/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.codeassist.select.translator;

import java.lang.reflect.Field;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionBindingResolver;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinkerHelper;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.DefaultNodeTranslator;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.JstToDLTKNodeTranslator;

public class JstAttributedTypeTranslator
extends DefaultNodeTranslator {
    @Override
    public IModelElement[] convert(IJstNode jstNode) {
        if (jstNode instanceof JstAttributedType) {
            IJstNode attributedBinding;
            JstAttributedType attributed = (JstAttributedType)jstNode;
            JstParseController ctrl = VjoParserToJstAndIType.getJstParseController();
            JstExpressionBindingResolver resolver = JstAttributedTypeTranslator.getResolver(ctrl);
            if (resolver != null && (attributedBinding = JstExpressionTypeLinkerHelper.look4ActualBinding((JstExpressionBindingResolver)resolver, (IJstType)attributed)) != null && attributedBinding != jstNode) {
                return JstToDLTKNodeTranslator.getNodeTranslator(attributedBinding).convert(attributedBinding);
            }
        }
        return null;
    }

    public static JstExpressionBindingResolver getResolver(JstParseController ctrl) {
        try {
            Field f = JstParseController.class.getDeclaredField("m_resolver");
            f.setAccessible(true);
            Object r = f.get(ctrl);
            if (r instanceof JstExpressionBindingResolver) {
                return (JstExpressionBindingResolver)r;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return null;
    }

    @Override
    public IJstNode lookupBinding(IJstNode jstNode) {
        if (jstNode instanceof JstAttributedType) {
            IJstNode attributedBinding;
            JstAttributedType attributed = (JstAttributedType)jstNode;
            JstParseController ctrl = VjoParserToJstAndIType.getJstParseController();
            JstExpressionBindingResolver resolver = JstAttributedTypeTranslator.getResolver(ctrl);
            if (resolver != null && (attributedBinding = JstExpressionTypeLinkerHelper.look4ActualBinding((JstExpressionBindingResolver)resolver, (IJstType)attributed)) != null && attributedBinding != jstNode) {
                if (attributedBinding instanceof JstProxyProperty) {
                    return ((JstProxyProperty)attributedBinding).getTargetProperty();
                }
                if (attributedBinding instanceof JstProxyMethod) {
                    return ((JstProxyMethod)attributedBinding).getTargetMethod();
                }
                if (attributedBinding instanceof JstProxyType) {
                    return ((JstProxyType)attributedBinding).getType();
                }
                return attributedBinding;
            }
        }
        return null;
    }

    @Override
    public IModelElement[] convert(IVjoSourceModule module, IJstNode jstNode) {
        IModelElement[] iModelElementArray;
        IJstType jstType = (IJstType)jstNode;
        IScriptProject sProject = null;
        if (module != null) {
            sProject = module.getScriptProject();
        }
        IType mElement = null;
        if (sProject != null && (!CodeassistUtils.isNativeType(jstType) || CodeassistUtils.isBinaryType(jstType))) {
            mElement = CodeassistUtils.findType((ScriptProject)sProject, jstType);
        }
        if (mElement == null) {
            mElement = this.convert(jstNode)[0];
        }
        if (mElement != null) {
            IModelElement[] iModelElementArray2 = new IModelElement[1];
            iModelElementArray = iModelElementArray2;
            iModelElementArray2[0] = mElement;
        } else {
            iModelElementArray = new IModelElement[]{};
        }
        return iModelElementArray;
    }

    private IType getType(IType rootType, String dltkTypeName) {
        try {
            if (rootType.getFullyQualifiedName(".").equals(dltkTypeName)) {
                return rootType;
            }
            IType[] types = rootType.getTypes();
            int i = 0;
            while (i < types.length) {
                IType type = this.getType(types[i], dltkTypeName);
                if (type != null) {
                    return type;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            VjetPlugin.error(e.getLocalizedMessage(), e);
        }
        return null;
    }
}

