/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.dbgp.IDbgpSession;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.VjoExternalSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.launching.VjoDBGPSourceStorage;

public class VjoDBGPSourceModule
extends VjoExternalSourceModule {
    private char[] m_bufferContent;

    public VjoDBGPSourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner, boolean readOnly, IStorage storage) {
        super(parent, name, owner, readOnly, storage);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VjoDBGPSourceModule)) {
            return false;
        }
        if (obj instanceof IStorage) {
            return obj.equals(this.getStorage());
        }
        return super.equals(obj);
    }

    public char[] getBufferContent() throws ModelException {
        if (this.m_bufferContent != null) {
            return this.m_bufferContent;
        }
        try {
            InputStream contents = this.getContents();
            char[] cache = new char[contents.available()];
            int i = 0;
            while (i < cache.length) {
                cache[i] = (char)contents.read();
                ++i;
            }
            this.m_bufferContent = cache;
            return this.m_bufferContent;
        }
        catch (Exception e) {
            VjetPlugin.error((String)e.getLocalizedMessage(), (Throwable)e);
            return new char[0];
        }
    }

    public char[] getFileName() {
        return CharOperation.NO_CHAR;
    }

    public IPath getPath() {
        return this.getStorage().getFullPath();
    }

    public void setDBGPSession(IDbgpSession session) {
        if (this.getStorage() instanceof VjoDBGPSourceStorage) {
            ((VjoDBGPSourceStorage)this.getStorage()).setSession(session);
        }
    }

    protected String getModuleType() {
        return "VJO Remote Source Module: ";
    }

    protected ISourceModule getOriginalSourceModule() {
        return new VjoDBGPSourceModule((ScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, this.isReadOnly(), this.getStorage());
    }

    protected IStatus validateSourceModule(IResource resource) {
        return IModelStatus.VERIFIED_OK;
    }
}

