/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class VjoRunnerInfo {
    private static final String BUNDLE_NAME = "org.eclipse.vjet.rt.wrapper";
    private static final String s_className = "org.eclipse.vjet.vjo.runner.VjoRunner";
    private static final String[] s_classPath = VjoRunnerInfo.buildClassPath();

    public static String[] getClassPath() {
        return s_classPath;
    }

    public static String getClassName() {
        return s_className;
    }

    private static String[] buildClassPath() {
        ArrayList<String> classPath = new ArrayList<String>();
        HashSet<String> visitedBundles = new HashSet<String>();
        Bundle bundle = Platform.getBundle((String)BUNDLE_NAME);
        visitedBundles.add(BUNDLE_NAME);
        VjoRunnerInfo.extractClassPath(bundle, classPath, visitedBundles);
        return classPath.toArray(new String[classPath.size()]);
    }

    private static void extractClassPath(Bundle bundle, List<String> classPath, Set<String> visitedBundles) {
        int iter;
        String baseLoc = VjoRunnerInfo.getLocation(bundle);
        Dictionary dic = bundle.getHeaders();
        if (baseLoc.endsWith("jar")) {
            classPath.add(baseLoc);
        } else {
            classPath.add(String.valueOf(baseLoc) + File.separatorChar + "bin");
            try {
                ManifestElement[] cp = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)dic.get("Bundle-ClassPath")));
                iter = 0;
                while (cp != null && iter < cp.length) {
                    classPath.add(String.valueOf(baseLoc) + File.separatorChar + cp[iter].getValue());
                    ++iter;
                }
            }
            catch (BundleException be) {
                be.printStackTrace();
            }
        }
        try {
            ManifestElement[] mfEls = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)dic.get("Require-Bundle")));
            iter = 0;
            while (mfEls != null && iter < mfEls.length) {
                Bundle bundle2;
                String bundleName = mfEls[iter].getValue();
                if (!visitedBundles.contains(bundleName) && (bundle2 = Platform.getBundle((String)bundleName)) != null) {
                    visitedBundles.add(bundleName);
                    VjoRunnerInfo.extractClassPath(bundle2, classPath, visitedBundles);
                }
                ++iter;
            }
        }
        catch (BundleException bundleException) {}
    }

    private static String getLocation(Bundle bundle) {
        String location = bundle.getLocation();
        int tempIndex = (location = location.substring(location.indexOf("@") + 1)).indexOf("reference:file:");
        if (tempIndex > -1) {
            location = location.substring(location.indexOf("file:") + 5);
        }
        if (!new File(location).isAbsolute()) {
            location = new File(Platform.getInstallLocation().getURL().getFile(), location).getAbsolutePath();
        }
        return location;
    }
}

