/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.dltk.mod.internal.corext.util.SearchUtils;

public class SearchResultGroup {
    private final IResource fResouce;
    private final List fSearchMatches;

    public SearchResultGroup(IResource res, SearchMatch[] matches) {
        Assert.isNotNull((Object)matches);
        this.fResouce = res;
        this.fSearchMatches = new ArrayList<SearchMatch>(Arrays.asList(matches));
    }

    public void add(SearchMatch match) {
        Assert.isNotNull((Object)match);
        this.fSearchMatches.add(match);
    }

    public IResource getResource() {
        return this.fResouce;
    }

    public SearchMatch[] getSearchResults() {
        return this.fSearchMatches.toArray(new SearchMatch[this.fSearchMatches.size()]);
    }

    public static IResource[] getResources(SearchResultGroup[] searchResultGroups) {
        HashSet<IResource> resourceSet = new HashSet<IResource>(searchResultGroups.length);
        int i = 0;
        while (i < searchResultGroups.length) {
            resourceSet.add(searchResultGroups[i].getResource());
            ++i;
        }
        return resourceSet.toArray(new IResource[resourceSet.size()]);
    }

    public ISourceModule getSourceModule() {
        if (this.getSearchResults() == null || this.getSearchResults().length == 0) {
            return null;
        }
        return SearchUtils.getSourceModule((SearchMatch)this.getSearchResults()[0]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.fResouce.getFullPath().toString());
        buf.append('\n');
        int i = 0;
        while (i < this.fSearchMatches.size()) {
            SearchMatch match = (SearchMatch)this.fSearchMatches.get(i);
            buf.append("  ").append(match.getOffset()).append(", ").append(match.getLength());
            buf.append(match.getAccuracy() == 0 ? "; acc" : "; inacc");
            if (match.isInsideDocComment()) {
                buf.append("; inDoc");
            }
            if (match.getElement() instanceof IModelElement) {
                buf.append("; in: ").append(((IModelElement)match.getElement()).getElementName());
            }
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }
}

