/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathAttribute;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.dltk.mod.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.mod.ui.wizards.NewElementWizard;
import org.eclipse.dltk.mod.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.mod.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.dltk.mod.ui.wizards.WorkingSetConfigurationBlock;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vjet.eclipse.internal.ui.preferences.VjetBuildpathBlock;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VJOProjectWizardFirstPage;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjetWizardMessages;
import org.eclipse.vjet.eclipse.ui.JavaScriptImages;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjetProjectCreationWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    private static final Path[] EMPTY_PATH = new Path[0];
    private static final String SOURCE_FOLDER_NAME = "src";
    private static final String ROOT_STRING = "/";
    private IConfigurationElement fConfigElement;
    private ProjectWizardFirstPage fFirstPage = new VJOProjectWizardFirstPage();
    private ProjectWizardSecondPage fSecondPage;

    public VjetProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(JavaScriptImages.DESC_WIZBAN_PROJECT_CREATION);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(VjetWizardMessages.ProjectCreationWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage.setTitle(VjetWizardMessages.ProjectCreationWizardFirstPage_title);
        this.fFirstPage.setDescription(VjetWizardMessages.ProjectCreationWizardFirstPage_description);
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new ProjectWizardSecondPage(this.fFirstPage){

            protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
                return new VjetBuildpathBlock((IRunnableContext)new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
            }

            protected IPreferenceStore getPreferenceStore() {
                return VjetUIPlugin.getDefault().getPreferenceStore();
            }

            protected String getScriptNature() {
                return "org.eclipse.vjet.core.nature";
            }

            public void createControl(Composite parent) {
                super.createControl(parent);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.new_vjetproject_wizard_page_context");
            }

            public void init(IScriptProject jproject, IBuildpathEntry[] defaultEntries, boolean defaultsOverrideExistingBuildpath) {
                ArrayList<IBuildpathEntry> entriesList = new ArrayList<IBuildpathEntry>();
                if (defaultEntries != null && defaultEntries.length > 0) {
                    IBuildpathEntry[] iBuildpathEntryArray = defaultEntries;
                    int n = defaultEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildpathEntry e = iBuildpathEntryArray[n2];
                        entriesList.add(e);
                        ++n2;
                    }
                }
                entriesList.add(DLTKCore.newContainerEntry((IPath)VjetProjectCreationWizard.this.getJsSDKPath()));
                entriesList.add(DLTKCore.newContainerEntry((IPath)VjetProjectCreationWizard.this.getBrowserSDKPath()));
                entriesList.add(DLTKCore.newContainerEntry((IPath)VjetProjectCreationWizard.this.getVjoPath()));
                IBuildpathEntry[] ary = new IBuildpathEntry[]{};
                super.init(jproject, entriesList.toArray(ary), defaultsOverrideExistingBuildpath);
            }
        };
        this.addPage((IWizardPage)this.fSecondPage);
    }

    private IPath getSdkPath() {
        Path path = new Path("org.eclipse.vjet.eclipse.core.SDK_CONTAINER");
        path = path.append("DEFUALT_SDK");
        return path;
    }

    private IPath getJsSDKPath() {
        Path path = new Path("org.eclipse.vjet.eclipse.core.JSNATIVE_CONTAINER");
        path = path.append("JS Native Types");
        return path;
    }

    private IPath getBrowserSDKPath() {
        Path path = new Path("org.eclipse.vjet.eclipse.core.BROWSER_CONTAINER");
        path = path.append("Browser SDK");
        return path;
    }

    private IPath getVjoPath() {
        Path path = new Path("org.eclipse.vjet.eclipse.core.VJO_CONTAINER");
        path = path.append("VJO LIB");
        return path;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.fFirstPage.getProjectHandle());
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            ScriptProject project = (ScriptProject)this.fSecondPage.getScriptProject();
            IWorkingSet[] workingSets = this.fFirstPage.getWorkingSets();
            WorkingSetConfigurationBlock.addToWorkingSets((IAdaptable)project, (IWorkingSet[])workingSets);
            this.selectAndReveal((IResource)project.getProject());
        }
        return res;
    }

    private void addDefaultSourceFolder(ScriptProject project) {
        Workspace workspace = (Workspace)project.getProject().getWorkspace();
        Path path = new Path(ROOT_STRING);
        path = path.append(project.getElementName());
        path = path.append(SOURCE_FOLDER_NAME);
        IFolder folder = (IFolder)workspace.newResource((IPath)path, 2);
        try {
            folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            IBuildpathEntry[] newEntries = this.getBuildpathEntries((IScriptProject)project, (IPath)path);
            project.saveBuildpath(newEntries);
        }
        catch (CoreException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private IBuildpathEntry[] getBuildpathEntries(IScriptProject project, IPath path) throws ModelException {
        IBuildpathEntry[] entries = project.getRawBuildpath();
        BuildpathEntry[] newEntries = new BuildpathEntry[entries.length];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        newEntries[0] = new BuildpathEntry(1, 3, path, false, (IPath[])EMPTY_PATH, (IPath[])EMPTY_PATH, null, false, new IBuildpathAttribute[0], false);
        return newEntries;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }
}

