/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.text.completion.CompletionProposalComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.JavaScriptCompletionProposal;

public class VjoPackageCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private IProjectFragment fPackageFragmentRoot;
    private CompletionProposalComparator fComparator = new CompletionProposalComparator();
    private ILabelProvider fLabelProvider;
    private static final String trigger = ".";
    private char[] fProposalAutoActivationSet;

    public VjoPackageCompletionProcessor() {
        this((ILabelProvider)new JavaElementLabelProvider(256));
    }

    public VjoPackageCompletionProcessor(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        this.fProposalAutoActivationSet = trigger.toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        if (this.fPackageFragmentRoot == null) {
            return null;
        }
        String input = contentAssistSubjectControl.getDocument().get();
        ICompletionProposal[] proposals = this.createPackagesProposals(documentOffset, input);
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public void setPackageFragmentRoot(IProjectFragment packageFragmentRoot) {
        this.fPackageFragmentRoot = packageFragmentRoot;
    }

    private ICompletionProposal[] createPackagesProposals(int documentOffset, String input) {
        ArrayList<JavaScriptCompletionProposal> proposals = new ArrayList<JavaScriptCompletionProposal>();
        String prefix = input.substring(0, documentOffset);
        try {
            IModelElement[] packageFragments = this.fPackageFragmentRoot.getChildren();
            int i = 0;
            while (i < packageFragments.length) {
                IScriptFolder pack = (IScriptFolder)packageFragments[i];
                String packName = pack.getElementName();
                if (packName.length() != 0 && packName.startsWith(prefix)) {
                    Image image = this.fLabelProvider.getImage((Object)pack);
                    JavaScriptCompletionProposal proposal = new JavaScriptCompletionProposal(packName, 0, input.length(), image, packName, 0);
                    proposals.add(proposal);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

