/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.text.completion;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class CompletionUtils {
    public static final char TAB = '\t';
    public static final char NEWLINE_1 = '\r';
    public static final char NEWLINE_2 = '\n';

    public static String calculateIndent(IDocument document, int offset) {
        block4: {
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                String indent = document.get(region.getOffset(), offset - region.getOffset());
                int i = 0;
                while (i < indent.length() && CompletionUtils.isSpaceOrTab(indent.charAt(i))) {
                    ++i;
                }
                if (i > 0) {
                    return indent.substring(0, i);
                }
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return "";
    }

    private static boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }
}

