/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DInput;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.HtmlForm;
import org.eclipse.vjet.dsf.jsnative.HtmlInput;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class AHtmlInput
extends AHtmlElement
implements HtmlInput,
IDFormControl {
    private static final long serialVersionUID = 1L;
    private static final String SELECT_JS_METHOD = "select()";
    private static final String FOCUS_JS_METHOD = "focus()";

    protected AHtmlInput(AHtmlDocument doc, DInput input) {
        super(doc, (BaseHtmlElement)input);
        this.populateScriptable(AHtmlInput.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public void blur() {
        this.dispatchEvent(EventType.BLUR.getName(), this);
    }

    public void click() {
        this.dispatchEvent(EventType.CLICK.getName(), this);
    }

    @Override
    public void focus() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod((BaseHtmlElement)this.getDInput(), FOCUS_JS_METHOD);
        }
    }

    public String getAccept() {
        return this.getDInput().getHtmlAccept();
    }

    public String getAccessKey() {
        return this.getDInput().getHtmlAccessKey();
    }

    public String getAlign() {
        return this.getDInput().getHtmlAlign();
    }

    public String getAlt() {
        return this.getDInput().getHtmlAlt();
    }

    public boolean getChecked() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.checked, this.getHtmlAttribute(EHtmlAttr.checked));
    }

    public boolean getDefaultChecked() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.defaultchecked, this.getHtmlAttribute(EHtmlAttr.defaultchecked));
    }

    public String getDefaultValue() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            return browserBinding.getDomAttributeValue((BaseHtmlElement)this.getDInput(), EHtmlAttr.defaultValue);
        }
        return null;
    }

    public boolean getDisabled() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.disabled, this.getHtmlAttribute(EHtmlAttr.disabled));
    }

    public HtmlForm getForm() {
        return super.getFormInternal();
    }

    public int getMaxLength() {
        return this.getDInput().getHtmlMaxLength();
    }

    public String getName() {
        return this.getDInput().getHtmlName();
    }

    public boolean getReadOnly() {
        Boolean out = AHtmlHelper.booleanValueOf(EHtmlAttr.readOnly, this.getHtmlAttribute(EHtmlAttr.readOnly));
        if (!out.booleanValue()) {
            out = AHtmlHelper.booleanValueOf(EHtmlAttr.readonly, this.getHtmlAttribute(EHtmlAttr.readonly));
        }
        return out;
    }

    public int getSize() {
        int size = 0;
        try {
            size = Integer.valueOf(this.getDInput().getHtmlSize());
        }
        catch (NumberFormatException numberFormatException) {}
        return size;
    }

    public String getSrc() {
        return this.getDInput().getHtmlSrc();
    }

    public int getTabIndex() {
        return this.getDInput().getHtmlTabIndex();
    }

    public String getType() {
        return this.getDInput().getHtmlType();
    }

    public String getUseMap() {
        return this.getDInput().getHtmlUseMap();
    }

    public String getValue() {
        return this.getDInput().getHtmlValue();
    }

    public void select() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod((BaseHtmlElement)this.getDInput(), SELECT_JS_METHOD);
        }
    }

    public void setAccept(String accept) {
        this.getDInput().setHtmlAccept(accept);
        this.onAttrChange(EHtmlAttr.accept, accept);
    }

    public void setAccessKey(String accessKey) {
        this.getDInput().setHtmlAccessKey(accessKey);
        this.onAttrChange(EHtmlAttr.accesskey, accessKey);
    }

    public void setAlign(String align) {
        this.getDInput().setHtmlAlign(align);
        this.onAttrChange(EHtmlAttr.align, align);
    }

    public void setAlt(String alt) {
        this.getDInput().setHtmlAlt(alt);
        this.onAttrChange(EHtmlAttr.alt, alt);
    }

    public void setChecked(boolean checked) {
        this.setHtmlAttribute(EHtmlAttr.checked, checked);
        this.onAttrChange(EHtmlAttr.checked, checked);
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.setHtmlAttribute(EHtmlAttr.defaultchecked, defaultChecked);
        this.onAttrChange(EHtmlAttr.defaultchecked, defaultChecked);
    }

    public void setDefaultValue(String defaultValue) {
        this.getDInput().setHtmlDefaultValue(defaultValue);
        this.onAttrChange(EHtmlAttr.defaultvalue, defaultValue);
    }

    public void setDisabled(boolean disabled) {
        this.setHtmlAttribute(EHtmlAttr.disabled, disabled);
        this.onAttrChange(EHtmlAttr.disabled, disabled);
    }

    public void setMaxLength(int maxLength) {
        this.getDInput().setHtmlMaxLength(maxLength);
        this.onAttrChange(EHtmlAttr.maxlength, String.valueOf(maxLength));
    }

    public void setName(String name) {
        this.getDInput().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    public void setReadOnly(boolean readOnly) {
        this.setHtmlAttribute(EHtmlAttr.readOnly, readOnly);
        this.onAttrChange(EHtmlAttr.readOnly, readOnly);
    }

    public void setSize(int size) {
        this.getDInput().setHtmlSize(size);
        this.onAttrChange(EHtmlAttr.size, String.valueOf(size));
    }

    public void setSrc(String src) {
        this.getDInput().setHtmlSrc(src);
        this.onAttrChange(EHtmlAttr.src, src);
    }

    public void setTabIndex(int tabIndex) {
        this.getDInput().setHtmlTabIndex(tabIndex);
        this.onAttrChange(EHtmlAttr.tabindex, String.valueOf(tabIndex));
    }

    public void setType(String type) {
        this.getDInput().setHtmlType(type);
        this.onAttrChange(EHtmlAttr.type, String.valueOf(type));
    }

    public void setUseMap(String useMap) {
        this.getDInput().setHtmlUseMap(useMap);
        this.onAttrChange(EHtmlAttr.usemap, useMap);
    }

    public void setValue(String value) {
        this.getDInput().setHtmlValue(value);
        this.onValueChange(value);
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public Object getOnchange() {
        return this.getOnChange();
    }

    public void setOnchange(Object functionRef) {
        this.setOnChange(functionRef);
    }

    public Object getOnselect() {
        return this.getOnSelect();
    }

    public void setOnselect(Object functionRef) {
        this.setOnSelect(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    private DInput getDInput() {
        return (DInput)this.getDNode();
    }
}

