/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.active.util.WindowTask;

public class WindowTaskQueue {
    private List<WindowTask> m_readyQueue = new ArrayList<WindowTask>();
    private Map<Integer, WindowTask> m_taskMap = new HashMap<Integer, WindowTask>();
    private int m_idIndex = 0;

    public synchronized WindowTask get(int id) {
        return this.m_taskMap.get(id);
    }

    public synchronized WindowTask next() {
        if (this.m_readyQueue.isEmpty()) {
            return null;
        }
        return this.m_readyQueue.remove(0);
    }

    public synchronized void ready(WindowTask task) {
        if (!this.isCanceled(task)) {
            this.m_readyQueue.add(task);
            this.notifyAll();
        }
    }

    public synchronized void add(WindowTask task) {
        this.m_taskMap.put(task.getId(), task);
    }

    public synchronized void cancel(int id) {
        WindowTask task = this.m_taskMap.remove(id);
        if (task != null) {
            this.m_readyQueue.remove(task);
        }
        this.notifyAll();
    }

    public synchronized boolean isCanceled(WindowTask task) {
        return !this.m_taskMap.containsKey(task.getId());
    }

    public synchronized int createId() {
        ++this.m_idIndex;
        return this.m_idIndex;
    }

    public synchronized boolean isReadyQueueEmpty() {
        return this.m_readyQueue.isEmpty();
    }

    public synchronized void waitForEmpty(long timeoutInMs) {
        if (timeoutInMs < 0L) {
            timeoutInMs = 0L;
        }
        long start = System.currentTimeMillis();
        while (!this.m_taskMap.isEmpty()) {
            try {
                this.wait(timeoutInMs);
            }
            catch (InterruptedException interruptedException) {}
            if (timeoutInMs > 0L && System.currentTimeMillis() - start >= timeoutInMs) break;
        }
        if (timeoutInMs > 0L && !this.m_taskMap.isEmpty()) {
            this.m_taskMap.clear();
            this.m_readyQueue.clear();
            throw new RuntimeException("There are still some timer events in system after specified timeout: " + timeoutInMs);
        }
    }

    public synchronized void cancelAll() {
        this.m_taskMap.clear();
        this.m_readyQueue.clear();
        this.notifyAll();
    }
}

