/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dap.util.DapDomHelper;
import org.eclipse.vjet.dsf.html.HtmlWriterHelper;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseCoreHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DHead;
import org.eclipse.vjet.dsf.html.dom.DHtml;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.ECssAttr;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public final class DapDomChangeListener
implements IDomChangeListener {
    private static final String EMPTY = "";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SET_VALUE = "{0}.value=\"{1}\";";
    private static final String UPDATE_ELEMENT = "DLC_updateElement({0},{1});";
    private static final String APPEND_CHILD = "DLC_appendHtml({0},{1},{2});";
    private static final String SET_ATTRIBUTE = "{0}.{1}={2};";
    private static final String SET_STYLE = "{0}.style.{1}={2};";
    private static final String INSERT_NEXT = "DLC_insertHtml({0},{1},{2});";
    private static final String REMOVE_ELEMENT = "DLC_removeElement({0});";
    private static final String NEW_OPTION = "{0}.options[{1}]=new Option(\"{2}\",\"{3}\");";
    private static final String SET_WIDTH = "DLC_setWidth({0},\"{1}\");";
    private static final String SET_HEIGHT = "DLC_setHeight({0},\"{1}\");";
    private static final String SET_CLASS_NAME = "DLC_setClassName({0},\"{1}\");";
    private static final String SET_CLASS_NAME_BY_ID = "DLC_setClassName(\"{0}\",\"{1}\");";
    private final IDLCDispatcher m_dlcDispatcher;

    public DapDomChangeListener(IDLCDispatcher dlcDispatcher) {
        this.m_dlcDispatcher = dlcDispatcher;
    }

    public void onValueChange(BaseHtmlElement elem, String value) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return;
        }
        this.m_dlcDispatcher.send(MessageFormat.format(SET_VALUE, path, value != null ? value : EMPTY));
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, boolean value) {
        this.onAttrChange(elem, attr, String.valueOf(value), true);
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, int value) {
        this.onAttrChange(elem, attr, String.valueOf(value), true);
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, double value) {
        this.onAttrChange(elem, attr, String.valueOf(value), true);
    }

    public void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, String value) {
        this.onAttrChange(elem, attr, value, false);
    }

    private void onAttrChange(BaseHtmlElement elem, EHtmlAttr attr, String value, boolean isBoolean) {
        String strValue;
        String string = strValue = value != null ? value : EMPTY;
        if (!isBoolean) {
            strValue = DOUBLE_QUOTE + value + DOUBLE_QUOTE;
        }
        String path = null;
        path = attr.equals((Object)EHtmlAttr.id) ? DapDomHelper.getPath((Node)elem, false) : DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return;
        }
        this.m_dlcDispatcher.send(MessageFormat.format(SET_ATTRIBUTE, path, attr.name(), strValue));
    }

    public void onStyleChange(BaseHtmlElement elem, String name, String value) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return;
        }
        this.m_dlcDispatcher.send(MessageFormat.format(SET_STYLE, path, name, value));
    }

    public void onElementChange(BaseHtmlElement elem) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return;
        }
        String html = this.getHtml((Node)elem);
        this.m_dlcDispatcher.send(MessageFormat.format(UPDATE_ELEMENT, path, html));
    }

    public void onAppendChild(Node child) {
        BaseHtmlElement parent = (BaseHtmlElement)child.getParentNode();
        if (parent instanceof DHtml && !(child instanceof DHead) && !(child instanceof DBody)) {
            return;
        }
        String parentRef = DapDomHelper.getPath((Node)parent);
        if (parentRef == null) {
            return;
        }
        if (child instanceof DOption) {
            DOption op = (DOption)child;
            this.m_dlcDispatcher.send(MessageFormat.format(NEW_OPTION, parentRef, DapDomChangeListener.getIndex(op), op.getHtmlText(), op.getHtmlValue()));
            return;
        }
        String html = this.getHtml(child);
        this.m_dlcDispatcher.send(MessageFormat.format(APPEND_CHILD, parentRef, html, DapDomHelper.getIndex((Node)parent, child)));
        this.syncPaddingInfo(child);
    }

    public void onInsert(Node newChild, Node nodeRef, boolean insertBefore) {
        if (nodeRef.getParentNode() instanceof DHtml && !(newChild instanceof DHead) && !(newChild instanceof DBody)) {
            return;
        }
        String siblingRef = DapDomHelper.getPath(nodeRef);
        if (siblingRef == null) {
            return;
        }
        String html = this.getHtml(newChild);
        this.m_dlcDispatcher.send(MessageFormat.format(INSERT_NEXT, siblingRef, html, insertBefore));
    }

    public void onRemove(Node node) {
        if (node.getParentNode() instanceof DHtml && !(node instanceof DHead) && !(node instanceof DBody)) {
            return;
        }
        String nodeRef = DapDomHelper.getPath(node);
        if (nodeRef == null) {
            return;
        }
        this.m_dlcDispatcher.send(MessageFormat.format(REMOVE_ELEMENT, nodeRef));
    }

    public void onWidthChange(BaseHtmlElement node, int width) {
        String path = DapDomHelper.getPath((Node)node);
        this.m_dlcDispatcher.send(path == null ? null : MessageFormat.format(SET_WIDTH, path, width));
    }

    public void onHeightChange(BaseHtmlElement node, int height) {
        String path = DapDomHelper.getPath((Node)node);
        this.m_dlcDispatcher.send(path == null ? null : MessageFormat.format(SET_HEIGHT, path, height));
    }

    public void onClassNameChange(BaseHtmlElement elem, String className) {
        String id;
        if (elem instanceof BaseAttrsHtmlElement && (id = ((BaseAttrsHtmlElement)elem).getHtmlId()) != null) {
            this.m_dlcDispatcher.send(MessageFormat.format(SET_CLASS_NAME_BY_ID, id, className));
            return;
        }
        String path = DapDomHelper.getPath((Node)elem);
        this.m_dlcDispatcher.send(path == null ? null : MessageFormat.format(SET_CLASS_NAME, path, className));
    }

    public String getAttributeValue(BaseHtmlElement elem, EHtmlAttr attr) {
        return this.m_dlcDispatcher.request(String.valueOf(DapDomHelper.getPath((Node)elem)) + "." + attr.getAttributeName(), 0);
    }

    private String getHtml(Node node) {
        StringWriter writer = new StringWriter(1000);
        HtmlWriterHelper.write((Node)node, (Writer)writer, (IIndenter)IIndenter.COMPACT);
        String html = writer.toString();
        int singleIdx = html.indexOf(SINGLE_QUOTE);
        int doubleIdx = html.indexOf(DOUBLE_QUOTE);
        html = doubleIdx > singleIdx ? SINGLE_QUOTE + html.replaceAll(SINGLE_QUOTE, SINGLE_QUOTE) + SINGLE_QUOTE : DOUBLE_QUOTE + html.replaceAll(DOUBLE_QUOTE, SINGLE_QUOTE) + DOUBLE_QUOTE;
        return html;
    }

    private static int getIndex(DOption op) {
        DSelect select = null;
        Node parent = op.getParentNode();
        while (parent != null) {
            if (!(parent instanceof DSelect)) continue;
            select = (DSelect)parent;
            break;
        }
        if (select != null) {
            int i = 0;
            while (i < select.getLength()) {
                if (select.item(i) == op) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    private void syncPaddingInfo(Node child) {
        CSSStyleDeclaration style;
        String ref = DapDomHelper.getPath(child);
        if (ref == null) {
            return;
        }
        if (child instanceof BaseCoreHtmlElement && (style = ((BaseCoreHtmlElement)child).getHtmlStyle()) != null) {
            this.syncStyleProp(ref, ECssAttr.padding.toString(), style.getPropertyCSSValue(ECssAttr.padding.toString()));
            this.syncStyleProp(ref, ECssAttr.paddingLeft.toString(), style.getPropertyCSSValue(ECssAttr.paddingLeft.toString()));
            this.syncStyleProp(ref, ECssAttr.paddingRight.toString(), style.getPropertyCSSValue(ECssAttr.paddingRight.toString()));
            this.syncStyleProp(ref, ECssAttr.paddingTop.toString(), style.getPropertyCSSValue(ECssAttr.paddingTop.toString()));
            this.syncStyleProp(ref, ECssAttr.paddingBottom.toString(), style.getPropertyCSSValue(ECssAttr.paddingBottom.toString()));
        }
    }

    private void syncStyleProp(String ref, String name, CSSValue val) {
        if (!EMPTY.equals(ref) && !EMPTY.equals(name) && val != null) {
            StringBuilder code = new StringBuilder(ref);
            code.append(".style.");
            code.append(name);
            code.append("=\"");
            code.append(val);
            code.append(DOUBLE_QUOTE);
            this.m_dlcDispatcher.send(code.toString());
        }
    }
}

