/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.lang.reflect.Method;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.html.dom.BaseCoreHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.js.JSAction;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSDocument;
import org.eclipse.vjet.dsf.html.js.JSElementArray;
import org.eclipse.vjet.dsf.html.js.JSListener;
import org.eclipse.vjet.dsf.html.js.JSStyle;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.FunctionObject;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.w3c.dom.Node;

public class JSElement
extends ScriptableObject {
    protected JSWindow window = null;
    protected Context cx = null;
    protected Scriptable scope = null;
    protected BaseHtmlElement element = null;
    JSStyle style = null;
    JSElementArray children = null;
    JSElement parentElement = null;
    Object onclick = null;

    protected JSElement() {
    }

    public JSElement(JSWindow window, BaseHtmlElement element) {
        window.addWrapper((Node)element, this);
        this.window = window;
        this.cx = window.getContext();
        this.scope = window.getScope();
        this.element = element;
        String[] functions = new String[]{"valueOf", "insertAdjacentHTML"};
        this.defineProperty("style", JSElement.class, 2);
        this.defineProperty("children", JSElement.class, 2);
        this.defineProperty("window", JSElement.class, 2);
        this.defineProperty("document", JSElement.class, 2);
        this.defineProperty("parentElement", JSElement.class, 2);
        this.defineProperty("onclick", JSElement.class, 2);
        this.defineFunctionProperties(functions, JSElement.class, 2);
    }

    public String getClassName() {
        return "JSElementWraper";
    }

    public JSWindow getWindow() {
        return this.window;
    }

    public JSDocument getDocument() {
        return this.window.getJSDocument();
    }

    public Object get(String name, Scriptable start) {
        Object obj = super.get(name, start);
        if (obj == NOT_FOUND) {
            if (name.equals("id")) {
                String id = this.element.getAttribute("id");
                if (id.length() > 0) {
                    obj = id;
                }
            } else {
                if (name.equals("isHomePage")) {
                    return JSElement.getIsHomePage(start);
                }
                if (name.equals("setHomePage")) {
                    return JSElement.getSetHomePage(start);
                }
                obj = this.window.get(name, start);
            }
        }
        return obj;
    }

    public JSStyle getStyle() {
        if (this.style == null) {
            this.style = new JSStyle(this.element, this.window);
        }
        return this.style;
    }

    public JSElementArray getChildren() {
        if (this.children == null) {
            this.children = new JSElementArray(this.window);
            Node child = this.element.getFirstChild();
            while (child != null) {
                if (child instanceof BaseHtmlElement) {
                    this.children.add((Object)this.window.getWrapper(child, true));
                }
                child = child.getNextSibling();
            }
        }
        return this.children;
    }

    public void appendChild(Node child) {
        this.element.appendChild(child);
        this.getChildren().add((Object)new JSElement(this.window, (BaseHtmlElement)child));
    }

    public void removeChild(Node child) {
        this.element.removeChild(child);
    }

    public void insertNext(JSElement node) {
        this.getParentElement().getChildren().insertAfter((Object)node, (Object)this);
        this.element.getParentNode().insertBefore(node.getDNode(), this.element.getNextSibling());
        this.getListener().onInsert((Node)this.element, node.getDNode(), false);
    }

    public void removeSibling(JSElement node) {
        this.element.getParentNode().removeChild(node.getDNode());
        this.getParentElement().getChildren().remove((Object)node);
    }

    public void removeChild(JSElement child) {
        this.element.removeChild(child.getDNode());
    }

    public JSElement getParentElement() {
        if (this.parentElement == null) {
            Node parent = this.element.getParentNode();
            this.parentElement = this.window.getWrapper(parent, true);
        }
        return this.parentElement;
    }

    public Scriptable getOnclick() {
        return Context.toObject((Object)this.onclick, (Scriptable)this.scope);
    }

    public void setOnclick(Object onclick) {
        this.onclick = onclick;
        if (onclick instanceof Function) {
            String href;
            JSAction action;
            this.window.setState(JSWindow.IN_ANALYSIS);
            JSListener listener = this.window.getJSListener();
            listener.reset();
            try {
                ((Function)onclick).call(this.cx, this.scope, (Scriptable)this, new Object[0]);
            }
            catch (Exception e) {
                JSDebug.println(e.getMessage());
            }
            if (listener.getLength() == 1 && (action = listener.get(0)) != null && (action.m_actionType == 5 || action.m_actionType == 4) && (href = action.m_value).length() > 0) {
                this.element.setAttribute("onclick", "location.href=\"" + href + "\"");
            }
            listener.reset();
            this.window.setState(JSWindow.IN_LOADING);
        }
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public Object jsFunction_valueOf(String type) {
        return this.valueOf(type);
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            if (this.element != null) {
                String id = this.element.getAttribute("id");
                return id;
            }
            return "";
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }

    public void insertAdjacentHTML(String name, String value) {
        this.window.getJSDocument().jsFunction_write(value);
    }

    private static FunctionObject getIsHomePage(Scriptable scope) {
        Method method = null;
        try {
            method = JSElement.class.getDeclaredMethod("isHomePage", String.class);
        }
        catch (Exception exception) {}
        return new FunctionObject("isHomePage", method, scope){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return JSElement.isHomePage((String)args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    private static FunctionObject getSetHomePage(Scriptable scope) {
        Method method = null;
        try {
            method = JSElement.class.getDeclaredMethod("setHomePage", String.class);
        }
        catch (Exception exception) {}
        return new FunctionObject("setHomePage", method, scope){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                JSElement.setHomePage((String)args[0]);
                return null;
            }
        };
    }

    static boolean isHomePage(String url) {
        JSDebug.println("isHomePage: " + url);
        return false;
    }

    static void setHomePage(String url) {
        JSDebug.println("setHomePage: " + url);
    }

    public String getId() {
        if (this.element instanceof BaseCoreHtmlElement) {
            return ((BaseCoreHtmlElement)this.element).getHtmlId();
        }
        return null;
    }

    protected IDomChangeListener getListener() {
        return this.window.getListener();
    }

    Node getDNode() {
        return this.element;
    }
}

