/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public class URLUtil {
    public static String getAbsoluteURL(String url, String base_url) {
        String r;
        if (url == null) {
            return null;
        }
        int size = url.length();
        StringBuffer buf = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            char c = url.charAt(i);
            switch (c) {
                case '\n': {
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        url = buf.toString();
        if (URLUtil.isFullURL(url)) {
            r = url;
        } else if (URLUtil.isAbsoluteURL(url)) {
            if (base_url == null || !URLUtil.isFullURL(base_url)) {
                r = url;
            } else {
                r = URLUtil.getHostURL(base_url);
                r = URLUtil.appendPath(r, url);
            }
        } else if (URLUtil.isAbsoluteURLWithHost(url)) {
            if (base_url == null || !URLUtil.isFullURL(base_url)) {
                r = url;
            } else {
                String p = URLUtil.getURLProtocol(base_url);
                r = String.valueOf(p) + ":" + url;
            }
        } else if (URLUtil.isRelativeURL(url)) {
            if (base_url == null) {
                throw new IllegalArgumentException("Base url cannot be null for url: " + url);
            }
            r = URLUtil.appendPath(base_url, url);
        } else {
            throw new IllegalArgumentException("Invalid url: " + url);
        }
        return r;
    }

    public static String appendPath(String url, String sub) {
        if (url == null || sub == null) {
            if (url == null) {
                return sub;
            }
            return url;
        }
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        if (sub.startsWith("/")) {
            sub = sub.substring(1);
        }
        return String.valueOf(url) + sub;
    }

    public static String getSubPath(String root, String path) {
        String r = root;
        String p = path;
        if (!r.endsWith("/")) {
            r = String.valueOf(r) + "/";
        }
        if (!p.endsWith("/")) {
            p = String.valueOf(p) + "/";
        }
        if (!r.startsWith("/")) {
            r = "/" + r + "/";
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.startsWith(r)) {
            throw new DsfRuntimeException("url path \"" + path + "\" is under root \"" + root + "\"");
        }
        String sub = p.substring(r.length());
        if (!path.endsWith("/")) {
            sub = sub.substring(0, p.length() - 1);
        }
        return sub;
    }

    public static boolean isWellFormedURL(String url_str) {
        if (url_str == null) {
            return false;
        }
        try {
            new URL(url_str);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static URL createURL(String url_str) {
        try {
            URL url = new URL(url_str);
            return url;
        }
        catch (MalformedURLException e) {
            throw new DsfRuntimeException("Invalid URL string", (Throwable)e);
        }
    }

    public static String URLEncode(String str) {
        return URLUtil.URLEncode(str, null);
    }

    public static String URLEncode(String str, String encoding) {
        if (str == null) {
            return null;
        }
        if (encoding != null) {
            StringBuffer sb = new StringBuffer();
            try {
                byte[] bytes = str.getBytes(encoding);
                int length = bytes.length;
                int i = 0;
                while (i < length) {
                    char c = (char)bytes[i];
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.') {
                        sb.append(c);
                    } else if (c == ' ') {
                        sb.append('+');
                    } else {
                        String encodedStr = Integer.toHexString(c);
                        int size = encodedStr.length();
                        if (size >= 2) {
                            encodedStr = encodedStr.substring(size - 2, size);
                            sb.append("%").append(encodedStr);
                        } else {
                            sb.append(c);
                        }
                    }
                    ++i;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            return sb.toString();
        }
        return URLEncoder.encode(str);
    }

    public static String URLDecode(String str) throws Exception {
        if (str == null) {
            return null;
        }
        return URLDecoder.decode(str);
    }

    public static String URLDecode(String s, String encoding) {
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    i += 2;
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        String result = sb.toString();
        try {
            result = new String(result.getBytes("8859_1"), encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return result;
    }

    public static String getQuery(String url_str) {
        if (url_str == null) {
            return "";
        }
        int i = url_str.indexOf(63);
        if (i < 0) {
            return "";
        }
        return url_str.substring(i + 1);
    }

    public static String getURLWithoutQuery(String url_str) {
        if (url_str == null) {
            return "";
        }
        int i = url_str.indexOf(63);
        if (i < 0) {
            return url_str;
        }
        return url_str.substring(0, i);
    }

    public static String getHostURL(String url_str) {
        if (url_str == null) {
            return null;
        }
        String s = url_str;
        int i = s.indexOf("://");
        i = i > -1 ? (i += 3) : 0;
        i = s.indexOf(47, i);
        if (i > -1) {
            s = s.substring(0, i);
        }
        return s;
    }

    public static String getURLHost(String url_str) {
        if (url_str == null) {
            return null;
        }
        String s = url_str;
        int i = s.indexOf("://");
        if (i > -1) {
            s = s.substring(i + 3);
        }
        if ((i = s.indexOf(47)) > -1) {
            s = s.substring(0, i);
        }
        return s;
    }

    public static String getURLProtocol(String url_str) {
        if (url_str == null) {
            return null;
        }
        String s = url_str;
        int i = s.indexOf("://");
        if (i > -1) {
            s = s.substring(0, i);
            return s;
        }
        return null;
    }

    public static String getURLPath(String url_str) {
        if (url_str == null) {
            return null;
        }
        String s = url_str;
        int i = s.lastIndexOf(59);
        if (i > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.lastIndexOf(35)) > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("://")) > -1) {
            s = s.substring(3 + i);
        }
        if ((i = s.indexOf(47)) <= -1) {
            return "/";
        }
        s = s.substring(i);
        i = s.indexOf(63);
        if (i > -1) {
            s = s.substring(0, i);
        }
        return s;
    }

    public static String getBaseURL(URLConnection conn) {
        String url = conn.getURL().toExternalForm();
        return URLUtil.getBaseURL(url);
    }

    public static String getBaseURL(String url_str) {
        int j;
        if (url_str == null) {
            return null;
        }
        String s = url_str;
        int i = s.lastIndexOf(59);
        if (i > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.lastIndexOf(35)) > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.lastIndexOf(63)) > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("://")) > 0) {
            i += 4;
        }
        if ((j = s.lastIndexOf(47)) > i) {
            s = s.substring(0, j);
        }
        if (!s.endsWith("/")) {
            s = String.valueOf(s) + "/";
        }
        return s;
    }

    public static String getRootURL(String url_str) {
        if (!URLUtil.hasProtocol(url_str)) {
            throw new IllegalArgumentException("URL " + url_str + " does not has protocol");
        }
        int i = url_str.indexOf("://");
        if (i < 0) {
            throw new IllegalArgumentException("URL " + url_str + " is not valid");
        }
        int j = url_str.indexOf("/", i + 3);
        String r = j < 0 ? url_str : url_str.substring(0, j + 1);
        return r;
    }

    public static boolean isFullURL(String str) {
        return URLUtil.hasProtocol(str);
    }

    public static boolean isAbsoluteURL(String str) {
        return str.startsWith("/") && !str.startsWith("//");
    }

    public static boolean isAbsoluteURLWithHost(String str) {
        return str.startsWith("//");
    }

    public static boolean isRelativeURL(String str) {
        return !str.startsWith("/") && !URLUtil.hasProtocol(str);
    }

    public static boolean hasProtocol(String str) {
        return str != null && (str.startsWith("https://") || str.startsWith("http://") || str.startsWith("file://"));
    }

    public static InputStream getInputStream(HttpURLConnection conn) {
        return URLUtil.getInputStream(conn, false);
    }

    /*
     * Unable to fully structure code
     */
    public static InputStream getInputStream(HttpURLConnection conn, boolean includeError) {
        stream = null;
        try {
            block9: {
                code = 200;
                try {
                    code = conn.getResponseCode();
                    break block9;
                }
                catch (IOException v0) {
                    index = 0;
                    errMessage = null;
                    ** while ((errMessage = conn.getHeaderField((int)index)) != null)
                }
lbl-1000:
                // 1 sources

                {
                    if (errMessage.indexOf(" 401 ") != -1) {
                        code = 401;
                        break;
                    }
                    ++index;
                    continue;
                }
            }
            if (code == 401) {
                stream = new ByteArrayInputStream(URLUtil.getLoginForm(conn.getURL().toString()).getBytes());
            } else {
                stream = conn.getInputStream();
                if (stream == null && includeError) {
                    stream = conn.getErrorStream();
                }
            }
        }
        catch (IOException v1) {}
        return stream;
    }

    static String getLoginForm(String urlStr) {
        String loginForm = "<H>Logon to : " + URLUtil.getURLHost(urlStr) + "</H>" + "<FORM name=login method=AUTHORIZATION action=" + urlStr + ">" + "<TABLE><TR>" + "<TD>User Name : </TD>" + "<TD><INPUT size=10 name=username></TD>" + "</TR><TR>" + "<TD>Password : </TD>" + "<TD><INPUT type=password size=10 name=password></TD>" + "</TR></TABLE>" + "<INPUT type=submit value=Submit>" + "</FORM>";
        return loginForm;
    }

    public static boolean isScript(String href) {
        if (href.length() == 0) {
            return false;
        }
        char h0 = href.charAt(0);
        return (h0 == 'j' || h0 == 'J' || h0 == 'v' || h0 == 'V') && href.indexOf("cript:") > 0;
    }
}

