/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;

public class JsResourceCache {
    private static final CacheEntry EMPTY_ENRTY = new CacheEntry();
    private final Map<String, CacheEntry> m_caches = new HashMap<String, CacheEntry>();

    public IJsResourceRef getJsRef(Permutation permutation, String slotName) {
        return (IJsResourceRef)this.getEntry(permutation.toExternal()).m_slottedJsRef.get(slotName);
    }

    public void setJsRef(Permutation permutation, String slotName, IJsResourceRef resource) {
        this.getEntry(permutation.toExternal()).m_slottedJsRef.put(slotName, resource);
    }

    public Iterable<String> getJsSlotNames(Permutation permutation) {
        return this.getEntry(permutation.toExternal()).m_slottedJsRef.keySet();
    }

    public boolean isCached(Permutation permutation) {
        return this.m_caches.containsKey(permutation.toExternal());
    }

    public Set<String> getCachedJsSet(Permutation permutation) {
        return this.getEntry(permutation.toExternal()).m_cachedJsUrns;
    }

    public void cachedJs(Permutation permutation, String resourceUrn) {
        this.getEntry(permutation.toExternal()).m_cachedJsUrns.add(resourceUrn);
    }

    private CacheEntry getEntry(String key) {
        if (ResourceUsageCtx.ctx().isFragmentExtractionMode()) {
            return EMPTY_ENRTY;
        }
        CacheEntry entry = this.m_caches.get(key);
        if (entry == null) {
            entry = new CacheEntry();
            this.m_caches.put(key, entry);
        }
        return entry;
    }

    private static class CacheEntry {
        private Map<String, IJsResourceRef> m_slottedJsRef = new LinkedHashMap<String, IJsResourceRef>(5);
        private Set<String> m_cachedJsUrns = new HashSet<String>();

        private CacheEntry() {
        }
    }
}

