/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.cache.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.resource.slot.ExternalizedSlotGrouping;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.vsf.aggregator.cache.meta.GrouppedBaseInfo;

public class ViewJsExternalizationInfo {
    private final String m_viewId;
    private Map<String, GrouppedJsInfo> m_grouppedJsInfoMap = new LinkedHashMap<String, GrouppedJsInfo>(4);
    private ExternalizedSlotGrouping m_slotGroupping;
    private Map<String, Map<String, GrouppedJsInfo>> m_localeGrouppedJsInfoMap = new LinkedHashMap<String, Map<String, GrouppedJsInfo>>(2);
    private JsResourceSlotter m_slotter;
    private Set<String> m_locales = new LinkedHashSet<String>();
    private static Collection<GrouppedJsInfo> EMPTY_GROUPED_JS_INFO_COLLECTION = Collections.unmodifiableList(new ArrayList(0));

    public ViewJsExternalizationInfo(String viewId) {
        this.m_viewId = viewId;
    }

    public void setSlotter(JsResourceSlotter slotter) {
        this.m_slotter = slotter;
    }

    public JsResourceSlotter getSlotter() {
        return this.m_slotter;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public ExternalizedSlotGrouping getSlotGroupping() {
        return this.m_slotGroupping;
    }

    public void setSlotMapping(ExternalizedSlotGrouping groupping) {
        this.m_slotGroupping = groupping;
    }

    public Collection<GrouppedJsInfo> getAllGrouppedJsInfo() {
        return this.m_grouppedJsInfoMap.values();
    }

    public Map<String, Map<String, GrouppedJsInfo>> getLocaleGrouppedJsInfo() {
        return this.m_localeGrouppedJsInfoMap;
    }

    public synchronized GrouppedJsInfo getGrouppedJsInfo(String groupIndex) {
        GrouppedJsInfo info = this.m_grouppedJsInfoMap.get(groupIndex);
        if (info == null) {
            info = new GrouppedJsInfo(groupIndex);
            info.setViewId(this.m_viewId);
            this.m_grouppedJsInfoMap.put(groupIndex, info);
        }
        return info;
    }

    public Collection<GrouppedJsInfo> getAllGrouppedJsInfo(String locale) {
        if (this.getLocales().contains(locale)) {
            return this.m_localeGrouppedJsInfoMap.get(locale).values();
        }
        return EMPTY_GROUPED_JS_INFO_COLLECTION;
    }

    public synchronized GrouppedJsInfo getGrouppedJsInfo(String groupIndex, String locale) {
        GrouppedJsInfo info;
        Map<String, GrouppedJsInfo> map = this.m_localeGrouppedJsInfoMap.get(locale);
        if (map == null) {
            map = new LinkedHashMap<String, GrouppedJsInfo>();
            this.m_locales.add(locale);
            this.m_localeGrouppedJsInfoMap.put(locale, map);
        }
        if ((info = map.get(groupIndex)) == null) {
            info = new GrouppedJsInfo(groupIndex);
            info.setViewId(this.m_viewId);
            map.put(groupIndex, info);
        }
        return info;
    }

    public Set<String> getLocales() {
        return this.m_locales;
    }

    public synchronized boolean removeGrouppedJsInfo(String groupIndex, String locale) {
        return this.m_localeGrouppedJsInfoMap.get(locale).remove(groupIndex) != null;
    }

    public synchronized boolean removeGrouppedJsInfo(String groupIndex) {
        return this.m_grouppedJsInfoMap.remove(groupIndex) != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(300);
        sb.append(" viewId=").append(this.m_viewId).append("\n");
        sb.append(this.m_slotGroupping.toString());
        for (GrouppedJsInfo grouppedInfo : this.getAllGrouppedJsInfo()) {
            sb.append(grouppedInfo.toString()).append("\n");
        }
        for (String locale : this.m_locales) {
            sb.append("locale=").append(locale).append("\n");
            for (GrouppedJsInfo grouppedInfo : this.getAllGrouppedJsInfo(locale)) {
                sb.append(grouppedInfo.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    public static class GrouppedJsInfo
    extends GrouppedBaseInfo {
        private String m_md5;
        private List<String> m_jsResourceUrns = new ArrayList<String>();
        private Map<String, String> m_jsResourceSizes = new HashMap<String, String>();
        private Map<String, MARKER> m_jsResourceUrnMarkers = new HashMap<String, MARKER>();
        private String m_resourceSize = "0";
        private boolean m_isEmpty = true;

        GrouppedJsInfo(String index) {
            super(index);
        }

        public List<String> getAllJsResourceUrns() {
            return this.m_jsResourceUrns;
        }

        public List<String> getResolvedUrns() {
            GrouppedJsInfo parent = (GrouppedJsInfo)this.getParentGroup();
            ArrayList<String> result = new ArrayList<String>();
            if (parent != null) {
                List<String> parentUrns = parent.getResolvedUrns();
                result.addAll(parentUrns);
            }
            for (String urn : this.m_jsResourceUrns) {
                MARKER marker = this.m_jsResourceUrnMarkers.get(urn);
                if (marker == MARKER.EXCLUDE) {
                    result.remove(urn);
                    continue;
                }
                result.add(urn);
            }
            return result;
        }

        public void addJsResourceUrn(String jsResourceUrn) {
            this.m_jsResourceUrns.add(jsResourceUrn);
            this.m_jsResourceUrnMarkers.put(jsResourceUrn, MARKER.INCLUDE);
        }

        public void addJsResourceUrn(String jsResourceUrn, MARKER marker) {
            this.m_jsResourceUrns.add(jsResourceUrn);
            this.m_jsResourceUrnMarkers.put(jsResourceUrn, marker);
        }

        public MARKER getJsResourceUrnMarker(String jsResourceUrn) {
            return this.m_jsResourceUrnMarkers.get(jsResourceUrn);
        }

        public void addJsResourceSize(String jsResourceUrn, String jsResourceSize) {
            this.m_jsResourceSizes.put(jsResourceUrn, jsResourceSize);
        }

        public Map<String, String> getAllJsResourceSizes() {
            return this.m_jsResourceSizes;
        }

        public String getJsResourceSize(String jsResourceUrn) {
            if (this.m_jsResourceSizes.get(jsResourceUrn) != null) {
                return this.m_jsResourceSizes.get(jsResourceUrn);
            }
            return "0";
        }

        public void removeJsResourceUrn(String jsResourceUrn) {
            this.m_jsResourceUrns.remove(jsResourceUrn);
            this.m_jsResourceUrnMarkers.remove(jsResourceUrn);
        }

        public boolean contains(String urn) {
            return this.m_jsResourceUrns.contains(urn);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("  slotIndex=").append(this.getIndex()).append("\n");
            sb.append("   path=").append(this.getRelativePath()).append("\n");
            sb.append("   opath=").append(this.getOptimizedPath()).append("\n");
            boolean notFirst = false;
            for (String urn : this.m_jsResourceUrns) {
                if (notFirst) {
                    sb.append(" | ");
                } else {
                    sb.append("   ");
                    notFirst = true;
                }
                sb.append(urn);
                sb.append("   ");
                sb.append((Object)this.m_jsResourceUrnMarkers.get(urn));
            }
            sb.append("\n");
            return sb.toString();
        }

        public String getMd5() {
            return this.m_md5;
        }

        public void setMd5(String md5) {
            this.m_md5 = md5;
        }

        public String getResourceSize() {
            if (!"0".equals(this.m_resourceSize)) {
                return this.m_resourceSize;
            }
            int resSize = 0;
            for (String size : this.m_jsResourceSizes.values()) {
                try {
                    resSize += Integer.parseInt(size);
                }
                catch (Exception exception) {}
            }
            return String.valueOf(resSize);
        }

        public void setResourceSize(String size) {
            this.m_resourceSize = size;
        }

        public boolean isEmpty() {
            return this.m_isEmpty;
        }

        public void setEmpty(boolean empty) {
            this.m_isEmpty = empty;
        }

        public static enum MARKER {
            INCLUDE,
            EXCLUDE;

        }
    }
}

