/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.statistics.DarwinStatisticsCtxHelper;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.dsf.spec.component.ISpecBasedComponent;
import org.eclipse.vjet.vsf.jsref.JsFunc;
import org.eclipse.vjet.vsf.jsref.JsObjData;
import org.eclipse.vjet.vsf.jsref.JsProp;
import org.eclipse.vjet.vsf.jsref.JsPropSetter;
import org.eclipse.vjet.vsf.jsref.ctx.ResourceCtx;
import org.eclipse.vjet.vsf.jsref.internals.BV;
import org.eclipse.vjet.vsf.jsref.internals.JsCmpMeta;
import org.eclipse.vjet.vsf.jsref.internals.Params;
import org.eclipse.vjet.vsf.jsruntime.BoolWrapper;
import org.eclipse.vjet.vsf.jsruntime.JsObjectRefWrapper;
import org.eclipse.vjet.vsf.jsruntime.compregistry.JsComponentRegistry;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.jsruntime.jsref.IJsPropSetter;

public class JsObj
implements ISpecBasedComponent,
IJsObjectRef,
IValueBinding<Object> {
    private static final long serialVersionUID = 1L;
    private final JsCmpMeta m_cmpMeta;
    private final Params m_params;
    private final boolean m_isInstance;
    private String m_instanceId;
    private boolean m_genAsHandler;
    private boolean m_genned;
    private Map<String, JsPropSetter> m_instanceProps;

    public JsObj(JsCmpMeta cmpMeta, boolean isInstance, Object ... args) {
        this.m_cmpMeta = cmpMeta;
        this.m_isInstance = isInstance;
        if (isInstance) {
            ResourceCtx.ctx().register(cmpMeta.getSpec());
            this.m_instanceId = JsRuntimeCtx.ctx().registerComponent((IJsObjectRef)this);
        } else {
            this.m_instanceId = null;
        }
        this.m_params = new Params(args);
        DarwinStatisticsCtxHelper.countJsStatistics((String)this.m_cmpMeta.getCmpName());
    }

    public static void addResourceSpec(IComponentSpec spec) {
        ResourceCtx.ctx().register(spec);
    }

    public String generate() {
        return this.generate(false);
    }

    public String generate(boolean withRegistry) {
        if (!this.m_isInstance) {
            return "";
        }
        this.m_genned = true;
        if (!withRegistry) {
            return this.getInstantiationJs();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJsScopedVarRef()).append(".put('").append(this.getInstanceId()).append("', ").append(this.getInstantiationJs()).append(");");
        return sb.toString();
    }

    @Deprecated
    public String getInstanceJsWithOutRegistration() {
        return this.getInstantiationJs();
    }

    public String getInstantiationJs() {
        this.m_genned = true;
        StringBuffer sb = new StringBuffer();
        sb.append("new ").append(this.m_cmpMeta.getCmpName()).append("(").append(this.m_params.genArgs()).append(")");
        return sb.toString();
    }

    public String getRefJs() {
        return this.getRefJs(this.getJsScopedVarRef());
    }

    public String getRefJs(String scopeVar) {
        if (scopeVar == null) {
            scopeVar = this.getJsScopedVarRef();
        }
        if (!this.m_isInstance) {
            return this.m_cmpMeta.getCmpName();
        }
        String key = this.getInstanceId();
        StringBuilder sb = new StringBuilder();
        sb.append(scopeVar);
        if (JsComponentRegistry.isValidKey((String)key)) {
            sb.append("._").append(key);
        } else {
            sb.append(".get('").append(key).append("')");
        }
        return sb.toString();
    }

    public JsCmpMeta getCmpMeta() {
        return this.m_cmpMeta;
    }

    public Params getParams() {
        return this.m_params;
    }

    public Object getValue() {
        throw new DsfRuntimeException("Not supported");
    }

    public Class<Object> getValueType() {
        throw new DsfRuntimeException("Not supported");
    }

    public void setValue(Object value) {
        throw new DsfRuntimeException("Not supported");
    }

    public String getVariableRef() {
        return this.getRefJs();
    }

    public String getJsScopedVarRef() {
        return JsRuntimeCtx.ctx().getCompRegistry().getRegistryVar();
    }

    public IComponentSpec getCompSpec() {
        return this.getCmpMeta().getSpec();
    }

    public String getInstanceId() {
        return this.m_instanceId;
    }

    protected void registerToOptimizer() {
    }

    protected JsPropSetter addInstancePropSetter(JsPropSetter prop) {
        this.getInstancePropSetters().put(prop.getName(), prop);
        return prop;
    }

    public String setInstanceId(String instanceId) {
        this.m_instanceId = instanceId;
        return this.m_instanceId;
    }

    public String getInstancePropertySetters() {
        StringBuilder b = new StringBuilder();
        for (JsPropSetter s : this.getInstancePropSetters().values()) {
            b.append(s.generate());
        }
        return b.toString();
    }

    private Map<String, JsPropSetter> getInstancePropSetters() {
        if (this.m_instanceProps == null) {
            this.m_instanceProps = new HashMap<String, JsPropSetter>();
        }
        return this.m_instanceProps;
    }

    public boolean isInstance() {
        return this.m_isInstance;
    }

    protected IJsPropSetter setProp(Object value) {
        return this.setProp(JsObj.getCallingName(), value);
    }

    protected IJsPropSetter setProp(String name, Object value) {
        IValueBinding<Object> vbValue;
        JsObj.assertName(name, "Property name must not be empty or null");
        JsObj.assertValue(value, "Property value must not be null");
        if (value instanceof IValueBinding) {
            vbValue = (IValueBinding<Object>)value;
        } else {
            Class<?> clz = value.getClass();
            vbValue = BV.bind(clz, value);
        }
        return this.addInstancePropSetter(new JsPropSetter(this, name, vbValue));
    }

    protected static IJsPropSetter setProp(JsObjData info, Object value) {
        return JsObj.setProp(info, JsObj.getCallingName(), value);
    }

    protected static <T> IJsPropSetter setProp(JsObjData info, String name, Object value) {
        IValueBinding<Object> vbValue;
        JsObj.assertName(name, "Property name must not be empty or null");
        JsObj.assertValue(value, "Property value must not be null");
        if (value instanceof IValueBinding) {
            vbValue = (IValueBinding<Object>)value;
        } else {
            Class<?> clz = value.getClass();
            vbValue = BV.bind(clz, value);
        }
        return new JsPropSetter(info.getStaticAnchor(), name, vbValue);
    }

    protected <T> JsProp<T> getProp(Class<T> returnType) {
        return this.getProp(returnType, JsObj.getCallingName());
    }

    protected <T> JsProp<T> getProp(Class<T> returnType, String name) {
        JsObj.assertName(name, "Property name must not be empty or null");
        return new JsProp(this, name);
    }

    protected static <T> JsProp<T> getProp(JsObjData info, Class<T> returnType) {
        return JsObj.getProp(info, returnType, JsObj.getCallingName());
    }

    protected static <T> JsProp<T> getProp(JsObjData info, Class<T> returnType, String name) {
        JsObj.assertName(name, "Property name must not be empty or null");
        return new JsProp(info.getStaticAnchor(), name);
    }

    public JsFunc<Void> call() {
        return JsObj._call(this, Void.class, JsObj.getCallingName());
    }

    public JsFunc<Void> call(String name) {
        return JsObj._call(this, Void.class, name);
    }

    public <T> JsFunc<T> call(Class<T> returnType) {
        return JsObj._call(this, returnType, JsObj.getCallingName());
    }

    public <T> JsFunc<T> call(Class<T> returnType, String name) {
        return JsObj._call(this, returnType, name);
    }

    public static JsFunc<Void> call(JsObjData data) {
        return JsObj._call(data, Void.class, JsObj.getCallingName());
    }

    public static JsFunc<Void> call(JsObjData data, String name) {
        return JsObj._call(data, Void.class, name);
    }

    public static <T> JsFunc<T> call(JsObjData data, Class<T> returnType) {
        return JsObj._call(data, returnType, JsObj.getCallingName());
    }

    public static <T> JsFunc<T> call(JsObjData data, Class<T> returnType, String name) {
        return JsObj._call(data, returnType, name);
    }

    private static <T> JsFunc<T> _call(JsObj env, Class<T> type, String name) {
        JsObj.assertMethodName(name);
        return new JsFunc(env, name, false, JsObj.hasReturn(type));
    }

    private static void assertMethodName(String name) {
        if (name == null || name.trim().equals("")) {
            JsObj.chuck("Method name must not be empty String or null");
        }
    }

    private static <T> JsFunc<T> _call(JsObjData data, Class<T> type, String name) {
        JsObj.assertName(name, "Property name must not be empty or null");
        return new JsFunc(data.getStaticAnchor(), name, false, JsObj.hasReturn(type));
    }

    public static boolean hasReturn(Class clz) {
        return Void.class != clz;
    }

    private static String getCallingName() {
        return Thread.currentThread().getStackTrace()[4].getMethodName();
    }

    private static void assertValue(Object value, String msg) {
        if (value == null) {
            JsObj.chuck(msg);
        }
    }

    private static void assertName(String name, String msg) {
        if (name == null || name.trim().equals("")) {
            JsObj.chuck(msg);
        }
    }

    private static void chuck(String msg) {
        throw new DsfRuntimeException(msg);
    }

    public boolean isHandler() {
        return this.m_genAsHandler;
    }

    public void setIsHandler(boolean value) {
        this.m_genAsHandler = value;
    }

    public boolean isGenned() {
        return this.m_genned;
    }

    public String getClassName() {
        return this.m_cmpMeta.getCmpName();
    }

    protected static BoolWrapper wrapS(Boolean arg) {
        return new BoolWrapper(arg);
    }

    protected BoolWrapper wrap(Boolean arg) {
        return new BoolWrapper(arg);
    }

    protected static IValueBinding<? extends Boolean> checkS(IValueBinding<? extends Boolean> arg) {
        if (arg == null && JsRuntimeCtx.ctx().runTimeTypeCheck()) {
            throw new DsfRuntimeException("argument can not be null for boolean");
        }
        return arg;
    }

    protected IValueBinding<? extends Boolean> check(IValueBinding<? extends Boolean> arg) {
        return JsObj.checkS(arg);
    }

    protected JsObjectRefWrapper wrap(IJsObjectRef[] psKey) {
        return JsObj.wrapS(psKey);
    }

    protected static JsObjectRefWrapper wrapS(IJsObjectRef[] psKey) {
        return new JsObjectRefWrapper(psKey);
    }
}

