/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRuleList;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.stylesheets.IStyleSheet;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class DCssStyleSheet
implements CSSStyleSheet,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean m_disabled = false;
    private DNode m_ownerNode = null;
    private CSSStyleSheet m_parentStyleSheet = null;
    private String m_href = null;
    private String m_title = null;
    private MediaList m_media = null;
    private CSSRule m_ownerRule = null;
    private boolean m_readOnly = false;
    private CSSRuleList m_rules = new DCssRuleList();

    @Override
    public String getType() {
        return "text/css";
    }

    @Override
    public boolean getDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.m_disabled = disabled;
    }

    public DNode getOwnerNode() {
        return this.m_ownerNode;
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.m_parentStyleSheet;
    }

    @Override
    public String getHref() {
        return this.m_href;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public MediaList getMedia() {
        return this.m_media;
    }

    @Override
    public CSSRule getOwnerRule() {
        return this.m_ownerRule;
    }

    @Override
    public CSSRuleList getCssRules() {
        return this.m_rules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (this.m_readOnly) {
            throw new DCssException(7, 2);
        }
        try {
            CSSRule r;
            block10: {
                int msg;
                block13: {
                    block11: {
                        block12: {
                            if (rule == null) {
                                throw new DsfRuntimeException("Error: rule is null");
                            }
                            InputSource is = new InputSource((Reader)new StringReader(rule));
                            DCssBuilder parser = new DCssBuilder();
                            parser.setParentStyleSheet(this);
                            r = parser.parseRule(is);
                            if (this.getCssRules().getLength() <= 0) break block10;
                            msg = -1;
                            if (r.getType() != 2) break block11;
                            if (index == 0) break block12;
                            msg = 15;
                            break block13;
                        }
                        if (this.getCssRules().item(0).getType() != 2) break block13;
                        msg = 16;
                        break block13;
                    }
                    if (r.getType() == 3 && index <= this.getCssRules().getLength()) {
                        int i = 0;
                        while (i < index) {
                            short rt = this.getCssRules().item(i).getType();
                            if (rt != 2 || rt != 3) {
                                msg = 17;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (msg > -1) {
                    throw new DCssException(3, msg);
                }
            }
            ((DCssRuleList)this.getCssRules()).insert(r, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DCssException(1, 1, e.getMessage());
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (this.m_readOnly) {
            throw new DCssException(7, 2);
        }
        try {
            ((DCssRuleList)this.getCssRules()).delete(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DCssException(1, 1, e.getMessage());
        }
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public CSSStyleSheet setReadOnly(boolean b) {
        this.m_readOnly = b;
        return this;
    }

    public void setOwnerNode(DNode ownerNode) {
        this.m_ownerNode = ownerNode;
    }

    public void setParentStyleSheet(IStyleSheet parentStyleSheet) {
        this.m_parentStyleSheet = (CSSStyleSheet)parentStyleSheet;
    }

    public void setHref(String href) {
        this.m_href = href;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setMedia(String mediaText) {
    }

    public void setOwnerRule(CSSRule ownerRule) {
        this.m_ownerRule = ownerRule;
    }

    public void setRuleList(CSSRuleList rules) {
        this.m_rules = rules;
    }

    public String toString() {
        return this.m_rules.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DCssStyleSheet copy = (DCssStyleSheet)super.clone();
        copy.m_rules = (DCssRuleList)((DCssRuleList)copy.m_rules).clone();
        return copy;
    }
}

