/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom.util;

import java.util.Vector;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DElementConstructor;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.DHtml;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.Html;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class WireFrameBuilder
implements ContentHandler,
LexicalHandler {
    protected DDocument m_document;
    protected DDocument m_initialDocument = new DHtmlDocument();
    protected DElement m_rootElement = new DHtml();
    protected DElement m_current;
    private boolean m_ignoreWhitespace = true;
    private boolean m_done = true;
    protected Vector m_preRootNodes;
    protected DElementConstructor m_eltConstuctor;

    @Override
    public void startDocument() throws SAXException {
        if (!this.m_done) {
            throw new SAXException("HTM001 State error: startDocument fired twice on one builder.");
        }
        this.m_done = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.m_document == null) {
            throw new SAXException("HTM002 State error: document never started or missing document element.");
        }
        if (this.m_current != null) {
            throw new SAXException("HTM003 State error: document ended before end of document element.");
        }
        this.m_current = null;
        this.m_done = true;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        int i;
        if (localName == null) {
            throw new SAXException("HTM004 Argument 'tagName' is null.");
        }
        if (this.m_document == null) {
            this.m_document = this.m_initialDocument;
            this.m_current = this.m_rootElement;
            this.m_document.add((DNode)this.m_rootElement);
            if (this.m_current == null) {
                throw new SAXException("HTM005 State error: Document.getDocumentElement returns null.");
            }
            if (this.m_preRootNodes != null) {
                i = this.m_preRootNodes.size();
                while (i-- > 0) {
                    this.m_document.insertBefore((Node)this.m_preRootNodes.elementAt(i), (Node)this.m_current);
                }
                this.m_preRootNodes = null;
            }
        } else {
            if (this.m_current == null) {
                throw new SAXException("HTM006 State error: startElement called after end of document element.");
            }
            if (this.m_eltConstuctor == null) {
                this.m_eltConstuctor = new Html();
            }
            DElement node = this.m_eltConstuctor.domCreateDynamicElement(localName);
            this.m_current.add((DNode)node);
            this.m_current = node;
        }
        if (atts != null) {
            i = 0;
            while (i < atts.getLength()) {
                String name = atts.getLocalName(i);
                String value = atts.getValue(i);
                if ("id".equalsIgnoreCase(name)) {
                    DAttr attr = (DAttr)this.m_document.createAttribute(name);
                    attr.setValue(value);
                    this.m_current.setAttributeNode((Attr)attr);
                    this.m_current.setIdAttribute(name, true);
                } else {
                    this.m_current.setAttribute(name, value);
                }
                ++i;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.m_current == null) {
            throw new SAXException("HTM007 State error: endElement called with no current node.");
        }
        if (!this.m_current.getNodeName().equalsIgnoreCase(localName)) {
            throw new SAXException("HTM008 State error: mismatch in closing tag name " + localName + "\n" + localName);
        }
        this.m_current = this.m_current.getParentNode().getNodeType() == 9 ? null : (DElement)this.m_current.getParentNode();
    }

    public void characters(String text) throws SAXException {
        this.addText(text);
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        this.addText(new String(text, start, length));
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
        if (!this.m_ignoreWhitespace) {
            this.addText(new String(text, start, length));
        }
    }

    private void addText(String text) throws SAXException {
        if (this.m_current == null) {
            throw new SAXException("HTM009 State error: character data found outside of element.");
        }
        String val = text.trim().replace("\r", "").replace("\n", "").replace("\t", "");
        if (val.length() > 0) {
            Node child = this.m_current.getLastChild();
            if (child instanceof DText) {
                ((DText)child).appendData(text);
            } else {
                this.m_current.add(text);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String instruction) throws SAXException {
    }

    public DHtmlDocument getHTMLDocument() {
        return (DHtmlDocument)this.m_document;
    }

    public DDocument getDocument() {
        return this.m_document;
    }

    public void setDocumentAndRoot(DDocument doc, DElement root) {
        this.m_initialDocument = doc;
        this.m_rootElement = root;
    }

    public void setElementConstructor(DElementConstructor elt) {
        this.m_eltConstuctor = elt;
    }

    public DElement getCurrentElement() {
        return this.m_current;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uti) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] text, int start, int length) throws SAXException {
        if (this.m_document == null) {
            return;
        }
        this.m_current.appendChild((Node)this.m_document.createComment(new String(text, start, length)));
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }
}

