/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.event;

import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.event.IDsfEventListener;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.phase.PhaseId;
import org.eclipse.vjet.dsf.dom.DNode;

public abstract class DsfPhaseEvent<L extends IDsfEventListener>
extends DsfEvent<DNode, L> {
    private PhaseId m_phaseId = PhaseId.ANY_PHASE;
    private PhaseId m_origPhaseId;

    protected DsfPhaseEvent(DNode node, Class<L> listenerType) {
        super((Object)node, listenerType);
    }

    public DNode getSource() {
        return (DNode)super.getSource();
    }

    public PhaseId getPhaseId() {
        return this.m_phaseId;
    }

    public void setPhaseId(PhaseId phaseId) {
        if (phaseId == null) {
            throw new DsfRuntimeException("PhaseId must not be null");
        }
        this.m_phaseId = phaseId;
    }

    public boolean shouldFire(PhaseId phaseId) {
        return this.m_phaseId == PhaseId.ANY_PHASE || this.m_phaseId == phaseId;
    }

    public boolean shouldDelete(PhaseId phaseId) {
        return this.m_phaseId == PhaseId.ANY_PHASE || this.m_phaseId == phaseId;
    }

    public PhaseId getOriginatingPhaseId() {
        return this.m_origPhaseId;
    }

    protected void setOriginatingPhaseId(PhaseId phaseId) {
        this.m_origPhaseId = phaseId;
    }
}

