/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.tracer;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.trace.config.TraceConfigMgr;
import org.eclipse.vjet.dsf.common.trace.handler.DefaultTraceEventHandler;
import org.eclipse.vjet.dsf.common.trace.handler.HandlerId;
import org.eclipse.vjet.dsf.common.trace.handler.TraceFormatter;
import org.eclipse.vjet.dsf.common.trace.introspect.DefaultTraceIntrospector;
import org.eclipse.vjet.dsf.common.tracer.DsfTracer;
import org.eclipse.vjet.dsf.common.tracer.Factory;
import org.eclipse.vjet.dsf.common.tracer.ITracer;
import org.eclipse.vjet.dsf.common.tracer.NoOpTracer;

public final class TraceManager {
    public static final String SCOPE_ROOT = "";
    private Boolean m_isTraceOn = null;
    private Map<String, DsfTracer> m_tracers = new HashMap<String, DsfTracer>(1);
    private Logger m_defaultLogger;
    private Formatter m_defaultFormatter;
    private Writer m_defaultWriter;
    private DefaultTraceEventHandler m_defaultHandler;
    private DefaultTraceIntrospector m_defaultIntrospector;
    private static TraceConfigMgr s_configBean;
    private Boolean m_isVerboseOn = null;

    public void setTraceOn(boolean on) {
        this.m_isTraceOn = on;
    }

    public boolean isTraceOn() {
        if (this.m_isTraceOn != null) {
            return this.m_isTraceOn;
        }
        return TraceManager.getConfigBean().isTraceOn();
    }

    public boolean isEnabled(Class callingClass) {
        if (!this.isTraceOn() || callingClass == null) {
            return false;
        }
        return this.isEnabled(TraceManager.getScope(callingClass));
    }

    public boolean isEnabled(String scope) {
        if (!this.isTraceOn() || scope == null) {
            return false;
        }
        List<String> enabledScopes = TraceManager.getConfigBean().getEnabledScopes();
        if (enabledScopes.isEmpty()) {
            return false;
        }
        if (enabledScopes.contains(scope)) {
            return true;
        }
        List<String> disabledScopes = TraceManager.getConfigBean().getDisabledScopes();
        if (disabledScopes.contains(scope)) {
            return false;
        }
        return this.isEnabled(TraceManager.getParentScope(scope));
    }

    public ITracer getTracer(Class callingClass) {
        if (callingClass == null) {
            DsfExceptionHelper.chuck((String)"callingClass is null");
        }
        if (!this.isTraceOn()) {
            return NoOpTracer.NO_OP_TRACER;
        }
        return this.getTracer(TraceManager.getScope(callingClass));
    }

    public ITracer getTracer(String scope) {
        if (scope == null) {
            DsfExceptionHelper.chuck((String)"scope is null");
        }
        if (!this.isTraceOn() || !this.isEnabled(scope)) {
            return NoOpTracer.NO_OP_TRACER;
        }
        return this.findTracer(scope);
    }

    public Logger getDefaultLogger() {
        if (this.m_defaultLogger == null) {
            this.m_defaultLogger = Factory.createDefaultLogger(this.getClass().getName(), this.getDefaultFormatter());
        }
        return this.m_defaultLogger;
    }

    public Formatter getDefaultFormatter() {
        if (this.m_defaultFormatter == null) {
            this.m_defaultFormatter = new TraceFormatter();
        }
        return this.m_defaultFormatter;
    }

    public DefaultTraceEventHandler getDefaultHandler() {
        if (this.m_defaultHandler == null) {
            this.m_defaultHandler = new DefaultTraceEventHandler(new HandlerId("Default"));
        }
        return this.m_defaultHandler;
    }

    public Writer getDefaultWriter() {
        if (this.m_defaultWriter == null) {
            this.m_defaultWriter = new StringWriter();
        }
        return this.m_defaultWriter;
    }

    public DefaultTraceIntrospector getDefaultIntrospector() {
        if (this.m_defaultIntrospector == null) {
            this.m_defaultIntrospector = new DefaultTraceIntrospector();
        }
        return this.m_defaultIntrospector;
    }

    public void close() {
        if (!this.isTraceOn()) {
            return;
        }
        for (DsfTracer tracer : this.m_tracers.values()) {
            tracer.close();
        }
        if (this.m_defaultWriter != null) {
            Logger logger = TraceCtx.ctx().getTraceManager().getDefaultLogger();
            logger.log(Level.INFO, this.m_defaultWriter.toString());
            Handler[] handlerArray = logger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                h.close();
                ++n2;
            }
        }
    }

    public static String getParentScope(String childScope) {
        if (childScope == null) {
            return null;
        }
        if (childScope.equals(SCOPE_ROOT)) {
            return null;
        }
        int idx = childScope.lastIndexOf(".");
        if (idx < 0) {
            return SCOPE_ROOT;
        }
        return childScope.substring(0, idx);
    }

    public static String getScope(Class callingClass) {
        if (callingClass == null) {
            DsfExceptionHelper.chuck((String)"callingClass is null");
        }
        if (callingClass.getPackage() != null) {
            return callingClass.getPackage().getName();
        }
        return callingClass.getName();
    }

    private DsfTracer addTracer(String scope) {
        if (scope == null) {
            DsfExceptionHelper.chuck((String)"scope is null");
        }
        DsfTracer tracer = new DsfTracer(scope);
        this.m_tracers.put(scope, tracer);
        return tracer;
    }

    private DsfTracer findTracer(String scope) {
        DsfTracer tracer;
        if (scope == null) {
            DsfExceptionHelper.chuck((String)"scope is null");
        }
        if ((tracer = this.m_tracers.get(scope)) != null) {
            return tracer;
        }
        if (this.hasScopeConfig(scope) || SCOPE_ROOT.equals(scope)) {
            return this.addTracer(scope);
        }
        return this.findTracer(TraceManager.getParentScope(scope));
    }

    private boolean hasScopeConfig(String scope) {
        if (scope == null) {
            DsfExceptionHelper.chuck((String)"scope is null");
        }
        return TraceManager.getConfigBean().getTracerConfig(scope) != null;
    }

    private static TraceConfigMgr getConfigBean() {
        if (s_configBean == null) {
            s_configBean = TraceConfigMgr.getInstance();
        }
        return s_configBean;
    }

    public boolean isVerboseOn() {
        if (this.m_isVerboseOn != null) {
            return this.m_isVerboseOn;
        }
        return TraceManager.getConfigBean().isVerboseOn();
    }

    public void setVerboseOn(boolean verboseOn) {
        this.m_isVerboseOn = verboseOn;
    }
}

