/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.SecondaryTable;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.ISecondaryTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaEntityModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularPluralTopLevelAnnotationAdapter;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class JavaEntityModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaEntityModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaEntityModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    private JavaEntityModelAdapter getEntityModelAdapter() {
        return (JavaEntityModelAdapter)this.testClassType.getTypeMapping().getModelAdapter();
    }

    public void testSetNameInJavaUpdatesPersistenceModel() {
        StringAnnotationElementAdapter adapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"specifiedNameAdapter");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz, (Object)"Foo");
        JavaEntityModelAdapterTests.assertEquals((String)"Foo", (String)((Entity)this.testClassType.getTypeMapping()).getSpecifiedName());
        JavaEntityModelAdapterTests.assertEquals((String)"Foo", (String)((Entity)this.testClassType.getTypeMapping()).getName());
        JavaEntityModelAdapterTests.assertEquals((String)SimpleTestProject.TYPE_NAME, (String)((Entity)this.testClassType.getTypeMapping()).getDefaultName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz2, (Object)"");
        JavaEntityModelAdapterTests.assertEquals((String)"", (String)((Entity)this.testClassType.getTypeMapping()).getSpecifiedName());
        JavaEntityModelAdapterTests.assertEquals((String)"", (String)((Entity)this.testClassType.getTypeMapping()).getName());
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        type.removeAnnotationElement("Entity", "name");
        JavaEntityModelAdapterTests.assertEquals(null, (String)((Entity)this.testClassType.getTypeMapping()).getSpecifiedName());
        JavaEntityModelAdapterTests.assertEquals((String)SimpleTestProject.TYPE_NAME, (String)((Entity)this.testClassType.getTypeMapping()).getName());
    }

    public void testSetNameInPersistenceModelUpdatesJava() {
        Entity entity = (Entity)this.testClassType.getTypeMapping();
        StringAnnotationElementAdapter adapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"specifiedNameAdapter");
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        entity.setSpecifiedName("Bar");
        CompilationUnit astRoot = type.createASTRoot();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((String)"Bar", (String)javaValue);
        entity.setSpecifiedName("");
        astRoot = type.createASTRoot();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz2, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((String)"", (String)javaValue);
        entity.setSpecifiedName(null);
        astRoot = type.createASTRoot();
        MemberValuePair valuePair = type.getMemberValuePair("Entity", "name", astRoot);
        JavaEntityModelAdapterTests.assertEquals(null, (Object)valuePair);
        JavaEntityModelAdapterTests.assertTrue((boolean)type.getAnnotation("Entity").isMarkerAnnotation());
    }

    public void testSecondaryTableChangesInJavaUpdatesPersistenceModel() {
        Entity entity = (Entity)this.testClassType.getTypeMapping();
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 0 ? 1 : 0) != 0);
        Type type = (Type)ClassTools.invokeMethod((Object)entity.getModelAdapter(), (String)"type");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"SecondaryTable");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)annotation);
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"SALARY");
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 1 ? 1 : 0) != 0);
        JavaEntityModelAdapterTests.assertEquals((String)"SALARY", (String)((SecondaryTable)entity.getSecondaryTables().get(0)).getSpecifiedName());
        JavaEntityModelAdapterTests.assertEquals(null, (String)((SecondaryTable)entity.getSecondaryTables().get(0)).getDefaultName());
        JavaEntityModelAdapterTests.assertEquals((String)"SALARY", (String)((SecondaryTable)entity.getSecondaryTables().get(0)).getName());
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation annotation = (NormalAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"SecondaryTable");
                ((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)annotation, (String)"name").getValue()).setLiteralValue("OTHER");
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 1 ? 1 : 0) != 0);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getSpecifiedName(), (String)"OTHER");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getName(), (String)"OTHER");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotation((BodyDeclaration)bodyDeclaration, (String)"SecondaryTable");
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 0 ? 1 : 0) != 0);
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation secondaryTablesAnnotation = ASTTools.newSingleMemberAnnotation((AST)bodyDeclaration.getAST(), (String)"SecondaryTables");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)secondaryTablesAnnotation);
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"SecondaryTable");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"SALARY");
                secondaryTablesAnnotation.setValue((Expression)annotation);
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 1 ? 1 : 0) != 0);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getSpecifiedName(), (String)"SALARY");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getName(), (String)"SALARY");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation annotation = (SingleMemberAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"SecondaryTables");
                NormalAnnotation normalAnnotation = (NormalAnnotation)annotation.getValue();
                ((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)normalAnnotation, (String)"name").getValue()).setLiteralValue("OTHER");
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 1 ? 1 : 0) != 0);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getSpecifiedName(), (String)"OTHER");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getName(), (String)"OTHER");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation annotation = (SingleMemberAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"SecondaryTables");
                annotation.setValue((Expression)bodyDeclaration.getAST().newNullLiteral());
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 0 ? 1 : 0) != 0);
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation annotation = (SingleMemberAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"SecondaryTables");
                ASTTools.removeAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)annotation);
            }
        });
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation secondaryTablesAnnotation = ASTTools.newSingleMemberAnnotation((AST)bodyDeclaration.getAST(), (String)"SecondaryTables");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)secondaryTablesAnnotation);
                ArrayInitializer arrayInitializer = bodyDeclaration.getAST().newArrayInitializer();
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"SecondaryTable");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"SALARY");
                ASTTools.addExpressionToArrayInitializer((ArrayInitializer)arrayInitializer, (Expression)annotation);
                secondaryTablesAnnotation.setValue((Expression)arrayInitializer);
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 1 ? 1 : 0) != 0);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getSpecifiedName(), (String)"SALARY");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getName(), (String)"SALARY");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation secondaryTablesAnnotation = (SingleMemberAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"SecondaryTables");
                ArrayInitializer arrayInitializer = (ArrayInitializer)secondaryTablesAnnotation.getValue();
                NormalAnnotation annotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"SecondaryTable");
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)annotation, (String)"name", (String)"OTHER");
                ASTTools.addExpressionToArrayInitializer((ArrayInitializer)arrayInitializer, (Expression)annotation);
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 2 ? 1 : 0) != 0);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getSpecifiedName(), (String)"SALARY");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getName(), (String)"SALARY");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(1)).getSpecifiedName(), (String)"OTHER");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(1)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(1)).getName(), (String)"OTHER");
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation secondaryTablesAnnotation = (SingleMemberAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"SecondaryTables");
                ArrayInitializer arrayInitializer = (ArrayInitializer)secondaryTablesAnnotation.getValue();
                List secondaryTables = (List)arrayInitializer.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                ((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)((NormalAnnotation)secondaryTables.get(0)), (String)"name").getValue()).setLiteralValue("SALARY2");
                ((StringLiteral)ASTTools.memberValuePair((NormalAnnotation)((NormalAnnotation)secondaryTables.get(1)), (String)"name").getValue()).setLiteralValue("OTHER2");
            }
        });
        JavaEntityModelAdapterTests.assertTrue((entity.getSecondaryTables().size() == 2 ? 1 : 0) != 0);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getSpecifiedName(), (String)"SALARY2");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(0)).getName(), (String)"SALARY2");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(1)).getSpecifiedName(), (String)"OTHER2");
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(1)).getDefaultName(), null);
        JavaEntityModelAdapterTests.assertEquals((String)((SecondaryTable)entity.getSecondaryTables().get(1)).getName(), (String)"OTHER2");
    }

    public void testSecondaryTableChangesPersistenceModelUpdatesJava() {
        Entity entity = (Entity)this.testClassType.getTypeMapping();
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        ISecondaryTableModelAdapter tableModelAdpater = ((IEntityModelAdapter)entity.getModelAdapter()).createSecondaryTableModelAdapter();
        SecondaryTable secondaryTable = OrmFactory.eINSTANCE.createSecondaryTable(tableModelAdpater);
        StringAnnotationElementAdapter adapter = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)tableModelAdpater, (String)"specifiedNameAdapter");
        entity.getSecondaryTables().add((Object)secondaryTable);
        JavaEntityModelAdapterTests.assertTrue((boolean)type.containsAnnotation("SecondaryTable"));
        secondaryTable.setSpecifiedName("Foo");
        CompilationUnit astRoot = type.createASTRoot();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((String)"Foo", (String)javaValue);
        secondaryTable.setSpecifiedName("Bar");
        astRoot = type.createASTRoot();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz2, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((String)"Bar", (String)javaValue);
        ISecondaryTableModelAdapter tableModelAdpater2 = ((IEntityModelAdapter)entity.getModelAdapter()).createSecondaryTableModelAdapter();
        SecondaryTable secondaryTable2 = OrmFactory.eINSTANCE.createSecondaryTable(tableModelAdpater2);
        StringAnnotationElementAdapter adapter2 = (StringAnnotationElementAdapter)ClassTools.getFieldValue((Object)tableModelAdpater2, (String)"specifiedNameAdapter");
        entity.getSecondaryTables().add((Object)secondaryTable2);
        JavaEntityModelAdapterTests.assertTrue((boolean)type.containsAnnotation("SecondaryTables"));
        secondaryTable2.setSpecifiedName("MyTable");
        astRoot = type.createASTRoot();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter2, (String)"javaValue", (Class)clazz3, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((String)"MyTable", (String)javaValue);
        SingularPluralTopLevelAnnotationAdapter secondaryTablesAdapter = (SingularPluralTopLevelAnnotationAdapter)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"secondaryTablesAdapter");
        astRoot = type.createASTRoot();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int numSecondaryTables = (Integer)ClassTools.invokeMethod((Object)secondaryTablesAdapter, (String)"javaElementsSize", (Class)clazz4, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((int)2, (int)numSecondaryTables);
        entity.getSecondaryTables().remove(1);
        astRoot = type.createASTRoot();
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        numSecondaryTables = (Integer)ClassTools.invokeMethod((Object)secondaryTablesAdapter, (String)"javaElementsSize", (Class)clazz5, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((int)1, (int)numSecondaryTables);
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz6, (Object)astRoot);
        JavaEntityModelAdapterTests.assertEquals((String)"Bar", (String)javaValue);
    }
}

