/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.debug.node.NodeRunDebugLaunchShortcut;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestDebug {
    protected ILaunchManager launchManager;

    @BeforeEach
    public void setUpLaunch() throws DebugException {
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.removeAllLaunches();
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.debug.ui");
        prefs.setValue("org.eclipse.debug.ui.switch_perspective_on_suspend", "always");
    }

    private void removeAllLaunches() throws DebugException {
        ILaunch[] iLaunchArray = this.launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            launch.terminate();
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n3 = iDebugTargetArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IDebugTarget debugTarget = iDebugTargetArray[n4];
                debugTarget.terminate();
                launch.removeDebugTarget(debugTarget);
                ++n4;
            }
            this.launchManager.removeLaunch(launch);
            ++n2;
        }
    }

    @AfterEach
    public void trearDownLaunch() throws DebugException {
        this.removeAllLaunches();
    }

    @Test
    public void testFindThreadsAndHitsBreakpoint() throws Exception {
        IProject project = Utils.provisionTestProject("helloWorldJS");
        IFile jsFile = project.getFile("hello.js");
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)jsFile);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        TextSelection selection = new TextSelection(doc, doc.getLineOffset(1) + 1, 0);
        IToggleBreakpointsTarget toggleBreakpointsTarget = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget((IWorkbenchPart)editor, (ISelection)selection);
        toggleBreakpointsTarget.toggleLineBreakpoints((IWorkbenchPart)editor, (ISelection)selection);
        final HashSet<IDebugTarget> before = new HashSet<IDebugTarget>(Arrays.asList(this.launchManager.getDebugTargets()));
        DisplayHelper.sleep((long)1000L);
        new NodeRunDebugLaunchShortcut().launch((IEditorPart)editor, "debug");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                return TestDebug.this.launchManager.getDebugTargets().length > before.size();
            }
        }.waitForCondition(Display.getDefault(), 30000L), (String)"New Debug Target not created");
        HashSet<IDebugTarget> after = new HashSet<IDebugTarget>(Arrays.asList(this.launchManager.getDebugTargets()));
        after.removeAll(before);
        Assertions.assertEquals((int)1, (int)after.size(), (String)"Extra DebugTarget not found");
        final IDebugTarget target = (IDebugTarget)after.iterator().next();
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return target.getThreads().length > 0;
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 30000L), (String)"Debug Target shows no threads");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return Arrays.stream(target.getThreads()).anyMatch(ISuspendResume::isSuspended);
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L), (String)"No thread is suspended");
        final IThread suspendedThread = Arrays.stream(target.getThreads()).filter(ISuspendResume::isSuspended).findFirst().get();
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return suspendedThread.getStackFrames().length > 0 && suspendedThread.getStackFrames()[0].getVariables().length > 0;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L), (String)"Suspended Thread doesn't show variables");
        IVariable localVariable = suspendedThread.getStackFrames()[0].getVariables()[0];
        Assertions.assertEquals((Object)"Local", (Object)localVariable.getName());
        IVariable nVariable = Arrays.stream(localVariable.getValue().getVariables()).filter(var -> {
            try {
                return "n".equals(var.getName());
            }
            catch (DebugException e) {
                return false;
            }
        }).findAny().get();
        Assertions.assertEquals((Object)"1605", (Object)nVariable.getValue().getValueString());
    }
}

