"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
function create() {
    return {
        name: 'vue-inlay-hints-hidden-callback-param',
        create(context) {
            return {
                async provideInlayHints(document, range) {
                    const settings = {};
                    const result = [];
                    const decoded = context.decodeEmbeddedDocumentUri(document.uri);
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const vitualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (vitualCode) {
                        const start = document.offsetAt(range.start);
                        const end = document.offsetAt(range.end);
                        for (const mapping of vitualCode.mappings) {
                            const hint = mapping.data.__hint;
                            if (mapping.generatedOffsets[0] >= start
                                && mapping.generatedOffsets[mapping.generatedOffsets.length - 1] + mapping.lengths[mapping.lengths.length - 1] <= end
                                && hint) {
                                settings[hint.setting] ??= await context.env.getConfiguration?.(hint.setting) ?? false;
                                if (!settings[hint.setting]) {
                                    continue;
                                }
                                result.push({
                                    label: hint.label,
                                    paddingRight: hint.paddingRight,
                                    paddingLeft: hint.paddingLeft,
                                    position: document.positionAt(mapping.generatedOffsets[0]),
                                    kind: 2,
                                    tooltip: {
                                        kind: 'markdown',
                                        value: hint.tooltip,
                                    },
                                });
                            }
                        }
                    }
                    return result;
                },
            };
        },
    };
}
exports.create = create;
//# sourceMappingURL=vue-visualize-hidden-callback-param.js.map