import type { Disposable, DocumentSelector, FormattingOptions, ProviderResult, ServiceContext, LanguageServicePlugin } from '@volar/language-service';
import * as css from 'vscode-css-languageservice';
import { TextDocument } from 'vscode-languageserver-textdocument';
export interface Provide {
    'css/stylesheet': (document: TextDocument, ls: css.LanguageService) => css.Stylesheet;
    'css/languageService': (document: TextDocument) => css.LanguageService | undefined;
}
export declare function create({ cssDocumentSelector, scssDocumentSelector, lessDocumentSelector, useDefaultDataProvider, getDocumentContext, isFormattingEnabled, getFormattingOptions, getLanguageSettings, getCustomData, onDidChangeCustomData, }?: {
    cssDocumentSelector?: DocumentSelector;
    scssDocumentSelector?: DocumentSelector;
    lessDocumentSelector?: DocumentSelector;
    useDefaultDataProvider?: boolean;
    getDocumentContext?(context: ServiceContext): css.DocumentContext;
    isFormattingEnabled?(document: TextDocument, context: ServiceContext): ProviderResult<boolean>;
    getFormattingOptions?(document: TextDocument, options: FormattingOptions, context: ServiceContext): ProviderResult<css.CSSFormatConfiguration>;
    getLanguageSettings?(document: TextDocument, context: ServiceContext): ProviderResult<css.LanguageSettings | undefined>;
    getCustomData?(context: ServiceContext): ProviderResult<css.ICSSDataProvider[]>;
    onDidChangeCustomData?(listener: () => void, context: ServiceContext): Disposable;
}): LanguageServicePlugin;
//# sourceMappingURL=index.d.ts.map