"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
function register(htmlLs) {
    return (pugDoc, posArr) => {
        const htmlPosArr = posArr
            .map(position => pugDoc.map.getGeneratedPosition(position))
            .filter((v) => !!v);
        const htmlResult = htmlLs.getSelectionRanges(pugDoc.map.embeddedDocument, htmlPosArr);
        return (0, language_service_1.transformLocations)(htmlResult, htmlRange => pugDoc.map.getSourceRange(htmlRange));
    };
}
exports.register = register;
//# sourceMappingURL=selectionRanges.js.map