/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;

public final class IntegerEvaluator
implements IExpressionEvaluator {
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if ("int".equals(typeQualifiedName)) {
            int operandValue;
            Expression operand;
            PrefixExpression.Operator operator;
            if (expression instanceof NumberLiteral) {
                NumberLiteral numberLiteral = (NumberLiteral)expression;
                String token = numberLiteral.getToken();
                if (token.startsWith("0x")) {
                    return Integer.valueOf(token.substring(2), 16);
                }
                if (token.startsWith("0")) {
                    return Integer.valueOf(token, 8);
                }
                return Integer.valueOf(token);
            }
            if (expression instanceof PrefixExpression) {
                PrefixExpression prefixExpression = (PrefixExpression)expression;
                operator = prefixExpression.getOperator();
                operand = prefixExpression.getOperand();
                operandValue = IntegerEvaluator.getIntegerValue(context, operand);
                if (operator == PrefixExpression.Operator.PLUS) {
                    return operandValue;
                }
                if (operator == PrefixExpression.Operator.MINUS) {
                    return -operandValue;
                }
                if (operator == PrefixExpression.Operator.COMPLEMENT) {
                    return ~operandValue;
                }
            }
            if (expression instanceof PostfixExpression) {
                PostfixExpression postfixExpression = (PostfixExpression)expression;
                operator = postfixExpression.getOperator();
                operand = postfixExpression.getOperand();
                ExecutionFlowDescription flowDescription = context.getFlowDescription();
                ExpressionValue value = ExecutionFlowUtils2.getValuePrev(flowDescription, operand);
                if (value != null) {
                    operand = value.getExpression();
                }
                operandValue = IntegerEvaluator.getIntegerValue(context, operand);
                if (operator == PostfixExpression.Operator.INCREMENT) {
                    return operandValue + 1;
                }
                if (operator == PostfixExpression.Operator.DECREMENT) {
                    return operandValue - 1;
                }
            }
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                List<Expression> extendedOperands = DomGenerics.extendedOperands(infixExpression);
                int[] operands = new int[2 + extendedOperands.size()];
                operands[0] = IntegerEvaluator.getIntegerValue(context, infixExpression.getLeftOperand());
                operands[1] = IntegerEvaluator.getIntegerValue(context, infixExpression.getRightOperand());
                int i = 0;
                while (i < extendedOperands.size()) {
                    Expression operandExpression = extendedOperands.get(i);
                    operands[2 + i] = IntegerEvaluator.getIntegerValue(context, operandExpression);
                    ++i;
                }
                int value = operands[0];
                InfixExpression.Operator operator2 = infixExpression.getOperator();
                int i2 = 1;
                while (i2 < operands.length) {
                    int operand2 = operands[i2];
                    if (operator2 == InfixExpression.Operator.PLUS) {
                        value += operand2;
                    } else if (operator2 == InfixExpression.Operator.MINUS) {
                        value -= operand2;
                    } else if (operator2 == InfixExpression.Operator.TIMES) {
                        value *= operand2;
                    } else if (operator2 == InfixExpression.Operator.DIVIDE) {
                        value /= operand2;
                    } else if (operator2 == InfixExpression.Operator.REMAINDER) {
                        value %= operand2;
                    } else if (operator2 == InfixExpression.Operator.OR) {
                        value |= operand2;
                    } else if (operator2 == InfixExpression.Operator.XOR) {
                        value ^= operand2;
                    } else if (operator2 == InfixExpression.Operator.AND) {
                        value &= operand2;
                    } else if (operator2 == InfixExpression.Operator.LEFT_SHIFT) {
                        value <<= operand2;
                    } else if (operator2 == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
                        value >>= operand2;
                    } else if (operator2 == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
                        value >>>= operand2;
                    }
                    ++i2;
                }
                return value;
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static int getIntegerValue(EvaluationContext context, Expression expression) throws Exception {
        Object value = AstEvaluationEngine.evaluate(context, expression);
        if (value instanceof Character) {
            Character character = (Character)value;
            return character.charValue();
        }
        Number number = (Number)value;
        return number.intValue();
    }
}

