/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.IDropRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;

public final class BorderTransparentLayoutRequestValidator
implements ILayoutRequestValidator {
    private final Insets m_insets;

    public BorderTransparentLayoutRequestValidator(int hBorder, int vBorder) {
        this(vBorder, hBorder, vBorder, hBorder);
    }

    public BorderTransparentLayoutRequestValidator(int top, int left, int bottom, int right) {
        this.m_insets = new Insets(top, left, bottom, right);
    }

    @Override
    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        if (request.isEraseFeedback()) {
            return true;
        }
        return this.isInnerPartOfHost(host, request);
    }

    @Override
    public boolean validatePasteRequest(EditPart host, PasteRequest request) {
        if (request.isEraseFeedback()) {
            return true;
        }
        return this.isInnerPartOfHost(host, request);
    }

    @Override
    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        return true;
    }

    @Override
    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        if (request.isEraseFeedback()) {
            return true;
        }
        return this.isInnerPartOfHost(host, request);
    }

    private boolean isInnerPartOfHost(EditPart host, IDropRequest request) {
        if (host instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalHost = (GraphicalEditPart)host;
            Figure hostFigure = graphicalHost.getFigure();
            Point location = request.getLocation().getCopy();
            FigureUtils.translateAbsoluteToFigure2(hostFigure, location);
            Rectangle hostClientArea = hostFigure.getClientArea();
            return hostClientArea.getCropped(this.m_insets).contains(location);
        }
        return true;
    }
}

