/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.util.Resolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XIncludeFilter
extends EventFilter
implements Locator {
    private Hashtable extEntities = new Hashtable(5, 5.0f);
    private int ignoreCount;
    private Locator locator;
    private Stack uris = new Stack();
    private Vector inclusions = new Vector(5, 5);
    private boolean savingPrefixes;

    public XIncludeFilter(EventConsumer eventConsumer) throws SAXException {
        super(eventConsumer);
        this.setContentHandler(this);
        this.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
    }

    private void fatal(SAXParseException sAXParseException) throws SAXException {
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(this);
    }

    public String getSystemId() {
        return this.locator == null ? null : this.locator.getSystemId();
    }

    public String getPublicId() {
        return this.locator == null ? null : this.locator.getPublicId();
    }

    public int getLineNumber() {
        return this.locator == null ? -1 : this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator == null ? -1 : this.locator.getColumnNumber();
    }

    public void setSavingPrefixes(boolean bl) {
        this.savingPrefixes = bl;
    }

    public boolean isSavingPrefixes() {
        return this.savingPrefixes;
    }

    private String addMarker(String string) throws SAXException {
        if (this.locator != null && this.locator.getSystemId() != null) {
            string = this.locator.getSystemId();
        }
        if (string == null) {
            this.fatal(new SAXParseException("Entity URI is unknown", this.locator));
        }
        try {
            URL uRL = new URL(string);
            string = uRL.toString();
            if (this.inclusions.contains(string)) {
                this.fatal(new SAXParseException("XInclude, circular inclusion", this.locator));
            }
            this.inclusions.addElement(string);
            this.uris.push(uRL);
        }
        catch (IOException iOException) {
            this.fatal(new SAXParseException("parser bug: relative URI", this.locator, iOException));
        }
        return string;
    }

    private void pop(String string) {
        this.inclusions.removeElement(string);
        this.uris.pop();
    }

    public void startDocument() throws SAXException {
        this.ignoreCount = 0;
        this.addMarker(null);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.inclusions.clear();
        this.extEntities.clear();
        this.uris.clear();
        super.endDocument();
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (string.charAt(0) == '%') {
            return;
        }
        try {
            URL uRL = new URL(this.locator.getSystemId());
            string3 = new URL(uRL, string3).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.extEntities.put(string, string3);
    }

    public void startEntity(String string) throws SAXException {
        if (this.ignoreCount != 0) {
            ++this.ignoreCount;
            return;
        }
        String string2 = (String)this.extEntities.get(string);
        if (string2 != null) {
            this.addMarker(string2);
        }
        super.startEntity(string);
    }

    public void endEntity(String string) throws SAXException {
        if (this.ignoreCount != 0 && --this.ignoreCount != 0) {
            return;
        }
        String string2 = (String)this.extEntities.get(string);
        if (string2 != null) {
            this.pop(string2);
        }
        super.endEntity(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.ignoreCount != 0) {
            ++this.ignoreCount;
            return;
        }
        URL uRL = (URL)this.uris.peek();
        String string4 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (string4 == null) {
            this.uris.push(uRL);
        } else {
            if (string4.indexOf(35) != -1) {
                this.fatal(new SAXParseException("xml:base with fragment: " + string4, this.locator));
            }
            try {
                uRL = new URL(uRL, string4);
                this.uris.push(uRL);
            }
            catch (Exception exception) {
                this.fatal(new SAXParseException("xml:base with illegal uri: " + string4, this.locator, exception));
            }
        }
        if ("http://www.w3.org/2001/XInclude".equals(string) && "include".equals(string2)) {
            String string5 = attributes.getValue("href");
            String string6 = attributes.getValue("parse");
            String string7 = attributes.getValue("encoding");
            URL uRL2 = (URL)this.uris.peek();
            if (string5 == null) {
                this.fatal(new SAXParseException("XInclude missing href", this.locator));
            }
            if (string5.indexOf(35) != -1) {
                this.fatal(new SAXParseException("XInclude with fragment: " + string5, this.locator));
            }
            if (string6 == null || "xml".equals(string6)) {
                this.xinclude(uRL2, string5);
            } else if ("text".equals(string6)) {
                this.readText(uRL2, string5, string7);
            } else {
                ErrorHandler errorHandler = this.getErrorHandler();
                if (errorHandler != null) {
                    errorHandler.error(new SAXParseException("unknown XInclude parsing rule: " + string6, this.locator));
                }
            }
            ++this.ignoreCount;
        } else {
            super.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.ignoreCount != 0 && --this.ignoreCount != 0) {
            return;
        }
        this.uris.pop();
        if (!"http://www.w3.org/2001/XInclude".equals(string) || !"include".equals(string2)) {
            super.endElement(string, string2, string3);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.characters(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.processingInstruction(string, string2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.comment(cArray, n, n2);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.ignoreCount == 0) {
            super.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.ignoreCount == 0) {
            super.endCDATA();
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.startPrefixMapping(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.ignoreCount == 0) {
            super.endPrefixMapping(string);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.ignoreCount == 0) {
            super.skippedEntity(string);
        }
    }

    private void xinclude(URL uRL, String string) throws SAXException {
        Locator locator = this.locator;
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setErrorHandler(this.getErrorHandler());
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        Scrubber scrubber = new Scrubber(this);
        this.locator = null;
        EventFilter.bind(xMLReader, scrubber);
        try {
            try {
                uRL = new URL(uRL, string);
                string = uRL.toString();
                if (this.inclusions.contains(string)) {
                    this.fatal(new SAXParseException("XInclude, circular inclusion", this.locator));
                }
                this.inclusions.addElement(string);
                this.uris.push(uRL);
                xMLReader.parse(new InputSource(string));
            }
            catch (IOException iOException) {
                this.fatal(new SAXParseException(string, this.locator, iOException));
                Object var8_7 = null;
                this.pop(string);
                this.locator = locator;
            }
            Object var8_6 = null;
            this.pop(string);
            this.locator = locator;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.pop(string);
            this.locator = locator;
            throw throwable;
        }
    }

    private void readText(URL uRL, String string, String string2) throws SAXException {
        InputStream inputStream = null;
        try {
            int n;
            InputStreamReader inputStreamReader;
            char[] cArray = new char[4096];
            uRL = new URL(uRL, string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            if (string2 == null) {
                string2 = Resolver.getEncoding(uRLConnection.getContentType());
            }
            if (string2 == null) {
                ErrorHandler errorHandler = this.getErrorHandler();
                if (errorHandler != null) {
                    errorHandler.warning(new SAXParseException("guessing text encoding for URL: " + uRL, this.locator));
                }
                inputStreamReader = new InputStreamReader(inputStream);
            } else {
                inputStreamReader = new InputStreamReader(inputStream, string2);
            }
            while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                super.characters(cArray, 0, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            this.fatal(new SAXParseException("can't XInclude text", this.locator, iOException));
        }
    }

    private class Scrubber
    extends EventFilter {
        Scrubber(EventFilter eventFilter) throws SAXException {
            super(eventFilter);
            this.setContentHandler(this);
            this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.setDTDHandler(null);
            this.setProperty("http://xml.org/sax/properties/declaration-handler", null);
        }

        public void setDocumentLocator(Locator locator) {
            XIncludeFilter.this.locator = locator;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        private void reject(String string) throws SAXException {
            XIncludeFilter.this.fatal(new SAXParseException(string, XIncludeFilter.this.locator));
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.reject("XIncluded DTD: " + string3);
        }

        public void endDTD() throws SAXException {
            this.reject("XIncluded DTD");
        }

        public void skippedEntity(String string) throws SAXException {
            this.reject("XInclude skipped entity: " + string);
        }
    }
}

