/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (opts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:2:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the complexity author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The complexity program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2011-2020 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  complexity is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  complexity is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the complexity program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_OPTS_H_GUARD
#define AUTOOPTS_OPTS_H_GUARD 1
#include <autoopts/options.h>
#include <stdarg.h>
#include <stdnoreturn.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 172034
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

#if GCC_VERSION > 40400
#define NOT_REACHED __builtin_unreachable();
#else
#define NOT_REACHED
#endif

/**
 *  Enumeration of each option type for complexity
 */
typedef enum {
    INDEX_OPT_THRESHOLD             =  0,
    INDEX_OPT_HORRID_THRESHOLD      =  1,
    INDEX_OPT_NESTING_PENALTY       =  2,
    INDEX_OPT_DEMI_NESTING_PENALTY  =  3,
    INDEX_OPT_SCALE                 =  4,
    INDEX_OPT_HISTOGRAM             =  5,
    INDEX_OPT_SCORES                =  6,
    INDEX_OPT_IGNORE                =  7,
    INDEX_OPT_NO_HEADER             =  8,
    INDEX_OPT_UNIFDEF               =  9,
    INDEX_OPT_UNIF_EXE              = 10,
    INDEX_OPT_INPUT                 = 11,
    INDEX_OPT_TRACE                 = 12,
    INDEX_OPT_VERSION               = 13,
    INDEX_OPT_HELP                  = 14,
    INDEX_OPT_MORE_HELP             = 15,
    INDEX_OPT_SAVE_OPTS             = 16,
    INDEX_OPT_LOAD_OPTS             = 17
} teOptIndex;
/** count of all options for complexity */
#define OPTION_CT    18
/** complexity version */
#define COMPLEXITY_VERSION       "1.13"
/** Full complexity version text */
#define COMPLEXITY_FULL_VERSION  "complexity (GNU Complexity) 1.13"

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(THRESHOLD)
 */
#define         DESC(n) (complexityOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of complexity exit codes
 */
typedef enum {
    COMPLEXITY_EXIT_SUCCESS         = 0,
    COMPLEXITY_EXIT_FAILURE         = 1,
    COMPLEXITY_EXIT_NOMEM           = 3,
    COMPLEXITY_EXIT_HORRID_FUNCTION = 4,
    COMPLEXITY_EXIT_NO_DATA         = 5,
    COMPLEXITY_EXIT_ASSERT          = 6,
    COMPLEXITY_EXIT_BAD_FILE        = 32,
    COMPLEXITY_EXIT_USAGE_ERROR     = 64,
    COMPLEXITY_EXIT_NO_CONFIG_INPUT = 66,
    COMPLEXITY_EXIT_LIBOPTS_FAILURE = 70
}   complexity_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_THRESHOLD      't'

#define OPT_VALUE_THRESHOLD      (DESC(THRESHOLD).optArg.argInt)
#define SET_OPT_THRESHOLD(a)   STMTS( \
        DESC(THRESHOLD).optActualIndex = 0; \
        DESC(THRESHOLD).optActualValue = VALUE_OPT_THRESHOLD; \
        DESC(THRESHOLD).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(THRESHOLD).fOptState |= OPTST_SET; \
        DESC(THRESHOLD).optArg.argInt = (a); \
        (*(DESC(THRESHOLD).pOptProc))(&complexityOptions, \
                complexityOptions.pOptDesc + 0); )
#define VALUE_OPT_HORRID_THRESHOLD 0x1001

#define OPT_VALUE_HORRID_THRESHOLD (DESC(HORRID_THRESHOLD).optArg.argInt)
#define SET_OPT_HORRID_THRESHOLD(a)   STMTS( \
        DESC(HORRID_THRESHOLD).optActualIndex = 1; \
        DESC(HORRID_THRESHOLD).optActualValue = VALUE_OPT_HORRID_THRESHOLD; \
        DESC(HORRID_THRESHOLD).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(HORRID_THRESHOLD).fOptState |= OPTST_SET; \
        DESC(HORRID_THRESHOLD).optArg.argInt = (a); \
        (*(DESC(HORRID_THRESHOLD).pOptProc))(&complexityOptions, \
                complexityOptions.pOptDesc + 1); )
#define VALUE_OPT_NESTING_PENALTY 'n'
#define VALUE_OPT_DEMI_NESTING_PENALTY 0x1002
#define VALUE_OPT_SCALE          's'

#define OPT_VALUE_SCALE          (DESC(SCALE).optArg.argInt)
#define VALUE_OPT_HISTOGRAM      'h'
#define VALUE_OPT_SCORES         'c'

#define SET_OPT_SCORES   STMTS( \
        DESC(SCORES).optActualIndex = 6; \
        DESC(SCORES).optActualValue = VALUE_OPT_SCORES; \
        DESC(SCORES).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SCORES).fOptState |= OPTST_SET )
#define DISABLE_OPT_SCORES   STMTS( \
        DESC(SCORES).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SCORES).fOptState |= OPTST_SET | OPTST_DISABLED; \
        DESC(SCORES).optArg.argString = NULL )
#define VALUE_OPT_IGNORE         'I'
#define VALUE_OPT_NO_HEADER      'H'
#define VALUE_OPT_UNIFDEF        'u'
#define VALUE_OPT_UNIF_EXE       0x1003
#define VALUE_OPT_INPUT          'i'
#define VALUE_OPT_TRACE          0x1004
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          '?'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
/** option flag (value) for version-value option */
#define VALUE_OPT_VERSION       'v'
/** option flag (value) for save-opts-value option */
#define VALUE_OPT_SAVE_OPTS     '>'
/** option flag (value) for load-opts-value option */
#define VALUE_OPT_LOAD_OPTS     '<'
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).optArg.argString = (char const*)(a))
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(complexityOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(complexityOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                complexityOptions.curOptIdx = (n); \
                complexityOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*complexityOptions.pUsageProc)(&complexityOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif
/*
 *  global exported definitions
 */
#define DEFAULT_PENALTY       1.9
#define DEFAULT_SCALE         19

typedef double  score_t;
extern  score_t penalty;

#include "complexity.h"
        extern  FILE *  trace_fp;
extern  int     score_ct;
extern  char const assert_fail_fmt[];

#define CX_ASSERT(_e)   \
	if (!(_e))      \
	    die(COMPLEXITY_EXIT_ASSERT, assert_fail_fmt, \
	        __FILE__, __LINE__, #_e);


/* * * * * *
 *
 *  Declare the complexity option descriptor.
 */
extern tOptions complexityOptions;

#if defined(ENABLE_NLS)
# ifndef _
#   include <stdio.h>
#   ifndef HAVE_GETTEXT
      extern char * gettext(char const *);
#   else
#     include <libintl.h>
#   endif

# ifndef ATTRIBUTE_FORMAT_ARG
#   define ATTRIBUTE_FORMAT_ARG(_a)
# endif

static inline char* aoGetsText(char const* pz) ATTRIBUTE_FORMAT_ARG(1);
static inline char* aoGetsText(char const* pz) {
    if (pz == NULL) return NULL;
    return (char*)gettext(pz);
}
#   define _(s)  aoGetsText(s)
# endif /* _() */

# define OPT_NO_XLAT_CFG_NAMES  STMTS(complexityOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT_CFG;)
# define OPT_NO_XLAT_OPT_NAMES  STMTS(complexityOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG;)

# define OPT_XLAT_CFG_NAMES     STMTS(complexityOptions.fOptSet &= \
                                  ~(OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG);)
# define OPT_XLAT_OPT_NAMES     STMTS(complexityOptions.fOptSet &= \
                                  ~OPTPROC_NXLAT_OPT;)

#else   /* ENABLE_NLS */
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif
#endif  /* ENABLE_NLS */


noreturn extern void
vdie( int exit_code, char const * fmt, va_list);
noreturn extern void
die(  int exit_code, char const * fmt, ...);
noreturn extern void
fserr(int exit_code, char const * op, char const * fn);

/**
 * Print a COMPLEXITY_EXIT_NOMEM fatal error message and die.
 *
 * @param[in] sz     the object size that was not allocated
 * @param[in] what   what that object was going to be
 * @noreturn
 */
noreturn static inline void nomem_err(size_t sz, char const * what)
{
    char const * fmt = _("could not allocate %zu bytes for %s\n");
    die(COMPLEXITY_EXIT_NOMEM, fmt, sz, what);
}
#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_OPTS_H_GUARD */

/* opts.h ends here */
