.data	256
#if __WORDSIZE == 32
fmt_ext:
.c	"\tEXT( 0x%08x, %d, %d, 0x%08x)\n"
fmt_ext_u:
.c	"\tEXTU(0x%08x, %d, %d, 0x%08x)\n"
fmt_dep:
.c	"\tDEP( 0x%08x, %d, %d, %d, 0x%08x)\n"
#else
fmt_ext:
.c	"\tEXT( 0x%016lx, %d, %d, 0x%016lx)\n"
fmt_ext_u:
.c	"\tEXTU(0x%016lx, %d, %d, 0x%016lx)\n"
fmt_dep:
.c	"\tDEP( 0x%016lx, %ld, %d, %d, 0x%016lx)\n"
#endif
dbg_ext:
.c	" ext %lx 1 2 = %lx\n"
dbg_ext_u:
.c	"ext_u %lx 1 2 = %lx\n"
dbg_dep:
.c	" dep %lx %lx 1 2 = %lx\n"
ok:
.c	"ok\n"

#define GENERATE_TABLE		0
/* Only do it to test more combinations. The important test is to check all
 * possible bitfields, to ensure there is no incorrect code generation  */
#define EXPAND_FULL		0

#define EXTRACT(OP, R0, R1, OFF, LEN, VAL, RES)				\
	movi %R1 VAL							\
	OP %R0 %R1 OFF LEN						\
	beqi OP##R0##R1##OFF##LEN##VAL %R0 RES				\
	calli @abort							\
OP##R0##R1##OFF##LEN##VAL:
#define DEPOSIT(R0, R1, OFF, LEN, VAL, BIT, RES)			\
	movi %R1 BIT							\
	movi %R0 VAL							\
	depr %R0 %R1 OFF LEN						\
	beqi dep##R0##R1##OFF##LEN##VAL %R0 RES				\
	calli @abort							\
dep##R0##R1##OFF##LEN##VAL:

#if EXPAND_FULL
#  define OPTIONAL(OPT)			OPT
#else
#  define OPTIONAL(OPT)			/**/
#endif

#define EXT2(OP, OFF, LEN, VAL, RES, R0, R1, R2, V0, V1, V2)		\
	/* Testing same register as input output is not optional */	\
	EXTRACT(OP, R0, R0, OFF, LEN, VAL, RES)				\
	OPTIONAL(EXTRACT(OP, R0, R1, OFF, LEN, VAL, RES))		\
	EXTRACT(OP, R0, R2, OFF, LEN, VAL, RES)				\
	EXTRACT(OP, R0, V0, OFF, LEN, VAL, RES)				\
	OPTIONAL(EXTRACT(OP, R0, V1, OFF, LEN, VAL, RES))		\
	OPTIONAL(EXTRACT(OP, R0, V2, OFF, LEN, VAL, RES))
#define EXT1(OP, OFF, LEN, VAL, RES, R0, R1, R2, V0, V1, V2)		\
	EXT2(OP, OFF, LEN, VAL, RES, R0, R1, R2, V0, V1, V2)		\
	OPTIONAL(EXT2(OP, OFF, LEN, VAL, RES, R1, R2, V0, V1, V2, R0))	\
	OPTIONAL(EXT2(OP, OFF, LEN, VAL, RES, R2, V0, V1, V2, R0, R1))	\
	OPTIONAL(EXT2(OP, OFF, LEN, VAL, RES, V0, V1, V2, R0, R1, R2))	\
	OPTIONAL(EXT2(OP, OFF, LEN, VAL, RES, V1, V2, R0, R1, R2, V0))	\
	OPTIONAL(EXT2(OP, OFF, LEN, VAL, RES, V2, R0, R1, R2, V0, V1))

#define DEP2(OFF, LEN, VAL, BIT, RES, R0, R1, R2, V0, V1, V2)		\
	DEPOSIT(R0, R1, OFF, LEN, VAL, BIT, RES)			\
	OPTIONAL(DEPOSIT(R0, R2, OFF, LEN, VAL, BIT, RES))		\
	DEPOSIT(R0, V0, OFF, LEN, VAL, BIT, RES)			\
	OPTIONAL(DEPOSIT(R0, V1, OFF, LEN, VAL, BIT, RES))		\
	OPTIONAL(DEPOSIT(R0, V2, OFF, LEN, VAL, BIT, RES))
#define DEP1(OFF, LEN, VAL, BIT, RES, R0, R1, R2, V0, V1, V2)		\
	DEP2(OFF, LEN, VAL, BIT, RES, R0, R1, R2, V0, V1, V2)		\
	OPTIONAL(DEP2(OFF, LEN, VAL, BIT, RES, R1, R2, V0, V1, V2, R0))	\
	OPTIONAL(DEP2(OFF, LEN, VAL, BIT, RES, R2, V0, V1, V2, R0, R1))	\
	OPTIONAL(DEP2(OFF, LEN, VAL, BIT, RES, V0, V1, V2, R0, R1, R2))	\
	OPTIONAL(DEP2(OFF, LEN, VAL, BIT, RES, V1, V2, R0, R1, R2, V0))	\
	OPTIONAL(DEP2(OFF, LEN, VAL, BIT, RES, V2, R0, R1, R2, V0, V1))

#define EXT(VAL, OFF, LEN, RES)						\
	EXT1(extr, OFF, LEN, VAL, RES, r0, r1, r2, v0, v1, v2)
#define EXTU(VAL, OFF, LEN, RES)					\
	EXT1(extr_u, OFF, LEN, VAL, RES, r0, r1, r2, v0, v1, v2)
#define DEP(VAL, BIT, OFF, LEN, RES)					\
	DEP1(OFF, LEN, VAL, BIT, RES, r0, r1, r2, v0, v1, v2)

.code
	jmpi main

/*
 *	jit_word_t ext(jit_word_t val, int base, int len) {
 *		assert(base >= 0 && len >= 1 && base + len <= __WORDSIZE);
 *	#if __BYTE_ORDER == __BIG_ENDIAN
 *		base = __WORDSIZE - (base + len);
 *	#endif
 *		jit_word_t res = val << (__WORDSIZE - (base + len));
 *		return (res >> (__WORDSIZE - len));
 *	} 
 */
name	func_ext
func_ext:
	prolog
	arg $val
	arg $base
	arg $len
	getarg %r0 $val		// r0 = val
	getarg %r1 $base	// r1 = base
	getarg %r2 $len		// r2 = len
#ifndef NDEBUG
	blti func_ext_assert %r1 0
	blti func_ext_assert %r2 1
#endif
#if __BYTE_ORDER == __BIG_ENDIAN
	addr %r1 %r1 %r2
	rsbi %r1 %r1 __WORDSIZE
#endif
	addr %r1 %r1 %r2	// r1 = base + len
#ifndef NDEBUG
#if __BYTE_ORDER == __BIG_ENDIAN
	blei func_ext_ok %r1 __WORDSIZE
#else
	blti func_ext_ok %r1 __WORDSIZE
#endif
func_ext_assert:
	calli @abort
func_ext_ok:
#endif
	rsbi %r1 %r1 __WORDSIZE	// r1 = __WORDSIZE - r1
	lshr %r0 %r0 %r1	// r0 = val << r1
	rsbi %r2 %r2 __WORDSIZE
	rshr %r0 %r0 %r2	// r0 >>= r2
	retr %r0
	epilog

/*
 *	jit_uword_t ext_u(jit_uword_t val, int base, int len) {
 *		assert(base >= 0 && len >= 1 && base + len <= __WORDSIZE);
 *	#if __BYTE_ORDER == __BIG_ENDIAN
 *		base = __WORDSIZE - (base + len);
 *	#endif
 *		jit_uword_t res = val << (__WORDSIZE - (base + len));
 *		return (res >> (__WORDSIZE - len));
 *	} 
 */
name	func_ext_u
func_ext_u:
	prolog
	arg $val
	arg $base
	arg $len
	getarg %r0 $val		// r0 = val
	getarg %r1 $base	// r1 = base
	getarg %r2 $len		// r2 = len
#ifndef NDEBUG
	blti func_ext_u_assert %r1 0
	blti func_ext_u_assert %r2 1
#endif
#if __BYTE_ORDER == __BIG_ENDIAN
	addr %r1 %r1 %r2
	rsbi %r1 %r1 __WORDSIZE
#endif
	addr %r1 %r1 %r2	// r1 = base + len
#ifndef NDEBUG
#if __BYTE_ORDER == __BIG_ENDIAN
	blei func_ext_u_ok %r2 __WORDSIZE
#else
	blti func_ext_u_ok %r2 __WORDSIZE
#endif
func_ext_u_assert:
	calli @abort
func_ext_u_ok:
#endif
	rsbi %r1 %r1 __WORDSIZE	// r1 = __WORDSIZE - r1
	lshr %r0 %r0 %r1	// r0 = val << r1
	rsbi %r2 %r2 __WORDSIZE
	rshr_u %r0 %r0 %r2	// r0 >>= r2
	retr %r0
	epilog

/*
 *	jit_word_t dep(jit_word_t res, jit_uword_t val, int base, int len) {
 *		assert(base >= 0 && len >= 1 && base + len <= __WORDSIZE);
 *	#if __BYTE_ORDER == __BIG_ENDIAN
 *		base = __WORDSIZE - (base + len);
 *	#endif
 *		jit_word_t	mask = (1 << len) - 1;
 *		val &= mask;
 *		val <<= base;
 *		mask <<= base;
 *		res &= ~mask;
 *		return (res | val);
 *	} 
 */
name	func_dep
func_dep:
	prolog
	arg $res
	arg $val
	arg $base
	arg $len
	getarg %r0 $res
	getarg %r1 $val
	getarg %v0 $base
	getarg %v1 $len
#ifndef NDEBUG
	blti func_dep_assert %v0 0
	blti func_dep_assert %v1 1
#if __BYTE_ORDER == __BIG_ENDIAN
	addr %v0 %v0 %v1
	rsbi %v0 %v0 __WORDSIZE
#endif
	addr %r2 %v0 %v1
#if __BYTE_ORDER == __BIG_ENDIAN
	blei func_dep_ok %r2 __WORDSIZE
#else
	blti func_dep_ok %r2 __WORDSIZE
#endif
func_dep_assert:
	calli @abort
func_dep_ok:
#endif
	movi %r2 1			// r2 = 1
	lshr %r2 %r2 %v1		// r2 = 1 << base
	subi %r2 %r2 1			// r2 = (1 << base) - 1
	andr %r1 %r1 %r2		// val &= mask
	lshr %r1 %r1 %v0		// val <<= base
	lshr %r2 %r2 %v0		// mask <<= base
	comr %r2 %r2			// mask = ~mask
	andr %r0 %r0 %r2		// res &= mask
	orr %r0 %r0 %r1			// res |= val
	retr %r0
	epilog

#if GENERATE_TABLE
	name main
main:
	prolog

#  if __WORDSIZE == 32
	movi %v0 0xa5a5a5a5
#  else
	movi %v0 0xa5a5a5a5a5a5a5a5
#  endif
	movi %v1 0
	movi %v2 1

loop:
	subi %v0 %v0 1
	prepare
		pushargr %v0
		pushargr %v1
		pushargr %v2
	finishi func_ext
	retval %r0
	prepare
		pushargi fmt_ext
		ellipsis
		pushargr %v0
		pushargr %v1
		pushargr %v2
		pushargr %r0
	finishi @printf

	prepare
		pushargr %v0
		pushargr %v1
		pushargr %v2
	finishi func_ext_u
	retval %r0
	prepare
		pushargi fmt_ext_u
		ellipsis
		pushargr %v0
		pushargr %v1
		pushargr %v2
		pushargr %r0
	finishi @printf

	movi %r1 1
	subi %r2 %v2 1
	lshr %r1 %r1 %r2
	subi %r1 %r1 1
	prepare
		pushargr %v0
		pushargr %r1
		pushargr %v1
		pushargr %v2
	finishi func_dep
	retval %r0
	movi %r1 1
	subi %r2 %v2 1
	lshr %r1 %r1 %r2
	subi %r1 %r1 1
	prepare
		pushargi fmt_dep
		ellipsis
		pushargr %v0
		pushargr %r1
		pushargr %v1
		pushargr %v2
		pushargr %r0
	finishi @printf

	addi %v2 %v2 1
	addr %r0 %v1 %v2
	blti loop %r0 __WORDSIZE
	addi %v1 %v1 1
	bgei done %v1 $(__WORDSIZE - 1)
	movi %v2 1
	jmpi loop
done:
	ret
	epilog
#else
	name main
main:
	prolog

/*  Simple encoding debug */
#if 0
	movi %v0 0x12345678
	extr %v1 %v0 1 2
	prepare
		pushargi dbg_ext
		ellipsis
		pushargr %v0
		pushargr %v1
	finishi @printf
	extr_u %v1 %v0 1 2
	prepare
		pushargi dbg_ext_u
		ellipsis
		pushargr %v0
		pushargr %v1
	finishi @printf
	movi %v1 1
	depr %v0 %v1 1 2
	prepare
		pushargi dbg_dep
		ellipsis
		pushargi 0xffffffff
		pushargi 1
		pushargr %v0
	finishi @printf
#else

#  if __WORDSIZE == 32
#    if __BYTE_ORDER == __LITTLE_ENDIAN
	EXT( 0xa5a5a5a4, 0, 1, 0x00000000)
	EXTU(0xa5a5a5a4, 0, 1, 0x00000000)
	DEP( 0xa5a5a5a4, 0, 0, 1, 0xa5a5a5a4)
	EXT( 0xa5a5a5a3, 0, 2, 0xffffffff)
	EXTU(0xa5a5a5a3, 0, 2, 0x00000003)
	DEP( 0xa5a5a5a3, 1, 0, 2, 0xa5a5a5a1)
	EXT( 0xa5a5a5a2, 0, 3, 0x00000002)
	EXTU(0xa5a5a5a2, 0, 3, 0x00000002)
	DEP( 0xa5a5a5a2, 3, 0, 3, 0xa5a5a5a3)
	EXT( 0xa5a5a5a1, 0, 4, 0x00000001)
	EXTU(0xa5a5a5a1, 0, 4, 0x00000001)
	DEP( 0xa5a5a5a1, 7, 0, 4, 0xa5a5a5a7)
	EXT( 0xa5a5a5a0, 0, 5, 0x00000000)
	EXTU(0xa5a5a5a0, 0, 5, 0x00000000)
	DEP( 0xa5a5a5a0, 15, 0, 5, 0xa5a5a5af)
	EXT( 0xa5a5a59f, 0, 6, 0x0000001f)
	EXTU(0xa5a5a59f, 0, 6, 0x0000001f)
	DEP( 0xa5a5a59f, 31, 0, 6, 0xa5a5a59f)
	EXT( 0xa5a5a59e, 0, 7, 0x0000001e)
	EXTU(0xa5a5a59e, 0, 7, 0x0000001e)
	DEP( 0xa5a5a59e, 63, 0, 7, 0xa5a5a5bf)
	EXT( 0xa5a5a59d, 0, 8, 0xffffff9d)
	EXTU(0xa5a5a59d, 0, 8, 0x0000009d)
	DEP( 0xa5a5a59d, 127, 0, 8, 0xa5a5a57f)
	EXT( 0xa5a5a59c, 0, 9, 0xffffff9c)
	EXTU(0xa5a5a59c, 0, 9, 0x0000019c)
	DEP( 0xa5a5a59c, 255, 0, 9, 0xa5a5a4ff)
	EXT( 0xa5a5a59b, 0, 10, 0x0000019b)
	EXTU(0xa5a5a59b, 0, 10, 0x0000019b)
	DEP( 0xa5a5a59b, 511, 0, 10, 0xa5a5a5ff)
	EXT( 0xa5a5a59a, 0, 11, 0xfffffd9a)
	EXTU(0xa5a5a59a, 0, 11, 0x0000059a)
	DEP( 0xa5a5a59a, 1023, 0, 11, 0xa5a5a3ff)
	EXT( 0xa5a5a599, 0, 12, 0x00000599)
	EXTU(0xa5a5a599, 0, 12, 0x00000599)
	DEP( 0xa5a5a599, 2047, 0, 12, 0xa5a5a7ff)
	EXT( 0xa5a5a598, 0, 13, 0x00000598)
	EXTU(0xa5a5a598, 0, 13, 0x00000598)
	DEP( 0xa5a5a598, 4095, 0, 13, 0xa5a5afff)
	EXT( 0xa5a5a597, 0, 14, 0xffffe597)
	EXTU(0xa5a5a597, 0, 14, 0x00002597)
	DEP( 0xa5a5a597, 8191, 0, 14, 0xa5a59fff)
	EXT( 0xa5a5a596, 0, 15, 0x00002596)
	EXTU(0xa5a5a596, 0, 15, 0x00002596)
	DEP( 0xa5a5a596, 16383, 0, 15, 0xa5a5bfff)
	EXT( 0xa5a5a595, 0, 16, 0xffffa595)
	EXTU(0xa5a5a595, 0, 16, 0x0000a595)
	DEP( 0xa5a5a595, 32767, 0, 16, 0xa5a57fff)
	EXT( 0xa5a5a594, 0, 17, 0xffffa594)
	EXTU(0xa5a5a594, 0, 17, 0x0001a594)
	DEP( 0xa5a5a594, 65535, 0, 17, 0xa5a4ffff)
	EXT( 0xa5a5a593, 0, 18, 0x0001a593)
	EXTU(0xa5a5a593, 0, 18, 0x0001a593)
	DEP( 0xa5a5a593, 131071, 0, 18, 0xa5a5ffff)
	EXT( 0xa5a5a592, 0, 19, 0xfffda592)
	EXTU(0xa5a5a592, 0, 19, 0x0005a592)
	DEP( 0xa5a5a592, 262143, 0, 19, 0xa5a3ffff)
	EXT( 0xa5a5a591, 0, 20, 0x0005a591)
	EXTU(0xa5a5a591, 0, 20, 0x0005a591)
	DEP( 0xa5a5a591, 524287, 0, 20, 0xa5a7ffff)
	EXT( 0xa5a5a590, 0, 21, 0x0005a590)
	EXTU(0xa5a5a590, 0, 21, 0x0005a590)
	DEP( 0xa5a5a590, 1048575, 0, 21, 0xa5afffff)
	EXT( 0xa5a5a58f, 0, 22, 0xffe5a58f)
	EXTU(0xa5a5a58f, 0, 22, 0x0025a58f)
	DEP( 0xa5a5a58f, 2097151, 0, 22, 0xa59fffff)
	EXT( 0xa5a5a58e, 0, 23, 0x0025a58e)
	EXTU(0xa5a5a58e, 0, 23, 0x0025a58e)
	DEP( 0xa5a5a58e, 4194303, 0, 23, 0xa5bfffff)
	EXT( 0xa5a5a58d, 0, 24, 0xffa5a58d)
	EXTU(0xa5a5a58d, 0, 24, 0x00a5a58d)
	DEP( 0xa5a5a58d, 8388607, 0, 24, 0xa57fffff)
	EXT( 0xa5a5a58c, 0, 25, 0xffa5a58c)
	EXTU(0xa5a5a58c, 0, 25, 0x01a5a58c)
	DEP( 0xa5a5a58c, 16777215, 0, 25, 0xa4ffffff)
	EXT( 0xa5a5a58b, 0, 26, 0x01a5a58b)
	EXTU(0xa5a5a58b, 0, 26, 0x01a5a58b)
	DEP( 0xa5a5a58b, 33554431, 0, 26, 0xa5ffffff)
	EXT( 0xa5a5a58a, 0, 27, 0xfda5a58a)
	EXTU(0xa5a5a58a, 0, 27, 0x05a5a58a)
	DEP( 0xa5a5a58a, 67108863, 0, 27, 0xa3ffffff)
	EXT( 0xa5a5a589, 0, 28, 0x05a5a589)
	EXTU(0xa5a5a589, 0, 28, 0x05a5a589)
	DEP( 0xa5a5a589, 134217727, 0, 28, 0xa7ffffff)
	EXT( 0xa5a5a588, 0, 29, 0x05a5a588)
	EXTU(0xa5a5a588, 0, 29, 0x05a5a588)
	DEP( 0xa5a5a588, 268435455, 0, 29, 0xafffffff)
	EXT( 0xa5a5a587, 0, 30, 0xe5a5a587)
	EXTU(0xa5a5a587, 0, 30, 0x25a5a587)
	DEP( 0xa5a5a587, 536870911, 0, 30, 0x9fffffff)
	EXT( 0xa5a5a586, 0, 31, 0x25a5a586)
	EXTU(0xa5a5a586, 0, 31, 0x25a5a586)
	DEP( 0xa5a5a586, 1073741823, 0, 31, 0xbfffffff)
	EXT( 0xa5a5a585, 1, 1, 0x00000000)
	EXTU(0xa5a5a585, 1, 1, 0x00000000)
	DEP( 0xa5a5a585, 0, 1, 1, 0xa5a5a585)
	EXT( 0xa5a5a584, 1, 2, 0xfffffffe)
	EXTU(0xa5a5a584, 1, 2, 0x00000002)
	DEP( 0xa5a5a584, 1, 1, 2, 0xa5a5a582)
	EXT( 0xa5a5a583, 1, 3, 0x00000001)
	EXTU(0xa5a5a583, 1, 3, 0x00000001)
	DEP( 0xa5a5a583, 3, 1, 3, 0xa5a5a587)
	EXT( 0xa5a5a582, 1, 4, 0x00000001)
	EXTU(0xa5a5a582, 1, 4, 0x00000001)
	DEP( 0xa5a5a582, 7, 1, 4, 0xa5a5a58e)
	EXT( 0xa5a5a581, 1, 5, 0x00000000)
	EXTU(0xa5a5a581, 1, 5, 0x00000000)
	DEP( 0xa5a5a581, 15, 1, 5, 0xa5a5a59f)
	EXT( 0xa5a5a580, 1, 6, 0x00000000)
	EXTU(0xa5a5a580, 1, 6, 0x00000000)
	DEP( 0xa5a5a580, 31, 1, 6, 0xa5a5a5be)
	EXT( 0xa5a5a57f, 1, 7, 0x0000003f)
	EXTU(0xa5a5a57f, 1, 7, 0x0000003f)
	DEP( 0xa5a5a57f, 63, 1, 7, 0xa5a5a57f)
	EXT( 0xa5a5a57e, 1, 8, 0xffffffbf)
	EXTU(0xa5a5a57e, 1, 8, 0x000000bf)
	DEP( 0xa5a5a57e, 127, 1, 8, 0xa5a5a4fe)
	EXT( 0xa5a5a57d, 1, 9, 0x000000be)
	EXTU(0xa5a5a57d, 1, 9, 0x000000be)
	DEP( 0xa5a5a57d, 255, 1, 9, 0xa5a5a5ff)
	EXT( 0xa5a5a57c, 1, 10, 0xfffffebe)
	EXTU(0xa5a5a57c, 1, 10, 0x000002be)
	DEP( 0xa5a5a57c, 511, 1, 10, 0xa5a5a3fe)
	EXT( 0xa5a5a57b, 1, 11, 0x000002bd)
	EXTU(0xa5a5a57b, 1, 11, 0x000002bd)
	DEP( 0xa5a5a57b, 1023, 1, 11, 0xa5a5a7ff)
	EXT( 0xa5a5a57a, 1, 12, 0x000002bd)
	EXTU(0xa5a5a57a, 1, 12, 0x000002bd)
	DEP( 0xa5a5a57a, 2047, 1, 12, 0xa5a5affe)
	EXT( 0xa5a5a579, 1, 13, 0xfffff2bc)
	EXTU(0xa5a5a579, 1, 13, 0x000012bc)
	DEP( 0xa5a5a579, 4095, 1, 13, 0xa5a59fff)
	EXT( 0xa5a5a578, 1, 14, 0x000012bc)
	EXTU(0xa5a5a578, 1, 14, 0x000012bc)
	DEP( 0xa5a5a578, 8191, 1, 14, 0xa5a5bffe)
	EXT( 0xa5a5a577, 1, 15, 0xffffd2bb)
	EXTU(0xa5a5a577, 1, 15, 0x000052bb)
	DEP( 0xa5a5a577, 16383, 1, 15, 0xa5a57fff)
	EXT( 0xa5a5a576, 1, 16, 0xffffd2bb)
	EXTU(0xa5a5a576, 1, 16, 0x0000d2bb)
	DEP( 0xa5a5a576, 32767, 1, 16, 0xa5a4fffe)
	EXT( 0xa5a5a575, 1, 17, 0x0000d2ba)
	EXTU(0xa5a5a575, 1, 17, 0x0000d2ba)
	DEP( 0xa5a5a575, 65535, 1, 17, 0xa5a5ffff)
	EXT( 0xa5a5a574, 1, 18, 0xfffed2ba)
	EXTU(0xa5a5a574, 1, 18, 0x0002d2ba)
	DEP( 0xa5a5a574, 131071, 1, 18, 0xa5a3fffe)
	EXT( 0xa5a5a573, 1, 19, 0x0002d2b9)
	EXTU(0xa5a5a573, 1, 19, 0x0002d2b9)
	DEP( 0xa5a5a573, 262143, 1, 19, 0xa5a7ffff)
	EXT( 0xa5a5a572, 1, 20, 0x0002d2b9)
	EXTU(0xa5a5a572, 1, 20, 0x0002d2b9)
	DEP( 0xa5a5a572, 524287, 1, 20, 0xa5affffe)
	EXT( 0xa5a5a571, 1, 21, 0xfff2d2b8)
	EXTU(0xa5a5a571, 1, 21, 0x0012d2b8)
	DEP( 0xa5a5a571, 1048575, 1, 21, 0xa59fffff)
	EXT( 0xa5a5a570, 1, 22, 0x0012d2b8)
	EXTU(0xa5a5a570, 1, 22, 0x0012d2b8)
	DEP( 0xa5a5a570, 2097151, 1, 22, 0xa5bffffe)
	EXT( 0xa5a5a56f, 1, 23, 0xffd2d2b7)
	EXTU(0xa5a5a56f, 1, 23, 0x0052d2b7)
	DEP( 0xa5a5a56f, 4194303, 1, 23, 0xa57fffff)
	EXT( 0xa5a5a56e, 1, 24, 0xffd2d2b7)
	EXTU(0xa5a5a56e, 1, 24, 0x00d2d2b7)
	DEP( 0xa5a5a56e, 8388607, 1, 24, 0xa4fffffe)
	EXT( 0xa5a5a56d, 1, 25, 0x00d2d2b6)
	EXTU(0xa5a5a56d, 1, 25, 0x00d2d2b6)
	DEP( 0xa5a5a56d, 16777215, 1, 25, 0xa5ffffff)
	EXT( 0xa5a5a56c, 1, 26, 0xfed2d2b6)
	EXTU(0xa5a5a56c, 1, 26, 0x02d2d2b6)
	DEP( 0xa5a5a56c, 33554431, 1, 26, 0xa3fffffe)
	EXT( 0xa5a5a56b, 1, 27, 0x02d2d2b5)
	EXTU(0xa5a5a56b, 1, 27, 0x02d2d2b5)
	DEP( 0xa5a5a56b, 67108863, 1, 27, 0xa7ffffff)
	EXT( 0xa5a5a56a, 1, 28, 0x02d2d2b5)
	EXTU(0xa5a5a56a, 1, 28, 0x02d2d2b5)
	DEP( 0xa5a5a56a, 134217727, 1, 28, 0xaffffffe)
	EXT( 0xa5a5a569, 1, 29, 0xf2d2d2b4)
	EXTU(0xa5a5a569, 1, 29, 0x12d2d2b4)
	DEP( 0xa5a5a569, 268435455, 1, 29, 0x9fffffff)
	EXT( 0xa5a5a568, 1, 30, 0x12d2d2b4)
	EXTU(0xa5a5a568, 1, 30, 0x12d2d2b4)
	DEP( 0xa5a5a568, 536870911, 1, 30, 0xbffffffe)
	EXT( 0xa5a5a567, 2, 1, 0xffffffff)
	EXTU(0xa5a5a567, 2, 1, 0x00000001)
	DEP( 0xa5a5a567, 0, 2, 1, 0xa5a5a563)
	EXT( 0xa5a5a566, 2, 2, 0x00000001)
	EXTU(0xa5a5a566, 2, 2, 0x00000001)
	DEP( 0xa5a5a566, 1, 2, 2, 0xa5a5a566)
	EXT( 0xa5a5a565, 2, 3, 0x00000001)
	EXTU(0xa5a5a565, 2, 3, 0x00000001)
	DEP( 0xa5a5a565, 3, 2, 3, 0xa5a5a56d)
	EXT( 0xa5a5a564, 2, 4, 0xfffffff9)
	EXTU(0xa5a5a564, 2, 4, 0x00000009)
	DEP( 0xa5a5a564, 7, 2, 4, 0xa5a5a55c)
	EXT( 0xa5a5a563, 2, 5, 0xfffffff8)
	EXTU(0xa5a5a563, 2, 5, 0x00000018)
	DEP( 0xa5a5a563, 15, 2, 5, 0xa5a5a53f)
	EXT( 0xa5a5a562, 2, 6, 0x00000018)
	EXTU(0xa5a5a562, 2, 6, 0x00000018)
	DEP( 0xa5a5a562, 31, 2, 6, 0xa5a5a57e)
	EXT( 0xa5a5a561, 2, 7, 0xffffffd8)
	EXTU(0xa5a5a561, 2, 7, 0x00000058)
	DEP( 0xa5a5a561, 63, 2, 7, 0xa5a5a4fd)
	EXT( 0xa5a5a560, 2, 8, 0x00000058)
	EXTU(0xa5a5a560, 2, 8, 0x00000058)
	DEP( 0xa5a5a560, 127, 2, 8, 0xa5a5a5fc)
	EXT( 0xa5a5a55f, 2, 9, 0xffffff57)
	EXTU(0xa5a5a55f, 2, 9, 0x00000157)
	DEP( 0xa5a5a55f, 255, 2, 9, 0xa5a5a3ff)
	EXT( 0xa5a5a55e, 2, 10, 0x00000157)
	EXTU(0xa5a5a55e, 2, 10, 0x00000157)
	DEP( 0xa5a5a55e, 511, 2, 10, 0xa5a5a7fe)
	EXT( 0xa5a5a55d, 2, 11, 0x00000157)
	EXTU(0xa5a5a55d, 2, 11, 0x00000157)
	DEP( 0xa5a5a55d, 1023, 2, 11, 0xa5a5affd)
	EXT( 0xa5a5a55c, 2, 12, 0xfffff957)
	EXTU(0xa5a5a55c, 2, 12, 0x00000957)
	DEP( 0xa5a5a55c, 2047, 2, 12, 0xa5a59ffc)
	EXT( 0xa5a5a55b, 2, 13, 0x00000956)
	EXTU(0xa5a5a55b, 2, 13, 0x00000956)
	DEP( 0xa5a5a55b, 4095, 2, 13, 0xa5a5bfff)
	EXT( 0xa5a5a55a, 2, 14, 0xffffe956)
	EXTU(0xa5a5a55a, 2, 14, 0x00002956)
	DEP( 0xa5a5a55a, 8191, 2, 14, 0xa5a57ffe)
	EXT( 0xa5a5a559, 2, 15, 0xffffe956)
	EXTU(0xa5a5a559, 2, 15, 0x00006956)
	DEP( 0xa5a5a559, 16383, 2, 15, 0xa5a4fffd)
	EXT( 0xa5a5a558, 2, 16, 0x00006956)
	EXTU(0xa5a5a558, 2, 16, 0x00006956)
	DEP( 0xa5a5a558, 32767, 2, 16, 0xa5a5fffc)
	EXT( 0xa5a5a557, 2, 17, 0xffff6955)
	EXTU(0xa5a5a557, 2, 17, 0x00016955)
	DEP( 0xa5a5a557, 65535, 2, 17, 0xa5a3ffff)
	EXT( 0xa5a5a556, 2, 18, 0x00016955)
	EXTU(0xa5a5a556, 2, 18, 0x00016955)
	DEP( 0xa5a5a556, 131071, 2, 18, 0xa5a7fffe)
	EXT( 0xa5a5a555, 2, 19, 0x00016955)
	EXTU(0xa5a5a555, 2, 19, 0x00016955)
	DEP( 0xa5a5a555, 262143, 2, 19, 0xa5affffd)
	EXT( 0xa5a5a554, 2, 20, 0xfff96955)
	EXTU(0xa5a5a554, 2, 20, 0x00096955)
	DEP( 0xa5a5a554, 524287, 2, 20, 0xa59ffffc)
	EXT( 0xa5a5a553, 2, 21, 0x00096954)
	EXTU(0xa5a5a553, 2, 21, 0x00096954)
	DEP( 0xa5a5a553, 1048575, 2, 21, 0xa5bfffff)
	EXT( 0xa5a5a552, 2, 22, 0xffe96954)
	EXTU(0xa5a5a552, 2, 22, 0x00296954)
	DEP( 0xa5a5a552, 2097151, 2, 22, 0xa57ffffe)
	EXT( 0xa5a5a551, 2, 23, 0xffe96954)
	EXTU(0xa5a5a551, 2, 23, 0x00696954)
	DEP( 0xa5a5a551, 4194303, 2, 23, 0xa4fffffd)
	EXT( 0xa5a5a550, 2, 24, 0x00696954)
	EXTU(0xa5a5a550, 2, 24, 0x00696954)
	DEP( 0xa5a5a550, 8388607, 2, 24, 0xa5fffffc)
	EXT( 0xa5a5a54f, 2, 25, 0xff696953)
	EXTU(0xa5a5a54f, 2, 25, 0x01696953)
	DEP( 0xa5a5a54f, 16777215, 2, 25, 0xa3ffffff)
	EXT( 0xa5a5a54e, 2, 26, 0x01696953)
	EXTU(0xa5a5a54e, 2, 26, 0x01696953)
	DEP( 0xa5a5a54e, 33554431, 2, 26, 0xa7fffffe)
	EXT( 0xa5a5a54d, 2, 27, 0x01696953)
	EXTU(0xa5a5a54d, 2, 27, 0x01696953)
	DEP( 0xa5a5a54d, 67108863, 2, 27, 0xaffffffd)
	EXT( 0xa5a5a54c, 2, 28, 0xf9696953)
	EXTU(0xa5a5a54c, 2, 28, 0x09696953)
	DEP( 0xa5a5a54c, 134217727, 2, 28, 0x9ffffffc)
	EXT( 0xa5a5a54b, 2, 29, 0x09696952)
	EXTU(0xa5a5a54b, 2, 29, 0x09696952)
	DEP( 0xa5a5a54b, 268435455, 2, 29, 0xbfffffff)
	EXT( 0xa5a5a54a, 3, 1, 0xffffffff)
	EXTU(0xa5a5a54a, 3, 1, 0x00000001)
	DEP( 0xa5a5a54a, 0, 3, 1, 0xa5a5a542)
	EXT( 0xa5a5a549, 3, 2, 0x00000001)
	EXTU(0xa5a5a549, 3, 2, 0x00000001)
	DEP( 0xa5a5a549, 1, 3, 2, 0xa5a5a549)
	EXT( 0xa5a5a548, 3, 3, 0x00000001)
	EXTU(0xa5a5a548, 3, 3, 0x00000001)
	DEP( 0xa5a5a548, 3, 3, 3, 0xa5a5a558)
	EXT( 0xa5a5a547, 3, 4, 0xfffffff8)
	EXTU(0xa5a5a547, 3, 4, 0x00000008)
	DEP( 0xa5a5a547, 7, 3, 4, 0xa5a5a53f)
	EXT( 0xa5a5a546, 3, 5, 0x00000008)
	EXTU(0xa5a5a546, 3, 5, 0x00000008)
	DEP( 0xa5a5a546, 15, 3, 5, 0xa5a5a57e)
	EXT( 0xa5a5a545, 3, 6, 0xffffffe8)
	EXTU(0xa5a5a545, 3, 6, 0x00000028)
	DEP( 0xa5a5a545, 31, 3, 6, 0xa5a5a4fd)
	EXT( 0xa5a5a544, 3, 7, 0x00000028)
	EXTU(0xa5a5a544, 3, 7, 0x00000028)
	DEP( 0xa5a5a544, 63, 3, 7, 0xa5a5a5fc)
	EXT( 0xa5a5a543, 3, 8, 0xffffffa8)
	EXTU(0xa5a5a543, 3, 8, 0x000000a8)
	DEP( 0xa5a5a543, 127, 3, 8, 0xa5a5a3fb)
	EXT( 0xa5a5a542, 3, 9, 0x000000a8)
	EXTU(0xa5a5a542, 3, 9, 0x000000a8)
	DEP( 0xa5a5a542, 255, 3, 9, 0xa5a5a7fa)
	EXT( 0xa5a5a541, 3, 10, 0x000000a8)
	EXTU(0xa5a5a541, 3, 10, 0x000000a8)
	DEP( 0xa5a5a541, 511, 3, 10, 0xa5a5aff9)
	EXT( 0xa5a5a540, 3, 11, 0xfffffca8)
	EXTU(0xa5a5a540, 3, 11, 0x000004a8)
	DEP( 0xa5a5a540, 1023, 3, 11, 0xa5a59ff8)
	EXT( 0xa5a5a53f, 3, 12, 0x000004a7)
	EXTU(0xa5a5a53f, 3, 12, 0x000004a7)
	DEP( 0xa5a5a53f, 2047, 3, 12, 0xa5a5bfff)
	EXT( 0xa5a5a53e, 3, 13, 0xfffff4a7)
	EXTU(0xa5a5a53e, 3, 13, 0x000014a7)
	DEP( 0xa5a5a53e, 4095, 3, 13, 0xa5a57ffe)
	EXT( 0xa5a5a53d, 3, 14, 0xfffff4a7)
	EXTU(0xa5a5a53d, 3, 14, 0x000034a7)
	DEP( 0xa5a5a53d, 8191, 3, 14, 0xa5a4fffd)
	EXT( 0xa5a5a53c, 3, 15, 0x000034a7)
	EXTU(0xa5a5a53c, 3, 15, 0x000034a7)
	DEP( 0xa5a5a53c, 16383, 3, 15, 0xa5a5fffc)
	EXT( 0xa5a5a53b, 3, 16, 0xffffb4a7)
	EXTU(0xa5a5a53b, 3, 16, 0x0000b4a7)
	DEP( 0xa5a5a53b, 32767, 3, 16, 0xa5a3fffb)
	EXT( 0xa5a5a53a, 3, 17, 0x0000b4a7)
	EXTU(0xa5a5a53a, 3, 17, 0x0000b4a7)
	DEP( 0xa5a5a53a, 65535, 3, 17, 0xa5a7fffa)
	EXT( 0xa5a5a539, 3, 18, 0x0000b4a7)
	EXTU(0xa5a5a539, 3, 18, 0x0000b4a7)
	DEP( 0xa5a5a539, 131071, 3, 18, 0xa5affff9)
	EXT( 0xa5a5a538, 3, 19, 0xfffcb4a7)
	EXTU(0xa5a5a538, 3, 19, 0x0004b4a7)
	DEP( 0xa5a5a538, 262143, 3, 19, 0xa59ffff8)
	EXT( 0xa5a5a537, 3, 20, 0x0004b4a6)
	EXTU(0xa5a5a537, 3, 20, 0x0004b4a6)
	DEP( 0xa5a5a537, 524287, 3, 20, 0xa5bfffff)
	EXT( 0xa5a5a536, 3, 21, 0xfff4b4a6)
	EXTU(0xa5a5a536, 3, 21, 0x0014b4a6)
	DEP( 0xa5a5a536, 1048575, 3, 21, 0xa57ffffe)
	EXT( 0xa5a5a535, 3, 22, 0xfff4b4a6)
	EXTU(0xa5a5a535, 3, 22, 0x0034b4a6)
	DEP( 0xa5a5a535, 2097151, 3, 22, 0xa4fffffd)
	EXT( 0xa5a5a534, 3, 23, 0x0034b4a6)
	EXTU(0xa5a5a534, 3, 23, 0x0034b4a6)
	DEP( 0xa5a5a534, 4194303, 3, 23, 0xa5fffffc)
	EXT( 0xa5a5a533, 3, 24, 0xffb4b4a6)
	EXTU(0xa5a5a533, 3, 24, 0x00b4b4a6)
	DEP( 0xa5a5a533, 8388607, 3, 24, 0xa3fffffb)
	EXT( 0xa5a5a532, 3, 25, 0x00b4b4a6)
	EXTU(0xa5a5a532, 3, 25, 0x00b4b4a6)
	DEP( 0xa5a5a532, 16777215, 3, 25, 0xa7fffffa)
	EXT( 0xa5a5a531, 3, 26, 0x00b4b4a6)
	EXTU(0xa5a5a531, 3, 26, 0x00b4b4a6)
	DEP( 0xa5a5a531, 33554431, 3, 26, 0xaffffff9)
	EXT( 0xa5a5a530, 3, 27, 0xfcb4b4a6)
	EXTU(0xa5a5a530, 3, 27, 0x04b4b4a6)
	DEP( 0xa5a5a530, 67108863, 3, 27, 0x9ffffff8)
	EXT( 0xa5a5a52f, 3, 28, 0x04b4b4a5)
	EXTU(0xa5a5a52f, 3, 28, 0x04b4b4a5)
	DEP( 0xa5a5a52f, 134217727, 3, 28, 0xbfffffff)
	EXT( 0xa5a5a52e, 4, 1, 0x00000000)
	EXTU(0xa5a5a52e, 4, 1, 0x00000000)
	DEP( 0xa5a5a52e, 0, 4, 1, 0xa5a5a52e)
	EXT( 0xa5a5a52d, 4, 2, 0xfffffffe)
	EXTU(0xa5a5a52d, 4, 2, 0x00000002)
	DEP( 0xa5a5a52d, 1, 4, 2, 0xa5a5a51d)
	EXT( 0xa5a5a52c, 4, 3, 0x00000002)
	EXTU(0xa5a5a52c, 4, 3, 0x00000002)
	DEP( 0xa5a5a52c, 3, 4, 3, 0xa5a5a53c)
	EXT( 0xa5a5a52b, 4, 4, 0x00000002)
	EXTU(0xa5a5a52b, 4, 4, 0x00000002)
	DEP( 0xa5a5a52b, 7, 4, 4, 0xa5a5a57b)
	EXT( 0xa5a5a52a, 4, 5, 0xfffffff2)
	EXTU(0xa5a5a52a, 4, 5, 0x00000012)
	DEP( 0xa5a5a52a, 15, 4, 5, 0xa5a5a4fa)
	EXT( 0xa5a5a529, 4, 6, 0x00000012)
	EXTU(0xa5a5a529, 4, 6, 0x00000012)
	DEP( 0xa5a5a529, 31, 4, 6, 0xa5a5a5f9)
	EXT( 0xa5a5a528, 4, 7, 0xffffffd2)
	EXTU(0xa5a5a528, 4, 7, 0x00000052)
	DEP( 0xa5a5a528, 63, 4, 7, 0xa5a5a3f8)
	EXT( 0xa5a5a527, 4, 8, 0x00000052)
	EXTU(0xa5a5a527, 4, 8, 0x00000052)
	DEP( 0xa5a5a527, 127, 4, 8, 0xa5a5a7f7)
	EXT( 0xa5a5a526, 4, 9, 0x00000052)
	EXTU(0xa5a5a526, 4, 9, 0x00000052)
	DEP( 0xa5a5a526, 255, 4, 9, 0xa5a5aff6)
	EXT( 0xa5a5a525, 4, 10, 0xfffffe52)
	EXTU(0xa5a5a525, 4, 10, 0x00000252)
	DEP( 0xa5a5a525, 511, 4, 10, 0xa5a59ff5)
	EXT( 0xa5a5a524, 4, 11, 0x00000252)
	EXTU(0xa5a5a524, 4, 11, 0x00000252)
	DEP( 0xa5a5a524, 1023, 4, 11, 0xa5a5bff4)
	EXT( 0xa5a5a523, 4, 12, 0xfffffa52)
	EXTU(0xa5a5a523, 4, 12, 0x00000a52)
	DEP( 0xa5a5a523, 2047, 4, 12, 0xa5a57ff3)
	EXT( 0xa5a5a522, 4, 13, 0xfffffa52)
	EXTU(0xa5a5a522, 4, 13, 0x00001a52)
	DEP( 0xa5a5a522, 4095, 4, 13, 0xa5a4fff2)
	EXT( 0xa5a5a521, 4, 14, 0x00001a52)
	EXTU(0xa5a5a521, 4, 14, 0x00001a52)
	DEP( 0xa5a5a521, 8191, 4, 14, 0xa5a5fff1)
	EXT( 0xa5a5a520, 4, 15, 0xffffda52)
	EXTU(0xa5a5a520, 4, 15, 0x00005a52)
	DEP( 0xa5a5a520, 16383, 4, 15, 0xa5a3fff0)
	EXT( 0xa5a5a51f, 4, 16, 0x00005a51)
	EXTU(0xa5a5a51f, 4, 16, 0x00005a51)
	DEP( 0xa5a5a51f, 32767, 4, 16, 0xa5a7ffff)
	EXT( 0xa5a5a51e, 4, 17, 0x00005a51)
	EXTU(0xa5a5a51e, 4, 17, 0x00005a51)
	DEP( 0xa5a5a51e, 65535, 4, 17, 0xa5affffe)
	EXT( 0xa5a5a51d, 4, 18, 0xfffe5a51)
	EXTU(0xa5a5a51d, 4, 18, 0x00025a51)
	DEP( 0xa5a5a51d, 131071, 4, 18, 0xa59ffffd)
	EXT( 0xa5a5a51c, 4, 19, 0x00025a51)
	EXTU(0xa5a5a51c, 4, 19, 0x00025a51)
	DEP( 0xa5a5a51c, 262143, 4, 19, 0xa5bffffc)
	EXT( 0xa5a5a51b, 4, 20, 0xfffa5a51)
	EXTU(0xa5a5a51b, 4, 20, 0x000a5a51)
	DEP( 0xa5a5a51b, 524287, 4, 20, 0xa57ffffb)
	EXT( 0xa5a5a51a, 4, 21, 0xfffa5a51)
	EXTU(0xa5a5a51a, 4, 21, 0x001a5a51)
	DEP( 0xa5a5a51a, 1048575, 4, 21, 0xa4fffffa)
	EXT( 0xa5a5a519, 4, 22, 0x001a5a51)
	EXTU(0xa5a5a519, 4, 22, 0x001a5a51)
	DEP( 0xa5a5a519, 2097151, 4, 22, 0xa5fffff9)
	EXT( 0xa5a5a518, 4, 23, 0xffda5a51)
	EXTU(0xa5a5a518, 4, 23, 0x005a5a51)
	DEP( 0xa5a5a518, 4194303, 4, 23, 0xa3fffff8)
	EXT( 0xa5a5a517, 4, 24, 0x005a5a51)
	EXTU(0xa5a5a517, 4, 24, 0x005a5a51)
	DEP( 0xa5a5a517, 8388607, 4, 24, 0xa7fffff7)
	EXT( 0xa5a5a516, 4, 25, 0x005a5a51)
	EXTU(0xa5a5a516, 4, 25, 0x005a5a51)
	DEP( 0xa5a5a516, 16777215, 4, 25, 0xaffffff6)
	EXT( 0xa5a5a515, 4, 26, 0xfe5a5a51)
	EXTU(0xa5a5a515, 4, 26, 0x025a5a51)
	DEP( 0xa5a5a515, 33554431, 4, 26, 0x9ffffff5)
	EXT( 0xa5a5a514, 4, 27, 0x025a5a51)
	EXTU(0xa5a5a514, 4, 27, 0x025a5a51)
	DEP( 0xa5a5a514, 67108863, 4, 27, 0xbffffff4)
	EXT( 0xa5a5a513, 5, 1, 0x00000000)
	EXTU(0xa5a5a513, 5, 1, 0x00000000)
	DEP( 0xa5a5a513, 0, 5, 1, 0xa5a5a513)
	EXT( 0xa5a5a512, 5, 2, 0x00000000)
	EXTU(0xa5a5a512, 5, 2, 0x00000000)
	DEP( 0xa5a5a512, 1, 5, 2, 0xa5a5a532)
	EXT( 0xa5a5a511, 5, 3, 0x00000000)
	EXTU(0xa5a5a511, 5, 3, 0x00000000)
	DEP( 0xa5a5a511, 3, 5, 3, 0xa5a5a571)
	EXT( 0xa5a5a510, 5, 4, 0xfffffff8)
	EXTU(0xa5a5a510, 5, 4, 0x00000008)
	DEP( 0xa5a5a510, 7, 5, 4, 0xa5a5a4f0)
	EXT( 0xa5a5a50f, 5, 5, 0x00000008)
	EXTU(0xa5a5a50f, 5, 5, 0x00000008)
	DEP( 0xa5a5a50f, 15, 5, 5, 0xa5a5a5ef)
	EXT( 0xa5a5a50e, 5, 6, 0xffffffe8)
	EXTU(0xa5a5a50e, 5, 6, 0x00000028)
	DEP( 0xa5a5a50e, 31, 5, 6, 0xa5a5a3ee)
	EXT( 0xa5a5a50d, 5, 7, 0x00000028)
	EXTU(0xa5a5a50d, 5, 7, 0x00000028)
	DEP( 0xa5a5a50d, 63, 5, 7, 0xa5a5a7ed)
	EXT( 0xa5a5a50c, 5, 8, 0x00000028)
	EXTU(0xa5a5a50c, 5, 8, 0x00000028)
	DEP( 0xa5a5a50c, 127, 5, 8, 0xa5a5afec)
	EXT( 0xa5a5a50b, 5, 9, 0xffffff28)
	EXTU(0xa5a5a50b, 5, 9, 0x00000128)
	DEP( 0xa5a5a50b, 255, 5, 9, 0xa5a59feb)
	EXT( 0xa5a5a50a, 5, 10, 0x00000128)
	EXTU(0xa5a5a50a, 5, 10, 0x00000128)
	DEP( 0xa5a5a50a, 511, 5, 10, 0xa5a5bfea)
	EXT( 0xa5a5a509, 5, 11, 0xfffffd28)
	EXTU(0xa5a5a509, 5, 11, 0x00000528)
	DEP( 0xa5a5a509, 1023, 5, 11, 0xa5a57fe9)
	EXT( 0xa5a5a508, 5, 12, 0xfffffd28)
	EXTU(0xa5a5a508, 5, 12, 0x00000d28)
	DEP( 0xa5a5a508, 2047, 5, 12, 0xa5a4ffe8)
	EXT( 0xa5a5a507, 5, 13, 0x00000d28)
	EXTU(0xa5a5a507, 5, 13, 0x00000d28)
	DEP( 0xa5a5a507, 4095, 5, 13, 0xa5a5ffe7)
	EXT( 0xa5a5a506, 5, 14, 0xffffed28)
	EXTU(0xa5a5a506, 5, 14, 0x00002d28)
	DEP( 0xa5a5a506, 8191, 5, 14, 0xa5a3ffe6)
	EXT( 0xa5a5a505, 5, 15, 0x00002d28)
	EXTU(0xa5a5a505, 5, 15, 0x00002d28)
	DEP( 0xa5a5a505, 16383, 5, 15, 0xa5a7ffe5)
	EXT( 0xa5a5a504, 5, 16, 0x00002d28)
	EXTU(0xa5a5a504, 5, 16, 0x00002d28)
	DEP( 0xa5a5a504, 32767, 5, 16, 0xa5afffe4)
	EXT( 0xa5a5a503, 5, 17, 0xffff2d28)
	EXTU(0xa5a5a503, 5, 17, 0x00012d28)
	DEP( 0xa5a5a503, 65535, 5, 17, 0xa59fffe3)
	EXT( 0xa5a5a502, 5, 18, 0x00012d28)
	EXTU(0xa5a5a502, 5, 18, 0x00012d28)
	DEP( 0xa5a5a502, 131071, 5, 18, 0xa5bfffe2)
	EXT( 0xa5a5a501, 5, 19, 0xfffd2d28)
	EXTU(0xa5a5a501, 5, 19, 0x00052d28)
	DEP( 0xa5a5a501, 262143, 5, 19, 0xa57fffe1)
	EXT( 0xa5a5a500, 5, 20, 0xfffd2d28)
	EXTU(0xa5a5a500, 5, 20, 0x000d2d28)
	DEP( 0xa5a5a500, 524287, 5, 20, 0xa4ffffe0)
	EXT( 0xa5a5a4ff, 5, 21, 0x000d2d27)
	EXTU(0xa5a5a4ff, 5, 21, 0x000d2d27)
	DEP( 0xa5a5a4ff, 1048575, 5, 21, 0xa5ffffff)
	EXT( 0xa5a5a4fe, 5, 22, 0xffed2d27)
	EXTU(0xa5a5a4fe, 5, 22, 0x002d2d27)
	DEP( 0xa5a5a4fe, 2097151, 5, 22, 0xa3fffffe)
	EXT( 0xa5a5a4fd, 5, 23, 0x002d2d27)
	EXTU(0xa5a5a4fd, 5, 23, 0x002d2d27)
	DEP( 0xa5a5a4fd, 4194303, 5, 23, 0xa7fffffd)
	EXT( 0xa5a5a4fc, 5, 24, 0x002d2d27)
	EXTU(0xa5a5a4fc, 5, 24, 0x002d2d27)
	DEP( 0xa5a5a4fc, 8388607, 5, 24, 0xaffffffc)
	EXT( 0xa5a5a4fb, 5, 25, 0xff2d2d27)
	EXTU(0xa5a5a4fb, 5, 25, 0x012d2d27)
	DEP( 0xa5a5a4fb, 16777215, 5, 25, 0x9ffffffb)
	EXT( 0xa5a5a4fa, 5, 26, 0x012d2d27)
	EXTU(0xa5a5a4fa, 5, 26, 0x012d2d27)
	DEP( 0xa5a5a4fa, 33554431, 5, 26, 0xbffffffa)
	EXT( 0xa5a5a4f9, 6, 1, 0xffffffff)
	EXTU(0xa5a5a4f9, 6, 1, 0x00000001)
	DEP( 0xa5a5a4f9, 0, 6, 1, 0xa5a5a4b9)
	EXT( 0xa5a5a4f8, 6, 2, 0xffffffff)
	EXTU(0xa5a5a4f8, 6, 2, 0x00000003)
	DEP( 0xa5a5a4f8, 1, 6, 2, 0xa5a5a478)
	EXT( 0xa5a5a4f7, 6, 3, 0x00000003)
	EXTU(0xa5a5a4f7, 6, 3, 0x00000003)
	DEP( 0xa5a5a4f7, 3, 6, 3, 0xa5a5a4f7)
	EXT( 0xa5a5a4f6, 6, 4, 0x00000003)
	EXTU(0xa5a5a4f6, 6, 4, 0x00000003)
	DEP( 0xa5a5a4f6, 7, 6, 4, 0xa5a5a5f6)
	EXT( 0xa5a5a4f5, 6, 5, 0xfffffff3)
	EXTU(0xa5a5a4f5, 6, 5, 0x00000013)
	DEP( 0xa5a5a4f5, 15, 6, 5, 0xa5a5a3f5)
	EXT( 0xa5a5a4f4, 6, 6, 0x00000013)
	EXTU(0xa5a5a4f4, 6, 6, 0x00000013)
	DEP( 0xa5a5a4f4, 31, 6, 6, 0xa5a5a7f4)
	EXT( 0xa5a5a4f3, 6, 7, 0x00000013)
	EXTU(0xa5a5a4f3, 6, 7, 0x00000013)
	DEP( 0xa5a5a4f3, 63, 6, 7, 0xa5a5aff3)
	EXT( 0xa5a5a4f2, 6, 8, 0xffffff93)
	EXTU(0xa5a5a4f2, 6, 8, 0x00000093)
	DEP( 0xa5a5a4f2, 127, 6, 8, 0xa5a59ff2)
	EXT( 0xa5a5a4f1, 6, 9, 0x00000093)
	EXTU(0xa5a5a4f1, 6, 9, 0x00000093)
	DEP( 0xa5a5a4f1, 255, 6, 9, 0xa5a5bff1)
	EXT( 0xa5a5a4f0, 6, 10, 0xfffffe93)
	EXTU(0xa5a5a4f0, 6, 10, 0x00000293)
	DEP( 0xa5a5a4f0, 511, 6, 10, 0xa5a57ff0)
	EXT( 0xa5a5a4ef, 6, 11, 0xfffffe93)
	EXTU(0xa5a5a4ef, 6, 11, 0x00000693)
	DEP( 0xa5a5a4ef, 1023, 6, 11, 0xa5a4ffef)
	EXT( 0xa5a5a4ee, 6, 12, 0x00000693)
	EXTU(0xa5a5a4ee, 6, 12, 0x00000693)
	DEP( 0xa5a5a4ee, 2047, 6, 12, 0xa5a5ffee)
	EXT( 0xa5a5a4ed, 6, 13, 0xfffff693)
	EXTU(0xa5a5a4ed, 6, 13, 0x00001693)
	DEP( 0xa5a5a4ed, 4095, 6, 13, 0xa5a3ffed)
	EXT( 0xa5a5a4ec, 6, 14, 0x00001693)
	EXTU(0xa5a5a4ec, 6, 14, 0x00001693)
	DEP( 0xa5a5a4ec, 8191, 6, 14, 0xa5a7ffec)
	EXT( 0xa5a5a4eb, 6, 15, 0x00001693)
	EXTU(0xa5a5a4eb, 6, 15, 0x00001693)
	DEP( 0xa5a5a4eb, 16383, 6, 15, 0xa5afffeb)
	EXT( 0xa5a5a4ea, 6, 16, 0xffff9693)
	EXTU(0xa5a5a4ea, 6, 16, 0x00009693)
	DEP( 0xa5a5a4ea, 32767, 6, 16, 0xa59fffea)
	EXT( 0xa5a5a4e9, 6, 17, 0x00009693)
	EXTU(0xa5a5a4e9, 6, 17, 0x00009693)
	DEP( 0xa5a5a4e9, 65535, 6, 17, 0xa5bfffe9)
	EXT( 0xa5a5a4e8, 6, 18, 0xfffe9693)
	EXTU(0xa5a5a4e8, 6, 18, 0x00029693)
	DEP( 0xa5a5a4e8, 131071, 6, 18, 0xa57fffe8)
	EXT( 0xa5a5a4e7, 6, 19, 0xfffe9693)
	EXTU(0xa5a5a4e7, 6, 19, 0x00069693)
	DEP( 0xa5a5a4e7, 262143, 6, 19, 0xa4ffffe7)
	EXT( 0xa5a5a4e6, 6, 20, 0x00069693)
	EXTU(0xa5a5a4e6, 6, 20, 0x00069693)
	DEP( 0xa5a5a4e6, 524287, 6, 20, 0xa5ffffe6)
	EXT( 0xa5a5a4e5, 6, 21, 0xfff69693)
	EXTU(0xa5a5a4e5, 6, 21, 0x00169693)
	DEP( 0xa5a5a4e5, 1048575, 6, 21, 0xa3ffffe5)
	EXT( 0xa5a5a4e4, 6, 22, 0x00169693)
	EXTU(0xa5a5a4e4, 6, 22, 0x00169693)
	DEP( 0xa5a5a4e4, 2097151, 6, 22, 0xa7ffffe4)
	EXT( 0xa5a5a4e3, 6, 23, 0x00169693)
	EXTU(0xa5a5a4e3, 6, 23, 0x00169693)
	DEP( 0xa5a5a4e3, 4194303, 6, 23, 0xafffffe3)
	EXT( 0xa5a5a4e2, 6, 24, 0xff969693)
	EXTU(0xa5a5a4e2, 6, 24, 0x00969693)
	DEP( 0xa5a5a4e2, 8388607, 6, 24, 0x9fffffe2)
	EXT( 0xa5a5a4e1, 6, 25, 0x00969693)
	EXTU(0xa5a5a4e1, 6, 25, 0x00969693)
	DEP( 0xa5a5a4e1, 16777215, 6, 25, 0xbfffffe1)
	EXT( 0xa5a5a4e0, 7, 1, 0xffffffff)
	EXTU(0xa5a5a4e0, 7, 1, 0x00000001)
	DEP( 0xa5a5a4e0, 0, 7, 1, 0xa5a5a460)
	EXT( 0xa5a5a4df, 7, 2, 0x00000001)
	EXTU(0xa5a5a4df, 7, 2, 0x00000001)
	DEP( 0xa5a5a4df, 1, 7, 2, 0xa5a5a4df)
	EXT( 0xa5a5a4de, 7, 3, 0x00000001)
	EXTU(0xa5a5a4de, 7, 3, 0x00000001)
	DEP( 0xa5a5a4de, 3, 7, 3, 0xa5a5a5de)
	EXT( 0xa5a5a4dd, 7, 4, 0xfffffff9)
	EXTU(0xa5a5a4dd, 7, 4, 0x00000009)
	DEP( 0xa5a5a4dd, 7, 7, 4, 0xa5a5a3dd)
	EXT( 0xa5a5a4dc, 7, 5, 0x00000009)
	EXTU(0xa5a5a4dc, 7, 5, 0x00000009)
	DEP( 0xa5a5a4dc, 15, 7, 5, 0xa5a5a7dc)
	EXT( 0xa5a5a4db, 7, 6, 0x00000009)
	EXTU(0xa5a5a4db, 7, 6, 0x00000009)
	DEP( 0xa5a5a4db, 31, 7, 6, 0xa5a5afdb)
	EXT( 0xa5a5a4da, 7, 7, 0xffffffc9)
	EXTU(0xa5a5a4da, 7, 7, 0x00000049)
	DEP( 0xa5a5a4da, 63, 7, 7, 0xa5a59fda)
	EXT( 0xa5a5a4d9, 7, 8, 0x00000049)
	EXTU(0xa5a5a4d9, 7, 8, 0x00000049)
	DEP( 0xa5a5a4d9, 127, 7, 8, 0xa5a5bfd9)
	EXT( 0xa5a5a4d8, 7, 9, 0xffffff49)
	EXTU(0xa5a5a4d8, 7, 9, 0x00000149)
	DEP( 0xa5a5a4d8, 255, 7, 9, 0xa5a57fd8)
	EXT( 0xa5a5a4d7, 7, 10, 0xffffff49)
	EXTU(0xa5a5a4d7, 7, 10, 0x00000349)
	DEP( 0xa5a5a4d7, 511, 7, 10, 0xa5a4ffd7)
	EXT( 0xa5a5a4d6, 7, 11, 0x00000349)
	EXTU(0xa5a5a4d6, 7, 11, 0x00000349)
	DEP( 0xa5a5a4d6, 1023, 7, 11, 0xa5a5ffd6)
	EXT( 0xa5a5a4d5, 7, 12, 0xfffffb49)
	EXTU(0xa5a5a4d5, 7, 12, 0x00000b49)
	DEP( 0xa5a5a4d5, 2047, 7, 12, 0xa5a3ffd5)
	EXT( 0xa5a5a4d4, 7, 13, 0x00000b49)
	EXTU(0xa5a5a4d4, 7, 13, 0x00000b49)
	DEP( 0xa5a5a4d4, 4095, 7, 13, 0xa5a7ffd4)
	EXT( 0xa5a5a4d3, 7, 14, 0x00000b49)
	EXTU(0xa5a5a4d3, 7, 14, 0x00000b49)
	DEP( 0xa5a5a4d3, 8191, 7, 14, 0xa5afffd3)
	EXT( 0xa5a5a4d2, 7, 15, 0xffffcb49)
	EXTU(0xa5a5a4d2, 7, 15, 0x00004b49)
	DEP( 0xa5a5a4d2, 16383, 7, 15, 0xa59fffd2)
	EXT( 0xa5a5a4d1, 7, 16, 0x00004b49)
	EXTU(0xa5a5a4d1, 7, 16, 0x00004b49)
	DEP( 0xa5a5a4d1, 32767, 7, 16, 0xa5bfffd1)
	EXT( 0xa5a5a4d0, 7, 17, 0xffff4b49)
	EXTU(0xa5a5a4d0, 7, 17, 0x00014b49)
	DEP( 0xa5a5a4d0, 65535, 7, 17, 0xa57fffd0)
	EXT( 0xa5a5a4cf, 7, 18, 0xffff4b49)
	EXTU(0xa5a5a4cf, 7, 18, 0x00034b49)
	DEP( 0xa5a5a4cf, 131071, 7, 18, 0xa4ffffcf)
	EXT( 0xa5a5a4ce, 7, 19, 0x00034b49)
	EXTU(0xa5a5a4ce, 7, 19, 0x00034b49)
	DEP( 0xa5a5a4ce, 262143, 7, 19, 0xa5ffffce)
	EXT( 0xa5a5a4cd, 7, 20, 0xfffb4b49)
	EXTU(0xa5a5a4cd, 7, 20, 0x000b4b49)
	DEP( 0xa5a5a4cd, 524287, 7, 20, 0xa3ffffcd)
	EXT( 0xa5a5a4cc, 7, 21, 0x000b4b49)
	EXTU(0xa5a5a4cc, 7, 21, 0x000b4b49)
	DEP( 0xa5a5a4cc, 1048575, 7, 21, 0xa7ffffcc)
	EXT( 0xa5a5a4cb, 7, 22, 0x000b4b49)
	EXTU(0xa5a5a4cb, 7, 22, 0x000b4b49)
	DEP( 0xa5a5a4cb, 2097151, 7, 22, 0xafffffcb)
	EXT( 0xa5a5a4ca, 7, 23, 0xffcb4b49)
	EXTU(0xa5a5a4ca, 7, 23, 0x004b4b49)
	DEP( 0xa5a5a4ca, 4194303, 7, 23, 0x9fffffca)
	EXT( 0xa5a5a4c9, 7, 24, 0x004b4b49)
	EXTU(0xa5a5a4c9, 7, 24, 0x004b4b49)
	DEP( 0xa5a5a4c9, 8388607, 7, 24, 0xbfffffc9)
	EXT( 0xa5a5a4c8, 8, 1, 0x00000000)
	EXTU(0xa5a5a4c8, 8, 1, 0x00000000)
	DEP( 0xa5a5a4c8, 0, 8, 1, 0xa5a5a4c8)
	EXT( 0xa5a5a4c7, 8, 2, 0x00000000)
	EXTU(0xa5a5a4c7, 8, 2, 0x00000000)
	DEP( 0xa5a5a4c7, 1, 8, 2, 0xa5a5a5c7)
	EXT( 0xa5a5a4c6, 8, 3, 0xfffffffc)
	EXTU(0xa5a5a4c6, 8, 3, 0x00000004)
	DEP( 0xa5a5a4c6, 3, 8, 3, 0xa5a5a3c6)
	EXT( 0xa5a5a4c5, 8, 4, 0x00000004)
	EXTU(0xa5a5a4c5, 8, 4, 0x00000004)
	DEP( 0xa5a5a4c5, 7, 8, 4, 0xa5a5a7c5)
	EXT( 0xa5a5a4c4, 8, 5, 0x00000004)
	EXTU(0xa5a5a4c4, 8, 5, 0x00000004)
	DEP( 0xa5a5a4c4, 15, 8, 5, 0xa5a5afc4)
	EXT( 0xa5a5a4c3, 8, 6, 0xffffffe4)
	EXTU(0xa5a5a4c3, 8, 6, 0x00000024)
	DEP( 0xa5a5a4c3, 31, 8, 6, 0xa5a59fc3)
	EXT( 0xa5a5a4c2, 8, 7, 0x00000024)
	EXTU(0xa5a5a4c2, 8, 7, 0x00000024)
	DEP( 0xa5a5a4c2, 63, 8, 7, 0xa5a5bfc2)
	EXT( 0xa5a5a4c1, 8, 8, 0xffffffa4)
	EXTU(0xa5a5a4c1, 8, 8, 0x000000a4)
	DEP( 0xa5a5a4c1, 127, 8, 8, 0xa5a57fc1)
	EXT( 0xa5a5a4c0, 8, 9, 0xffffffa4)
	EXTU(0xa5a5a4c0, 8, 9, 0x000001a4)
	DEP( 0xa5a5a4c0, 255, 8, 9, 0xa5a4ffc0)
	EXT( 0xa5a5a4bf, 8, 10, 0x000001a4)
	EXTU(0xa5a5a4bf, 8, 10, 0x000001a4)
	DEP( 0xa5a5a4bf, 511, 8, 10, 0xa5a5ffbf)
	EXT( 0xa5a5a4be, 8, 11, 0xfffffda4)
	EXTU(0xa5a5a4be, 8, 11, 0x000005a4)
	DEP( 0xa5a5a4be, 1023, 8, 11, 0xa5a3ffbe)
	EXT( 0xa5a5a4bd, 8, 12, 0x000005a4)
	EXTU(0xa5a5a4bd, 8, 12, 0x000005a4)
	DEP( 0xa5a5a4bd, 2047, 8, 12, 0xa5a7ffbd)
	EXT( 0xa5a5a4bc, 8, 13, 0x000005a4)
	EXTU(0xa5a5a4bc, 8, 13, 0x000005a4)
	DEP( 0xa5a5a4bc, 4095, 8, 13, 0xa5afffbc)
	EXT( 0xa5a5a4bb, 8, 14, 0xffffe5a4)
	EXTU(0xa5a5a4bb, 8, 14, 0x000025a4)
	DEP( 0xa5a5a4bb, 8191, 8, 14, 0xa59fffbb)
	EXT( 0xa5a5a4ba, 8, 15, 0x000025a4)
	EXTU(0xa5a5a4ba, 8, 15, 0x000025a4)
	DEP( 0xa5a5a4ba, 16383, 8, 15, 0xa5bfffba)
	EXT( 0xa5a5a4b9, 8, 16, 0xffffa5a4)
	EXTU(0xa5a5a4b9, 8, 16, 0x0000a5a4)
	DEP( 0xa5a5a4b9, 32767, 8, 16, 0xa57fffb9)
	EXT( 0xa5a5a4b8, 8, 17, 0xffffa5a4)
	EXTU(0xa5a5a4b8, 8, 17, 0x0001a5a4)
	DEP( 0xa5a5a4b8, 65535, 8, 17, 0xa4ffffb8)
	EXT( 0xa5a5a4b7, 8, 18, 0x0001a5a4)
	EXTU(0xa5a5a4b7, 8, 18, 0x0001a5a4)
	DEP( 0xa5a5a4b7, 131071, 8, 18, 0xa5ffffb7)
	EXT( 0xa5a5a4b6, 8, 19, 0xfffda5a4)
	EXTU(0xa5a5a4b6, 8, 19, 0x0005a5a4)
	DEP( 0xa5a5a4b6, 262143, 8, 19, 0xa3ffffb6)
	EXT( 0xa5a5a4b5, 8, 20, 0x0005a5a4)
	EXTU(0xa5a5a4b5, 8, 20, 0x0005a5a4)
	DEP( 0xa5a5a4b5, 524287, 8, 20, 0xa7ffffb5)
	EXT( 0xa5a5a4b4, 8, 21, 0x0005a5a4)
	EXTU(0xa5a5a4b4, 8, 21, 0x0005a5a4)
	DEP( 0xa5a5a4b4, 1048575, 8, 21, 0xafffffb4)
	EXT( 0xa5a5a4b3, 8, 22, 0xffe5a5a4)
	EXTU(0xa5a5a4b3, 8, 22, 0x0025a5a4)
	DEP( 0xa5a5a4b3, 2097151, 8, 22, 0x9fffffb3)
	EXT( 0xa5a5a4b2, 8, 23, 0x0025a5a4)
	EXTU(0xa5a5a4b2, 8, 23, 0x0025a5a4)
	DEP( 0xa5a5a4b2, 4194303, 8, 23, 0xbfffffb2)
	EXT( 0xa5a5a4b1, 9, 1, 0x00000000)
	EXTU(0xa5a5a4b1, 9, 1, 0x00000000)
	DEP( 0xa5a5a4b1, 0, 9, 1, 0xa5a5a4b1)
	EXT( 0xa5a5a4b0, 9, 2, 0xfffffffe)
	EXTU(0xa5a5a4b0, 9, 2, 0x00000002)
	DEP( 0xa5a5a4b0, 1, 9, 2, 0xa5a5a2b0)
	EXT( 0xa5a5a4af, 9, 3, 0x00000002)
	EXTU(0xa5a5a4af, 9, 3, 0x00000002)
	DEP( 0xa5a5a4af, 3, 9, 3, 0xa5a5a6af)
	EXT( 0xa5a5a4ae, 9, 4, 0x00000002)
	EXTU(0xa5a5a4ae, 9, 4, 0x00000002)
	DEP( 0xa5a5a4ae, 7, 9, 4, 0xa5a5aeae)
	EXT( 0xa5a5a4ad, 9, 5, 0xfffffff2)
	EXTU(0xa5a5a4ad, 9, 5, 0x00000012)
	DEP( 0xa5a5a4ad, 15, 9, 5, 0xa5a59ead)
	EXT( 0xa5a5a4ac, 9, 6, 0x00000012)
	EXTU(0xa5a5a4ac, 9, 6, 0x00000012)
	DEP( 0xa5a5a4ac, 31, 9, 6, 0xa5a5beac)
	EXT( 0xa5a5a4ab, 9, 7, 0xffffffd2)
	EXTU(0xa5a5a4ab, 9, 7, 0x00000052)
	DEP( 0xa5a5a4ab, 63, 9, 7, 0xa5a57eab)
	EXT( 0xa5a5a4aa, 9, 8, 0xffffffd2)
	EXTU(0xa5a5a4aa, 9, 8, 0x000000d2)
	DEP( 0xa5a5a4aa, 127, 9, 8, 0xa5a4feaa)
	EXT( 0xa5a5a4a9, 9, 9, 0x000000d2)
	EXTU(0xa5a5a4a9, 9, 9, 0x000000d2)
	DEP( 0xa5a5a4a9, 255, 9, 9, 0xa5a5fea9)
	EXT( 0xa5a5a4a8, 9, 10, 0xfffffed2)
	EXTU(0xa5a5a4a8, 9, 10, 0x000002d2)
	DEP( 0xa5a5a4a8, 511, 9, 10, 0xa5a3fea8)
	EXT( 0xa5a5a4a7, 9, 11, 0x000002d2)
	EXTU(0xa5a5a4a7, 9, 11, 0x000002d2)
	DEP( 0xa5a5a4a7, 1023, 9, 11, 0xa5a7fea7)
	EXT( 0xa5a5a4a6, 9, 12, 0x000002d2)
	EXTU(0xa5a5a4a6, 9, 12, 0x000002d2)
	DEP( 0xa5a5a4a6, 2047, 9, 12, 0xa5affea6)
	EXT( 0xa5a5a4a5, 9, 13, 0xfffff2d2)
	EXTU(0xa5a5a4a5, 9, 13, 0x000012d2)
	DEP( 0xa5a5a4a5, 4095, 9, 13, 0xa59ffea5)
	EXT( 0xa5a5a4a4, 9, 14, 0x000012d2)
	EXTU(0xa5a5a4a4, 9, 14, 0x000012d2)
	DEP( 0xa5a5a4a4, 8191, 9, 14, 0xa5bffea4)
	EXT( 0xa5a5a4a3, 9, 15, 0xffffd2d2)
	EXTU(0xa5a5a4a3, 9, 15, 0x000052d2)
	DEP( 0xa5a5a4a3, 16383, 9, 15, 0xa57ffea3)
	EXT( 0xa5a5a4a2, 9, 16, 0xffffd2d2)
	EXTU(0xa5a5a4a2, 9, 16, 0x0000d2d2)
	DEP( 0xa5a5a4a2, 32767, 9, 16, 0xa4fffea2)
	EXT( 0xa5a5a4a1, 9, 17, 0x0000d2d2)
	EXTU(0xa5a5a4a1, 9, 17, 0x0000d2d2)
	DEP( 0xa5a5a4a1, 65535, 9, 17, 0xa5fffea1)
	EXT( 0xa5a5a4a0, 9, 18, 0xfffed2d2)
	EXTU(0xa5a5a4a0, 9, 18, 0x0002d2d2)
	DEP( 0xa5a5a4a0, 131071, 9, 18, 0xa3fffea0)
	EXT( 0xa5a5a49f, 9, 19, 0x0002d2d2)
	EXTU(0xa5a5a49f, 9, 19, 0x0002d2d2)
	DEP( 0xa5a5a49f, 262143, 9, 19, 0xa7fffe9f)
	EXT( 0xa5a5a49e, 9, 20, 0x0002d2d2)
	EXTU(0xa5a5a49e, 9, 20, 0x0002d2d2)
	DEP( 0xa5a5a49e, 524287, 9, 20, 0xaffffe9e)
	EXT( 0xa5a5a49d, 9, 21, 0xfff2d2d2)
	EXTU(0xa5a5a49d, 9, 21, 0x0012d2d2)
	DEP( 0xa5a5a49d, 1048575, 9, 21, 0x9ffffe9d)
	EXT( 0xa5a5a49c, 9, 22, 0x0012d2d2)
	EXTU(0xa5a5a49c, 9, 22, 0x0012d2d2)
	DEP( 0xa5a5a49c, 2097151, 9, 22, 0xbffffe9c)
	EXT( 0xa5a5a49b, 10, 1, 0xffffffff)
	EXTU(0xa5a5a49b, 10, 1, 0x00000001)
	DEP( 0xa5a5a49b, 0, 10, 1, 0xa5a5a09b)
	EXT( 0xa5a5a49a, 10, 2, 0x00000001)
	EXTU(0xa5a5a49a, 10, 2, 0x00000001)
	DEP( 0xa5a5a49a, 1, 10, 2, 0xa5a5a49a)
	EXT( 0xa5a5a499, 10, 3, 0x00000001)
	EXTU(0xa5a5a499, 10, 3, 0x00000001)
	DEP( 0xa5a5a499, 3, 10, 3, 0xa5a5ac99)
	EXT( 0xa5a5a498, 10, 4, 0xfffffff9)
	EXTU(0xa5a5a498, 10, 4, 0x00000009)
	DEP( 0xa5a5a498, 7, 10, 4, 0xa5a59c98)
	EXT( 0xa5a5a497, 10, 5, 0x00000009)
	EXTU(0xa5a5a497, 10, 5, 0x00000009)
	DEP( 0xa5a5a497, 15, 10, 5, 0xa5a5bc97)
	EXT( 0xa5a5a496, 10, 6, 0xffffffe9)
	EXTU(0xa5a5a496, 10, 6, 0x00000029)
	DEP( 0xa5a5a496, 31, 10, 6, 0xa5a57c96)
	EXT( 0xa5a5a495, 10, 7, 0xffffffe9)
	EXTU(0xa5a5a495, 10, 7, 0x00000069)
	DEP( 0xa5a5a495, 63, 10, 7, 0xa5a4fc95)
	EXT( 0xa5a5a494, 10, 8, 0x00000069)
	EXTU(0xa5a5a494, 10, 8, 0x00000069)
	DEP( 0xa5a5a494, 127, 10, 8, 0xa5a5fc94)
	EXT( 0xa5a5a493, 10, 9, 0xffffff69)
	EXTU(0xa5a5a493, 10, 9, 0x00000169)
	DEP( 0xa5a5a493, 255, 10, 9, 0xa5a3fc93)
	EXT( 0xa5a5a492, 10, 10, 0x00000169)
	EXTU(0xa5a5a492, 10, 10, 0x00000169)
	DEP( 0xa5a5a492, 511, 10, 10, 0xa5a7fc92)
	EXT( 0xa5a5a491, 10, 11, 0x00000169)
	EXTU(0xa5a5a491, 10, 11, 0x00000169)
	DEP( 0xa5a5a491, 1023, 10, 11, 0xa5affc91)
	EXT( 0xa5a5a490, 10, 12, 0xfffff969)
	EXTU(0xa5a5a490, 10, 12, 0x00000969)
	DEP( 0xa5a5a490, 2047, 10, 12, 0xa59ffc90)
	EXT( 0xa5a5a48f, 10, 13, 0x00000969)
	EXTU(0xa5a5a48f, 10, 13, 0x00000969)
	DEP( 0xa5a5a48f, 4095, 10, 13, 0xa5bffc8f)
	EXT( 0xa5a5a48e, 10, 14, 0xffffe969)
	EXTU(0xa5a5a48e, 10, 14, 0x00002969)
	DEP( 0xa5a5a48e, 8191, 10, 14, 0xa57ffc8e)
	EXT( 0xa5a5a48d, 10, 15, 0xffffe969)
	EXTU(0xa5a5a48d, 10, 15, 0x00006969)
	DEP( 0xa5a5a48d, 16383, 10, 15, 0xa4fffc8d)
	EXT( 0xa5a5a48c, 10, 16, 0x00006969)
	EXTU(0xa5a5a48c, 10, 16, 0x00006969)
	DEP( 0xa5a5a48c, 32767, 10, 16, 0xa5fffc8c)
	EXT( 0xa5a5a48b, 10, 17, 0xffff6969)
	EXTU(0xa5a5a48b, 10, 17, 0x00016969)
	DEP( 0xa5a5a48b, 65535, 10, 17, 0xa3fffc8b)
	EXT( 0xa5a5a48a, 10, 18, 0x00016969)
	EXTU(0xa5a5a48a, 10, 18, 0x00016969)
	DEP( 0xa5a5a48a, 131071, 10, 18, 0xa7fffc8a)
	EXT( 0xa5a5a489, 10, 19, 0x00016969)
	EXTU(0xa5a5a489, 10, 19, 0x00016969)
	DEP( 0xa5a5a489, 262143, 10, 19, 0xaffffc89)
	EXT( 0xa5a5a488, 10, 20, 0xfff96969)
	EXTU(0xa5a5a488, 10, 20, 0x00096969)
	DEP( 0xa5a5a488, 524287, 10, 20, 0x9ffffc88)
	EXT( 0xa5a5a487, 10, 21, 0x00096969)
	EXTU(0xa5a5a487, 10, 21, 0x00096969)
	DEP( 0xa5a5a487, 1048575, 10, 21, 0xbffffc87)
	EXT( 0xa5a5a486, 11, 1, 0x00000000)
	EXTU(0xa5a5a486, 11, 1, 0x00000000)
	DEP( 0xa5a5a486, 0, 11, 1, 0xa5a5a486)
	EXT( 0xa5a5a485, 11, 2, 0x00000000)
	EXTU(0xa5a5a485, 11, 2, 0x00000000)
	DEP( 0xa5a5a485, 1, 11, 2, 0xa5a5ac85)
	EXT( 0xa5a5a484, 11, 3, 0xfffffffc)
	EXTU(0xa5a5a484, 11, 3, 0x00000004)
	DEP( 0xa5a5a484, 3, 11, 3, 0xa5a59c84)
	EXT( 0xa5a5a483, 11, 4, 0x00000004)
	EXTU(0xa5a5a483, 11, 4, 0x00000004)
	DEP( 0xa5a5a483, 7, 11, 4, 0xa5a5bc83)
	EXT( 0xa5a5a482, 11, 5, 0xfffffff4)
	EXTU(0xa5a5a482, 11, 5, 0x00000014)
	DEP( 0xa5a5a482, 15, 11, 5, 0xa5a57c82)
	EXT( 0xa5a5a481, 11, 6, 0xfffffff4)
	EXTU(0xa5a5a481, 11, 6, 0x00000034)
	DEP( 0xa5a5a481, 31, 11, 6, 0xa5a4fc81)
	EXT( 0xa5a5a480, 11, 7, 0x00000034)
	EXTU(0xa5a5a480, 11, 7, 0x00000034)
	DEP( 0xa5a5a480, 63, 11, 7, 0xa5a5fc80)
	EXT( 0xa5a5a47f, 11, 8, 0xffffffb4)
	EXTU(0xa5a5a47f, 11, 8, 0x000000b4)
	DEP( 0xa5a5a47f, 127, 11, 8, 0xa5a3fc7f)
	EXT( 0xa5a5a47e, 11, 9, 0x000000b4)
	EXTU(0xa5a5a47e, 11, 9, 0x000000b4)
	DEP( 0xa5a5a47e, 255, 11, 9, 0xa5a7fc7e)
	EXT( 0xa5a5a47d, 11, 10, 0x000000b4)
	EXTU(0xa5a5a47d, 11, 10, 0x000000b4)
	DEP( 0xa5a5a47d, 511, 11, 10, 0xa5affc7d)
	EXT( 0xa5a5a47c, 11, 11, 0xfffffcb4)
	EXTU(0xa5a5a47c, 11, 11, 0x000004b4)
	DEP( 0xa5a5a47c, 1023, 11, 11, 0xa59ffc7c)
	EXT( 0xa5a5a47b, 11, 12, 0x000004b4)
	EXTU(0xa5a5a47b, 11, 12, 0x000004b4)
	DEP( 0xa5a5a47b, 2047, 11, 12, 0xa5bffc7b)
	EXT( 0xa5a5a47a, 11, 13, 0xfffff4b4)
	EXTU(0xa5a5a47a, 11, 13, 0x000014b4)
	DEP( 0xa5a5a47a, 4095, 11, 13, 0xa57ffc7a)
	EXT( 0xa5a5a479, 11, 14, 0xfffff4b4)
	EXTU(0xa5a5a479, 11, 14, 0x000034b4)
	DEP( 0xa5a5a479, 8191, 11, 14, 0xa4fffc79)
	EXT( 0xa5a5a478, 11, 15, 0x000034b4)
	EXTU(0xa5a5a478, 11, 15, 0x000034b4)
	DEP( 0xa5a5a478, 16383, 11, 15, 0xa5fffc78)
	EXT( 0xa5a5a477, 11, 16, 0xffffb4b4)
	EXTU(0xa5a5a477, 11, 16, 0x0000b4b4)
	DEP( 0xa5a5a477, 32767, 11, 16, 0xa3fffc77)
	EXT( 0xa5a5a476, 11, 17, 0x0000b4b4)
	EXTU(0xa5a5a476, 11, 17, 0x0000b4b4)
	DEP( 0xa5a5a476, 65535, 11, 17, 0xa7fffc76)
	EXT( 0xa5a5a475, 11, 18, 0x0000b4b4)
	EXTU(0xa5a5a475, 11, 18, 0x0000b4b4)
	DEP( 0xa5a5a475, 131071, 11, 18, 0xaffffc75)
	EXT( 0xa5a5a474, 11, 19, 0xfffcb4b4)
	EXTU(0xa5a5a474, 11, 19, 0x0004b4b4)
	DEP( 0xa5a5a474, 262143, 11, 19, 0x9ffffc74)
	EXT( 0xa5a5a473, 11, 20, 0x0004b4b4)
	EXTU(0xa5a5a473, 11, 20, 0x0004b4b4)
	DEP( 0xa5a5a473, 524287, 11, 20, 0xbffffc73)
	EXT( 0xa5a5a472, 12, 1, 0x00000000)
	EXTU(0xa5a5a472, 12, 1, 0x00000000)
	DEP( 0xa5a5a472, 0, 12, 1, 0xa5a5a472)
	EXT( 0xa5a5a471, 12, 2, 0xfffffffe)
	EXTU(0xa5a5a471, 12, 2, 0x00000002)
	DEP( 0xa5a5a471, 1, 12, 2, 0xa5a59471)
	EXT( 0xa5a5a470, 12, 3, 0x00000002)
	EXTU(0xa5a5a470, 12, 3, 0x00000002)
	DEP( 0xa5a5a470, 3, 12, 3, 0xa5a5b470)
	EXT( 0xa5a5a46f, 12, 4, 0xfffffffa)
	EXTU(0xa5a5a46f, 12, 4, 0x0000000a)
	DEP( 0xa5a5a46f, 7, 12, 4, 0xa5a5746f)
	EXT( 0xa5a5a46e, 12, 5, 0xfffffffa)
	EXTU(0xa5a5a46e, 12, 5, 0x0000001a)
	DEP( 0xa5a5a46e, 15, 12, 5, 0xa5a4f46e)
	EXT( 0xa5a5a46d, 12, 6, 0x0000001a)
	EXTU(0xa5a5a46d, 12, 6, 0x0000001a)
	DEP( 0xa5a5a46d, 31, 12, 6, 0xa5a5f46d)
	EXT( 0xa5a5a46c, 12, 7, 0xffffffda)
	EXTU(0xa5a5a46c, 12, 7, 0x0000005a)
	DEP( 0xa5a5a46c, 63, 12, 7, 0xa5a3f46c)
	EXT( 0xa5a5a46b, 12, 8, 0x0000005a)
	EXTU(0xa5a5a46b, 12, 8, 0x0000005a)
	DEP( 0xa5a5a46b, 127, 12, 8, 0xa5a7f46b)
	EXT( 0xa5a5a46a, 12, 9, 0x0000005a)
	EXTU(0xa5a5a46a, 12, 9, 0x0000005a)
	DEP( 0xa5a5a46a, 255, 12, 9, 0xa5aff46a)
	EXT( 0xa5a5a469, 12, 10, 0xfffffe5a)
	EXTU(0xa5a5a469, 12, 10, 0x0000025a)
	DEP( 0xa5a5a469, 511, 12, 10, 0xa59ff469)
	EXT( 0xa5a5a468, 12, 11, 0x0000025a)
	EXTU(0xa5a5a468, 12, 11, 0x0000025a)
	DEP( 0xa5a5a468, 1023, 12, 11, 0xa5bff468)
	EXT( 0xa5a5a467, 12, 12, 0xfffffa5a)
	EXTU(0xa5a5a467, 12, 12, 0x00000a5a)
	DEP( 0xa5a5a467, 2047, 12, 12, 0xa57ff467)
	EXT( 0xa5a5a466, 12, 13, 0xfffffa5a)
	EXTU(0xa5a5a466, 12, 13, 0x00001a5a)
	DEP( 0xa5a5a466, 4095, 12, 13, 0xa4fff466)
	EXT( 0xa5a5a465, 12, 14, 0x00001a5a)
	EXTU(0xa5a5a465, 12, 14, 0x00001a5a)
	DEP( 0xa5a5a465, 8191, 12, 14, 0xa5fff465)
	EXT( 0xa5a5a464, 12, 15, 0xffffda5a)
	EXTU(0xa5a5a464, 12, 15, 0x00005a5a)
	DEP( 0xa5a5a464, 16383, 12, 15, 0xa3fff464)
	EXT( 0xa5a5a463, 12, 16, 0x00005a5a)
	EXTU(0xa5a5a463, 12, 16, 0x00005a5a)
	DEP( 0xa5a5a463, 32767, 12, 16, 0xa7fff463)
	EXT( 0xa5a5a462, 12, 17, 0x00005a5a)
	EXTU(0xa5a5a462, 12, 17, 0x00005a5a)
	DEP( 0xa5a5a462, 65535, 12, 17, 0xaffff462)
	EXT( 0xa5a5a461, 12, 18, 0xfffe5a5a)
	EXTU(0xa5a5a461, 12, 18, 0x00025a5a)
	DEP( 0xa5a5a461, 131071, 12, 18, 0x9ffff461)
	EXT( 0xa5a5a460, 12, 19, 0x00025a5a)
	EXTU(0xa5a5a460, 12, 19, 0x00025a5a)
	DEP( 0xa5a5a460, 262143, 12, 19, 0xbffff460)
	EXT( 0xa5a5a45f, 13, 1, 0xffffffff)
	EXTU(0xa5a5a45f, 13, 1, 0x00000001)
	DEP( 0xa5a5a45f, 0, 13, 1, 0xa5a5845f)
	EXT( 0xa5a5a45e, 13, 2, 0x00000001)
	EXTU(0xa5a5a45e, 13, 2, 0x00000001)
	DEP( 0xa5a5a45e, 1, 13, 2, 0xa5a5a45e)
	EXT( 0xa5a5a45d, 13, 3, 0xfffffffd)
	EXTU(0xa5a5a45d, 13, 3, 0x00000005)
	DEP( 0xa5a5a45d, 3, 13, 3, 0xa5a5645d)
	EXT( 0xa5a5a45c, 13, 4, 0xfffffffd)
	EXTU(0xa5a5a45c, 13, 4, 0x0000000d)
	DEP( 0xa5a5a45c, 7, 13, 4, 0xa5a4e45c)
	EXT( 0xa5a5a45b, 13, 5, 0x0000000d)
	EXTU(0xa5a5a45b, 13, 5, 0x0000000d)
	DEP( 0xa5a5a45b, 15, 13, 5, 0xa5a5e45b)
	EXT( 0xa5a5a45a, 13, 6, 0xffffffed)
	EXTU(0xa5a5a45a, 13, 6, 0x0000002d)
	DEP( 0xa5a5a45a, 31, 13, 6, 0xa5a3e45a)
	EXT( 0xa5a5a459, 13, 7, 0x0000002d)
	EXTU(0xa5a5a459, 13, 7, 0x0000002d)
	DEP( 0xa5a5a459, 63, 13, 7, 0xa5a7e459)
	EXT( 0xa5a5a458, 13, 8, 0x0000002d)
	EXTU(0xa5a5a458, 13, 8, 0x0000002d)
	DEP( 0xa5a5a458, 127, 13, 8, 0xa5afe458)
	EXT( 0xa5a5a457, 13, 9, 0xffffff2d)
	EXTU(0xa5a5a457, 13, 9, 0x0000012d)
	DEP( 0xa5a5a457, 255, 13, 9, 0xa59fe457)
	EXT( 0xa5a5a456, 13, 10, 0x0000012d)
	EXTU(0xa5a5a456, 13, 10, 0x0000012d)
	DEP( 0xa5a5a456, 511, 13, 10, 0xa5bfe456)
	EXT( 0xa5a5a455, 13, 11, 0xfffffd2d)
	EXTU(0xa5a5a455, 13, 11, 0x0000052d)
	DEP( 0xa5a5a455, 1023, 13, 11, 0xa57fe455)
	EXT( 0xa5a5a454, 13, 12, 0xfffffd2d)
	EXTU(0xa5a5a454, 13, 12, 0x00000d2d)
	DEP( 0xa5a5a454, 2047, 13, 12, 0xa4ffe454)
	EXT( 0xa5a5a453, 13, 13, 0x00000d2d)
	EXTU(0xa5a5a453, 13, 13, 0x00000d2d)
	DEP( 0xa5a5a453, 4095, 13, 13, 0xa5ffe453)
	EXT( 0xa5a5a452, 13, 14, 0xffffed2d)
	EXTU(0xa5a5a452, 13, 14, 0x00002d2d)
	DEP( 0xa5a5a452, 8191, 13, 14, 0xa3ffe452)
	EXT( 0xa5a5a451, 13, 15, 0x00002d2d)
	EXTU(0xa5a5a451, 13, 15, 0x00002d2d)
	DEP( 0xa5a5a451, 16383, 13, 15, 0xa7ffe451)
	EXT( 0xa5a5a450, 13, 16, 0x00002d2d)
	EXTU(0xa5a5a450, 13, 16, 0x00002d2d)
	DEP( 0xa5a5a450, 32767, 13, 16, 0xafffe450)
	EXT( 0xa5a5a44f, 13, 17, 0xffff2d2d)
	EXTU(0xa5a5a44f, 13, 17, 0x00012d2d)
	DEP( 0xa5a5a44f, 65535, 13, 17, 0x9fffe44f)
	EXT( 0xa5a5a44e, 13, 18, 0x00012d2d)
	EXTU(0xa5a5a44e, 13, 18, 0x00012d2d)
	DEP( 0xa5a5a44e, 131071, 13, 18, 0xbfffe44e)
	EXT( 0xa5a5a44d, 14, 1, 0x00000000)
	EXTU(0xa5a5a44d, 14, 1, 0x00000000)
	DEP( 0xa5a5a44d, 0, 14, 1, 0xa5a5a44d)
	EXT( 0xa5a5a44c, 14, 2, 0xfffffffe)
	EXTU(0xa5a5a44c, 14, 2, 0x00000002)
	DEP( 0xa5a5a44c, 1, 14, 2, 0xa5a5644c)
	EXT( 0xa5a5a44b, 14, 3, 0xfffffffe)
	EXTU(0xa5a5a44b, 14, 3, 0x00000006)
	DEP( 0xa5a5a44b, 3, 14, 3, 0xa5a4e44b)
	EXT( 0xa5a5a44a, 14, 4, 0x00000006)
	EXTU(0xa5a5a44a, 14, 4, 0x00000006)
	DEP( 0xa5a5a44a, 7, 14, 4, 0xa5a5e44a)
	EXT( 0xa5a5a449, 14, 5, 0xfffffff6)
	EXTU(0xa5a5a449, 14, 5, 0x00000016)
	DEP( 0xa5a5a449, 15, 14, 5, 0xa5a3e449)
	EXT( 0xa5a5a448, 14, 6, 0x00000016)
	EXTU(0xa5a5a448, 14, 6, 0x00000016)
	DEP( 0xa5a5a448, 31, 14, 6, 0xa5a7e448)
	EXT( 0xa5a5a447, 14, 7, 0x00000016)
	EXTU(0xa5a5a447, 14, 7, 0x00000016)
	DEP( 0xa5a5a447, 63, 14, 7, 0xa5afe447)
	EXT( 0xa5a5a446, 14, 8, 0xffffff96)
	EXTU(0xa5a5a446, 14, 8, 0x00000096)
	DEP( 0xa5a5a446, 127, 14, 8, 0xa59fe446)
	EXT( 0xa5a5a445, 14, 9, 0x00000096)
	EXTU(0xa5a5a445, 14, 9, 0x00000096)
	DEP( 0xa5a5a445, 255, 14, 9, 0xa5bfe445)
	EXT( 0xa5a5a444, 14, 10, 0xfffffe96)
	EXTU(0xa5a5a444, 14, 10, 0x00000296)
	DEP( 0xa5a5a444, 511, 14, 10, 0xa57fe444)
	EXT( 0xa5a5a443, 14, 11, 0xfffffe96)
	EXTU(0xa5a5a443, 14, 11, 0x00000696)
	DEP( 0xa5a5a443, 1023, 14, 11, 0xa4ffe443)
	EXT( 0xa5a5a442, 14, 12, 0x00000696)
	EXTU(0xa5a5a442, 14, 12, 0x00000696)
	DEP( 0xa5a5a442, 2047, 14, 12, 0xa5ffe442)
	EXT( 0xa5a5a441, 14, 13, 0xfffff696)
	EXTU(0xa5a5a441, 14, 13, 0x00001696)
	DEP( 0xa5a5a441, 4095, 14, 13, 0xa3ffe441)
	EXT( 0xa5a5a440, 14, 14, 0x00001696)
	EXTU(0xa5a5a440, 14, 14, 0x00001696)
	DEP( 0xa5a5a440, 8191, 14, 14, 0xa7ffe440)
	EXT( 0xa5a5a43f, 14, 15, 0x00001696)
	EXTU(0xa5a5a43f, 14, 15, 0x00001696)
	DEP( 0xa5a5a43f, 16383, 14, 15, 0xafffe43f)
	EXT( 0xa5a5a43e, 14, 16, 0xffff9696)
	EXTU(0xa5a5a43e, 14, 16, 0x00009696)
	DEP( 0xa5a5a43e, 32767, 14, 16, 0x9fffe43e)
	EXT( 0xa5a5a43d, 14, 17, 0x00009696)
	EXTU(0xa5a5a43d, 14, 17, 0x00009696)
	DEP( 0xa5a5a43d, 65535, 14, 17, 0xbfffe43d)
	EXT( 0xa5a5a43c, 15, 1, 0xffffffff)
	EXTU(0xa5a5a43c, 15, 1, 0x00000001)
	DEP( 0xa5a5a43c, 0, 15, 1, 0xa5a5243c)
	EXT( 0xa5a5a43b, 15, 2, 0xffffffff)
	EXTU(0xa5a5a43b, 15, 2, 0x00000003)
	DEP( 0xa5a5a43b, 1, 15, 2, 0xa5a4a43b)
	EXT( 0xa5a5a43a, 15, 3, 0x00000003)
	EXTU(0xa5a5a43a, 15, 3, 0x00000003)
	DEP( 0xa5a5a43a, 3, 15, 3, 0xa5a5a43a)
	EXT( 0xa5a5a439, 15, 4, 0xfffffffb)
	EXTU(0xa5a5a439, 15, 4, 0x0000000b)
	DEP( 0xa5a5a439, 7, 15, 4, 0xa5a3a439)
	EXT( 0xa5a5a438, 15, 5, 0x0000000b)
	EXTU(0xa5a5a438, 15, 5, 0x0000000b)
	DEP( 0xa5a5a438, 15, 15, 5, 0xa5a7a438)
	EXT( 0xa5a5a437, 15, 6, 0x0000000b)
	EXTU(0xa5a5a437, 15, 6, 0x0000000b)
	DEP( 0xa5a5a437, 31, 15, 6, 0xa5afa437)
	EXT( 0xa5a5a436, 15, 7, 0xffffffcb)
	EXTU(0xa5a5a436, 15, 7, 0x0000004b)
	DEP( 0xa5a5a436, 63, 15, 7, 0xa59fa436)
	EXT( 0xa5a5a435, 15, 8, 0x0000004b)
	EXTU(0xa5a5a435, 15, 8, 0x0000004b)
	DEP( 0xa5a5a435, 127, 15, 8, 0xa5bfa435)
	EXT( 0xa5a5a434, 15, 9, 0xffffff4b)
	EXTU(0xa5a5a434, 15, 9, 0x0000014b)
	DEP( 0xa5a5a434, 255, 15, 9, 0xa57fa434)
	EXT( 0xa5a5a433, 15, 10, 0xffffff4b)
	EXTU(0xa5a5a433, 15, 10, 0x0000034b)
	DEP( 0xa5a5a433, 511, 15, 10, 0xa4ffa433)
	EXT( 0xa5a5a432, 15, 11, 0x0000034b)
	EXTU(0xa5a5a432, 15, 11, 0x0000034b)
	DEP( 0xa5a5a432, 1023, 15, 11, 0xa5ffa432)
	EXT( 0xa5a5a431, 15, 12, 0xfffffb4b)
	EXTU(0xa5a5a431, 15, 12, 0x00000b4b)
	DEP( 0xa5a5a431, 2047, 15, 12, 0xa3ffa431)
	EXT( 0xa5a5a430, 15, 13, 0x00000b4b)
	EXTU(0xa5a5a430, 15, 13, 0x00000b4b)
	DEP( 0xa5a5a430, 4095, 15, 13, 0xa7ffa430)
	EXT( 0xa5a5a42f, 15, 14, 0x00000b4b)
	EXTU(0xa5a5a42f, 15, 14, 0x00000b4b)
	DEP( 0xa5a5a42f, 8191, 15, 14, 0xafffa42f)
	EXT( 0xa5a5a42e, 15, 15, 0xffffcb4b)
	EXTU(0xa5a5a42e, 15, 15, 0x00004b4b)
	DEP( 0xa5a5a42e, 16383, 15, 15, 0x9fffa42e)
	EXT( 0xa5a5a42d, 15, 16, 0x00004b4b)
	EXTU(0xa5a5a42d, 15, 16, 0x00004b4b)
	DEP( 0xa5a5a42d, 32767, 15, 16, 0xbfffa42d)
	EXT( 0xa5a5a42c, 16, 1, 0xffffffff)
	EXTU(0xa5a5a42c, 16, 1, 0x00000001)
	DEP( 0xa5a5a42c, 0, 16, 1, 0xa5a4a42c)
	EXT( 0xa5a5a42b, 16, 2, 0x00000001)
	EXTU(0xa5a5a42b, 16, 2, 0x00000001)
	DEP( 0xa5a5a42b, 1, 16, 2, 0xa5a5a42b)
	EXT( 0xa5a5a42a, 16, 3, 0xfffffffd)
	EXTU(0xa5a5a42a, 16, 3, 0x00000005)
	DEP( 0xa5a5a42a, 3, 16, 3, 0xa5a3a42a)
	EXT( 0xa5a5a429, 16, 4, 0x00000005)
	EXTU(0xa5a5a429, 16, 4, 0x00000005)
	DEP( 0xa5a5a429, 7, 16, 4, 0xa5a7a429)
	EXT( 0xa5a5a428, 16, 5, 0x00000005)
	EXTU(0xa5a5a428, 16, 5, 0x00000005)
	DEP( 0xa5a5a428, 15, 16, 5, 0xa5afa428)
	EXT( 0xa5a5a427, 16, 6, 0xffffffe5)
	EXTU(0xa5a5a427, 16, 6, 0x00000025)
	DEP( 0xa5a5a427, 31, 16, 6, 0xa59fa427)
	EXT( 0xa5a5a426, 16, 7, 0x00000025)
	EXTU(0xa5a5a426, 16, 7, 0x00000025)
	DEP( 0xa5a5a426, 63, 16, 7, 0xa5bfa426)
	EXT( 0xa5a5a425, 16, 8, 0xffffffa5)
	EXTU(0xa5a5a425, 16, 8, 0x000000a5)
	DEP( 0xa5a5a425, 127, 16, 8, 0xa57fa425)
	EXT( 0xa5a5a424, 16, 9, 0xffffffa5)
	EXTU(0xa5a5a424, 16, 9, 0x000001a5)
	DEP( 0xa5a5a424, 255, 16, 9, 0xa4ffa424)
	EXT( 0xa5a5a423, 16, 10, 0x000001a5)
	EXTU(0xa5a5a423, 16, 10, 0x000001a5)
	DEP( 0xa5a5a423, 511, 16, 10, 0xa5ffa423)
	EXT( 0xa5a5a422, 16, 11, 0xfffffda5)
	EXTU(0xa5a5a422, 16, 11, 0x000005a5)
	DEP( 0xa5a5a422, 1023, 16, 11, 0xa3ffa422)
	EXT( 0xa5a5a421, 16, 12, 0x000005a5)
	EXTU(0xa5a5a421, 16, 12, 0x000005a5)
	DEP( 0xa5a5a421, 2047, 16, 12, 0xa7ffa421)
	EXT( 0xa5a5a420, 16, 13, 0x000005a5)
	EXTU(0xa5a5a420, 16, 13, 0x000005a5)
	DEP( 0xa5a5a420, 4095, 16, 13, 0xafffa420)
	EXT( 0xa5a5a41f, 16, 14, 0xffffe5a5)
	EXTU(0xa5a5a41f, 16, 14, 0x000025a5)
	DEP( 0xa5a5a41f, 8191, 16, 14, 0x9fffa41f)
	EXT( 0xa5a5a41e, 16, 15, 0x000025a5)
	EXTU(0xa5a5a41e, 16, 15, 0x000025a5)
	DEP( 0xa5a5a41e, 16383, 16, 15, 0xbfffa41e)
	EXT( 0xa5a5a41d, 17, 1, 0x00000000)
	EXTU(0xa5a5a41d, 17, 1, 0x00000000)
	DEP( 0xa5a5a41d, 0, 17, 1, 0xa5a5a41d)
	EXT( 0xa5a5a41c, 17, 2, 0xfffffffe)
	EXTU(0xa5a5a41c, 17, 2, 0x00000002)
	DEP( 0xa5a5a41c, 1, 17, 2, 0xa5a3a41c)
	EXT( 0xa5a5a41b, 17, 3, 0x00000002)
	EXTU(0xa5a5a41b, 17, 3, 0x00000002)
	DEP( 0xa5a5a41b, 3, 17, 3, 0xa5a7a41b)
	EXT( 0xa5a5a41a, 17, 4, 0x00000002)
	EXTU(0xa5a5a41a, 17, 4, 0x00000002)
	DEP( 0xa5a5a41a, 7, 17, 4, 0xa5afa41a)
	EXT( 0xa5a5a419, 17, 5, 0xfffffff2)
	EXTU(0xa5a5a419, 17, 5, 0x00000012)
	DEP( 0xa5a5a419, 15, 17, 5, 0xa59fa419)
	EXT( 0xa5a5a418, 17, 6, 0x00000012)
	EXTU(0xa5a5a418, 17, 6, 0x00000012)
	DEP( 0xa5a5a418, 31, 17, 6, 0xa5bfa418)
	EXT( 0xa5a5a417, 17, 7, 0xffffffd2)
	EXTU(0xa5a5a417, 17, 7, 0x00000052)
	DEP( 0xa5a5a417, 63, 17, 7, 0xa57fa417)
	EXT( 0xa5a5a416, 17, 8, 0xffffffd2)
	EXTU(0xa5a5a416, 17, 8, 0x000000d2)
	DEP( 0xa5a5a416, 127, 17, 8, 0xa4ffa416)
	EXT( 0xa5a5a415, 17, 9, 0x000000d2)
	EXTU(0xa5a5a415, 17, 9, 0x000000d2)
	DEP( 0xa5a5a415, 255, 17, 9, 0xa5ffa415)
	EXT( 0xa5a5a414, 17, 10, 0xfffffed2)
	EXTU(0xa5a5a414, 17, 10, 0x000002d2)
	DEP( 0xa5a5a414, 511, 17, 10, 0xa3ffa414)
	EXT( 0xa5a5a413, 17, 11, 0x000002d2)
	EXTU(0xa5a5a413, 17, 11, 0x000002d2)
	DEP( 0xa5a5a413, 1023, 17, 11, 0xa7ffa413)
	EXT( 0xa5a5a412, 17, 12, 0x000002d2)
	EXTU(0xa5a5a412, 17, 12, 0x000002d2)
	DEP( 0xa5a5a412, 2047, 17, 12, 0xafffa412)
	EXT( 0xa5a5a411, 17, 13, 0xfffff2d2)
	EXTU(0xa5a5a411, 17, 13, 0x000012d2)
	DEP( 0xa5a5a411, 4095, 17, 13, 0x9fffa411)
	EXT( 0xa5a5a410, 17, 14, 0x000012d2)
	EXTU(0xa5a5a410, 17, 14, 0x000012d2)
	DEP( 0xa5a5a410, 8191, 17, 14, 0xbfffa410)
	EXT( 0xa5a5a40f, 18, 1, 0xffffffff)
	EXTU(0xa5a5a40f, 18, 1, 0x00000001)
	DEP( 0xa5a5a40f, 0, 18, 1, 0xa5a1a40f)
	EXT( 0xa5a5a40e, 18, 2, 0x00000001)
	EXTU(0xa5a5a40e, 18, 2, 0x00000001)
	DEP( 0xa5a5a40e, 1, 18, 2, 0xa5a5a40e)
	EXT( 0xa5a5a40d, 18, 3, 0x00000001)
	EXTU(0xa5a5a40d, 18, 3, 0x00000001)
	DEP( 0xa5a5a40d, 3, 18, 3, 0xa5ada40d)
	EXT( 0xa5a5a40c, 18, 4, 0xfffffff9)
	EXTU(0xa5a5a40c, 18, 4, 0x00000009)
	DEP( 0xa5a5a40c, 7, 18, 4, 0xa59da40c)
	EXT( 0xa5a5a40b, 18, 5, 0x00000009)
	EXTU(0xa5a5a40b, 18, 5, 0x00000009)
	DEP( 0xa5a5a40b, 15, 18, 5, 0xa5bda40b)
	EXT( 0xa5a5a40a, 18, 6, 0xffffffe9)
	EXTU(0xa5a5a40a, 18, 6, 0x00000029)
	DEP( 0xa5a5a40a, 31, 18, 6, 0xa57da40a)
	EXT( 0xa5a5a409, 18, 7, 0xffffffe9)
	EXTU(0xa5a5a409, 18, 7, 0x00000069)
	DEP( 0xa5a5a409, 63, 18, 7, 0xa4fda409)
	EXT( 0xa5a5a408, 18, 8, 0x00000069)
	EXTU(0xa5a5a408, 18, 8, 0x00000069)
	DEP( 0xa5a5a408, 127, 18, 8, 0xa5fda408)
	EXT( 0xa5a5a407, 18, 9, 0xffffff69)
	EXTU(0xa5a5a407, 18, 9, 0x00000169)
	DEP( 0xa5a5a407, 255, 18, 9, 0xa3fda407)
	EXT( 0xa5a5a406, 18, 10, 0x00000169)
	EXTU(0xa5a5a406, 18, 10, 0x00000169)
	DEP( 0xa5a5a406, 511, 18, 10, 0xa7fda406)
	EXT( 0xa5a5a405, 18, 11, 0x00000169)
	EXTU(0xa5a5a405, 18, 11, 0x00000169)
	DEP( 0xa5a5a405, 1023, 18, 11, 0xaffda405)
	EXT( 0xa5a5a404, 18, 12, 0xfffff969)
	EXTU(0xa5a5a404, 18, 12, 0x00000969)
	DEP( 0xa5a5a404, 2047, 18, 12, 0x9ffda404)
	EXT( 0xa5a5a403, 18, 13, 0x00000969)
	EXTU(0xa5a5a403, 18, 13, 0x00000969)
	DEP( 0xa5a5a403, 4095, 18, 13, 0xbffda403)
	EXT( 0xa5a5a402, 19, 1, 0x00000000)
	EXTU(0xa5a5a402, 19, 1, 0x00000000)
	DEP( 0xa5a5a402, 0, 19, 1, 0xa5a5a402)
	EXT( 0xa5a5a401, 19, 2, 0x00000000)
	EXTU(0xa5a5a401, 19, 2, 0x00000000)
	DEP( 0xa5a5a401, 1, 19, 2, 0xa5ada401)
	EXT( 0xa5a5a400, 19, 3, 0xfffffffc)
	EXTU(0xa5a5a400, 19, 3, 0x00000004)
	DEP( 0xa5a5a400, 3, 19, 3, 0xa59da400)
	EXT( 0xa5a5a3ff, 19, 4, 0x00000004)
	EXTU(0xa5a5a3ff, 19, 4, 0x00000004)
	DEP( 0xa5a5a3ff, 7, 19, 4, 0xa5bda3ff)
	EXT( 0xa5a5a3fe, 19, 5, 0xfffffff4)
	EXTU(0xa5a5a3fe, 19, 5, 0x00000014)
	DEP( 0xa5a5a3fe, 15, 19, 5, 0xa57da3fe)
	EXT( 0xa5a5a3fd, 19, 6, 0xfffffff4)
	EXTU(0xa5a5a3fd, 19, 6, 0x00000034)
	DEP( 0xa5a5a3fd, 31, 19, 6, 0xa4fda3fd)
	EXT( 0xa5a5a3fc, 19, 7, 0x00000034)
	EXTU(0xa5a5a3fc, 19, 7, 0x00000034)
	DEP( 0xa5a5a3fc, 63, 19, 7, 0xa5fda3fc)
	EXT( 0xa5a5a3fb, 19, 8, 0xffffffb4)
	EXTU(0xa5a5a3fb, 19, 8, 0x000000b4)
	DEP( 0xa5a5a3fb, 127, 19, 8, 0xa3fda3fb)
	EXT( 0xa5a5a3fa, 19, 9, 0x000000b4)
	EXTU(0xa5a5a3fa, 19, 9, 0x000000b4)
	DEP( 0xa5a5a3fa, 255, 19, 9, 0xa7fda3fa)
	EXT( 0xa5a5a3f9, 19, 10, 0x000000b4)
	EXTU(0xa5a5a3f9, 19, 10, 0x000000b4)
	DEP( 0xa5a5a3f9, 511, 19, 10, 0xaffda3f9)
	EXT( 0xa5a5a3f8, 19, 11, 0xfffffcb4)
	EXTU(0xa5a5a3f8, 19, 11, 0x000004b4)
	DEP( 0xa5a5a3f8, 1023, 19, 11, 0x9ffda3f8)
	EXT( 0xa5a5a3f7, 19, 12, 0x000004b4)
	EXTU(0xa5a5a3f7, 19, 12, 0x000004b4)
	DEP( 0xa5a5a3f7, 2047, 19, 12, 0xbffda3f7)
	EXT( 0xa5a5a3f6, 20, 1, 0x00000000)
	EXTU(0xa5a5a3f6, 20, 1, 0x00000000)
	DEP( 0xa5a5a3f6, 0, 20, 1, 0xa5a5a3f6)
	EXT( 0xa5a5a3f5, 20, 2, 0xfffffffe)
	EXTU(0xa5a5a3f5, 20, 2, 0x00000002)
	DEP( 0xa5a5a3f5, 1, 20, 2, 0xa595a3f5)
	EXT( 0xa5a5a3f4, 20, 3, 0x00000002)
	EXTU(0xa5a5a3f4, 20, 3, 0x00000002)
	DEP( 0xa5a5a3f4, 3, 20, 3, 0xa5b5a3f4)
	EXT( 0xa5a5a3f3, 20, 4, 0xfffffffa)
	EXTU(0xa5a5a3f3, 20, 4, 0x0000000a)
	DEP( 0xa5a5a3f3, 7, 20, 4, 0xa575a3f3)
	EXT( 0xa5a5a3f2, 20, 5, 0xfffffffa)
	EXTU(0xa5a5a3f2, 20, 5, 0x0000001a)
	DEP( 0xa5a5a3f2, 15, 20, 5, 0xa4f5a3f2)
	EXT( 0xa5a5a3f1, 20, 6, 0x0000001a)
	EXTU(0xa5a5a3f1, 20, 6, 0x0000001a)
	DEP( 0xa5a5a3f1, 31, 20, 6, 0xa5f5a3f1)
	EXT( 0xa5a5a3f0, 20, 7, 0xffffffda)
	EXTU(0xa5a5a3f0, 20, 7, 0x0000005a)
	DEP( 0xa5a5a3f0, 63, 20, 7, 0xa3f5a3f0)
	EXT( 0xa5a5a3ef, 20, 8, 0x0000005a)
	EXTU(0xa5a5a3ef, 20, 8, 0x0000005a)
	DEP( 0xa5a5a3ef, 127, 20, 8, 0xa7f5a3ef)
	EXT( 0xa5a5a3ee, 20, 9, 0x0000005a)
	EXTU(0xa5a5a3ee, 20, 9, 0x0000005a)
	DEP( 0xa5a5a3ee, 255, 20, 9, 0xaff5a3ee)
	EXT( 0xa5a5a3ed, 20, 10, 0xfffffe5a)
	EXTU(0xa5a5a3ed, 20, 10, 0x0000025a)
	DEP( 0xa5a5a3ed, 511, 20, 10, 0x9ff5a3ed)
	EXT( 0xa5a5a3ec, 20, 11, 0x0000025a)
	EXTU(0xa5a5a3ec, 20, 11, 0x0000025a)
	DEP( 0xa5a5a3ec, 1023, 20, 11, 0xbff5a3ec)
	EXT( 0xa5a5a3eb, 21, 1, 0xffffffff)
	EXTU(0xa5a5a3eb, 21, 1, 0x00000001)
	DEP( 0xa5a5a3eb, 0, 21, 1, 0xa585a3eb)
	EXT( 0xa5a5a3ea, 21, 2, 0x00000001)
	EXTU(0xa5a5a3ea, 21, 2, 0x00000001)
	DEP( 0xa5a5a3ea, 1, 21, 2, 0xa5a5a3ea)
	EXT( 0xa5a5a3e9, 21, 3, 0xfffffffd)
	EXTU(0xa5a5a3e9, 21, 3, 0x00000005)
	DEP( 0xa5a5a3e9, 3, 21, 3, 0xa565a3e9)
	EXT( 0xa5a5a3e8, 21, 4, 0xfffffffd)
	EXTU(0xa5a5a3e8, 21, 4, 0x0000000d)
	DEP( 0xa5a5a3e8, 7, 21, 4, 0xa4e5a3e8)
	EXT( 0xa5a5a3e7, 21, 5, 0x0000000d)
	EXTU(0xa5a5a3e7, 21, 5, 0x0000000d)
	DEP( 0xa5a5a3e7, 15, 21, 5, 0xa5e5a3e7)
	EXT( 0xa5a5a3e6, 21, 6, 0xffffffed)
	EXTU(0xa5a5a3e6, 21, 6, 0x0000002d)
	DEP( 0xa5a5a3e6, 31, 21, 6, 0xa3e5a3e6)
	EXT( 0xa5a5a3e5, 21, 7, 0x0000002d)
	EXTU(0xa5a5a3e5, 21, 7, 0x0000002d)
	DEP( 0xa5a5a3e5, 63, 21, 7, 0xa7e5a3e5)
	EXT( 0xa5a5a3e4, 21, 8, 0x0000002d)
	EXTU(0xa5a5a3e4, 21, 8, 0x0000002d)
	DEP( 0xa5a5a3e4, 127, 21, 8, 0xafe5a3e4)
	EXT( 0xa5a5a3e3, 21, 9, 0xffffff2d)
	EXTU(0xa5a5a3e3, 21, 9, 0x0000012d)
	DEP( 0xa5a5a3e3, 255, 21, 9, 0x9fe5a3e3)
	EXT( 0xa5a5a3e2, 21, 10, 0x0000012d)
	EXTU(0xa5a5a3e2, 21, 10, 0x0000012d)
	DEP( 0xa5a5a3e2, 511, 21, 10, 0xbfe5a3e2)
	EXT( 0xa5a5a3e1, 22, 1, 0x00000000)
	EXTU(0xa5a5a3e1, 22, 1, 0x00000000)
	DEP( 0xa5a5a3e1, 0, 22, 1, 0xa5a5a3e1)
	EXT( 0xa5a5a3e0, 22, 2, 0xfffffffe)
	EXTU(0xa5a5a3e0, 22, 2, 0x00000002)
	DEP( 0xa5a5a3e0, 1, 22, 2, 0xa565a3e0)
	EXT( 0xa5a5a3df, 22, 3, 0xfffffffe)
	EXTU(0xa5a5a3df, 22, 3, 0x00000006)
	DEP( 0xa5a5a3df, 3, 22, 3, 0xa4e5a3df)
	EXT( 0xa5a5a3de, 22, 4, 0x00000006)
	EXTU(0xa5a5a3de, 22, 4, 0x00000006)
	DEP( 0xa5a5a3de, 7, 22, 4, 0xa5e5a3de)
	EXT( 0xa5a5a3dd, 22, 5, 0xfffffff6)
	EXTU(0xa5a5a3dd, 22, 5, 0x00000016)
	DEP( 0xa5a5a3dd, 15, 22, 5, 0xa3e5a3dd)
	EXT( 0xa5a5a3dc, 22, 6, 0x00000016)
	EXTU(0xa5a5a3dc, 22, 6, 0x00000016)
	DEP( 0xa5a5a3dc, 31, 22, 6, 0xa7e5a3dc)
	EXT( 0xa5a5a3db, 22, 7, 0x00000016)
	EXTU(0xa5a5a3db, 22, 7, 0x00000016)
	DEP( 0xa5a5a3db, 63, 22, 7, 0xafe5a3db)
	EXT( 0xa5a5a3da, 22, 8, 0xffffff96)
	EXTU(0xa5a5a3da, 22, 8, 0x00000096)
	DEP( 0xa5a5a3da, 127, 22, 8, 0x9fe5a3da)
	EXT( 0xa5a5a3d9, 22, 9, 0x00000096)
	EXTU(0xa5a5a3d9, 22, 9, 0x00000096)
	DEP( 0xa5a5a3d9, 255, 22, 9, 0xbfe5a3d9)
	EXT( 0xa5a5a3d8, 23, 1, 0xffffffff)
	EXTU(0xa5a5a3d8, 23, 1, 0x00000001)
	DEP( 0xa5a5a3d8, 0, 23, 1, 0xa525a3d8)
	EXT( 0xa5a5a3d7, 23, 2, 0xffffffff)
	EXTU(0xa5a5a3d7, 23, 2, 0x00000003)
	DEP( 0xa5a5a3d7, 1, 23, 2, 0xa4a5a3d7)
	EXT( 0xa5a5a3d6, 23, 3, 0x00000003)
	EXTU(0xa5a5a3d6, 23, 3, 0x00000003)
	DEP( 0xa5a5a3d6, 3, 23, 3, 0xa5a5a3d6)
	EXT( 0xa5a5a3d5, 23, 4, 0xfffffffb)
	EXTU(0xa5a5a3d5, 23, 4, 0x0000000b)
	DEP( 0xa5a5a3d5, 7, 23, 4, 0xa3a5a3d5)
	EXT( 0xa5a5a3d4, 23, 5, 0x0000000b)
	EXTU(0xa5a5a3d4, 23, 5, 0x0000000b)
	DEP( 0xa5a5a3d4, 15, 23, 5, 0xa7a5a3d4)
	EXT( 0xa5a5a3d3, 23, 6, 0x0000000b)
	EXTU(0xa5a5a3d3, 23, 6, 0x0000000b)
	DEP( 0xa5a5a3d3, 31, 23, 6, 0xafa5a3d3)
	EXT( 0xa5a5a3d2, 23, 7, 0xffffffcb)
	EXTU(0xa5a5a3d2, 23, 7, 0x0000004b)
	DEP( 0xa5a5a3d2, 63, 23, 7, 0x9fa5a3d2)
	EXT( 0xa5a5a3d1, 23, 8, 0x0000004b)
	EXTU(0xa5a5a3d1, 23, 8, 0x0000004b)
	DEP( 0xa5a5a3d1, 127, 23, 8, 0xbfa5a3d1)
	EXT( 0xa5a5a3d0, 24, 1, 0xffffffff)
	EXTU(0xa5a5a3d0, 24, 1, 0x00000001)
	DEP( 0xa5a5a3d0, 0, 24, 1, 0xa4a5a3d0)
	EXT( 0xa5a5a3cf, 24, 2, 0x00000001)
	EXTU(0xa5a5a3cf, 24, 2, 0x00000001)
	DEP( 0xa5a5a3cf, 1, 24, 2, 0xa5a5a3cf)
	EXT( 0xa5a5a3ce, 24, 3, 0xfffffffd)
	EXTU(0xa5a5a3ce, 24, 3, 0x00000005)
	DEP( 0xa5a5a3ce, 3, 24, 3, 0xa3a5a3ce)
	EXT( 0xa5a5a3cd, 24, 4, 0x00000005)
	EXTU(0xa5a5a3cd, 24, 4, 0x00000005)
	DEP( 0xa5a5a3cd, 7, 24, 4, 0xa7a5a3cd)
	EXT( 0xa5a5a3cc, 24, 5, 0x00000005)
	EXTU(0xa5a5a3cc, 24, 5, 0x00000005)
	DEP( 0xa5a5a3cc, 15, 24, 5, 0xafa5a3cc)
	EXT( 0xa5a5a3cb, 24, 6, 0xffffffe5)
	EXTU(0xa5a5a3cb, 24, 6, 0x00000025)
	DEP( 0xa5a5a3cb, 31, 24, 6, 0x9fa5a3cb)
	EXT( 0xa5a5a3ca, 24, 7, 0x00000025)
	EXTU(0xa5a5a3ca, 24, 7, 0x00000025)
	DEP( 0xa5a5a3ca, 63, 24, 7, 0xbfa5a3ca)
	EXT( 0xa5a5a3c9, 25, 1, 0x00000000)
	EXTU(0xa5a5a3c9, 25, 1, 0x00000000)
	DEP( 0xa5a5a3c9, 0, 25, 1, 0xa5a5a3c9)
	EXT( 0xa5a5a3c8, 25, 2, 0xfffffffe)
	EXTU(0xa5a5a3c8, 25, 2, 0x00000002)
	DEP( 0xa5a5a3c8, 1, 25, 2, 0xa3a5a3c8)
	EXT( 0xa5a5a3c7, 25, 3, 0x00000002)
	EXTU(0xa5a5a3c7, 25, 3, 0x00000002)
	DEP( 0xa5a5a3c7, 3, 25, 3, 0xa7a5a3c7)
	EXT( 0xa5a5a3c6, 25, 4, 0x00000002)
	EXTU(0xa5a5a3c6, 25, 4, 0x00000002)
	DEP( 0xa5a5a3c6, 7, 25, 4, 0xafa5a3c6)
	EXT( 0xa5a5a3c5, 25, 5, 0xfffffff2)
	EXTU(0xa5a5a3c5, 25, 5, 0x00000012)
	DEP( 0xa5a5a3c5, 15, 25, 5, 0x9fa5a3c5)
	EXT( 0xa5a5a3c4, 25, 6, 0x00000012)
	EXTU(0xa5a5a3c4, 25, 6, 0x00000012)
	DEP( 0xa5a5a3c4, 31, 25, 6, 0xbfa5a3c4)
	EXT( 0xa5a5a3c3, 26, 1, 0xffffffff)
	EXTU(0xa5a5a3c3, 26, 1, 0x00000001)
	DEP( 0xa5a5a3c3, 0, 26, 1, 0xa1a5a3c3)
	EXT( 0xa5a5a3c2, 26, 2, 0x00000001)
	EXTU(0xa5a5a3c2, 26, 2, 0x00000001)
	DEP( 0xa5a5a3c2, 1, 26, 2, 0xa5a5a3c2)
	EXT( 0xa5a5a3c1, 26, 3, 0x00000001)
	EXTU(0xa5a5a3c1, 26, 3, 0x00000001)
	DEP( 0xa5a5a3c1, 3, 26, 3, 0xada5a3c1)
	EXT( 0xa5a5a3c0, 26, 4, 0xfffffff9)
	EXTU(0xa5a5a3c0, 26, 4, 0x00000009)
	DEP( 0xa5a5a3c0, 7, 26, 4, 0x9da5a3c0)
	EXT( 0xa5a5a3bf, 26, 5, 0x00000009)
	EXTU(0xa5a5a3bf, 26, 5, 0x00000009)
	DEP( 0xa5a5a3bf, 15, 26, 5, 0xbda5a3bf)
	EXT( 0xa5a5a3be, 27, 1, 0x00000000)
	EXTU(0xa5a5a3be, 27, 1, 0x00000000)
	DEP( 0xa5a5a3be, 0, 27, 1, 0xa5a5a3be)
	EXT( 0xa5a5a3bd, 27, 2, 0x00000000)
	EXTU(0xa5a5a3bd, 27, 2, 0x00000000)
	DEP( 0xa5a5a3bd, 1, 27, 2, 0xada5a3bd)
	EXT( 0xa5a5a3bc, 27, 3, 0xfffffffc)
	EXTU(0xa5a5a3bc, 27, 3, 0x00000004)
	DEP( 0xa5a5a3bc, 3, 27, 3, 0x9da5a3bc)
	EXT( 0xa5a5a3bb, 27, 4, 0x00000004)
	EXTU(0xa5a5a3bb, 27, 4, 0x00000004)
	DEP( 0xa5a5a3bb, 7, 27, 4, 0xbda5a3bb)
	EXT( 0xa5a5a3ba, 28, 1, 0x00000000)
	EXTU(0xa5a5a3ba, 28, 1, 0x00000000)
	DEP( 0xa5a5a3ba, 0, 28, 1, 0xa5a5a3ba)
	EXT( 0xa5a5a3b9, 28, 2, 0xfffffffe)
	EXTU(0xa5a5a3b9, 28, 2, 0x00000002)
	DEP( 0xa5a5a3b9, 1, 28, 2, 0x95a5a3b9)
	EXT( 0xa5a5a3b8, 28, 3, 0x00000002)
	EXTU(0xa5a5a3b8, 28, 3, 0x00000002)
	DEP( 0xa5a5a3b8, 3, 28, 3, 0xb5a5a3b8)
	EXT( 0xa5a5a3b7, 29, 1, 0xffffffff)
	EXTU(0xa5a5a3b7, 29, 1, 0x00000001)
	DEP( 0xa5a5a3b7, 0, 29, 1, 0x85a5a3b7)
	EXT( 0xa5a5a3b6, 29, 2, 0x00000001)
	EXTU(0xa5a5a3b6, 29, 2, 0x00000001)
	DEP( 0xa5a5a3b6, 1, 29, 2, 0xa5a5a3b6)
	EXT( 0xa5a5a3b5, 30, 1, 0x00000000)
	EXTU(0xa5a5a3b5, 30, 1, 0x00000000)
	DEP( 0xa5a5a3b5, 0, 30, 1, 0xa5a5a3b5)

#    else
	EXT( 0xa5a5a5a4, 0, 1, 0xffffffff)
	EXTU(0xa5a5a5a4, 0, 1, 0x00000001)
	DEP( 0xa5a5a5a4, 0, 0, 1, 0x25a5a5a4)
	EXT( 0xa5a5a5a3, 0, 2, 0xfffffffe)
	EXTU(0xa5a5a5a3, 0, 2, 0x00000002)
	DEP( 0xa5a5a5a3, 1, 0, 2, 0x65a5a5a3)
	EXT( 0xa5a5a5a2, 0, 3, 0xfffffffd)
	EXTU(0xa5a5a5a2, 0, 3, 0x00000005)
	DEP( 0xa5a5a5a2, 3, 0, 3, 0x65a5a5a2)
	EXT( 0xa5a5a5a1, 0, 4, 0xfffffffa)
	EXTU(0xa5a5a5a1, 0, 4, 0x0000000a)
	DEP( 0xa5a5a5a1, 7, 0, 4, 0x75a5a5a1)
	EXT( 0xa5a5a5a0, 0, 5, 0xfffffff4)
	EXTU(0xa5a5a5a0, 0, 5, 0x00000014)
	DEP( 0xa5a5a5a0, 15, 0, 5, 0x7da5a5a0)
	EXT( 0xa5a5a59f, 0, 6, 0xffffffe9)
	EXTU(0xa5a5a59f, 0, 6, 0x00000029)
	DEP( 0xa5a5a59f, 31, 0, 6, 0x7da5a59f)
	EXT( 0xa5a5a59e, 0, 7, 0xffffffd2)
	EXTU(0xa5a5a59e, 0, 7, 0x00000052)
	DEP( 0xa5a5a59e, 63, 0, 7, 0x7fa5a59e)
	EXT( 0xa5a5a59d, 0, 8, 0xffffffa5)
	EXTU(0xa5a5a59d, 0, 8, 0x000000a5)
	DEP( 0xa5a5a59d, 127, 0, 8, 0x7fa5a59d)
	EXT( 0xa5a5a59c, 0, 9, 0xffffff4b)
	EXTU(0xa5a5a59c, 0, 9, 0x0000014b)
	DEP( 0xa5a5a59c, 255, 0, 9, 0x7fa5a59c)
	EXT( 0xa5a5a59b, 0, 10, 0xfffffe96)
	EXTU(0xa5a5a59b, 0, 10, 0x00000296)
	DEP( 0xa5a5a59b, 511, 0, 10, 0x7fe5a59b)
	EXT( 0xa5a5a59a, 0, 11, 0xfffffd2d)
	EXTU(0xa5a5a59a, 0, 11, 0x0000052d)
	DEP( 0xa5a5a59a, 1023, 0, 11, 0x7fe5a59a)
	EXT( 0xa5a5a599, 0, 12, 0xfffffa5a)
	EXTU(0xa5a5a599, 0, 12, 0x00000a5a)
	DEP( 0xa5a5a599, 2047, 0, 12, 0x7ff5a599)
	EXT( 0xa5a5a598, 0, 13, 0xfffff4b4)
	EXTU(0xa5a5a598, 0, 13, 0x000014b4)
	DEP( 0xa5a5a598, 4095, 0, 13, 0x7ffda598)
	EXT( 0xa5a5a597, 0, 14, 0xffffe969)
	EXTU(0xa5a5a597, 0, 14, 0x00002969)
	DEP( 0xa5a5a597, 8191, 0, 14, 0x7ffda597)
	EXT( 0xa5a5a596, 0, 15, 0xffffd2d2)
	EXTU(0xa5a5a596, 0, 15, 0x000052d2)
	DEP( 0xa5a5a596, 16383, 0, 15, 0x7fffa596)
	EXT( 0xa5a5a595, 0, 16, 0xffffa5a5)
	EXTU(0xa5a5a595, 0, 16, 0x0000a5a5)
	DEP( 0xa5a5a595, 32767, 0, 16, 0x7fffa595)
	EXT( 0xa5a5a594, 0, 17, 0xffff4b4b)
	EXTU(0xa5a5a594, 0, 17, 0x00014b4b)
	DEP( 0xa5a5a594, 65535, 0, 17, 0x7fffa594)
	EXT( 0xa5a5a593, 0, 18, 0xfffe9696)
	EXTU(0xa5a5a593, 0, 18, 0x00029696)
	DEP( 0xa5a5a593, 131071, 0, 18, 0x7fffe593)
	EXT( 0xa5a5a592, 0, 19, 0xfffd2d2d)
	EXTU(0xa5a5a592, 0, 19, 0x00052d2d)
	DEP( 0xa5a5a592, 262143, 0, 19, 0x7fffe592)
	EXT( 0xa5a5a591, 0, 20, 0xfffa5a5a)
	EXTU(0xa5a5a591, 0, 20, 0x000a5a5a)
	DEP( 0xa5a5a591, 524287, 0, 20, 0x7ffff591)
	EXT( 0xa5a5a590, 0, 21, 0xfff4b4b4)
	EXTU(0xa5a5a590, 0, 21, 0x0014b4b4)
	DEP( 0xa5a5a590, 1048575, 0, 21, 0x7ffffd90)
	EXT( 0xa5a5a58f, 0, 22, 0xffe96969)
	EXTU(0xa5a5a58f, 0, 22, 0x00296969)
	DEP( 0xa5a5a58f, 2097151, 0, 22, 0x7ffffd8f)
	EXT( 0xa5a5a58e, 0, 23, 0xffd2d2d2)
	EXTU(0xa5a5a58e, 0, 23, 0x0052d2d2)
	DEP( 0xa5a5a58e, 4194303, 0, 23, 0x7fffff8e)
	EXT( 0xa5a5a58d, 0, 24, 0xffa5a5a5)
	EXTU(0xa5a5a58d, 0, 24, 0x00a5a5a5)
	DEP( 0xa5a5a58d, 8388607, 0, 24, 0x7fffff8d)
	EXT( 0xa5a5a58c, 0, 25, 0xff4b4b4b)
	EXTU(0xa5a5a58c, 0, 25, 0x014b4b4b)
	DEP( 0xa5a5a58c, 16777215, 0, 25, 0x7fffff8c)
	EXT( 0xa5a5a58b, 0, 26, 0xfe969696)
	EXTU(0xa5a5a58b, 0, 26, 0x02969696)
	DEP( 0xa5a5a58b, 33554431, 0, 26, 0x7fffffcb)
	EXT( 0xa5a5a58a, 0, 27, 0xfd2d2d2c)
	EXTU(0xa5a5a58a, 0, 27, 0x052d2d2c)
	DEP( 0xa5a5a58a, 67108863, 0, 27, 0x7fffffea)
	EXT( 0xa5a5a589, 0, 28, 0xfa5a5a58)
	EXTU(0xa5a5a589, 0, 28, 0x0a5a5a58)
	DEP( 0xa5a5a589, 134217727, 0, 28, 0x7ffffff9)
	EXT( 0xa5a5a588, 0, 29, 0xf4b4b4b1)
	EXTU(0xa5a5a588, 0, 29, 0x14b4b4b1)
	DEP( 0xa5a5a588, 268435455, 0, 29, 0x7ffffff8)
	EXT( 0xa5a5a587, 0, 30, 0xe9696961)
	EXTU(0xa5a5a587, 0, 30, 0x29696961)
	DEP( 0xa5a5a587, 536870911, 0, 30, 0x7fffffff)
	EXT( 0xa5a5a586, 0, 31, 0xd2d2d2c3)
	EXTU(0xa5a5a586, 0, 31, 0x52d2d2c3)
	DEP( 0xa5a5a586, 1073741823, 0, 31, 0x7ffffffe)
	EXT( 0xa5a5a585, 1, 1, 0x00000000)
	EXTU(0xa5a5a585, 1, 1, 0x00000000)
	DEP( 0xa5a5a585, 0, 1, 1, 0xa5a5a585)
	EXT( 0xa5a5a584, 1, 2, 0x00000001)
	EXTU(0xa5a5a584, 1, 2, 0x00000001)
	DEP( 0xa5a5a584, 1, 1, 2, 0xa5a5a584)
	EXT( 0xa5a5a583, 1, 3, 0x00000002)
	EXTU(0xa5a5a583, 1, 3, 0x00000002)
	DEP( 0xa5a5a583, 3, 1, 3, 0xb5a5a583)
	EXT( 0xa5a5a582, 1, 4, 0x00000004)
	EXTU(0xa5a5a582, 1, 4, 0x00000004)
	DEP( 0xa5a5a582, 7, 1, 4, 0xbda5a582)
	EXT( 0xa5a5a581, 1, 5, 0x00000009)
	EXTU(0xa5a5a581, 1, 5, 0x00000009)
	DEP( 0xa5a5a581, 15, 1, 5, 0xbda5a581)
	EXT( 0xa5a5a580, 1, 6, 0x00000012)
	EXTU(0xa5a5a580, 1, 6, 0x00000012)
	DEP( 0xa5a5a580, 31, 1, 6, 0xbfa5a580)
	EXT( 0xa5a5a57f, 1, 7, 0x00000025)
	EXTU(0xa5a5a57f, 1, 7, 0x00000025)
	DEP( 0xa5a5a57f, 63, 1, 7, 0xbfa5a57f)
	EXT( 0xa5a5a57e, 1, 8, 0x0000004b)
	EXTU(0xa5a5a57e, 1, 8, 0x0000004b)
	DEP( 0xa5a5a57e, 127, 1, 8, 0xbfa5a57e)
	EXT( 0xa5a5a57d, 1, 9, 0x00000096)
	EXTU(0xa5a5a57d, 1, 9, 0x00000096)
	DEP( 0xa5a5a57d, 255, 1, 9, 0xbfe5a57d)
	EXT( 0xa5a5a57c, 1, 10, 0x0000012d)
	EXTU(0xa5a5a57c, 1, 10, 0x0000012d)
	DEP( 0xa5a5a57c, 511, 1, 10, 0xbfe5a57c)
	EXT( 0xa5a5a57b, 1, 11, 0x0000025a)
	EXTU(0xa5a5a57b, 1, 11, 0x0000025a)
	DEP( 0xa5a5a57b, 1023, 1, 11, 0xbff5a57b)
	EXT( 0xa5a5a57a, 1, 12, 0x000004b4)
	EXTU(0xa5a5a57a, 1, 12, 0x000004b4)
	DEP( 0xa5a5a57a, 2047, 1, 12, 0xbffda57a)
	EXT( 0xa5a5a579, 1, 13, 0x00000969)
	EXTU(0xa5a5a579, 1, 13, 0x00000969)
	DEP( 0xa5a5a579, 4095, 1, 13, 0xbffda579)
	EXT( 0xa5a5a578, 1, 14, 0x000012d2)
	EXTU(0xa5a5a578, 1, 14, 0x000012d2)
	DEP( 0xa5a5a578, 8191, 1, 14, 0xbfffa578)
	EXT( 0xa5a5a577, 1, 15, 0x000025a5)
	EXTU(0xa5a5a577, 1, 15, 0x000025a5)
	DEP( 0xa5a5a577, 16383, 1, 15, 0xbfffa577)
	EXT( 0xa5a5a576, 1, 16, 0x00004b4b)
	EXTU(0xa5a5a576, 1, 16, 0x00004b4b)
	DEP( 0xa5a5a576, 32767, 1, 16, 0xbfffa576)
	EXT( 0xa5a5a575, 1, 17, 0x00009696)
	EXTU(0xa5a5a575, 1, 17, 0x00009696)
	DEP( 0xa5a5a575, 65535, 1, 17, 0xbfffe575)
	EXT( 0xa5a5a574, 1, 18, 0x00012d2d)
	EXTU(0xa5a5a574, 1, 18, 0x00012d2d)
	DEP( 0xa5a5a574, 131071, 1, 18, 0xbfffe574)
	EXT( 0xa5a5a573, 1, 19, 0x00025a5a)
	EXTU(0xa5a5a573, 1, 19, 0x00025a5a)
	DEP( 0xa5a5a573, 262143, 1, 19, 0xbffff573)
	EXT( 0xa5a5a572, 1, 20, 0x0004b4b4)
	EXTU(0xa5a5a572, 1, 20, 0x0004b4b4)
	DEP( 0xa5a5a572, 524287, 1, 20, 0xbffffd72)
	EXT( 0xa5a5a571, 1, 21, 0x00096969)
	EXTU(0xa5a5a571, 1, 21, 0x00096969)
	DEP( 0xa5a5a571, 1048575, 1, 21, 0xbffffd71)
	EXT( 0xa5a5a570, 1, 22, 0x0012d2d2)
	EXTU(0xa5a5a570, 1, 22, 0x0012d2d2)
	DEP( 0xa5a5a570, 2097151, 1, 22, 0xbfffff70)
	EXT( 0xa5a5a56f, 1, 23, 0x0025a5a5)
	EXTU(0xa5a5a56f, 1, 23, 0x0025a5a5)
	DEP( 0xa5a5a56f, 4194303, 1, 23, 0xbfffff6f)
	EXT( 0xa5a5a56e, 1, 24, 0x004b4b4a)
	EXTU(0xa5a5a56e, 1, 24, 0x004b4b4a)
	DEP( 0xa5a5a56e, 8388607, 1, 24, 0xbfffffee)
	EXT( 0xa5a5a56d, 1, 25, 0x00969695)
	EXTU(0xa5a5a56d, 1, 25, 0x00969695)
	DEP( 0xa5a5a56d, 16777215, 1, 25, 0xbfffffed)
	EXT( 0xa5a5a56c, 1, 26, 0x012d2d2b)
	EXTU(0xa5a5a56c, 1, 26, 0x012d2d2b)
	DEP( 0xa5a5a56c, 33554431, 1, 26, 0xbfffffec)
	EXT( 0xa5a5a56b, 1, 27, 0x025a5a56)
	EXTU(0xa5a5a56b, 1, 27, 0x025a5a56)
	DEP( 0xa5a5a56b, 67108863, 1, 27, 0xbffffffb)
	EXT( 0xa5a5a56a, 1, 28, 0x04b4b4ad)
	EXTU(0xa5a5a56a, 1, 28, 0x04b4b4ad)
	DEP( 0xa5a5a56a, 134217727, 1, 28, 0xbffffffa)
	EXT( 0xa5a5a569, 1, 29, 0x0969695a)
	EXTU(0xa5a5a569, 1, 29, 0x0969695a)
	DEP( 0xa5a5a569, 268435455, 1, 29, 0xbffffffd)
	EXT( 0xa5a5a568, 1, 30, 0x12d2d2b4)
	EXTU(0xa5a5a568, 1, 30, 0x12d2d2b4)
	DEP( 0xa5a5a568, 536870911, 1, 30, 0xbffffffe)
	EXT( 0xa5a5a567, 2, 1, 0xffffffff)
	EXTU(0xa5a5a567, 2, 1, 0x00000001)
	DEP( 0xa5a5a567, 0, 2, 1, 0x85a5a567)
	EXT( 0xa5a5a566, 2, 2, 0xfffffffe)
	EXTU(0xa5a5a566, 2, 2, 0x00000002)
	DEP( 0xa5a5a566, 1, 2, 2, 0x95a5a566)
	EXT( 0xa5a5a565, 2, 3, 0xfffffffc)
	EXTU(0xa5a5a565, 2, 3, 0x00000004)
	DEP( 0xa5a5a565, 3, 2, 3, 0x9da5a565)
	EXT( 0xa5a5a564, 2, 4, 0xfffffff9)
	EXTU(0xa5a5a564, 2, 4, 0x00000009)
	DEP( 0xa5a5a564, 7, 2, 4, 0x9da5a564)
	EXT( 0xa5a5a563, 2, 5, 0xfffffff2)
	EXTU(0xa5a5a563, 2, 5, 0x00000012)
	DEP( 0xa5a5a563, 15, 2, 5, 0x9fa5a563)
	EXT( 0xa5a5a562, 2, 6, 0xffffffe5)
	EXTU(0xa5a5a562, 2, 6, 0x00000025)
	DEP( 0xa5a5a562, 31, 2, 6, 0x9fa5a562)
	EXT( 0xa5a5a561, 2, 7, 0xffffffcb)
	EXTU(0xa5a5a561, 2, 7, 0x0000004b)
	DEP( 0xa5a5a561, 63, 2, 7, 0x9fa5a561)
	EXT( 0xa5a5a560, 2, 8, 0xffffff96)
	EXTU(0xa5a5a560, 2, 8, 0x00000096)
	DEP( 0xa5a5a560, 127, 2, 8, 0x9fe5a560)
	EXT( 0xa5a5a55f, 2, 9, 0xffffff2d)
	EXTU(0xa5a5a55f, 2, 9, 0x0000012d)
	DEP( 0xa5a5a55f, 255, 2, 9, 0x9fe5a55f)
	EXT( 0xa5a5a55e, 2, 10, 0xfffffe5a)
	EXTU(0xa5a5a55e, 2, 10, 0x0000025a)
	DEP( 0xa5a5a55e, 511, 2, 10, 0x9ff5a55e)
	EXT( 0xa5a5a55d, 2, 11, 0xfffffcb4)
	EXTU(0xa5a5a55d, 2, 11, 0x000004b4)
	DEP( 0xa5a5a55d, 1023, 2, 11, 0x9ffda55d)
	EXT( 0xa5a5a55c, 2, 12, 0xfffff969)
	EXTU(0xa5a5a55c, 2, 12, 0x00000969)
	DEP( 0xa5a5a55c, 2047, 2, 12, 0x9ffda55c)
	EXT( 0xa5a5a55b, 2, 13, 0xfffff2d2)
	EXTU(0xa5a5a55b, 2, 13, 0x000012d2)
	DEP( 0xa5a5a55b, 4095, 2, 13, 0x9fffa55b)
	EXT( 0xa5a5a55a, 2, 14, 0xffffe5a5)
	EXTU(0xa5a5a55a, 2, 14, 0x000025a5)
	DEP( 0xa5a5a55a, 8191, 2, 14, 0x9fffa55a)
	EXT( 0xa5a5a559, 2, 15, 0xffffcb4b)
	EXTU(0xa5a5a559, 2, 15, 0x00004b4b)
	DEP( 0xa5a5a559, 16383, 2, 15, 0x9fffa559)
	EXT( 0xa5a5a558, 2, 16, 0xffff9696)
	EXTU(0xa5a5a558, 2, 16, 0x00009696)
	DEP( 0xa5a5a558, 32767, 2, 16, 0x9fffe558)
	EXT( 0xa5a5a557, 2, 17, 0xffff2d2d)
	EXTU(0xa5a5a557, 2, 17, 0x00012d2d)
	DEP( 0xa5a5a557, 65535, 2, 17, 0x9fffe557)
	EXT( 0xa5a5a556, 2, 18, 0xfffe5a5a)
	EXTU(0xa5a5a556, 2, 18, 0x00025a5a)
	DEP( 0xa5a5a556, 131071, 2, 18, 0x9ffff556)
	EXT( 0xa5a5a555, 2, 19, 0xfffcb4b4)
	EXTU(0xa5a5a555, 2, 19, 0x0004b4b4)
	DEP( 0xa5a5a555, 262143, 2, 19, 0x9ffffd55)
	EXT( 0xa5a5a554, 2, 20, 0xfff96969)
	EXTU(0xa5a5a554, 2, 20, 0x00096969)
	DEP( 0xa5a5a554, 524287, 2, 20, 0x9ffffd54)
	EXT( 0xa5a5a553, 2, 21, 0xfff2d2d2)
	EXTU(0xa5a5a553, 2, 21, 0x0012d2d2)
	DEP( 0xa5a5a553, 1048575, 2, 21, 0x9fffff53)
	EXT( 0xa5a5a552, 2, 22, 0xffe5a5a5)
	EXTU(0xa5a5a552, 2, 22, 0x0025a5a5)
	DEP( 0xa5a5a552, 2097151, 2, 22, 0x9fffff52)
	EXT( 0xa5a5a551, 2, 23, 0xffcb4b4a)
	EXTU(0xa5a5a551, 2, 23, 0x004b4b4a)
	DEP( 0xa5a5a551, 4194303, 2, 23, 0x9fffffd1)
	EXT( 0xa5a5a550, 2, 24, 0xff969695)
	EXTU(0xa5a5a550, 2, 24, 0x00969695)
	DEP( 0xa5a5a550, 8388607, 2, 24, 0x9fffffd0)
	EXT( 0xa5a5a54f, 2, 25, 0xff2d2d2a)
	EXTU(0xa5a5a54f, 2, 25, 0x012d2d2a)
	DEP( 0xa5a5a54f, 16777215, 2, 25, 0x9fffffef)
	EXT( 0xa5a5a54e, 2, 26, 0xfe5a5a54)
	EXTU(0xa5a5a54e, 2, 26, 0x025a5a54)
	DEP( 0xa5a5a54e, 33554431, 2, 26, 0x9ffffffe)
	EXT( 0xa5a5a54d, 2, 27, 0xfcb4b4a9)
	EXTU(0xa5a5a54d, 2, 27, 0x04b4b4a9)
	DEP( 0xa5a5a54d, 67108863, 2, 27, 0x9ffffffd)
	EXT( 0xa5a5a54c, 2, 28, 0xf9696953)
	EXTU(0xa5a5a54c, 2, 28, 0x09696953)
	DEP( 0xa5a5a54c, 134217727, 2, 28, 0x9ffffffc)
	EXT( 0xa5a5a54b, 2, 29, 0xf2d2d2a5)
	EXTU(0xa5a5a54b, 2, 29, 0x12d2d2a5)
	DEP( 0xa5a5a54b, 268435455, 2, 29, 0x9fffffff)
	EXT( 0xa5a5a54a, 3, 1, 0x00000000)
	EXTU(0xa5a5a54a, 3, 1, 0x00000000)
	DEP( 0xa5a5a54a, 0, 3, 1, 0xa5a5a54a)
	EXT( 0xa5a5a549, 3, 2, 0x00000000)
	EXTU(0xa5a5a549, 3, 2, 0x00000000)
	DEP( 0xa5a5a549, 1, 3, 2, 0xada5a549)
	EXT( 0xa5a5a548, 3, 3, 0x00000001)
	EXTU(0xa5a5a548, 3, 3, 0x00000001)
	DEP( 0xa5a5a548, 3, 3, 3, 0xada5a548)
	EXT( 0xa5a5a547, 3, 4, 0x00000002)
	EXTU(0xa5a5a547, 3, 4, 0x00000002)
	DEP( 0xa5a5a547, 7, 3, 4, 0xafa5a547)
	EXT( 0xa5a5a546, 3, 5, 0x00000005)
	EXTU(0xa5a5a546, 3, 5, 0x00000005)
	DEP( 0xa5a5a546, 15, 3, 5, 0xafa5a546)
	EXT( 0xa5a5a545, 3, 6, 0x0000000b)
	EXTU(0xa5a5a545, 3, 6, 0x0000000b)
	DEP( 0xa5a5a545, 31, 3, 6, 0xafa5a545)
	EXT( 0xa5a5a544, 3, 7, 0x00000016)
	EXTU(0xa5a5a544, 3, 7, 0x00000016)
	DEP( 0xa5a5a544, 63, 3, 7, 0xafe5a544)
	EXT( 0xa5a5a543, 3, 8, 0x0000002d)
	EXTU(0xa5a5a543, 3, 8, 0x0000002d)
	DEP( 0xa5a5a543, 127, 3, 8, 0xafe5a543)
	EXT( 0xa5a5a542, 3, 9, 0x0000005a)
	EXTU(0xa5a5a542, 3, 9, 0x0000005a)
	DEP( 0xa5a5a542, 255, 3, 9, 0xaff5a542)
	EXT( 0xa5a5a541, 3, 10, 0x000000b4)
	EXTU(0xa5a5a541, 3, 10, 0x000000b4)
	DEP( 0xa5a5a541, 511, 3, 10, 0xaffda541)
	EXT( 0xa5a5a540, 3, 11, 0x00000169)
	EXTU(0xa5a5a540, 3, 11, 0x00000169)
	DEP( 0xa5a5a540, 1023, 3, 11, 0xaffda540)
	EXT( 0xa5a5a53f, 3, 12, 0x000002d2)
	EXTU(0xa5a5a53f, 3, 12, 0x000002d2)
	DEP( 0xa5a5a53f, 2047, 3, 12, 0xafffa53f)
	EXT( 0xa5a5a53e, 3, 13, 0x000005a5)
	EXTU(0xa5a5a53e, 3, 13, 0x000005a5)
	DEP( 0xa5a5a53e, 4095, 3, 13, 0xafffa53e)
	EXT( 0xa5a5a53d, 3, 14, 0x00000b4b)
	EXTU(0xa5a5a53d, 3, 14, 0x00000b4b)
	DEP( 0xa5a5a53d, 8191, 3, 14, 0xafffa53d)
	EXT( 0xa5a5a53c, 3, 15, 0x00001696)
	EXTU(0xa5a5a53c, 3, 15, 0x00001696)
	DEP( 0xa5a5a53c, 16383, 3, 15, 0xafffe53c)
	EXT( 0xa5a5a53b, 3, 16, 0x00002d2d)
	EXTU(0xa5a5a53b, 3, 16, 0x00002d2d)
	DEP( 0xa5a5a53b, 32767, 3, 16, 0xafffe53b)
	EXT( 0xa5a5a53a, 3, 17, 0x00005a5a)
	EXTU(0xa5a5a53a, 3, 17, 0x00005a5a)
	DEP( 0xa5a5a53a, 65535, 3, 17, 0xaffff53a)
	EXT( 0xa5a5a539, 3, 18, 0x0000b4b4)
	EXTU(0xa5a5a539, 3, 18, 0x0000b4b4)
	DEP( 0xa5a5a539, 131071, 3, 18, 0xaffffd39)
	EXT( 0xa5a5a538, 3, 19, 0x00016969)
	EXTU(0xa5a5a538, 3, 19, 0x00016969)
	DEP( 0xa5a5a538, 262143, 3, 19, 0xaffffd38)
	EXT( 0xa5a5a537, 3, 20, 0x0002d2d2)
	EXTU(0xa5a5a537, 3, 20, 0x0002d2d2)
	DEP( 0xa5a5a537, 524287, 3, 20, 0xafffff37)
	EXT( 0xa5a5a536, 3, 21, 0x0005a5a5)
	EXTU(0xa5a5a536, 3, 21, 0x0005a5a5)
	DEP( 0xa5a5a536, 1048575, 3, 21, 0xafffff36)
	EXT( 0xa5a5a535, 3, 22, 0x000b4b4a)
	EXTU(0xa5a5a535, 3, 22, 0x000b4b4a)
	DEP( 0xa5a5a535, 2097151, 3, 22, 0xafffffb5)
	EXT( 0xa5a5a534, 3, 23, 0x00169694)
	EXTU(0xa5a5a534, 3, 23, 0x00169694)
	DEP( 0xa5a5a534, 4194303, 3, 23, 0xaffffff4)
	EXT( 0xa5a5a533, 3, 24, 0x002d2d29)
	EXTU(0xa5a5a533, 3, 24, 0x002d2d29)
	DEP( 0xa5a5a533, 8388607, 3, 24, 0xaffffff3)
	EXT( 0xa5a5a532, 3, 25, 0x005a5a53)
	EXTU(0xa5a5a532, 3, 25, 0x005a5a53)
	DEP( 0xa5a5a532, 16777215, 3, 25, 0xaffffff2)
	EXT( 0xa5a5a531, 3, 26, 0x00b4b4a6)
	EXTU(0xa5a5a531, 3, 26, 0x00b4b4a6)
	DEP( 0xa5a5a531, 33554431, 3, 26, 0xaffffff9)
	EXT( 0xa5a5a530, 3, 27, 0x0169694c)
	EXTU(0xa5a5a530, 3, 27, 0x0169694c)
	DEP( 0xa5a5a530, 67108863, 3, 27, 0xaffffffc)
	EXT( 0xa5a5a52f, 3, 28, 0x02d2d297)
	EXTU(0xa5a5a52f, 3, 28, 0x02d2d297)
	DEP( 0xa5a5a52f, 134217727, 3, 28, 0xafffffff)
	EXT( 0xa5a5a52e, 4, 1, 0x00000000)
	EXTU(0xa5a5a52e, 4, 1, 0x00000000)
	DEP( 0xa5a5a52e, 0, 4, 1, 0xa5a5a52e)
	EXT( 0xa5a5a52d, 4, 2, 0x00000001)
	EXTU(0xa5a5a52d, 4, 2, 0x00000001)
	DEP( 0xa5a5a52d, 1, 4, 2, 0xa5a5a52d)
	EXT( 0xa5a5a52c, 4, 3, 0x00000002)
	EXTU(0xa5a5a52c, 4, 3, 0x00000002)
	DEP( 0xa5a5a52c, 3, 4, 3, 0xa7a5a52c)
	EXT( 0xa5a5a52b, 4, 4, 0x00000005)
	EXTU(0xa5a5a52b, 4, 4, 0x00000005)
	DEP( 0xa5a5a52b, 7, 4, 4, 0xa7a5a52b)
	EXT( 0xa5a5a52a, 4, 5, 0x0000000b)
	EXTU(0xa5a5a52a, 4, 5, 0x0000000b)
	DEP( 0xa5a5a52a, 15, 4, 5, 0xa7a5a52a)
	EXT( 0xa5a5a529, 4, 6, 0x00000016)
	EXTU(0xa5a5a529, 4, 6, 0x00000016)
	DEP( 0xa5a5a529, 31, 4, 6, 0xa7e5a529)
	EXT( 0xa5a5a528, 4, 7, 0x0000002d)
	EXTU(0xa5a5a528, 4, 7, 0x0000002d)
	DEP( 0xa5a5a528, 63, 4, 7, 0xa7e5a528)
	EXT( 0xa5a5a527, 4, 8, 0x0000005a)
	EXTU(0xa5a5a527, 4, 8, 0x0000005a)
	DEP( 0xa5a5a527, 127, 4, 8, 0xa7f5a527)
	EXT( 0xa5a5a526, 4, 9, 0x000000b4)
	EXTU(0xa5a5a526, 4, 9, 0x000000b4)
	DEP( 0xa5a5a526, 255, 4, 9, 0xa7fda526)
	EXT( 0xa5a5a525, 4, 10, 0x00000169)
	EXTU(0xa5a5a525, 4, 10, 0x00000169)
	DEP( 0xa5a5a525, 511, 4, 10, 0xa7fda525)
	EXT( 0xa5a5a524, 4, 11, 0x000002d2)
	EXTU(0xa5a5a524, 4, 11, 0x000002d2)
	DEP( 0xa5a5a524, 1023, 4, 11, 0xa7ffa524)
	EXT( 0xa5a5a523, 4, 12, 0x000005a5)
	EXTU(0xa5a5a523, 4, 12, 0x000005a5)
	DEP( 0xa5a5a523, 2047, 4, 12, 0xa7ffa523)
	EXT( 0xa5a5a522, 4, 13, 0x00000b4b)
	EXTU(0xa5a5a522, 4, 13, 0x00000b4b)
	DEP( 0xa5a5a522, 4095, 4, 13, 0xa7ffa522)
	EXT( 0xa5a5a521, 4, 14, 0x00001696)
	EXTU(0xa5a5a521, 4, 14, 0x00001696)
	DEP( 0xa5a5a521, 8191, 4, 14, 0xa7ffe521)
	EXT( 0xa5a5a520, 4, 15, 0x00002d2d)
	EXTU(0xa5a5a520, 4, 15, 0x00002d2d)
	DEP( 0xa5a5a520, 16383, 4, 15, 0xa7ffe520)
	EXT( 0xa5a5a51f, 4, 16, 0x00005a5a)
	EXTU(0xa5a5a51f, 4, 16, 0x00005a5a)
	DEP( 0xa5a5a51f, 32767, 4, 16, 0xa7fff51f)
	EXT( 0xa5a5a51e, 4, 17, 0x0000b4b4)
	EXTU(0xa5a5a51e, 4, 17, 0x0000b4b4)
	DEP( 0xa5a5a51e, 65535, 4, 17, 0xa7fffd1e)
	EXT( 0xa5a5a51d, 4, 18, 0x00016969)
	EXTU(0xa5a5a51d, 4, 18, 0x00016969)
	DEP( 0xa5a5a51d, 131071, 4, 18, 0xa7fffd1d)
	EXT( 0xa5a5a51c, 4, 19, 0x0002d2d2)
	EXTU(0xa5a5a51c, 4, 19, 0x0002d2d2)
	DEP( 0xa5a5a51c, 262143, 4, 19, 0xa7ffff1c)
	EXT( 0xa5a5a51b, 4, 20, 0x0005a5a5)
	EXTU(0xa5a5a51b, 4, 20, 0x0005a5a5)
	DEP( 0xa5a5a51b, 524287, 4, 20, 0xa7ffff1b)
	EXT( 0xa5a5a51a, 4, 21, 0x000b4b4a)
	EXTU(0xa5a5a51a, 4, 21, 0x000b4b4a)
	DEP( 0xa5a5a51a, 1048575, 4, 21, 0xa7ffff9a)
	EXT( 0xa5a5a519, 4, 22, 0x00169694)
	EXTU(0xa5a5a519, 4, 22, 0x00169694)
	DEP( 0xa5a5a519, 2097151, 4, 22, 0xa7ffffd9)
	EXT( 0xa5a5a518, 4, 23, 0x002d2d28)
	EXTU(0xa5a5a518, 4, 23, 0x002d2d28)
	DEP( 0xa5a5a518, 4194303, 4, 23, 0xa7fffff8)
	EXT( 0xa5a5a517, 4, 24, 0x005a5a51)
	EXTU(0xa5a5a517, 4, 24, 0x005a5a51)
	DEP( 0xa5a5a517, 8388607, 4, 24, 0xa7fffff7)
	EXT( 0xa5a5a516, 4, 25, 0x00b4b4a2)
	EXTU(0xa5a5a516, 4, 25, 0x00b4b4a2)
	DEP( 0xa5a5a516, 16777215, 4, 25, 0xa7fffffe)
	EXT( 0xa5a5a515, 4, 26, 0x01696945)
	EXTU(0xa5a5a515, 4, 26, 0x01696945)
	DEP( 0xa5a5a515, 33554431, 4, 26, 0xa7fffffd)
	EXT( 0xa5a5a514, 4, 27, 0x02d2d28a)
	EXTU(0xa5a5a514, 4, 27, 0x02d2d28a)
	DEP( 0xa5a5a514, 67108863, 4, 27, 0xa7fffffe)
	EXT( 0xa5a5a513, 5, 1, 0xffffffff)
	EXTU(0xa5a5a513, 5, 1, 0x00000001)
	DEP( 0xa5a5a513, 0, 5, 1, 0xa1a5a513)
	EXT( 0xa5a5a512, 5, 2, 0xfffffffe)
	EXTU(0xa5a5a512, 5, 2, 0x00000002)
	DEP( 0xa5a5a512, 1, 5, 2, 0xa3a5a512)
	EXT( 0xa5a5a511, 5, 3, 0xfffffffd)
	EXTU(0xa5a5a511, 5, 3, 0x00000005)
	DEP( 0xa5a5a511, 3, 5, 3, 0xa3a5a511)
	EXT( 0xa5a5a510, 5, 4, 0xfffffffb)
	EXTU(0xa5a5a510, 5, 4, 0x0000000b)
	DEP( 0xa5a5a510, 7, 5, 4, 0xa3a5a510)
	EXT( 0xa5a5a50f, 5, 5, 0xfffffff6)
	EXTU(0xa5a5a50f, 5, 5, 0x00000016)
	DEP( 0xa5a5a50f, 15, 5, 5, 0xa3e5a50f)
	EXT( 0xa5a5a50e, 5, 6, 0xffffffed)
	EXTU(0xa5a5a50e, 5, 6, 0x0000002d)
	DEP( 0xa5a5a50e, 31, 5, 6, 0xa3e5a50e)
	EXT( 0xa5a5a50d, 5, 7, 0xffffffda)
	EXTU(0xa5a5a50d, 5, 7, 0x0000005a)
	DEP( 0xa5a5a50d, 63, 5, 7, 0xa3f5a50d)
	EXT( 0xa5a5a50c, 5, 8, 0xffffffb4)
	EXTU(0xa5a5a50c, 5, 8, 0x000000b4)
	DEP( 0xa5a5a50c, 127, 5, 8, 0xa3fda50c)
	EXT( 0xa5a5a50b, 5, 9, 0xffffff69)
	EXTU(0xa5a5a50b, 5, 9, 0x00000169)
	DEP( 0xa5a5a50b, 255, 5, 9, 0xa3fda50b)
	EXT( 0xa5a5a50a, 5, 10, 0xfffffed2)
	EXTU(0xa5a5a50a, 5, 10, 0x000002d2)
	DEP( 0xa5a5a50a, 511, 5, 10, 0xa3ffa50a)
	EXT( 0xa5a5a509, 5, 11, 0xfffffda5)
	EXTU(0xa5a5a509, 5, 11, 0x000005a5)
	DEP( 0xa5a5a509, 1023, 5, 11, 0xa3ffa509)
	EXT( 0xa5a5a508, 5, 12, 0xfffffb4b)
	EXTU(0xa5a5a508, 5, 12, 0x00000b4b)
	DEP( 0xa5a5a508, 2047, 5, 12, 0xa3ffa508)
	EXT( 0xa5a5a507, 5, 13, 0xfffff696)
	EXTU(0xa5a5a507, 5, 13, 0x00001696)
	DEP( 0xa5a5a507, 4095, 5, 13, 0xa3ffe507)
	EXT( 0xa5a5a506, 5, 14, 0xffffed2d)
	EXTU(0xa5a5a506, 5, 14, 0x00002d2d)
	DEP( 0xa5a5a506, 8191, 5, 14, 0xa3ffe506)
	EXT( 0xa5a5a505, 5, 15, 0xffffda5a)
	EXTU(0xa5a5a505, 5, 15, 0x00005a5a)
	DEP( 0xa5a5a505, 16383, 5, 15, 0xa3fff505)
	EXT( 0xa5a5a504, 5, 16, 0xffffb4b4)
	EXTU(0xa5a5a504, 5, 16, 0x0000b4b4)
	DEP( 0xa5a5a504, 32767, 5, 16, 0xa3fffd04)
	EXT( 0xa5a5a503, 5, 17, 0xffff6969)
	EXTU(0xa5a5a503, 5, 17, 0x00016969)
	DEP( 0xa5a5a503, 65535, 5, 17, 0xa3fffd03)
	EXT( 0xa5a5a502, 5, 18, 0xfffed2d2)
	EXTU(0xa5a5a502, 5, 18, 0x0002d2d2)
	DEP( 0xa5a5a502, 131071, 5, 18, 0xa3ffff02)
	EXT( 0xa5a5a501, 5, 19, 0xfffda5a5)
	EXTU(0xa5a5a501, 5, 19, 0x0005a5a5)
	DEP( 0xa5a5a501, 262143, 5, 19, 0xa3ffff01)
	EXT( 0xa5a5a500, 5, 20, 0xfffb4b4a)
	EXTU(0xa5a5a500, 5, 20, 0x000b4b4a)
	DEP( 0xa5a5a500, 524287, 5, 20, 0xa3ffff80)
	EXT( 0xa5a5a4ff, 5, 21, 0xfff69693)
	EXTU(0xa5a5a4ff, 5, 21, 0x00169693)
	DEP( 0xa5a5a4ff, 1048575, 5, 21, 0xa3ffffff)
	EXT( 0xa5a5a4fe, 5, 22, 0xffed2d27)
	EXTU(0xa5a5a4fe, 5, 22, 0x002d2d27)
	DEP( 0xa5a5a4fe, 2097151, 5, 22, 0xa3fffffe)
	EXT( 0xa5a5a4fd, 5, 23, 0xffda5a4f)
	EXTU(0xa5a5a4fd, 5, 23, 0x005a5a4f)
	DEP( 0xa5a5a4fd, 4194303, 5, 23, 0xa3fffffd)
	EXT( 0xa5a5a4fc, 5, 24, 0xffb4b49f)
	EXTU(0xa5a5a4fc, 5, 24, 0x00b4b49f)
	DEP( 0xa5a5a4fc, 8388607, 5, 24, 0xa3fffffc)
	EXT( 0xa5a5a4fb, 5, 25, 0xff69693e)
	EXTU(0xa5a5a4fb, 5, 25, 0x0169693e)
	DEP( 0xa5a5a4fb, 16777215, 5, 25, 0xa3ffffff)
	EXT( 0xa5a5a4fa, 5, 26, 0xfed2d27d)
	EXTU(0xa5a5a4fa, 5, 26, 0x02d2d27d)
	DEP( 0xa5a5a4fa, 33554431, 5, 26, 0xa3fffffe)
	EXT( 0xa5a5a4f9, 6, 1, 0x00000000)
	EXTU(0xa5a5a4f9, 6, 1, 0x00000000)
	DEP( 0xa5a5a4f9, 0, 6, 1, 0xa5a5a4f9)
	EXT( 0xa5a5a4f8, 6, 2, 0x00000001)
	EXTU(0xa5a5a4f8, 6, 2, 0x00000001)
	DEP( 0xa5a5a4f8, 1, 6, 2, 0xa5a5a4f8)
	EXT( 0xa5a5a4f7, 6, 3, 0x00000003)
	EXTU(0xa5a5a4f7, 6, 3, 0x00000003)
	DEP( 0xa5a5a4f7, 3, 6, 3, 0xa5a5a4f7)
	EXT( 0xa5a5a4f6, 6, 4, 0x00000006)
	EXTU(0xa5a5a4f6, 6, 4, 0x00000006)
	DEP( 0xa5a5a4f6, 7, 6, 4, 0xa5e5a4f6)
	EXT( 0xa5a5a4f5, 6, 5, 0x0000000d)
	EXTU(0xa5a5a4f5, 6, 5, 0x0000000d)
	DEP( 0xa5a5a4f5, 15, 6, 5, 0xa5e5a4f5)
	EXT( 0xa5a5a4f4, 6, 6, 0x0000001a)
	EXTU(0xa5a5a4f4, 6, 6, 0x0000001a)
	DEP( 0xa5a5a4f4, 31, 6, 6, 0xa5f5a4f4)
	EXT( 0xa5a5a4f3, 6, 7, 0x00000034)
	EXTU(0xa5a5a4f3, 6, 7, 0x00000034)
	DEP( 0xa5a5a4f3, 63, 6, 7, 0xa5fda4f3)
	EXT( 0xa5a5a4f2, 6, 8, 0x00000069)
	EXTU(0xa5a5a4f2, 6, 8, 0x00000069)
	DEP( 0xa5a5a4f2, 127, 6, 8, 0xa5fda4f2)
	EXT( 0xa5a5a4f1, 6, 9, 0x000000d2)
	EXTU(0xa5a5a4f1, 6, 9, 0x000000d2)
	DEP( 0xa5a5a4f1, 255, 6, 9, 0xa5ffa4f1)
	EXT( 0xa5a5a4f0, 6, 10, 0x000001a5)
	EXTU(0xa5a5a4f0, 6, 10, 0x000001a5)
	DEP( 0xa5a5a4f0, 511, 6, 10, 0xa5ffa4f0)
	EXT( 0xa5a5a4ef, 6, 11, 0x0000034b)
	EXTU(0xa5a5a4ef, 6, 11, 0x0000034b)
	DEP( 0xa5a5a4ef, 1023, 6, 11, 0xa5ffa4ef)
	EXT( 0xa5a5a4ee, 6, 12, 0x00000696)
	EXTU(0xa5a5a4ee, 6, 12, 0x00000696)
	DEP( 0xa5a5a4ee, 2047, 6, 12, 0xa5ffe4ee)
	EXT( 0xa5a5a4ed, 6, 13, 0x00000d2d)
	EXTU(0xa5a5a4ed, 6, 13, 0x00000d2d)
	DEP( 0xa5a5a4ed, 4095, 6, 13, 0xa5ffe4ed)
	EXT( 0xa5a5a4ec, 6, 14, 0x00001a5a)
	EXTU(0xa5a5a4ec, 6, 14, 0x00001a5a)
	DEP( 0xa5a5a4ec, 8191, 6, 14, 0xa5fff4ec)
	EXT( 0xa5a5a4eb, 6, 15, 0x000034b4)
	EXTU(0xa5a5a4eb, 6, 15, 0x000034b4)
	DEP( 0xa5a5a4eb, 16383, 6, 15, 0xa5fffceb)
	EXT( 0xa5a5a4ea, 6, 16, 0x00006969)
	EXTU(0xa5a5a4ea, 6, 16, 0x00006969)
	DEP( 0xa5a5a4ea, 32767, 6, 16, 0xa5fffcea)
	EXT( 0xa5a5a4e9, 6, 17, 0x0000d2d2)
	EXTU(0xa5a5a4e9, 6, 17, 0x0000d2d2)
	DEP( 0xa5a5a4e9, 65535, 6, 17, 0xa5fffee9)
	EXT( 0xa5a5a4e8, 6, 18, 0x0001a5a4)
	EXTU(0xa5a5a4e8, 6, 18, 0x0001a5a4)
	DEP( 0xa5a5a4e8, 131071, 6, 18, 0xa5ffffe8)
	EXT( 0xa5a5a4e7, 6, 19, 0x00034b49)
	EXTU(0xa5a5a4e7, 6, 19, 0x00034b49)
	DEP( 0xa5a5a4e7, 262143, 6, 19, 0xa5ffffe7)
	EXT( 0xa5a5a4e6, 6, 20, 0x00069693)
	EXTU(0xa5a5a4e6, 6, 20, 0x00069693)
	DEP( 0xa5a5a4e6, 524287, 6, 20, 0xa5ffffe6)
	EXT( 0xa5a5a4e5, 6, 21, 0x000d2d27)
	EXTU(0xa5a5a4e5, 6, 21, 0x000d2d27)
	DEP( 0xa5a5a4e5, 1048575, 6, 21, 0xa5ffffe5)
	EXT( 0xa5a5a4e4, 6, 22, 0x001a5a4e)
	EXTU(0xa5a5a4e4, 6, 22, 0x001a5a4e)
	DEP( 0xa5a5a4e4, 2097151, 6, 22, 0xa5fffff4)
	EXT( 0xa5a5a4e3, 6, 23, 0x0034b49c)
	EXTU(0xa5a5a4e3, 6, 23, 0x0034b49c)
	DEP( 0xa5a5a4e3, 4194303, 6, 23, 0xa5fffffb)
	EXT( 0xa5a5a4e2, 6, 24, 0x00696938)
	EXTU(0xa5a5a4e2, 6, 24, 0x00696938)
	DEP( 0xa5a5a4e2, 8388607, 6, 24, 0xa5fffffe)
	EXT( 0xa5a5a4e1, 6, 25, 0x00d2d270)
	EXTU(0xa5a5a4e1, 6, 25, 0x00d2d270)
	DEP( 0xa5a5a4e1, 16777215, 6, 25, 0xa5ffffff)
	EXT( 0xa5a5a4e0, 7, 1, 0xffffffff)
	EXTU(0xa5a5a4e0, 7, 1, 0x00000001)
	DEP( 0xa5a5a4e0, 0, 7, 1, 0xa4a5a4e0)
	EXT( 0xa5a5a4df, 7, 2, 0xffffffff)
	EXTU(0xa5a5a4df, 7, 2, 0x00000003)
	DEP( 0xa5a5a4df, 1, 7, 2, 0xa4a5a4df)
	EXT( 0xa5a5a4de, 7, 3, 0xfffffffe)
	EXTU(0xa5a5a4de, 7, 3, 0x00000006)
	DEP( 0xa5a5a4de, 3, 7, 3, 0xa4e5a4de)
	EXT( 0xa5a5a4dd, 7, 4, 0xfffffffd)
	EXTU(0xa5a5a4dd, 7, 4, 0x0000000d)
	DEP( 0xa5a5a4dd, 7, 7, 4, 0xa4e5a4dd)
	EXT( 0xa5a5a4dc, 7, 5, 0xfffffffa)
	EXTU(0xa5a5a4dc, 7, 5, 0x0000001a)
	DEP( 0xa5a5a4dc, 15, 7, 5, 0xa4f5a4dc)
	EXT( 0xa5a5a4db, 7, 6, 0xfffffff4)
	EXTU(0xa5a5a4db, 7, 6, 0x00000034)
	DEP( 0xa5a5a4db, 31, 7, 6, 0xa4fda4db)
	EXT( 0xa5a5a4da, 7, 7, 0xffffffe9)
	EXTU(0xa5a5a4da, 7, 7, 0x00000069)
	DEP( 0xa5a5a4da, 63, 7, 7, 0xa4fda4da)
	EXT( 0xa5a5a4d9, 7, 8, 0xffffffd2)
	EXTU(0xa5a5a4d9, 7, 8, 0x000000d2)
	DEP( 0xa5a5a4d9, 127, 7, 8, 0xa4ffa4d9)
	EXT( 0xa5a5a4d8, 7, 9, 0xffffffa5)
	EXTU(0xa5a5a4d8, 7, 9, 0x000001a5)
	DEP( 0xa5a5a4d8, 255, 7, 9, 0xa4ffa4d8)
	EXT( 0xa5a5a4d7, 7, 10, 0xffffff4b)
	EXTU(0xa5a5a4d7, 7, 10, 0x0000034b)
	DEP( 0xa5a5a4d7, 511, 7, 10, 0xa4ffa4d7)
	EXT( 0xa5a5a4d6, 7, 11, 0xfffffe96)
	EXTU(0xa5a5a4d6, 7, 11, 0x00000696)
	DEP( 0xa5a5a4d6, 1023, 7, 11, 0xa4ffe4d6)
	EXT( 0xa5a5a4d5, 7, 12, 0xfffffd2d)
	EXTU(0xa5a5a4d5, 7, 12, 0x00000d2d)
	DEP( 0xa5a5a4d5, 2047, 7, 12, 0xa4ffe4d5)
	EXT( 0xa5a5a4d4, 7, 13, 0xfffffa5a)
	EXTU(0xa5a5a4d4, 7, 13, 0x00001a5a)
	DEP( 0xa5a5a4d4, 4095, 7, 13, 0xa4fff4d4)
	EXT( 0xa5a5a4d3, 7, 14, 0xfffff4b4)
	EXTU(0xa5a5a4d3, 7, 14, 0x000034b4)
	DEP( 0xa5a5a4d3, 8191, 7, 14, 0xa4fffcd3)
	EXT( 0xa5a5a4d2, 7, 15, 0xffffe969)
	EXTU(0xa5a5a4d2, 7, 15, 0x00006969)
	DEP( 0xa5a5a4d2, 16383, 7, 15, 0xa4fffcd2)
	EXT( 0xa5a5a4d1, 7, 16, 0xffffd2d2)
	EXTU(0xa5a5a4d1, 7, 16, 0x0000d2d2)
	DEP( 0xa5a5a4d1, 32767, 7, 16, 0xa4fffed1)
	EXT( 0xa5a5a4d0, 7, 17, 0xffffa5a4)
	EXTU(0xa5a5a4d0, 7, 17, 0x0001a5a4)
	DEP( 0xa5a5a4d0, 65535, 7, 17, 0xa4ffffd0)
	EXT( 0xa5a5a4cf, 7, 18, 0xffff4b49)
	EXTU(0xa5a5a4cf, 7, 18, 0x00034b49)
	DEP( 0xa5a5a4cf, 131071, 7, 18, 0xa4ffffcf)
	EXT( 0xa5a5a4ce, 7, 19, 0xfffe9693)
	EXTU(0xa5a5a4ce, 7, 19, 0x00069693)
	DEP( 0xa5a5a4ce, 262143, 7, 19, 0xa4ffffce)
	EXT( 0xa5a5a4cd, 7, 20, 0xfffd2d26)
	EXTU(0xa5a5a4cd, 7, 20, 0x000d2d26)
	DEP( 0xa5a5a4cd, 524287, 7, 20, 0xa4ffffed)
	EXT( 0xa5a5a4cc, 7, 21, 0xfffa5a4c)
	EXTU(0xa5a5a4cc, 7, 21, 0x001a5a4c)
	DEP( 0xa5a5a4cc, 1048575, 7, 21, 0xa4fffffc)
	EXT( 0xa5a5a4cb, 7, 22, 0xfff4b499)
	EXTU(0xa5a5a4cb, 7, 22, 0x0034b499)
	DEP( 0xa5a5a4cb, 2097151, 7, 22, 0xa4fffffb)
	EXT( 0xa5a5a4ca, 7, 23, 0xffe96932)
	EXTU(0xa5a5a4ca, 7, 23, 0x00696932)
	DEP( 0xa5a5a4ca, 4194303, 7, 23, 0xa4fffffe)
	EXT( 0xa5a5a4c9, 7, 24, 0xffd2d264)
	EXTU(0xa5a5a4c9, 7, 24, 0x00d2d264)
	DEP( 0xa5a5a4c9, 8388607, 7, 24, 0xa4ffffff)
	EXT( 0xa5a5a4c8, 8, 1, 0xffffffff)
	EXTU(0xa5a5a4c8, 8, 1, 0x00000001)
	DEP( 0xa5a5a4c8, 0, 8, 1, 0xa525a4c8)
	EXT( 0xa5a5a4c7, 8, 2, 0xfffffffe)
	EXTU(0xa5a5a4c7, 8, 2, 0x00000002)
	DEP( 0xa5a5a4c7, 1, 8, 2, 0xa565a4c7)
	EXT( 0xa5a5a4c6, 8, 3, 0xfffffffd)
	EXTU(0xa5a5a4c6, 8, 3, 0x00000005)
	DEP( 0xa5a5a4c6, 3, 8, 3, 0xa565a4c6)
	EXT( 0xa5a5a4c5, 8, 4, 0xfffffffa)
	EXTU(0xa5a5a4c5, 8, 4, 0x0000000a)
	DEP( 0xa5a5a4c5, 7, 8, 4, 0xa575a4c5)
	EXT( 0xa5a5a4c4, 8, 5, 0xfffffff4)
	EXTU(0xa5a5a4c4, 8, 5, 0x00000014)
	DEP( 0xa5a5a4c4, 15, 8, 5, 0xa57da4c4)
	EXT( 0xa5a5a4c3, 8, 6, 0xffffffe9)
	EXTU(0xa5a5a4c3, 8, 6, 0x00000029)
	DEP( 0xa5a5a4c3, 31, 8, 6, 0xa57da4c3)
	EXT( 0xa5a5a4c2, 8, 7, 0xffffffd2)
	EXTU(0xa5a5a4c2, 8, 7, 0x00000052)
	DEP( 0xa5a5a4c2, 63, 8, 7, 0xa57fa4c2)
	EXT( 0xa5a5a4c1, 8, 8, 0xffffffa5)
	EXTU(0xa5a5a4c1, 8, 8, 0x000000a5)
	DEP( 0xa5a5a4c1, 127, 8, 8, 0xa57fa4c1)
	EXT( 0xa5a5a4c0, 8, 9, 0xffffff4b)
	EXTU(0xa5a5a4c0, 8, 9, 0x0000014b)
	DEP( 0xa5a5a4c0, 255, 8, 9, 0xa57fa4c0)
	EXT( 0xa5a5a4bf, 8, 10, 0xfffffe96)
	EXTU(0xa5a5a4bf, 8, 10, 0x00000296)
	DEP( 0xa5a5a4bf, 511, 8, 10, 0xa57fe4bf)
	EXT( 0xa5a5a4be, 8, 11, 0xfffffd2d)
	EXTU(0xa5a5a4be, 8, 11, 0x0000052d)
	DEP( 0xa5a5a4be, 1023, 8, 11, 0xa57fe4be)
	EXT( 0xa5a5a4bd, 8, 12, 0xfffffa5a)
	EXTU(0xa5a5a4bd, 8, 12, 0x00000a5a)
	DEP( 0xa5a5a4bd, 2047, 8, 12, 0xa57ff4bd)
	EXT( 0xa5a5a4bc, 8, 13, 0xfffff4b4)
	EXTU(0xa5a5a4bc, 8, 13, 0x000014b4)
	DEP( 0xa5a5a4bc, 4095, 8, 13, 0xa57ffcbc)
	EXT( 0xa5a5a4bb, 8, 14, 0xffffe969)
	EXTU(0xa5a5a4bb, 8, 14, 0x00002969)
	DEP( 0xa5a5a4bb, 8191, 8, 14, 0xa57ffcbb)
	EXT( 0xa5a5a4ba, 8, 15, 0xffffd2d2)
	EXTU(0xa5a5a4ba, 8, 15, 0x000052d2)
	DEP( 0xa5a5a4ba, 16383, 8, 15, 0xa57ffeba)
	EXT( 0xa5a5a4b9, 8, 16, 0xffffa5a4)
	EXTU(0xa5a5a4b9, 8, 16, 0x0000a5a4)
	DEP( 0xa5a5a4b9, 32767, 8, 16, 0xa57fffb9)
	EXT( 0xa5a5a4b8, 8, 17, 0xffff4b49)
	EXTU(0xa5a5a4b8, 8, 17, 0x00014b49)
	DEP( 0xa5a5a4b8, 65535, 8, 17, 0xa57fffb8)
	EXT( 0xa5a5a4b7, 8, 18, 0xfffe9692)
	EXTU(0xa5a5a4b7, 8, 18, 0x00029692)
	DEP( 0xa5a5a4b7, 131071, 8, 18, 0xa57ffff7)
	EXT( 0xa5a5a4b6, 8, 19, 0xfffd2d25)
	EXTU(0xa5a5a4b6, 8, 19, 0x00052d25)
	DEP( 0xa5a5a4b6, 262143, 8, 19, 0xa57ffff6)
	EXT( 0xa5a5a4b5, 8, 20, 0xfffa5a4b)
	EXTU(0xa5a5a4b5, 8, 20, 0x000a5a4b)
	DEP( 0xa5a5a4b5, 524287, 8, 20, 0xa57ffff5)
	EXT( 0xa5a5a4b4, 8, 21, 0xfff4b496)
	EXTU(0xa5a5a4b4, 8, 21, 0x0014b496)
	DEP( 0xa5a5a4b4, 1048575, 8, 21, 0xa57ffffc)
	EXT( 0xa5a5a4b3, 8, 22, 0xffe9692c)
	EXTU(0xa5a5a4b3, 8, 22, 0x0029692c)
	DEP( 0xa5a5a4b3, 2097151, 8, 22, 0xa57fffff)
	EXT( 0xa5a5a4b2, 8, 23, 0xffd2d259)
	EXTU(0xa5a5a4b2, 8, 23, 0x0052d259)
	DEP( 0xa5a5a4b2, 4194303, 8, 23, 0xa57ffffe)
	EXT( 0xa5a5a4b1, 9, 1, 0x00000000)
	EXTU(0xa5a5a4b1, 9, 1, 0x00000000)
	DEP( 0xa5a5a4b1, 0, 9, 1, 0xa5a5a4b1)
	EXT( 0xa5a5a4b0, 9, 2, 0x00000001)
	EXTU(0xa5a5a4b0, 9, 2, 0x00000001)
	DEP( 0xa5a5a4b0, 1, 9, 2, 0xa5a5a4b0)
	EXT( 0xa5a5a4af, 9, 3, 0x00000002)
	EXTU(0xa5a5a4af, 9, 3, 0x00000002)
	DEP( 0xa5a5a4af, 3, 9, 3, 0xa5b5a4af)
	EXT( 0xa5a5a4ae, 9, 4, 0x00000004)
	EXTU(0xa5a5a4ae, 9, 4, 0x00000004)
	DEP( 0xa5a5a4ae, 7, 9, 4, 0xa5bda4ae)
	EXT( 0xa5a5a4ad, 9, 5, 0x00000009)
	EXTU(0xa5a5a4ad, 9, 5, 0x00000009)
	DEP( 0xa5a5a4ad, 15, 9, 5, 0xa5bda4ad)
	EXT( 0xa5a5a4ac, 9, 6, 0x00000012)
	EXTU(0xa5a5a4ac, 9, 6, 0x00000012)
	DEP( 0xa5a5a4ac, 31, 9, 6, 0xa5bfa4ac)
	EXT( 0xa5a5a4ab, 9, 7, 0x00000025)
	EXTU(0xa5a5a4ab, 9, 7, 0x00000025)
	DEP( 0xa5a5a4ab, 63, 9, 7, 0xa5bfa4ab)
	EXT( 0xa5a5a4aa, 9, 8, 0x0000004b)
	EXTU(0xa5a5a4aa, 9, 8, 0x0000004b)
	DEP( 0xa5a5a4aa, 127, 9, 8, 0xa5bfa4aa)
	EXT( 0xa5a5a4a9, 9, 9, 0x00000096)
	EXTU(0xa5a5a4a9, 9, 9, 0x00000096)
	DEP( 0xa5a5a4a9, 255, 9, 9, 0xa5bfe4a9)
	EXT( 0xa5a5a4a8, 9, 10, 0x0000012d)
	EXTU(0xa5a5a4a8, 9, 10, 0x0000012d)
	DEP( 0xa5a5a4a8, 511, 9, 10, 0xa5bfe4a8)
	EXT( 0xa5a5a4a7, 9, 11, 0x0000025a)
	EXTU(0xa5a5a4a7, 9, 11, 0x0000025a)
	DEP( 0xa5a5a4a7, 1023, 9, 11, 0xa5bff4a7)
	EXT( 0xa5a5a4a6, 9, 12, 0x000004b4)
	EXTU(0xa5a5a4a6, 9, 12, 0x000004b4)
	DEP( 0xa5a5a4a6, 2047, 9, 12, 0xa5bffca6)
	EXT( 0xa5a5a4a5, 9, 13, 0x00000969)
	EXTU(0xa5a5a4a5, 9, 13, 0x00000969)
	DEP( 0xa5a5a4a5, 4095, 9, 13, 0xa5bffca5)
	EXT( 0xa5a5a4a4, 9, 14, 0x000012d2)
	EXTU(0xa5a5a4a4, 9, 14, 0x000012d2)
	DEP( 0xa5a5a4a4, 8191, 9, 14, 0xa5bffea4)
	EXT( 0xa5a5a4a3, 9, 15, 0x000025a4)
	EXTU(0xa5a5a4a3, 9, 15, 0x000025a4)
	DEP( 0xa5a5a4a3, 16383, 9, 15, 0xa5bfffa3)
	EXT( 0xa5a5a4a2, 9, 16, 0x00004b49)
	EXTU(0xa5a5a4a2, 9, 16, 0x00004b49)
	DEP( 0xa5a5a4a2, 32767, 9, 16, 0xa5bfffa2)
	EXT( 0xa5a5a4a1, 9, 17, 0x00009692)
	EXTU(0xa5a5a4a1, 9, 17, 0x00009692)
	DEP( 0xa5a5a4a1, 65535, 9, 17, 0xa5bfffe1)
	EXT( 0xa5a5a4a0, 9, 18, 0x00012d25)
	EXTU(0xa5a5a4a0, 9, 18, 0x00012d25)
	DEP( 0xa5a5a4a0, 131071, 9, 18, 0xa5bfffe0)
	EXT( 0xa5a5a49f, 9, 19, 0x00025a49)
	EXTU(0xa5a5a49f, 9, 19, 0x00025a49)
	DEP( 0xa5a5a49f, 262143, 9, 19, 0xa5bfffff)
	EXT( 0xa5a5a49e, 9, 20, 0x0004b493)
	EXTU(0xa5a5a49e, 9, 20, 0x0004b493)
	DEP( 0xa5a5a49e, 524287, 9, 20, 0xa5bffffe)
	EXT( 0xa5a5a49d, 9, 21, 0x00096927)
	EXTU(0xa5a5a49d, 9, 21, 0x00096927)
	DEP( 0xa5a5a49d, 1048575, 9, 21, 0xa5bffffd)
	EXT( 0xa5a5a49c, 9, 22, 0x0012d24e)
	EXTU(0xa5a5a49c, 9, 22, 0x0012d24e)
	DEP( 0xa5a5a49c, 2097151, 9, 22, 0xa5bffffe)
	EXT( 0xa5a5a49b, 10, 1, 0xffffffff)
	EXTU(0xa5a5a49b, 10, 1, 0x00000001)
	DEP( 0xa5a5a49b, 0, 10, 1, 0xa585a49b)
	EXT( 0xa5a5a49a, 10, 2, 0xfffffffe)
	EXTU(0xa5a5a49a, 10, 2, 0x00000002)
	DEP( 0xa5a5a49a, 1, 10, 2, 0xa595a49a)
	EXT( 0xa5a5a499, 10, 3, 0xfffffffc)
	EXTU(0xa5a5a499, 10, 3, 0x00000004)
	DEP( 0xa5a5a499, 3, 10, 3, 0xa59da499)
	EXT( 0xa5a5a498, 10, 4, 0xfffffff9)
	EXTU(0xa5a5a498, 10, 4, 0x00000009)
	DEP( 0xa5a5a498, 7, 10, 4, 0xa59da498)
	EXT( 0xa5a5a497, 10, 5, 0xfffffff2)
	EXTU(0xa5a5a497, 10, 5, 0x00000012)
	DEP( 0xa5a5a497, 15, 10, 5, 0xa59fa497)
	EXT( 0xa5a5a496, 10, 6, 0xffffffe5)
	EXTU(0xa5a5a496, 10, 6, 0x00000025)
	DEP( 0xa5a5a496, 31, 10, 6, 0xa59fa496)
	EXT( 0xa5a5a495, 10, 7, 0xffffffcb)
	EXTU(0xa5a5a495, 10, 7, 0x0000004b)
	DEP( 0xa5a5a495, 63, 10, 7, 0xa59fa495)
	EXT( 0xa5a5a494, 10, 8, 0xffffff96)
	EXTU(0xa5a5a494, 10, 8, 0x00000096)
	DEP( 0xa5a5a494, 127, 10, 8, 0xa59fe494)
	EXT( 0xa5a5a493, 10, 9, 0xffffff2d)
	EXTU(0xa5a5a493, 10, 9, 0x0000012d)
	DEP( 0xa5a5a493, 255, 10, 9, 0xa59fe493)
	EXT( 0xa5a5a492, 10, 10, 0xfffffe5a)
	EXTU(0xa5a5a492, 10, 10, 0x0000025a)
	DEP( 0xa5a5a492, 511, 10, 10, 0xa59ff492)
	EXT( 0xa5a5a491, 10, 11, 0xfffffcb4)
	EXTU(0xa5a5a491, 10, 11, 0x000004b4)
	DEP( 0xa5a5a491, 1023, 10, 11, 0xa59ffc91)
	EXT( 0xa5a5a490, 10, 12, 0xfffff969)
	EXTU(0xa5a5a490, 10, 12, 0x00000969)
	DEP( 0xa5a5a490, 2047, 10, 12, 0xa59ffc90)
	EXT( 0xa5a5a48f, 10, 13, 0xfffff2d2)
	EXTU(0xa5a5a48f, 10, 13, 0x000012d2)
	DEP( 0xa5a5a48f, 4095, 10, 13, 0xa59ffe8f)
	EXT( 0xa5a5a48e, 10, 14, 0xffffe5a4)
	EXTU(0xa5a5a48e, 10, 14, 0x000025a4)
	DEP( 0xa5a5a48e, 8191, 10, 14, 0xa59fff8e)
	EXT( 0xa5a5a48d, 10, 15, 0xffffcb49)
	EXTU(0xa5a5a48d, 10, 15, 0x00004b49)
	DEP( 0xa5a5a48d, 16383, 10, 15, 0xa59fff8d)
	EXT( 0xa5a5a48c, 10, 16, 0xffff9692)
	EXTU(0xa5a5a48c, 10, 16, 0x00009692)
	DEP( 0xa5a5a48c, 32767, 10, 16, 0xa59fffcc)
	EXT( 0xa5a5a48b, 10, 17, 0xffff2d24)
	EXTU(0xa5a5a48b, 10, 17, 0x00012d24)
	DEP( 0xa5a5a48b, 65535, 10, 17, 0xa59fffeb)
	EXT( 0xa5a5a48a, 10, 18, 0xfffe5a48)
	EXTU(0xa5a5a48a, 10, 18, 0x00025a48)
	DEP( 0xa5a5a48a, 131071, 10, 18, 0xa59ffffa)
	EXT( 0xa5a5a489, 10, 19, 0xfffcb491)
	EXTU(0xa5a5a489, 10, 19, 0x0004b491)
	DEP( 0xa5a5a489, 262143, 10, 19, 0xa59ffff9)
	EXT( 0xa5a5a488, 10, 20, 0xfff96922)
	EXTU(0xa5a5a488, 10, 20, 0x00096922)
	DEP( 0xa5a5a488, 524287, 10, 20, 0xa59ffffc)
	EXT( 0xa5a5a487, 10, 21, 0xfff2d243)
	EXTU(0xa5a5a487, 10, 21, 0x0012d243)
	DEP( 0xa5a5a487, 1048575, 10, 21, 0xa59fffff)
	EXT( 0xa5a5a486, 11, 1, 0x00000000)
	EXTU(0xa5a5a486, 11, 1, 0x00000000)
	DEP( 0xa5a5a486, 0, 11, 1, 0xa5a5a486)
	EXT( 0xa5a5a485, 11, 2, 0x00000000)
	EXTU(0xa5a5a485, 11, 2, 0x00000000)
	DEP( 0xa5a5a485, 1, 11, 2, 0xa5ada485)
	EXT( 0xa5a5a484, 11, 3, 0x00000001)
	EXTU(0xa5a5a484, 11, 3, 0x00000001)
	DEP( 0xa5a5a484, 3, 11, 3, 0xa5ada484)
	EXT( 0xa5a5a483, 11, 4, 0x00000002)
	EXTU(0xa5a5a483, 11, 4, 0x00000002)
	DEP( 0xa5a5a483, 7, 11, 4, 0xa5afa483)
	EXT( 0xa5a5a482, 11, 5, 0x00000005)
	EXTU(0xa5a5a482, 11, 5, 0x00000005)
	DEP( 0xa5a5a482, 15, 11, 5, 0xa5afa482)
	EXT( 0xa5a5a481, 11, 6, 0x0000000b)
	EXTU(0xa5a5a481, 11, 6, 0x0000000b)
	DEP( 0xa5a5a481, 31, 11, 6, 0xa5afa481)
	EXT( 0xa5a5a480, 11, 7, 0x00000016)
	EXTU(0xa5a5a480, 11, 7, 0x00000016)
	DEP( 0xa5a5a480, 63, 11, 7, 0xa5afe480)
	EXT( 0xa5a5a47f, 11, 8, 0x0000002d)
	EXTU(0xa5a5a47f, 11, 8, 0x0000002d)
	DEP( 0xa5a5a47f, 127, 11, 8, 0xa5afe47f)
	EXT( 0xa5a5a47e, 11, 9, 0x0000005a)
	EXTU(0xa5a5a47e, 11, 9, 0x0000005a)
	DEP( 0xa5a5a47e, 255, 11, 9, 0xa5aff47e)
	EXT( 0xa5a5a47d, 11, 10, 0x000000b4)
	EXTU(0xa5a5a47d, 11, 10, 0x000000b4)
	DEP( 0xa5a5a47d, 511, 11, 10, 0xa5affc7d)
	EXT( 0xa5a5a47c, 11, 11, 0x00000169)
	EXTU(0xa5a5a47c, 11, 11, 0x00000169)
	DEP( 0xa5a5a47c, 1023, 11, 11, 0xa5affc7c)
	EXT( 0xa5a5a47b, 11, 12, 0x000002d2)
	EXTU(0xa5a5a47b, 11, 12, 0x000002d2)
	DEP( 0xa5a5a47b, 2047, 11, 12, 0xa5affe7b)
	EXT( 0xa5a5a47a, 11, 13, 0x000005a4)
	EXTU(0xa5a5a47a, 11, 13, 0x000005a4)
	DEP( 0xa5a5a47a, 4095, 11, 13, 0xa5afff7a)
	EXT( 0xa5a5a479, 11, 14, 0x00000b48)
	EXTU(0xa5a5a479, 11, 14, 0x00000b48)
	DEP( 0xa5a5a479, 8191, 11, 14, 0xa5affff9)
	EXT( 0xa5a5a478, 11, 15, 0x00001691)
	EXTU(0xa5a5a478, 11, 15, 0x00001691)
	DEP( 0xa5a5a478, 16383, 11, 15, 0xa5affff8)
	EXT( 0xa5a5a477, 11, 16, 0x00002d23)
	EXTU(0xa5a5a477, 11, 16, 0x00002d23)
	DEP( 0xa5a5a477, 32767, 11, 16, 0xa5affff7)
	EXT( 0xa5a5a476, 11, 17, 0x00005a47)
	EXTU(0xa5a5a476, 11, 17, 0x00005a47)
	DEP( 0xa5a5a476, 65535, 11, 17, 0xa5affff6)
	EXT( 0xa5a5a475, 11, 18, 0x0000b48e)
	EXTU(0xa5a5a475, 11, 18, 0x0000b48e)
	DEP( 0xa5a5a475, 131071, 11, 18, 0xa5affffd)
	EXT( 0xa5a5a474, 11, 19, 0x0001691d)
	EXTU(0xa5a5a474, 11, 19, 0x0001691d)
	DEP( 0xa5a5a474, 262143, 11, 19, 0xa5affffc)
	EXT( 0xa5a5a473, 11, 20, 0x0002d239)
	EXTU(0xa5a5a473, 11, 20, 0x0002d239)
	DEP( 0xa5a5a473, 524287, 11, 20, 0xa5afffff)
	EXT( 0xa5a5a472, 12, 1, 0x00000000)
	EXTU(0xa5a5a472, 12, 1, 0x00000000)
	DEP( 0xa5a5a472, 0, 12, 1, 0xa5a5a472)
	EXT( 0xa5a5a471, 12, 2, 0x00000001)
	EXTU(0xa5a5a471, 12, 2, 0x00000001)
	DEP( 0xa5a5a471, 1, 12, 2, 0xa5a5a471)
	EXT( 0xa5a5a470, 12, 3, 0x00000002)
	EXTU(0xa5a5a470, 12, 3, 0x00000002)
	DEP( 0xa5a5a470, 3, 12, 3, 0xa5a7a470)
	EXT( 0xa5a5a46f, 12, 4, 0x00000005)
	EXTU(0xa5a5a46f, 12, 4, 0x00000005)
	DEP( 0xa5a5a46f, 7, 12, 4, 0xa5a7a46f)
	EXT( 0xa5a5a46e, 12, 5, 0x0000000b)
	EXTU(0xa5a5a46e, 12, 5, 0x0000000b)
	DEP( 0xa5a5a46e, 15, 12, 5, 0xa5a7a46e)
	EXT( 0xa5a5a46d, 12, 6, 0x00000016)
	EXTU(0xa5a5a46d, 12, 6, 0x00000016)
	DEP( 0xa5a5a46d, 31, 12, 6, 0xa5a7e46d)
	EXT( 0xa5a5a46c, 12, 7, 0x0000002d)
	EXTU(0xa5a5a46c, 12, 7, 0x0000002d)
	DEP( 0xa5a5a46c, 63, 12, 7, 0xa5a7e46c)
	EXT( 0xa5a5a46b, 12, 8, 0x0000005a)
	EXTU(0xa5a5a46b, 12, 8, 0x0000005a)
	DEP( 0xa5a5a46b, 127, 12, 8, 0xa5a7f46b)
	EXT( 0xa5a5a46a, 12, 9, 0x000000b4)
	EXTU(0xa5a5a46a, 12, 9, 0x000000b4)
	DEP( 0xa5a5a46a, 255, 12, 9, 0xa5a7fc6a)
	EXT( 0xa5a5a469, 12, 10, 0x00000169)
	EXTU(0xa5a5a469, 12, 10, 0x00000169)
	DEP( 0xa5a5a469, 511, 12, 10, 0xa5a7fc69)
	EXT( 0xa5a5a468, 12, 11, 0x000002d2)
	EXTU(0xa5a5a468, 12, 11, 0x000002d2)
	DEP( 0xa5a5a468, 1023, 12, 11, 0xa5a7fe68)
	EXT( 0xa5a5a467, 12, 12, 0x000005a4)
	EXTU(0xa5a5a467, 12, 12, 0x000005a4)
	DEP( 0xa5a5a467, 2047, 12, 12, 0xa5a7ff67)
	EXT( 0xa5a5a466, 12, 13, 0x00000b48)
	EXTU(0xa5a5a466, 12, 13, 0x00000b48)
	DEP( 0xa5a5a466, 4095, 12, 13, 0xa5a7ffe6)
	EXT( 0xa5a5a465, 12, 14, 0x00001691)
	EXTU(0xa5a5a465, 12, 14, 0x00001691)
	DEP( 0xa5a5a465, 8191, 12, 14, 0xa5a7ffe5)
	EXT( 0xa5a5a464, 12, 15, 0x00002d23)
	EXTU(0xa5a5a464, 12, 15, 0x00002d23)
	DEP( 0xa5a5a464, 16383, 12, 15, 0xa5a7ffe4)
	EXT( 0xa5a5a463, 12, 16, 0x00005a46)
	EXTU(0xa5a5a463, 12, 16, 0x00005a46)
	DEP( 0xa5a5a463, 32767, 12, 16, 0xa5a7fff3)
	EXT( 0xa5a5a462, 12, 17, 0x0000b48c)
	EXTU(0xa5a5a462, 12, 17, 0x0000b48c)
	DEP( 0xa5a5a462, 65535, 12, 17, 0xa5a7fffa)
	EXT( 0xa5a5a461, 12, 18, 0x00016918)
	EXTU(0xa5a5a461, 12, 18, 0x00016918)
	DEP( 0xa5a5a461, 131071, 12, 18, 0xa5a7fffd)
	EXT( 0xa5a5a460, 12, 19, 0x0002d230)
	EXTU(0xa5a5a460, 12, 19, 0x0002d230)
	DEP( 0xa5a5a460, 262143, 12, 19, 0xa5a7fffe)
	EXT( 0xa5a5a45f, 13, 1, 0xffffffff)
	EXTU(0xa5a5a45f, 13, 1, 0x00000001)
	DEP( 0xa5a5a45f, 0, 13, 1, 0xa5a1a45f)
	EXT( 0xa5a5a45e, 13, 2, 0xfffffffe)
	EXTU(0xa5a5a45e, 13, 2, 0x00000002)
	DEP( 0xa5a5a45e, 1, 13, 2, 0xa5a3a45e)
	EXT( 0xa5a5a45d, 13, 3, 0xfffffffd)
	EXTU(0xa5a5a45d, 13, 3, 0x00000005)
	DEP( 0xa5a5a45d, 3, 13, 3, 0xa5a3a45d)
	EXT( 0xa5a5a45c, 13, 4, 0xfffffffb)
	EXTU(0xa5a5a45c, 13, 4, 0x0000000b)
	DEP( 0xa5a5a45c, 7, 13, 4, 0xa5a3a45c)
	EXT( 0xa5a5a45b, 13, 5, 0xfffffff6)
	EXTU(0xa5a5a45b, 13, 5, 0x00000016)
	DEP( 0xa5a5a45b, 15, 13, 5, 0xa5a3e45b)
	EXT( 0xa5a5a45a, 13, 6, 0xffffffed)
	EXTU(0xa5a5a45a, 13, 6, 0x0000002d)
	DEP( 0xa5a5a45a, 31, 13, 6, 0xa5a3e45a)
	EXT( 0xa5a5a459, 13, 7, 0xffffffda)
	EXTU(0xa5a5a459, 13, 7, 0x0000005a)
	DEP( 0xa5a5a459, 63, 13, 7, 0xa5a3f459)
	EXT( 0xa5a5a458, 13, 8, 0xffffffb4)
	EXTU(0xa5a5a458, 13, 8, 0x000000b4)
	DEP( 0xa5a5a458, 127, 13, 8, 0xa5a3fc58)
	EXT( 0xa5a5a457, 13, 9, 0xffffff69)
	EXTU(0xa5a5a457, 13, 9, 0x00000169)
	DEP( 0xa5a5a457, 255, 13, 9, 0xa5a3fc57)
	EXT( 0xa5a5a456, 13, 10, 0xfffffed2)
	EXTU(0xa5a5a456, 13, 10, 0x000002d2)
	DEP( 0xa5a5a456, 511, 13, 10, 0xa5a3fe56)
	EXT( 0xa5a5a455, 13, 11, 0xfffffda4)
	EXTU(0xa5a5a455, 13, 11, 0x000005a4)
	DEP( 0xa5a5a455, 1023, 13, 11, 0xa5a3ff55)
	EXT( 0xa5a5a454, 13, 12, 0xfffffb48)
	EXTU(0xa5a5a454, 13, 12, 0x00000b48)
	DEP( 0xa5a5a454, 2047, 13, 12, 0xa5a3ffd4)
	EXT( 0xa5a5a453, 13, 13, 0xfffff691)
	EXTU(0xa5a5a453, 13, 13, 0x00001691)
	DEP( 0xa5a5a453, 4095, 13, 13, 0xa5a3ffd3)
	EXT( 0xa5a5a452, 13, 14, 0xffffed22)
	EXTU(0xa5a5a452, 13, 14, 0x00002d22)
	DEP( 0xa5a5a452, 8191, 13, 14, 0xa5a3fff2)
	EXT( 0xa5a5a451, 13, 15, 0xffffda45)
	EXTU(0xa5a5a451, 13, 15, 0x00005a45)
	DEP( 0xa5a5a451, 16383, 13, 15, 0xa5a3fff1)
	EXT( 0xa5a5a450, 13, 16, 0xffffb48a)
	EXTU(0xa5a5a450, 13, 16, 0x0000b48a)
	DEP( 0xa5a5a450, 32767, 13, 16, 0xa5a3fff8)
	EXT( 0xa5a5a44f, 13, 17, 0xffff6913)
	EXTU(0xa5a5a44f, 13, 17, 0x00016913)
	DEP( 0xa5a5a44f, 65535, 13, 17, 0xa5a3ffff)
	EXT( 0xa5a5a44e, 13, 18, 0xfffed227)
	EXTU(0xa5a5a44e, 13, 18, 0x0002d227)
	DEP( 0xa5a5a44e, 131071, 13, 18, 0xa5a3fffe)
	EXT( 0xa5a5a44d, 14, 1, 0x00000000)
	EXTU(0xa5a5a44d, 14, 1, 0x00000000)
	DEP( 0xa5a5a44d, 0, 14, 1, 0xa5a5a44d)
	EXT( 0xa5a5a44c, 14, 2, 0x00000001)
	EXTU(0xa5a5a44c, 14, 2, 0x00000001)
	DEP( 0xa5a5a44c, 1, 14, 2, 0xa5a5a44c)
	EXT( 0xa5a5a44b, 14, 3, 0x00000003)
	EXTU(0xa5a5a44b, 14, 3, 0x00000003)
	DEP( 0xa5a5a44b, 3, 14, 3, 0xa5a5a44b)
	EXT( 0xa5a5a44a, 14, 4, 0x00000006)
	EXTU(0xa5a5a44a, 14, 4, 0x00000006)
	DEP( 0xa5a5a44a, 7, 14, 4, 0xa5a5e44a)
	EXT( 0xa5a5a449, 14, 5, 0x0000000d)
	EXTU(0xa5a5a449, 14, 5, 0x0000000d)
	DEP( 0xa5a5a449, 15, 14, 5, 0xa5a5e449)
	EXT( 0xa5a5a448, 14, 6, 0x0000001a)
	EXTU(0xa5a5a448, 14, 6, 0x0000001a)
	DEP( 0xa5a5a448, 31, 14, 6, 0xa5a5f448)
	EXT( 0xa5a5a447, 14, 7, 0x00000034)
	EXTU(0xa5a5a447, 14, 7, 0x00000034)
	DEP( 0xa5a5a447, 63, 14, 7, 0xa5a5fc47)
	EXT( 0xa5a5a446, 14, 8, 0x00000069)
	EXTU(0xa5a5a446, 14, 8, 0x00000069)
	DEP( 0xa5a5a446, 127, 14, 8, 0xa5a5fc46)
	EXT( 0xa5a5a445, 14, 9, 0x000000d2)
	EXTU(0xa5a5a445, 14, 9, 0x000000d2)
	DEP( 0xa5a5a445, 255, 14, 9, 0xa5a5fe45)
	EXT( 0xa5a5a444, 14, 10, 0x000001a4)
	EXTU(0xa5a5a444, 14, 10, 0x000001a4)
	DEP( 0xa5a5a444, 511, 14, 10, 0xa5a5ff44)
	EXT( 0xa5a5a443, 14, 11, 0x00000348)
	EXTU(0xa5a5a443, 14, 11, 0x00000348)
	DEP( 0xa5a5a443, 1023, 14, 11, 0xa5a5ffc3)
	EXT( 0xa5a5a442, 14, 12, 0x00000691)
	EXTU(0xa5a5a442, 14, 12, 0x00000691)
	DEP( 0xa5a5a442, 2047, 14, 12, 0xa5a5ffc2)
	EXT( 0xa5a5a441, 14, 13, 0x00000d22)
	EXTU(0xa5a5a441, 14, 13, 0x00000d22)
	DEP( 0xa5a5a441, 4095, 14, 13, 0xa5a5ffe1)
	EXT( 0xa5a5a440, 14, 14, 0x00001a44)
	EXTU(0xa5a5a440, 14, 14, 0x00001a44)
	DEP( 0xa5a5a440, 8191, 14, 14, 0xa5a5fff0)
	EXT( 0xa5a5a43f, 14, 15, 0x00003487)
	EXTU(0xa5a5a43f, 14, 15, 0x00003487)
	DEP( 0xa5a5a43f, 16383, 14, 15, 0xa5a5ffff)
	EXT( 0xa5a5a43e, 14, 16, 0x0000690f)
	EXTU(0xa5a5a43e, 14, 16, 0x0000690f)
	DEP( 0xa5a5a43e, 32767, 14, 16, 0xa5a5fffe)
	EXT( 0xa5a5a43d, 14, 17, 0x0000d21e)
	EXTU(0xa5a5a43d, 14, 17, 0x0000d21e)
	DEP( 0xa5a5a43d, 65535, 14, 17, 0xa5a5ffff)
	EXT( 0xa5a5a43c, 15, 1, 0xffffffff)
	EXTU(0xa5a5a43c, 15, 1, 0x00000001)
	DEP( 0xa5a5a43c, 0, 15, 1, 0xa5a4a43c)
	EXT( 0xa5a5a43b, 15, 2, 0xffffffff)
	EXTU(0xa5a5a43b, 15, 2, 0x00000003)
	DEP( 0xa5a5a43b, 1, 15, 2, 0xa5a4a43b)
	EXT( 0xa5a5a43a, 15, 3, 0xfffffffe)
	EXTU(0xa5a5a43a, 15, 3, 0x00000006)
	DEP( 0xa5a5a43a, 3, 15, 3, 0xa5a4e43a)
	EXT( 0xa5a5a439, 15, 4, 0xfffffffd)
	EXTU(0xa5a5a439, 15, 4, 0x0000000d)
	DEP( 0xa5a5a439, 7, 15, 4, 0xa5a4e439)
	EXT( 0xa5a5a438, 15, 5, 0xfffffffa)
	EXTU(0xa5a5a438, 15, 5, 0x0000001a)
	DEP( 0xa5a5a438, 15, 15, 5, 0xa5a4f438)
	EXT( 0xa5a5a437, 15, 6, 0xfffffff4)
	EXTU(0xa5a5a437, 15, 6, 0x00000034)
	DEP( 0xa5a5a437, 31, 15, 6, 0xa5a4fc37)
	EXT( 0xa5a5a436, 15, 7, 0xffffffe9)
	EXTU(0xa5a5a436, 15, 7, 0x00000069)
	DEP( 0xa5a5a436, 63, 15, 7, 0xa5a4fc36)
	EXT( 0xa5a5a435, 15, 8, 0xffffffd2)
	EXTU(0xa5a5a435, 15, 8, 0x000000d2)
	DEP( 0xa5a5a435, 127, 15, 8, 0xa5a4fe35)
	EXT( 0xa5a5a434, 15, 9, 0xffffffa4)
	EXTU(0xa5a5a434, 15, 9, 0x000001a4)
	DEP( 0xa5a5a434, 255, 15, 9, 0xa5a4ff34)
	EXT( 0xa5a5a433, 15, 10, 0xffffff48)
	EXTU(0xa5a5a433, 15, 10, 0x00000348)
	DEP( 0xa5a5a433, 511, 15, 10, 0xa5a4ffb3)
	EXT( 0xa5a5a432, 15, 11, 0xfffffe90)
	EXTU(0xa5a5a432, 15, 11, 0x00000690)
	DEP( 0xa5a5a432, 1023, 15, 11, 0xa5a4fff2)
	EXT( 0xa5a5a431, 15, 12, 0xfffffd21)
	EXTU(0xa5a5a431, 15, 12, 0x00000d21)
	DEP( 0xa5a5a431, 2047, 15, 12, 0xa5a4fff1)
	EXT( 0xa5a5a430, 15, 13, 0xfffffa43)
	EXTU(0xa5a5a430, 15, 13, 0x00001a43)
	DEP( 0xa5a5a430, 4095, 15, 13, 0xa5a4fff0)
	EXT( 0xa5a5a42f, 15, 14, 0xfffff485)
	EXTU(0xa5a5a42f, 15, 14, 0x00003485)
	DEP( 0xa5a5a42f, 8191, 15, 14, 0xa5a4ffff)
	EXT( 0xa5a5a42e, 15, 15, 0xffffe90b)
	EXTU(0xa5a5a42e, 15, 15, 0x0000690b)
	DEP( 0xa5a5a42e, 16383, 15, 15, 0xa5a4fffe)
	EXT( 0xa5a5a42d, 15, 16, 0xffffd216)
	EXTU(0xa5a5a42d, 15, 16, 0x0000d216)
	DEP( 0xa5a5a42d, 32767, 15, 16, 0xa5a4ffff)
	EXT( 0xa5a5a42c, 16, 1, 0xffffffff)
	EXTU(0xa5a5a42c, 16, 1, 0x00000001)
	DEP( 0xa5a5a42c, 0, 16, 1, 0xa5a5242c)
	EXT( 0xa5a5a42b, 16, 2, 0xfffffffe)
	EXTU(0xa5a5a42b, 16, 2, 0x00000002)
	DEP( 0xa5a5a42b, 1, 16, 2, 0xa5a5642b)
	EXT( 0xa5a5a42a, 16, 3, 0xfffffffd)
	EXTU(0xa5a5a42a, 16, 3, 0x00000005)
	DEP( 0xa5a5a42a, 3, 16, 3, 0xa5a5642a)
	EXT( 0xa5a5a429, 16, 4, 0xfffffffa)
	EXTU(0xa5a5a429, 16, 4, 0x0000000a)
	DEP( 0xa5a5a429, 7, 16, 4, 0xa5a57429)
	EXT( 0xa5a5a428, 16, 5, 0xfffffff4)
	EXTU(0xa5a5a428, 16, 5, 0x00000014)
	DEP( 0xa5a5a428, 15, 16, 5, 0xa5a57c28)
	EXT( 0xa5a5a427, 16, 6, 0xffffffe9)
	EXTU(0xa5a5a427, 16, 6, 0x00000029)
	DEP( 0xa5a5a427, 31, 16, 6, 0xa5a57c27)
	EXT( 0xa5a5a426, 16, 7, 0xffffffd2)
	EXTU(0xa5a5a426, 16, 7, 0x00000052)
	DEP( 0xa5a5a426, 63, 16, 7, 0xa5a57e26)
	EXT( 0xa5a5a425, 16, 8, 0xffffffa4)
	EXTU(0xa5a5a425, 16, 8, 0x000000a4)
	DEP( 0xa5a5a425, 127, 16, 8, 0xa5a57f25)
	EXT( 0xa5a5a424, 16, 9, 0xffffff48)
	EXTU(0xa5a5a424, 16, 9, 0x00000148)
	DEP( 0xa5a5a424, 255, 16, 9, 0xa5a57fa4)
	EXT( 0xa5a5a423, 16, 10, 0xfffffe90)
	EXTU(0xa5a5a423, 16, 10, 0x00000290)
	DEP( 0xa5a5a423, 511, 16, 10, 0xa5a57fe3)
	EXT( 0xa5a5a422, 16, 11, 0xfffffd21)
	EXTU(0xa5a5a422, 16, 11, 0x00000521)
	DEP( 0xa5a5a422, 1023, 16, 11, 0xa5a57fe2)
	EXT( 0xa5a5a421, 16, 12, 0xfffffa42)
	EXTU(0xa5a5a421, 16, 12, 0x00000a42)
	DEP( 0xa5a5a421, 2047, 16, 12, 0xa5a57ff1)
	EXT( 0xa5a5a420, 16, 13, 0xfffff484)
	EXTU(0xa5a5a420, 16, 13, 0x00001484)
	DEP( 0xa5a5a420, 4095, 16, 13, 0xa5a57ff8)
	EXT( 0xa5a5a41f, 16, 14, 0xffffe907)
	EXTU(0xa5a5a41f, 16, 14, 0x00002907)
	DEP( 0xa5a5a41f, 8191, 16, 14, 0xa5a57fff)
	EXT( 0xa5a5a41e, 16, 15, 0xffffd20f)
	EXTU(0xa5a5a41e, 16, 15, 0x0000520f)
	DEP( 0xa5a5a41e, 16383, 16, 15, 0xa5a57ffe)
	EXT( 0xa5a5a41d, 17, 1, 0x00000000)
	EXTU(0xa5a5a41d, 17, 1, 0x00000000)
	DEP( 0xa5a5a41d, 0, 17, 1, 0xa5a5a41d)
	EXT( 0xa5a5a41c, 17, 2, 0x00000001)
	EXTU(0xa5a5a41c, 17, 2, 0x00000001)
	DEP( 0xa5a5a41c, 1, 17, 2, 0xa5a5a41c)
	EXT( 0xa5a5a41b, 17, 3, 0x00000002)
	EXTU(0xa5a5a41b, 17, 3, 0x00000002)
	DEP( 0xa5a5a41b, 3, 17, 3, 0xa5a5b41b)
	EXT( 0xa5a5a41a, 17, 4, 0x00000004)
	EXTU(0xa5a5a41a, 17, 4, 0x00000004)
	DEP( 0xa5a5a41a, 7, 17, 4, 0xa5a5bc1a)
	EXT( 0xa5a5a419, 17, 5, 0x00000009)
	EXTU(0xa5a5a419, 17, 5, 0x00000009)
	DEP( 0xa5a5a419, 15, 17, 5, 0xa5a5bc19)
	EXT( 0xa5a5a418, 17, 6, 0x00000012)
	EXTU(0xa5a5a418, 17, 6, 0x00000012)
	DEP( 0xa5a5a418, 31, 17, 6, 0xa5a5be18)
	EXT( 0xa5a5a417, 17, 7, 0x00000024)
	EXTU(0xa5a5a417, 17, 7, 0x00000024)
	DEP( 0xa5a5a417, 63, 17, 7, 0xa5a5bf17)
	EXT( 0xa5a5a416, 17, 8, 0x00000048)
	EXTU(0xa5a5a416, 17, 8, 0x00000048)
	DEP( 0xa5a5a416, 127, 17, 8, 0xa5a5bf96)
	EXT( 0xa5a5a415, 17, 9, 0x00000090)
	EXTU(0xa5a5a415, 17, 9, 0x00000090)
	DEP( 0xa5a5a415, 255, 17, 9, 0xa5a5bfd5)
	EXT( 0xa5a5a414, 17, 10, 0x00000120)
	EXTU(0xa5a5a414, 17, 10, 0x00000120)
	DEP( 0xa5a5a414, 511, 17, 10, 0xa5a5bff4)
	EXT( 0xa5a5a413, 17, 11, 0x00000241)
	EXTU(0xa5a5a413, 17, 11, 0x00000241)
	DEP( 0xa5a5a413, 1023, 17, 11, 0xa5a5bff3)
	EXT( 0xa5a5a412, 17, 12, 0x00000482)
	EXTU(0xa5a5a412, 17, 12, 0x00000482)
	DEP( 0xa5a5a412, 2047, 17, 12, 0xa5a5bffa)
	EXT( 0xa5a5a411, 17, 13, 0x00000904)
	EXTU(0xa5a5a411, 17, 13, 0x00000904)
	DEP( 0xa5a5a411, 4095, 17, 13, 0xa5a5bffd)
	EXT( 0xa5a5a410, 17, 14, 0x00001208)
	EXTU(0xa5a5a410, 17, 14, 0x00001208)
	DEP( 0xa5a5a410, 8191, 17, 14, 0xa5a5bffe)
	EXT( 0xa5a5a40f, 18, 1, 0xffffffff)
	EXTU(0xa5a5a40f, 18, 1, 0x00000001)
	DEP( 0xa5a5a40f, 0, 18, 1, 0xa5a5840f)
	EXT( 0xa5a5a40e, 18, 2, 0xfffffffe)
	EXTU(0xa5a5a40e, 18, 2, 0x00000002)
	DEP( 0xa5a5a40e, 1, 18, 2, 0xa5a5940e)
	EXT( 0xa5a5a40d, 18, 3, 0xfffffffc)
	EXTU(0xa5a5a40d, 18, 3, 0x00000004)
	DEP( 0xa5a5a40d, 3, 18, 3, 0xa5a59c0d)
	EXT( 0xa5a5a40c, 18, 4, 0xfffffff9)
	EXTU(0xa5a5a40c, 18, 4, 0x00000009)
	DEP( 0xa5a5a40c, 7, 18, 4, 0xa5a59c0c)
	EXT( 0xa5a5a40b, 18, 5, 0xfffffff2)
	EXTU(0xa5a5a40b, 18, 5, 0x00000012)
	DEP( 0xa5a5a40b, 15, 18, 5, 0xa5a59e0b)
	EXT( 0xa5a5a40a, 18, 6, 0xffffffe4)
	EXTU(0xa5a5a40a, 18, 6, 0x00000024)
	DEP( 0xa5a5a40a, 31, 18, 6, 0xa5a59f0a)
	EXT( 0xa5a5a409, 18, 7, 0xffffffc8)
	EXTU(0xa5a5a409, 18, 7, 0x00000048)
	DEP( 0xa5a5a409, 63, 18, 7, 0xa5a59f89)
	EXT( 0xa5a5a408, 18, 8, 0xffffff90)
	EXTU(0xa5a5a408, 18, 8, 0x00000090)
	DEP( 0xa5a5a408, 127, 18, 8, 0xa5a59fc8)
	EXT( 0xa5a5a407, 18, 9, 0xffffff20)
	EXTU(0xa5a5a407, 18, 9, 0x00000120)
	DEP( 0xa5a5a407, 255, 18, 9, 0xa5a59fe7)
	EXT( 0xa5a5a406, 18, 10, 0xfffffe40)
	EXTU(0xa5a5a406, 18, 10, 0x00000240)
	DEP( 0xa5a5a406, 511, 18, 10, 0xa5a59ff6)
	EXT( 0xa5a5a405, 18, 11, 0xfffffc80)
	EXTU(0xa5a5a405, 18, 11, 0x00000480)
	DEP( 0xa5a5a405, 1023, 18, 11, 0xa5a59ffd)
	EXT( 0xa5a5a404, 18, 12, 0xfffff901)
	EXTU(0xa5a5a404, 18, 12, 0x00000901)
	DEP( 0xa5a5a404, 2047, 18, 12, 0xa5a59ffc)
	EXT( 0xa5a5a403, 18, 13, 0xfffff201)
	EXTU(0xa5a5a403, 18, 13, 0x00001201)
	DEP( 0xa5a5a403, 4095, 18, 13, 0xa5a59fff)
	EXT( 0xa5a5a402, 19, 1, 0x00000000)
	EXTU(0xa5a5a402, 19, 1, 0x00000000)
	DEP( 0xa5a5a402, 0, 19, 1, 0xa5a5a402)
	EXT( 0xa5a5a401, 19, 2, 0x00000000)
	EXTU(0xa5a5a401, 19, 2, 0x00000000)
	DEP( 0xa5a5a401, 1, 19, 2, 0xa5a5ac01)
	EXT( 0xa5a5a400, 19, 3, 0x00000001)
	EXTU(0xa5a5a400, 19, 3, 0x00000001)
	DEP( 0xa5a5a400, 3, 19, 3, 0xa5a5ac00)
	EXT( 0xa5a5a3ff, 19, 4, 0x00000001)
	EXTU(0xa5a5a3ff, 19, 4, 0x00000001)
	DEP( 0xa5a5a3ff, 7, 19, 4, 0xa5a5afff)
	EXT( 0xa5a5a3fe, 19, 5, 0x00000003)
	EXTU(0xa5a5a3fe, 19, 5, 0x00000003)
	DEP( 0xa5a5a3fe, 15, 19, 5, 0xa5a5affe)
	EXT( 0xa5a5a3fd, 19, 6, 0x00000007)
	EXTU(0xa5a5a3fd, 19, 6, 0x00000007)
	DEP( 0xa5a5a3fd, 31, 19, 6, 0xa5a5affd)
	EXT( 0xa5a5a3fc, 19, 7, 0x0000000f)
	EXTU(0xa5a5a3fc, 19, 7, 0x0000000f)
	DEP( 0xa5a5a3fc, 63, 19, 7, 0xa5a5affc)
	EXT( 0xa5a5a3fb, 19, 8, 0x0000001f)
	EXTU(0xa5a5a3fb, 19, 8, 0x0000001f)
	DEP( 0xa5a5a3fb, 127, 19, 8, 0xa5a5affb)
	EXT( 0xa5a5a3fa, 19, 9, 0x0000003f)
	EXTU(0xa5a5a3fa, 19, 9, 0x0000003f)
	DEP( 0xa5a5a3fa, 255, 19, 9, 0xa5a5affa)
	EXT( 0xa5a5a3f9, 19, 10, 0x0000007f)
	EXTU(0xa5a5a3f9, 19, 10, 0x0000007f)
	DEP( 0xa5a5a3f9, 511, 19, 10, 0xa5a5aff9)
	EXT( 0xa5a5a3f8, 19, 11, 0x000000fe)
	EXTU(0xa5a5a3f8, 19, 11, 0x000000fe)
	DEP( 0xa5a5a3f8, 1023, 19, 11, 0xa5a5affc)
	EXT( 0xa5a5a3f7, 19, 12, 0x000001fb)
	EXTU(0xa5a5a3f7, 19, 12, 0x000001fb)
	DEP( 0xa5a5a3f7, 2047, 19, 12, 0xa5a5afff)
	EXT( 0xa5a5a3f6, 20, 1, 0x00000000)
	EXTU(0xa5a5a3f6, 20, 1, 0x00000000)
	DEP( 0xa5a5a3f6, 0, 20, 1, 0xa5a5a3f6)
	EXT( 0xa5a5a3f5, 20, 2, 0x00000000)
	EXTU(0xa5a5a3f5, 20, 2, 0x00000000)
	DEP( 0xa5a5a3f5, 1, 20, 2, 0xa5a5a7f5)
	EXT( 0xa5a5a3f4, 20, 3, 0x00000001)
	EXTU(0xa5a5a3f4, 20, 3, 0x00000001)
	DEP( 0xa5a5a3f4, 3, 20, 3, 0xa5a5a7f4)
	EXT( 0xa5a5a3f3, 20, 4, 0x00000003)
	EXTU(0xa5a5a3f3, 20, 4, 0x00000003)
	DEP( 0xa5a5a3f3, 7, 20, 4, 0xa5a5a7f3)
	EXT( 0xa5a5a3f2, 20, 5, 0x00000007)
	EXTU(0xa5a5a3f2, 20, 5, 0x00000007)
	DEP( 0xa5a5a3f2, 15, 20, 5, 0xa5a5a7f2)
	EXT( 0xa5a5a3f1, 20, 6, 0x0000000f)
	EXTU(0xa5a5a3f1, 20, 6, 0x0000000f)
	DEP( 0xa5a5a3f1, 31, 20, 6, 0xa5a5a7f1)
	EXT( 0xa5a5a3f0, 20, 7, 0x0000001f)
	EXTU(0xa5a5a3f0, 20, 7, 0x0000001f)
	DEP( 0xa5a5a3f0, 63, 20, 7, 0xa5a5a7f0)
	EXT( 0xa5a5a3ef, 20, 8, 0x0000003e)
	EXTU(0xa5a5a3ef, 20, 8, 0x0000003e)
	DEP( 0xa5a5a3ef, 127, 20, 8, 0xa5a5a7ff)
	EXT( 0xa5a5a3ee, 20, 9, 0x0000007d)
	EXTU(0xa5a5a3ee, 20, 9, 0x0000007d)
	DEP( 0xa5a5a3ee, 255, 20, 9, 0xa5a5a7fe)
	EXT( 0xa5a5a3ed, 20, 10, 0x000000fb)
	EXTU(0xa5a5a3ed, 20, 10, 0x000000fb)
	DEP( 0xa5a5a3ed, 511, 20, 10, 0xa5a5a7fd)
	EXT( 0xa5a5a3ec, 20, 11, 0x000001f6)
	EXTU(0xa5a5a3ec, 20, 11, 0x000001f6)
	DEP( 0xa5a5a3ec, 1023, 20, 11, 0xa5a5a7fe)
	EXT( 0xa5a5a3eb, 21, 1, 0x00000000)
	EXTU(0xa5a5a3eb, 21, 1, 0x00000000)
	DEP( 0xa5a5a3eb, 0, 21, 1, 0xa5a5a3eb)
	EXT( 0xa5a5a3ea, 21, 2, 0x00000001)
	EXTU(0xa5a5a3ea, 21, 2, 0x00000001)
	DEP( 0xa5a5a3ea, 1, 21, 2, 0xa5a5a3ea)
	EXT( 0xa5a5a3e9, 21, 3, 0x00000003)
	EXTU(0xa5a5a3e9, 21, 3, 0x00000003)
	DEP( 0xa5a5a3e9, 3, 21, 3, 0xa5a5a3e9)
	EXT( 0xa5a5a3e8, 21, 4, 0x00000007)
	EXTU(0xa5a5a3e8, 21, 4, 0x00000007)
	DEP( 0xa5a5a3e8, 7, 21, 4, 0xa5a5a3e8)
	EXT( 0xa5a5a3e7, 21, 5, 0x0000000f)
	EXTU(0xa5a5a3e7, 21, 5, 0x0000000f)
	DEP( 0xa5a5a3e7, 15, 21, 5, 0xa5a5a3e7)
	EXT( 0xa5a5a3e6, 21, 6, 0x0000001f)
	EXTU(0xa5a5a3e6, 21, 6, 0x0000001f)
	DEP( 0xa5a5a3e6, 31, 21, 6, 0xa5a5a3e6)
	EXT( 0xa5a5a3e5, 21, 7, 0x0000003e)
	EXTU(0xa5a5a3e5, 21, 7, 0x0000003e)
	DEP( 0xa5a5a3e5, 63, 21, 7, 0xa5a5a3f5)
	EXT( 0xa5a5a3e4, 21, 8, 0x0000007c)
	EXTU(0xa5a5a3e4, 21, 8, 0x0000007c)
	DEP( 0xa5a5a3e4, 127, 21, 8, 0xa5a5a3fc)
	EXT( 0xa5a5a3e3, 21, 9, 0x000000f8)
	EXTU(0xa5a5a3e3, 21, 9, 0x000000f8)
	DEP( 0xa5a5a3e3, 255, 21, 9, 0xa5a5a3ff)
	EXT( 0xa5a5a3e2, 21, 10, 0x000001f1)
	EXTU(0xa5a5a3e2, 21, 10, 0x000001f1)
	DEP( 0xa5a5a3e2, 511, 21, 10, 0xa5a5a3fe)
	EXT( 0xa5a5a3e1, 22, 1, 0xffffffff)
	EXTU(0xa5a5a3e1, 22, 1, 0x00000001)
	DEP( 0xa5a5a3e1, 0, 22, 1, 0xa5a5a1e1)
	EXT( 0xa5a5a3e0, 22, 2, 0xffffffff)
	EXTU(0xa5a5a3e0, 22, 2, 0x00000003)
	DEP( 0xa5a5a3e0, 1, 22, 2, 0xa5a5a1e0)
	EXT( 0xa5a5a3df, 22, 3, 0xffffffff)
	EXTU(0xa5a5a3df, 22, 3, 0x00000007)
	DEP( 0xa5a5a3df, 3, 22, 3, 0xa5a5a1df)
	EXT( 0xa5a5a3de, 22, 4, 0xffffffff)
	EXTU(0xa5a5a3de, 22, 4, 0x0000000f)
	DEP( 0xa5a5a3de, 7, 22, 4, 0xa5a5a1de)
	EXT( 0xa5a5a3dd, 22, 5, 0xfffffffe)
	EXTU(0xa5a5a3dd, 22, 5, 0x0000001e)
	DEP( 0xa5a5a3dd, 15, 22, 5, 0xa5a5a1fd)
	EXT( 0xa5a5a3dc, 22, 6, 0xfffffffd)
	EXTU(0xa5a5a3dc, 22, 6, 0x0000003d)
	DEP( 0xa5a5a3dc, 31, 22, 6, 0xa5a5a1fc)
	EXT( 0xa5a5a3db, 22, 7, 0xfffffffb)
	EXTU(0xa5a5a3db, 22, 7, 0x0000007b)
	DEP( 0xa5a5a3db, 63, 22, 7, 0xa5a5a1fb)
	EXT( 0xa5a5a3da, 22, 8, 0xfffffff6)
	EXTU(0xa5a5a3da, 22, 8, 0x000000f6)
	DEP( 0xa5a5a3da, 127, 22, 8, 0xa5a5a1fe)
	EXT( 0xa5a5a3d9, 22, 9, 0xffffffec)
	EXTU(0xa5a5a3d9, 22, 9, 0x000001ec)
	DEP( 0xa5a5a3d9, 255, 22, 9, 0xa5a5a1ff)
	EXT( 0xa5a5a3d8, 23, 1, 0xffffffff)
	EXTU(0xa5a5a3d8, 23, 1, 0x00000001)
	DEP( 0xa5a5a3d8, 0, 23, 1, 0xa5a5a2d8)
	EXT( 0xa5a5a3d7, 23, 2, 0xffffffff)
	EXTU(0xa5a5a3d7, 23, 2, 0x00000003)
	DEP( 0xa5a5a3d7, 1, 23, 2, 0xa5a5a2d7)
	EXT( 0xa5a5a3d6, 23, 3, 0xffffffff)
	EXTU(0xa5a5a3d6, 23, 3, 0x00000007)
	DEP( 0xa5a5a3d6, 3, 23, 3, 0xa5a5a2d6)
	EXT( 0xa5a5a3d5, 23, 4, 0xfffffffe)
	EXTU(0xa5a5a3d5, 23, 4, 0x0000000e)
	DEP( 0xa5a5a3d5, 7, 23, 4, 0xa5a5a2f5)
	EXT( 0xa5a5a3d4, 23, 5, 0xfffffffd)
	EXTU(0xa5a5a3d4, 23, 5, 0x0000001d)
	DEP( 0xa5a5a3d4, 15, 23, 5, 0xa5a5a2f4)
	EXT( 0xa5a5a3d3, 23, 6, 0xfffffffa)
	EXTU(0xa5a5a3d3, 23, 6, 0x0000003a)
	DEP( 0xa5a5a3d3, 31, 23, 6, 0xa5a5a2fb)
	EXT( 0xa5a5a3d2, 23, 7, 0xfffffff4)
	EXTU(0xa5a5a3d2, 23, 7, 0x00000074)
	DEP( 0xa5a5a3d2, 63, 23, 7, 0xa5a5a2fe)
	EXT( 0xa5a5a3d1, 23, 8, 0xffffffe8)
	EXTU(0xa5a5a3d1, 23, 8, 0x000000e8)
	DEP( 0xa5a5a3d1, 127, 23, 8, 0xa5a5a2ff)
	EXT( 0xa5a5a3d0, 24, 1, 0xffffffff)
	EXTU(0xa5a5a3d0, 24, 1, 0x00000001)
	DEP( 0xa5a5a3d0, 0, 24, 1, 0xa5a5a350)
	EXT( 0xa5a5a3cf, 24, 2, 0xffffffff)
	EXTU(0xa5a5a3cf, 24, 2, 0x00000003)
	DEP( 0xa5a5a3cf, 1, 24, 2, 0xa5a5a34f)
	EXT( 0xa5a5a3ce, 24, 3, 0xfffffffe)
	EXTU(0xa5a5a3ce, 24, 3, 0x00000006)
	DEP( 0xa5a5a3ce, 3, 24, 3, 0xa5a5a36e)
	EXT( 0xa5a5a3cd, 24, 4, 0xfffffffc)
	EXTU(0xa5a5a3cd, 24, 4, 0x0000000c)
	DEP( 0xa5a5a3cd, 7, 24, 4, 0xa5a5a37d)
	EXT( 0xa5a5a3cc, 24, 5, 0xfffffff9)
	EXTU(0xa5a5a3cc, 24, 5, 0x00000019)
	DEP( 0xa5a5a3cc, 15, 24, 5, 0xa5a5a37c)
	EXT( 0xa5a5a3cb, 24, 6, 0xfffffff2)
	EXTU(0xa5a5a3cb, 24, 6, 0x00000032)
	DEP( 0xa5a5a3cb, 31, 24, 6, 0xa5a5a37f)
	EXT( 0xa5a5a3ca, 24, 7, 0xffffffe5)
	EXTU(0xa5a5a3ca, 24, 7, 0x00000065)
	DEP( 0xa5a5a3ca, 63, 24, 7, 0xa5a5a37e)
	EXT( 0xa5a5a3c9, 25, 1, 0xffffffff)
	EXTU(0xa5a5a3c9, 25, 1, 0x00000001)
	DEP( 0xa5a5a3c9, 0, 25, 1, 0xa5a5a389)
	EXT( 0xa5a5a3c8, 25, 2, 0xfffffffe)
	EXTU(0xa5a5a3c8, 25, 2, 0x00000002)
	DEP( 0xa5a5a3c8, 1, 25, 2, 0xa5a5a3a8)
	EXT( 0xa5a5a3c7, 25, 3, 0xfffffffc)
	EXTU(0xa5a5a3c7, 25, 3, 0x00000004)
	DEP( 0xa5a5a3c7, 3, 25, 3, 0xa5a5a3b7)
	EXT( 0xa5a5a3c6, 25, 4, 0xfffffff8)
	EXTU(0xa5a5a3c6, 25, 4, 0x00000008)
	DEP( 0xa5a5a3c6, 7, 25, 4, 0xa5a5a3be)
	EXT( 0xa5a5a3c5, 25, 5, 0xfffffff1)
	EXTU(0xa5a5a3c5, 25, 5, 0x00000011)
	DEP( 0xa5a5a3c5, 15, 25, 5, 0xa5a5a3bd)
	EXT( 0xa5a5a3c4, 25, 6, 0xffffffe2)
	EXTU(0xa5a5a3c4, 25, 6, 0x00000022)
	DEP( 0xa5a5a3c4, 31, 25, 6, 0xa5a5a3be)
	EXT( 0xa5a5a3c3, 26, 1, 0x00000000)
	EXTU(0xa5a5a3c3, 26, 1, 0x00000000)
	DEP( 0xa5a5a3c3, 0, 26, 1, 0xa5a5a3c3)
	EXT( 0xa5a5a3c2, 26, 2, 0x00000000)
	EXTU(0xa5a5a3c2, 26, 2, 0x00000000)
	DEP( 0xa5a5a3c2, 1, 26, 2, 0xa5a5a3d2)
	EXT( 0xa5a5a3c1, 26, 3, 0x00000000)
	EXTU(0xa5a5a3c1, 26, 3, 0x00000000)
	DEP( 0xa5a5a3c1, 3, 26, 3, 0xa5a5a3d9)
	EXT( 0xa5a5a3c0, 26, 4, 0x00000000)
	EXTU(0xa5a5a3c0, 26, 4, 0x00000000)
	DEP( 0xa5a5a3c0, 7, 26, 4, 0xa5a5a3dc)
	EXT( 0xa5a5a3bf, 26, 5, 0xffffffff)
	EXTU(0xa5a5a3bf, 26, 5, 0x0000001f)
	DEP( 0xa5a5a3bf, 15, 26, 5, 0xa5a5a39f)
	EXT( 0xa5a5a3be, 27, 1, 0xffffffff)
	EXTU(0xa5a5a3be, 27, 1, 0x00000001)
	DEP( 0xa5a5a3be, 0, 27, 1, 0xa5a5a3ae)
	EXT( 0xa5a5a3bd, 27, 2, 0xffffffff)
	EXTU(0xa5a5a3bd, 27, 2, 0x00000003)
	DEP( 0xa5a5a3bd, 1, 27, 2, 0xa5a5a3ad)
	EXT( 0xa5a5a3bc, 27, 3, 0xffffffff)
	EXTU(0xa5a5a3bc, 27, 3, 0x00000007)
	DEP( 0xa5a5a3bc, 3, 27, 3, 0xa5a5a3ac)
	EXT( 0xa5a5a3bb, 27, 4, 0xfffffffd)
	EXTU(0xa5a5a3bb, 27, 4, 0x0000000d)
	DEP( 0xa5a5a3bb, 7, 27, 4, 0xa5a5a3af)
	EXT( 0xa5a5a3ba, 28, 1, 0xffffffff)
	EXTU(0xa5a5a3ba, 28, 1, 0x00000001)
	DEP( 0xa5a5a3ba, 0, 28, 1, 0xa5a5a3b2)
	EXT( 0xa5a5a3b9, 28, 2, 0xfffffffe)
	EXTU(0xa5a5a3b9, 28, 2, 0x00000002)
	DEP( 0xa5a5a3b9, 1, 28, 2, 0xa5a5a3b5)
	EXT( 0xa5a5a3b8, 28, 3, 0xfffffffc)
	EXTU(0xa5a5a3b8, 28, 3, 0x00000004)
	DEP( 0xa5a5a3b8, 3, 28, 3, 0xa5a5a3b6)
	EXT( 0xa5a5a3b7, 29, 1, 0xffffffff)
	EXTU(0xa5a5a3b7, 29, 1, 0x00000001)
	DEP( 0xa5a5a3b7, 0, 29, 1, 0xa5a5a3b3)
	EXT( 0xa5a5a3b6, 29, 2, 0xffffffff)
	EXTU(0xa5a5a3b6, 29, 2, 0x00000003)
	DEP( 0xa5a5a3b6, 1, 29, 2, 0xa5a5a3b2)
	EXT( 0xa5a5a3b5, 30, 1, 0x00000000)
	EXTU(0xa5a5a3b5, 30, 1, 0x00000000)
	DEP( 0xa5a5a3b5, 0, 30, 1, 0xa5a5a3b5)
#    endif

#  else
#    if __BYTE_ORDER == __LITTLE_ENDIAN
	EXT( 0xa5a5a5a5a5a5a5a4, 0, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a5a4, 0, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a5a4, 0, 0, 1, 0xa5a5a5a5a5a5a5a4)
	EXT( 0xa5a5a5a5a5a5a5a3, 0, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a5a3, 0, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a5a3, 1, 0, 2, 0xa5a5a5a5a5a5a5a1)
	EXT( 0xa5a5a5a5a5a5a5a2, 0, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a5a2, 0, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a5a2, 3, 0, 3, 0xa5a5a5a5a5a5a5a3)
	EXT( 0xa5a5a5a5a5a5a5a1, 0, 4, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a5a1, 0, 4, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a5a1, 7, 0, 4, 0xa5a5a5a5a5a5a5a7)
	EXT( 0xa5a5a5a5a5a5a5a0, 0, 5, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a5a0, 0, 5, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a5a0, 15, 0, 5, 0xa5a5a5a5a5a5a5af)
	EXT( 0xa5a5a5a5a5a5a59f, 0, 6, 0x000000000000001f)
	EXTU(0xa5a5a5a5a5a5a59f, 0, 6, 0x000000000000001f)
	DEP( 0xa5a5a5a5a5a5a59f, 31, 0, 6, 0xa5a5a5a5a5a5a59f)
	EXT( 0xa5a5a5a5a5a5a59e, 0, 7, 0x000000000000001e)
	EXTU(0xa5a5a5a5a5a5a59e, 0, 7, 0x000000000000001e)
	DEP( 0xa5a5a5a5a5a5a59e, 63, 0, 7, 0xa5a5a5a5a5a5a5bf)
	EXT( 0xa5a5a5a5a5a5a59d, 0, 8, 0xffffffffffffff9d)
	EXTU(0xa5a5a5a5a5a5a59d, 0, 8, 0x000000000000009d)
	DEP( 0xa5a5a5a5a5a5a59d, 127, 0, 8, 0xa5a5a5a5a5a5a57f)
	EXT( 0xa5a5a5a5a5a5a59c, 0, 9, 0xffffffffffffff9c)
	EXTU(0xa5a5a5a5a5a5a59c, 0, 9, 0x000000000000019c)
	DEP( 0xa5a5a5a5a5a5a59c, 255, 0, 9, 0xa5a5a5a5a5a5a4ff)
	EXT( 0xa5a5a5a5a5a5a59b, 0, 10, 0x000000000000019b)
	EXTU(0xa5a5a5a5a5a5a59b, 0, 10, 0x000000000000019b)
	DEP( 0xa5a5a5a5a5a5a59b, 511, 0, 10, 0xa5a5a5a5a5a5a5ff)
	EXT( 0xa5a5a5a5a5a5a59a, 0, 11, 0xfffffffffffffd9a)
	EXTU(0xa5a5a5a5a5a5a59a, 0, 11, 0x000000000000059a)
	DEP( 0xa5a5a5a5a5a5a59a, 1023, 0, 11, 0xa5a5a5a5a5a5a3ff)
	EXT( 0xa5a5a5a5a5a5a599, 0, 12, 0x0000000000000599)
	EXTU(0xa5a5a5a5a5a5a599, 0, 12, 0x0000000000000599)
	DEP( 0xa5a5a5a5a5a5a599, 2047, 0, 12, 0xa5a5a5a5a5a5a7ff)
	EXT( 0xa5a5a5a5a5a5a598, 0, 13, 0x0000000000000598)
	EXTU(0xa5a5a5a5a5a5a598, 0, 13, 0x0000000000000598)
	DEP( 0xa5a5a5a5a5a5a598, 4095, 0, 13, 0xa5a5a5a5a5a5afff)
	EXT( 0xa5a5a5a5a5a5a597, 0, 14, 0xffffffffffffe597)
	EXTU(0xa5a5a5a5a5a5a597, 0, 14, 0x0000000000002597)
	DEP( 0xa5a5a5a5a5a5a597, 8191, 0, 14, 0xa5a5a5a5a5a59fff)
	EXT( 0xa5a5a5a5a5a5a596, 0, 15, 0x0000000000002596)
	EXTU(0xa5a5a5a5a5a5a596, 0, 15, 0x0000000000002596)
	DEP( 0xa5a5a5a5a5a5a596, 16383, 0, 15, 0xa5a5a5a5a5a5bfff)
	EXT( 0xa5a5a5a5a5a5a595, 0, 16, 0xffffffffffffa595)
	EXTU(0xa5a5a5a5a5a5a595, 0, 16, 0x000000000000a595)
	DEP( 0xa5a5a5a5a5a5a595, 32767, 0, 16, 0xa5a5a5a5a5a57fff)
	EXT( 0xa5a5a5a5a5a5a594, 0, 17, 0xffffffffffffa594)
	EXTU(0xa5a5a5a5a5a5a594, 0, 17, 0x000000000001a594)
	DEP( 0xa5a5a5a5a5a5a594, 65535, 0, 17, 0xa5a5a5a5a5a4ffff)
	EXT( 0xa5a5a5a5a5a5a593, 0, 18, 0x000000000001a593)
	EXTU(0xa5a5a5a5a5a5a593, 0, 18, 0x000000000001a593)
	DEP( 0xa5a5a5a5a5a5a593, 131071, 0, 18, 0xa5a5a5a5a5a5ffff)
	EXT( 0xa5a5a5a5a5a5a592, 0, 19, 0xfffffffffffda592)
	EXTU(0xa5a5a5a5a5a5a592, 0, 19, 0x000000000005a592)
	DEP( 0xa5a5a5a5a5a5a592, 262143, 0, 19, 0xa5a5a5a5a5a3ffff)
	EXT( 0xa5a5a5a5a5a5a591, 0, 20, 0x000000000005a591)
	EXTU(0xa5a5a5a5a5a5a591, 0, 20, 0x000000000005a591)
	DEP( 0xa5a5a5a5a5a5a591, 524287, 0, 20, 0xa5a5a5a5a5a7ffff)
	EXT( 0xa5a5a5a5a5a5a590, 0, 21, 0x000000000005a590)
	EXTU(0xa5a5a5a5a5a5a590, 0, 21, 0x000000000005a590)
	DEP( 0xa5a5a5a5a5a5a590, 1048575, 0, 21, 0xa5a5a5a5a5afffff)
	EXT( 0xa5a5a5a5a5a5a58f, 0, 22, 0xffffffffffe5a58f)
	EXTU(0xa5a5a5a5a5a5a58f, 0, 22, 0x000000000025a58f)
	DEP( 0xa5a5a5a5a5a5a58f, 2097151, 0, 22, 0xa5a5a5a5a59fffff)
	EXT( 0xa5a5a5a5a5a5a58e, 0, 23, 0x000000000025a58e)
	EXTU(0xa5a5a5a5a5a5a58e, 0, 23, 0x000000000025a58e)
	DEP( 0xa5a5a5a5a5a5a58e, 4194303, 0, 23, 0xa5a5a5a5a5bfffff)
	EXT( 0xa5a5a5a5a5a5a58d, 0, 24, 0xffffffffffa5a58d)
	EXTU(0xa5a5a5a5a5a5a58d, 0, 24, 0x0000000000a5a58d)
	DEP( 0xa5a5a5a5a5a5a58d, 8388607, 0, 24, 0xa5a5a5a5a57fffff)
	EXT( 0xa5a5a5a5a5a5a58c, 0, 25, 0xffffffffffa5a58c)
	EXTU(0xa5a5a5a5a5a5a58c, 0, 25, 0x0000000001a5a58c)
	DEP( 0xa5a5a5a5a5a5a58c, 16777215, 0, 25, 0xa5a5a5a5a4ffffff)
	EXT( 0xa5a5a5a5a5a5a58b, 0, 26, 0x0000000001a5a58b)
	EXTU(0xa5a5a5a5a5a5a58b, 0, 26, 0x0000000001a5a58b)
	DEP( 0xa5a5a5a5a5a5a58b, 33554431, 0, 26, 0xa5a5a5a5a5ffffff)
	EXT( 0xa5a5a5a5a5a5a58a, 0, 27, 0xfffffffffda5a58a)
	EXTU(0xa5a5a5a5a5a5a58a, 0, 27, 0x0000000005a5a58a)
	DEP( 0xa5a5a5a5a5a5a58a, 67108863, 0, 27, 0xa5a5a5a5a3ffffff)
	EXT( 0xa5a5a5a5a5a5a589, 0, 28, 0x0000000005a5a589)
	EXTU(0xa5a5a5a5a5a5a589, 0, 28, 0x0000000005a5a589)
	DEP( 0xa5a5a5a5a5a5a589, 134217727, 0, 28, 0xa5a5a5a5a7ffffff)
	EXT( 0xa5a5a5a5a5a5a588, 0, 29, 0x0000000005a5a588)
	EXTU(0xa5a5a5a5a5a5a588, 0, 29, 0x0000000005a5a588)
	DEP( 0xa5a5a5a5a5a5a588, 268435455, 0, 29, 0xa5a5a5a5afffffff)
	EXT( 0xa5a5a5a5a5a5a587, 0, 30, 0xffffffffe5a5a587)
	EXTU(0xa5a5a5a5a5a5a587, 0, 30, 0x0000000025a5a587)
	DEP( 0xa5a5a5a5a5a5a587, 536870911, 0, 30, 0xa5a5a5a59fffffff)
	EXT( 0xa5a5a5a5a5a5a586, 0, 31, 0x0000000025a5a586)
	EXTU(0xa5a5a5a5a5a5a586, 0, 31, 0x0000000025a5a586)
	DEP( 0xa5a5a5a5a5a5a586, 1073741823, 0, 31, 0xa5a5a5a5bfffffff)
	EXT( 0xa5a5a5a5a5a5a585, 0, 32, 0xffffffffa5a5a585)
	EXTU(0xa5a5a5a5a5a5a585, 0, 32, 0x00000000a5a5a585)
	DEP( 0xa5a5a5a5a5a5a585, 2147483647, 0, 32, 0xa5a5a5a57fffffff)
	EXT( 0xa5a5a5a5a5a5a584, 0, 33, 0xffffffffa5a5a584)
	EXTU(0xa5a5a5a5a5a5a584, 0, 33, 0x00000001a5a5a584)
	DEP( 0xa5a5a5a5a5a5a584, 4294967295, 0, 33, 0xa5a5a5a4ffffffff)
	EXT( 0xa5a5a5a5a5a5a583, 0, 34, 0x00000001a5a5a583)
	EXTU(0xa5a5a5a5a5a5a583, 0, 34, 0x00000001a5a5a583)
	DEP( 0xa5a5a5a5a5a5a583, 8589934591, 0, 34, 0xa5a5a5a5ffffffff)
	EXT( 0xa5a5a5a5a5a5a582, 0, 35, 0xfffffffda5a5a582)
	EXTU(0xa5a5a5a5a5a5a582, 0, 35, 0x00000005a5a5a582)
	DEP( 0xa5a5a5a5a5a5a582, 17179869183, 0, 35, 0xa5a5a5a3ffffffff)
	EXT( 0xa5a5a5a5a5a5a581, 0, 36, 0x00000005a5a5a581)
	EXTU(0xa5a5a5a5a5a5a581, 0, 36, 0x00000005a5a5a581)
	DEP( 0xa5a5a5a5a5a5a581, 34359738367, 0, 36, 0xa5a5a5a7ffffffff)
	EXT( 0xa5a5a5a5a5a5a580, 0, 37, 0x00000005a5a5a580)
	EXTU(0xa5a5a5a5a5a5a580, 0, 37, 0x00000005a5a5a580)
	DEP( 0xa5a5a5a5a5a5a580, 68719476735, 0, 37, 0xa5a5a5afffffffff)
	EXT( 0xa5a5a5a5a5a5a57f, 0, 38, 0xffffffe5a5a5a57f)
	EXTU(0xa5a5a5a5a5a5a57f, 0, 38, 0x00000025a5a5a57f)
	DEP( 0xa5a5a5a5a5a5a57f, 137438953471, 0, 38, 0xa5a5a59fffffffff)
	EXT( 0xa5a5a5a5a5a5a57e, 0, 39, 0x00000025a5a5a57e)
	EXTU(0xa5a5a5a5a5a5a57e, 0, 39, 0x00000025a5a5a57e)
	DEP( 0xa5a5a5a5a5a5a57e, 274877906943, 0, 39, 0xa5a5a5bfffffffff)
	EXT( 0xa5a5a5a5a5a5a57d, 0, 40, 0xffffffa5a5a5a57d)
	EXTU(0xa5a5a5a5a5a5a57d, 0, 40, 0x000000a5a5a5a57d)
	DEP( 0xa5a5a5a5a5a5a57d, 549755813887, 0, 40, 0xa5a5a57fffffffff)
	EXT( 0xa5a5a5a5a5a5a57c, 0, 41, 0xffffffa5a5a5a57c)
	EXTU(0xa5a5a5a5a5a5a57c, 0, 41, 0x000001a5a5a5a57c)
	DEP( 0xa5a5a5a5a5a5a57c, 1099511627775, 0, 41, 0xa5a5a4ffffffffff)
	EXT( 0xa5a5a5a5a5a5a57b, 0, 42, 0x000001a5a5a5a57b)
	EXTU(0xa5a5a5a5a5a5a57b, 0, 42, 0x000001a5a5a5a57b)
	DEP( 0xa5a5a5a5a5a5a57b, 2199023255551, 0, 42, 0xa5a5a5ffffffffff)
	EXT( 0xa5a5a5a5a5a5a57a, 0, 43, 0xfffffda5a5a5a57a)
	EXTU(0xa5a5a5a5a5a5a57a, 0, 43, 0x000005a5a5a5a57a)
	DEP( 0xa5a5a5a5a5a5a57a, 4398046511103, 0, 43, 0xa5a5a3ffffffffff)
	EXT( 0xa5a5a5a5a5a5a579, 0, 44, 0x000005a5a5a5a579)
	EXTU(0xa5a5a5a5a5a5a579, 0, 44, 0x000005a5a5a5a579)
	DEP( 0xa5a5a5a5a5a5a579, 8796093022207, 0, 44, 0xa5a5a7ffffffffff)
	EXT( 0xa5a5a5a5a5a5a578, 0, 45, 0x000005a5a5a5a578)
	EXTU(0xa5a5a5a5a5a5a578, 0, 45, 0x000005a5a5a5a578)
	DEP( 0xa5a5a5a5a5a5a578, 17592186044415, 0, 45, 0xa5a5afffffffffff)
	EXT( 0xa5a5a5a5a5a5a577, 0, 46, 0xffffe5a5a5a5a577)
	EXTU(0xa5a5a5a5a5a5a577, 0, 46, 0x000025a5a5a5a577)
	DEP( 0xa5a5a5a5a5a5a577, 35184372088831, 0, 46, 0xa5a59fffffffffff)
	EXT( 0xa5a5a5a5a5a5a576, 0, 47, 0x000025a5a5a5a576)
	EXTU(0xa5a5a5a5a5a5a576, 0, 47, 0x000025a5a5a5a576)
	DEP( 0xa5a5a5a5a5a5a576, 70368744177663, 0, 47, 0xa5a5bfffffffffff)
	EXT( 0xa5a5a5a5a5a5a575, 0, 48, 0xffffa5a5a5a5a575)
	EXTU(0xa5a5a5a5a5a5a575, 0, 48, 0x0000a5a5a5a5a575)
	DEP( 0xa5a5a5a5a5a5a575, 140737488355327, 0, 48, 0xa5a57fffffffffff)
	EXT( 0xa5a5a5a5a5a5a574, 0, 49, 0xffffa5a5a5a5a574)
	EXTU(0xa5a5a5a5a5a5a574, 0, 49, 0x0001a5a5a5a5a574)
	DEP( 0xa5a5a5a5a5a5a574, 281474976710655, 0, 49, 0xa5a4ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a573, 0, 50, 0x0001a5a5a5a5a573)
	EXTU(0xa5a5a5a5a5a5a573, 0, 50, 0x0001a5a5a5a5a573)
	DEP( 0xa5a5a5a5a5a5a573, 562949953421311, 0, 50, 0xa5a5ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a572, 0, 51, 0xfffda5a5a5a5a572)
	EXTU(0xa5a5a5a5a5a5a572, 0, 51, 0x0005a5a5a5a5a572)
	DEP( 0xa5a5a5a5a5a5a572, 1125899906842623, 0, 51, 0xa5a3ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a571, 0, 52, 0x0005a5a5a5a5a571)
	EXTU(0xa5a5a5a5a5a5a571, 0, 52, 0x0005a5a5a5a5a571)
	DEP( 0xa5a5a5a5a5a5a571, 2251799813685247, 0, 52, 0xa5a7ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a570, 0, 53, 0x0005a5a5a5a5a570)
	EXTU(0xa5a5a5a5a5a5a570, 0, 53, 0x0005a5a5a5a5a570)
	DEP( 0xa5a5a5a5a5a5a570, 4503599627370495, 0, 53, 0xa5afffffffffffff)
	EXT( 0xa5a5a5a5a5a5a56f, 0, 54, 0xffe5a5a5a5a5a56f)
	EXTU(0xa5a5a5a5a5a5a56f, 0, 54, 0x0025a5a5a5a5a56f)
	DEP( 0xa5a5a5a5a5a5a56f, 9007199254740991, 0, 54, 0xa59fffffffffffff)
	EXT( 0xa5a5a5a5a5a5a56e, 0, 55, 0x0025a5a5a5a5a56e)
	EXTU(0xa5a5a5a5a5a5a56e, 0, 55, 0x0025a5a5a5a5a56e)
	DEP( 0xa5a5a5a5a5a5a56e, 18014398509481983, 0, 55, 0xa5bfffffffffffff)
	EXT( 0xa5a5a5a5a5a5a56d, 0, 56, 0xffa5a5a5a5a5a56d)
	EXTU(0xa5a5a5a5a5a5a56d, 0, 56, 0x00a5a5a5a5a5a56d)
	DEP( 0xa5a5a5a5a5a5a56d, 36028797018963967, 0, 56, 0xa57fffffffffffff)
	EXT( 0xa5a5a5a5a5a5a56c, 0, 57, 0xffa5a5a5a5a5a56c)
	EXTU(0xa5a5a5a5a5a5a56c, 0, 57, 0x01a5a5a5a5a5a56c)
	DEP( 0xa5a5a5a5a5a5a56c, 72057594037927935, 0, 57, 0xa4ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a56b, 0, 58, 0x01a5a5a5a5a5a56b)
	EXTU(0xa5a5a5a5a5a5a56b, 0, 58, 0x01a5a5a5a5a5a56b)
	DEP( 0xa5a5a5a5a5a5a56b, 144115188075855871, 0, 58, 0xa5ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a56a, 0, 59, 0xfda5a5a5a5a5a56a)
	EXTU(0xa5a5a5a5a5a5a56a, 0, 59, 0x05a5a5a5a5a5a56a)
	DEP( 0xa5a5a5a5a5a5a56a, 288230376151711743, 0, 59, 0xa3ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a569, 0, 60, 0x05a5a5a5a5a5a569)
	EXTU(0xa5a5a5a5a5a5a569, 0, 60, 0x05a5a5a5a5a5a569)
	DEP( 0xa5a5a5a5a5a5a569, 576460752303423487, 0, 60, 0xa7ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a568, 0, 61, 0x05a5a5a5a5a5a568)
	EXTU(0xa5a5a5a5a5a5a568, 0, 61, 0x05a5a5a5a5a5a568)
	DEP( 0xa5a5a5a5a5a5a568, 1152921504606846975, 0, 61, 0xafffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a567, 0, 62, 0xe5a5a5a5a5a5a567)
	EXTU(0xa5a5a5a5a5a5a567, 0, 62, 0x25a5a5a5a5a5a567)
	DEP( 0xa5a5a5a5a5a5a567, 2305843009213693951, 0, 62, 0x9fffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a566, 0, 63, 0x25a5a5a5a5a5a566)
	EXTU(0xa5a5a5a5a5a5a566, 0, 63, 0x25a5a5a5a5a5a566)
	DEP( 0xa5a5a5a5a5a5a566, 4611686018427387903, 0, 63, 0xbfffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a565, 1, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a565, 1, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a565, 0, 1, 1, 0xa5a5a5a5a5a5a565)
	EXT( 0xa5a5a5a5a5a5a564, 1, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a564, 1, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a564, 1, 1, 2, 0xa5a5a5a5a5a5a562)
	EXT( 0xa5a5a5a5a5a5a563, 1, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a563, 1, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a563, 3, 1, 3, 0xa5a5a5a5a5a5a567)
	EXT( 0xa5a5a5a5a5a5a562, 1, 4, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a562, 1, 4, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a562, 7, 1, 4, 0xa5a5a5a5a5a5a56e)
	EXT( 0xa5a5a5a5a5a5a561, 1, 5, 0xfffffffffffffff0)
	EXTU(0xa5a5a5a5a5a5a561, 1, 5, 0x0000000000000010)
	DEP( 0xa5a5a5a5a5a5a561, 15, 1, 5, 0xa5a5a5a5a5a5a55f)
	EXT( 0xa5a5a5a5a5a5a560, 1, 6, 0xfffffffffffffff0)
	EXTU(0xa5a5a5a5a5a5a560, 1, 6, 0x0000000000000030)
	DEP( 0xa5a5a5a5a5a5a560, 31, 1, 6, 0xa5a5a5a5a5a5a53e)
	EXT( 0xa5a5a5a5a5a5a55f, 1, 7, 0x000000000000002f)
	EXTU(0xa5a5a5a5a5a5a55f, 1, 7, 0x000000000000002f)
	DEP( 0xa5a5a5a5a5a5a55f, 63, 1, 7, 0xa5a5a5a5a5a5a57f)
	EXT( 0xa5a5a5a5a5a5a55e, 1, 8, 0xffffffffffffffaf)
	EXTU(0xa5a5a5a5a5a5a55e, 1, 8, 0x00000000000000af)
	DEP( 0xa5a5a5a5a5a5a55e, 127, 1, 8, 0xa5a5a5a5a5a5a4fe)
	EXT( 0xa5a5a5a5a5a5a55d, 1, 9, 0x00000000000000ae)
	EXTU(0xa5a5a5a5a5a5a55d, 1, 9, 0x00000000000000ae)
	DEP( 0xa5a5a5a5a5a5a55d, 255, 1, 9, 0xa5a5a5a5a5a5a5ff)
	EXT( 0xa5a5a5a5a5a5a55c, 1, 10, 0xfffffffffffffeae)
	EXTU(0xa5a5a5a5a5a5a55c, 1, 10, 0x00000000000002ae)
	DEP( 0xa5a5a5a5a5a5a55c, 511, 1, 10, 0xa5a5a5a5a5a5a3fe)
	EXT( 0xa5a5a5a5a5a5a55b, 1, 11, 0x00000000000002ad)
	EXTU(0xa5a5a5a5a5a5a55b, 1, 11, 0x00000000000002ad)
	DEP( 0xa5a5a5a5a5a5a55b, 1023, 1, 11, 0xa5a5a5a5a5a5a7ff)
	EXT( 0xa5a5a5a5a5a5a55a, 1, 12, 0x00000000000002ad)
	EXTU(0xa5a5a5a5a5a5a55a, 1, 12, 0x00000000000002ad)
	DEP( 0xa5a5a5a5a5a5a55a, 2047, 1, 12, 0xa5a5a5a5a5a5affe)
	EXT( 0xa5a5a5a5a5a5a559, 1, 13, 0xfffffffffffff2ac)
	EXTU(0xa5a5a5a5a5a5a559, 1, 13, 0x00000000000012ac)
	DEP( 0xa5a5a5a5a5a5a559, 4095, 1, 13, 0xa5a5a5a5a5a59fff)
	EXT( 0xa5a5a5a5a5a5a558, 1, 14, 0x00000000000012ac)
	EXTU(0xa5a5a5a5a5a5a558, 1, 14, 0x00000000000012ac)
	DEP( 0xa5a5a5a5a5a5a558, 8191, 1, 14, 0xa5a5a5a5a5a5bffe)
	EXT( 0xa5a5a5a5a5a5a557, 1, 15, 0xffffffffffffd2ab)
	EXTU(0xa5a5a5a5a5a5a557, 1, 15, 0x00000000000052ab)
	DEP( 0xa5a5a5a5a5a5a557, 16383, 1, 15, 0xa5a5a5a5a5a57fff)
	EXT( 0xa5a5a5a5a5a5a556, 1, 16, 0xffffffffffffd2ab)
	EXTU(0xa5a5a5a5a5a5a556, 1, 16, 0x000000000000d2ab)
	DEP( 0xa5a5a5a5a5a5a556, 32767, 1, 16, 0xa5a5a5a5a5a4fffe)
	EXT( 0xa5a5a5a5a5a5a555, 1, 17, 0x000000000000d2aa)
	EXTU(0xa5a5a5a5a5a5a555, 1, 17, 0x000000000000d2aa)
	DEP( 0xa5a5a5a5a5a5a555, 65535, 1, 17, 0xa5a5a5a5a5a5ffff)
	EXT( 0xa5a5a5a5a5a5a554, 1, 18, 0xfffffffffffed2aa)
	EXTU(0xa5a5a5a5a5a5a554, 1, 18, 0x000000000002d2aa)
	DEP( 0xa5a5a5a5a5a5a554, 131071, 1, 18, 0xa5a5a5a5a5a3fffe)
	EXT( 0xa5a5a5a5a5a5a553, 1, 19, 0x000000000002d2a9)
	EXTU(0xa5a5a5a5a5a5a553, 1, 19, 0x000000000002d2a9)
	DEP( 0xa5a5a5a5a5a5a553, 262143, 1, 19, 0xa5a5a5a5a5a7ffff)
	EXT( 0xa5a5a5a5a5a5a552, 1, 20, 0x000000000002d2a9)
	EXTU(0xa5a5a5a5a5a5a552, 1, 20, 0x000000000002d2a9)
	DEP( 0xa5a5a5a5a5a5a552, 524287, 1, 20, 0xa5a5a5a5a5affffe)
	EXT( 0xa5a5a5a5a5a5a551, 1, 21, 0xfffffffffff2d2a8)
	EXTU(0xa5a5a5a5a5a5a551, 1, 21, 0x000000000012d2a8)
	DEP( 0xa5a5a5a5a5a5a551, 1048575, 1, 21, 0xa5a5a5a5a59fffff)
	EXT( 0xa5a5a5a5a5a5a550, 1, 22, 0x000000000012d2a8)
	EXTU(0xa5a5a5a5a5a5a550, 1, 22, 0x000000000012d2a8)
	DEP( 0xa5a5a5a5a5a5a550, 2097151, 1, 22, 0xa5a5a5a5a5bffffe)
	EXT( 0xa5a5a5a5a5a5a54f, 1, 23, 0xffffffffffd2d2a7)
	EXTU(0xa5a5a5a5a5a5a54f, 1, 23, 0x000000000052d2a7)
	DEP( 0xa5a5a5a5a5a5a54f, 4194303, 1, 23, 0xa5a5a5a5a57fffff)
	EXT( 0xa5a5a5a5a5a5a54e, 1, 24, 0xffffffffffd2d2a7)
	EXTU(0xa5a5a5a5a5a5a54e, 1, 24, 0x0000000000d2d2a7)
	DEP( 0xa5a5a5a5a5a5a54e, 8388607, 1, 24, 0xa5a5a5a5a4fffffe)
	EXT( 0xa5a5a5a5a5a5a54d, 1, 25, 0x0000000000d2d2a6)
	EXTU(0xa5a5a5a5a5a5a54d, 1, 25, 0x0000000000d2d2a6)
	DEP( 0xa5a5a5a5a5a5a54d, 16777215, 1, 25, 0xa5a5a5a5a5ffffff)
	EXT( 0xa5a5a5a5a5a5a54c, 1, 26, 0xfffffffffed2d2a6)
	EXTU(0xa5a5a5a5a5a5a54c, 1, 26, 0x0000000002d2d2a6)
	DEP( 0xa5a5a5a5a5a5a54c, 33554431, 1, 26, 0xa5a5a5a5a3fffffe)
	EXT( 0xa5a5a5a5a5a5a54b, 1, 27, 0x0000000002d2d2a5)
	EXTU(0xa5a5a5a5a5a5a54b, 1, 27, 0x0000000002d2d2a5)
	DEP( 0xa5a5a5a5a5a5a54b, 67108863, 1, 27, 0xa5a5a5a5a7ffffff)
	EXT( 0xa5a5a5a5a5a5a54a, 1, 28, 0x0000000002d2d2a5)
	EXTU(0xa5a5a5a5a5a5a54a, 1, 28, 0x0000000002d2d2a5)
	DEP( 0xa5a5a5a5a5a5a54a, 134217727, 1, 28, 0xa5a5a5a5affffffe)
	EXT( 0xa5a5a5a5a5a5a549, 1, 29, 0xfffffffff2d2d2a4)
	EXTU(0xa5a5a5a5a5a5a549, 1, 29, 0x0000000012d2d2a4)
	DEP( 0xa5a5a5a5a5a5a549, 268435455, 1, 29, 0xa5a5a5a59fffffff)
	EXT( 0xa5a5a5a5a5a5a548, 1, 30, 0x0000000012d2d2a4)
	EXTU(0xa5a5a5a5a5a5a548, 1, 30, 0x0000000012d2d2a4)
	DEP( 0xa5a5a5a5a5a5a548, 536870911, 1, 30, 0xa5a5a5a5bffffffe)
	EXT( 0xa5a5a5a5a5a5a547, 1, 31, 0xffffffffd2d2d2a3)
	EXTU(0xa5a5a5a5a5a5a547, 1, 31, 0x0000000052d2d2a3)
	DEP( 0xa5a5a5a5a5a5a547, 1073741823, 1, 31, 0xa5a5a5a57fffffff)
	EXT( 0xa5a5a5a5a5a5a546, 1, 32, 0xffffffffd2d2d2a3)
	EXTU(0xa5a5a5a5a5a5a546, 1, 32, 0x00000000d2d2d2a3)
	DEP( 0xa5a5a5a5a5a5a546, 2147483647, 1, 32, 0xa5a5a5a4fffffffe)
	EXT( 0xa5a5a5a5a5a5a545, 1, 33, 0x00000000d2d2d2a2)
	EXTU(0xa5a5a5a5a5a5a545, 1, 33, 0x00000000d2d2d2a2)
	DEP( 0xa5a5a5a5a5a5a545, 4294967295, 1, 33, 0xa5a5a5a5ffffffff)
	EXT( 0xa5a5a5a5a5a5a544, 1, 34, 0xfffffffed2d2d2a2)
	EXTU(0xa5a5a5a5a5a5a544, 1, 34, 0x00000002d2d2d2a2)
	DEP( 0xa5a5a5a5a5a5a544, 8589934591, 1, 34, 0xa5a5a5a3fffffffe)
	EXT( 0xa5a5a5a5a5a5a543, 1, 35, 0x00000002d2d2d2a1)
	EXTU(0xa5a5a5a5a5a5a543, 1, 35, 0x00000002d2d2d2a1)
	DEP( 0xa5a5a5a5a5a5a543, 17179869183, 1, 35, 0xa5a5a5a7ffffffff)
	EXT( 0xa5a5a5a5a5a5a542, 1, 36, 0x00000002d2d2d2a1)
	EXTU(0xa5a5a5a5a5a5a542, 1, 36, 0x00000002d2d2d2a1)
	DEP( 0xa5a5a5a5a5a5a542, 34359738367, 1, 36, 0xa5a5a5affffffffe)
	EXT( 0xa5a5a5a5a5a5a541, 1, 37, 0xfffffff2d2d2d2a0)
	EXTU(0xa5a5a5a5a5a5a541, 1, 37, 0x00000012d2d2d2a0)
	DEP( 0xa5a5a5a5a5a5a541, 68719476735, 1, 37, 0xa5a5a59fffffffff)
	EXT( 0xa5a5a5a5a5a5a540, 1, 38, 0x00000012d2d2d2a0)
	EXTU(0xa5a5a5a5a5a5a540, 1, 38, 0x00000012d2d2d2a0)
	DEP( 0xa5a5a5a5a5a5a540, 137438953471, 1, 38, 0xa5a5a5bffffffffe)
	EXT( 0xa5a5a5a5a5a5a53f, 1, 39, 0xffffffd2d2d2d29f)
	EXTU(0xa5a5a5a5a5a5a53f, 1, 39, 0x00000052d2d2d29f)
	DEP( 0xa5a5a5a5a5a5a53f, 274877906943, 1, 39, 0xa5a5a57fffffffff)
	EXT( 0xa5a5a5a5a5a5a53e, 1, 40, 0xffffffd2d2d2d29f)
	EXTU(0xa5a5a5a5a5a5a53e, 1, 40, 0x000000d2d2d2d29f)
	DEP( 0xa5a5a5a5a5a5a53e, 549755813887, 1, 40, 0xa5a5a4fffffffffe)
	EXT( 0xa5a5a5a5a5a5a53d, 1, 41, 0x000000d2d2d2d29e)
	EXTU(0xa5a5a5a5a5a5a53d, 1, 41, 0x000000d2d2d2d29e)
	DEP( 0xa5a5a5a5a5a5a53d, 1099511627775, 1, 41, 0xa5a5a5ffffffffff)
	EXT( 0xa5a5a5a5a5a5a53c, 1, 42, 0xfffffed2d2d2d29e)
	EXTU(0xa5a5a5a5a5a5a53c, 1, 42, 0x000002d2d2d2d29e)
	DEP( 0xa5a5a5a5a5a5a53c, 2199023255551, 1, 42, 0xa5a5a3fffffffffe)
	EXT( 0xa5a5a5a5a5a5a53b, 1, 43, 0x000002d2d2d2d29d)
	EXTU(0xa5a5a5a5a5a5a53b, 1, 43, 0x000002d2d2d2d29d)
	DEP( 0xa5a5a5a5a5a5a53b, 4398046511103, 1, 43, 0xa5a5a7ffffffffff)
	EXT( 0xa5a5a5a5a5a5a53a, 1, 44, 0x000002d2d2d2d29d)
	EXTU(0xa5a5a5a5a5a5a53a, 1, 44, 0x000002d2d2d2d29d)
	DEP( 0xa5a5a5a5a5a5a53a, 8796093022207, 1, 44, 0xa5a5affffffffffe)
	EXT( 0xa5a5a5a5a5a5a539, 1, 45, 0xfffff2d2d2d2d29c)
	EXTU(0xa5a5a5a5a5a5a539, 1, 45, 0x000012d2d2d2d29c)
	DEP( 0xa5a5a5a5a5a5a539, 17592186044415, 1, 45, 0xa5a59fffffffffff)
	EXT( 0xa5a5a5a5a5a5a538, 1, 46, 0x000012d2d2d2d29c)
	EXTU(0xa5a5a5a5a5a5a538, 1, 46, 0x000012d2d2d2d29c)
	DEP( 0xa5a5a5a5a5a5a538, 35184372088831, 1, 46, 0xa5a5bffffffffffe)
	EXT( 0xa5a5a5a5a5a5a537, 1, 47, 0xffffd2d2d2d2d29b)
	EXTU(0xa5a5a5a5a5a5a537, 1, 47, 0x000052d2d2d2d29b)
	DEP( 0xa5a5a5a5a5a5a537, 70368744177663, 1, 47, 0xa5a57fffffffffff)
	EXT( 0xa5a5a5a5a5a5a536, 1, 48, 0xffffd2d2d2d2d29b)
	EXTU(0xa5a5a5a5a5a5a536, 1, 48, 0x0000d2d2d2d2d29b)
	DEP( 0xa5a5a5a5a5a5a536, 140737488355327, 1, 48, 0xa5a4fffffffffffe)
	EXT( 0xa5a5a5a5a5a5a535, 1, 49, 0x0000d2d2d2d2d29a)
	EXTU(0xa5a5a5a5a5a5a535, 1, 49, 0x0000d2d2d2d2d29a)
	DEP( 0xa5a5a5a5a5a5a535, 281474976710655, 1, 49, 0xa5a5ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a534, 1, 50, 0xfffed2d2d2d2d29a)
	EXTU(0xa5a5a5a5a5a5a534, 1, 50, 0x0002d2d2d2d2d29a)
	DEP( 0xa5a5a5a5a5a5a534, 562949953421311, 1, 50, 0xa5a3fffffffffffe)
	EXT( 0xa5a5a5a5a5a5a533, 1, 51, 0x0002d2d2d2d2d299)
	EXTU(0xa5a5a5a5a5a5a533, 1, 51, 0x0002d2d2d2d2d299)
	DEP( 0xa5a5a5a5a5a5a533, 1125899906842623, 1, 51, 0xa5a7ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a532, 1, 52, 0x0002d2d2d2d2d299)
	EXTU(0xa5a5a5a5a5a5a532, 1, 52, 0x0002d2d2d2d2d299)
	DEP( 0xa5a5a5a5a5a5a532, 2251799813685247, 1, 52, 0xa5affffffffffffe)
	EXT( 0xa5a5a5a5a5a5a531, 1, 53, 0xfff2d2d2d2d2d298)
	EXTU(0xa5a5a5a5a5a5a531, 1, 53, 0x0012d2d2d2d2d298)
	DEP( 0xa5a5a5a5a5a5a531, 4503599627370495, 1, 53, 0xa59fffffffffffff)
	EXT( 0xa5a5a5a5a5a5a530, 1, 54, 0x0012d2d2d2d2d298)
	EXTU(0xa5a5a5a5a5a5a530, 1, 54, 0x0012d2d2d2d2d298)
	DEP( 0xa5a5a5a5a5a5a530, 9007199254740991, 1, 54, 0xa5bffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a52f, 1, 55, 0xffd2d2d2d2d2d297)
	EXTU(0xa5a5a5a5a5a5a52f, 1, 55, 0x0052d2d2d2d2d297)
	DEP( 0xa5a5a5a5a5a5a52f, 18014398509481983, 1, 55, 0xa57fffffffffffff)
	EXT( 0xa5a5a5a5a5a5a52e, 1, 56, 0xffd2d2d2d2d2d297)
	EXTU(0xa5a5a5a5a5a5a52e, 1, 56, 0x00d2d2d2d2d2d297)
	DEP( 0xa5a5a5a5a5a5a52e, 36028797018963967, 1, 56, 0xa4fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a52d, 1, 57, 0x00d2d2d2d2d2d296)
	EXTU(0xa5a5a5a5a5a5a52d, 1, 57, 0x00d2d2d2d2d2d296)
	DEP( 0xa5a5a5a5a5a5a52d, 72057594037927935, 1, 57, 0xa5ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a52c, 1, 58, 0xfed2d2d2d2d2d296)
	EXTU(0xa5a5a5a5a5a5a52c, 1, 58, 0x02d2d2d2d2d2d296)
	DEP( 0xa5a5a5a5a5a5a52c, 144115188075855871, 1, 58, 0xa3fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a52b, 1, 59, 0x02d2d2d2d2d2d295)
	EXTU(0xa5a5a5a5a5a5a52b, 1, 59, 0x02d2d2d2d2d2d295)
	DEP( 0xa5a5a5a5a5a5a52b, 288230376151711743, 1, 59, 0xa7ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a52a, 1, 60, 0x02d2d2d2d2d2d295)
	EXTU(0xa5a5a5a5a5a5a52a, 1, 60, 0x02d2d2d2d2d2d295)
	DEP( 0xa5a5a5a5a5a5a52a, 576460752303423487, 1, 60, 0xaffffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a529, 1, 61, 0xf2d2d2d2d2d2d294)
	EXTU(0xa5a5a5a5a5a5a529, 1, 61, 0x12d2d2d2d2d2d294)
	DEP( 0xa5a5a5a5a5a5a529, 1152921504606846975, 1, 61, 0x9fffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a528, 1, 62, 0x12d2d2d2d2d2d294)
	EXTU(0xa5a5a5a5a5a5a528, 1, 62, 0x12d2d2d2d2d2d294)
	DEP( 0xa5a5a5a5a5a5a528, 2305843009213693951, 1, 62, 0xbffffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a527, 2, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a527, 2, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a527, 0, 2, 1, 0xa5a5a5a5a5a5a523)
	EXT( 0xa5a5a5a5a5a5a526, 2, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a526, 2, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a526, 1, 2, 2, 0xa5a5a5a5a5a5a526)
	EXT( 0xa5a5a5a5a5a5a525, 2, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a525, 2, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a525, 3, 2, 3, 0xa5a5a5a5a5a5a52d)
	EXT( 0xa5a5a5a5a5a5a524, 2, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a5a524, 2, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a524, 7, 2, 4, 0xa5a5a5a5a5a5a51c)
	EXT( 0xa5a5a5a5a5a5a523, 2, 5, 0x0000000000000008)
	EXTU(0xa5a5a5a5a5a5a523, 2, 5, 0x0000000000000008)
	DEP( 0xa5a5a5a5a5a5a523, 15, 2, 5, 0xa5a5a5a5a5a5a53f)
	EXT( 0xa5a5a5a5a5a5a522, 2, 6, 0x0000000000000008)
	EXTU(0xa5a5a5a5a5a5a522, 2, 6, 0x0000000000000008)
	DEP( 0xa5a5a5a5a5a5a522, 31, 2, 6, 0xa5a5a5a5a5a5a57e)
	EXT( 0xa5a5a5a5a5a5a521, 2, 7, 0xffffffffffffffc8)
	EXTU(0xa5a5a5a5a5a5a521, 2, 7, 0x0000000000000048)
	DEP( 0xa5a5a5a5a5a5a521, 63, 2, 7, 0xa5a5a5a5a5a5a4fd)
	EXT( 0xa5a5a5a5a5a5a520, 2, 8, 0x0000000000000048)
	EXTU(0xa5a5a5a5a5a5a520, 2, 8, 0x0000000000000048)
	DEP( 0xa5a5a5a5a5a5a520, 127, 2, 8, 0xa5a5a5a5a5a5a5fc)
	EXT( 0xa5a5a5a5a5a5a51f, 2, 9, 0xffffffffffffff47)
	EXTU(0xa5a5a5a5a5a5a51f, 2, 9, 0x0000000000000147)
	DEP( 0xa5a5a5a5a5a5a51f, 255, 2, 9, 0xa5a5a5a5a5a5a3ff)
	EXT( 0xa5a5a5a5a5a5a51e, 2, 10, 0x0000000000000147)
	EXTU(0xa5a5a5a5a5a5a51e, 2, 10, 0x0000000000000147)
	DEP( 0xa5a5a5a5a5a5a51e, 511, 2, 10, 0xa5a5a5a5a5a5a7fe)
	EXT( 0xa5a5a5a5a5a5a51d, 2, 11, 0x0000000000000147)
	EXTU(0xa5a5a5a5a5a5a51d, 2, 11, 0x0000000000000147)
	DEP( 0xa5a5a5a5a5a5a51d, 1023, 2, 11, 0xa5a5a5a5a5a5affd)
	EXT( 0xa5a5a5a5a5a5a51c, 2, 12, 0xfffffffffffff947)
	EXTU(0xa5a5a5a5a5a5a51c, 2, 12, 0x0000000000000947)
	DEP( 0xa5a5a5a5a5a5a51c, 2047, 2, 12, 0xa5a5a5a5a5a59ffc)
	EXT( 0xa5a5a5a5a5a5a51b, 2, 13, 0x0000000000000946)
	EXTU(0xa5a5a5a5a5a5a51b, 2, 13, 0x0000000000000946)
	DEP( 0xa5a5a5a5a5a5a51b, 4095, 2, 13, 0xa5a5a5a5a5a5bfff)
	EXT( 0xa5a5a5a5a5a5a51a, 2, 14, 0xffffffffffffe946)
	EXTU(0xa5a5a5a5a5a5a51a, 2, 14, 0x0000000000002946)
	DEP( 0xa5a5a5a5a5a5a51a, 8191, 2, 14, 0xa5a5a5a5a5a57ffe)
	EXT( 0xa5a5a5a5a5a5a519, 2, 15, 0xffffffffffffe946)
	EXTU(0xa5a5a5a5a5a5a519, 2, 15, 0x0000000000006946)
	DEP( 0xa5a5a5a5a5a5a519, 16383, 2, 15, 0xa5a5a5a5a5a4fffd)
	EXT( 0xa5a5a5a5a5a5a518, 2, 16, 0x0000000000006946)
	EXTU(0xa5a5a5a5a5a5a518, 2, 16, 0x0000000000006946)
	DEP( 0xa5a5a5a5a5a5a518, 32767, 2, 16, 0xa5a5a5a5a5a5fffc)
	EXT( 0xa5a5a5a5a5a5a517, 2, 17, 0xffffffffffff6945)
	EXTU(0xa5a5a5a5a5a5a517, 2, 17, 0x0000000000016945)
	DEP( 0xa5a5a5a5a5a5a517, 65535, 2, 17, 0xa5a5a5a5a5a3ffff)
	EXT( 0xa5a5a5a5a5a5a516, 2, 18, 0x0000000000016945)
	EXTU(0xa5a5a5a5a5a5a516, 2, 18, 0x0000000000016945)
	DEP( 0xa5a5a5a5a5a5a516, 131071, 2, 18, 0xa5a5a5a5a5a7fffe)
	EXT( 0xa5a5a5a5a5a5a515, 2, 19, 0x0000000000016945)
	EXTU(0xa5a5a5a5a5a5a515, 2, 19, 0x0000000000016945)
	DEP( 0xa5a5a5a5a5a5a515, 262143, 2, 19, 0xa5a5a5a5a5affffd)
	EXT( 0xa5a5a5a5a5a5a514, 2, 20, 0xfffffffffff96945)
	EXTU(0xa5a5a5a5a5a5a514, 2, 20, 0x0000000000096945)
	DEP( 0xa5a5a5a5a5a5a514, 524287, 2, 20, 0xa5a5a5a5a59ffffc)
	EXT( 0xa5a5a5a5a5a5a513, 2, 21, 0x0000000000096944)
	EXTU(0xa5a5a5a5a5a5a513, 2, 21, 0x0000000000096944)
	DEP( 0xa5a5a5a5a5a5a513, 1048575, 2, 21, 0xa5a5a5a5a5bfffff)
	EXT( 0xa5a5a5a5a5a5a512, 2, 22, 0xffffffffffe96944)
	EXTU(0xa5a5a5a5a5a5a512, 2, 22, 0x0000000000296944)
	DEP( 0xa5a5a5a5a5a5a512, 2097151, 2, 22, 0xa5a5a5a5a57ffffe)
	EXT( 0xa5a5a5a5a5a5a511, 2, 23, 0xffffffffffe96944)
	EXTU(0xa5a5a5a5a5a5a511, 2, 23, 0x0000000000696944)
	DEP( 0xa5a5a5a5a5a5a511, 4194303, 2, 23, 0xa5a5a5a5a4fffffd)
	EXT( 0xa5a5a5a5a5a5a510, 2, 24, 0x0000000000696944)
	EXTU(0xa5a5a5a5a5a5a510, 2, 24, 0x0000000000696944)
	DEP( 0xa5a5a5a5a5a5a510, 8388607, 2, 24, 0xa5a5a5a5a5fffffc)
	EXT( 0xa5a5a5a5a5a5a50f, 2, 25, 0xffffffffff696943)
	EXTU(0xa5a5a5a5a5a5a50f, 2, 25, 0x0000000001696943)
	DEP( 0xa5a5a5a5a5a5a50f, 16777215, 2, 25, 0xa5a5a5a5a3ffffff)
	EXT( 0xa5a5a5a5a5a5a50e, 2, 26, 0x0000000001696943)
	EXTU(0xa5a5a5a5a5a5a50e, 2, 26, 0x0000000001696943)
	DEP( 0xa5a5a5a5a5a5a50e, 33554431, 2, 26, 0xa5a5a5a5a7fffffe)
	EXT( 0xa5a5a5a5a5a5a50d, 2, 27, 0x0000000001696943)
	EXTU(0xa5a5a5a5a5a5a50d, 2, 27, 0x0000000001696943)
	DEP( 0xa5a5a5a5a5a5a50d, 67108863, 2, 27, 0xa5a5a5a5affffffd)
	EXT( 0xa5a5a5a5a5a5a50c, 2, 28, 0xfffffffff9696943)
	EXTU(0xa5a5a5a5a5a5a50c, 2, 28, 0x0000000009696943)
	DEP( 0xa5a5a5a5a5a5a50c, 134217727, 2, 28, 0xa5a5a5a59ffffffc)
	EXT( 0xa5a5a5a5a5a5a50b, 2, 29, 0x0000000009696942)
	EXTU(0xa5a5a5a5a5a5a50b, 2, 29, 0x0000000009696942)
	DEP( 0xa5a5a5a5a5a5a50b, 268435455, 2, 29, 0xa5a5a5a5bfffffff)
	EXT( 0xa5a5a5a5a5a5a50a, 2, 30, 0xffffffffe9696942)
	EXTU(0xa5a5a5a5a5a5a50a, 2, 30, 0x0000000029696942)
	DEP( 0xa5a5a5a5a5a5a50a, 536870911, 2, 30, 0xa5a5a5a57ffffffe)
	EXT( 0xa5a5a5a5a5a5a509, 2, 31, 0xffffffffe9696942)
	EXTU(0xa5a5a5a5a5a5a509, 2, 31, 0x0000000069696942)
	DEP( 0xa5a5a5a5a5a5a509, 1073741823, 2, 31, 0xa5a5a5a4fffffffd)
	EXT( 0xa5a5a5a5a5a5a508, 2, 32, 0x0000000069696942)
	EXTU(0xa5a5a5a5a5a5a508, 2, 32, 0x0000000069696942)
	DEP( 0xa5a5a5a5a5a5a508, 2147483647, 2, 32, 0xa5a5a5a5fffffffc)
	EXT( 0xa5a5a5a5a5a5a507, 2, 33, 0xffffffff69696941)
	EXTU(0xa5a5a5a5a5a5a507, 2, 33, 0x0000000169696941)
	DEP( 0xa5a5a5a5a5a5a507, 4294967295, 2, 33, 0xa5a5a5a3ffffffff)
	EXT( 0xa5a5a5a5a5a5a506, 2, 34, 0x0000000169696941)
	EXTU(0xa5a5a5a5a5a5a506, 2, 34, 0x0000000169696941)
	DEP( 0xa5a5a5a5a5a5a506, 8589934591, 2, 34, 0xa5a5a5a7fffffffe)
	EXT( 0xa5a5a5a5a5a5a505, 2, 35, 0x0000000169696941)
	EXTU(0xa5a5a5a5a5a5a505, 2, 35, 0x0000000169696941)
	DEP( 0xa5a5a5a5a5a5a505, 17179869183, 2, 35, 0xa5a5a5affffffffd)
	EXT( 0xa5a5a5a5a5a5a504, 2, 36, 0xfffffff969696941)
	EXTU(0xa5a5a5a5a5a5a504, 2, 36, 0x0000000969696941)
	DEP( 0xa5a5a5a5a5a5a504, 34359738367, 2, 36, 0xa5a5a59ffffffffc)
	EXT( 0xa5a5a5a5a5a5a503, 2, 37, 0x0000000969696940)
	EXTU(0xa5a5a5a5a5a5a503, 2, 37, 0x0000000969696940)
	DEP( 0xa5a5a5a5a5a5a503, 68719476735, 2, 37, 0xa5a5a5bfffffffff)
	EXT( 0xa5a5a5a5a5a5a502, 2, 38, 0xffffffe969696940)
	EXTU(0xa5a5a5a5a5a5a502, 2, 38, 0x0000002969696940)
	DEP( 0xa5a5a5a5a5a5a502, 137438953471, 2, 38, 0xa5a5a57ffffffffe)
	EXT( 0xa5a5a5a5a5a5a501, 2, 39, 0xffffffe969696940)
	EXTU(0xa5a5a5a5a5a5a501, 2, 39, 0x0000006969696940)
	DEP( 0xa5a5a5a5a5a5a501, 274877906943, 2, 39, 0xa5a5a4fffffffffd)
	EXT( 0xa5a5a5a5a5a5a500, 2, 40, 0x0000006969696940)
	EXTU(0xa5a5a5a5a5a5a500, 2, 40, 0x0000006969696940)
	DEP( 0xa5a5a5a5a5a5a500, 549755813887, 2, 40, 0xa5a5a5fffffffffc)
	EXT( 0xa5a5a5a5a5a5a4ff, 2, 41, 0xffffff696969693f)
	EXTU(0xa5a5a5a5a5a5a4ff, 2, 41, 0x000001696969693f)
	DEP( 0xa5a5a5a5a5a5a4ff, 1099511627775, 2, 41, 0xa5a5a3ffffffffff)
	EXT( 0xa5a5a5a5a5a5a4fe, 2, 42, 0x000001696969693f)
	EXTU(0xa5a5a5a5a5a5a4fe, 2, 42, 0x000001696969693f)
	DEP( 0xa5a5a5a5a5a5a4fe, 2199023255551, 2, 42, 0xa5a5a7fffffffffe)
	EXT( 0xa5a5a5a5a5a5a4fd, 2, 43, 0x000001696969693f)
	EXTU(0xa5a5a5a5a5a5a4fd, 2, 43, 0x000001696969693f)
	DEP( 0xa5a5a5a5a5a5a4fd, 4398046511103, 2, 43, 0xa5a5affffffffffd)
	EXT( 0xa5a5a5a5a5a5a4fc, 2, 44, 0xfffff9696969693f)
	EXTU(0xa5a5a5a5a5a5a4fc, 2, 44, 0x000009696969693f)
	DEP( 0xa5a5a5a5a5a5a4fc, 8796093022207, 2, 44, 0xa5a59ffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4fb, 2, 45, 0x000009696969693e)
	EXTU(0xa5a5a5a5a5a5a4fb, 2, 45, 0x000009696969693e)
	DEP( 0xa5a5a5a5a5a5a4fb, 17592186044415, 2, 45, 0xa5a5bfffffffffff)
	EXT( 0xa5a5a5a5a5a5a4fa, 2, 46, 0xffffe9696969693e)
	EXTU(0xa5a5a5a5a5a5a4fa, 2, 46, 0x000029696969693e)
	DEP( 0xa5a5a5a5a5a5a4fa, 35184372088831, 2, 46, 0xa5a57ffffffffffe)
	EXT( 0xa5a5a5a5a5a5a4f9, 2, 47, 0xffffe9696969693e)
	EXTU(0xa5a5a5a5a5a5a4f9, 2, 47, 0x000069696969693e)
	DEP( 0xa5a5a5a5a5a5a4f9, 70368744177663, 2, 47, 0xa5a4fffffffffffd)
	EXT( 0xa5a5a5a5a5a5a4f8, 2, 48, 0x000069696969693e)
	EXTU(0xa5a5a5a5a5a5a4f8, 2, 48, 0x000069696969693e)
	DEP( 0xa5a5a5a5a5a5a4f8, 140737488355327, 2, 48, 0xa5a5fffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4f7, 2, 49, 0xffff69696969693d)
	EXTU(0xa5a5a5a5a5a5a4f7, 2, 49, 0x000169696969693d)
	DEP( 0xa5a5a5a5a5a5a4f7, 281474976710655, 2, 49, 0xa5a3ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4f6, 2, 50, 0x000169696969693d)
	EXTU(0xa5a5a5a5a5a5a4f6, 2, 50, 0x000169696969693d)
	DEP( 0xa5a5a5a5a5a5a4f6, 562949953421311, 2, 50, 0xa5a7fffffffffffe)
	EXT( 0xa5a5a5a5a5a5a4f5, 2, 51, 0x000169696969693d)
	EXTU(0xa5a5a5a5a5a5a4f5, 2, 51, 0x000169696969693d)
	DEP( 0xa5a5a5a5a5a5a4f5, 1125899906842623, 2, 51, 0xa5affffffffffffd)
	EXT( 0xa5a5a5a5a5a5a4f4, 2, 52, 0xfff969696969693d)
	EXTU(0xa5a5a5a5a5a5a4f4, 2, 52, 0x000969696969693d)
	DEP( 0xa5a5a5a5a5a5a4f4, 2251799813685247, 2, 52, 0xa59ffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4f3, 2, 53, 0x000969696969693c)
	EXTU(0xa5a5a5a5a5a5a4f3, 2, 53, 0x000969696969693c)
	DEP( 0xa5a5a5a5a5a5a4f3, 4503599627370495, 2, 53, 0xa5bfffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4f2, 2, 54, 0xffe969696969693c)
	EXTU(0xa5a5a5a5a5a5a4f2, 2, 54, 0x002969696969693c)
	DEP( 0xa5a5a5a5a5a5a4f2, 9007199254740991, 2, 54, 0xa57ffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a4f1, 2, 55, 0xffe969696969693c)
	EXTU(0xa5a5a5a5a5a5a4f1, 2, 55, 0x006969696969693c)
	DEP( 0xa5a5a5a5a5a5a4f1, 18014398509481983, 2, 55, 0xa4fffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a4f0, 2, 56, 0x006969696969693c)
	EXTU(0xa5a5a5a5a5a5a4f0, 2, 56, 0x006969696969693c)
	DEP( 0xa5a5a5a5a5a5a4f0, 36028797018963967, 2, 56, 0xa5fffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4ef, 2, 57, 0xff6969696969693b)
	EXTU(0xa5a5a5a5a5a5a4ef, 2, 57, 0x016969696969693b)
	DEP( 0xa5a5a5a5a5a5a4ef, 72057594037927935, 2, 57, 0xa3ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4ee, 2, 58, 0x016969696969693b)
	EXTU(0xa5a5a5a5a5a5a4ee, 2, 58, 0x016969696969693b)
	DEP( 0xa5a5a5a5a5a5a4ee, 144115188075855871, 2, 58, 0xa7fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a4ed, 2, 59, 0x016969696969693b)
	EXTU(0xa5a5a5a5a5a5a4ed, 2, 59, 0x016969696969693b)
	DEP( 0xa5a5a5a5a5a5a4ed, 288230376151711743, 2, 59, 0xaffffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a4ec, 2, 60, 0xf96969696969693b)
	EXTU(0xa5a5a5a5a5a5a4ec, 2, 60, 0x096969696969693b)
	DEP( 0xa5a5a5a5a5a5a4ec, 576460752303423487, 2, 60, 0x9ffffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4eb, 2, 61, 0x096969696969693a)
	EXTU(0xa5a5a5a5a5a5a4eb, 2, 61, 0x096969696969693a)
	DEP( 0xa5a5a5a5a5a5a4eb, 1152921504606846975, 2, 61, 0xbfffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4ea, 3, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a4ea, 3, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a4ea, 0, 3, 1, 0xa5a5a5a5a5a5a4e2)
	EXT( 0xa5a5a5a5a5a5a4e9, 3, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a4e9, 3, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a4e9, 1, 3, 2, 0xa5a5a5a5a5a5a4e9)
	EXT( 0xa5a5a5a5a5a5a4e8, 3, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a4e8, 3, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a4e8, 3, 3, 3, 0xa5a5a5a5a5a5a4d8)
	EXT( 0xa5a5a5a5a5a5a4e7, 3, 4, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a4e7, 3, 4, 0x000000000000000c)
	DEP( 0xa5a5a5a5a5a5a4e7, 7, 3, 4, 0xa5a5a5a5a5a5a4bf)
	EXT( 0xa5a5a5a5a5a5a4e6, 3, 5, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a4e6, 3, 5, 0x000000000000001c)
	DEP( 0xa5a5a5a5a5a5a4e6, 15, 3, 5, 0xa5a5a5a5a5a5a47e)
	EXT( 0xa5a5a5a5a5a5a4e5, 3, 6, 0x000000000000001c)
	EXTU(0xa5a5a5a5a5a5a4e5, 3, 6, 0x000000000000001c)
	DEP( 0xa5a5a5a5a5a5a4e5, 31, 3, 6, 0xa5a5a5a5a5a5a4fd)
	EXT( 0xa5a5a5a5a5a5a4e4, 3, 7, 0x000000000000001c)
	EXTU(0xa5a5a5a5a5a5a4e4, 3, 7, 0x000000000000001c)
	DEP( 0xa5a5a5a5a5a5a4e4, 63, 3, 7, 0xa5a5a5a5a5a5a5fc)
	EXT( 0xa5a5a5a5a5a5a4e3, 3, 8, 0xffffffffffffff9c)
	EXTU(0xa5a5a5a5a5a5a4e3, 3, 8, 0x000000000000009c)
	DEP( 0xa5a5a5a5a5a5a4e3, 127, 3, 8, 0xa5a5a5a5a5a5a3fb)
	EXT( 0xa5a5a5a5a5a5a4e2, 3, 9, 0x000000000000009c)
	EXTU(0xa5a5a5a5a5a5a4e2, 3, 9, 0x000000000000009c)
	DEP( 0xa5a5a5a5a5a5a4e2, 255, 3, 9, 0xa5a5a5a5a5a5a7fa)
	EXT( 0xa5a5a5a5a5a5a4e1, 3, 10, 0x000000000000009c)
	EXTU(0xa5a5a5a5a5a5a4e1, 3, 10, 0x000000000000009c)
	DEP( 0xa5a5a5a5a5a5a4e1, 511, 3, 10, 0xa5a5a5a5a5a5aff9)
	EXT( 0xa5a5a5a5a5a5a4e0, 3, 11, 0xfffffffffffffc9c)
	EXTU(0xa5a5a5a5a5a5a4e0, 3, 11, 0x000000000000049c)
	DEP( 0xa5a5a5a5a5a5a4e0, 1023, 3, 11, 0xa5a5a5a5a5a59ff8)
	EXT( 0xa5a5a5a5a5a5a4df, 3, 12, 0x000000000000049b)
	EXTU(0xa5a5a5a5a5a5a4df, 3, 12, 0x000000000000049b)
	DEP( 0xa5a5a5a5a5a5a4df, 2047, 3, 12, 0xa5a5a5a5a5a5bfff)
	EXT( 0xa5a5a5a5a5a5a4de, 3, 13, 0xfffffffffffff49b)
	EXTU(0xa5a5a5a5a5a5a4de, 3, 13, 0x000000000000149b)
	DEP( 0xa5a5a5a5a5a5a4de, 4095, 3, 13, 0xa5a5a5a5a5a57ffe)
	EXT( 0xa5a5a5a5a5a5a4dd, 3, 14, 0xfffffffffffff49b)
	EXTU(0xa5a5a5a5a5a5a4dd, 3, 14, 0x000000000000349b)
	DEP( 0xa5a5a5a5a5a5a4dd, 8191, 3, 14, 0xa5a5a5a5a5a4fffd)
	EXT( 0xa5a5a5a5a5a5a4dc, 3, 15, 0x000000000000349b)
	EXTU(0xa5a5a5a5a5a5a4dc, 3, 15, 0x000000000000349b)
	DEP( 0xa5a5a5a5a5a5a4dc, 16383, 3, 15, 0xa5a5a5a5a5a5fffc)
	EXT( 0xa5a5a5a5a5a5a4db, 3, 16, 0xffffffffffffb49b)
	EXTU(0xa5a5a5a5a5a5a4db, 3, 16, 0x000000000000b49b)
	DEP( 0xa5a5a5a5a5a5a4db, 32767, 3, 16, 0xa5a5a5a5a5a3fffb)
	EXT( 0xa5a5a5a5a5a5a4da, 3, 17, 0x000000000000b49b)
	EXTU(0xa5a5a5a5a5a5a4da, 3, 17, 0x000000000000b49b)
	DEP( 0xa5a5a5a5a5a5a4da, 65535, 3, 17, 0xa5a5a5a5a5a7fffa)
	EXT( 0xa5a5a5a5a5a5a4d9, 3, 18, 0x000000000000b49b)
	EXTU(0xa5a5a5a5a5a5a4d9, 3, 18, 0x000000000000b49b)
	DEP( 0xa5a5a5a5a5a5a4d9, 131071, 3, 18, 0xa5a5a5a5a5affff9)
	EXT( 0xa5a5a5a5a5a5a4d8, 3, 19, 0xfffffffffffcb49b)
	EXTU(0xa5a5a5a5a5a5a4d8, 3, 19, 0x000000000004b49b)
	DEP( 0xa5a5a5a5a5a5a4d8, 262143, 3, 19, 0xa5a5a5a5a59ffff8)
	EXT( 0xa5a5a5a5a5a5a4d7, 3, 20, 0x000000000004b49a)
	EXTU(0xa5a5a5a5a5a5a4d7, 3, 20, 0x000000000004b49a)
	DEP( 0xa5a5a5a5a5a5a4d7, 524287, 3, 20, 0xa5a5a5a5a5bfffff)
	EXT( 0xa5a5a5a5a5a5a4d6, 3, 21, 0xfffffffffff4b49a)
	EXTU(0xa5a5a5a5a5a5a4d6, 3, 21, 0x000000000014b49a)
	DEP( 0xa5a5a5a5a5a5a4d6, 1048575, 3, 21, 0xa5a5a5a5a57ffffe)
	EXT( 0xa5a5a5a5a5a5a4d5, 3, 22, 0xfffffffffff4b49a)
	EXTU(0xa5a5a5a5a5a5a4d5, 3, 22, 0x000000000034b49a)
	DEP( 0xa5a5a5a5a5a5a4d5, 2097151, 3, 22, 0xa5a5a5a5a4fffffd)
	EXT( 0xa5a5a5a5a5a5a4d4, 3, 23, 0x000000000034b49a)
	EXTU(0xa5a5a5a5a5a5a4d4, 3, 23, 0x000000000034b49a)
	DEP( 0xa5a5a5a5a5a5a4d4, 4194303, 3, 23, 0xa5a5a5a5a5fffffc)
	EXT( 0xa5a5a5a5a5a5a4d3, 3, 24, 0xffffffffffb4b49a)
	EXTU(0xa5a5a5a5a5a5a4d3, 3, 24, 0x0000000000b4b49a)
	DEP( 0xa5a5a5a5a5a5a4d3, 8388607, 3, 24, 0xa5a5a5a5a3fffffb)
	EXT( 0xa5a5a5a5a5a5a4d2, 3, 25, 0x0000000000b4b49a)
	EXTU(0xa5a5a5a5a5a5a4d2, 3, 25, 0x0000000000b4b49a)
	DEP( 0xa5a5a5a5a5a5a4d2, 16777215, 3, 25, 0xa5a5a5a5a7fffffa)
	EXT( 0xa5a5a5a5a5a5a4d1, 3, 26, 0x0000000000b4b49a)
	EXTU(0xa5a5a5a5a5a5a4d1, 3, 26, 0x0000000000b4b49a)
	DEP( 0xa5a5a5a5a5a5a4d1, 33554431, 3, 26, 0xa5a5a5a5affffff9)
	EXT( 0xa5a5a5a5a5a5a4d0, 3, 27, 0xfffffffffcb4b49a)
	EXTU(0xa5a5a5a5a5a5a4d0, 3, 27, 0x0000000004b4b49a)
	DEP( 0xa5a5a5a5a5a5a4d0, 67108863, 3, 27, 0xa5a5a5a59ffffff8)
	EXT( 0xa5a5a5a5a5a5a4cf, 3, 28, 0x0000000004b4b499)
	EXTU(0xa5a5a5a5a5a5a4cf, 3, 28, 0x0000000004b4b499)
	DEP( 0xa5a5a5a5a5a5a4cf, 134217727, 3, 28, 0xa5a5a5a5bfffffff)
	EXT( 0xa5a5a5a5a5a5a4ce, 3, 29, 0xfffffffff4b4b499)
	EXTU(0xa5a5a5a5a5a5a4ce, 3, 29, 0x0000000014b4b499)
	DEP( 0xa5a5a5a5a5a5a4ce, 268435455, 3, 29, 0xa5a5a5a57ffffffe)
	EXT( 0xa5a5a5a5a5a5a4cd, 3, 30, 0xfffffffff4b4b499)
	EXTU(0xa5a5a5a5a5a5a4cd, 3, 30, 0x0000000034b4b499)
	DEP( 0xa5a5a5a5a5a5a4cd, 536870911, 3, 30, 0xa5a5a5a4fffffffd)
	EXT( 0xa5a5a5a5a5a5a4cc, 3, 31, 0x0000000034b4b499)
	EXTU(0xa5a5a5a5a5a5a4cc, 3, 31, 0x0000000034b4b499)
	DEP( 0xa5a5a5a5a5a5a4cc, 1073741823, 3, 31, 0xa5a5a5a5fffffffc)
	EXT( 0xa5a5a5a5a5a5a4cb, 3, 32, 0xffffffffb4b4b499)
	EXTU(0xa5a5a5a5a5a5a4cb, 3, 32, 0x00000000b4b4b499)
	DEP( 0xa5a5a5a5a5a5a4cb, 2147483647, 3, 32, 0xa5a5a5a3fffffffb)
	EXT( 0xa5a5a5a5a5a5a4ca, 3, 33, 0x00000000b4b4b499)
	EXTU(0xa5a5a5a5a5a5a4ca, 3, 33, 0x00000000b4b4b499)
	DEP( 0xa5a5a5a5a5a5a4ca, 4294967295, 3, 33, 0xa5a5a5a7fffffffa)
	EXT( 0xa5a5a5a5a5a5a4c9, 3, 34, 0x00000000b4b4b499)
	EXTU(0xa5a5a5a5a5a5a4c9, 3, 34, 0x00000000b4b4b499)
	DEP( 0xa5a5a5a5a5a5a4c9, 8589934591, 3, 34, 0xa5a5a5affffffff9)
	EXT( 0xa5a5a5a5a5a5a4c8, 3, 35, 0xfffffffcb4b4b499)
	EXTU(0xa5a5a5a5a5a5a4c8, 3, 35, 0x00000004b4b4b499)
	DEP( 0xa5a5a5a5a5a5a4c8, 17179869183, 3, 35, 0xa5a5a59ffffffff8)
	EXT( 0xa5a5a5a5a5a5a4c7, 3, 36, 0x00000004b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c7, 3, 36, 0x00000004b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c7, 34359738367, 3, 36, 0xa5a5a5bfffffffff)
	EXT( 0xa5a5a5a5a5a5a4c6, 3, 37, 0xfffffff4b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c6, 3, 37, 0x00000014b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c6, 68719476735, 3, 37, 0xa5a5a57ffffffffe)
	EXT( 0xa5a5a5a5a5a5a4c5, 3, 38, 0xfffffff4b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c5, 3, 38, 0x00000034b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c5, 137438953471, 3, 38, 0xa5a5a4fffffffffd)
	EXT( 0xa5a5a5a5a5a5a4c4, 3, 39, 0x00000034b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c4, 3, 39, 0x00000034b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c4, 274877906943, 3, 39, 0xa5a5a5fffffffffc)
	EXT( 0xa5a5a5a5a5a5a4c3, 3, 40, 0xffffffb4b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c3, 3, 40, 0x000000b4b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c3, 549755813887, 3, 40, 0xa5a5a3fffffffffb)
	EXT( 0xa5a5a5a5a5a5a4c2, 3, 41, 0x000000b4b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c2, 3, 41, 0x000000b4b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c2, 1099511627775, 3, 41, 0xa5a5a7fffffffffa)
	EXT( 0xa5a5a5a5a5a5a4c1, 3, 42, 0x000000b4b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c1, 3, 42, 0x000000b4b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c1, 2199023255551, 3, 42, 0xa5a5affffffffff9)
	EXT( 0xa5a5a5a5a5a5a4c0, 3, 43, 0xfffffcb4b4b4b498)
	EXTU(0xa5a5a5a5a5a5a4c0, 3, 43, 0x000004b4b4b4b498)
	DEP( 0xa5a5a5a5a5a5a4c0, 4398046511103, 3, 43, 0xa5a59ffffffffff8)
	EXT( 0xa5a5a5a5a5a5a4bf, 3, 44, 0x000004b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4bf, 3, 44, 0x000004b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4bf, 8796093022207, 3, 44, 0xa5a5bfffffffffff)
	EXT( 0xa5a5a5a5a5a5a4be, 3, 45, 0xfffff4b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4be, 3, 45, 0x000014b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4be, 17592186044415, 3, 45, 0xa5a57ffffffffffe)
	EXT( 0xa5a5a5a5a5a5a4bd, 3, 46, 0xfffff4b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4bd, 3, 46, 0x000034b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4bd, 35184372088831, 3, 46, 0xa5a4fffffffffffd)
	EXT( 0xa5a5a5a5a5a5a4bc, 3, 47, 0x000034b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4bc, 3, 47, 0x000034b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4bc, 70368744177663, 3, 47, 0xa5a5fffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4bb, 3, 48, 0xffffb4b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4bb, 3, 48, 0x0000b4b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4bb, 140737488355327, 3, 48, 0xa5a3fffffffffffb)
	EXT( 0xa5a5a5a5a5a5a4ba, 3, 49, 0x0000b4b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4ba, 3, 49, 0x0000b4b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4ba, 281474976710655, 3, 49, 0xa5a7fffffffffffa)
	EXT( 0xa5a5a5a5a5a5a4b9, 3, 50, 0x0000b4b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4b9, 3, 50, 0x0000b4b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4b9, 562949953421311, 3, 50, 0xa5affffffffffff9)
	EXT( 0xa5a5a5a5a5a5a4b8, 3, 51, 0xfffcb4b4b4b4b497)
	EXTU(0xa5a5a5a5a5a5a4b8, 3, 51, 0x0004b4b4b4b4b497)
	DEP( 0xa5a5a5a5a5a5a4b8, 1125899906842623, 3, 51, 0xa59ffffffffffff8)
	EXT( 0xa5a5a5a5a5a5a4b7, 3, 52, 0x0004b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b7, 3, 52, 0x0004b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b7, 2251799813685247, 3, 52, 0xa5bfffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4b6, 3, 53, 0xfff4b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b6, 3, 53, 0x0014b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b6, 4503599627370495, 3, 53, 0xa57ffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a4b5, 3, 54, 0xfff4b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b5, 3, 54, 0x0034b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b5, 9007199254740991, 3, 54, 0xa4fffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a4b4, 3, 55, 0x0034b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b4, 3, 55, 0x0034b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b4, 18014398509481983, 3, 55, 0xa5fffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4b3, 3, 56, 0xffb4b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b3, 3, 56, 0x00b4b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b3, 36028797018963967, 3, 56, 0xa3fffffffffffffb)
	EXT( 0xa5a5a5a5a5a5a4b2, 3, 57, 0x00b4b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b2, 3, 57, 0x00b4b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b2, 72057594037927935, 3, 57, 0xa7fffffffffffffa)
	EXT( 0xa5a5a5a5a5a5a4b1, 3, 58, 0x00b4b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b1, 3, 58, 0x00b4b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b1, 144115188075855871, 3, 58, 0xaffffffffffffff9)
	EXT( 0xa5a5a5a5a5a5a4b0, 3, 59, 0xfcb4b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b0, 3, 59, 0x04b4b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b0, 288230376151711743, 3, 59, 0x9ffffffffffffff8)
	EXT( 0xa5a5a5a5a5a5a4af, 3, 60, 0x04b4b4b4b4b4b495)
	EXTU(0xa5a5a5a5a5a5a4af, 3, 60, 0x04b4b4b4b4b4b495)
	DEP( 0xa5a5a5a5a5a5a4af, 576460752303423487, 3, 60, 0xbfffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4ae, 4, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a4ae, 4, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a4ae, 0, 4, 1, 0xa5a5a5a5a5a5a4ae)
	EXT( 0xa5a5a5a5a5a5a4ad, 4, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a4ad, 4, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a4ad, 1, 4, 2, 0xa5a5a5a5a5a5a49d)
	EXT( 0xa5a5a5a5a5a5a4ac, 4, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a4ac, 4, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a4ac, 3, 4, 3, 0xa5a5a5a5a5a5a4bc)
	EXT( 0xa5a5a5a5a5a5a4ab, 4, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a4ab, 4, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a4ab, 7, 4, 4, 0xa5a5a5a5a5a5a47b)
	EXT( 0xa5a5a5a5a5a5a4aa, 4, 5, 0x000000000000000a)
	EXTU(0xa5a5a5a5a5a5a4aa, 4, 5, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a4aa, 15, 4, 5, 0xa5a5a5a5a5a5a4fa)
	EXT( 0xa5a5a5a5a5a5a4a9, 4, 6, 0x000000000000000a)
	EXTU(0xa5a5a5a5a5a5a4a9, 4, 6, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a4a9, 31, 4, 6, 0xa5a5a5a5a5a5a5f9)
	EXT( 0xa5a5a5a5a5a5a4a8, 4, 7, 0xffffffffffffffca)
	EXTU(0xa5a5a5a5a5a5a4a8, 4, 7, 0x000000000000004a)
	DEP( 0xa5a5a5a5a5a5a4a8, 63, 4, 7, 0xa5a5a5a5a5a5a3f8)
	EXT( 0xa5a5a5a5a5a5a4a7, 4, 8, 0x000000000000004a)
	EXTU(0xa5a5a5a5a5a5a4a7, 4, 8, 0x000000000000004a)
	DEP( 0xa5a5a5a5a5a5a4a7, 127, 4, 8, 0xa5a5a5a5a5a5a7f7)
	EXT( 0xa5a5a5a5a5a5a4a6, 4, 9, 0x000000000000004a)
	EXTU(0xa5a5a5a5a5a5a4a6, 4, 9, 0x000000000000004a)
	DEP( 0xa5a5a5a5a5a5a4a6, 255, 4, 9, 0xa5a5a5a5a5a5aff6)
	EXT( 0xa5a5a5a5a5a5a4a5, 4, 10, 0xfffffffffffffe4a)
	EXTU(0xa5a5a5a5a5a5a4a5, 4, 10, 0x000000000000024a)
	DEP( 0xa5a5a5a5a5a5a4a5, 511, 4, 10, 0xa5a5a5a5a5a59ff5)
	EXT( 0xa5a5a5a5a5a5a4a4, 4, 11, 0x000000000000024a)
	EXTU(0xa5a5a5a5a5a5a4a4, 4, 11, 0x000000000000024a)
	DEP( 0xa5a5a5a5a5a5a4a4, 1023, 4, 11, 0xa5a5a5a5a5a5bff4)
	EXT( 0xa5a5a5a5a5a5a4a3, 4, 12, 0xfffffffffffffa4a)
	EXTU(0xa5a5a5a5a5a5a4a3, 4, 12, 0x0000000000000a4a)
	DEP( 0xa5a5a5a5a5a5a4a3, 2047, 4, 12, 0xa5a5a5a5a5a57ff3)
	EXT( 0xa5a5a5a5a5a5a4a2, 4, 13, 0xfffffffffffffa4a)
	EXTU(0xa5a5a5a5a5a5a4a2, 4, 13, 0x0000000000001a4a)
	DEP( 0xa5a5a5a5a5a5a4a2, 4095, 4, 13, 0xa5a5a5a5a5a4fff2)
	EXT( 0xa5a5a5a5a5a5a4a1, 4, 14, 0x0000000000001a4a)
	EXTU(0xa5a5a5a5a5a5a4a1, 4, 14, 0x0000000000001a4a)
	DEP( 0xa5a5a5a5a5a5a4a1, 8191, 4, 14, 0xa5a5a5a5a5a5fff1)
	EXT( 0xa5a5a5a5a5a5a4a0, 4, 15, 0xffffffffffffda4a)
	EXTU(0xa5a5a5a5a5a5a4a0, 4, 15, 0x0000000000005a4a)
	DEP( 0xa5a5a5a5a5a5a4a0, 16383, 4, 15, 0xa5a5a5a5a5a3fff0)
	EXT( 0xa5a5a5a5a5a5a49f, 4, 16, 0x0000000000005a49)
	EXTU(0xa5a5a5a5a5a5a49f, 4, 16, 0x0000000000005a49)
	DEP( 0xa5a5a5a5a5a5a49f, 32767, 4, 16, 0xa5a5a5a5a5a7ffff)
	EXT( 0xa5a5a5a5a5a5a49e, 4, 17, 0x0000000000005a49)
	EXTU(0xa5a5a5a5a5a5a49e, 4, 17, 0x0000000000005a49)
	DEP( 0xa5a5a5a5a5a5a49e, 65535, 4, 17, 0xa5a5a5a5a5affffe)
	EXT( 0xa5a5a5a5a5a5a49d, 4, 18, 0xfffffffffffe5a49)
	EXTU(0xa5a5a5a5a5a5a49d, 4, 18, 0x0000000000025a49)
	DEP( 0xa5a5a5a5a5a5a49d, 131071, 4, 18, 0xa5a5a5a5a59ffffd)
	EXT( 0xa5a5a5a5a5a5a49c, 4, 19, 0x0000000000025a49)
	EXTU(0xa5a5a5a5a5a5a49c, 4, 19, 0x0000000000025a49)
	DEP( 0xa5a5a5a5a5a5a49c, 262143, 4, 19, 0xa5a5a5a5a5bffffc)
	EXT( 0xa5a5a5a5a5a5a49b, 4, 20, 0xfffffffffffa5a49)
	EXTU(0xa5a5a5a5a5a5a49b, 4, 20, 0x00000000000a5a49)
	DEP( 0xa5a5a5a5a5a5a49b, 524287, 4, 20, 0xa5a5a5a5a57ffffb)
	EXT( 0xa5a5a5a5a5a5a49a, 4, 21, 0xfffffffffffa5a49)
	EXTU(0xa5a5a5a5a5a5a49a, 4, 21, 0x00000000001a5a49)
	DEP( 0xa5a5a5a5a5a5a49a, 1048575, 4, 21, 0xa5a5a5a5a4fffffa)
	EXT( 0xa5a5a5a5a5a5a499, 4, 22, 0x00000000001a5a49)
	EXTU(0xa5a5a5a5a5a5a499, 4, 22, 0x00000000001a5a49)
	DEP( 0xa5a5a5a5a5a5a499, 2097151, 4, 22, 0xa5a5a5a5a5fffff9)
	EXT( 0xa5a5a5a5a5a5a498, 4, 23, 0xffffffffffda5a49)
	EXTU(0xa5a5a5a5a5a5a498, 4, 23, 0x00000000005a5a49)
	DEP( 0xa5a5a5a5a5a5a498, 4194303, 4, 23, 0xa5a5a5a5a3fffff8)
	EXT( 0xa5a5a5a5a5a5a497, 4, 24, 0x00000000005a5a49)
	EXTU(0xa5a5a5a5a5a5a497, 4, 24, 0x00000000005a5a49)
	DEP( 0xa5a5a5a5a5a5a497, 8388607, 4, 24, 0xa5a5a5a5a7fffff7)
	EXT( 0xa5a5a5a5a5a5a496, 4, 25, 0x00000000005a5a49)
	EXTU(0xa5a5a5a5a5a5a496, 4, 25, 0x00000000005a5a49)
	DEP( 0xa5a5a5a5a5a5a496, 16777215, 4, 25, 0xa5a5a5a5affffff6)
	EXT( 0xa5a5a5a5a5a5a495, 4, 26, 0xfffffffffe5a5a49)
	EXTU(0xa5a5a5a5a5a5a495, 4, 26, 0x00000000025a5a49)
	DEP( 0xa5a5a5a5a5a5a495, 33554431, 4, 26, 0xa5a5a5a59ffffff5)
	EXT( 0xa5a5a5a5a5a5a494, 4, 27, 0x00000000025a5a49)
	EXTU(0xa5a5a5a5a5a5a494, 4, 27, 0x00000000025a5a49)
	DEP( 0xa5a5a5a5a5a5a494, 67108863, 4, 27, 0xa5a5a5a5bffffff4)
	EXT( 0xa5a5a5a5a5a5a493, 4, 28, 0xfffffffffa5a5a49)
	EXTU(0xa5a5a5a5a5a5a493, 4, 28, 0x000000000a5a5a49)
	DEP( 0xa5a5a5a5a5a5a493, 134217727, 4, 28, 0xa5a5a5a57ffffff3)
	EXT( 0xa5a5a5a5a5a5a492, 4, 29, 0xfffffffffa5a5a49)
	EXTU(0xa5a5a5a5a5a5a492, 4, 29, 0x000000001a5a5a49)
	DEP( 0xa5a5a5a5a5a5a492, 268435455, 4, 29, 0xa5a5a5a4fffffff2)
	EXT( 0xa5a5a5a5a5a5a491, 4, 30, 0x000000001a5a5a49)
	EXTU(0xa5a5a5a5a5a5a491, 4, 30, 0x000000001a5a5a49)
	DEP( 0xa5a5a5a5a5a5a491, 536870911, 4, 30, 0xa5a5a5a5fffffff1)
	EXT( 0xa5a5a5a5a5a5a490, 4, 31, 0xffffffffda5a5a49)
	EXTU(0xa5a5a5a5a5a5a490, 4, 31, 0x000000005a5a5a49)
	DEP( 0xa5a5a5a5a5a5a490, 1073741823, 4, 31, 0xa5a5a5a3fffffff0)
	EXT( 0xa5a5a5a5a5a5a48f, 4, 32, 0x000000005a5a5a48)
	EXTU(0xa5a5a5a5a5a5a48f, 4, 32, 0x000000005a5a5a48)
	DEP( 0xa5a5a5a5a5a5a48f, 2147483647, 4, 32, 0xa5a5a5a7ffffffff)
	EXT( 0xa5a5a5a5a5a5a48e, 4, 33, 0x000000005a5a5a48)
	EXTU(0xa5a5a5a5a5a5a48e, 4, 33, 0x000000005a5a5a48)
	DEP( 0xa5a5a5a5a5a5a48e, 4294967295, 4, 33, 0xa5a5a5affffffffe)
	EXT( 0xa5a5a5a5a5a5a48d, 4, 34, 0xfffffffe5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a48d, 4, 34, 0x000000025a5a5a48)
	DEP( 0xa5a5a5a5a5a5a48d, 8589934591, 4, 34, 0xa5a5a59ffffffffd)
	EXT( 0xa5a5a5a5a5a5a48c, 4, 35, 0x000000025a5a5a48)
	EXTU(0xa5a5a5a5a5a5a48c, 4, 35, 0x000000025a5a5a48)
	DEP( 0xa5a5a5a5a5a5a48c, 17179869183, 4, 35, 0xa5a5a5bffffffffc)
	EXT( 0xa5a5a5a5a5a5a48b, 4, 36, 0xfffffffa5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a48b, 4, 36, 0x0000000a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a48b, 34359738367, 4, 36, 0xa5a5a57ffffffffb)
	EXT( 0xa5a5a5a5a5a5a48a, 4, 37, 0xfffffffa5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a48a, 4, 37, 0x0000001a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a48a, 68719476735, 4, 37, 0xa5a5a4fffffffffa)
	EXT( 0xa5a5a5a5a5a5a489, 4, 38, 0x0000001a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a489, 4, 38, 0x0000001a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a489, 137438953471, 4, 38, 0xa5a5a5fffffffff9)
	EXT( 0xa5a5a5a5a5a5a488, 4, 39, 0xffffffda5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a488, 4, 39, 0x0000005a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a488, 274877906943, 4, 39, 0xa5a5a3fffffffff8)
	EXT( 0xa5a5a5a5a5a5a487, 4, 40, 0x0000005a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a487, 4, 40, 0x0000005a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a487, 549755813887, 4, 40, 0xa5a5a7fffffffff7)
	EXT( 0xa5a5a5a5a5a5a486, 4, 41, 0x0000005a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a486, 4, 41, 0x0000005a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a486, 1099511627775, 4, 41, 0xa5a5affffffffff6)
	EXT( 0xa5a5a5a5a5a5a485, 4, 42, 0xfffffe5a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a485, 4, 42, 0x0000025a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a485, 2199023255551, 4, 42, 0xa5a59ffffffffff5)
	EXT( 0xa5a5a5a5a5a5a484, 4, 43, 0x0000025a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a484, 4, 43, 0x0000025a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a484, 4398046511103, 4, 43, 0xa5a5bffffffffff4)
	EXT( 0xa5a5a5a5a5a5a483, 4, 44, 0xfffffa5a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a483, 4, 44, 0x00000a5a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a483, 8796093022207, 4, 44, 0xa5a57ffffffffff3)
	EXT( 0xa5a5a5a5a5a5a482, 4, 45, 0xfffffa5a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a482, 4, 45, 0x00001a5a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a482, 17592186044415, 4, 45, 0xa5a4fffffffffff2)
	EXT( 0xa5a5a5a5a5a5a481, 4, 46, 0x00001a5a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a481, 4, 46, 0x00001a5a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a481, 35184372088831, 4, 46, 0xa5a5fffffffffff1)
	EXT( 0xa5a5a5a5a5a5a480, 4, 47, 0xffffda5a5a5a5a48)
	EXTU(0xa5a5a5a5a5a5a480, 4, 47, 0x00005a5a5a5a5a48)
	DEP( 0xa5a5a5a5a5a5a480, 70368744177663, 4, 47, 0xa5a3fffffffffff0)
	EXT( 0xa5a5a5a5a5a5a47f, 4, 48, 0x00005a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a47f, 4, 48, 0x00005a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a47f, 140737488355327, 4, 48, 0xa5a7ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a47e, 4, 49, 0x00005a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a47e, 4, 49, 0x00005a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a47e, 281474976710655, 4, 49, 0xa5affffffffffffe)
	EXT( 0xa5a5a5a5a5a5a47d, 4, 50, 0xfffe5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a47d, 4, 50, 0x00025a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a47d, 562949953421311, 4, 50, 0xa59ffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a47c, 4, 51, 0x00025a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a47c, 4, 51, 0x00025a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a47c, 1125899906842623, 4, 51, 0xa5bffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a47b, 4, 52, 0xfffa5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a47b, 4, 52, 0x000a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a47b, 2251799813685247, 4, 52, 0xa57ffffffffffffb)
	EXT( 0xa5a5a5a5a5a5a47a, 4, 53, 0xfffa5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a47a, 4, 53, 0x001a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a47a, 4503599627370495, 4, 53, 0xa4fffffffffffffa)
	EXT( 0xa5a5a5a5a5a5a479, 4, 54, 0x001a5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a479, 4, 54, 0x001a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a479, 9007199254740991, 4, 54, 0xa5fffffffffffff9)
	EXT( 0xa5a5a5a5a5a5a478, 4, 55, 0xffda5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a478, 4, 55, 0x005a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a478, 18014398509481983, 4, 55, 0xa3fffffffffffff8)
	EXT( 0xa5a5a5a5a5a5a477, 4, 56, 0x005a5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a477, 4, 56, 0x005a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a477, 36028797018963967, 4, 56, 0xa7fffffffffffff7)
	EXT( 0xa5a5a5a5a5a5a476, 4, 57, 0x005a5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a476, 4, 57, 0x005a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a476, 72057594037927935, 4, 57, 0xaffffffffffffff6)
	EXT( 0xa5a5a5a5a5a5a475, 4, 58, 0xfe5a5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a475, 4, 58, 0x025a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a475, 144115188075855871, 4, 58, 0x9ffffffffffffff5)
	EXT( 0xa5a5a5a5a5a5a474, 4, 59, 0x025a5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a474, 4, 59, 0x025a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a474, 288230376151711743, 4, 59, 0xbffffffffffffff4)
	EXT( 0xa5a5a5a5a5a5a473, 5, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a473, 5, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a473, 0, 5, 1, 0xa5a5a5a5a5a5a453)
	EXT( 0xa5a5a5a5a5a5a472, 5, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a472, 5, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a472, 1, 5, 2, 0xa5a5a5a5a5a5a432)
	EXT( 0xa5a5a5a5a5a5a471, 5, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a471, 5, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a471, 3, 5, 3, 0xa5a5a5a5a5a5a471)
	EXT( 0xa5a5a5a5a5a5a470, 5, 4, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a470, 5, 4, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a470, 7, 5, 4, 0xa5a5a5a5a5a5a4f0)
	EXT( 0xa5a5a5a5a5a5a46f, 5, 5, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a46f, 5, 5, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a46f, 15, 5, 5, 0xa5a5a5a5a5a5a5ef)
	EXT( 0xa5a5a5a5a5a5a46e, 5, 6, 0xffffffffffffffe3)
	EXTU(0xa5a5a5a5a5a5a46e, 5, 6, 0x0000000000000023)
	DEP( 0xa5a5a5a5a5a5a46e, 31, 5, 6, 0xa5a5a5a5a5a5a3ee)
	EXT( 0xa5a5a5a5a5a5a46d, 5, 7, 0x0000000000000023)
	EXTU(0xa5a5a5a5a5a5a46d, 5, 7, 0x0000000000000023)
	DEP( 0xa5a5a5a5a5a5a46d, 63, 5, 7, 0xa5a5a5a5a5a5a7ed)
	EXT( 0xa5a5a5a5a5a5a46c, 5, 8, 0x0000000000000023)
	EXTU(0xa5a5a5a5a5a5a46c, 5, 8, 0x0000000000000023)
	DEP( 0xa5a5a5a5a5a5a46c, 127, 5, 8, 0xa5a5a5a5a5a5afec)
	EXT( 0xa5a5a5a5a5a5a46b, 5, 9, 0xffffffffffffff23)
	EXTU(0xa5a5a5a5a5a5a46b, 5, 9, 0x0000000000000123)
	DEP( 0xa5a5a5a5a5a5a46b, 255, 5, 9, 0xa5a5a5a5a5a59feb)
	EXT( 0xa5a5a5a5a5a5a46a, 5, 10, 0x0000000000000123)
	EXTU(0xa5a5a5a5a5a5a46a, 5, 10, 0x0000000000000123)
	DEP( 0xa5a5a5a5a5a5a46a, 511, 5, 10, 0xa5a5a5a5a5a5bfea)
	EXT( 0xa5a5a5a5a5a5a469, 5, 11, 0xfffffffffffffd23)
	EXTU(0xa5a5a5a5a5a5a469, 5, 11, 0x0000000000000523)
	DEP( 0xa5a5a5a5a5a5a469, 1023, 5, 11, 0xa5a5a5a5a5a57fe9)
	EXT( 0xa5a5a5a5a5a5a468, 5, 12, 0xfffffffffffffd23)
	EXTU(0xa5a5a5a5a5a5a468, 5, 12, 0x0000000000000d23)
	DEP( 0xa5a5a5a5a5a5a468, 2047, 5, 12, 0xa5a5a5a5a5a4ffe8)
	EXT( 0xa5a5a5a5a5a5a467, 5, 13, 0x0000000000000d23)
	EXTU(0xa5a5a5a5a5a5a467, 5, 13, 0x0000000000000d23)
	DEP( 0xa5a5a5a5a5a5a467, 4095, 5, 13, 0xa5a5a5a5a5a5ffe7)
	EXT( 0xa5a5a5a5a5a5a466, 5, 14, 0xffffffffffffed23)
	EXTU(0xa5a5a5a5a5a5a466, 5, 14, 0x0000000000002d23)
	DEP( 0xa5a5a5a5a5a5a466, 8191, 5, 14, 0xa5a5a5a5a5a3ffe6)
	EXT( 0xa5a5a5a5a5a5a465, 5, 15, 0x0000000000002d23)
	EXTU(0xa5a5a5a5a5a5a465, 5, 15, 0x0000000000002d23)
	DEP( 0xa5a5a5a5a5a5a465, 16383, 5, 15, 0xa5a5a5a5a5a7ffe5)
	EXT( 0xa5a5a5a5a5a5a464, 5, 16, 0x0000000000002d23)
	EXTU(0xa5a5a5a5a5a5a464, 5, 16, 0x0000000000002d23)
	DEP( 0xa5a5a5a5a5a5a464, 32767, 5, 16, 0xa5a5a5a5a5afffe4)
	EXT( 0xa5a5a5a5a5a5a463, 5, 17, 0xffffffffffff2d23)
	EXTU(0xa5a5a5a5a5a5a463, 5, 17, 0x0000000000012d23)
	DEP( 0xa5a5a5a5a5a5a463, 65535, 5, 17, 0xa5a5a5a5a59fffe3)
	EXT( 0xa5a5a5a5a5a5a462, 5, 18, 0x0000000000012d23)
	EXTU(0xa5a5a5a5a5a5a462, 5, 18, 0x0000000000012d23)
	DEP( 0xa5a5a5a5a5a5a462, 131071, 5, 18, 0xa5a5a5a5a5bfffe2)
	EXT( 0xa5a5a5a5a5a5a461, 5, 19, 0xfffffffffffd2d23)
	EXTU(0xa5a5a5a5a5a5a461, 5, 19, 0x0000000000052d23)
	DEP( 0xa5a5a5a5a5a5a461, 262143, 5, 19, 0xa5a5a5a5a57fffe1)
	EXT( 0xa5a5a5a5a5a5a460, 5, 20, 0xfffffffffffd2d23)
	EXTU(0xa5a5a5a5a5a5a460, 5, 20, 0x00000000000d2d23)
	DEP( 0xa5a5a5a5a5a5a460, 524287, 5, 20, 0xa5a5a5a5a4ffffe0)
	EXT( 0xa5a5a5a5a5a5a45f, 5, 21, 0x00000000000d2d22)
	EXTU(0xa5a5a5a5a5a5a45f, 5, 21, 0x00000000000d2d22)
	DEP( 0xa5a5a5a5a5a5a45f, 1048575, 5, 21, 0xa5a5a5a5a5ffffff)
	EXT( 0xa5a5a5a5a5a5a45e, 5, 22, 0xffffffffffed2d22)
	EXTU(0xa5a5a5a5a5a5a45e, 5, 22, 0x00000000002d2d22)
	DEP( 0xa5a5a5a5a5a5a45e, 2097151, 5, 22, 0xa5a5a5a5a3fffffe)
	EXT( 0xa5a5a5a5a5a5a45d, 5, 23, 0x00000000002d2d22)
	EXTU(0xa5a5a5a5a5a5a45d, 5, 23, 0x00000000002d2d22)
	DEP( 0xa5a5a5a5a5a5a45d, 4194303, 5, 23, 0xa5a5a5a5a7fffffd)
	EXT( 0xa5a5a5a5a5a5a45c, 5, 24, 0x00000000002d2d22)
	EXTU(0xa5a5a5a5a5a5a45c, 5, 24, 0x00000000002d2d22)
	DEP( 0xa5a5a5a5a5a5a45c, 8388607, 5, 24, 0xa5a5a5a5affffffc)
	EXT( 0xa5a5a5a5a5a5a45b, 5, 25, 0xffffffffff2d2d22)
	EXTU(0xa5a5a5a5a5a5a45b, 5, 25, 0x00000000012d2d22)
	DEP( 0xa5a5a5a5a5a5a45b, 16777215, 5, 25, 0xa5a5a5a59ffffffb)
	EXT( 0xa5a5a5a5a5a5a45a, 5, 26, 0x00000000012d2d22)
	EXTU(0xa5a5a5a5a5a5a45a, 5, 26, 0x00000000012d2d22)
	DEP( 0xa5a5a5a5a5a5a45a, 33554431, 5, 26, 0xa5a5a5a5bffffffa)
	EXT( 0xa5a5a5a5a5a5a459, 5, 27, 0xfffffffffd2d2d22)
	EXTU(0xa5a5a5a5a5a5a459, 5, 27, 0x00000000052d2d22)
	DEP( 0xa5a5a5a5a5a5a459, 67108863, 5, 27, 0xa5a5a5a57ffffff9)
	EXT( 0xa5a5a5a5a5a5a458, 5, 28, 0xfffffffffd2d2d22)
	EXTU(0xa5a5a5a5a5a5a458, 5, 28, 0x000000000d2d2d22)
	DEP( 0xa5a5a5a5a5a5a458, 134217727, 5, 28, 0xa5a5a5a4fffffff8)
	EXT( 0xa5a5a5a5a5a5a457, 5, 29, 0x000000000d2d2d22)
	EXTU(0xa5a5a5a5a5a5a457, 5, 29, 0x000000000d2d2d22)
	DEP( 0xa5a5a5a5a5a5a457, 268435455, 5, 29, 0xa5a5a5a5fffffff7)
	EXT( 0xa5a5a5a5a5a5a456, 5, 30, 0xffffffffed2d2d22)
	EXTU(0xa5a5a5a5a5a5a456, 5, 30, 0x000000002d2d2d22)
	DEP( 0xa5a5a5a5a5a5a456, 536870911, 5, 30, 0xa5a5a5a3fffffff6)
	EXT( 0xa5a5a5a5a5a5a455, 5, 31, 0x000000002d2d2d22)
	EXTU(0xa5a5a5a5a5a5a455, 5, 31, 0x000000002d2d2d22)
	DEP( 0xa5a5a5a5a5a5a455, 1073741823, 5, 31, 0xa5a5a5a7fffffff5)
	EXT( 0xa5a5a5a5a5a5a454, 5, 32, 0x000000002d2d2d22)
	EXTU(0xa5a5a5a5a5a5a454, 5, 32, 0x000000002d2d2d22)
	DEP( 0xa5a5a5a5a5a5a454, 2147483647, 5, 32, 0xa5a5a5affffffff4)
	EXT( 0xa5a5a5a5a5a5a453, 5, 33, 0xffffffff2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a453, 5, 33, 0x000000012d2d2d22)
	DEP( 0xa5a5a5a5a5a5a453, 4294967295, 5, 33, 0xa5a5a59ffffffff3)
	EXT( 0xa5a5a5a5a5a5a452, 5, 34, 0x000000012d2d2d22)
	EXTU(0xa5a5a5a5a5a5a452, 5, 34, 0x000000012d2d2d22)
	DEP( 0xa5a5a5a5a5a5a452, 8589934591, 5, 34, 0xa5a5a5bffffffff2)
	EXT( 0xa5a5a5a5a5a5a451, 5, 35, 0xfffffffd2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a451, 5, 35, 0x000000052d2d2d22)
	DEP( 0xa5a5a5a5a5a5a451, 17179869183, 5, 35, 0xa5a5a57ffffffff1)
	EXT( 0xa5a5a5a5a5a5a450, 5, 36, 0xfffffffd2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a450, 5, 36, 0x0000000d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a450, 34359738367, 5, 36, 0xa5a5a4fffffffff0)
	EXT( 0xa5a5a5a5a5a5a44f, 5, 37, 0x0000000d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a44f, 5, 37, 0x0000000d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a44f, 68719476735, 5, 37, 0xa5a5a5ffffffffef)
	EXT( 0xa5a5a5a5a5a5a44e, 5, 38, 0xffffffed2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a44e, 5, 38, 0x0000002d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a44e, 137438953471, 5, 38, 0xa5a5a3ffffffffee)
	EXT( 0xa5a5a5a5a5a5a44d, 5, 39, 0x0000002d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a44d, 5, 39, 0x0000002d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a44d, 274877906943, 5, 39, 0xa5a5a7ffffffffed)
	EXT( 0xa5a5a5a5a5a5a44c, 5, 40, 0x0000002d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a44c, 5, 40, 0x0000002d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a44c, 549755813887, 5, 40, 0xa5a5afffffffffec)
	EXT( 0xa5a5a5a5a5a5a44b, 5, 41, 0xffffff2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a44b, 5, 41, 0x0000012d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a44b, 1099511627775, 5, 41, 0xa5a59fffffffffeb)
	EXT( 0xa5a5a5a5a5a5a44a, 5, 42, 0x0000012d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a44a, 5, 42, 0x0000012d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a44a, 2199023255551, 5, 42, 0xa5a5bfffffffffea)
	EXT( 0xa5a5a5a5a5a5a449, 5, 43, 0xfffffd2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a449, 5, 43, 0x0000052d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a449, 4398046511103, 5, 43, 0xa5a57fffffffffe9)
	EXT( 0xa5a5a5a5a5a5a448, 5, 44, 0xfffffd2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a448, 5, 44, 0x00000d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a448, 8796093022207, 5, 44, 0xa5a4ffffffffffe8)
	EXT( 0xa5a5a5a5a5a5a447, 5, 45, 0x00000d2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a447, 5, 45, 0x00000d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a447, 17592186044415, 5, 45, 0xa5a5ffffffffffe7)
	EXT( 0xa5a5a5a5a5a5a446, 5, 46, 0xffffed2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a446, 5, 46, 0x00002d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a446, 35184372088831, 5, 46, 0xa5a3ffffffffffe6)
	EXT( 0xa5a5a5a5a5a5a445, 5, 47, 0x00002d2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a445, 5, 47, 0x00002d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a445, 70368744177663, 5, 47, 0xa5a7ffffffffffe5)
	EXT( 0xa5a5a5a5a5a5a444, 5, 48, 0x00002d2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a444, 5, 48, 0x00002d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a444, 140737488355327, 5, 48, 0xa5afffffffffffe4)
	EXT( 0xa5a5a5a5a5a5a443, 5, 49, 0xffff2d2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a443, 5, 49, 0x00012d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a443, 281474976710655, 5, 49, 0xa59fffffffffffe3)
	EXT( 0xa5a5a5a5a5a5a442, 5, 50, 0x00012d2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a442, 5, 50, 0x00012d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a442, 562949953421311, 5, 50, 0xa5bfffffffffffe2)
	EXT( 0xa5a5a5a5a5a5a441, 5, 51, 0xfffd2d2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a441, 5, 51, 0x00052d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a441, 1125899906842623, 5, 51, 0xa57fffffffffffe1)
	EXT( 0xa5a5a5a5a5a5a440, 5, 52, 0xfffd2d2d2d2d2d22)
	EXTU(0xa5a5a5a5a5a5a440, 5, 52, 0x000d2d2d2d2d2d22)
	DEP( 0xa5a5a5a5a5a5a440, 2251799813685247, 5, 52, 0xa4ffffffffffffe0)
	EXT( 0xa5a5a5a5a5a5a43f, 5, 53, 0x000d2d2d2d2d2d21)
	EXTU(0xa5a5a5a5a5a5a43f, 5, 53, 0x000d2d2d2d2d2d21)
	DEP( 0xa5a5a5a5a5a5a43f, 4503599627370495, 5, 53, 0xa5ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a43e, 5, 54, 0xffed2d2d2d2d2d21)
	EXTU(0xa5a5a5a5a5a5a43e, 5, 54, 0x002d2d2d2d2d2d21)
	DEP( 0xa5a5a5a5a5a5a43e, 9007199254740991, 5, 54, 0xa3fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a43d, 5, 55, 0x002d2d2d2d2d2d21)
	EXTU(0xa5a5a5a5a5a5a43d, 5, 55, 0x002d2d2d2d2d2d21)
	DEP( 0xa5a5a5a5a5a5a43d, 18014398509481983, 5, 55, 0xa7fffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a43c, 5, 56, 0x002d2d2d2d2d2d21)
	EXTU(0xa5a5a5a5a5a5a43c, 5, 56, 0x002d2d2d2d2d2d21)
	DEP( 0xa5a5a5a5a5a5a43c, 36028797018963967, 5, 56, 0xaffffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a43b, 5, 57, 0xff2d2d2d2d2d2d21)
	EXTU(0xa5a5a5a5a5a5a43b, 5, 57, 0x012d2d2d2d2d2d21)
	DEP( 0xa5a5a5a5a5a5a43b, 72057594037927935, 5, 57, 0x9ffffffffffffffb)
	EXT( 0xa5a5a5a5a5a5a43a, 5, 58, 0x012d2d2d2d2d2d21)
	EXTU(0xa5a5a5a5a5a5a43a, 5, 58, 0x012d2d2d2d2d2d21)
	DEP( 0xa5a5a5a5a5a5a43a, 144115188075855871, 5, 58, 0xbffffffffffffffa)
	EXT( 0xa5a5a5a5a5a5a439, 6, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a439, 6, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a439, 0, 6, 1, 0xa5a5a5a5a5a5a439)
	EXT( 0xa5a5a5a5a5a5a438, 6, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a438, 6, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a438, 1, 6, 2, 0xa5a5a5a5a5a5a478)
	EXT( 0xa5a5a5a5a5a5a437, 6, 3, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a437, 6, 3, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a437, 3, 6, 3, 0xa5a5a5a5a5a5a4f7)
	EXT( 0xa5a5a5a5a5a5a436, 6, 4, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a436, 6, 4, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a436, 7, 6, 4, 0xa5a5a5a5a5a5a5f6)
	EXT( 0xa5a5a5a5a5a5a435, 6, 5, 0xfffffffffffffff0)
	EXTU(0xa5a5a5a5a5a5a435, 6, 5, 0x0000000000000010)
	DEP( 0xa5a5a5a5a5a5a435, 15, 6, 5, 0xa5a5a5a5a5a5a3f5)
	EXT( 0xa5a5a5a5a5a5a434, 6, 6, 0x0000000000000010)
	EXTU(0xa5a5a5a5a5a5a434, 6, 6, 0x0000000000000010)
	DEP( 0xa5a5a5a5a5a5a434, 31, 6, 6, 0xa5a5a5a5a5a5a7f4)
	EXT( 0xa5a5a5a5a5a5a433, 6, 7, 0x0000000000000010)
	EXTU(0xa5a5a5a5a5a5a433, 6, 7, 0x0000000000000010)
	DEP( 0xa5a5a5a5a5a5a433, 63, 6, 7, 0xa5a5a5a5a5a5aff3)
	EXT( 0xa5a5a5a5a5a5a432, 6, 8, 0xffffffffffffff90)
	EXTU(0xa5a5a5a5a5a5a432, 6, 8, 0x0000000000000090)
	DEP( 0xa5a5a5a5a5a5a432, 127, 6, 8, 0xa5a5a5a5a5a59ff2)
	EXT( 0xa5a5a5a5a5a5a431, 6, 9, 0x0000000000000090)
	EXTU(0xa5a5a5a5a5a5a431, 6, 9, 0x0000000000000090)
	DEP( 0xa5a5a5a5a5a5a431, 255, 6, 9, 0xa5a5a5a5a5a5bff1)
	EXT( 0xa5a5a5a5a5a5a430, 6, 10, 0xfffffffffffffe90)
	EXTU(0xa5a5a5a5a5a5a430, 6, 10, 0x0000000000000290)
	DEP( 0xa5a5a5a5a5a5a430, 511, 6, 10, 0xa5a5a5a5a5a57ff0)
	EXT( 0xa5a5a5a5a5a5a42f, 6, 11, 0xfffffffffffffe90)
	EXTU(0xa5a5a5a5a5a5a42f, 6, 11, 0x0000000000000690)
	DEP( 0xa5a5a5a5a5a5a42f, 1023, 6, 11, 0xa5a5a5a5a5a4ffef)
	EXT( 0xa5a5a5a5a5a5a42e, 6, 12, 0x0000000000000690)
	EXTU(0xa5a5a5a5a5a5a42e, 6, 12, 0x0000000000000690)
	DEP( 0xa5a5a5a5a5a5a42e, 2047, 6, 12, 0xa5a5a5a5a5a5ffee)
	EXT( 0xa5a5a5a5a5a5a42d, 6, 13, 0xfffffffffffff690)
	EXTU(0xa5a5a5a5a5a5a42d, 6, 13, 0x0000000000001690)
	DEP( 0xa5a5a5a5a5a5a42d, 4095, 6, 13, 0xa5a5a5a5a5a3ffed)
	EXT( 0xa5a5a5a5a5a5a42c, 6, 14, 0x0000000000001690)
	EXTU(0xa5a5a5a5a5a5a42c, 6, 14, 0x0000000000001690)
	DEP( 0xa5a5a5a5a5a5a42c, 8191, 6, 14, 0xa5a5a5a5a5a7ffec)
	EXT( 0xa5a5a5a5a5a5a42b, 6, 15, 0x0000000000001690)
	EXTU(0xa5a5a5a5a5a5a42b, 6, 15, 0x0000000000001690)
	DEP( 0xa5a5a5a5a5a5a42b, 16383, 6, 15, 0xa5a5a5a5a5afffeb)
	EXT( 0xa5a5a5a5a5a5a42a, 6, 16, 0xffffffffffff9690)
	EXTU(0xa5a5a5a5a5a5a42a, 6, 16, 0x0000000000009690)
	DEP( 0xa5a5a5a5a5a5a42a, 32767, 6, 16, 0xa5a5a5a5a59fffea)
	EXT( 0xa5a5a5a5a5a5a429, 6, 17, 0x0000000000009690)
	EXTU(0xa5a5a5a5a5a5a429, 6, 17, 0x0000000000009690)
	DEP( 0xa5a5a5a5a5a5a429, 65535, 6, 17, 0xa5a5a5a5a5bfffe9)
	EXT( 0xa5a5a5a5a5a5a428, 6, 18, 0xfffffffffffe9690)
	EXTU(0xa5a5a5a5a5a5a428, 6, 18, 0x0000000000029690)
	DEP( 0xa5a5a5a5a5a5a428, 131071, 6, 18, 0xa5a5a5a5a57fffe8)
	EXT( 0xa5a5a5a5a5a5a427, 6, 19, 0xfffffffffffe9690)
	EXTU(0xa5a5a5a5a5a5a427, 6, 19, 0x0000000000069690)
	DEP( 0xa5a5a5a5a5a5a427, 262143, 6, 19, 0xa5a5a5a5a4ffffe7)
	EXT( 0xa5a5a5a5a5a5a426, 6, 20, 0x0000000000069690)
	EXTU(0xa5a5a5a5a5a5a426, 6, 20, 0x0000000000069690)
	DEP( 0xa5a5a5a5a5a5a426, 524287, 6, 20, 0xa5a5a5a5a5ffffe6)
	EXT( 0xa5a5a5a5a5a5a425, 6, 21, 0xfffffffffff69690)
	EXTU(0xa5a5a5a5a5a5a425, 6, 21, 0x0000000000169690)
	DEP( 0xa5a5a5a5a5a5a425, 1048575, 6, 21, 0xa5a5a5a5a3ffffe5)
	EXT( 0xa5a5a5a5a5a5a424, 6, 22, 0x0000000000169690)
	EXTU(0xa5a5a5a5a5a5a424, 6, 22, 0x0000000000169690)
	DEP( 0xa5a5a5a5a5a5a424, 2097151, 6, 22, 0xa5a5a5a5a7ffffe4)
	EXT( 0xa5a5a5a5a5a5a423, 6, 23, 0x0000000000169690)
	EXTU(0xa5a5a5a5a5a5a423, 6, 23, 0x0000000000169690)
	DEP( 0xa5a5a5a5a5a5a423, 4194303, 6, 23, 0xa5a5a5a5afffffe3)
	EXT( 0xa5a5a5a5a5a5a422, 6, 24, 0xffffffffff969690)
	EXTU(0xa5a5a5a5a5a5a422, 6, 24, 0x0000000000969690)
	DEP( 0xa5a5a5a5a5a5a422, 8388607, 6, 24, 0xa5a5a5a59fffffe2)
	EXT( 0xa5a5a5a5a5a5a421, 6, 25, 0x0000000000969690)
	EXTU(0xa5a5a5a5a5a5a421, 6, 25, 0x0000000000969690)
	DEP( 0xa5a5a5a5a5a5a421, 16777215, 6, 25, 0xa5a5a5a5bfffffe1)
	EXT( 0xa5a5a5a5a5a5a420, 6, 26, 0xfffffffffe969690)
	EXTU(0xa5a5a5a5a5a5a420, 6, 26, 0x0000000002969690)
	DEP( 0xa5a5a5a5a5a5a420, 33554431, 6, 26, 0xa5a5a5a57fffffe0)
	EXT( 0xa5a5a5a5a5a5a41f, 6, 27, 0xfffffffffe969690)
	EXTU(0xa5a5a5a5a5a5a41f, 6, 27, 0x0000000006969690)
	DEP( 0xa5a5a5a5a5a5a41f, 67108863, 6, 27, 0xa5a5a5a4ffffffdf)
	EXT( 0xa5a5a5a5a5a5a41e, 6, 28, 0x0000000006969690)
	EXTU(0xa5a5a5a5a5a5a41e, 6, 28, 0x0000000006969690)
	DEP( 0xa5a5a5a5a5a5a41e, 134217727, 6, 28, 0xa5a5a5a5ffffffde)
	EXT( 0xa5a5a5a5a5a5a41d, 6, 29, 0xfffffffff6969690)
	EXTU(0xa5a5a5a5a5a5a41d, 6, 29, 0x0000000016969690)
	DEP( 0xa5a5a5a5a5a5a41d, 268435455, 6, 29, 0xa5a5a5a3ffffffdd)
	EXT( 0xa5a5a5a5a5a5a41c, 6, 30, 0x0000000016969690)
	EXTU(0xa5a5a5a5a5a5a41c, 6, 30, 0x0000000016969690)
	DEP( 0xa5a5a5a5a5a5a41c, 536870911, 6, 30, 0xa5a5a5a7ffffffdc)
	EXT( 0xa5a5a5a5a5a5a41b, 6, 31, 0x0000000016969690)
	EXTU(0xa5a5a5a5a5a5a41b, 6, 31, 0x0000000016969690)
	DEP( 0xa5a5a5a5a5a5a41b, 1073741823, 6, 31, 0xa5a5a5afffffffdb)
	EXT( 0xa5a5a5a5a5a5a41a, 6, 32, 0xffffffff96969690)
	EXTU(0xa5a5a5a5a5a5a41a, 6, 32, 0x0000000096969690)
	DEP( 0xa5a5a5a5a5a5a41a, 2147483647, 6, 32, 0xa5a5a59fffffffda)
	EXT( 0xa5a5a5a5a5a5a419, 6, 33, 0x0000000096969690)
	EXTU(0xa5a5a5a5a5a5a419, 6, 33, 0x0000000096969690)
	DEP( 0xa5a5a5a5a5a5a419, 4294967295, 6, 33, 0xa5a5a5bfffffffd9)
	EXT( 0xa5a5a5a5a5a5a418, 6, 34, 0xfffffffe96969690)
	EXTU(0xa5a5a5a5a5a5a418, 6, 34, 0x0000000296969690)
	DEP( 0xa5a5a5a5a5a5a418, 8589934591, 6, 34, 0xa5a5a57fffffffd8)
	EXT( 0xa5a5a5a5a5a5a417, 6, 35, 0xfffffffe96969690)
	EXTU(0xa5a5a5a5a5a5a417, 6, 35, 0x0000000696969690)
	DEP( 0xa5a5a5a5a5a5a417, 17179869183, 6, 35, 0xa5a5a4ffffffffd7)
	EXT( 0xa5a5a5a5a5a5a416, 6, 36, 0x0000000696969690)
	EXTU(0xa5a5a5a5a5a5a416, 6, 36, 0x0000000696969690)
	DEP( 0xa5a5a5a5a5a5a416, 34359738367, 6, 36, 0xa5a5a5ffffffffd6)
	EXT( 0xa5a5a5a5a5a5a415, 6, 37, 0xfffffff696969690)
	EXTU(0xa5a5a5a5a5a5a415, 6, 37, 0x0000001696969690)
	DEP( 0xa5a5a5a5a5a5a415, 68719476735, 6, 37, 0xa5a5a3ffffffffd5)
	EXT( 0xa5a5a5a5a5a5a414, 6, 38, 0x0000001696969690)
	EXTU(0xa5a5a5a5a5a5a414, 6, 38, 0x0000001696969690)
	DEP( 0xa5a5a5a5a5a5a414, 137438953471, 6, 38, 0xa5a5a7ffffffffd4)
	EXT( 0xa5a5a5a5a5a5a413, 6, 39, 0x0000001696969690)
	EXTU(0xa5a5a5a5a5a5a413, 6, 39, 0x0000001696969690)
	DEP( 0xa5a5a5a5a5a5a413, 274877906943, 6, 39, 0xa5a5afffffffffd3)
	EXT( 0xa5a5a5a5a5a5a412, 6, 40, 0xffffff9696969690)
	EXTU(0xa5a5a5a5a5a5a412, 6, 40, 0x0000009696969690)
	DEP( 0xa5a5a5a5a5a5a412, 549755813887, 6, 40, 0xa5a59fffffffffd2)
	EXT( 0xa5a5a5a5a5a5a411, 6, 41, 0x0000009696969690)
	EXTU(0xa5a5a5a5a5a5a411, 6, 41, 0x0000009696969690)
	DEP( 0xa5a5a5a5a5a5a411, 1099511627775, 6, 41, 0xa5a5bfffffffffd1)
	EXT( 0xa5a5a5a5a5a5a410, 6, 42, 0xfffffe9696969690)
	EXTU(0xa5a5a5a5a5a5a410, 6, 42, 0x0000029696969690)
	DEP( 0xa5a5a5a5a5a5a410, 2199023255551, 6, 42, 0xa5a57fffffffffd0)
	EXT( 0xa5a5a5a5a5a5a40f, 6, 43, 0xfffffe9696969690)
	EXTU(0xa5a5a5a5a5a5a40f, 6, 43, 0x0000069696969690)
	DEP( 0xa5a5a5a5a5a5a40f, 4398046511103, 6, 43, 0xa5a4ffffffffffcf)
	EXT( 0xa5a5a5a5a5a5a40e, 6, 44, 0x0000069696969690)
	EXTU(0xa5a5a5a5a5a5a40e, 6, 44, 0x0000069696969690)
	DEP( 0xa5a5a5a5a5a5a40e, 8796093022207, 6, 44, 0xa5a5ffffffffffce)
	EXT( 0xa5a5a5a5a5a5a40d, 6, 45, 0xfffff69696969690)
	EXTU(0xa5a5a5a5a5a5a40d, 6, 45, 0x0000169696969690)
	DEP( 0xa5a5a5a5a5a5a40d, 17592186044415, 6, 45, 0xa5a3ffffffffffcd)
	EXT( 0xa5a5a5a5a5a5a40c, 6, 46, 0x0000169696969690)
	EXTU(0xa5a5a5a5a5a5a40c, 6, 46, 0x0000169696969690)
	DEP( 0xa5a5a5a5a5a5a40c, 35184372088831, 6, 46, 0xa5a7ffffffffffcc)
	EXT( 0xa5a5a5a5a5a5a40b, 6, 47, 0x0000169696969690)
	EXTU(0xa5a5a5a5a5a5a40b, 6, 47, 0x0000169696969690)
	DEP( 0xa5a5a5a5a5a5a40b, 70368744177663, 6, 47, 0xa5afffffffffffcb)
	EXT( 0xa5a5a5a5a5a5a40a, 6, 48, 0xffff969696969690)
	EXTU(0xa5a5a5a5a5a5a40a, 6, 48, 0x0000969696969690)
	DEP( 0xa5a5a5a5a5a5a40a, 140737488355327, 6, 48, 0xa59fffffffffffca)
	EXT( 0xa5a5a5a5a5a5a409, 6, 49, 0x0000969696969690)
	EXTU(0xa5a5a5a5a5a5a409, 6, 49, 0x0000969696969690)
	DEP( 0xa5a5a5a5a5a5a409, 281474976710655, 6, 49, 0xa5bfffffffffffc9)
	EXT( 0xa5a5a5a5a5a5a408, 6, 50, 0xfffe969696969690)
	EXTU(0xa5a5a5a5a5a5a408, 6, 50, 0x0002969696969690)
	DEP( 0xa5a5a5a5a5a5a408, 562949953421311, 6, 50, 0xa57fffffffffffc8)
	EXT( 0xa5a5a5a5a5a5a407, 6, 51, 0xfffe969696969690)
	EXTU(0xa5a5a5a5a5a5a407, 6, 51, 0x0006969696969690)
	DEP( 0xa5a5a5a5a5a5a407, 1125899906842623, 6, 51, 0xa4ffffffffffffc7)
	EXT( 0xa5a5a5a5a5a5a406, 6, 52, 0x0006969696969690)
	EXTU(0xa5a5a5a5a5a5a406, 6, 52, 0x0006969696969690)
	DEP( 0xa5a5a5a5a5a5a406, 2251799813685247, 6, 52, 0xa5ffffffffffffc6)
	EXT( 0xa5a5a5a5a5a5a405, 6, 53, 0xfff6969696969690)
	EXTU(0xa5a5a5a5a5a5a405, 6, 53, 0x0016969696969690)
	DEP( 0xa5a5a5a5a5a5a405, 4503599627370495, 6, 53, 0xa3ffffffffffffc5)
	EXT( 0xa5a5a5a5a5a5a404, 6, 54, 0x0016969696969690)
	EXTU(0xa5a5a5a5a5a5a404, 6, 54, 0x0016969696969690)
	DEP( 0xa5a5a5a5a5a5a404, 9007199254740991, 6, 54, 0xa7ffffffffffffc4)
	EXT( 0xa5a5a5a5a5a5a403, 6, 55, 0x0016969696969690)
	EXTU(0xa5a5a5a5a5a5a403, 6, 55, 0x0016969696969690)
	DEP( 0xa5a5a5a5a5a5a403, 18014398509481983, 6, 55, 0xafffffffffffffc3)
	EXT( 0xa5a5a5a5a5a5a402, 6, 56, 0xff96969696969690)
	EXTU(0xa5a5a5a5a5a5a402, 6, 56, 0x0096969696969690)
	DEP( 0xa5a5a5a5a5a5a402, 36028797018963967, 6, 56, 0x9fffffffffffffc2)
	EXT( 0xa5a5a5a5a5a5a401, 6, 57, 0x0096969696969690)
	EXTU(0xa5a5a5a5a5a5a401, 6, 57, 0x0096969696969690)
	DEP( 0xa5a5a5a5a5a5a401, 72057594037927935, 6, 57, 0xbfffffffffffffc1)
	EXT( 0xa5a5a5a5a5a5a400, 7, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a400, 7, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a400, 0, 7, 1, 0xa5a5a5a5a5a5a400)
	EXT( 0xa5a5a5a5a5a5a3ff, 7, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a3ff, 7, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a3ff, 1, 7, 2, 0xa5a5a5a5a5a5a2ff)
	EXT( 0xa5a5a5a5a5a5a3fe, 7, 3, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a3fe, 7, 3, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a5a3fe, 3, 7, 3, 0xa5a5a5a5a5a5a1fe)
	EXT( 0xa5a5a5a5a5a5a3fd, 7, 4, 0x0000000000000007)
	EXTU(0xa5a5a5a5a5a5a3fd, 7, 4, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a5a3fd, 7, 7, 4, 0xa5a5a5a5a5a5a3fd)
	EXT( 0xa5a5a5a5a5a5a3fc, 7, 5, 0x0000000000000007)
	EXTU(0xa5a5a5a5a5a5a3fc, 7, 5, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a5a3fc, 15, 7, 5, 0xa5a5a5a5a5a5a7fc)
	EXT( 0xa5a5a5a5a5a5a3fb, 7, 6, 0x0000000000000007)
	EXTU(0xa5a5a5a5a5a5a3fb, 7, 6, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a5a3fb, 31, 7, 6, 0xa5a5a5a5a5a5affb)
	EXT( 0xa5a5a5a5a5a5a3fa, 7, 7, 0xffffffffffffffc7)
	EXTU(0xa5a5a5a5a5a5a3fa, 7, 7, 0x0000000000000047)
	DEP( 0xa5a5a5a5a5a5a3fa, 63, 7, 7, 0xa5a5a5a5a5a59ffa)
	EXT( 0xa5a5a5a5a5a5a3f9, 7, 8, 0x0000000000000047)
	EXTU(0xa5a5a5a5a5a5a3f9, 7, 8, 0x0000000000000047)
	DEP( 0xa5a5a5a5a5a5a3f9, 127, 7, 8, 0xa5a5a5a5a5a5bff9)
	EXT( 0xa5a5a5a5a5a5a3f8, 7, 9, 0xffffffffffffff47)
	EXTU(0xa5a5a5a5a5a5a3f8, 7, 9, 0x0000000000000147)
	DEP( 0xa5a5a5a5a5a5a3f8, 255, 7, 9, 0xa5a5a5a5a5a57ff8)
	EXT( 0xa5a5a5a5a5a5a3f7, 7, 10, 0xffffffffffffff47)
	EXTU(0xa5a5a5a5a5a5a3f7, 7, 10, 0x0000000000000347)
	DEP( 0xa5a5a5a5a5a5a3f7, 511, 7, 10, 0xa5a5a5a5a5a4fff7)
	EXT( 0xa5a5a5a5a5a5a3f6, 7, 11, 0x0000000000000347)
	EXTU(0xa5a5a5a5a5a5a3f6, 7, 11, 0x0000000000000347)
	DEP( 0xa5a5a5a5a5a5a3f6, 1023, 7, 11, 0xa5a5a5a5a5a5fff6)
	EXT( 0xa5a5a5a5a5a5a3f5, 7, 12, 0xfffffffffffffb47)
	EXTU(0xa5a5a5a5a5a5a3f5, 7, 12, 0x0000000000000b47)
	DEP( 0xa5a5a5a5a5a5a3f5, 2047, 7, 12, 0xa5a5a5a5a5a3fff5)
	EXT( 0xa5a5a5a5a5a5a3f4, 7, 13, 0x0000000000000b47)
	EXTU(0xa5a5a5a5a5a5a3f4, 7, 13, 0x0000000000000b47)
	DEP( 0xa5a5a5a5a5a5a3f4, 4095, 7, 13, 0xa5a5a5a5a5a7fff4)
	EXT( 0xa5a5a5a5a5a5a3f3, 7, 14, 0x0000000000000b47)
	EXTU(0xa5a5a5a5a5a5a3f3, 7, 14, 0x0000000000000b47)
	DEP( 0xa5a5a5a5a5a5a3f3, 8191, 7, 14, 0xa5a5a5a5a5affff3)
	EXT( 0xa5a5a5a5a5a5a3f2, 7, 15, 0xffffffffffffcb47)
	EXTU(0xa5a5a5a5a5a5a3f2, 7, 15, 0x0000000000004b47)
	DEP( 0xa5a5a5a5a5a5a3f2, 16383, 7, 15, 0xa5a5a5a5a59ffff2)
	EXT( 0xa5a5a5a5a5a5a3f1, 7, 16, 0x0000000000004b47)
	EXTU(0xa5a5a5a5a5a5a3f1, 7, 16, 0x0000000000004b47)
	DEP( 0xa5a5a5a5a5a5a3f1, 32767, 7, 16, 0xa5a5a5a5a5bffff1)
	EXT( 0xa5a5a5a5a5a5a3f0, 7, 17, 0xffffffffffff4b47)
	EXTU(0xa5a5a5a5a5a5a3f0, 7, 17, 0x0000000000014b47)
	DEP( 0xa5a5a5a5a5a5a3f0, 65535, 7, 17, 0xa5a5a5a5a57ffff0)
	EXT( 0xa5a5a5a5a5a5a3ef, 7, 18, 0xffffffffffff4b47)
	EXTU(0xa5a5a5a5a5a5a3ef, 7, 18, 0x0000000000034b47)
	DEP( 0xa5a5a5a5a5a5a3ef, 131071, 7, 18, 0xa5a5a5a5a4ffffef)
	EXT( 0xa5a5a5a5a5a5a3ee, 7, 19, 0x0000000000034b47)
	EXTU(0xa5a5a5a5a5a5a3ee, 7, 19, 0x0000000000034b47)
	DEP( 0xa5a5a5a5a5a5a3ee, 262143, 7, 19, 0xa5a5a5a5a5ffffee)
	EXT( 0xa5a5a5a5a5a5a3ed, 7, 20, 0xfffffffffffb4b47)
	EXTU(0xa5a5a5a5a5a5a3ed, 7, 20, 0x00000000000b4b47)
	DEP( 0xa5a5a5a5a5a5a3ed, 524287, 7, 20, 0xa5a5a5a5a3ffffed)
	EXT( 0xa5a5a5a5a5a5a3ec, 7, 21, 0x00000000000b4b47)
	EXTU(0xa5a5a5a5a5a5a3ec, 7, 21, 0x00000000000b4b47)
	DEP( 0xa5a5a5a5a5a5a3ec, 1048575, 7, 21, 0xa5a5a5a5a7ffffec)
	EXT( 0xa5a5a5a5a5a5a3eb, 7, 22, 0x00000000000b4b47)
	EXTU(0xa5a5a5a5a5a5a3eb, 7, 22, 0x00000000000b4b47)
	DEP( 0xa5a5a5a5a5a5a3eb, 2097151, 7, 22, 0xa5a5a5a5afffffeb)
	EXT( 0xa5a5a5a5a5a5a3ea, 7, 23, 0xffffffffffcb4b47)
	EXTU(0xa5a5a5a5a5a5a3ea, 7, 23, 0x00000000004b4b47)
	DEP( 0xa5a5a5a5a5a5a3ea, 4194303, 7, 23, 0xa5a5a5a59fffffea)
	EXT( 0xa5a5a5a5a5a5a3e9, 7, 24, 0x00000000004b4b47)
	EXTU(0xa5a5a5a5a5a5a3e9, 7, 24, 0x00000000004b4b47)
	DEP( 0xa5a5a5a5a5a5a3e9, 8388607, 7, 24, 0xa5a5a5a5bfffffe9)
	EXT( 0xa5a5a5a5a5a5a3e8, 7, 25, 0xffffffffff4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e8, 7, 25, 0x00000000014b4b47)
	DEP( 0xa5a5a5a5a5a5a3e8, 16777215, 7, 25, 0xa5a5a5a57fffffe8)
	EXT( 0xa5a5a5a5a5a5a3e7, 7, 26, 0xffffffffff4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e7, 7, 26, 0x00000000034b4b47)
	DEP( 0xa5a5a5a5a5a5a3e7, 33554431, 7, 26, 0xa5a5a5a4ffffffe7)
	EXT( 0xa5a5a5a5a5a5a3e6, 7, 27, 0x00000000034b4b47)
	EXTU(0xa5a5a5a5a5a5a3e6, 7, 27, 0x00000000034b4b47)
	DEP( 0xa5a5a5a5a5a5a3e6, 67108863, 7, 27, 0xa5a5a5a5ffffffe6)
	EXT( 0xa5a5a5a5a5a5a3e5, 7, 28, 0xfffffffffb4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e5, 7, 28, 0x000000000b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3e5, 134217727, 7, 28, 0xa5a5a5a3ffffffe5)
	EXT( 0xa5a5a5a5a5a5a3e4, 7, 29, 0x000000000b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e4, 7, 29, 0x000000000b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3e4, 268435455, 7, 29, 0xa5a5a5a7ffffffe4)
	EXT( 0xa5a5a5a5a5a5a3e3, 7, 30, 0x000000000b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e3, 7, 30, 0x000000000b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3e3, 536870911, 7, 30, 0xa5a5a5afffffffe3)
	EXT( 0xa5a5a5a5a5a5a3e2, 7, 31, 0xffffffffcb4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e2, 7, 31, 0x000000004b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3e2, 1073741823, 7, 31, 0xa5a5a59fffffffe2)
	EXT( 0xa5a5a5a5a5a5a3e1, 7, 32, 0x000000004b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e1, 7, 32, 0x000000004b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3e1, 2147483647, 7, 32, 0xa5a5a5bfffffffe1)
	EXT( 0xa5a5a5a5a5a5a3e0, 7, 33, 0xffffffff4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3e0, 7, 33, 0x000000014b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3e0, 4294967295, 7, 33, 0xa5a5a57fffffffe0)
	EXT( 0xa5a5a5a5a5a5a3df, 7, 34, 0xffffffff4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3df, 7, 34, 0x000000034b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3df, 8589934591, 7, 34, 0xa5a5a4ffffffffdf)
	EXT( 0xa5a5a5a5a5a5a3de, 7, 35, 0x000000034b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3de, 7, 35, 0x000000034b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3de, 17179869183, 7, 35, 0xa5a5a5ffffffffde)
	EXT( 0xa5a5a5a5a5a5a3dd, 7, 36, 0xfffffffb4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3dd, 7, 36, 0x0000000b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3dd, 34359738367, 7, 36, 0xa5a5a3ffffffffdd)
	EXT( 0xa5a5a5a5a5a5a3dc, 7, 37, 0x0000000b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3dc, 7, 37, 0x0000000b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3dc, 68719476735, 7, 37, 0xa5a5a7ffffffffdc)
	EXT( 0xa5a5a5a5a5a5a3db, 7, 38, 0x0000000b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3db, 7, 38, 0x0000000b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3db, 137438953471, 7, 38, 0xa5a5afffffffffdb)
	EXT( 0xa5a5a5a5a5a5a3da, 7, 39, 0xffffffcb4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3da, 7, 39, 0x0000004b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3da, 274877906943, 7, 39, 0xa5a59fffffffffda)
	EXT( 0xa5a5a5a5a5a5a3d9, 7, 40, 0x0000004b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d9, 7, 40, 0x0000004b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d9, 549755813887, 7, 40, 0xa5a5bfffffffffd9)
	EXT( 0xa5a5a5a5a5a5a3d8, 7, 41, 0xffffff4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d8, 7, 41, 0x0000014b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d8, 1099511627775, 7, 41, 0xa5a57fffffffffd8)
	EXT( 0xa5a5a5a5a5a5a3d7, 7, 42, 0xffffff4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d7, 7, 42, 0x0000034b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d7, 2199023255551, 7, 42, 0xa5a4ffffffffffd7)
	EXT( 0xa5a5a5a5a5a5a3d6, 7, 43, 0x0000034b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d6, 7, 43, 0x0000034b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d6, 4398046511103, 7, 43, 0xa5a5ffffffffffd6)
	EXT( 0xa5a5a5a5a5a5a3d5, 7, 44, 0xfffffb4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d5, 7, 44, 0x00000b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d5, 8796093022207, 7, 44, 0xa5a3ffffffffffd5)
	EXT( 0xa5a5a5a5a5a5a3d4, 7, 45, 0x00000b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d4, 7, 45, 0x00000b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d4, 17592186044415, 7, 45, 0xa5a7ffffffffffd4)
	EXT( 0xa5a5a5a5a5a5a3d3, 7, 46, 0x00000b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d3, 7, 46, 0x00000b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d3, 35184372088831, 7, 46, 0xa5afffffffffffd3)
	EXT( 0xa5a5a5a5a5a5a3d2, 7, 47, 0xffffcb4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d2, 7, 47, 0x00004b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d2, 70368744177663, 7, 47, 0xa59fffffffffffd2)
	EXT( 0xa5a5a5a5a5a5a3d1, 7, 48, 0x00004b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d1, 7, 48, 0x00004b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d1, 140737488355327, 7, 48, 0xa5bfffffffffffd1)
	EXT( 0xa5a5a5a5a5a5a3d0, 7, 49, 0xffff4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3d0, 7, 49, 0x00014b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3d0, 281474976710655, 7, 49, 0xa57fffffffffffd0)
	EXT( 0xa5a5a5a5a5a5a3cf, 7, 50, 0xffff4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3cf, 7, 50, 0x00034b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3cf, 562949953421311, 7, 50, 0xa4ffffffffffffcf)
	EXT( 0xa5a5a5a5a5a5a3ce, 7, 51, 0x00034b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3ce, 7, 51, 0x00034b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3ce, 1125899906842623, 7, 51, 0xa5ffffffffffffce)
	EXT( 0xa5a5a5a5a5a5a3cd, 7, 52, 0xfffb4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3cd, 7, 52, 0x000b4b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3cd, 2251799813685247, 7, 52, 0xa3ffffffffffffcd)
	EXT( 0xa5a5a5a5a5a5a3cc, 7, 53, 0x000b4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3cc, 7, 53, 0x000b4b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3cc, 4503599627370495, 7, 53, 0xa7ffffffffffffcc)
	EXT( 0xa5a5a5a5a5a5a3cb, 7, 54, 0x000b4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3cb, 7, 54, 0x000b4b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3cb, 9007199254740991, 7, 54, 0xafffffffffffffcb)
	EXT( 0xa5a5a5a5a5a5a3ca, 7, 55, 0xffcb4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3ca, 7, 55, 0x004b4b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3ca, 18014398509481983, 7, 55, 0x9fffffffffffffca)
	EXT( 0xa5a5a5a5a5a5a3c9, 7, 56, 0x004b4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3c9, 7, 56, 0x004b4b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3c9, 36028797018963967, 7, 56, 0xbfffffffffffffc9)
	EXT( 0xa5a5a5a5a5a5a3c8, 8, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a3c8, 8, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a3c8, 0, 8, 1, 0xa5a5a5a5a5a5a2c8)
	EXT( 0xa5a5a5a5a5a5a3c7, 8, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a3c7, 8, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a3c7, 1, 8, 2, 0xa5a5a5a5a5a5a1c7)
	EXT( 0xa5a5a5a5a5a5a3c6, 8, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a3c6, 8, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a3c6, 3, 8, 3, 0xa5a5a5a5a5a5a3c6)
	EXT( 0xa5a5a5a5a5a5a3c5, 8, 4, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a3c5, 8, 4, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a3c5, 7, 8, 4, 0xa5a5a5a5a5a5a7c5)
	EXT( 0xa5a5a5a5a5a5a3c4, 8, 5, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a3c4, 8, 5, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a3c4, 15, 8, 5, 0xa5a5a5a5a5a5afc4)
	EXT( 0xa5a5a5a5a5a5a3c3, 8, 6, 0xffffffffffffffe3)
	EXTU(0xa5a5a5a5a5a5a3c3, 8, 6, 0x0000000000000023)
	DEP( 0xa5a5a5a5a5a5a3c3, 31, 8, 6, 0xa5a5a5a5a5a59fc3)
	EXT( 0xa5a5a5a5a5a5a3c2, 8, 7, 0x0000000000000023)
	EXTU(0xa5a5a5a5a5a5a3c2, 8, 7, 0x0000000000000023)
	DEP( 0xa5a5a5a5a5a5a3c2, 63, 8, 7, 0xa5a5a5a5a5a5bfc2)
	EXT( 0xa5a5a5a5a5a5a3c1, 8, 8, 0xffffffffffffffa3)
	EXTU(0xa5a5a5a5a5a5a3c1, 8, 8, 0x00000000000000a3)
	DEP( 0xa5a5a5a5a5a5a3c1, 127, 8, 8, 0xa5a5a5a5a5a57fc1)
	EXT( 0xa5a5a5a5a5a5a3c0, 8, 9, 0xffffffffffffffa3)
	EXTU(0xa5a5a5a5a5a5a3c0, 8, 9, 0x00000000000001a3)
	DEP( 0xa5a5a5a5a5a5a3c0, 255, 8, 9, 0xa5a5a5a5a5a4ffc0)
	EXT( 0xa5a5a5a5a5a5a3bf, 8, 10, 0x00000000000001a3)
	EXTU(0xa5a5a5a5a5a5a3bf, 8, 10, 0x00000000000001a3)
	DEP( 0xa5a5a5a5a5a5a3bf, 511, 8, 10, 0xa5a5a5a5a5a5ffbf)
	EXT( 0xa5a5a5a5a5a5a3be, 8, 11, 0xfffffffffffffda3)
	EXTU(0xa5a5a5a5a5a5a3be, 8, 11, 0x00000000000005a3)
	DEP( 0xa5a5a5a5a5a5a3be, 1023, 8, 11, 0xa5a5a5a5a5a3ffbe)
	EXT( 0xa5a5a5a5a5a5a3bd, 8, 12, 0x00000000000005a3)
	EXTU(0xa5a5a5a5a5a5a3bd, 8, 12, 0x00000000000005a3)
	DEP( 0xa5a5a5a5a5a5a3bd, 2047, 8, 12, 0xa5a5a5a5a5a7ffbd)
	EXT( 0xa5a5a5a5a5a5a3bc, 8, 13, 0x00000000000005a3)
	EXTU(0xa5a5a5a5a5a5a3bc, 8, 13, 0x00000000000005a3)
	DEP( 0xa5a5a5a5a5a5a3bc, 4095, 8, 13, 0xa5a5a5a5a5afffbc)
	EXT( 0xa5a5a5a5a5a5a3bb, 8, 14, 0xffffffffffffe5a3)
	EXTU(0xa5a5a5a5a5a5a3bb, 8, 14, 0x00000000000025a3)
	DEP( 0xa5a5a5a5a5a5a3bb, 8191, 8, 14, 0xa5a5a5a5a59fffbb)
	EXT( 0xa5a5a5a5a5a5a3ba, 8, 15, 0x00000000000025a3)
	EXTU(0xa5a5a5a5a5a5a3ba, 8, 15, 0x00000000000025a3)
	DEP( 0xa5a5a5a5a5a5a3ba, 16383, 8, 15, 0xa5a5a5a5a5bfffba)
	EXT( 0xa5a5a5a5a5a5a3b9, 8, 16, 0xffffffffffffa5a3)
	EXTU(0xa5a5a5a5a5a5a3b9, 8, 16, 0x000000000000a5a3)
	DEP( 0xa5a5a5a5a5a5a3b9, 32767, 8, 16, 0xa5a5a5a5a57fffb9)
	EXT( 0xa5a5a5a5a5a5a3b8, 8, 17, 0xffffffffffffa5a3)
	EXTU(0xa5a5a5a5a5a5a3b8, 8, 17, 0x000000000001a5a3)
	DEP( 0xa5a5a5a5a5a5a3b8, 65535, 8, 17, 0xa5a5a5a5a4ffffb8)
	EXT( 0xa5a5a5a5a5a5a3b7, 8, 18, 0x000000000001a5a3)
	EXTU(0xa5a5a5a5a5a5a3b7, 8, 18, 0x000000000001a5a3)
	DEP( 0xa5a5a5a5a5a5a3b7, 131071, 8, 18, 0xa5a5a5a5a5ffffb7)
	EXT( 0xa5a5a5a5a5a5a3b6, 8, 19, 0xfffffffffffda5a3)
	EXTU(0xa5a5a5a5a5a5a3b6, 8, 19, 0x000000000005a5a3)
	DEP( 0xa5a5a5a5a5a5a3b6, 262143, 8, 19, 0xa5a5a5a5a3ffffb6)
	EXT( 0xa5a5a5a5a5a5a3b5, 8, 20, 0x000000000005a5a3)
	EXTU(0xa5a5a5a5a5a5a3b5, 8, 20, 0x000000000005a5a3)
	DEP( 0xa5a5a5a5a5a5a3b5, 524287, 8, 20, 0xa5a5a5a5a7ffffb5)
	EXT( 0xa5a5a5a5a5a5a3b4, 8, 21, 0x000000000005a5a3)
	EXTU(0xa5a5a5a5a5a5a3b4, 8, 21, 0x000000000005a5a3)
	DEP( 0xa5a5a5a5a5a5a3b4, 1048575, 8, 21, 0xa5a5a5a5afffffb4)
	EXT( 0xa5a5a5a5a5a5a3b3, 8, 22, 0xffffffffffe5a5a3)
	EXTU(0xa5a5a5a5a5a5a3b3, 8, 22, 0x000000000025a5a3)
	DEP( 0xa5a5a5a5a5a5a3b3, 2097151, 8, 22, 0xa5a5a5a59fffffb3)
	EXT( 0xa5a5a5a5a5a5a3b2, 8, 23, 0x000000000025a5a3)
	EXTU(0xa5a5a5a5a5a5a3b2, 8, 23, 0x000000000025a5a3)
	DEP( 0xa5a5a5a5a5a5a3b2, 4194303, 8, 23, 0xa5a5a5a5bfffffb2)
	EXT( 0xa5a5a5a5a5a5a3b1, 8, 24, 0xffffffffffa5a5a3)
	EXTU(0xa5a5a5a5a5a5a3b1, 8, 24, 0x0000000000a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3b1, 8388607, 8, 24, 0xa5a5a5a57fffffb1)
	EXT( 0xa5a5a5a5a5a5a3b0, 8, 25, 0xffffffffffa5a5a3)
	EXTU(0xa5a5a5a5a5a5a3b0, 8, 25, 0x0000000001a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3b0, 16777215, 8, 25, 0xa5a5a5a4ffffffb0)
	EXT( 0xa5a5a5a5a5a5a3af, 8, 26, 0x0000000001a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3af, 8, 26, 0x0000000001a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3af, 33554431, 8, 26, 0xa5a5a5a5ffffffaf)
	EXT( 0xa5a5a5a5a5a5a3ae, 8, 27, 0xfffffffffda5a5a3)
	EXTU(0xa5a5a5a5a5a5a3ae, 8, 27, 0x0000000005a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3ae, 67108863, 8, 27, 0xa5a5a5a3ffffffae)
	EXT( 0xa5a5a5a5a5a5a3ad, 8, 28, 0x0000000005a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3ad, 8, 28, 0x0000000005a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3ad, 134217727, 8, 28, 0xa5a5a5a7ffffffad)
	EXT( 0xa5a5a5a5a5a5a3ac, 8, 29, 0x0000000005a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3ac, 8, 29, 0x0000000005a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3ac, 268435455, 8, 29, 0xa5a5a5afffffffac)
	EXT( 0xa5a5a5a5a5a5a3ab, 8, 30, 0xffffffffe5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3ab, 8, 30, 0x0000000025a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3ab, 536870911, 8, 30, 0xa5a5a59fffffffab)
	EXT( 0xa5a5a5a5a5a5a3aa, 8, 31, 0x0000000025a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3aa, 8, 31, 0x0000000025a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3aa, 1073741823, 8, 31, 0xa5a5a5bfffffffaa)
	EXT( 0xa5a5a5a5a5a5a3a9, 8, 32, 0xffffffffa5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a9, 8, 32, 0x00000000a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a9, 2147483647, 8, 32, 0xa5a5a57fffffffa9)
	EXT( 0xa5a5a5a5a5a5a3a8, 8, 33, 0xffffffffa5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a8, 8, 33, 0x00000001a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a8, 4294967295, 8, 33, 0xa5a5a4ffffffffa8)
	EXT( 0xa5a5a5a5a5a5a3a7, 8, 34, 0x00000001a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a7, 8, 34, 0x00000001a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a7, 8589934591, 8, 34, 0xa5a5a5ffffffffa7)
	EXT( 0xa5a5a5a5a5a5a3a6, 8, 35, 0xfffffffda5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a6, 8, 35, 0x00000005a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a6, 17179869183, 8, 35, 0xa5a5a3ffffffffa6)
	EXT( 0xa5a5a5a5a5a5a3a5, 8, 36, 0x00000005a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a5, 8, 36, 0x00000005a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a5, 34359738367, 8, 36, 0xa5a5a7ffffffffa5)
	EXT( 0xa5a5a5a5a5a5a3a4, 8, 37, 0x00000005a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a4, 8, 37, 0x00000005a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a4, 68719476735, 8, 37, 0xa5a5afffffffffa4)
	EXT( 0xa5a5a5a5a5a5a3a3, 8, 38, 0xffffffe5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a3, 8, 38, 0x00000025a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a3, 137438953471, 8, 38, 0xa5a59fffffffffa3)
	EXT( 0xa5a5a5a5a5a5a3a2, 8, 39, 0x00000025a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a2, 8, 39, 0x00000025a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a2, 274877906943, 8, 39, 0xa5a5bfffffffffa2)
	EXT( 0xa5a5a5a5a5a5a3a1, 8, 40, 0xffffffa5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a1, 8, 40, 0x000000a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a1, 549755813887, 8, 40, 0xa5a57fffffffffa1)
	EXT( 0xa5a5a5a5a5a5a3a0, 8, 41, 0xffffffa5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3a0, 8, 41, 0x000001a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3a0, 1099511627775, 8, 41, 0xa5a4ffffffffffa0)
	EXT( 0xa5a5a5a5a5a5a39f, 8, 42, 0x000001a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a39f, 8, 42, 0x000001a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a39f, 2199023255551, 8, 42, 0xa5a5ffffffffff9f)
	EXT( 0xa5a5a5a5a5a5a39e, 8, 43, 0xfffffda5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a39e, 8, 43, 0x000005a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a39e, 4398046511103, 8, 43, 0xa5a3ffffffffff9e)
	EXT( 0xa5a5a5a5a5a5a39d, 8, 44, 0x000005a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a39d, 8, 44, 0x000005a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a39d, 8796093022207, 8, 44, 0xa5a7ffffffffff9d)
	EXT( 0xa5a5a5a5a5a5a39c, 8, 45, 0x000005a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a39c, 8, 45, 0x000005a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a39c, 17592186044415, 8, 45, 0xa5afffffffffff9c)
	EXT( 0xa5a5a5a5a5a5a39b, 8, 46, 0xffffe5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a39b, 8, 46, 0x000025a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a39b, 35184372088831, 8, 46, 0xa59fffffffffff9b)
	EXT( 0xa5a5a5a5a5a5a39a, 8, 47, 0x000025a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a39a, 8, 47, 0x000025a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a39a, 70368744177663, 8, 47, 0xa5bfffffffffff9a)
	EXT( 0xa5a5a5a5a5a5a399, 8, 48, 0xffffa5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a399, 8, 48, 0x0000a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a399, 140737488355327, 8, 48, 0xa57fffffffffff99)
	EXT( 0xa5a5a5a5a5a5a398, 8, 49, 0xffffa5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a398, 8, 49, 0x0001a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a398, 281474976710655, 8, 49, 0xa4ffffffffffff98)
	EXT( 0xa5a5a5a5a5a5a397, 8, 50, 0x0001a5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a397, 8, 50, 0x0001a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a397, 562949953421311, 8, 50, 0xa5ffffffffffff97)
	EXT( 0xa5a5a5a5a5a5a396, 8, 51, 0xfffda5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a396, 8, 51, 0x0005a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a396, 1125899906842623, 8, 51, 0xa3ffffffffffff96)
	EXT( 0xa5a5a5a5a5a5a395, 8, 52, 0x0005a5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a395, 8, 52, 0x0005a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a395, 2251799813685247, 8, 52, 0xa7ffffffffffff95)
	EXT( 0xa5a5a5a5a5a5a394, 8, 53, 0x0005a5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a394, 8, 53, 0x0005a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a394, 4503599627370495, 8, 53, 0xafffffffffffff94)
	EXT( 0xa5a5a5a5a5a5a393, 8, 54, 0xffe5a5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a393, 8, 54, 0x0025a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a393, 9007199254740991, 8, 54, 0x9fffffffffffff93)
	EXT( 0xa5a5a5a5a5a5a392, 8, 55, 0x0025a5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a392, 8, 55, 0x0025a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a392, 18014398509481983, 8, 55, 0xbfffffffffffff92)
	EXT( 0xa5a5a5a5a5a5a391, 9, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a391, 9, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a391, 0, 9, 1, 0xa5a5a5a5a5a5a191)
	EXT( 0xa5a5a5a5a5a5a390, 9, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a390, 9, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a390, 1, 9, 2, 0xa5a5a5a5a5a5a390)
	EXT( 0xa5a5a5a5a5a5a38f, 9, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a38f, 9, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a38f, 3, 9, 3, 0xa5a5a5a5a5a5a78f)
	EXT( 0xa5a5a5a5a5a5a38e, 9, 4, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a38e, 9, 4, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a38e, 7, 9, 4, 0xa5a5a5a5a5a5af8e)
	EXT( 0xa5a5a5a5a5a5a38d, 9, 5, 0xfffffffffffffff1)
	EXTU(0xa5a5a5a5a5a5a38d, 9, 5, 0x0000000000000011)
	DEP( 0xa5a5a5a5a5a5a38d, 15, 9, 5, 0xa5a5a5a5a5a59f8d)
	EXT( 0xa5a5a5a5a5a5a38c, 9, 6, 0x0000000000000011)
	EXTU(0xa5a5a5a5a5a5a38c, 9, 6, 0x0000000000000011)
	DEP( 0xa5a5a5a5a5a5a38c, 31, 9, 6, 0xa5a5a5a5a5a5bf8c)
	EXT( 0xa5a5a5a5a5a5a38b, 9, 7, 0xffffffffffffffd1)
	EXTU(0xa5a5a5a5a5a5a38b, 9, 7, 0x0000000000000051)
	DEP( 0xa5a5a5a5a5a5a38b, 63, 9, 7, 0xa5a5a5a5a5a57f8b)
	EXT( 0xa5a5a5a5a5a5a38a, 9, 8, 0xffffffffffffffd1)
	EXTU(0xa5a5a5a5a5a5a38a, 9, 8, 0x00000000000000d1)
	DEP( 0xa5a5a5a5a5a5a38a, 127, 9, 8, 0xa5a5a5a5a5a4ff8a)
	EXT( 0xa5a5a5a5a5a5a389, 9, 9, 0x00000000000000d1)
	EXTU(0xa5a5a5a5a5a5a389, 9, 9, 0x00000000000000d1)
	DEP( 0xa5a5a5a5a5a5a389, 255, 9, 9, 0xa5a5a5a5a5a5ff89)
	EXT( 0xa5a5a5a5a5a5a388, 9, 10, 0xfffffffffffffed1)
	EXTU(0xa5a5a5a5a5a5a388, 9, 10, 0x00000000000002d1)
	DEP( 0xa5a5a5a5a5a5a388, 511, 9, 10, 0xa5a5a5a5a5a3ff88)
	EXT( 0xa5a5a5a5a5a5a387, 9, 11, 0x00000000000002d1)
	EXTU(0xa5a5a5a5a5a5a387, 9, 11, 0x00000000000002d1)
	DEP( 0xa5a5a5a5a5a5a387, 1023, 9, 11, 0xa5a5a5a5a5a7ff87)
	EXT( 0xa5a5a5a5a5a5a386, 9, 12, 0x00000000000002d1)
	EXTU(0xa5a5a5a5a5a5a386, 9, 12, 0x00000000000002d1)
	DEP( 0xa5a5a5a5a5a5a386, 2047, 9, 12, 0xa5a5a5a5a5afff86)
	EXT( 0xa5a5a5a5a5a5a385, 9, 13, 0xfffffffffffff2d1)
	EXTU(0xa5a5a5a5a5a5a385, 9, 13, 0x00000000000012d1)
	DEP( 0xa5a5a5a5a5a5a385, 4095, 9, 13, 0xa5a5a5a5a59fff85)
	EXT( 0xa5a5a5a5a5a5a384, 9, 14, 0x00000000000012d1)
	EXTU(0xa5a5a5a5a5a5a384, 9, 14, 0x00000000000012d1)
	DEP( 0xa5a5a5a5a5a5a384, 8191, 9, 14, 0xa5a5a5a5a5bfff84)
	EXT( 0xa5a5a5a5a5a5a383, 9, 15, 0xffffffffffffd2d1)
	EXTU(0xa5a5a5a5a5a5a383, 9, 15, 0x00000000000052d1)
	DEP( 0xa5a5a5a5a5a5a383, 16383, 9, 15, 0xa5a5a5a5a57fff83)
	EXT( 0xa5a5a5a5a5a5a382, 9, 16, 0xffffffffffffd2d1)
	EXTU(0xa5a5a5a5a5a5a382, 9, 16, 0x000000000000d2d1)
	DEP( 0xa5a5a5a5a5a5a382, 32767, 9, 16, 0xa5a5a5a5a4ffff82)
	EXT( 0xa5a5a5a5a5a5a381, 9, 17, 0x000000000000d2d1)
	EXTU(0xa5a5a5a5a5a5a381, 9, 17, 0x000000000000d2d1)
	DEP( 0xa5a5a5a5a5a5a381, 65535, 9, 17, 0xa5a5a5a5a5ffff81)
	EXT( 0xa5a5a5a5a5a5a380, 9, 18, 0xfffffffffffed2d1)
	EXTU(0xa5a5a5a5a5a5a380, 9, 18, 0x000000000002d2d1)
	DEP( 0xa5a5a5a5a5a5a380, 131071, 9, 18, 0xa5a5a5a5a3ffff80)
	EXT( 0xa5a5a5a5a5a5a37f, 9, 19, 0x000000000002d2d1)
	EXTU(0xa5a5a5a5a5a5a37f, 9, 19, 0x000000000002d2d1)
	DEP( 0xa5a5a5a5a5a5a37f, 262143, 9, 19, 0xa5a5a5a5a7ffff7f)
	EXT( 0xa5a5a5a5a5a5a37e, 9, 20, 0x000000000002d2d1)
	EXTU(0xa5a5a5a5a5a5a37e, 9, 20, 0x000000000002d2d1)
	DEP( 0xa5a5a5a5a5a5a37e, 524287, 9, 20, 0xa5a5a5a5afffff7e)
	EXT( 0xa5a5a5a5a5a5a37d, 9, 21, 0xfffffffffff2d2d1)
	EXTU(0xa5a5a5a5a5a5a37d, 9, 21, 0x000000000012d2d1)
	DEP( 0xa5a5a5a5a5a5a37d, 1048575, 9, 21, 0xa5a5a5a59fffff7d)
	EXT( 0xa5a5a5a5a5a5a37c, 9, 22, 0x000000000012d2d1)
	EXTU(0xa5a5a5a5a5a5a37c, 9, 22, 0x000000000012d2d1)
	DEP( 0xa5a5a5a5a5a5a37c, 2097151, 9, 22, 0xa5a5a5a5bfffff7c)
	EXT( 0xa5a5a5a5a5a5a37b, 9, 23, 0xffffffffffd2d2d1)
	EXTU(0xa5a5a5a5a5a5a37b, 9, 23, 0x000000000052d2d1)
	DEP( 0xa5a5a5a5a5a5a37b, 4194303, 9, 23, 0xa5a5a5a57fffff7b)
	EXT( 0xa5a5a5a5a5a5a37a, 9, 24, 0xffffffffffd2d2d1)
	EXTU(0xa5a5a5a5a5a5a37a, 9, 24, 0x0000000000d2d2d1)
	DEP( 0xa5a5a5a5a5a5a37a, 8388607, 9, 24, 0xa5a5a5a4ffffff7a)
	EXT( 0xa5a5a5a5a5a5a379, 9, 25, 0x0000000000d2d2d1)
	EXTU(0xa5a5a5a5a5a5a379, 9, 25, 0x0000000000d2d2d1)
	DEP( 0xa5a5a5a5a5a5a379, 16777215, 9, 25, 0xa5a5a5a5ffffff79)
	EXT( 0xa5a5a5a5a5a5a378, 9, 26, 0xfffffffffed2d2d1)
	EXTU(0xa5a5a5a5a5a5a378, 9, 26, 0x0000000002d2d2d1)
	DEP( 0xa5a5a5a5a5a5a378, 33554431, 9, 26, 0xa5a5a5a3ffffff78)
	EXT( 0xa5a5a5a5a5a5a377, 9, 27, 0x0000000002d2d2d1)
	EXTU(0xa5a5a5a5a5a5a377, 9, 27, 0x0000000002d2d2d1)
	DEP( 0xa5a5a5a5a5a5a377, 67108863, 9, 27, 0xa5a5a5a7ffffff77)
	EXT( 0xa5a5a5a5a5a5a376, 9, 28, 0x0000000002d2d2d1)
	EXTU(0xa5a5a5a5a5a5a376, 9, 28, 0x0000000002d2d2d1)
	DEP( 0xa5a5a5a5a5a5a376, 134217727, 9, 28, 0xa5a5a5afffffff76)
	EXT( 0xa5a5a5a5a5a5a375, 9, 29, 0xfffffffff2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a375, 9, 29, 0x0000000012d2d2d1)
	DEP( 0xa5a5a5a5a5a5a375, 268435455, 9, 29, 0xa5a5a59fffffff75)
	EXT( 0xa5a5a5a5a5a5a374, 9, 30, 0x0000000012d2d2d1)
	EXTU(0xa5a5a5a5a5a5a374, 9, 30, 0x0000000012d2d2d1)
	DEP( 0xa5a5a5a5a5a5a374, 536870911, 9, 30, 0xa5a5a5bfffffff74)
	EXT( 0xa5a5a5a5a5a5a373, 9, 31, 0xffffffffd2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a373, 9, 31, 0x0000000052d2d2d1)
	DEP( 0xa5a5a5a5a5a5a373, 1073741823, 9, 31, 0xa5a5a57fffffff73)
	EXT( 0xa5a5a5a5a5a5a372, 9, 32, 0xffffffffd2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a372, 9, 32, 0x00000000d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a372, 2147483647, 9, 32, 0xa5a5a4ffffffff72)
	EXT( 0xa5a5a5a5a5a5a371, 9, 33, 0x00000000d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a371, 9, 33, 0x00000000d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a371, 4294967295, 9, 33, 0xa5a5a5ffffffff71)
	EXT( 0xa5a5a5a5a5a5a370, 9, 34, 0xfffffffed2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a370, 9, 34, 0x00000002d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a370, 8589934591, 9, 34, 0xa5a5a3ffffffff70)
	EXT( 0xa5a5a5a5a5a5a36f, 9, 35, 0x00000002d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a36f, 9, 35, 0x00000002d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a36f, 17179869183, 9, 35, 0xa5a5a7ffffffff6f)
	EXT( 0xa5a5a5a5a5a5a36e, 9, 36, 0x00000002d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a36e, 9, 36, 0x00000002d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a36e, 34359738367, 9, 36, 0xa5a5afffffffff6e)
	EXT( 0xa5a5a5a5a5a5a36d, 9, 37, 0xfffffff2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a36d, 9, 37, 0x00000012d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a36d, 68719476735, 9, 37, 0xa5a59fffffffff6d)
	EXT( 0xa5a5a5a5a5a5a36c, 9, 38, 0x00000012d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a36c, 9, 38, 0x00000012d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a36c, 137438953471, 9, 38, 0xa5a5bfffffffff6c)
	EXT( 0xa5a5a5a5a5a5a36b, 9, 39, 0xffffffd2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a36b, 9, 39, 0x00000052d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a36b, 274877906943, 9, 39, 0xa5a57fffffffff6b)
	EXT( 0xa5a5a5a5a5a5a36a, 9, 40, 0xffffffd2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a36a, 9, 40, 0x000000d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a36a, 549755813887, 9, 40, 0xa5a4ffffffffff6a)
	EXT( 0xa5a5a5a5a5a5a369, 9, 41, 0x000000d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a369, 9, 41, 0x000000d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a369, 1099511627775, 9, 41, 0xa5a5ffffffffff69)
	EXT( 0xa5a5a5a5a5a5a368, 9, 42, 0xfffffed2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a368, 9, 42, 0x000002d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a368, 2199023255551, 9, 42, 0xa5a3ffffffffff68)
	EXT( 0xa5a5a5a5a5a5a367, 9, 43, 0x000002d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a367, 9, 43, 0x000002d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a367, 4398046511103, 9, 43, 0xa5a7ffffffffff67)
	EXT( 0xa5a5a5a5a5a5a366, 9, 44, 0x000002d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a366, 9, 44, 0x000002d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a366, 8796093022207, 9, 44, 0xa5afffffffffff66)
	EXT( 0xa5a5a5a5a5a5a365, 9, 45, 0xfffff2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a365, 9, 45, 0x000012d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a365, 17592186044415, 9, 45, 0xa59fffffffffff65)
	EXT( 0xa5a5a5a5a5a5a364, 9, 46, 0x000012d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a364, 9, 46, 0x000012d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a364, 35184372088831, 9, 46, 0xa5bfffffffffff64)
	EXT( 0xa5a5a5a5a5a5a363, 9, 47, 0xffffd2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a363, 9, 47, 0x000052d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a363, 70368744177663, 9, 47, 0xa57fffffffffff63)
	EXT( 0xa5a5a5a5a5a5a362, 9, 48, 0xffffd2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a362, 9, 48, 0x0000d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a362, 140737488355327, 9, 48, 0xa4ffffffffffff62)
	EXT( 0xa5a5a5a5a5a5a361, 9, 49, 0x0000d2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a361, 9, 49, 0x0000d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a361, 281474976710655, 9, 49, 0xa5ffffffffffff61)
	EXT( 0xa5a5a5a5a5a5a360, 9, 50, 0xfffed2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a360, 9, 50, 0x0002d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a360, 562949953421311, 9, 50, 0xa3ffffffffffff60)
	EXT( 0xa5a5a5a5a5a5a35f, 9, 51, 0x0002d2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a35f, 9, 51, 0x0002d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a35f, 1125899906842623, 9, 51, 0xa7ffffffffffff5f)
	EXT( 0xa5a5a5a5a5a5a35e, 9, 52, 0x0002d2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a35e, 9, 52, 0x0002d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a35e, 2251799813685247, 9, 52, 0xafffffffffffff5e)
	EXT( 0xa5a5a5a5a5a5a35d, 9, 53, 0xfff2d2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a35d, 9, 53, 0x0012d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a35d, 4503599627370495, 9, 53, 0x9fffffffffffff5d)
	EXT( 0xa5a5a5a5a5a5a35c, 9, 54, 0x0012d2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a35c, 9, 54, 0x0012d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a35c, 9007199254740991, 9, 54, 0xbfffffffffffff5c)
	EXT( 0xa5a5a5a5a5a5a35b, 10, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a35b, 10, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a35b, 0, 10, 1, 0xa5a5a5a5a5a5a35b)
	EXT( 0xa5a5a5a5a5a5a35a, 10, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a35a, 10, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a35a, 1, 10, 2, 0xa5a5a5a5a5a5a75a)
	EXT( 0xa5a5a5a5a5a5a359, 10, 3, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a359, 10, 3, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a359, 3, 10, 3, 0xa5a5a5a5a5a5af59)
	EXT( 0xa5a5a5a5a5a5a358, 10, 4, 0xfffffffffffffff8)
	EXTU(0xa5a5a5a5a5a5a358, 10, 4, 0x0000000000000008)
	DEP( 0xa5a5a5a5a5a5a358, 7, 10, 4, 0xa5a5a5a5a5a59f58)
	EXT( 0xa5a5a5a5a5a5a357, 10, 5, 0x0000000000000008)
	EXTU(0xa5a5a5a5a5a5a357, 10, 5, 0x0000000000000008)
	DEP( 0xa5a5a5a5a5a5a357, 15, 10, 5, 0xa5a5a5a5a5a5bf57)
	EXT( 0xa5a5a5a5a5a5a356, 10, 6, 0xffffffffffffffe8)
	EXTU(0xa5a5a5a5a5a5a356, 10, 6, 0x0000000000000028)
	DEP( 0xa5a5a5a5a5a5a356, 31, 10, 6, 0xa5a5a5a5a5a57f56)
	EXT( 0xa5a5a5a5a5a5a355, 10, 7, 0xffffffffffffffe8)
	EXTU(0xa5a5a5a5a5a5a355, 10, 7, 0x0000000000000068)
	DEP( 0xa5a5a5a5a5a5a355, 63, 10, 7, 0xa5a5a5a5a5a4ff55)
	EXT( 0xa5a5a5a5a5a5a354, 10, 8, 0x0000000000000068)
	EXTU(0xa5a5a5a5a5a5a354, 10, 8, 0x0000000000000068)
	DEP( 0xa5a5a5a5a5a5a354, 127, 10, 8, 0xa5a5a5a5a5a5ff54)
	EXT( 0xa5a5a5a5a5a5a353, 10, 9, 0xffffffffffffff68)
	EXTU(0xa5a5a5a5a5a5a353, 10, 9, 0x0000000000000168)
	DEP( 0xa5a5a5a5a5a5a353, 255, 10, 9, 0xa5a5a5a5a5a3ff53)
	EXT( 0xa5a5a5a5a5a5a352, 10, 10, 0x0000000000000168)
	EXTU(0xa5a5a5a5a5a5a352, 10, 10, 0x0000000000000168)
	DEP( 0xa5a5a5a5a5a5a352, 511, 10, 10, 0xa5a5a5a5a5a7ff52)
	EXT( 0xa5a5a5a5a5a5a351, 10, 11, 0x0000000000000168)
	EXTU(0xa5a5a5a5a5a5a351, 10, 11, 0x0000000000000168)
	DEP( 0xa5a5a5a5a5a5a351, 1023, 10, 11, 0xa5a5a5a5a5afff51)
	EXT( 0xa5a5a5a5a5a5a350, 10, 12, 0xfffffffffffff968)
	EXTU(0xa5a5a5a5a5a5a350, 10, 12, 0x0000000000000968)
	DEP( 0xa5a5a5a5a5a5a350, 2047, 10, 12, 0xa5a5a5a5a59fff50)
	EXT( 0xa5a5a5a5a5a5a34f, 10, 13, 0x0000000000000968)
	EXTU(0xa5a5a5a5a5a5a34f, 10, 13, 0x0000000000000968)
	DEP( 0xa5a5a5a5a5a5a34f, 4095, 10, 13, 0xa5a5a5a5a5bfff4f)
	EXT( 0xa5a5a5a5a5a5a34e, 10, 14, 0xffffffffffffe968)
	EXTU(0xa5a5a5a5a5a5a34e, 10, 14, 0x0000000000002968)
	DEP( 0xa5a5a5a5a5a5a34e, 8191, 10, 14, 0xa5a5a5a5a57fff4e)
	EXT( 0xa5a5a5a5a5a5a34d, 10, 15, 0xffffffffffffe968)
	EXTU(0xa5a5a5a5a5a5a34d, 10, 15, 0x0000000000006968)
	DEP( 0xa5a5a5a5a5a5a34d, 16383, 10, 15, 0xa5a5a5a5a4ffff4d)
	EXT( 0xa5a5a5a5a5a5a34c, 10, 16, 0x0000000000006968)
	EXTU(0xa5a5a5a5a5a5a34c, 10, 16, 0x0000000000006968)
	DEP( 0xa5a5a5a5a5a5a34c, 32767, 10, 16, 0xa5a5a5a5a5ffff4c)
	EXT( 0xa5a5a5a5a5a5a34b, 10, 17, 0xffffffffffff6968)
	EXTU(0xa5a5a5a5a5a5a34b, 10, 17, 0x0000000000016968)
	DEP( 0xa5a5a5a5a5a5a34b, 65535, 10, 17, 0xa5a5a5a5a3ffff4b)
	EXT( 0xa5a5a5a5a5a5a34a, 10, 18, 0x0000000000016968)
	EXTU(0xa5a5a5a5a5a5a34a, 10, 18, 0x0000000000016968)
	DEP( 0xa5a5a5a5a5a5a34a, 131071, 10, 18, 0xa5a5a5a5a7ffff4a)
	EXT( 0xa5a5a5a5a5a5a349, 10, 19, 0x0000000000016968)
	EXTU(0xa5a5a5a5a5a5a349, 10, 19, 0x0000000000016968)
	DEP( 0xa5a5a5a5a5a5a349, 262143, 10, 19, 0xa5a5a5a5afffff49)
	EXT( 0xa5a5a5a5a5a5a348, 10, 20, 0xfffffffffff96968)
	EXTU(0xa5a5a5a5a5a5a348, 10, 20, 0x0000000000096968)
	DEP( 0xa5a5a5a5a5a5a348, 524287, 10, 20, 0xa5a5a5a59fffff48)
	EXT( 0xa5a5a5a5a5a5a347, 10, 21, 0x0000000000096968)
	EXTU(0xa5a5a5a5a5a5a347, 10, 21, 0x0000000000096968)
	DEP( 0xa5a5a5a5a5a5a347, 1048575, 10, 21, 0xa5a5a5a5bfffff47)
	EXT( 0xa5a5a5a5a5a5a346, 10, 22, 0xffffffffffe96968)
	EXTU(0xa5a5a5a5a5a5a346, 10, 22, 0x0000000000296968)
	DEP( 0xa5a5a5a5a5a5a346, 2097151, 10, 22, 0xa5a5a5a57fffff46)
	EXT( 0xa5a5a5a5a5a5a345, 10, 23, 0xffffffffffe96968)
	EXTU(0xa5a5a5a5a5a5a345, 10, 23, 0x0000000000696968)
	DEP( 0xa5a5a5a5a5a5a345, 4194303, 10, 23, 0xa5a5a5a4ffffff45)
	EXT( 0xa5a5a5a5a5a5a344, 10, 24, 0x0000000000696968)
	EXTU(0xa5a5a5a5a5a5a344, 10, 24, 0x0000000000696968)
	DEP( 0xa5a5a5a5a5a5a344, 8388607, 10, 24, 0xa5a5a5a5ffffff44)
	EXT( 0xa5a5a5a5a5a5a343, 10, 25, 0xffffffffff696968)
	EXTU(0xa5a5a5a5a5a5a343, 10, 25, 0x0000000001696968)
	DEP( 0xa5a5a5a5a5a5a343, 16777215, 10, 25, 0xa5a5a5a3ffffff43)
	EXT( 0xa5a5a5a5a5a5a342, 10, 26, 0x0000000001696968)
	EXTU(0xa5a5a5a5a5a5a342, 10, 26, 0x0000000001696968)
	DEP( 0xa5a5a5a5a5a5a342, 33554431, 10, 26, 0xa5a5a5a7ffffff42)
	EXT( 0xa5a5a5a5a5a5a341, 10, 27, 0x0000000001696968)
	EXTU(0xa5a5a5a5a5a5a341, 10, 27, 0x0000000001696968)
	DEP( 0xa5a5a5a5a5a5a341, 67108863, 10, 27, 0xa5a5a5afffffff41)
	EXT( 0xa5a5a5a5a5a5a340, 10, 28, 0xfffffffff9696968)
	EXTU(0xa5a5a5a5a5a5a340, 10, 28, 0x0000000009696968)
	DEP( 0xa5a5a5a5a5a5a340, 134217727, 10, 28, 0xa5a5a59fffffff40)
	EXT( 0xa5a5a5a5a5a5a33f, 10, 29, 0x0000000009696968)
	EXTU(0xa5a5a5a5a5a5a33f, 10, 29, 0x0000000009696968)
	DEP( 0xa5a5a5a5a5a5a33f, 268435455, 10, 29, 0xa5a5a5bfffffff3f)
	EXT( 0xa5a5a5a5a5a5a33e, 10, 30, 0xffffffffe9696968)
	EXTU(0xa5a5a5a5a5a5a33e, 10, 30, 0x0000000029696968)
	DEP( 0xa5a5a5a5a5a5a33e, 536870911, 10, 30, 0xa5a5a57fffffff3e)
	EXT( 0xa5a5a5a5a5a5a33d, 10, 31, 0xffffffffe9696968)
	EXTU(0xa5a5a5a5a5a5a33d, 10, 31, 0x0000000069696968)
	DEP( 0xa5a5a5a5a5a5a33d, 1073741823, 10, 31, 0xa5a5a4ffffffff3d)
	EXT( 0xa5a5a5a5a5a5a33c, 10, 32, 0x0000000069696968)
	EXTU(0xa5a5a5a5a5a5a33c, 10, 32, 0x0000000069696968)
	DEP( 0xa5a5a5a5a5a5a33c, 2147483647, 10, 32, 0xa5a5a5ffffffff3c)
	EXT( 0xa5a5a5a5a5a5a33b, 10, 33, 0xffffffff69696968)
	EXTU(0xa5a5a5a5a5a5a33b, 10, 33, 0x0000000169696968)
	DEP( 0xa5a5a5a5a5a5a33b, 4294967295, 10, 33, 0xa5a5a3ffffffff3b)
	EXT( 0xa5a5a5a5a5a5a33a, 10, 34, 0x0000000169696968)
	EXTU(0xa5a5a5a5a5a5a33a, 10, 34, 0x0000000169696968)
	DEP( 0xa5a5a5a5a5a5a33a, 8589934591, 10, 34, 0xa5a5a7ffffffff3a)
	EXT( 0xa5a5a5a5a5a5a339, 10, 35, 0x0000000169696968)
	EXTU(0xa5a5a5a5a5a5a339, 10, 35, 0x0000000169696968)
	DEP( 0xa5a5a5a5a5a5a339, 17179869183, 10, 35, 0xa5a5afffffffff39)
	EXT( 0xa5a5a5a5a5a5a338, 10, 36, 0xfffffff969696968)
	EXTU(0xa5a5a5a5a5a5a338, 10, 36, 0x0000000969696968)
	DEP( 0xa5a5a5a5a5a5a338, 34359738367, 10, 36, 0xa5a59fffffffff38)
	EXT( 0xa5a5a5a5a5a5a337, 10, 37, 0x0000000969696968)
	EXTU(0xa5a5a5a5a5a5a337, 10, 37, 0x0000000969696968)
	DEP( 0xa5a5a5a5a5a5a337, 68719476735, 10, 37, 0xa5a5bfffffffff37)
	EXT( 0xa5a5a5a5a5a5a336, 10, 38, 0xffffffe969696968)
	EXTU(0xa5a5a5a5a5a5a336, 10, 38, 0x0000002969696968)
	DEP( 0xa5a5a5a5a5a5a336, 137438953471, 10, 38, 0xa5a57fffffffff36)
	EXT( 0xa5a5a5a5a5a5a335, 10, 39, 0xffffffe969696968)
	EXTU(0xa5a5a5a5a5a5a335, 10, 39, 0x0000006969696968)
	DEP( 0xa5a5a5a5a5a5a335, 274877906943, 10, 39, 0xa5a4ffffffffff35)
	EXT( 0xa5a5a5a5a5a5a334, 10, 40, 0x0000006969696968)
	EXTU(0xa5a5a5a5a5a5a334, 10, 40, 0x0000006969696968)
	DEP( 0xa5a5a5a5a5a5a334, 549755813887, 10, 40, 0xa5a5ffffffffff34)
	EXT( 0xa5a5a5a5a5a5a333, 10, 41, 0xffffff6969696968)
	EXTU(0xa5a5a5a5a5a5a333, 10, 41, 0x0000016969696968)
	DEP( 0xa5a5a5a5a5a5a333, 1099511627775, 10, 41, 0xa5a3ffffffffff33)
	EXT( 0xa5a5a5a5a5a5a332, 10, 42, 0x0000016969696968)
	EXTU(0xa5a5a5a5a5a5a332, 10, 42, 0x0000016969696968)
	DEP( 0xa5a5a5a5a5a5a332, 2199023255551, 10, 42, 0xa5a7ffffffffff32)
	EXT( 0xa5a5a5a5a5a5a331, 10, 43, 0x0000016969696968)
	EXTU(0xa5a5a5a5a5a5a331, 10, 43, 0x0000016969696968)
	DEP( 0xa5a5a5a5a5a5a331, 4398046511103, 10, 43, 0xa5afffffffffff31)
	EXT( 0xa5a5a5a5a5a5a330, 10, 44, 0xfffff96969696968)
	EXTU(0xa5a5a5a5a5a5a330, 10, 44, 0x0000096969696968)
	DEP( 0xa5a5a5a5a5a5a330, 8796093022207, 10, 44, 0xa59fffffffffff30)
	EXT( 0xa5a5a5a5a5a5a32f, 10, 45, 0x0000096969696968)
	EXTU(0xa5a5a5a5a5a5a32f, 10, 45, 0x0000096969696968)
	DEP( 0xa5a5a5a5a5a5a32f, 17592186044415, 10, 45, 0xa5bfffffffffff2f)
	EXT( 0xa5a5a5a5a5a5a32e, 10, 46, 0xffffe96969696968)
	EXTU(0xa5a5a5a5a5a5a32e, 10, 46, 0x0000296969696968)
	DEP( 0xa5a5a5a5a5a5a32e, 35184372088831, 10, 46, 0xa57fffffffffff2e)
	EXT( 0xa5a5a5a5a5a5a32d, 10, 47, 0xffffe96969696968)
	EXTU(0xa5a5a5a5a5a5a32d, 10, 47, 0x0000696969696968)
	DEP( 0xa5a5a5a5a5a5a32d, 70368744177663, 10, 47, 0xa4ffffffffffff2d)
	EXT( 0xa5a5a5a5a5a5a32c, 10, 48, 0x0000696969696968)
	EXTU(0xa5a5a5a5a5a5a32c, 10, 48, 0x0000696969696968)
	DEP( 0xa5a5a5a5a5a5a32c, 140737488355327, 10, 48, 0xa5ffffffffffff2c)
	EXT( 0xa5a5a5a5a5a5a32b, 10, 49, 0xffff696969696968)
	EXTU(0xa5a5a5a5a5a5a32b, 10, 49, 0x0001696969696968)
	DEP( 0xa5a5a5a5a5a5a32b, 281474976710655, 10, 49, 0xa3ffffffffffff2b)
	EXT( 0xa5a5a5a5a5a5a32a, 10, 50, 0x0001696969696968)
	EXTU(0xa5a5a5a5a5a5a32a, 10, 50, 0x0001696969696968)
	DEP( 0xa5a5a5a5a5a5a32a, 562949953421311, 10, 50, 0xa7ffffffffffff2a)
	EXT( 0xa5a5a5a5a5a5a329, 10, 51, 0x0001696969696968)
	EXTU(0xa5a5a5a5a5a5a329, 10, 51, 0x0001696969696968)
	DEP( 0xa5a5a5a5a5a5a329, 1125899906842623, 10, 51, 0xafffffffffffff29)
	EXT( 0xa5a5a5a5a5a5a328, 10, 52, 0xfff9696969696968)
	EXTU(0xa5a5a5a5a5a5a328, 10, 52, 0x0009696969696968)
	DEP( 0xa5a5a5a5a5a5a328, 2251799813685247, 10, 52, 0x9fffffffffffff28)
	EXT( 0xa5a5a5a5a5a5a327, 10, 53, 0x0009696969696968)
	EXTU(0xa5a5a5a5a5a5a327, 10, 53, 0x0009696969696968)
	DEP( 0xa5a5a5a5a5a5a327, 4503599627370495, 10, 53, 0xbfffffffffffff27)
	EXT( 0xa5a5a5a5a5a5a326, 11, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a326, 11, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a326, 0, 11, 1, 0xa5a5a5a5a5a5a326)
	EXT( 0xa5a5a5a5a5a5a325, 11, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a325, 11, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a325, 1, 11, 2, 0xa5a5a5a5a5a5ab25)
	EXT( 0xa5a5a5a5a5a5a324, 11, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a324, 11, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a324, 3, 11, 3, 0xa5a5a5a5a5a59b24)
	EXT( 0xa5a5a5a5a5a5a323, 11, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a5a323, 11, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a323, 7, 11, 4, 0xa5a5a5a5a5a5bb23)
	EXT( 0xa5a5a5a5a5a5a322, 11, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a322, 11, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a5a322, 15, 11, 5, 0xa5a5a5a5a5a57b22)
	EXT( 0xa5a5a5a5a5a5a321, 11, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a321, 11, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a321, 31, 11, 6, 0xa5a5a5a5a5a4fb21)
	EXT( 0xa5a5a5a5a5a5a320, 11, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a5a320, 11, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a320, 63, 11, 7, 0xa5a5a5a5a5a5fb20)
	EXT( 0xa5a5a5a5a5a5a31f, 11, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a5a31f, 11, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a31f, 127, 11, 8, 0xa5a5a5a5a5a3fb1f)
	EXT( 0xa5a5a5a5a5a5a31e, 11, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a31e, 11, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a31e, 255, 11, 9, 0xa5a5a5a5a5a7fb1e)
	EXT( 0xa5a5a5a5a5a5a31d, 11, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a31d, 11, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a31d, 511, 11, 10, 0xa5a5a5a5a5affb1d)
	EXT( 0xa5a5a5a5a5a5a31c, 11, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a5a31c, 11, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a31c, 1023, 11, 11, 0xa5a5a5a5a59ffb1c)
	EXT( 0xa5a5a5a5a5a5a31b, 11, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a5a31b, 11, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a31b, 2047, 11, 12, 0xa5a5a5a5a5bffb1b)
	EXT( 0xa5a5a5a5a5a5a31a, 11, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a31a, 11, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a5a31a, 4095, 11, 13, 0xa5a5a5a5a57ffb1a)
	EXT( 0xa5a5a5a5a5a5a319, 11, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a319, 11, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a319, 8191, 11, 14, 0xa5a5a5a5a4fffb19)
	EXT( 0xa5a5a5a5a5a5a318, 11, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a5a318, 11, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a318, 16383, 11, 15, 0xa5a5a5a5a5fffb18)
	EXT( 0xa5a5a5a5a5a5a317, 11, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a5a317, 11, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a317, 32767, 11, 16, 0xa5a5a5a5a3fffb17)
	EXT( 0xa5a5a5a5a5a5a316, 11, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a316, 11, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a316, 65535, 11, 17, 0xa5a5a5a5a7fffb16)
	EXT( 0xa5a5a5a5a5a5a315, 11, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a315, 11, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a315, 131071, 11, 18, 0xa5a5a5a5affffb15)
	EXT( 0xa5a5a5a5a5a5a314, 11, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a5a314, 11, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a314, 262143, 11, 19, 0xa5a5a5a59ffffb14)
	EXT( 0xa5a5a5a5a5a5a313, 11, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a5a313, 11, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a313, 524287, 11, 20, 0xa5a5a5a5bffffb13)
	EXT( 0xa5a5a5a5a5a5a312, 11, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a312, 11, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a5a312, 1048575, 11, 21, 0xa5a5a5a57ffffb12)
	EXT( 0xa5a5a5a5a5a5a311, 11, 22, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a311, 11, 22, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a311, 2097151, 11, 22, 0xa5a5a5a4fffffb11)
	EXT( 0xa5a5a5a5a5a5a310, 11, 23, 0x000000000034b4b4)
	EXTU(0xa5a5a5a5a5a5a310, 11, 23, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a310, 4194303, 11, 23, 0xa5a5a5a5fffffb10)
	EXT( 0xa5a5a5a5a5a5a30f, 11, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a5a30f, 11, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a30f, 8388607, 11, 24, 0xa5a5a5a3fffffb0f)
	EXT( 0xa5a5a5a5a5a5a30e, 11, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a30e, 11, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a30e, 16777215, 11, 25, 0xa5a5a5a7fffffb0e)
	EXT( 0xa5a5a5a5a5a5a30d, 11, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a30d, 11, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a30d, 33554431, 11, 26, 0xa5a5a5affffffb0d)
	EXT( 0xa5a5a5a5a5a5a30c, 11, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a5a30c, 11, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a30c, 67108863, 11, 27, 0xa5a5a59ffffffb0c)
	EXT( 0xa5a5a5a5a5a5a30b, 11, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a5a30b, 11, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a30b, 134217727, 11, 28, 0xa5a5a5bffffffb0b)
	EXT( 0xa5a5a5a5a5a5a30a, 11, 29, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a30a, 11, 29, 0x0000000014b4b4b4)
	DEP( 0xa5a5a5a5a5a5a30a, 268435455, 11, 29, 0xa5a5a57ffffffb0a)
	EXT( 0xa5a5a5a5a5a5a309, 11, 30, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a309, 11, 30, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a309, 536870911, 11, 30, 0xa5a5a4fffffffb09)
	EXT( 0xa5a5a5a5a5a5a308, 11, 31, 0x0000000034b4b4b4)
	EXTU(0xa5a5a5a5a5a5a308, 11, 31, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a308, 1073741823, 11, 31, 0xa5a5a5fffffffb08)
	EXT( 0xa5a5a5a5a5a5a307, 11, 32, 0xffffffffb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a307, 11, 32, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a307, 2147483647, 11, 32, 0xa5a5a3fffffffb07)
	EXT( 0xa5a5a5a5a5a5a306, 11, 33, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a306, 11, 33, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a306, 4294967295, 11, 33, 0xa5a5a7fffffffb06)
	EXT( 0xa5a5a5a5a5a5a305, 11, 34, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a305, 11, 34, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a305, 8589934591, 11, 34, 0xa5a5affffffffb05)
	EXT( 0xa5a5a5a5a5a5a304, 11, 35, 0xfffffffcb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a304, 11, 35, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a304, 17179869183, 11, 35, 0xa5a59ffffffffb04)
	EXT( 0xa5a5a5a5a5a5a303, 11, 36, 0x00000004b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a303, 11, 36, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a303, 34359738367, 11, 36, 0xa5a5bffffffffb03)
	EXT( 0xa5a5a5a5a5a5a302, 11, 37, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a302, 11, 37, 0x00000014b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a302, 68719476735, 11, 37, 0xa5a57ffffffffb02)
	EXT( 0xa5a5a5a5a5a5a301, 11, 38, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a301, 11, 38, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a301, 137438953471, 11, 38, 0xa5a4fffffffffb01)
	EXT( 0xa5a5a5a5a5a5a300, 11, 39, 0x00000034b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a300, 11, 39, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a300, 274877906943, 11, 39, 0xa5a5fffffffffb00)
	EXT( 0xa5a5a5a5a5a5a2ff, 11, 40, 0xffffffb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2ff, 11, 40, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2ff, 549755813887, 11, 40, 0xa5a3fffffffffaff)
	EXT( 0xa5a5a5a5a5a5a2fe, 11, 41, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2fe, 11, 41, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2fe, 1099511627775, 11, 41, 0xa5a7fffffffffafe)
	EXT( 0xa5a5a5a5a5a5a2fd, 11, 42, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2fd, 11, 42, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2fd, 2199023255551, 11, 42, 0xa5affffffffffafd)
	EXT( 0xa5a5a5a5a5a5a2fc, 11, 43, 0xfffffcb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2fc, 11, 43, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2fc, 4398046511103, 11, 43, 0xa59ffffffffffafc)
	EXT( 0xa5a5a5a5a5a5a2fb, 11, 44, 0x000004b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2fb, 11, 44, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2fb, 8796093022207, 11, 44, 0xa5bffffffffffafb)
	EXT( 0xa5a5a5a5a5a5a2fa, 11, 45, 0xfffff4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2fa, 11, 45, 0x000014b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2fa, 17592186044415, 11, 45, 0xa57ffffffffffafa)
	EXT( 0xa5a5a5a5a5a5a2f9, 11, 46, 0xfffff4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2f9, 11, 46, 0x000034b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2f9, 35184372088831, 11, 46, 0xa4fffffffffffaf9)
	EXT( 0xa5a5a5a5a5a5a2f8, 11, 47, 0x000034b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2f8, 11, 47, 0x000034b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2f8, 70368744177663, 11, 47, 0xa5fffffffffffaf8)
	EXT( 0xa5a5a5a5a5a5a2f7, 11, 48, 0xffffb4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2f7, 11, 48, 0x0000b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2f7, 140737488355327, 11, 48, 0xa3fffffffffffaf7)
	EXT( 0xa5a5a5a5a5a5a2f6, 11, 49, 0x0000b4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2f6, 11, 49, 0x0000b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2f6, 281474976710655, 11, 49, 0xa7fffffffffffaf6)
	EXT( 0xa5a5a5a5a5a5a2f5, 11, 50, 0x0000b4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2f5, 11, 50, 0x0000b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2f5, 562949953421311, 11, 50, 0xaffffffffffffaf5)
	EXT( 0xa5a5a5a5a5a5a2f4, 11, 51, 0xfffcb4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2f4, 11, 51, 0x0004b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2f4, 1125899906842623, 11, 51, 0x9ffffffffffffaf4)
	EXT( 0xa5a5a5a5a5a5a2f3, 11, 52, 0x0004b4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2f3, 11, 52, 0x0004b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2f3, 2251799813685247, 11, 52, 0xbffffffffffffaf3)
	EXT( 0xa5a5a5a5a5a5a2f2, 12, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a2f2, 12, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a2f2, 0, 12, 1, 0xa5a5a5a5a5a5a2f2)
	EXT( 0xa5a5a5a5a5a5a2f1, 12, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a2f1, 12, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a2f1, 1, 12, 2, 0xa5a5a5a5a5a592f1)
	EXT( 0xa5a5a5a5a5a5a2f0, 12, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a2f0, 12, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a2f0, 3, 12, 3, 0xa5a5a5a5a5a5b2f0)
	EXT( 0xa5a5a5a5a5a5a2ef, 12, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a2ef, 12, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a2ef, 7, 12, 4, 0xa5a5a5a5a5a572ef)
	EXT( 0xa5a5a5a5a5a5a2ee, 12, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a2ee, 12, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a2ee, 15, 12, 5, 0xa5a5a5a5a5a4f2ee)
	EXT( 0xa5a5a5a5a5a5a2ed, 12, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a5a2ed, 12, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a2ed, 31, 12, 6, 0xa5a5a5a5a5a5f2ed)
	EXT( 0xa5a5a5a5a5a5a2ec, 12, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a5a2ec, 12, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a2ec, 63, 12, 7, 0xa5a5a5a5a5a3f2ec)
	EXT( 0xa5a5a5a5a5a5a2eb, 12, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a2eb, 12, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a2eb, 127, 12, 8, 0xa5a5a5a5a5a7f2eb)
	EXT( 0xa5a5a5a5a5a5a2ea, 12, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a2ea, 12, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a2ea, 255, 12, 9, 0xa5a5a5a5a5aff2ea)
	EXT( 0xa5a5a5a5a5a5a2e9, 12, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a5a2e9, 12, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a2e9, 511, 12, 10, 0xa5a5a5a5a59ff2e9)
	EXT( 0xa5a5a5a5a5a5a2e8, 12, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a5a2e8, 12, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a2e8, 1023, 12, 11, 0xa5a5a5a5a5bff2e8)
	EXT( 0xa5a5a5a5a5a5a2e7, 12, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a2e7, 12, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a5a2e7, 2047, 12, 12, 0xa5a5a5a5a57ff2e7)
	EXT( 0xa5a5a5a5a5a5a2e6, 12, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a2e6, 12, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a2e6, 4095, 12, 13, 0xa5a5a5a5a4fff2e6)
	EXT( 0xa5a5a5a5a5a5a2e5, 12, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a5a2e5, 12, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a2e5, 8191, 12, 14, 0xa5a5a5a5a5fff2e5)
	EXT( 0xa5a5a5a5a5a5a2e4, 12, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a5a2e4, 12, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a2e4, 16383, 12, 15, 0xa5a5a5a5a3fff2e4)
	EXT( 0xa5a5a5a5a5a5a2e3, 12, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a2e3, 12, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a2e3, 32767, 12, 16, 0xa5a5a5a5a7fff2e3)
	EXT( 0xa5a5a5a5a5a5a2e2, 12, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a2e2, 12, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a2e2, 65535, 12, 17, 0xa5a5a5a5affff2e2)
	EXT( 0xa5a5a5a5a5a5a2e1, 12, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a5a2e1, 12, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a2e1, 131071, 12, 18, 0xa5a5a5a59ffff2e1)
	EXT( 0xa5a5a5a5a5a5a2e0, 12, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a5a2e0, 12, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a2e0, 262143, 12, 19, 0xa5a5a5a5bffff2e0)
	EXT( 0xa5a5a5a5a5a5a2df, 12, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a2df, 12, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a5a2df, 524287, 12, 20, 0xa5a5a5a57ffff2df)
	EXT( 0xa5a5a5a5a5a5a2de, 12, 21, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a2de, 12, 21, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a2de, 1048575, 12, 21, 0xa5a5a5a4fffff2de)
	EXT( 0xa5a5a5a5a5a5a2dd, 12, 22, 0x00000000001a5a5a)
	EXTU(0xa5a5a5a5a5a5a2dd, 12, 22, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a2dd, 2097151, 12, 22, 0xa5a5a5a5fffff2dd)
	EXT( 0xa5a5a5a5a5a5a2dc, 12, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a5a2dc, 12, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a2dc, 4194303, 12, 23, 0xa5a5a5a3fffff2dc)
	EXT( 0xa5a5a5a5a5a5a2db, 12, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a2db, 12, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a2db, 8388607, 12, 24, 0xa5a5a5a7fffff2db)
	EXT( 0xa5a5a5a5a5a5a2da, 12, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a2da, 12, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a2da, 16777215, 12, 25, 0xa5a5a5affffff2da)
	EXT( 0xa5a5a5a5a5a5a2d9, 12, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d9, 12, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d9, 33554431, 12, 26, 0xa5a5a59ffffff2d9)
	EXT( 0xa5a5a5a5a5a5a2d8, 12, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d8, 12, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d8, 67108863, 12, 27, 0xa5a5a5bffffff2d8)
	EXT( 0xa5a5a5a5a5a5a2d7, 12, 28, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d7, 12, 28, 0x000000000a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d7, 134217727, 12, 28, 0xa5a5a57ffffff2d7)
	EXT( 0xa5a5a5a5a5a5a2d6, 12, 29, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d6, 12, 29, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d6, 268435455, 12, 29, 0xa5a5a4fffffff2d6)
	EXT( 0xa5a5a5a5a5a5a2d5, 12, 30, 0x000000001a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d5, 12, 30, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d5, 536870911, 12, 30, 0xa5a5a5fffffff2d5)
	EXT( 0xa5a5a5a5a5a5a2d4, 12, 31, 0xffffffffda5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d4, 12, 31, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d4, 1073741823, 12, 31, 0xa5a5a3fffffff2d4)
	EXT( 0xa5a5a5a5a5a5a2d3, 12, 32, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d3, 12, 32, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d3, 2147483647, 12, 32, 0xa5a5a7fffffff2d3)
	EXT( 0xa5a5a5a5a5a5a2d2, 12, 33, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d2, 12, 33, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d2, 4294967295, 12, 33, 0xa5a5affffffff2d2)
	EXT( 0xa5a5a5a5a5a5a2d1, 12, 34, 0xfffffffe5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d1, 12, 34, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d1, 8589934591, 12, 34, 0xa5a59ffffffff2d1)
	EXT( 0xa5a5a5a5a5a5a2d0, 12, 35, 0x000000025a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d0, 12, 35, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d0, 17179869183, 12, 35, 0xa5a5bffffffff2d0)
	EXT( 0xa5a5a5a5a5a5a2cf, 12, 36, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2cf, 12, 36, 0x0000000a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2cf, 34359738367, 12, 36, 0xa5a57ffffffff2cf)
	EXT( 0xa5a5a5a5a5a5a2ce, 12, 37, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2ce, 12, 37, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2ce, 68719476735, 12, 37, 0xa5a4fffffffff2ce)
	EXT( 0xa5a5a5a5a5a5a2cd, 12, 38, 0x0000001a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2cd, 12, 38, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2cd, 137438953471, 12, 38, 0xa5a5fffffffff2cd)
	EXT( 0xa5a5a5a5a5a5a2cc, 12, 39, 0xffffffda5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2cc, 12, 39, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2cc, 274877906943, 12, 39, 0xa5a3fffffffff2cc)
	EXT( 0xa5a5a5a5a5a5a2cb, 12, 40, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2cb, 12, 40, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2cb, 549755813887, 12, 40, 0xa5a7fffffffff2cb)
	EXT( 0xa5a5a5a5a5a5a2ca, 12, 41, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2ca, 12, 41, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2ca, 1099511627775, 12, 41, 0xa5affffffffff2ca)
	EXT( 0xa5a5a5a5a5a5a2c9, 12, 42, 0xfffffe5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c9, 12, 42, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c9, 2199023255551, 12, 42, 0xa59ffffffffff2c9)
	EXT( 0xa5a5a5a5a5a5a2c8, 12, 43, 0x0000025a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c8, 12, 43, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c8, 4398046511103, 12, 43, 0xa5bffffffffff2c8)
	EXT( 0xa5a5a5a5a5a5a2c7, 12, 44, 0xfffffa5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c7, 12, 44, 0x00000a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c7, 8796093022207, 12, 44, 0xa57ffffffffff2c7)
	EXT( 0xa5a5a5a5a5a5a2c6, 12, 45, 0xfffffa5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c6, 12, 45, 0x00001a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c6, 17592186044415, 12, 45, 0xa4fffffffffff2c6)
	EXT( 0xa5a5a5a5a5a5a2c5, 12, 46, 0x00001a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c5, 12, 46, 0x00001a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c5, 35184372088831, 12, 46, 0xa5fffffffffff2c5)
	EXT( 0xa5a5a5a5a5a5a2c4, 12, 47, 0xffffda5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c4, 12, 47, 0x00005a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c4, 70368744177663, 12, 47, 0xa3fffffffffff2c4)
	EXT( 0xa5a5a5a5a5a5a2c3, 12, 48, 0x00005a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c3, 12, 48, 0x00005a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c3, 140737488355327, 12, 48, 0xa7fffffffffff2c3)
	EXT( 0xa5a5a5a5a5a5a2c2, 12, 49, 0x00005a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c2, 12, 49, 0x00005a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c2, 281474976710655, 12, 49, 0xaffffffffffff2c2)
	EXT( 0xa5a5a5a5a5a5a2c1, 12, 50, 0xfffe5a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c1, 12, 50, 0x00025a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c1, 562949953421311, 12, 50, 0x9ffffffffffff2c1)
	EXT( 0xa5a5a5a5a5a5a2c0, 12, 51, 0x00025a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2c0, 12, 51, 0x00025a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2c0, 1125899906842623, 12, 51, 0xbffffffffffff2c0)
	EXT( 0xa5a5a5a5a5a5a2bf, 13, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a2bf, 13, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a2bf, 0, 13, 1, 0xa5a5a5a5a5a582bf)
	EXT( 0xa5a5a5a5a5a5a2be, 13, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a2be, 13, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a2be, 1, 13, 2, 0xa5a5a5a5a5a5a2be)
	EXT( 0xa5a5a5a5a5a5a2bd, 13, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a2bd, 13, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a2bd, 3, 13, 3, 0xa5a5a5a5a5a562bd)
	EXT( 0xa5a5a5a5a5a5a2bc, 13, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a2bc, 13, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a2bc, 7, 13, 4, 0xa5a5a5a5a5a4e2bc)
	EXT( 0xa5a5a5a5a5a5a2bb, 13, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a5a2bb, 13, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a2bb, 15, 13, 5, 0xa5a5a5a5a5a5e2bb)
	EXT( 0xa5a5a5a5a5a5a2ba, 13, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a5a2ba, 13, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a2ba, 31, 13, 6, 0xa5a5a5a5a5a3e2ba)
	EXT( 0xa5a5a5a5a5a5a2b9, 13, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a2b9, 13, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a2b9, 63, 13, 7, 0xa5a5a5a5a5a7e2b9)
	EXT( 0xa5a5a5a5a5a5a2b8, 13, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a2b8, 13, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a2b8, 127, 13, 8, 0xa5a5a5a5a5afe2b8)
	EXT( 0xa5a5a5a5a5a5a2b7, 13, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a5a2b7, 13, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a2b7, 255, 13, 9, 0xa5a5a5a5a59fe2b7)
	EXT( 0xa5a5a5a5a5a5a2b6, 13, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a5a2b6, 13, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a2b6, 511, 13, 10, 0xa5a5a5a5a5bfe2b6)
	EXT( 0xa5a5a5a5a5a5a2b5, 13, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a2b5, 13, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a5a2b5, 1023, 13, 11, 0xa5a5a5a5a57fe2b5)
	EXT( 0xa5a5a5a5a5a5a2b4, 13, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a2b4, 13, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a2b4, 2047, 13, 12, 0xa5a5a5a5a4ffe2b4)
	EXT( 0xa5a5a5a5a5a5a2b3, 13, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a5a2b3, 13, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a2b3, 4095, 13, 13, 0xa5a5a5a5a5ffe2b3)
	EXT( 0xa5a5a5a5a5a5a2b2, 13, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a5a2b2, 13, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a2b2, 8191, 13, 14, 0xa5a5a5a5a3ffe2b2)
	EXT( 0xa5a5a5a5a5a5a2b1, 13, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a2b1, 13, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a2b1, 16383, 13, 15, 0xa5a5a5a5a7ffe2b1)
	EXT( 0xa5a5a5a5a5a5a2b0, 13, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a2b0, 13, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a2b0, 32767, 13, 16, 0xa5a5a5a5afffe2b0)
	EXT( 0xa5a5a5a5a5a5a2af, 13, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a5a2af, 13, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a2af, 65535, 13, 17, 0xa5a5a5a59fffe2af)
	EXT( 0xa5a5a5a5a5a5a2ae, 13, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a5a2ae, 13, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a2ae, 131071, 13, 18, 0xa5a5a5a5bfffe2ae)
	EXT( 0xa5a5a5a5a5a5a2ad, 13, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a2ad, 13, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a5a2ad, 262143, 13, 19, 0xa5a5a5a57fffe2ad)
	EXT( 0xa5a5a5a5a5a5a2ac, 13, 20, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a2ac, 13, 20, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a2ac, 524287, 13, 20, 0xa5a5a5a4ffffe2ac)
	EXT( 0xa5a5a5a5a5a5a2ab, 13, 21, 0x00000000000d2d2d)
	EXTU(0xa5a5a5a5a5a5a2ab, 13, 21, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a2ab, 1048575, 13, 21, 0xa5a5a5a5ffffe2ab)
	EXT( 0xa5a5a5a5a5a5a2aa, 13, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a5a2aa, 13, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a2aa, 2097151, 13, 22, 0xa5a5a5a3ffffe2aa)
	EXT( 0xa5a5a5a5a5a5a2a9, 13, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a9, 13, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a9, 4194303, 13, 23, 0xa5a5a5a7ffffe2a9)
	EXT( 0xa5a5a5a5a5a5a2a8, 13, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a8, 13, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a8, 8388607, 13, 24, 0xa5a5a5afffffe2a8)
	EXT( 0xa5a5a5a5a5a5a2a7, 13, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a7, 13, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a7, 16777215, 13, 25, 0xa5a5a59fffffe2a7)
	EXT( 0xa5a5a5a5a5a5a2a6, 13, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a6, 13, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a6, 33554431, 13, 26, 0xa5a5a5bfffffe2a6)
	EXT( 0xa5a5a5a5a5a5a2a5, 13, 27, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a5, 13, 27, 0x00000000052d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a5, 67108863, 13, 27, 0xa5a5a57fffffe2a5)
	EXT( 0xa5a5a5a5a5a5a2a4, 13, 28, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a4, 13, 28, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a4, 134217727, 13, 28, 0xa5a5a4ffffffe2a4)
	EXT( 0xa5a5a5a5a5a5a2a3, 13, 29, 0x000000000d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a3, 13, 29, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a3, 268435455, 13, 29, 0xa5a5a5ffffffe2a3)
	EXT( 0xa5a5a5a5a5a5a2a2, 13, 30, 0xffffffffed2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a2, 13, 30, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a2, 536870911, 13, 30, 0xa5a5a3ffffffe2a2)
	EXT( 0xa5a5a5a5a5a5a2a1, 13, 31, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a1, 13, 31, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a1, 1073741823, 13, 31, 0xa5a5a7ffffffe2a1)
	EXT( 0xa5a5a5a5a5a5a2a0, 13, 32, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a0, 13, 32, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a0, 2147483647, 13, 32, 0xa5a5afffffffe2a0)
	EXT( 0xa5a5a5a5a5a5a29f, 13, 33, 0xffffffff2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a29f, 13, 33, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a29f, 4294967295, 13, 33, 0xa5a59fffffffe29f)
	EXT( 0xa5a5a5a5a5a5a29e, 13, 34, 0x000000012d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a29e, 13, 34, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a29e, 8589934591, 13, 34, 0xa5a5bfffffffe29e)
	EXT( 0xa5a5a5a5a5a5a29d, 13, 35, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a29d, 13, 35, 0x000000052d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a29d, 17179869183, 13, 35, 0xa5a57fffffffe29d)
	EXT( 0xa5a5a5a5a5a5a29c, 13, 36, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a29c, 13, 36, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a29c, 34359738367, 13, 36, 0xa5a4ffffffffe29c)
	EXT( 0xa5a5a5a5a5a5a29b, 13, 37, 0x0000000d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a29b, 13, 37, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a29b, 68719476735, 13, 37, 0xa5a5ffffffffe29b)
	EXT( 0xa5a5a5a5a5a5a29a, 13, 38, 0xffffffed2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a29a, 13, 38, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a29a, 137438953471, 13, 38, 0xa5a3ffffffffe29a)
	EXT( 0xa5a5a5a5a5a5a299, 13, 39, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a299, 13, 39, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a299, 274877906943, 13, 39, 0xa5a7ffffffffe299)
	EXT( 0xa5a5a5a5a5a5a298, 13, 40, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a298, 13, 40, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a298, 549755813887, 13, 40, 0xa5afffffffffe298)
	EXT( 0xa5a5a5a5a5a5a297, 13, 41, 0xffffff2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a297, 13, 41, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a297, 1099511627775, 13, 41, 0xa59fffffffffe297)
	EXT( 0xa5a5a5a5a5a5a296, 13, 42, 0x0000012d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a296, 13, 42, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a296, 2199023255551, 13, 42, 0xa5bfffffffffe296)
	EXT( 0xa5a5a5a5a5a5a295, 13, 43, 0xfffffd2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a295, 13, 43, 0x0000052d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a295, 4398046511103, 13, 43, 0xa57fffffffffe295)
	EXT( 0xa5a5a5a5a5a5a294, 13, 44, 0xfffffd2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a294, 13, 44, 0x00000d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a294, 8796093022207, 13, 44, 0xa4ffffffffffe294)
	EXT( 0xa5a5a5a5a5a5a293, 13, 45, 0x00000d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a293, 13, 45, 0x00000d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a293, 17592186044415, 13, 45, 0xa5ffffffffffe293)
	EXT( 0xa5a5a5a5a5a5a292, 13, 46, 0xffffed2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a292, 13, 46, 0x00002d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a292, 35184372088831, 13, 46, 0xa3ffffffffffe292)
	EXT( 0xa5a5a5a5a5a5a291, 13, 47, 0x00002d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a291, 13, 47, 0x00002d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a291, 70368744177663, 13, 47, 0xa7ffffffffffe291)
	EXT( 0xa5a5a5a5a5a5a290, 13, 48, 0x00002d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a290, 13, 48, 0x00002d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a290, 140737488355327, 13, 48, 0xafffffffffffe290)
	EXT( 0xa5a5a5a5a5a5a28f, 13, 49, 0xffff2d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a28f, 13, 49, 0x00012d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a28f, 281474976710655, 13, 49, 0x9fffffffffffe28f)
	EXT( 0xa5a5a5a5a5a5a28e, 13, 50, 0x00012d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a28e, 13, 50, 0x00012d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a28e, 562949953421311, 13, 50, 0xbfffffffffffe28e)
	EXT( 0xa5a5a5a5a5a5a28d, 14, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a28d, 14, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a28d, 0, 14, 1, 0xa5a5a5a5a5a5a28d)
	EXT( 0xa5a5a5a5a5a5a28c, 14, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a28c, 14, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a28c, 1, 14, 2, 0xa5a5a5a5a5a5628c)
	EXT( 0xa5a5a5a5a5a5a28b, 14, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a28b, 14, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a28b, 3, 14, 3, 0xa5a5a5a5a5a4e28b)
	EXT( 0xa5a5a5a5a5a5a28a, 14, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a5a28a, 14, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a28a, 7, 14, 4, 0xa5a5a5a5a5a5e28a)
	EXT( 0xa5a5a5a5a5a5a289, 14, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a5a289, 14, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a289, 15, 14, 5, 0xa5a5a5a5a5a3e289)
	EXT( 0xa5a5a5a5a5a5a288, 14, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a288, 14, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a288, 31, 14, 6, 0xa5a5a5a5a5a7e288)
	EXT( 0xa5a5a5a5a5a5a287, 14, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a287, 14, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a287, 63, 14, 7, 0xa5a5a5a5a5afe287)
	EXT( 0xa5a5a5a5a5a5a286, 14, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a5a286, 14, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a286, 127, 14, 8, 0xa5a5a5a5a59fe286)
	EXT( 0xa5a5a5a5a5a5a285, 14, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a5a285, 14, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a285, 255, 14, 9, 0xa5a5a5a5a5bfe285)
	EXT( 0xa5a5a5a5a5a5a284, 14, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a284, 14, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a5a284, 511, 14, 10, 0xa5a5a5a5a57fe284)
	EXT( 0xa5a5a5a5a5a5a283, 14, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a283, 14, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a283, 1023, 14, 11, 0xa5a5a5a5a4ffe283)
	EXT( 0xa5a5a5a5a5a5a282, 14, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a5a282, 14, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a282, 2047, 14, 12, 0xa5a5a5a5a5ffe282)
	EXT( 0xa5a5a5a5a5a5a281, 14, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a5a281, 14, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a281, 4095, 14, 13, 0xa5a5a5a5a3ffe281)
	EXT( 0xa5a5a5a5a5a5a280, 14, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a280, 14, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a280, 8191, 14, 14, 0xa5a5a5a5a7ffe280)
	EXT( 0xa5a5a5a5a5a5a27f, 14, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a27f, 14, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a27f, 16383, 14, 15, 0xa5a5a5a5afffe27f)
	EXT( 0xa5a5a5a5a5a5a27e, 14, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a5a27e, 14, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a27e, 32767, 14, 16, 0xa5a5a5a59fffe27e)
	EXT( 0xa5a5a5a5a5a5a27d, 14, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a5a27d, 14, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a27d, 65535, 14, 17, 0xa5a5a5a5bfffe27d)
	EXT( 0xa5a5a5a5a5a5a27c, 14, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a27c, 14, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a5a27c, 131071, 14, 18, 0xa5a5a5a57fffe27c)
	EXT( 0xa5a5a5a5a5a5a27b, 14, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a27b, 14, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a27b, 262143, 14, 19, 0xa5a5a5a4ffffe27b)
	EXT( 0xa5a5a5a5a5a5a27a, 14, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a5a27a, 14, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a27a, 524287, 14, 20, 0xa5a5a5a5ffffe27a)
	EXT( 0xa5a5a5a5a5a5a279, 14, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a5a279, 14, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a279, 1048575, 14, 21, 0xa5a5a5a3ffffe279)
	EXT( 0xa5a5a5a5a5a5a278, 14, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a278, 14, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a278, 2097151, 14, 22, 0xa5a5a5a7ffffe278)
	EXT( 0xa5a5a5a5a5a5a277, 14, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a277, 14, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a277, 4194303, 14, 23, 0xa5a5a5afffffe277)
	EXT( 0xa5a5a5a5a5a5a276, 14, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a5a276, 14, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a276, 8388607, 14, 24, 0xa5a5a59fffffe276)
	EXT( 0xa5a5a5a5a5a5a275, 14, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a5a275, 14, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a275, 16777215, 14, 25, 0xa5a5a5bfffffe275)
	EXT( 0xa5a5a5a5a5a5a274, 14, 26, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a274, 14, 26, 0x0000000002969696)
	DEP( 0xa5a5a5a5a5a5a274, 33554431, 14, 26, 0xa5a5a57fffffe274)
	EXT( 0xa5a5a5a5a5a5a273, 14, 27, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a273, 14, 27, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a273, 67108863, 14, 27, 0xa5a5a4ffffffe273)
	EXT( 0xa5a5a5a5a5a5a272, 14, 28, 0x0000000006969696)
	EXTU(0xa5a5a5a5a5a5a272, 14, 28, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a272, 134217727, 14, 28, 0xa5a5a5ffffffe272)
	EXT( 0xa5a5a5a5a5a5a271, 14, 29, 0xfffffffff6969696)
	EXTU(0xa5a5a5a5a5a5a271, 14, 29, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a271, 268435455, 14, 29, 0xa5a5a3ffffffe271)
	EXT( 0xa5a5a5a5a5a5a270, 14, 30, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a270, 14, 30, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a270, 536870911, 14, 30, 0xa5a5a7ffffffe270)
	EXT( 0xa5a5a5a5a5a5a26f, 14, 31, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a26f, 14, 31, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a26f, 1073741823, 14, 31, 0xa5a5afffffffe26f)
	EXT( 0xa5a5a5a5a5a5a26e, 14, 32, 0xffffffff96969696)
	EXTU(0xa5a5a5a5a5a5a26e, 14, 32, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a26e, 2147483647, 14, 32, 0xa5a59fffffffe26e)
	EXT( 0xa5a5a5a5a5a5a26d, 14, 33, 0x0000000096969696)
	EXTU(0xa5a5a5a5a5a5a26d, 14, 33, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a26d, 4294967295, 14, 33, 0xa5a5bfffffffe26d)
	EXT( 0xa5a5a5a5a5a5a26c, 14, 34, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a26c, 14, 34, 0x0000000296969696)
	DEP( 0xa5a5a5a5a5a5a26c, 8589934591, 14, 34, 0xa5a57fffffffe26c)
	EXT( 0xa5a5a5a5a5a5a26b, 14, 35, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a26b, 14, 35, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a26b, 17179869183, 14, 35, 0xa5a4ffffffffe26b)
	EXT( 0xa5a5a5a5a5a5a26a, 14, 36, 0x0000000696969696)
	EXTU(0xa5a5a5a5a5a5a26a, 14, 36, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a26a, 34359738367, 14, 36, 0xa5a5ffffffffe26a)
	EXT( 0xa5a5a5a5a5a5a269, 14, 37, 0xfffffff696969696)
	EXTU(0xa5a5a5a5a5a5a269, 14, 37, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a269, 68719476735, 14, 37, 0xa5a3ffffffffe269)
	EXT( 0xa5a5a5a5a5a5a268, 14, 38, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a268, 14, 38, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a268, 137438953471, 14, 38, 0xa5a7ffffffffe268)
	EXT( 0xa5a5a5a5a5a5a267, 14, 39, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a267, 14, 39, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a267, 274877906943, 14, 39, 0xa5afffffffffe267)
	EXT( 0xa5a5a5a5a5a5a266, 14, 40, 0xffffff9696969696)
	EXTU(0xa5a5a5a5a5a5a266, 14, 40, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a266, 549755813887, 14, 40, 0xa59fffffffffe266)
	EXT( 0xa5a5a5a5a5a5a265, 14, 41, 0x0000009696969696)
	EXTU(0xa5a5a5a5a5a5a265, 14, 41, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a265, 1099511627775, 14, 41, 0xa5bfffffffffe265)
	EXT( 0xa5a5a5a5a5a5a264, 14, 42, 0xfffffe9696969696)
	EXTU(0xa5a5a5a5a5a5a264, 14, 42, 0x0000029696969696)
	DEP( 0xa5a5a5a5a5a5a264, 2199023255551, 14, 42, 0xa57fffffffffe264)
	EXT( 0xa5a5a5a5a5a5a263, 14, 43, 0xfffffe9696969696)
	EXTU(0xa5a5a5a5a5a5a263, 14, 43, 0x0000069696969696)
	DEP( 0xa5a5a5a5a5a5a263, 4398046511103, 14, 43, 0xa4ffffffffffe263)
	EXT( 0xa5a5a5a5a5a5a262, 14, 44, 0x0000069696969696)
	EXTU(0xa5a5a5a5a5a5a262, 14, 44, 0x0000069696969696)
	DEP( 0xa5a5a5a5a5a5a262, 8796093022207, 14, 44, 0xa5ffffffffffe262)
	EXT( 0xa5a5a5a5a5a5a261, 14, 45, 0xfffff69696969696)
	EXTU(0xa5a5a5a5a5a5a261, 14, 45, 0x0000169696969696)
	DEP( 0xa5a5a5a5a5a5a261, 17592186044415, 14, 45, 0xa3ffffffffffe261)
	EXT( 0xa5a5a5a5a5a5a260, 14, 46, 0x0000169696969696)
	EXTU(0xa5a5a5a5a5a5a260, 14, 46, 0x0000169696969696)
	DEP( 0xa5a5a5a5a5a5a260, 35184372088831, 14, 46, 0xa7ffffffffffe260)
	EXT( 0xa5a5a5a5a5a5a25f, 14, 47, 0x0000169696969696)
	EXTU(0xa5a5a5a5a5a5a25f, 14, 47, 0x0000169696969696)
	DEP( 0xa5a5a5a5a5a5a25f, 70368744177663, 14, 47, 0xafffffffffffe25f)
	EXT( 0xa5a5a5a5a5a5a25e, 14, 48, 0xffff969696969696)
	EXTU(0xa5a5a5a5a5a5a25e, 14, 48, 0x0000969696969696)
	DEP( 0xa5a5a5a5a5a5a25e, 140737488355327, 14, 48, 0x9fffffffffffe25e)
	EXT( 0xa5a5a5a5a5a5a25d, 14, 49, 0x0000969696969696)
	EXTU(0xa5a5a5a5a5a5a25d, 14, 49, 0x0000969696969696)
	DEP( 0xa5a5a5a5a5a5a25d, 281474976710655, 14, 49, 0xbfffffffffffe25d)
	EXT( 0xa5a5a5a5a5a5a25c, 15, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a25c, 15, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a25c, 0, 15, 1, 0xa5a5a5a5a5a5225c)
	EXT( 0xa5a5a5a5a5a5a25b, 15, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a25b, 15, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a25b, 1, 15, 2, 0xa5a5a5a5a5a4a25b)
	EXT( 0xa5a5a5a5a5a5a25a, 15, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a25a, 15, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a25a, 3, 15, 3, 0xa5a5a5a5a5a5a25a)
	EXT( 0xa5a5a5a5a5a5a259, 15, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a5a259, 15, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a259, 7, 15, 4, 0xa5a5a5a5a5a3a259)
	EXT( 0xa5a5a5a5a5a5a258, 15, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a258, 15, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a258, 15, 15, 5, 0xa5a5a5a5a5a7a258)
	EXT( 0xa5a5a5a5a5a5a257, 15, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a257, 15, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a257, 31, 15, 6, 0xa5a5a5a5a5afa257)
	EXT( 0xa5a5a5a5a5a5a256, 15, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a5a256, 15, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a256, 63, 15, 7, 0xa5a5a5a5a59fa256)
	EXT( 0xa5a5a5a5a5a5a255, 15, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a5a255, 15, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a255, 127, 15, 8, 0xa5a5a5a5a5bfa255)
	EXT( 0xa5a5a5a5a5a5a254, 15, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a254, 15, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a5a254, 255, 15, 9, 0xa5a5a5a5a57fa254)
	EXT( 0xa5a5a5a5a5a5a253, 15, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a253, 15, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a253, 511, 15, 10, 0xa5a5a5a5a4ffa253)
	EXT( 0xa5a5a5a5a5a5a252, 15, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a5a252, 15, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a252, 1023, 15, 11, 0xa5a5a5a5a5ffa252)
	EXT( 0xa5a5a5a5a5a5a251, 15, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a5a251, 15, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a251, 2047, 15, 12, 0xa5a5a5a5a3ffa251)
	EXT( 0xa5a5a5a5a5a5a250, 15, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a250, 15, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a250, 4095, 15, 13, 0xa5a5a5a5a7ffa250)
	EXT( 0xa5a5a5a5a5a5a24f, 15, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a24f, 15, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a24f, 8191, 15, 14, 0xa5a5a5a5afffa24f)
	EXT( 0xa5a5a5a5a5a5a24e, 15, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a5a24e, 15, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a24e, 16383, 15, 15, 0xa5a5a5a59fffa24e)
	EXT( 0xa5a5a5a5a5a5a24d, 15, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a5a24d, 15, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a24d, 32767, 15, 16, 0xa5a5a5a5bfffa24d)
	EXT( 0xa5a5a5a5a5a5a24c, 15, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a24c, 15, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a5a24c, 65535, 15, 17, 0xa5a5a5a57fffa24c)
	EXT( 0xa5a5a5a5a5a5a24b, 15, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a24b, 15, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a24b, 131071, 15, 18, 0xa5a5a5a4ffffa24b)
	EXT( 0xa5a5a5a5a5a5a24a, 15, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a5a24a, 15, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a24a, 262143, 15, 19, 0xa5a5a5a5ffffa24a)
	EXT( 0xa5a5a5a5a5a5a249, 15, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a5a249, 15, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a249, 524287, 15, 20, 0xa5a5a5a3ffffa249)
	EXT( 0xa5a5a5a5a5a5a248, 15, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a248, 15, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a248, 1048575, 15, 21, 0xa5a5a5a7ffffa248)
	EXT( 0xa5a5a5a5a5a5a247, 15, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a247, 15, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a247, 2097151, 15, 22, 0xa5a5a5afffffa247)
	EXT( 0xa5a5a5a5a5a5a246, 15, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a5a246, 15, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a246, 4194303, 15, 23, 0xa5a5a59fffffa246)
	EXT( 0xa5a5a5a5a5a5a245, 15, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a5a245, 15, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a245, 8388607, 15, 24, 0xa5a5a5bfffffa245)
	EXT( 0xa5a5a5a5a5a5a244, 15, 25, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a244, 15, 25, 0x00000000014b4b4b)
	DEP( 0xa5a5a5a5a5a5a244, 16777215, 15, 25, 0xa5a5a57fffffa244)
	EXT( 0xa5a5a5a5a5a5a243, 15, 26, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a243, 15, 26, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a243, 33554431, 15, 26, 0xa5a5a4ffffffa243)
	EXT( 0xa5a5a5a5a5a5a242, 15, 27, 0x00000000034b4b4b)
	EXTU(0xa5a5a5a5a5a5a242, 15, 27, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a242, 67108863, 15, 27, 0xa5a5a5ffffffa242)
	EXT( 0xa5a5a5a5a5a5a241, 15, 28, 0xfffffffffb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a241, 15, 28, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a241, 134217727, 15, 28, 0xa5a5a3ffffffa241)
	EXT( 0xa5a5a5a5a5a5a240, 15, 29, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a240, 15, 29, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a240, 268435455, 15, 29, 0xa5a5a7ffffffa240)
	EXT( 0xa5a5a5a5a5a5a23f, 15, 30, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a23f, 15, 30, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a23f, 536870911, 15, 30, 0xa5a5afffffffa23f)
	EXT( 0xa5a5a5a5a5a5a23e, 15, 31, 0xffffffffcb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a23e, 15, 31, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a23e, 1073741823, 15, 31, 0xa5a59fffffffa23e)
	EXT( 0xa5a5a5a5a5a5a23d, 15, 32, 0x000000004b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a23d, 15, 32, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a23d, 2147483647, 15, 32, 0xa5a5bfffffffa23d)
	EXT( 0xa5a5a5a5a5a5a23c, 15, 33, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a23c, 15, 33, 0x000000014b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a23c, 4294967295, 15, 33, 0xa5a57fffffffa23c)
	EXT( 0xa5a5a5a5a5a5a23b, 15, 34, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a23b, 15, 34, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a23b, 8589934591, 15, 34, 0xa5a4ffffffffa23b)
	EXT( 0xa5a5a5a5a5a5a23a, 15, 35, 0x000000034b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a23a, 15, 35, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a23a, 17179869183, 15, 35, 0xa5a5ffffffffa23a)
	EXT( 0xa5a5a5a5a5a5a239, 15, 36, 0xfffffffb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a239, 15, 36, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a239, 34359738367, 15, 36, 0xa5a3ffffffffa239)
	EXT( 0xa5a5a5a5a5a5a238, 15, 37, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a238, 15, 37, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a238, 68719476735, 15, 37, 0xa5a7ffffffffa238)
	EXT( 0xa5a5a5a5a5a5a237, 15, 38, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a237, 15, 38, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a237, 137438953471, 15, 38, 0xa5afffffffffa237)
	EXT( 0xa5a5a5a5a5a5a236, 15, 39, 0xffffffcb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a236, 15, 39, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a236, 274877906943, 15, 39, 0xa59fffffffffa236)
	EXT( 0xa5a5a5a5a5a5a235, 15, 40, 0x0000004b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a235, 15, 40, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a235, 549755813887, 15, 40, 0xa5bfffffffffa235)
	EXT( 0xa5a5a5a5a5a5a234, 15, 41, 0xffffff4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a234, 15, 41, 0x0000014b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a234, 1099511627775, 15, 41, 0xa57fffffffffa234)
	EXT( 0xa5a5a5a5a5a5a233, 15, 42, 0xffffff4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a233, 15, 42, 0x0000034b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a233, 2199023255551, 15, 42, 0xa4ffffffffffa233)
	EXT( 0xa5a5a5a5a5a5a232, 15, 43, 0x0000034b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a232, 15, 43, 0x0000034b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a232, 4398046511103, 15, 43, 0xa5ffffffffffa232)
	EXT( 0xa5a5a5a5a5a5a231, 15, 44, 0xfffffb4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a231, 15, 44, 0x00000b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a231, 8796093022207, 15, 44, 0xa3ffffffffffa231)
	EXT( 0xa5a5a5a5a5a5a230, 15, 45, 0x00000b4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a230, 15, 45, 0x00000b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a230, 17592186044415, 15, 45, 0xa7ffffffffffa230)
	EXT( 0xa5a5a5a5a5a5a22f, 15, 46, 0x00000b4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a22f, 15, 46, 0x00000b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a22f, 35184372088831, 15, 46, 0xafffffffffffa22f)
	EXT( 0xa5a5a5a5a5a5a22e, 15, 47, 0xffffcb4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a22e, 15, 47, 0x00004b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a22e, 70368744177663, 15, 47, 0x9fffffffffffa22e)
	EXT( 0xa5a5a5a5a5a5a22d, 15, 48, 0x00004b4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a22d, 15, 48, 0x00004b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a22d, 140737488355327, 15, 48, 0xbfffffffffffa22d)
	EXT( 0xa5a5a5a5a5a5a22c, 16, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a22c, 16, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a22c, 0, 16, 1, 0xa5a5a5a5a5a4a22c)
	EXT( 0xa5a5a5a5a5a5a22b, 16, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a22b, 16, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a22b, 1, 16, 2, 0xa5a5a5a5a5a5a22b)
	EXT( 0xa5a5a5a5a5a5a22a, 16, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a22a, 16, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a22a, 3, 16, 3, 0xa5a5a5a5a5a3a22a)
	EXT( 0xa5a5a5a5a5a5a229, 16, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a229, 16, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a229, 7, 16, 4, 0xa5a5a5a5a5a7a229)
	EXT( 0xa5a5a5a5a5a5a228, 16, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a228, 16, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a228, 15, 16, 5, 0xa5a5a5a5a5afa228)
	EXT( 0xa5a5a5a5a5a5a227, 16, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a5a227, 16, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a227, 31, 16, 6, 0xa5a5a5a5a59fa227)
	EXT( 0xa5a5a5a5a5a5a226, 16, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a5a226, 16, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a226, 63, 16, 7, 0xa5a5a5a5a5bfa226)
	EXT( 0xa5a5a5a5a5a5a225, 16, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a225, 16, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a5a225, 127, 16, 8, 0xa5a5a5a5a57fa225)
	EXT( 0xa5a5a5a5a5a5a224, 16, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a224, 16, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a224, 255, 16, 9, 0xa5a5a5a5a4ffa224)
	EXT( 0xa5a5a5a5a5a5a223, 16, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a5a223, 16, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a223, 511, 16, 10, 0xa5a5a5a5a5ffa223)
	EXT( 0xa5a5a5a5a5a5a222, 16, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a5a222, 16, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a222, 1023, 16, 11, 0xa5a5a5a5a3ffa222)
	EXT( 0xa5a5a5a5a5a5a221, 16, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a221, 16, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a221, 2047, 16, 12, 0xa5a5a5a5a7ffa221)
	EXT( 0xa5a5a5a5a5a5a220, 16, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a220, 16, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a220, 4095, 16, 13, 0xa5a5a5a5afffa220)
	EXT( 0xa5a5a5a5a5a5a21f, 16, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a5a21f, 16, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a21f, 8191, 16, 14, 0xa5a5a5a59fffa21f)
	EXT( 0xa5a5a5a5a5a5a21e, 16, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a5a21e, 16, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a21e, 16383, 16, 15, 0xa5a5a5a5bfffa21e)
	EXT( 0xa5a5a5a5a5a5a21d, 16, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a21d, 16, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a5a21d, 32767, 16, 16, 0xa5a5a5a57fffa21d)
	EXT( 0xa5a5a5a5a5a5a21c, 16, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a21c, 16, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a21c, 65535, 16, 17, 0xa5a5a5a4ffffa21c)
	EXT( 0xa5a5a5a5a5a5a21b, 16, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a5a21b, 16, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a21b, 131071, 16, 18, 0xa5a5a5a5ffffa21b)
	EXT( 0xa5a5a5a5a5a5a21a, 16, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a5a21a, 16, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a21a, 262143, 16, 19, 0xa5a5a5a3ffffa21a)
	EXT( 0xa5a5a5a5a5a5a219, 16, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a219, 16, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a219, 524287, 16, 20, 0xa5a5a5a7ffffa219)
	EXT( 0xa5a5a5a5a5a5a218, 16, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a218, 16, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a218, 1048575, 16, 21, 0xa5a5a5afffffa218)
	EXT( 0xa5a5a5a5a5a5a217, 16, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a5a217, 16, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a217, 2097151, 16, 22, 0xa5a5a59fffffa217)
	EXT( 0xa5a5a5a5a5a5a216, 16, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a5a216, 16, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a216, 4194303, 16, 23, 0xa5a5a5bfffffa216)
	EXT( 0xa5a5a5a5a5a5a215, 16, 24, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a215, 16, 24, 0x0000000000a5a5a5)
	DEP( 0xa5a5a5a5a5a5a215, 8388607, 16, 24, 0xa5a5a57fffffa215)
	EXT( 0xa5a5a5a5a5a5a214, 16, 25, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a214, 16, 25, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a214, 16777215, 16, 25, 0xa5a5a4ffffffa214)
	EXT( 0xa5a5a5a5a5a5a213, 16, 26, 0x0000000001a5a5a5)
	EXTU(0xa5a5a5a5a5a5a213, 16, 26, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a213, 33554431, 16, 26, 0xa5a5a5ffffffa213)
	EXT( 0xa5a5a5a5a5a5a212, 16, 27, 0xfffffffffda5a5a5)
	EXTU(0xa5a5a5a5a5a5a212, 16, 27, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a212, 67108863, 16, 27, 0xa5a5a3ffffffa212)
	EXT( 0xa5a5a5a5a5a5a211, 16, 28, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a211, 16, 28, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a211, 134217727, 16, 28, 0xa5a5a7ffffffa211)
	EXT( 0xa5a5a5a5a5a5a210, 16, 29, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a210, 16, 29, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a210, 268435455, 16, 29, 0xa5a5afffffffa210)
	EXT( 0xa5a5a5a5a5a5a20f, 16, 30, 0xffffffffe5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a20f, 16, 30, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a20f, 536870911, 16, 30, 0xa5a59fffffffa20f)
	EXT( 0xa5a5a5a5a5a5a20e, 16, 31, 0x0000000025a5a5a5)
	EXTU(0xa5a5a5a5a5a5a20e, 16, 31, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a20e, 1073741823, 16, 31, 0xa5a5bfffffffa20e)
	EXT( 0xa5a5a5a5a5a5a20d, 16, 32, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a20d, 16, 32, 0x00000000a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a20d, 2147483647, 16, 32, 0xa5a57fffffffa20d)
	EXT( 0xa5a5a5a5a5a5a20c, 16, 33, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a20c, 16, 33, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a20c, 4294967295, 16, 33, 0xa5a4ffffffffa20c)
	EXT( 0xa5a5a5a5a5a5a20b, 16, 34, 0x00000001a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a20b, 16, 34, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a20b, 8589934591, 16, 34, 0xa5a5ffffffffa20b)
	EXT( 0xa5a5a5a5a5a5a20a, 16, 35, 0xfffffffda5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a20a, 16, 35, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a20a, 17179869183, 16, 35, 0xa5a3ffffffffa20a)
	EXT( 0xa5a5a5a5a5a5a209, 16, 36, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a209, 16, 36, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a209, 34359738367, 16, 36, 0xa5a7ffffffffa209)
	EXT( 0xa5a5a5a5a5a5a208, 16, 37, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a208, 16, 37, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a208, 68719476735, 16, 37, 0xa5afffffffffa208)
	EXT( 0xa5a5a5a5a5a5a207, 16, 38, 0xffffffe5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a207, 16, 38, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a207, 137438953471, 16, 38, 0xa59fffffffffa207)
	EXT( 0xa5a5a5a5a5a5a206, 16, 39, 0x00000025a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a206, 16, 39, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a206, 274877906943, 16, 39, 0xa5bfffffffffa206)
	EXT( 0xa5a5a5a5a5a5a205, 16, 40, 0xffffffa5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a205, 16, 40, 0x000000a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a205, 549755813887, 16, 40, 0xa57fffffffffa205)
	EXT( 0xa5a5a5a5a5a5a204, 16, 41, 0xffffffa5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a204, 16, 41, 0x000001a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a204, 1099511627775, 16, 41, 0xa4ffffffffffa204)
	EXT( 0xa5a5a5a5a5a5a203, 16, 42, 0x000001a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a203, 16, 42, 0x000001a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a203, 2199023255551, 16, 42, 0xa5ffffffffffa203)
	EXT( 0xa5a5a5a5a5a5a202, 16, 43, 0xfffffda5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a202, 16, 43, 0x000005a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a202, 4398046511103, 16, 43, 0xa3ffffffffffa202)
	EXT( 0xa5a5a5a5a5a5a201, 16, 44, 0x000005a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a201, 16, 44, 0x000005a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a201, 8796093022207, 16, 44, 0xa7ffffffffffa201)
	EXT( 0xa5a5a5a5a5a5a200, 16, 45, 0x000005a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a200, 16, 45, 0x000005a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a200, 17592186044415, 16, 45, 0xafffffffffffa200)
	EXT( 0xa5a5a5a5a5a5a1ff, 16, 46, 0xffffe5a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a1ff, 16, 46, 0x000025a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a1ff, 35184372088831, 16, 46, 0x9fffffffffffa1ff)
	EXT( 0xa5a5a5a5a5a5a1fe, 16, 47, 0x000025a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a1fe, 16, 47, 0x000025a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a1fe, 70368744177663, 16, 47, 0xbfffffffffffa1fe)
	EXT( 0xa5a5a5a5a5a5a1fd, 17, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a1fd, 17, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a1fd, 0, 17, 1, 0xa5a5a5a5a5a5a1fd)
	EXT( 0xa5a5a5a5a5a5a1fc, 17, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a1fc, 17, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a1fc, 1, 17, 2, 0xa5a5a5a5a5a3a1fc)
	EXT( 0xa5a5a5a5a5a5a1fb, 17, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a1fb, 17, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a1fb, 3, 17, 3, 0xa5a5a5a5a5a7a1fb)
	EXT( 0xa5a5a5a5a5a5a1fa, 17, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a1fa, 17, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a1fa, 7, 17, 4, 0xa5a5a5a5a5afa1fa)
	EXT( 0xa5a5a5a5a5a5a1f9, 17, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a5a1f9, 17, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a1f9, 15, 17, 5, 0xa5a5a5a5a59fa1f9)
	EXT( 0xa5a5a5a5a5a5a1f8, 17, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a5a1f8, 17, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a1f8, 31, 17, 6, 0xa5a5a5a5a5bfa1f8)
	EXT( 0xa5a5a5a5a5a5a1f7, 17, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a1f7, 17, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a5a1f7, 63, 17, 7, 0xa5a5a5a5a57fa1f7)
	EXT( 0xa5a5a5a5a5a5a1f6, 17, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a1f6, 17, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a1f6, 127, 17, 8, 0xa5a5a5a5a4ffa1f6)
	EXT( 0xa5a5a5a5a5a5a1f5, 17, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a5a1f5, 17, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a1f5, 255, 17, 9, 0xa5a5a5a5a5ffa1f5)
	EXT( 0xa5a5a5a5a5a5a1f4, 17, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a5a1f4, 17, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a1f4, 511, 17, 10, 0xa5a5a5a5a3ffa1f4)
	EXT( 0xa5a5a5a5a5a5a1f3, 17, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a1f3, 17, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a1f3, 1023, 17, 11, 0xa5a5a5a5a7ffa1f3)
	EXT( 0xa5a5a5a5a5a5a1f2, 17, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a1f2, 17, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a1f2, 2047, 17, 12, 0xa5a5a5a5afffa1f2)
	EXT( 0xa5a5a5a5a5a5a1f1, 17, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a5a1f1, 17, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a1f1, 4095, 17, 13, 0xa5a5a5a59fffa1f1)
	EXT( 0xa5a5a5a5a5a5a1f0, 17, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a5a1f0, 17, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a1f0, 8191, 17, 14, 0xa5a5a5a5bfffa1f0)
	EXT( 0xa5a5a5a5a5a5a1ef, 17, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a1ef, 17, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a5a1ef, 16383, 17, 15, 0xa5a5a5a57fffa1ef)
	EXT( 0xa5a5a5a5a5a5a1ee, 17, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a1ee, 17, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a1ee, 32767, 17, 16, 0xa5a5a5a4ffffa1ee)
	EXT( 0xa5a5a5a5a5a5a1ed, 17, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a5a1ed, 17, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a1ed, 65535, 17, 17, 0xa5a5a5a5ffffa1ed)
	EXT( 0xa5a5a5a5a5a5a1ec, 17, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a5a1ec, 17, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a1ec, 131071, 17, 18, 0xa5a5a5a3ffffa1ec)
	EXT( 0xa5a5a5a5a5a5a1eb, 17, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a1eb, 17, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a1eb, 262143, 17, 19, 0xa5a5a5a7ffffa1eb)
	EXT( 0xa5a5a5a5a5a5a1ea, 17, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a1ea, 17, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a1ea, 524287, 17, 20, 0xa5a5a5afffffa1ea)
	EXT( 0xa5a5a5a5a5a5a1e9, 17, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e9, 17, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a1e9, 1048575, 17, 21, 0xa5a5a59fffffa1e9)
	EXT( 0xa5a5a5a5a5a5a1e8, 17, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a5a1e8, 17, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a1e8, 2097151, 17, 22, 0xa5a5a5bfffffa1e8)
	EXT( 0xa5a5a5a5a5a5a1e7, 17, 23, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e7, 17, 23, 0x000000000052d2d2)
	DEP( 0xa5a5a5a5a5a5a1e7, 4194303, 17, 23, 0xa5a5a57fffffa1e7)
	EXT( 0xa5a5a5a5a5a5a1e6, 17, 24, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e6, 17, 24, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e6, 8388607, 17, 24, 0xa5a5a4ffffffa1e6)
	EXT( 0xa5a5a5a5a5a5a1e5, 17, 25, 0x0000000000d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e5, 17, 25, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e5, 16777215, 17, 25, 0xa5a5a5ffffffa1e5)
	EXT( 0xa5a5a5a5a5a5a1e4, 17, 26, 0xfffffffffed2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e4, 17, 26, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e4, 33554431, 17, 26, 0xa5a5a3ffffffa1e4)
	EXT( 0xa5a5a5a5a5a5a1e3, 17, 27, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e3, 17, 27, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e3, 67108863, 17, 27, 0xa5a5a7ffffffa1e3)
	EXT( 0xa5a5a5a5a5a5a1e2, 17, 28, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e2, 17, 28, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e2, 134217727, 17, 28, 0xa5a5afffffffa1e2)
	EXT( 0xa5a5a5a5a5a5a1e1, 17, 29, 0xfffffffff2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e1, 17, 29, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e1, 268435455, 17, 29, 0xa5a59fffffffa1e1)
	EXT( 0xa5a5a5a5a5a5a1e0, 17, 30, 0x0000000012d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e0, 17, 30, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e0, 536870911, 17, 30, 0xa5a5bfffffffa1e0)
	EXT( 0xa5a5a5a5a5a5a1df, 17, 31, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1df, 17, 31, 0x0000000052d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1df, 1073741823, 17, 31, 0xa5a57fffffffa1df)
	EXT( 0xa5a5a5a5a5a5a1de, 17, 32, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1de, 17, 32, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1de, 2147483647, 17, 32, 0xa5a4ffffffffa1de)
	EXT( 0xa5a5a5a5a5a5a1dd, 17, 33, 0x00000000d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1dd, 17, 33, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1dd, 4294967295, 17, 33, 0xa5a5ffffffffa1dd)
	EXT( 0xa5a5a5a5a5a5a1dc, 17, 34, 0xfffffffed2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1dc, 17, 34, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1dc, 8589934591, 17, 34, 0xa5a3ffffffffa1dc)
	EXT( 0xa5a5a5a5a5a5a1db, 17, 35, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1db, 17, 35, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1db, 17179869183, 17, 35, 0xa5a7ffffffffa1db)
	EXT( 0xa5a5a5a5a5a5a1da, 17, 36, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1da, 17, 36, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1da, 34359738367, 17, 36, 0xa5afffffffffa1da)
	EXT( 0xa5a5a5a5a5a5a1d9, 17, 37, 0xfffffff2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d9, 17, 37, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d9, 68719476735, 17, 37, 0xa59fffffffffa1d9)
	EXT( 0xa5a5a5a5a5a5a1d8, 17, 38, 0x00000012d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d8, 17, 38, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d8, 137438953471, 17, 38, 0xa5bfffffffffa1d8)
	EXT( 0xa5a5a5a5a5a5a1d7, 17, 39, 0xffffffd2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d7, 17, 39, 0x00000052d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d7, 274877906943, 17, 39, 0xa57fffffffffa1d7)
	EXT( 0xa5a5a5a5a5a5a1d6, 17, 40, 0xffffffd2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d6, 17, 40, 0x000000d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d6, 549755813887, 17, 40, 0xa4ffffffffffa1d6)
	EXT( 0xa5a5a5a5a5a5a1d5, 17, 41, 0x000000d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d5, 17, 41, 0x000000d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d5, 1099511627775, 17, 41, 0xa5ffffffffffa1d5)
	EXT( 0xa5a5a5a5a5a5a1d4, 17, 42, 0xfffffed2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d4, 17, 42, 0x000002d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d4, 2199023255551, 17, 42, 0xa3ffffffffffa1d4)
	EXT( 0xa5a5a5a5a5a5a1d3, 17, 43, 0x000002d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d3, 17, 43, 0x000002d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d3, 4398046511103, 17, 43, 0xa7ffffffffffa1d3)
	EXT( 0xa5a5a5a5a5a5a1d2, 17, 44, 0x000002d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d2, 17, 44, 0x000002d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d2, 8796093022207, 17, 44, 0xafffffffffffa1d2)
	EXT( 0xa5a5a5a5a5a5a1d1, 17, 45, 0xfffff2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d1, 17, 45, 0x000012d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d1, 17592186044415, 17, 45, 0x9fffffffffffa1d1)
	EXT( 0xa5a5a5a5a5a5a1d0, 17, 46, 0x000012d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1d0, 17, 46, 0x000012d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1d0, 35184372088831, 17, 46, 0xbfffffffffffa1d0)
	EXT( 0xa5a5a5a5a5a5a1cf, 18, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a1cf, 18, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a1cf, 0, 18, 1, 0xa5a5a5a5a5a1a1cf)
	EXT( 0xa5a5a5a5a5a5a1ce, 18, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a1ce, 18, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a1ce, 1, 18, 2, 0xa5a5a5a5a5a5a1ce)
	EXT( 0xa5a5a5a5a5a5a1cd, 18, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a1cd, 18, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a1cd, 3, 18, 3, 0xa5a5a5a5a5ada1cd)
	EXT( 0xa5a5a5a5a5a5a1cc, 18, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a5a1cc, 18, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a1cc, 7, 18, 4, 0xa5a5a5a5a59da1cc)
	EXT( 0xa5a5a5a5a5a5a1cb, 18, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a5a1cb, 18, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a1cb, 15, 18, 5, 0xa5a5a5a5a5bda1cb)
	EXT( 0xa5a5a5a5a5a5a1ca, 18, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a1ca, 18, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a5a1ca, 31, 18, 6, 0xa5a5a5a5a57da1ca)
	EXT( 0xa5a5a5a5a5a5a1c9, 18, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a1c9, 18, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a1c9, 63, 18, 7, 0xa5a5a5a5a4fda1c9)
	EXT( 0xa5a5a5a5a5a5a1c8, 18, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a5a1c8, 18, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a1c8, 127, 18, 8, 0xa5a5a5a5a5fda1c8)
	EXT( 0xa5a5a5a5a5a5a1c7, 18, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a5a1c7, 18, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a1c7, 255, 18, 9, 0xa5a5a5a5a3fda1c7)
	EXT( 0xa5a5a5a5a5a5a1c6, 18, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a1c6, 18, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a1c6, 511, 18, 10, 0xa5a5a5a5a7fda1c6)
	EXT( 0xa5a5a5a5a5a5a1c5, 18, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a1c5, 18, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a1c5, 1023, 18, 11, 0xa5a5a5a5affda1c5)
	EXT( 0xa5a5a5a5a5a5a1c4, 18, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a5a1c4, 18, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a1c4, 2047, 18, 12, 0xa5a5a5a59ffda1c4)
	EXT( 0xa5a5a5a5a5a5a1c3, 18, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a5a1c3, 18, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a1c3, 4095, 18, 13, 0xa5a5a5a5bffda1c3)
	EXT( 0xa5a5a5a5a5a5a1c2, 18, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a1c2, 18, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a5a1c2, 8191, 18, 14, 0xa5a5a5a57ffda1c2)
	EXT( 0xa5a5a5a5a5a5a1c1, 18, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a1c1, 18, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a1c1, 16383, 18, 15, 0xa5a5a5a4fffda1c1)
	EXT( 0xa5a5a5a5a5a5a1c0, 18, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a5a1c0, 18, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a1c0, 32767, 18, 16, 0xa5a5a5a5fffda1c0)
	EXT( 0xa5a5a5a5a5a5a1bf, 18, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a5a1bf, 18, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a1bf, 65535, 18, 17, 0xa5a5a5a3fffda1bf)
	EXT( 0xa5a5a5a5a5a5a1be, 18, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a1be, 18, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a1be, 131071, 18, 18, 0xa5a5a5a7fffda1be)
	EXT( 0xa5a5a5a5a5a5a1bd, 18, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a1bd, 18, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a1bd, 262143, 18, 19, 0xa5a5a5affffda1bd)
	EXT( 0xa5a5a5a5a5a5a1bc, 18, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a5a1bc, 18, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a1bc, 524287, 18, 20, 0xa5a5a59ffffda1bc)
	EXT( 0xa5a5a5a5a5a5a1bb, 18, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a5a1bb, 18, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a1bb, 1048575, 18, 21, 0xa5a5a5bffffda1bb)
	EXT( 0xa5a5a5a5a5a5a1ba, 18, 22, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a1ba, 18, 22, 0x0000000000296969)
	DEP( 0xa5a5a5a5a5a5a1ba, 2097151, 18, 22, 0xa5a5a57ffffda1ba)
	EXT( 0xa5a5a5a5a5a5a1b9, 18, 23, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a1b9, 18, 23, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a1b9, 4194303, 18, 23, 0xa5a5a4fffffda1b9)
	EXT( 0xa5a5a5a5a5a5a1b8, 18, 24, 0x0000000000696969)
	EXTU(0xa5a5a5a5a5a5a1b8, 18, 24, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a1b8, 8388607, 18, 24, 0xa5a5a5fffffda1b8)
	EXT( 0xa5a5a5a5a5a5a1b7, 18, 25, 0xffffffffff696969)
	EXTU(0xa5a5a5a5a5a5a1b7, 18, 25, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a1b7, 16777215, 18, 25, 0xa5a5a3fffffda1b7)
	EXT( 0xa5a5a5a5a5a5a1b6, 18, 26, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a1b6, 18, 26, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a1b6, 33554431, 18, 26, 0xa5a5a7fffffda1b6)
	EXT( 0xa5a5a5a5a5a5a1b5, 18, 27, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a1b5, 18, 27, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a1b5, 67108863, 18, 27, 0xa5a5affffffda1b5)
	EXT( 0xa5a5a5a5a5a5a1b4, 18, 28, 0xfffffffff9696969)
	EXTU(0xa5a5a5a5a5a5a1b4, 18, 28, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a1b4, 134217727, 18, 28, 0xa5a59ffffffda1b4)
	EXT( 0xa5a5a5a5a5a5a1b3, 18, 29, 0x0000000009696969)
	EXTU(0xa5a5a5a5a5a5a1b3, 18, 29, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a1b3, 268435455, 18, 29, 0xa5a5bffffffda1b3)
	EXT( 0xa5a5a5a5a5a5a1b2, 18, 30, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a1b2, 18, 30, 0x0000000029696969)
	DEP( 0xa5a5a5a5a5a5a1b2, 536870911, 18, 30, 0xa5a57ffffffda1b2)
	EXT( 0xa5a5a5a5a5a5a1b1, 18, 31, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a1b1, 18, 31, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a1b1, 1073741823, 18, 31, 0xa5a4fffffffda1b1)
	EXT( 0xa5a5a5a5a5a5a1b0, 18, 32, 0x0000000069696969)
	EXTU(0xa5a5a5a5a5a5a1b0, 18, 32, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a1b0, 2147483647, 18, 32, 0xa5a5fffffffda1b0)
	EXT( 0xa5a5a5a5a5a5a1af, 18, 33, 0xffffffff69696969)
	EXTU(0xa5a5a5a5a5a5a1af, 18, 33, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a1af, 4294967295, 18, 33, 0xa5a3fffffffda1af)
	EXT( 0xa5a5a5a5a5a5a1ae, 18, 34, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a1ae, 18, 34, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a1ae, 8589934591, 18, 34, 0xa5a7fffffffda1ae)
	EXT( 0xa5a5a5a5a5a5a1ad, 18, 35, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a1ad, 18, 35, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a1ad, 17179869183, 18, 35, 0xa5affffffffda1ad)
	EXT( 0xa5a5a5a5a5a5a1ac, 18, 36, 0xfffffff969696969)
	EXTU(0xa5a5a5a5a5a5a1ac, 18, 36, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a1ac, 34359738367, 18, 36, 0xa59ffffffffda1ac)
	EXT( 0xa5a5a5a5a5a5a1ab, 18, 37, 0x0000000969696969)
	EXTU(0xa5a5a5a5a5a5a1ab, 18, 37, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a1ab, 68719476735, 18, 37, 0xa5bffffffffda1ab)
	EXT( 0xa5a5a5a5a5a5a1aa, 18, 38, 0xffffffe969696969)
	EXTU(0xa5a5a5a5a5a5a1aa, 18, 38, 0x0000002969696969)
	DEP( 0xa5a5a5a5a5a5a1aa, 137438953471, 18, 38, 0xa57ffffffffda1aa)
	EXT( 0xa5a5a5a5a5a5a1a9, 18, 39, 0xffffffe969696969)
	EXTU(0xa5a5a5a5a5a5a1a9, 18, 39, 0x0000006969696969)
	DEP( 0xa5a5a5a5a5a5a1a9, 274877906943, 18, 39, 0xa4fffffffffda1a9)
	EXT( 0xa5a5a5a5a5a5a1a8, 18, 40, 0x0000006969696969)
	EXTU(0xa5a5a5a5a5a5a1a8, 18, 40, 0x0000006969696969)
	DEP( 0xa5a5a5a5a5a5a1a8, 549755813887, 18, 40, 0xa5fffffffffda1a8)
	EXT( 0xa5a5a5a5a5a5a1a7, 18, 41, 0xffffff6969696969)
	EXTU(0xa5a5a5a5a5a5a1a7, 18, 41, 0x0000016969696969)
	DEP( 0xa5a5a5a5a5a5a1a7, 1099511627775, 18, 41, 0xa3fffffffffda1a7)
	EXT( 0xa5a5a5a5a5a5a1a6, 18, 42, 0x0000016969696969)
	EXTU(0xa5a5a5a5a5a5a1a6, 18, 42, 0x0000016969696969)
	DEP( 0xa5a5a5a5a5a5a1a6, 2199023255551, 18, 42, 0xa7fffffffffda1a6)
	EXT( 0xa5a5a5a5a5a5a1a5, 18, 43, 0x0000016969696969)
	EXTU(0xa5a5a5a5a5a5a1a5, 18, 43, 0x0000016969696969)
	DEP( 0xa5a5a5a5a5a5a1a5, 4398046511103, 18, 43, 0xaffffffffffda1a5)
	EXT( 0xa5a5a5a5a5a5a1a4, 18, 44, 0xfffff96969696969)
	EXTU(0xa5a5a5a5a5a5a1a4, 18, 44, 0x0000096969696969)
	DEP( 0xa5a5a5a5a5a5a1a4, 8796093022207, 18, 44, 0x9ffffffffffda1a4)
	EXT( 0xa5a5a5a5a5a5a1a3, 18, 45, 0x0000096969696969)
	EXTU(0xa5a5a5a5a5a5a1a3, 18, 45, 0x0000096969696969)
	DEP( 0xa5a5a5a5a5a5a1a3, 17592186044415, 18, 45, 0xbffffffffffda1a3)
	EXT( 0xa5a5a5a5a5a5a1a2, 19, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a1a2, 19, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a1a2, 0, 19, 1, 0xa5a5a5a5a5a5a1a2)
	EXT( 0xa5a5a5a5a5a5a1a1, 19, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a1a1, 19, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a1a1, 1, 19, 2, 0xa5a5a5a5a5ada1a1)
	EXT( 0xa5a5a5a5a5a5a1a0, 19, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a1a0, 19, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a1a0, 3, 19, 3, 0xa5a5a5a5a59da1a0)
	EXT( 0xa5a5a5a5a5a5a19f, 19, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a5a19f, 19, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a19f, 7, 19, 4, 0xa5a5a5a5a5bda19f)
	EXT( 0xa5a5a5a5a5a5a19e, 19, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a19e, 19, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a5a19e, 15, 19, 5, 0xa5a5a5a5a57da19e)
	EXT( 0xa5a5a5a5a5a5a19d, 19, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a19d, 19, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a19d, 31, 19, 6, 0xa5a5a5a5a4fda19d)
	EXT( 0xa5a5a5a5a5a5a19c, 19, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a5a19c, 19, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a19c, 63, 19, 7, 0xa5a5a5a5a5fda19c)
	EXT( 0xa5a5a5a5a5a5a19b, 19, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a5a19b, 19, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a19b, 127, 19, 8, 0xa5a5a5a5a3fda19b)
	EXT( 0xa5a5a5a5a5a5a19a, 19, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a19a, 19, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a19a, 255, 19, 9, 0xa5a5a5a5a7fda19a)
	EXT( 0xa5a5a5a5a5a5a199, 19, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a199, 19, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a199, 511, 19, 10, 0xa5a5a5a5affda199)
	EXT( 0xa5a5a5a5a5a5a198, 19, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a5a198, 19, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a198, 1023, 19, 11, 0xa5a5a5a59ffda198)
	EXT( 0xa5a5a5a5a5a5a197, 19, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a5a197, 19, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a197, 2047, 19, 12, 0xa5a5a5a5bffda197)
	EXT( 0xa5a5a5a5a5a5a196, 19, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a196, 19, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a5a196, 4095, 19, 13, 0xa5a5a5a57ffda196)
	EXT( 0xa5a5a5a5a5a5a195, 19, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a195, 19, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a195, 8191, 19, 14, 0xa5a5a5a4fffda195)
	EXT( 0xa5a5a5a5a5a5a194, 19, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a5a194, 19, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a194, 16383, 19, 15, 0xa5a5a5a5fffda194)
	EXT( 0xa5a5a5a5a5a5a193, 19, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a5a193, 19, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a193, 32767, 19, 16, 0xa5a5a5a3fffda193)
	EXT( 0xa5a5a5a5a5a5a192, 19, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a192, 19, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a192, 65535, 19, 17, 0xa5a5a5a7fffda192)
	EXT( 0xa5a5a5a5a5a5a191, 19, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a191, 19, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a191, 131071, 19, 18, 0xa5a5a5affffda191)
	EXT( 0xa5a5a5a5a5a5a190, 19, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a5a190, 19, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a190, 262143, 19, 19, 0xa5a5a59ffffda190)
	EXT( 0xa5a5a5a5a5a5a18f, 19, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a5a18f, 19, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a18f, 524287, 19, 20, 0xa5a5a5bffffda18f)
	EXT( 0xa5a5a5a5a5a5a18e, 19, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a18e, 19, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a5a18e, 1048575, 19, 21, 0xa5a5a57ffffda18e)
	EXT( 0xa5a5a5a5a5a5a18d, 19, 22, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a18d, 19, 22, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a18d, 2097151, 19, 22, 0xa5a5a4fffffda18d)
	EXT( 0xa5a5a5a5a5a5a18c, 19, 23, 0x000000000034b4b4)
	EXTU(0xa5a5a5a5a5a5a18c, 19, 23, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a18c, 4194303, 19, 23, 0xa5a5a5fffffda18c)
	EXT( 0xa5a5a5a5a5a5a18b, 19, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a5a18b, 19, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a18b, 8388607, 19, 24, 0xa5a5a3fffffda18b)
	EXT( 0xa5a5a5a5a5a5a18a, 19, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a18a, 19, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a18a, 16777215, 19, 25, 0xa5a5a7fffffda18a)
	EXT( 0xa5a5a5a5a5a5a189, 19, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a189, 19, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a189, 33554431, 19, 26, 0xa5a5affffffda189)
	EXT( 0xa5a5a5a5a5a5a188, 19, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a5a188, 19, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a188, 67108863, 19, 27, 0xa5a59ffffffda188)
	EXT( 0xa5a5a5a5a5a5a187, 19, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a5a187, 19, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a187, 134217727, 19, 28, 0xa5a5bffffffda187)
	EXT( 0xa5a5a5a5a5a5a186, 19, 29, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a186, 19, 29, 0x0000000014b4b4b4)
	DEP( 0xa5a5a5a5a5a5a186, 268435455, 19, 29, 0xa5a57ffffffda186)
	EXT( 0xa5a5a5a5a5a5a185, 19, 30, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a185, 19, 30, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a185, 536870911, 19, 30, 0xa5a4fffffffda185)
	EXT( 0xa5a5a5a5a5a5a184, 19, 31, 0x0000000034b4b4b4)
	EXTU(0xa5a5a5a5a5a5a184, 19, 31, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a184, 1073741823, 19, 31, 0xa5a5fffffffda184)
	EXT( 0xa5a5a5a5a5a5a183, 19, 32, 0xffffffffb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a183, 19, 32, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a183, 2147483647, 19, 32, 0xa5a3fffffffda183)
	EXT( 0xa5a5a5a5a5a5a182, 19, 33, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a182, 19, 33, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a182, 4294967295, 19, 33, 0xa5a7fffffffda182)
	EXT( 0xa5a5a5a5a5a5a181, 19, 34, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a181, 19, 34, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a181, 8589934591, 19, 34, 0xa5affffffffda181)
	EXT( 0xa5a5a5a5a5a5a180, 19, 35, 0xfffffffcb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a180, 19, 35, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a180, 17179869183, 19, 35, 0xa59ffffffffda180)
	EXT( 0xa5a5a5a5a5a5a17f, 19, 36, 0x00000004b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a17f, 19, 36, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a17f, 34359738367, 19, 36, 0xa5bffffffffda17f)
	EXT( 0xa5a5a5a5a5a5a17e, 19, 37, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a17e, 19, 37, 0x00000014b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a17e, 68719476735, 19, 37, 0xa57ffffffffda17e)
	EXT( 0xa5a5a5a5a5a5a17d, 19, 38, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a17d, 19, 38, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a17d, 137438953471, 19, 38, 0xa4fffffffffda17d)
	EXT( 0xa5a5a5a5a5a5a17c, 19, 39, 0x00000034b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a17c, 19, 39, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a17c, 274877906943, 19, 39, 0xa5fffffffffda17c)
	EXT( 0xa5a5a5a5a5a5a17b, 19, 40, 0xffffffb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a17b, 19, 40, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a17b, 549755813887, 19, 40, 0xa3fffffffffda17b)
	EXT( 0xa5a5a5a5a5a5a17a, 19, 41, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a17a, 19, 41, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a17a, 1099511627775, 19, 41, 0xa7fffffffffda17a)
	EXT( 0xa5a5a5a5a5a5a179, 19, 42, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a179, 19, 42, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a179, 2199023255551, 19, 42, 0xaffffffffffda179)
	EXT( 0xa5a5a5a5a5a5a178, 19, 43, 0xfffffcb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a178, 19, 43, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a178, 4398046511103, 19, 43, 0x9ffffffffffda178)
	EXT( 0xa5a5a5a5a5a5a177, 19, 44, 0x000004b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a177, 19, 44, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a177, 8796093022207, 19, 44, 0xbffffffffffda177)
	EXT( 0xa5a5a5a5a5a5a176, 20, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a176, 20, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a176, 0, 20, 1, 0xa5a5a5a5a5a5a176)
	EXT( 0xa5a5a5a5a5a5a175, 20, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a175, 20, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a175, 1, 20, 2, 0xa5a5a5a5a595a175)
	EXT( 0xa5a5a5a5a5a5a174, 20, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a174, 20, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a174, 3, 20, 3, 0xa5a5a5a5a5b5a174)
	EXT( 0xa5a5a5a5a5a5a173, 20, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a173, 20, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a173, 7, 20, 4, 0xa5a5a5a5a575a173)
	EXT( 0xa5a5a5a5a5a5a172, 20, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a172, 20, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a172, 15, 20, 5, 0xa5a5a5a5a4f5a172)
	EXT( 0xa5a5a5a5a5a5a171, 20, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a5a171, 20, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a171, 31, 20, 6, 0xa5a5a5a5a5f5a171)
	EXT( 0xa5a5a5a5a5a5a170, 20, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a5a170, 20, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a170, 63, 20, 7, 0xa5a5a5a5a3f5a170)
	EXT( 0xa5a5a5a5a5a5a16f, 20, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a16f, 20, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a16f, 127, 20, 8, 0xa5a5a5a5a7f5a16f)
	EXT( 0xa5a5a5a5a5a5a16e, 20, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a16e, 20, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a16e, 255, 20, 9, 0xa5a5a5a5aff5a16e)
	EXT( 0xa5a5a5a5a5a5a16d, 20, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a5a16d, 20, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a16d, 511, 20, 10, 0xa5a5a5a59ff5a16d)
	EXT( 0xa5a5a5a5a5a5a16c, 20, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a5a16c, 20, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a16c, 1023, 20, 11, 0xa5a5a5a5bff5a16c)
	EXT( 0xa5a5a5a5a5a5a16b, 20, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a16b, 20, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a5a16b, 2047, 20, 12, 0xa5a5a5a57ff5a16b)
	EXT( 0xa5a5a5a5a5a5a16a, 20, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a16a, 20, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a16a, 4095, 20, 13, 0xa5a5a5a4fff5a16a)
	EXT( 0xa5a5a5a5a5a5a169, 20, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a5a169, 20, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a169, 8191, 20, 14, 0xa5a5a5a5fff5a169)
	EXT( 0xa5a5a5a5a5a5a168, 20, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a5a168, 20, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a168, 16383, 20, 15, 0xa5a5a5a3fff5a168)
	EXT( 0xa5a5a5a5a5a5a167, 20, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a167, 20, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a167, 32767, 20, 16, 0xa5a5a5a7fff5a167)
	EXT( 0xa5a5a5a5a5a5a166, 20, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a166, 20, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a166, 65535, 20, 17, 0xa5a5a5affff5a166)
	EXT( 0xa5a5a5a5a5a5a165, 20, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a5a165, 20, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a165, 131071, 20, 18, 0xa5a5a59ffff5a165)
	EXT( 0xa5a5a5a5a5a5a164, 20, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a5a164, 20, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a164, 262143, 20, 19, 0xa5a5a5bffff5a164)
	EXT( 0xa5a5a5a5a5a5a163, 20, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a163, 20, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a5a163, 524287, 20, 20, 0xa5a5a57ffff5a163)
	EXT( 0xa5a5a5a5a5a5a162, 20, 21, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a162, 20, 21, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a162, 1048575, 20, 21, 0xa5a5a4fffff5a162)
	EXT( 0xa5a5a5a5a5a5a161, 20, 22, 0x00000000001a5a5a)
	EXTU(0xa5a5a5a5a5a5a161, 20, 22, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a161, 2097151, 20, 22, 0xa5a5a5fffff5a161)
	EXT( 0xa5a5a5a5a5a5a160, 20, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a5a160, 20, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a160, 4194303, 20, 23, 0xa5a5a3fffff5a160)
	EXT( 0xa5a5a5a5a5a5a15f, 20, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a15f, 20, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a15f, 8388607, 20, 24, 0xa5a5a7fffff5a15f)
	EXT( 0xa5a5a5a5a5a5a15e, 20, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a15e, 20, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a15e, 16777215, 20, 25, 0xa5a5affffff5a15e)
	EXT( 0xa5a5a5a5a5a5a15d, 20, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a5a15d, 20, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a15d, 33554431, 20, 26, 0xa5a59ffffff5a15d)
	EXT( 0xa5a5a5a5a5a5a15c, 20, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a5a15c, 20, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a15c, 67108863, 20, 27, 0xa5a5bffffff5a15c)
	EXT( 0xa5a5a5a5a5a5a15b, 20, 28, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a15b, 20, 28, 0x000000000a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a15b, 134217727, 20, 28, 0xa5a57ffffff5a15b)
	EXT( 0xa5a5a5a5a5a5a15a, 20, 29, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a15a, 20, 29, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a15a, 268435455, 20, 29, 0xa5a4fffffff5a15a)
	EXT( 0xa5a5a5a5a5a5a159, 20, 30, 0x000000001a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a159, 20, 30, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a159, 536870911, 20, 30, 0xa5a5fffffff5a159)
	EXT( 0xa5a5a5a5a5a5a158, 20, 31, 0xffffffffda5a5a5a)
	EXTU(0xa5a5a5a5a5a5a158, 20, 31, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a158, 1073741823, 20, 31, 0xa5a3fffffff5a158)
	EXT( 0xa5a5a5a5a5a5a157, 20, 32, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a157, 20, 32, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a157, 2147483647, 20, 32, 0xa5a7fffffff5a157)
	EXT( 0xa5a5a5a5a5a5a156, 20, 33, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a156, 20, 33, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a156, 4294967295, 20, 33, 0xa5affffffff5a156)
	EXT( 0xa5a5a5a5a5a5a155, 20, 34, 0xfffffffe5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a155, 20, 34, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a155, 8589934591, 20, 34, 0xa59ffffffff5a155)
	EXT( 0xa5a5a5a5a5a5a154, 20, 35, 0x000000025a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a154, 20, 35, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a154, 17179869183, 20, 35, 0xa5bffffffff5a154)
	EXT( 0xa5a5a5a5a5a5a153, 20, 36, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a153, 20, 36, 0x0000000a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a153, 34359738367, 20, 36, 0xa57ffffffff5a153)
	EXT( 0xa5a5a5a5a5a5a152, 20, 37, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a152, 20, 37, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a152, 68719476735, 20, 37, 0xa4fffffffff5a152)
	EXT( 0xa5a5a5a5a5a5a151, 20, 38, 0x0000001a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a151, 20, 38, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a151, 137438953471, 20, 38, 0xa5fffffffff5a151)
	EXT( 0xa5a5a5a5a5a5a150, 20, 39, 0xffffffda5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a150, 20, 39, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a150, 274877906943, 20, 39, 0xa3fffffffff5a150)
	EXT( 0xa5a5a5a5a5a5a14f, 20, 40, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a14f, 20, 40, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a14f, 549755813887, 20, 40, 0xa7fffffffff5a14f)
	EXT( 0xa5a5a5a5a5a5a14e, 20, 41, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a14e, 20, 41, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a14e, 1099511627775, 20, 41, 0xaffffffffff5a14e)
	EXT( 0xa5a5a5a5a5a5a14d, 20, 42, 0xfffffe5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a14d, 20, 42, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a14d, 2199023255551, 20, 42, 0x9ffffffffff5a14d)
	EXT( 0xa5a5a5a5a5a5a14c, 20, 43, 0x0000025a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a14c, 20, 43, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a14c, 4398046511103, 20, 43, 0xbffffffffff5a14c)
	EXT( 0xa5a5a5a5a5a5a14b, 21, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a14b, 21, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a14b, 0, 21, 1, 0xa5a5a5a5a585a14b)
	EXT( 0xa5a5a5a5a5a5a14a, 21, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a14a, 21, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a14a, 1, 21, 2, 0xa5a5a5a5a5a5a14a)
	EXT( 0xa5a5a5a5a5a5a149, 21, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a149, 21, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a149, 3, 21, 3, 0xa5a5a5a5a565a149)
	EXT( 0xa5a5a5a5a5a5a148, 21, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a148, 21, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a148, 7, 21, 4, 0xa5a5a5a5a4e5a148)
	EXT( 0xa5a5a5a5a5a5a147, 21, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a5a147, 21, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a147, 15, 21, 5, 0xa5a5a5a5a5e5a147)
	EXT( 0xa5a5a5a5a5a5a146, 21, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a5a146, 21, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a146, 31, 21, 6, 0xa5a5a5a5a3e5a146)
	EXT( 0xa5a5a5a5a5a5a145, 21, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a145, 21, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a145, 63, 21, 7, 0xa5a5a5a5a7e5a145)
	EXT( 0xa5a5a5a5a5a5a144, 21, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a144, 21, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a144, 127, 21, 8, 0xa5a5a5a5afe5a144)
	EXT( 0xa5a5a5a5a5a5a143, 21, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a5a143, 21, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a143, 255, 21, 9, 0xa5a5a5a59fe5a143)
	EXT( 0xa5a5a5a5a5a5a142, 21, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a5a142, 21, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a142, 511, 21, 10, 0xa5a5a5a5bfe5a142)
	EXT( 0xa5a5a5a5a5a5a141, 21, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a141, 21, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a5a141, 1023, 21, 11, 0xa5a5a5a57fe5a141)
	EXT( 0xa5a5a5a5a5a5a140, 21, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a140, 21, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a140, 2047, 21, 12, 0xa5a5a5a4ffe5a140)
	EXT( 0xa5a5a5a5a5a5a13f, 21, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a5a13f, 21, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a13f, 4095, 21, 13, 0xa5a5a5a5ffe5a13f)
	EXT( 0xa5a5a5a5a5a5a13e, 21, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a5a13e, 21, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a13e, 8191, 21, 14, 0xa5a5a5a3ffe5a13e)
	EXT( 0xa5a5a5a5a5a5a13d, 21, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a13d, 21, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a13d, 16383, 21, 15, 0xa5a5a5a7ffe5a13d)
	EXT( 0xa5a5a5a5a5a5a13c, 21, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a13c, 21, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a13c, 32767, 21, 16, 0xa5a5a5afffe5a13c)
	EXT( 0xa5a5a5a5a5a5a13b, 21, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a5a13b, 21, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a13b, 65535, 21, 17, 0xa5a5a59fffe5a13b)
	EXT( 0xa5a5a5a5a5a5a13a, 21, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a5a13a, 21, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a13a, 131071, 21, 18, 0xa5a5a5bfffe5a13a)
	EXT( 0xa5a5a5a5a5a5a139, 21, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a139, 21, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a5a139, 262143, 21, 19, 0xa5a5a57fffe5a139)
	EXT( 0xa5a5a5a5a5a5a138, 21, 20, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a138, 21, 20, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a138, 524287, 21, 20, 0xa5a5a4ffffe5a138)
	EXT( 0xa5a5a5a5a5a5a137, 21, 21, 0x00000000000d2d2d)
	EXTU(0xa5a5a5a5a5a5a137, 21, 21, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a137, 1048575, 21, 21, 0xa5a5a5ffffe5a137)
	EXT( 0xa5a5a5a5a5a5a136, 21, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a5a136, 21, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a136, 2097151, 21, 22, 0xa5a5a3ffffe5a136)
	EXT( 0xa5a5a5a5a5a5a135, 21, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a135, 21, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a135, 4194303, 21, 23, 0xa5a5a7ffffe5a135)
	EXT( 0xa5a5a5a5a5a5a134, 21, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a134, 21, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a134, 8388607, 21, 24, 0xa5a5afffffe5a134)
	EXT( 0xa5a5a5a5a5a5a133, 21, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a5a133, 21, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a133, 16777215, 21, 25, 0xa5a59fffffe5a133)
	EXT( 0xa5a5a5a5a5a5a132, 21, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a5a132, 21, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a132, 33554431, 21, 26, 0xa5a5bfffffe5a132)
	EXT( 0xa5a5a5a5a5a5a131, 21, 27, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a131, 21, 27, 0x00000000052d2d2d)
	DEP( 0xa5a5a5a5a5a5a131, 67108863, 21, 27, 0xa5a57fffffe5a131)
	EXT( 0xa5a5a5a5a5a5a130, 21, 28, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a130, 21, 28, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a130, 134217727, 21, 28, 0xa5a4ffffffe5a130)
	EXT( 0xa5a5a5a5a5a5a12f, 21, 29, 0x000000000d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a12f, 21, 29, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a12f, 268435455, 21, 29, 0xa5a5ffffffe5a12f)
	EXT( 0xa5a5a5a5a5a5a12e, 21, 30, 0xffffffffed2d2d2d)
	EXTU(0xa5a5a5a5a5a5a12e, 21, 30, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a12e, 536870911, 21, 30, 0xa5a3ffffffe5a12e)
	EXT( 0xa5a5a5a5a5a5a12d, 21, 31, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a12d, 21, 31, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a12d, 1073741823, 21, 31, 0xa5a7ffffffe5a12d)
	EXT( 0xa5a5a5a5a5a5a12c, 21, 32, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a12c, 21, 32, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a12c, 2147483647, 21, 32, 0xa5afffffffe5a12c)
	EXT( 0xa5a5a5a5a5a5a12b, 21, 33, 0xffffffff2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a12b, 21, 33, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a12b, 4294967295, 21, 33, 0xa59fffffffe5a12b)
	EXT( 0xa5a5a5a5a5a5a12a, 21, 34, 0x000000012d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a12a, 21, 34, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a12a, 8589934591, 21, 34, 0xa5bfffffffe5a12a)
	EXT( 0xa5a5a5a5a5a5a129, 21, 35, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a129, 21, 35, 0x000000052d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a129, 17179869183, 21, 35, 0xa57fffffffe5a129)
	EXT( 0xa5a5a5a5a5a5a128, 21, 36, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a128, 21, 36, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a128, 34359738367, 21, 36, 0xa4ffffffffe5a128)
	EXT( 0xa5a5a5a5a5a5a127, 21, 37, 0x0000000d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a127, 21, 37, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a127, 68719476735, 21, 37, 0xa5ffffffffe5a127)
	EXT( 0xa5a5a5a5a5a5a126, 21, 38, 0xffffffed2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a126, 21, 38, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a126, 137438953471, 21, 38, 0xa3ffffffffe5a126)
	EXT( 0xa5a5a5a5a5a5a125, 21, 39, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a125, 21, 39, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a125, 274877906943, 21, 39, 0xa7ffffffffe5a125)
	EXT( 0xa5a5a5a5a5a5a124, 21, 40, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a124, 21, 40, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a124, 549755813887, 21, 40, 0xafffffffffe5a124)
	EXT( 0xa5a5a5a5a5a5a123, 21, 41, 0xffffff2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a123, 21, 41, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a123, 1099511627775, 21, 41, 0x9fffffffffe5a123)
	EXT( 0xa5a5a5a5a5a5a122, 21, 42, 0x0000012d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a122, 21, 42, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a122, 2199023255551, 21, 42, 0xbfffffffffe5a122)
	EXT( 0xa5a5a5a5a5a5a121, 22, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a121, 22, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a121, 0, 22, 1, 0xa5a5a5a5a5a5a121)
	EXT( 0xa5a5a5a5a5a5a120, 22, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a120, 22, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a120, 1, 22, 2, 0xa5a5a5a5a565a120)
	EXT( 0xa5a5a5a5a5a5a11f, 22, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a11f, 22, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a11f, 3, 22, 3, 0xa5a5a5a5a4e5a11f)
	EXT( 0xa5a5a5a5a5a5a11e, 22, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a5a11e, 22, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a11e, 7, 22, 4, 0xa5a5a5a5a5e5a11e)
	EXT( 0xa5a5a5a5a5a5a11d, 22, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a5a11d, 22, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a11d, 15, 22, 5, 0xa5a5a5a5a3e5a11d)
	EXT( 0xa5a5a5a5a5a5a11c, 22, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a11c, 22, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a11c, 31, 22, 6, 0xa5a5a5a5a7e5a11c)
	EXT( 0xa5a5a5a5a5a5a11b, 22, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a11b, 22, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a11b, 63, 22, 7, 0xa5a5a5a5afe5a11b)
	EXT( 0xa5a5a5a5a5a5a11a, 22, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a5a11a, 22, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a11a, 127, 22, 8, 0xa5a5a5a59fe5a11a)
	EXT( 0xa5a5a5a5a5a5a119, 22, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a5a119, 22, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a119, 255, 22, 9, 0xa5a5a5a5bfe5a119)
	EXT( 0xa5a5a5a5a5a5a118, 22, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a118, 22, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a5a118, 511, 22, 10, 0xa5a5a5a57fe5a118)
	EXT( 0xa5a5a5a5a5a5a117, 22, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a117, 22, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a117, 1023, 22, 11, 0xa5a5a5a4ffe5a117)
	EXT( 0xa5a5a5a5a5a5a116, 22, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a5a116, 22, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a116, 2047, 22, 12, 0xa5a5a5a5ffe5a116)
	EXT( 0xa5a5a5a5a5a5a115, 22, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a5a115, 22, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a115, 4095, 22, 13, 0xa5a5a5a3ffe5a115)
	EXT( 0xa5a5a5a5a5a5a114, 22, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a114, 22, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a114, 8191, 22, 14, 0xa5a5a5a7ffe5a114)
	EXT( 0xa5a5a5a5a5a5a113, 22, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a113, 22, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a113, 16383, 22, 15, 0xa5a5a5afffe5a113)
	EXT( 0xa5a5a5a5a5a5a112, 22, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a5a112, 22, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a112, 32767, 22, 16, 0xa5a5a59fffe5a112)
	EXT( 0xa5a5a5a5a5a5a111, 22, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a5a111, 22, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a111, 65535, 22, 17, 0xa5a5a5bfffe5a111)
	EXT( 0xa5a5a5a5a5a5a110, 22, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a110, 22, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a5a110, 131071, 22, 18, 0xa5a5a57fffe5a110)
	EXT( 0xa5a5a5a5a5a5a10f, 22, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a10f, 22, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a10f, 262143, 22, 19, 0xa5a5a4ffffe5a10f)
	EXT( 0xa5a5a5a5a5a5a10e, 22, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a5a10e, 22, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a10e, 524287, 22, 20, 0xa5a5a5ffffe5a10e)
	EXT( 0xa5a5a5a5a5a5a10d, 22, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a5a10d, 22, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a10d, 1048575, 22, 21, 0xa5a5a3ffffe5a10d)
	EXT( 0xa5a5a5a5a5a5a10c, 22, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a10c, 22, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a10c, 2097151, 22, 22, 0xa5a5a7ffffe5a10c)
	EXT( 0xa5a5a5a5a5a5a10b, 22, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a10b, 22, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a10b, 4194303, 22, 23, 0xa5a5afffffe5a10b)
	EXT( 0xa5a5a5a5a5a5a10a, 22, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a5a10a, 22, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a10a, 8388607, 22, 24, 0xa5a59fffffe5a10a)
	EXT( 0xa5a5a5a5a5a5a109, 22, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a5a109, 22, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a109, 16777215, 22, 25, 0xa5a5bfffffe5a109)
	EXT( 0xa5a5a5a5a5a5a108, 22, 26, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a108, 22, 26, 0x0000000002969696)
	DEP( 0xa5a5a5a5a5a5a108, 33554431, 22, 26, 0xa5a57fffffe5a108)
	EXT( 0xa5a5a5a5a5a5a107, 22, 27, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a107, 22, 27, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a107, 67108863, 22, 27, 0xa5a4ffffffe5a107)
	EXT( 0xa5a5a5a5a5a5a106, 22, 28, 0x0000000006969696)
	EXTU(0xa5a5a5a5a5a5a106, 22, 28, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a106, 134217727, 22, 28, 0xa5a5ffffffe5a106)
	EXT( 0xa5a5a5a5a5a5a105, 22, 29, 0xfffffffff6969696)
	EXTU(0xa5a5a5a5a5a5a105, 22, 29, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a105, 268435455, 22, 29, 0xa5a3ffffffe5a105)
	EXT( 0xa5a5a5a5a5a5a104, 22, 30, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a104, 22, 30, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a104, 536870911, 22, 30, 0xa5a7ffffffe5a104)
	EXT( 0xa5a5a5a5a5a5a103, 22, 31, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a103, 22, 31, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a103, 1073741823, 22, 31, 0xa5afffffffe5a103)
	EXT( 0xa5a5a5a5a5a5a102, 22, 32, 0xffffffff96969696)
	EXTU(0xa5a5a5a5a5a5a102, 22, 32, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a102, 2147483647, 22, 32, 0xa59fffffffe5a102)
	EXT( 0xa5a5a5a5a5a5a101, 22, 33, 0x0000000096969696)
	EXTU(0xa5a5a5a5a5a5a101, 22, 33, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a101, 4294967295, 22, 33, 0xa5bfffffffe5a101)
	EXT( 0xa5a5a5a5a5a5a100, 22, 34, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a100, 22, 34, 0x0000000296969696)
	DEP( 0xa5a5a5a5a5a5a100, 8589934591, 22, 34, 0xa57fffffffe5a100)
	EXT( 0xa5a5a5a5a5a5a0ff, 22, 35, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a0ff, 22, 35, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a0ff, 17179869183, 22, 35, 0xa4ffffffffe5a0ff)
	EXT( 0xa5a5a5a5a5a5a0fe, 22, 36, 0x0000000696969696)
	EXTU(0xa5a5a5a5a5a5a0fe, 22, 36, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a0fe, 34359738367, 22, 36, 0xa5ffffffffe5a0fe)
	EXT( 0xa5a5a5a5a5a5a0fd, 22, 37, 0xfffffff696969696)
	EXTU(0xa5a5a5a5a5a5a0fd, 22, 37, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a0fd, 68719476735, 22, 37, 0xa3ffffffffe5a0fd)
	EXT( 0xa5a5a5a5a5a5a0fc, 22, 38, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a0fc, 22, 38, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a0fc, 137438953471, 22, 38, 0xa7ffffffffe5a0fc)
	EXT( 0xa5a5a5a5a5a5a0fb, 22, 39, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a0fb, 22, 39, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a0fb, 274877906943, 22, 39, 0xafffffffffe5a0fb)
	EXT( 0xa5a5a5a5a5a5a0fa, 22, 40, 0xffffff9696969696)
	EXTU(0xa5a5a5a5a5a5a0fa, 22, 40, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a0fa, 549755813887, 22, 40, 0x9fffffffffe5a0fa)
	EXT( 0xa5a5a5a5a5a5a0f9, 22, 41, 0x0000009696969696)
	EXTU(0xa5a5a5a5a5a5a0f9, 22, 41, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a0f9, 1099511627775, 22, 41, 0xbfffffffffe5a0f9)
	EXT( 0xa5a5a5a5a5a5a0f8, 23, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a0f8, 23, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a0f8, 0, 23, 1, 0xa5a5a5a5a525a0f8)
	EXT( 0xa5a5a5a5a5a5a0f7, 23, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a0f7, 23, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a0f7, 1, 23, 2, 0xa5a5a5a5a4a5a0f7)
	EXT( 0xa5a5a5a5a5a5a0f6, 23, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a0f6, 23, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a0f6, 3, 23, 3, 0xa5a5a5a5a5a5a0f6)
	EXT( 0xa5a5a5a5a5a5a0f5, 23, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a5a0f5, 23, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a0f5, 7, 23, 4, 0xa5a5a5a5a3a5a0f5)
	EXT( 0xa5a5a5a5a5a5a0f4, 23, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a0f4, 23, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a0f4, 15, 23, 5, 0xa5a5a5a5a7a5a0f4)
	EXT( 0xa5a5a5a5a5a5a0f3, 23, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a0f3, 23, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a0f3, 31, 23, 6, 0xa5a5a5a5afa5a0f3)
	EXT( 0xa5a5a5a5a5a5a0f2, 23, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a5a0f2, 23, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a0f2, 63, 23, 7, 0xa5a5a5a59fa5a0f2)
	EXT( 0xa5a5a5a5a5a5a0f1, 23, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a5a0f1, 23, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a0f1, 127, 23, 8, 0xa5a5a5a5bfa5a0f1)
	EXT( 0xa5a5a5a5a5a5a0f0, 23, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a0f0, 23, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a5a0f0, 255, 23, 9, 0xa5a5a5a57fa5a0f0)
	EXT( 0xa5a5a5a5a5a5a0ef, 23, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a0ef, 23, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a0ef, 511, 23, 10, 0xa5a5a5a4ffa5a0ef)
	EXT( 0xa5a5a5a5a5a5a0ee, 23, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a5a0ee, 23, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a0ee, 1023, 23, 11, 0xa5a5a5a5ffa5a0ee)
	EXT( 0xa5a5a5a5a5a5a0ed, 23, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a5a0ed, 23, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a0ed, 2047, 23, 12, 0xa5a5a5a3ffa5a0ed)
	EXT( 0xa5a5a5a5a5a5a0ec, 23, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a0ec, 23, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a0ec, 4095, 23, 13, 0xa5a5a5a7ffa5a0ec)
	EXT( 0xa5a5a5a5a5a5a0eb, 23, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a0eb, 23, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a0eb, 8191, 23, 14, 0xa5a5a5afffa5a0eb)
	EXT( 0xa5a5a5a5a5a5a0ea, 23, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a5a0ea, 23, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a0ea, 16383, 23, 15, 0xa5a5a59fffa5a0ea)
	EXT( 0xa5a5a5a5a5a5a0e9, 23, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a5a0e9, 23, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a0e9, 32767, 23, 16, 0xa5a5a5bfffa5a0e9)
	EXT( 0xa5a5a5a5a5a5a0e8, 23, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a0e8, 23, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a5a0e8, 65535, 23, 17, 0xa5a5a57fffa5a0e8)
	EXT( 0xa5a5a5a5a5a5a0e7, 23, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a0e7, 23, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a0e7, 131071, 23, 18, 0xa5a5a4ffffa5a0e7)
	EXT( 0xa5a5a5a5a5a5a0e6, 23, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a5a0e6, 23, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a0e6, 262143, 23, 19, 0xa5a5a5ffffa5a0e6)
	EXT( 0xa5a5a5a5a5a5a0e5, 23, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a5a0e5, 23, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a0e5, 524287, 23, 20, 0xa5a5a3ffffa5a0e5)
	EXT( 0xa5a5a5a5a5a5a0e4, 23, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a0e4, 23, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a0e4, 1048575, 23, 21, 0xa5a5a7ffffa5a0e4)
	EXT( 0xa5a5a5a5a5a5a0e3, 23, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a0e3, 23, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a0e3, 2097151, 23, 22, 0xa5a5afffffa5a0e3)
	EXT( 0xa5a5a5a5a5a5a0e2, 23, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a5a0e2, 23, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a0e2, 4194303, 23, 23, 0xa5a59fffffa5a0e2)
	EXT( 0xa5a5a5a5a5a5a0e1, 23, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a5a0e1, 23, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a0e1, 8388607, 23, 24, 0xa5a5bfffffa5a0e1)
	EXT( 0xa5a5a5a5a5a5a0e0, 23, 25, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0e0, 23, 25, 0x00000000014b4b4b)
	DEP( 0xa5a5a5a5a5a5a0e0, 16777215, 23, 25, 0xa5a57fffffa5a0e0)
	EXT( 0xa5a5a5a5a5a5a0df, 23, 26, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0df, 23, 26, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a0df, 33554431, 23, 26, 0xa5a4ffffffa5a0df)
	EXT( 0xa5a5a5a5a5a5a0de, 23, 27, 0x00000000034b4b4b)
	EXTU(0xa5a5a5a5a5a5a0de, 23, 27, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a0de, 67108863, 23, 27, 0xa5a5ffffffa5a0de)
	EXT( 0xa5a5a5a5a5a5a0dd, 23, 28, 0xfffffffffb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0dd, 23, 28, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0dd, 134217727, 23, 28, 0xa5a3ffffffa5a0dd)
	EXT( 0xa5a5a5a5a5a5a0dc, 23, 29, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0dc, 23, 29, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0dc, 268435455, 23, 29, 0xa5a7ffffffa5a0dc)
	EXT( 0xa5a5a5a5a5a5a0db, 23, 30, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0db, 23, 30, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0db, 536870911, 23, 30, 0xa5afffffffa5a0db)
	EXT( 0xa5a5a5a5a5a5a0da, 23, 31, 0xffffffffcb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0da, 23, 31, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0da, 1073741823, 23, 31, 0xa59fffffffa5a0da)
	EXT( 0xa5a5a5a5a5a5a0d9, 23, 32, 0x000000004b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d9, 23, 32, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d9, 2147483647, 23, 32, 0xa5bfffffffa5a0d9)
	EXT( 0xa5a5a5a5a5a5a0d8, 23, 33, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d8, 23, 33, 0x000000014b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d8, 4294967295, 23, 33, 0xa57fffffffa5a0d8)
	EXT( 0xa5a5a5a5a5a5a0d7, 23, 34, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d7, 23, 34, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d7, 8589934591, 23, 34, 0xa4ffffffffa5a0d7)
	EXT( 0xa5a5a5a5a5a5a0d6, 23, 35, 0x000000034b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d6, 23, 35, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d6, 17179869183, 23, 35, 0xa5ffffffffa5a0d6)
	EXT( 0xa5a5a5a5a5a5a0d5, 23, 36, 0xfffffffb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d5, 23, 36, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d5, 34359738367, 23, 36, 0xa3ffffffffa5a0d5)
	EXT( 0xa5a5a5a5a5a5a0d4, 23, 37, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d4, 23, 37, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d4, 68719476735, 23, 37, 0xa7ffffffffa5a0d4)
	EXT( 0xa5a5a5a5a5a5a0d3, 23, 38, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d3, 23, 38, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d3, 137438953471, 23, 38, 0xafffffffffa5a0d3)
	EXT( 0xa5a5a5a5a5a5a0d2, 23, 39, 0xffffffcb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d2, 23, 39, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d2, 274877906943, 23, 39, 0x9fffffffffa5a0d2)
	EXT( 0xa5a5a5a5a5a5a0d1, 23, 40, 0x0000004b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0d1, 23, 40, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a0d1, 549755813887, 23, 40, 0xbfffffffffa5a0d1)
	EXT( 0xa5a5a5a5a5a5a0d0, 24, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a0d0, 24, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a0d0, 0, 24, 1, 0xa5a5a5a5a4a5a0d0)
	EXT( 0xa5a5a5a5a5a5a0cf, 24, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a0cf, 24, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a0cf, 1, 24, 2, 0xa5a5a5a5a5a5a0cf)
	EXT( 0xa5a5a5a5a5a5a0ce, 24, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a0ce, 24, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a0ce, 3, 24, 3, 0xa5a5a5a5a3a5a0ce)
	EXT( 0xa5a5a5a5a5a5a0cd, 24, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a0cd, 24, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a0cd, 7, 24, 4, 0xa5a5a5a5a7a5a0cd)
	EXT( 0xa5a5a5a5a5a5a0cc, 24, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a0cc, 24, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a0cc, 15, 24, 5, 0xa5a5a5a5afa5a0cc)
	EXT( 0xa5a5a5a5a5a5a0cb, 24, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a5a0cb, 24, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a0cb, 31, 24, 6, 0xa5a5a5a59fa5a0cb)
	EXT( 0xa5a5a5a5a5a5a0ca, 24, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a5a0ca, 24, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a0ca, 63, 24, 7, 0xa5a5a5a5bfa5a0ca)
	EXT( 0xa5a5a5a5a5a5a0c9, 24, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a0c9, 24, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a5a0c9, 127, 24, 8, 0xa5a5a5a57fa5a0c9)
	EXT( 0xa5a5a5a5a5a5a0c8, 24, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a0c8, 24, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a0c8, 255, 24, 9, 0xa5a5a5a4ffa5a0c8)
	EXT( 0xa5a5a5a5a5a5a0c7, 24, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a5a0c7, 24, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a0c7, 511, 24, 10, 0xa5a5a5a5ffa5a0c7)
	EXT( 0xa5a5a5a5a5a5a0c6, 24, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a5a0c6, 24, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a0c6, 1023, 24, 11, 0xa5a5a5a3ffa5a0c6)
	EXT( 0xa5a5a5a5a5a5a0c5, 24, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a0c5, 24, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a0c5, 2047, 24, 12, 0xa5a5a5a7ffa5a0c5)
	EXT( 0xa5a5a5a5a5a5a0c4, 24, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a0c4, 24, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a0c4, 4095, 24, 13, 0xa5a5a5afffa5a0c4)
	EXT( 0xa5a5a5a5a5a5a0c3, 24, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a5a0c3, 24, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a0c3, 8191, 24, 14, 0xa5a5a59fffa5a0c3)
	EXT( 0xa5a5a5a5a5a5a0c2, 24, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a5a0c2, 24, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a0c2, 16383, 24, 15, 0xa5a5a5bfffa5a0c2)
	EXT( 0xa5a5a5a5a5a5a0c1, 24, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a0c1, 24, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a5a0c1, 32767, 24, 16, 0xa5a5a57fffa5a0c1)
	EXT( 0xa5a5a5a5a5a5a0c0, 24, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a0c0, 24, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a0c0, 65535, 24, 17, 0xa5a5a4ffffa5a0c0)
	EXT( 0xa5a5a5a5a5a5a0bf, 24, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a5a0bf, 24, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a0bf, 131071, 24, 18, 0xa5a5a5ffffa5a0bf)
	EXT( 0xa5a5a5a5a5a5a0be, 24, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a5a0be, 24, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a0be, 262143, 24, 19, 0xa5a5a3ffffa5a0be)
	EXT( 0xa5a5a5a5a5a5a0bd, 24, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a0bd, 24, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a0bd, 524287, 24, 20, 0xa5a5a7ffffa5a0bd)
	EXT( 0xa5a5a5a5a5a5a0bc, 24, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a0bc, 24, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a0bc, 1048575, 24, 21, 0xa5a5afffffa5a0bc)
	EXT( 0xa5a5a5a5a5a5a0bb, 24, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a5a0bb, 24, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a0bb, 2097151, 24, 22, 0xa5a59fffffa5a0bb)
	EXT( 0xa5a5a5a5a5a5a0ba, 24, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a5a0ba, 24, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a0ba, 4194303, 24, 23, 0xa5a5bfffffa5a0ba)
	EXT( 0xa5a5a5a5a5a5a0b9, 24, 24, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b9, 24, 24, 0x0000000000a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b9, 8388607, 24, 24, 0xa5a57fffffa5a0b9)
	EXT( 0xa5a5a5a5a5a5a0b8, 24, 25, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b8, 24, 25, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b8, 16777215, 24, 25, 0xa5a4ffffffa5a0b8)
	EXT( 0xa5a5a5a5a5a5a0b7, 24, 26, 0x0000000001a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b7, 24, 26, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b7, 33554431, 24, 26, 0xa5a5ffffffa5a0b7)
	EXT( 0xa5a5a5a5a5a5a0b6, 24, 27, 0xfffffffffda5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b6, 24, 27, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b6, 67108863, 24, 27, 0xa5a3ffffffa5a0b6)
	EXT( 0xa5a5a5a5a5a5a0b5, 24, 28, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b5, 24, 28, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b5, 134217727, 24, 28, 0xa5a7ffffffa5a0b5)
	EXT( 0xa5a5a5a5a5a5a0b4, 24, 29, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b4, 24, 29, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b4, 268435455, 24, 29, 0xa5afffffffa5a0b4)
	EXT( 0xa5a5a5a5a5a5a0b3, 24, 30, 0xffffffffe5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b3, 24, 30, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b3, 536870911, 24, 30, 0xa59fffffffa5a0b3)
	EXT( 0xa5a5a5a5a5a5a0b2, 24, 31, 0x0000000025a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b2, 24, 31, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b2, 1073741823, 24, 31, 0xa5bfffffffa5a0b2)
	EXT( 0xa5a5a5a5a5a5a0b1, 24, 32, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b1, 24, 32, 0x00000000a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b1, 2147483647, 24, 32, 0xa57fffffffa5a0b1)
	EXT( 0xa5a5a5a5a5a5a0b0, 24, 33, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b0, 24, 33, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b0, 4294967295, 24, 33, 0xa4ffffffffa5a0b0)
	EXT( 0xa5a5a5a5a5a5a0af, 24, 34, 0x00000001a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0af, 24, 34, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0af, 8589934591, 24, 34, 0xa5ffffffffa5a0af)
	EXT( 0xa5a5a5a5a5a5a0ae, 24, 35, 0xfffffffda5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0ae, 24, 35, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0ae, 17179869183, 24, 35, 0xa3ffffffffa5a0ae)
	EXT( 0xa5a5a5a5a5a5a0ad, 24, 36, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0ad, 24, 36, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0ad, 34359738367, 24, 36, 0xa7ffffffffa5a0ad)
	EXT( 0xa5a5a5a5a5a5a0ac, 24, 37, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0ac, 24, 37, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0ac, 68719476735, 24, 37, 0xafffffffffa5a0ac)
	EXT( 0xa5a5a5a5a5a5a0ab, 24, 38, 0xffffffe5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0ab, 24, 38, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0ab, 137438953471, 24, 38, 0x9fffffffffa5a0ab)
	EXT( 0xa5a5a5a5a5a5a0aa, 24, 39, 0x00000025a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a0aa, 24, 39, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0aa, 274877906943, 24, 39, 0xbfffffffffa5a0aa)
	EXT( 0xa5a5a5a5a5a5a0a9, 25, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a0a9, 25, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a0a9, 0, 25, 1, 0xa5a5a5a5a5a5a0a9)
	EXT( 0xa5a5a5a5a5a5a0a8, 25, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a0a8, 25, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a0a8, 1, 25, 2, 0xa5a5a5a5a3a5a0a8)
	EXT( 0xa5a5a5a5a5a5a0a7, 25, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a0a7, 25, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a0a7, 3, 25, 3, 0xa5a5a5a5a7a5a0a7)
	EXT( 0xa5a5a5a5a5a5a0a6, 25, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a0a6, 25, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a0a6, 7, 25, 4, 0xa5a5a5a5afa5a0a6)
	EXT( 0xa5a5a5a5a5a5a0a5, 25, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a5a0a5, 25, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a0a5, 15, 25, 5, 0xa5a5a5a59fa5a0a5)
	EXT( 0xa5a5a5a5a5a5a0a4, 25, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a5a0a4, 25, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a0a4, 31, 25, 6, 0xa5a5a5a5bfa5a0a4)
	EXT( 0xa5a5a5a5a5a5a0a3, 25, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a0a3, 25, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a5a0a3, 63, 25, 7, 0xa5a5a5a57fa5a0a3)
	EXT( 0xa5a5a5a5a5a5a0a2, 25, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a0a2, 25, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a0a2, 127, 25, 8, 0xa5a5a5a4ffa5a0a2)
	EXT( 0xa5a5a5a5a5a5a0a1, 25, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a5a0a1, 25, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a0a1, 255, 25, 9, 0xa5a5a5a5ffa5a0a1)
	EXT( 0xa5a5a5a5a5a5a0a0, 25, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a5a0a0, 25, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a0a0, 511, 25, 10, 0xa5a5a5a3ffa5a0a0)
	EXT( 0xa5a5a5a5a5a5a09f, 25, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a09f, 25, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a09f, 1023, 25, 11, 0xa5a5a5a7ffa5a09f)
	EXT( 0xa5a5a5a5a5a5a09e, 25, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a09e, 25, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a09e, 2047, 25, 12, 0xa5a5a5afffa5a09e)
	EXT( 0xa5a5a5a5a5a5a09d, 25, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a5a09d, 25, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a09d, 4095, 25, 13, 0xa5a5a59fffa5a09d)
	EXT( 0xa5a5a5a5a5a5a09c, 25, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a5a09c, 25, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a09c, 8191, 25, 14, 0xa5a5a5bfffa5a09c)
	EXT( 0xa5a5a5a5a5a5a09b, 25, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a09b, 25, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a5a09b, 16383, 25, 15, 0xa5a5a57fffa5a09b)
	EXT( 0xa5a5a5a5a5a5a09a, 25, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a09a, 25, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a09a, 32767, 25, 16, 0xa5a5a4ffffa5a09a)
	EXT( 0xa5a5a5a5a5a5a099, 25, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a5a099, 25, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a099, 65535, 25, 17, 0xa5a5a5ffffa5a099)
	EXT( 0xa5a5a5a5a5a5a098, 25, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a5a098, 25, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a098, 131071, 25, 18, 0xa5a5a3ffffa5a098)
	EXT( 0xa5a5a5a5a5a5a097, 25, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a097, 25, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a097, 262143, 25, 19, 0xa5a5a7ffffa5a097)
	EXT( 0xa5a5a5a5a5a5a096, 25, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a096, 25, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a096, 524287, 25, 20, 0xa5a5afffffa5a096)
	EXT( 0xa5a5a5a5a5a5a095, 25, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a5a095, 25, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a095, 1048575, 25, 21, 0xa5a59fffffa5a095)
	EXT( 0xa5a5a5a5a5a5a094, 25, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a5a094, 25, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a094, 2097151, 25, 22, 0xa5a5bfffffa5a094)
	EXT( 0xa5a5a5a5a5a5a093, 25, 23, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a093, 25, 23, 0x000000000052d2d2)
	DEP( 0xa5a5a5a5a5a5a093, 4194303, 25, 23, 0xa5a57fffffa5a093)
	EXT( 0xa5a5a5a5a5a5a092, 25, 24, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a092, 25, 24, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a092, 8388607, 25, 24, 0xa5a4ffffffa5a092)
	EXT( 0xa5a5a5a5a5a5a091, 25, 25, 0x0000000000d2d2d2)
	EXTU(0xa5a5a5a5a5a5a091, 25, 25, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a091, 16777215, 25, 25, 0xa5a5ffffffa5a091)
	EXT( 0xa5a5a5a5a5a5a090, 25, 26, 0xfffffffffed2d2d2)
	EXTU(0xa5a5a5a5a5a5a090, 25, 26, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a090, 33554431, 25, 26, 0xa5a3ffffffa5a090)
	EXT( 0xa5a5a5a5a5a5a08f, 25, 27, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a08f, 25, 27, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a08f, 67108863, 25, 27, 0xa5a7ffffffa5a08f)
	EXT( 0xa5a5a5a5a5a5a08e, 25, 28, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a08e, 25, 28, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a08e, 134217727, 25, 28, 0xa5afffffffa5a08e)
	EXT( 0xa5a5a5a5a5a5a08d, 25, 29, 0xfffffffff2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a08d, 25, 29, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a08d, 268435455, 25, 29, 0xa59fffffffa5a08d)
	EXT( 0xa5a5a5a5a5a5a08c, 25, 30, 0x0000000012d2d2d2)
	EXTU(0xa5a5a5a5a5a5a08c, 25, 30, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a08c, 536870911, 25, 30, 0xa5bfffffffa5a08c)
	EXT( 0xa5a5a5a5a5a5a08b, 25, 31, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a08b, 25, 31, 0x0000000052d2d2d2)
	DEP( 0xa5a5a5a5a5a5a08b, 1073741823, 25, 31, 0xa57fffffffa5a08b)
	EXT( 0xa5a5a5a5a5a5a08a, 25, 32, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a08a, 25, 32, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a08a, 2147483647, 25, 32, 0xa4ffffffffa5a08a)
	EXT( 0xa5a5a5a5a5a5a089, 25, 33, 0x00000000d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a089, 25, 33, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a089, 4294967295, 25, 33, 0xa5ffffffffa5a089)
	EXT( 0xa5a5a5a5a5a5a088, 25, 34, 0xfffffffed2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a088, 25, 34, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a088, 8589934591, 25, 34, 0xa3ffffffffa5a088)
	EXT( 0xa5a5a5a5a5a5a087, 25, 35, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a087, 25, 35, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a087, 17179869183, 25, 35, 0xa7ffffffffa5a087)
	EXT( 0xa5a5a5a5a5a5a086, 25, 36, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a086, 25, 36, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a086, 34359738367, 25, 36, 0xafffffffffa5a086)
	EXT( 0xa5a5a5a5a5a5a085, 25, 37, 0xfffffff2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a085, 25, 37, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a085, 68719476735, 25, 37, 0x9fffffffffa5a085)
	EXT( 0xa5a5a5a5a5a5a084, 25, 38, 0x00000012d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a084, 25, 38, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a084, 137438953471, 25, 38, 0xbfffffffffa5a084)
	EXT( 0xa5a5a5a5a5a5a083, 26, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a083, 26, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a083, 0, 26, 1, 0xa5a5a5a5a1a5a083)
	EXT( 0xa5a5a5a5a5a5a082, 26, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a082, 26, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a082, 1, 26, 2, 0xa5a5a5a5a5a5a082)
	EXT( 0xa5a5a5a5a5a5a081, 26, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a081, 26, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a081, 3, 26, 3, 0xa5a5a5a5ada5a081)
	EXT( 0xa5a5a5a5a5a5a080, 26, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a5a080, 26, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a080, 7, 26, 4, 0xa5a5a5a59da5a080)
	EXT( 0xa5a5a5a5a5a5a07f, 26, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a5a07f, 26, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a07f, 15, 26, 5, 0xa5a5a5a5bda5a07f)
	EXT( 0xa5a5a5a5a5a5a07e, 26, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a07e, 26, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a5a07e, 31, 26, 6, 0xa5a5a5a57da5a07e)
	EXT( 0xa5a5a5a5a5a5a07d, 26, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a07d, 26, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a07d, 63, 26, 7, 0xa5a5a5a4fda5a07d)
	EXT( 0xa5a5a5a5a5a5a07c, 26, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a5a07c, 26, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a07c, 127, 26, 8, 0xa5a5a5a5fda5a07c)
	EXT( 0xa5a5a5a5a5a5a07b, 26, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a5a07b, 26, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a07b, 255, 26, 9, 0xa5a5a5a3fda5a07b)
	EXT( 0xa5a5a5a5a5a5a07a, 26, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a07a, 26, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a07a, 511, 26, 10, 0xa5a5a5a7fda5a07a)
	EXT( 0xa5a5a5a5a5a5a079, 26, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a079, 26, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a079, 1023, 26, 11, 0xa5a5a5affda5a079)
	EXT( 0xa5a5a5a5a5a5a078, 26, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a5a078, 26, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a078, 2047, 26, 12, 0xa5a5a59ffda5a078)
	EXT( 0xa5a5a5a5a5a5a077, 26, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a5a077, 26, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a077, 4095, 26, 13, 0xa5a5a5bffda5a077)
	EXT( 0xa5a5a5a5a5a5a076, 26, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a076, 26, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a5a076, 8191, 26, 14, 0xa5a5a57ffda5a076)
	EXT( 0xa5a5a5a5a5a5a075, 26, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a075, 26, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a075, 16383, 26, 15, 0xa5a5a4fffda5a075)
	EXT( 0xa5a5a5a5a5a5a074, 26, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a5a074, 26, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a074, 32767, 26, 16, 0xa5a5a5fffda5a074)
	EXT( 0xa5a5a5a5a5a5a073, 26, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a5a073, 26, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a073, 65535, 26, 17, 0xa5a5a3fffda5a073)
	EXT( 0xa5a5a5a5a5a5a072, 26, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a072, 26, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a072, 131071, 26, 18, 0xa5a5a7fffda5a072)
	EXT( 0xa5a5a5a5a5a5a071, 26, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a071, 26, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a071, 262143, 26, 19, 0xa5a5affffda5a071)
	EXT( 0xa5a5a5a5a5a5a070, 26, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a5a070, 26, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a070, 524287, 26, 20, 0xa5a59ffffda5a070)
	EXT( 0xa5a5a5a5a5a5a06f, 26, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a5a06f, 26, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a06f, 1048575, 26, 21, 0xa5a5bffffda5a06f)
	EXT( 0xa5a5a5a5a5a5a06e, 26, 22, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a06e, 26, 22, 0x0000000000296969)
	DEP( 0xa5a5a5a5a5a5a06e, 2097151, 26, 22, 0xa5a57ffffda5a06e)
	EXT( 0xa5a5a5a5a5a5a06d, 26, 23, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a06d, 26, 23, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a06d, 4194303, 26, 23, 0xa5a4fffffda5a06d)
	EXT( 0xa5a5a5a5a5a5a06c, 26, 24, 0x0000000000696969)
	EXTU(0xa5a5a5a5a5a5a06c, 26, 24, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a06c, 8388607, 26, 24, 0xa5a5fffffda5a06c)
	EXT( 0xa5a5a5a5a5a5a06b, 26, 25, 0xffffffffff696969)
	EXTU(0xa5a5a5a5a5a5a06b, 26, 25, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a06b, 16777215, 26, 25, 0xa5a3fffffda5a06b)
	EXT( 0xa5a5a5a5a5a5a06a, 26, 26, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a06a, 26, 26, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a06a, 33554431, 26, 26, 0xa5a7fffffda5a06a)
	EXT( 0xa5a5a5a5a5a5a069, 26, 27, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a069, 26, 27, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a069, 67108863, 26, 27, 0xa5affffffda5a069)
	EXT( 0xa5a5a5a5a5a5a068, 26, 28, 0xfffffffff9696969)
	EXTU(0xa5a5a5a5a5a5a068, 26, 28, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a068, 134217727, 26, 28, 0xa59ffffffda5a068)
	EXT( 0xa5a5a5a5a5a5a067, 26, 29, 0x0000000009696969)
	EXTU(0xa5a5a5a5a5a5a067, 26, 29, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a067, 268435455, 26, 29, 0xa5bffffffda5a067)
	EXT( 0xa5a5a5a5a5a5a066, 26, 30, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a066, 26, 30, 0x0000000029696969)
	DEP( 0xa5a5a5a5a5a5a066, 536870911, 26, 30, 0xa57ffffffda5a066)
	EXT( 0xa5a5a5a5a5a5a065, 26, 31, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a065, 26, 31, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a065, 1073741823, 26, 31, 0xa4fffffffda5a065)
	EXT( 0xa5a5a5a5a5a5a064, 26, 32, 0x0000000069696969)
	EXTU(0xa5a5a5a5a5a5a064, 26, 32, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a064, 2147483647, 26, 32, 0xa5fffffffda5a064)
	EXT( 0xa5a5a5a5a5a5a063, 26, 33, 0xffffffff69696969)
	EXTU(0xa5a5a5a5a5a5a063, 26, 33, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a063, 4294967295, 26, 33, 0xa3fffffffda5a063)
	EXT( 0xa5a5a5a5a5a5a062, 26, 34, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a062, 26, 34, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a062, 8589934591, 26, 34, 0xa7fffffffda5a062)
	EXT( 0xa5a5a5a5a5a5a061, 26, 35, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a061, 26, 35, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a061, 17179869183, 26, 35, 0xaffffffffda5a061)
	EXT( 0xa5a5a5a5a5a5a060, 26, 36, 0xfffffff969696969)
	EXTU(0xa5a5a5a5a5a5a060, 26, 36, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a060, 34359738367, 26, 36, 0x9ffffffffda5a060)
	EXT( 0xa5a5a5a5a5a5a05f, 26, 37, 0x0000000969696969)
	EXTU(0xa5a5a5a5a5a5a05f, 26, 37, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a05f, 68719476735, 26, 37, 0xbffffffffda5a05f)
	EXT( 0xa5a5a5a5a5a5a05e, 27, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a05e, 27, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a05e, 0, 27, 1, 0xa5a5a5a5a5a5a05e)
	EXT( 0xa5a5a5a5a5a5a05d, 27, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a05d, 27, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a05d, 1, 27, 2, 0xa5a5a5a5ada5a05d)
	EXT( 0xa5a5a5a5a5a5a05c, 27, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a05c, 27, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a05c, 3, 27, 3, 0xa5a5a5a59da5a05c)
	EXT( 0xa5a5a5a5a5a5a05b, 27, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a5a05b, 27, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a05b, 7, 27, 4, 0xa5a5a5a5bda5a05b)
	EXT( 0xa5a5a5a5a5a5a05a, 27, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a05a, 27, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a5a05a, 15, 27, 5, 0xa5a5a5a57da5a05a)
	EXT( 0xa5a5a5a5a5a5a059, 27, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a059, 27, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a059, 31, 27, 6, 0xa5a5a5a4fda5a059)
	EXT( 0xa5a5a5a5a5a5a058, 27, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a5a058, 27, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a058, 63, 27, 7, 0xa5a5a5a5fda5a058)
	EXT( 0xa5a5a5a5a5a5a057, 27, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a5a057, 27, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a057, 127, 27, 8, 0xa5a5a5a3fda5a057)
	EXT( 0xa5a5a5a5a5a5a056, 27, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a056, 27, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a056, 255, 27, 9, 0xa5a5a5a7fda5a056)
	EXT( 0xa5a5a5a5a5a5a055, 27, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a055, 27, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a055, 511, 27, 10, 0xa5a5a5affda5a055)
	EXT( 0xa5a5a5a5a5a5a054, 27, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a5a054, 27, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a054, 1023, 27, 11, 0xa5a5a59ffda5a054)
	EXT( 0xa5a5a5a5a5a5a053, 27, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a5a053, 27, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a053, 2047, 27, 12, 0xa5a5a5bffda5a053)
	EXT( 0xa5a5a5a5a5a5a052, 27, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a052, 27, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a5a052, 4095, 27, 13, 0xa5a5a57ffda5a052)
	EXT( 0xa5a5a5a5a5a5a051, 27, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a051, 27, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a051, 8191, 27, 14, 0xa5a5a4fffda5a051)
	EXT( 0xa5a5a5a5a5a5a050, 27, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a5a050, 27, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a050, 16383, 27, 15, 0xa5a5a5fffda5a050)
	EXT( 0xa5a5a5a5a5a5a04f, 27, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a5a04f, 27, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a04f, 32767, 27, 16, 0xa5a5a3fffda5a04f)
	EXT( 0xa5a5a5a5a5a5a04e, 27, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a04e, 27, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a04e, 65535, 27, 17, 0xa5a5a7fffda5a04e)
	EXT( 0xa5a5a5a5a5a5a04d, 27, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a04d, 27, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a04d, 131071, 27, 18, 0xa5a5affffda5a04d)
	EXT( 0xa5a5a5a5a5a5a04c, 27, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a5a04c, 27, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a04c, 262143, 27, 19, 0xa5a59ffffda5a04c)
	EXT( 0xa5a5a5a5a5a5a04b, 27, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a5a04b, 27, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a04b, 524287, 27, 20, 0xa5a5bffffda5a04b)
	EXT( 0xa5a5a5a5a5a5a04a, 27, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a04a, 27, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a5a04a, 1048575, 27, 21, 0xa5a57ffffda5a04a)
	EXT( 0xa5a5a5a5a5a5a049, 27, 22, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a049, 27, 22, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a049, 2097151, 27, 22, 0xa5a4fffffda5a049)
	EXT( 0xa5a5a5a5a5a5a048, 27, 23, 0x000000000034b4b4)
	EXTU(0xa5a5a5a5a5a5a048, 27, 23, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a048, 4194303, 27, 23, 0xa5a5fffffda5a048)
	EXT( 0xa5a5a5a5a5a5a047, 27, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a5a047, 27, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a047, 8388607, 27, 24, 0xa5a3fffffda5a047)
	EXT( 0xa5a5a5a5a5a5a046, 27, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a046, 27, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a046, 16777215, 27, 25, 0xa5a7fffffda5a046)
	EXT( 0xa5a5a5a5a5a5a045, 27, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a045, 27, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a045, 33554431, 27, 26, 0xa5affffffda5a045)
	EXT( 0xa5a5a5a5a5a5a044, 27, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a5a044, 27, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a044, 67108863, 27, 27, 0xa59ffffffda5a044)
	EXT( 0xa5a5a5a5a5a5a043, 27, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a5a043, 27, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a043, 134217727, 27, 28, 0xa5bffffffda5a043)
	EXT( 0xa5a5a5a5a5a5a042, 27, 29, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a042, 27, 29, 0x0000000014b4b4b4)
	DEP( 0xa5a5a5a5a5a5a042, 268435455, 27, 29, 0xa57ffffffda5a042)
	EXT( 0xa5a5a5a5a5a5a041, 27, 30, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a041, 27, 30, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a041, 536870911, 27, 30, 0xa4fffffffda5a041)
	EXT( 0xa5a5a5a5a5a5a040, 27, 31, 0x0000000034b4b4b4)
	EXTU(0xa5a5a5a5a5a5a040, 27, 31, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a040, 1073741823, 27, 31, 0xa5fffffffda5a040)
	EXT( 0xa5a5a5a5a5a5a03f, 27, 32, 0xffffffffb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a03f, 27, 32, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a03f, 2147483647, 27, 32, 0xa3fffffffda5a03f)
	EXT( 0xa5a5a5a5a5a5a03e, 27, 33, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a03e, 27, 33, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a03e, 4294967295, 27, 33, 0xa7fffffffda5a03e)
	EXT( 0xa5a5a5a5a5a5a03d, 27, 34, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a03d, 27, 34, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a03d, 8589934591, 27, 34, 0xaffffffffda5a03d)
	EXT( 0xa5a5a5a5a5a5a03c, 27, 35, 0xfffffffcb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a03c, 27, 35, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a03c, 17179869183, 27, 35, 0x9ffffffffda5a03c)
	EXT( 0xa5a5a5a5a5a5a03b, 27, 36, 0x00000004b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a03b, 27, 36, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a03b, 34359738367, 27, 36, 0xbffffffffda5a03b)
	EXT( 0xa5a5a5a5a5a5a03a, 28, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a03a, 28, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a03a, 0, 28, 1, 0xa5a5a5a5a5a5a03a)
	EXT( 0xa5a5a5a5a5a5a039, 28, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a039, 28, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a039, 1, 28, 2, 0xa5a5a5a595a5a039)
	EXT( 0xa5a5a5a5a5a5a038, 28, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a038, 28, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a038, 3, 28, 3, 0xa5a5a5a5b5a5a038)
	EXT( 0xa5a5a5a5a5a5a037, 28, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a037, 28, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a037, 7, 28, 4, 0xa5a5a5a575a5a037)
	EXT( 0xa5a5a5a5a5a5a036, 28, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a036, 28, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a036, 15, 28, 5, 0xa5a5a5a4f5a5a036)
	EXT( 0xa5a5a5a5a5a5a035, 28, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a5a035, 28, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a035, 31, 28, 6, 0xa5a5a5a5f5a5a035)
	EXT( 0xa5a5a5a5a5a5a034, 28, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a5a034, 28, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a034, 63, 28, 7, 0xa5a5a5a3f5a5a034)
	EXT( 0xa5a5a5a5a5a5a033, 28, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a033, 28, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a033, 127, 28, 8, 0xa5a5a5a7f5a5a033)
	EXT( 0xa5a5a5a5a5a5a032, 28, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a032, 28, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a032, 255, 28, 9, 0xa5a5a5aff5a5a032)
	EXT( 0xa5a5a5a5a5a5a031, 28, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a5a031, 28, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a031, 511, 28, 10, 0xa5a5a59ff5a5a031)
	EXT( 0xa5a5a5a5a5a5a030, 28, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a5a030, 28, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a030, 1023, 28, 11, 0xa5a5a5bff5a5a030)
	EXT( 0xa5a5a5a5a5a5a02f, 28, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a02f, 28, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a5a02f, 2047, 28, 12, 0xa5a5a57ff5a5a02f)
	EXT( 0xa5a5a5a5a5a5a02e, 28, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a02e, 28, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a02e, 4095, 28, 13, 0xa5a5a4fff5a5a02e)
	EXT( 0xa5a5a5a5a5a5a02d, 28, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a5a02d, 28, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a02d, 8191, 28, 14, 0xa5a5a5fff5a5a02d)
	EXT( 0xa5a5a5a5a5a5a02c, 28, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a5a02c, 28, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a02c, 16383, 28, 15, 0xa5a5a3fff5a5a02c)
	EXT( 0xa5a5a5a5a5a5a02b, 28, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a02b, 28, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a02b, 32767, 28, 16, 0xa5a5a7fff5a5a02b)
	EXT( 0xa5a5a5a5a5a5a02a, 28, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a02a, 28, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a02a, 65535, 28, 17, 0xa5a5affff5a5a02a)
	EXT( 0xa5a5a5a5a5a5a029, 28, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a5a029, 28, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a029, 131071, 28, 18, 0xa5a59ffff5a5a029)
	EXT( 0xa5a5a5a5a5a5a028, 28, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a5a028, 28, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a028, 262143, 28, 19, 0xa5a5bffff5a5a028)
	EXT( 0xa5a5a5a5a5a5a027, 28, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a027, 28, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a5a027, 524287, 28, 20, 0xa5a57ffff5a5a027)
	EXT( 0xa5a5a5a5a5a5a026, 28, 21, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a026, 28, 21, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a026, 1048575, 28, 21, 0xa5a4fffff5a5a026)
	EXT( 0xa5a5a5a5a5a5a025, 28, 22, 0x00000000001a5a5a)
	EXTU(0xa5a5a5a5a5a5a025, 28, 22, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a025, 2097151, 28, 22, 0xa5a5fffff5a5a025)
	EXT( 0xa5a5a5a5a5a5a024, 28, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a5a024, 28, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a024, 4194303, 28, 23, 0xa5a3fffff5a5a024)
	EXT( 0xa5a5a5a5a5a5a023, 28, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a023, 28, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a023, 8388607, 28, 24, 0xa5a7fffff5a5a023)
	EXT( 0xa5a5a5a5a5a5a022, 28, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a022, 28, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a022, 16777215, 28, 25, 0xa5affffff5a5a022)
	EXT( 0xa5a5a5a5a5a5a021, 28, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a5a021, 28, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a021, 33554431, 28, 26, 0xa59ffffff5a5a021)
	EXT( 0xa5a5a5a5a5a5a020, 28, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a5a020, 28, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a020, 67108863, 28, 27, 0xa5bffffff5a5a020)
	EXT( 0xa5a5a5a5a5a5a01f, 28, 28, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a01f, 28, 28, 0x000000000a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a01f, 134217727, 28, 28, 0xa57ffffff5a5a01f)
	EXT( 0xa5a5a5a5a5a5a01e, 28, 29, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a01e, 28, 29, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a01e, 268435455, 28, 29, 0xa4fffffff5a5a01e)
	EXT( 0xa5a5a5a5a5a5a01d, 28, 30, 0x000000001a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a01d, 28, 30, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a01d, 536870911, 28, 30, 0xa5fffffff5a5a01d)
	EXT( 0xa5a5a5a5a5a5a01c, 28, 31, 0xffffffffda5a5a5a)
	EXTU(0xa5a5a5a5a5a5a01c, 28, 31, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a01c, 1073741823, 28, 31, 0xa3fffffff5a5a01c)
	EXT( 0xa5a5a5a5a5a5a01b, 28, 32, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a01b, 28, 32, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a01b, 2147483647, 28, 32, 0xa7fffffff5a5a01b)
	EXT( 0xa5a5a5a5a5a5a01a, 28, 33, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a01a, 28, 33, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a01a, 4294967295, 28, 33, 0xaffffffff5a5a01a)
	EXT( 0xa5a5a5a5a5a5a019, 28, 34, 0xfffffffe5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a019, 28, 34, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a019, 8589934591, 28, 34, 0x9ffffffff5a5a019)
	EXT( 0xa5a5a5a5a5a5a018, 28, 35, 0x000000025a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a018, 28, 35, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a018, 17179869183, 28, 35, 0xbffffffff5a5a018)
	EXT( 0xa5a5a5a5a5a5a017, 29, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a017, 29, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a017, 0, 29, 1, 0xa5a5a5a585a5a017)
	EXT( 0xa5a5a5a5a5a5a016, 29, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a016, 29, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a016, 1, 29, 2, 0xa5a5a5a5a5a5a016)
	EXT( 0xa5a5a5a5a5a5a015, 29, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a015, 29, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a015, 3, 29, 3, 0xa5a5a5a565a5a015)
	EXT( 0xa5a5a5a5a5a5a014, 29, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a014, 29, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a014, 7, 29, 4, 0xa5a5a5a4e5a5a014)
	EXT( 0xa5a5a5a5a5a5a013, 29, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a5a013, 29, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a013, 15, 29, 5, 0xa5a5a5a5e5a5a013)
	EXT( 0xa5a5a5a5a5a5a012, 29, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a5a012, 29, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a012, 31, 29, 6, 0xa5a5a5a3e5a5a012)
	EXT( 0xa5a5a5a5a5a5a011, 29, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a011, 29, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a011, 63, 29, 7, 0xa5a5a5a7e5a5a011)
	EXT( 0xa5a5a5a5a5a5a010, 29, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a010, 29, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a010, 127, 29, 8, 0xa5a5a5afe5a5a010)
	EXT( 0xa5a5a5a5a5a5a00f, 29, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a5a00f, 29, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a00f, 255, 29, 9, 0xa5a5a59fe5a5a00f)
	EXT( 0xa5a5a5a5a5a5a00e, 29, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a5a00e, 29, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a00e, 511, 29, 10, 0xa5a5a5bfe5a5a00e)
	EXT( 0xa5a5a5a5a5a5a00d, 29, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a00d, 29, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a5a00d, 1023, 29, 11, 0xa5a5a57fe5a5a00d)
	EXT( 0xa5a5a5a5a5a5a00c, 29, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a00c, 29, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a00c, 2047, 29, 12, 0xa5a5a4ffe5a5a00c)
	EXT( 0xa5a5a5a5a5a5a00b, 29, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a5a00b, 29, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a00b, 4095, 29, 13, 0xa5a5a5ffe5a5a00b)
	EXT( 0xa5a5a5a5a5a5a00a, 29, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a5a00a, 29, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a00a, 8191, 29, 14, 0xa5a5a3ffe5a5a00a)
	EXT( 0xa5a5a5a5a5a5a009, 29, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a009, 29, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a009, 16383, 29, 15, 0xa5a5a7ffe5a5a009)
	EXT( 0xa5a5a5a5a5a5a008, 29, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a008, 29, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a008, 32767, 29, 16, 0xa5a5afffe5a5a008)
	EXT( 0xa5a5a5a5a5a5a007, 29, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a5a007, 29, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a007, 65535, 29, 17, 0xa5a59fffe5a5a007)
	EXT( 0xa5a5a5a5a5a5a006, 29, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a5a006, 29, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a006, 131071, 29, 18, 0xa5a5bfffe5a5a006)
	EXT( 0xa5a5a5a5a5a5a005, 29, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a005, 29, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a5a005, 262143, 29, 19, 0xa5a57fffe5a5a005)
	EXT( 0xa5a5a5a5a5a5a004, 29, 20, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a004, 29, 20, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a004, 524287, 29, 20, 0xa5a4ffffe5a5a004)
	EXT( 0xa5a5a5a5a5a5a003, 29, 21, 0x00000000000d2d2d)
	EXTU(0xa5a5a5a5a5a5a003, 29, 21, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a003, 1048575, 29, 21, 0xa5a5ffffe5a5a003)
	EXT( 0xa5a5a5a5a5a5a002, 29, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a5a002, 29, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a002, 2097151, 29, 22, 0xa5a3ffffe5a5a002)
	EXT( 0xa5a5a5a5a5a5a001, 29, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a001, 29, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a001, 4194303, 29, 23, 0xa5a7ffffe5a5a001)
	EXT( 0xa5a5a5a5a5a5a000, 29, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a000, 29, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a000, 8388607, 29, 24, 0xa5afffffe5a5a000)
	EXT( 0xa5a5a5a5a5a59fff, 29, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a59fff, 29, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a59fff, 16777215, 29, 25, 0xa59fffffe5a59fff)
	EXT( 0xa5a5a5a5a5a59ffe, 29, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a59ffe, 29, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a59ffe, 33554431, 29, 26, 0xa5bfffffe5a59ffe)
	EXT( 0xa5a5a5a5a5a59ffd, 29, 27, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a59ffd, 29, 27, 0x00000000052d2d2d)
	DEP( 0xa5a5a5a5a5a59ffd, 67108863, 29, 27, 0xa57fffffe5a59ffd)
	EXT( 0xa5a5a5a5a5a59ffc, 29, 28, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a59ffc, 29, 28, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a59ffc, 134217727, 29, 28, 0xa4ffffffe5a59ffc)
	EXT( 0xa5a5a5a5a5a59ffb, 29, 29, 0x000000000d2d2d2d)
	EXTU(0xa5a5a5a5a5a59ffb, 29, 29, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a59ffb, 268435455, 29, 29, 0xa5ffffffe5a59ffb)
	EXT( 0xa5a5a5a5a5a59ffa, 29, 30, 0xffffffffed2d2d2d)
	EXTU(0xa5a5a5a5a5a59ffa, 29, 30, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a59ffa, 536870911, 29, 30, 0xa3ffffffe5a59ffa)
	EXT( 0xa5a5a5a5a5a59ff9, 29, 31, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a59ff9, 29, 31, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a59ff9, 1073741823, 29, 31, 0xa7ffffffe5a59ff9)
	EXT( 0xa5a5a5a5a5a59ff8, 29, 32, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a59ff8, 29, 32, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a59ff8, 2147483647, 29, 32, 0xafffffffe5a59ff8)
	EXT( 0xa5a5a5a5a5a59ff7, 29, 33, 0xffffffff2d2d2d2d)
	EXTU(0xa5a5a5a5a5a59ff7, 29, 33, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a59ff7, 4294967295, 29, 33, 0x9fffffffe5a59ff7)
	EXT( 0xa5a5a5a5a5a59ff6, 29, 34, 0x000000012d2d2d2d)
	EXTU(0xa5a5a5a5a5a59ff6, 29, 34, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a59ff6, 8589934591, 29, 34, 0xbfffffffe5a59ff6)
	EXT( 0xa5a5a5a5a5a59ff5, 30, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59ff5, 30, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59ff5, 0, 30, 1, 0xa5a5a5a5a5a59ff5)
	EXT( 0xa5a5a5a5a5a59ff4, 30, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59ff4, 30, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59ff4, 1, 30, 2, 0xa5a5a5a565a59ff4)
	EXT( 0xa5a5a5a5a5a59ff3, 30, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59ff3, 30, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59ff3, 3, 30, 3, 0xa5a5a5a4e5a59ff3)
	EXT( 0xa5a5a5a5a5a59ff2, 30, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a59ff2, 30, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59ff2, 7, 30, 4, 0xa5a5a5a5e5a59ff2)
	EXT( 0xa5a5a5a5a5a59ff1, 30, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a59ff1, 30, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59ff1, 15, 30, 5, 0xa5a5a5a3e5a59ff1)
	EXT( 0xa5a5a5a5a5a59ff0, 30, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59ff0, 30, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59ff0, 31, 30, 6, 0xa5a5a5a7e5a59ff0)
	EXT( 0xa5a5a5a5a5a59fef, 30, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59fef, 30, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59fef, 63, 30, 7, 0xa5a5a5afe5a59fef)
	EXT( 0xa5a5a5a5a5a59fee, 30, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a59fee, 30, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59fee, 127, 30, 8, 0xa5a5a59fe5a59fee)
	EXT( 0xa5a5a5a5a5a59fed, 30, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a59fed, 30, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59fed, 255, 30, 9, 0xa5a5a5bfe5a59fed)
	EXT( 0xa5a5a5a5a5a59fec, 30, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59fec, 30, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a59fec, 511, 30, 10, 0xa5a5a57fe5a59fec)
	EXT( 0xa5a5a5a5a5a59feb, 30, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59feb, 30, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59feb, 1023, 30, 11, 0xa5a5a4ffe5a59feb)
	EXT( 0xa5a5a5a5a5a59fea, 30, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a59fea, 30, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59fea, 2047, 30, 12, 0xa5a5a5ffe5a59fea)
	EXT( 0xa5a5a5a5a5a59fe9, 30, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a59fe9, 30, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59fe9, 4095, 30, 13, 0xa5a5a3ffe5a59fe9)
	EXT( 0xa5a5a5a5a5a59fe8, 30, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59fe8, 30, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59fe8, 8191, 30, 14, 0xa5a5a7ffe5a59fe8)
	EXT( 0xa5a5a5a5a5a59fe7, 30, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59fe7, 30, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59fe7, 16383, 30, 15, 0xa5a5afffe5a59fe7)
	EXT( 0xa5a5a5a5a5a59fe6, 30, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a59fe6, 30, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59fe6, 32767, 30, 16, 0xa5a59fffe5a59fe6)
	EXT( 0xa5a5a5a5a5a59fe5, 30, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a59fe5, 30, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59fe5, 65535, 30, 17, 0xa5a5bfffe5a59fe5)
	EXT( 0xa5a5a5a5a5a59fe4, 30, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a59fe4, 30, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a59fe4, 131071, 30, 18, 0xa5a57fffe5a59fe4)
	EXT( 0xa5a5a5a5a5a59fe3, 30, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a59fe3, 30, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a59fe3, 262143, 30, 19, 0xa5a4ffffe5a59fe3)
	EXT( 0xa5a5a5a5a5a59fe2, 30, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a59fe2, 30, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a59fe2, 524287, 30, 20, 0xa5a5ffffe5a59fe2)
	EXT( 0xa5a5a5a5a5a59fe1, 30, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a59fe1, 30, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a59fe1, 1048575, 30, 21, 0xa5a3ffffe5a59fe1)
	EXT( 0xa5a5a5a5a5a59fe0, 30, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a59fe0, 30, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a59fe0, 2097151, 30, 22, 0xa5a7ffffe5a59fe0)
	EXT( 0xa5a5a5a5a5a59fdf, 30, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a59fdf, 30, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a59fdf, 4194303, 30, 23, 0xa5afffffe5a59fdf)
	EXT( 0xa5a5a5a5a5a59fde, 30, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a59fde, 30, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a59fde, 8388607, 30, 24, 0xa59fffffe5a59fde)
	EXT( 0xa5a5a5a5a5a59fdd, 30, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a59fdd, 30, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a59fdd, 16777215, 30, 25, 0xa5bfffffe5a59fdd)
	EXT( 0xa5a5a5a5a5a59fdc, 30, 26, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a59fdc, 30, 26, 0x0000000002969696)
	DEP( 0xa5a5a5a5a5a59fdc, 33554431, 30, 26, 0xa57fffffe5a59fdc)
	EXT( 0xa5a5a5a5a5a59fdb, 30, 27, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a59fdb, 30, 27, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a59fdb, 67108863, 30, 27, 0xa4ffffffe5a59fdb)
	EXT( 0xa5a5a5a5a5a59fda, 30, 28, 0x0000000006969696)
	EXTU(0xa5a5a5a5a5a59fda, 30, 28, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a59fda, 134217727, 30, 28, 0xa5ffffffe5a59fda)
	EXT( 0xa5a5a5a5a5a59fd9, 30, 29, 0xfffffffff6969696)
	EXTU(0xa5a5a5a5a5a59fd9, 30, 29, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a59fd9, 268435455, 30, 29, 0xa3ffffffe5a59fd9)
	EXT( 0xa5a5a5a5a5a59fd8, 30, 30, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a59fd8, 30, 30, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a59fd8, 536870911, 30, 30, 0xa7ffffffe5a59fd8)
	EXT( 0xa5a5a5a5a5a59fd7, 30, 31, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a59fd7, 30, 31, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a59fd7, 1073741823, 30, 31, 0xafffffffe5a59fd7)
	EXT( 0xa5a5a5a5a5a59fd6, 30, 32, 0xffffffff96969696)
	EXTU(0xa5a5a5a5a5a59fd6, 30, 32, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a59fd6, 2147483647, 30, 32, 0x9fffffffe5a59fd6)
	EXT( 0xa5a5a5a5a5a59fd5, 30, 33, 0x0000000096969696)
	EXTU(0xa5a5a5a5a5a59fd5, 30, 33, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a59fd5, 4294967295, 30, 33, 0xbfffffffe5a59fd5)
	EXT( 0xa5a5a5a5a5a59fd4, 31, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59fd4, 31, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59fd4, 0, 31, 1, 0xa5a5a5a525a59fd4)
	EXT( 0xa5a5a5a5a5a59fd3, 31, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59fd3, 31, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59fd3, 1, 31, 2, 0xa5a5a5a4a5a59fd3)
	EXT( 0xa5a5a5a5a5a59fd2, 31, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59fd2, 31, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59fd2, 3, 31, 3, 0xa5a5a5a5a5a59fd2)
	EXT( 0xa5a5a5a5a5a59fd1, 31, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59fd1, 31, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59fd1, 7, 31, 4, 0xa5a5a5a3a5a59fd1)
	EXT( 0xa5a5a5a5a5a59fd0, 31, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59fd0, 31, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59fd0, 15, 31, 5, 0xa5a5a5a7a5a59fd0)
	EXT( 0xa5a5a5a5a5a59fcf, 31, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59fcf, 31, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59fcf, 31, 31, 6, 0xa5a5a5afa5a59fcf)
	EXT( 0xa5a5a5a5a5a59fce, 31, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a59fce, 31, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59fce, 63, 31, 7, 0xa5a5a59fa5a59fce)
	EXT( 0xa5a5a5a5a5a59fcd, 31, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a59fcd, 31, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59fcd, 127, 31, 8, 0xa5a5a5bfa5a59fcd)
	EXT( 0xa5a5a5a5a5a59fcc, 31, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59fcc, 31, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a59fcc, 255, 31, 9, 0xa5a5a57fa5a59fcc)
	EXT( 0xa5a5a5a5a5a59fcb, 31, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59fcb, 31, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59fcb, 511, 31, 10, 0xa5a5a4ffa5a59fcb)
	EXT( 0xa5a5a5a5a5a59fca, 31, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a59fca, 31, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59fca, 1023, 31, 11, 0xa5a5a5ffa5a59fca)
	EXT( 0xa5a5a5a5a5a59fc9, 31, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a59fc9, 31, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59fc9, 2047, 31, 12, 0xa5a5a3ffa5a59fc9)
	EXT( 0xa5a5a5a5a5a59fc8, 31, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59fc8, 31, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59fc8, 4095, 31, 13, 0xa5a5a7ffa5a59fc8)
	EXT( 0xa5a5a5a5a5a59fc7, 31, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59fc7, 31, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59fc7, 8191, 31, 14, 0xa5a5afffa5a59fc7)
	EXT( 0xa5a5a5a5a5a59fc6, 31, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a59fc6, 31, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59fc6, 16383, 31, 15, 0xa5a59fffa5a59fc6)
	EXT( 0xa5a5a5a5a5a59fc5, 31, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a59fc5, 31, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59fc5, 32767, 31, 16, 0xa5a5bfffa5a59fc5)
	EXT( 0xa5a5a5a5a5a59fc4, 31, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a59fc4, 31, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a59fc4, 65535, 31, 17, 0xa5a57fffa5a59fc4)
	EXT( 0xa5a5a5a5a5a59fc3, 31, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a59fc3, 31, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a59fc3, 131071, 31, 18, 0xa5a4ffffa5a59fc3)
	EXT( 0xa5a5a5a5a5a59fc2, 31, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a59fc2, 31, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a59fc2, 262143, 31, 19, 0xa5a5ffffa5a59fc2)
	EXT( 0xa5a5a5a5a5a59fc1, 31, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a59fc1, 31, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a59fc1, 524287, 31, 20, 0xa5a3ffffa5a59fc1)
	EXT( 0xa5a5a5a5a5a59fc0, 31, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a59fc0, 31, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a59fc0, 1048575, 31, 21, 0xa5a7ffffa5a59fc0)
	EXT( 0xa5a5a5a5a5a59fbf, 31, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a59fbf, 31, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a59fbf, 2097151, 31, 22, 0xa5afffffa5a59fbf)
	EXT( 0xa5a5a5a5a5a59fbe, 31, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a59fbe, 31, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a59fbe, 4194303, 31, 23, 0xa59fffffa5a59fbe)
	EXT( 0xa5a5a5a5a5a59fbd, 31, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a59fbd, 31, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a59fbd, 8388607, 31, 24, 0xa5bfffffa5a59fbd)
	EXT( 0xa5a5a5a5a5a59fbc, 31, 25, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a59fbc, 31, 25, 0x00000000014b4b4b)
	DEP( 0xa5a5a5a5a5a59fbc, 16777215, 31, 25, 0xa57fffffa5a59fbc)
	EXT( 0xa5a5a5a5a5a59fbb, 31, 26, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a59fbb, 31, 26, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a59fbb, 33554431, 31, 26, 0xa4ffffffa5a59fbb)
	EXT( 0xa5a5a5a5a5a59fba, 31, 27, 0x00000000034b4b4b)
	EXTU(0xa5a5a5a5a5a59fba, 31, 27, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a59fba, 67108863, 31, 27, 0xa5ffffffa5a59fba)
	EXT( 0xa5a5a5a5a5a59fb9, 31, 28, 0xfffffffffb4b4b4b)
	EXTU(0xa5a5a5a5a5a59fb9, 31, 28, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a59fb9, 134217727, 31, 28, 0xa3ffffffa5a59fb9)
	EXT( 0xa5a5a5a5a5a59fb8, 31, 29, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a59fb8, 31, 29, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a59fb8, 268435455, 31, 29, 0xa7ffffffa5a59fb8)
	EXT( 0xa5a5a5a5a5a59fb7, 31, 30, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a59fb7, 31, 30, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a59fb7, 536870911, 31, 30, 0xafffffffa5a59fb7)
	EXT( 0xa5a5a5a5a5a59fb6, 31, 31, 0xffffffffcb4b4b4b)
	EXTU(0xa5a5a5a5a5a59fb6, 31, 31, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a59fb6, 1073741823, 31, 31, 0x9fffffffa5a59fb6)
	EXT( 0xa5a5a5a5a5a59fb5, 31, 32, 0x000000004b4b4b4b)
	EXTU(0xa5a5a5a5a5a59fb5, 31, 32, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a59fb5, 2147483647, 31, 32, 0xbfffffffa5a59fb5)
	EXT( 0xa5a5a5a5a5a59fb4, 32, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59fb4, 32, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59fb4, 0, 32, 1, 0xa5a5a5a4a5a59fb4)
	EXT( 0xa5a5a5a5a5a59fb3, 32, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59fb3, 32, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59fb3, 1, 32, 2, 0xa5a5a5a5a5a59fb3)
	EXT( 0xa5a5a5a5a5a59fb2, 32, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59fb2, 32, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59fb2, 3, 32, 3, 0xa5a5a5a3a5a59fb2)
	EXT( 0xa5a5a5a5a5a59fb1, 32, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59fb1, 32, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59fb1, 7, 32, 4, 0xa5a5a5a7a5a59fb1)
	EXT( 0xa5a5a5a5a5a59fb0, 32, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59fb0, 32, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59fb0, 15, 32, 5, 0xa5a5a5afa5a59fb0)
	EXT( 0xa5a5a5a5a5a59faf, 32, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a59faf, 32, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59faf, 31, 32, 6, 0xa5a5a59fa5a59faf)
	EXT( 0xa5a5a5a5a5a59fae, 32, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a59fae, 32, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59fae, 63, 32, 7, 0xa5a5a5bfa5a59fae)
	EXT( 0xa5a5a5a5a5a59fad, 32, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59fad, 32, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a59fad, 127, 32, 8, 0xa5a5a57fa5a59fad)
	EXT( 0xa5a5a5a5a5a59fac, 32, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59fac, 32, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59fac, 255, 32, 9, 0xa5a5a4ffa5a59fac)
	EXT( 0xa5a5a5a5a5a59fab, 32, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a59fab, 32, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59fab, 511, 32, 10, 0xa5a5a5ffa5a59fab)
	EXT( 0xa5a5a5a5a5a59faa, 32, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a59faa, 32, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59faa, 1023, 32, 11, 0xa5a5a3ffa5a59faa)
	EXT( 0xa5a5a5a5a5a59fa9, 32, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59fa9, 32, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59fa9, 2047, 32, 12, 0xa5a5a7ffa5a59fa9)
	EXT( 0xa5a5a5a5a5a59fa8, 32, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59fa8, 32, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59fa8, 4095, 32, 13, 0xa5a5afffa5a59fa8)
	EXT( 0xa5a5a5a5a5a59fa7, 32, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a59fa7, 32, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59fa7, 8191, 32, 14, 0xa5a59fffa5a59fa7)
	EXT( 0xa5a5a5a5a5a59fa6, 32, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a59fa6, 32, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59fa6, 16383, 32, 15, 0xa5a5bfffa5a59fa6)
	EXT( 0xa5a5a5a5a5a59fa5, 32, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a59fa5, 32, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a59fa5, 32767, 32, 16, 0xa5a57fffa5a59fa5)
	EXT( 0xa5a5a5a5a5a59fa4, 32, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a59fa4, 32, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a59fa4, 65535, 32, 17, 0xa5a4ffffa5a59fa4)
	EXT( 0xa5a5a5a5a5a59fa3, 32, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a59fa3, 32, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a59fa3, 131071, 32, 18, 0xa5a5ffffa5a59fa3)
	EXT( 0xa5a5a5a5a5a59fa2, 32, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a59fa2, 32, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a59fa2, 262143, 32, 19, 0xa5a3ffffa5a59fa2)
	EXT( 0xa5a5a5a5a5a59fa1, 32, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a59fa1, 32, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a59fa1, 524287, 32, 20, 0xa5a7ffffa5a59fa1)
	EXT( 0xa5a5a5a5a5a59fa0, 32, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a59fa0, 32, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a59fa0, 1048575, 32, 21, 0xa5afffffa5a59fa0)
	EXT( 0xa5a5a5a5a5a59f9f, 32, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a59f9f, 32, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a59f9f, 2097151, 32, 22, 0xa59fffffa5a59f9f)
	EXT( 0xa5a5a5a5a5a59f9e, 32, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a59f9e, 32, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a59f9e, 4194303, 32, 23, 0xa5bfffffa5a59f9e)
	EXT( 0xa5a5a5a5a5a59f9d, 32, 24, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a59f9d, 32, 24, 0x0000000000a5a5a5)
	DEP( 0xa5a5a5a5a5a59f9d, 8388607, 32, 24, 0xa57fffffa5a59f9d)
	EXT( 0xa5a5a5a5a5a59f9c, 32, 25, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a59f9c, 32, 25, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a59f9c, 16777215, 32, 25, 0xa4ffffffa5a59f9c)
	EXT( 0xa5a5a5a5a5a59f9b, 32, 26, 0x0000000001a5a5a5)
	EXTU(0xa5a5a5a5a5a59f9b, 32, 26, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a59f9b, 33554431, 32, 26, 0xa5ffffffa5a59f9b)
	EXT( 0xa5a5a5a5a5a59f9a, 32, 27, 0xfffffffffda5a5a5)
	EXTU(0xa5a5a5a5a5a59f9a, 32, 27, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a59f9a, 67108863, 32, 27, 0xa3ffffffa5a59f9a)
	EXT( 0xa5a5a5a5a5a59f99, 32, 28, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a59f99, 32, 28, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a59f99, 134217727, 32, 28, 0xa7ffffffa5a59f99)
	EXT( 0xa5a5a5a5a5a59f98, 32, 29, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a59f98, 32, 29, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a59f98, 268435455, 32, 29, 0xafffffffa5a59f98)
	EXT( 0xa5a5a5a5a5a59f97, 32, 30, 0xffffffffe5a5a5a5)
	EXTU(0xa5a5a5a5a5a59f97, 32, 30, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a59f97, 536870911, 32, 30, 0x9fffffffa5a59f97)
	EXT( 0xa5a5a5a5a5a59f96, 32, 31, 0x0000000025a5a5a5)
	EXTU(0xa5a5a5a5a5a59f96, 32, 31, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a59f96, 1073741823, 32, 31, 0xbfffffffa5a59f96)
	EXT( 0xa5a5a5a5a5a59f95, 33, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f95, 33, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f95, 0, 33, 1, 0xa5a5a5a5a5a59f95)
	EXT( 0xa5a5a5a5a5a59f94, 33, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59f94, 33, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f94, 1, 33, 2, 0xa5a5a5a3a5a59f94)
	EXT( 0xa5a5a5a5a5a59f93, 33, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59f93, 33, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f93, 3, 33, 3, 0xa5a5a5a7a5a59f93)
	EXT( 0xa5a5a5a5a5a59f92, 33, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59f92, 33, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f92, 7, 33, 4, 0xa5a5a5afa5a59f92)
	EXT( 0xa5a5a5a5a5a59f91, 33, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a59f91, 33, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59f91, 15, 33, 5, 0xa5a5a59fa5a59f91)
	EXT( 0xa5a5a5a5a5a59f90, 33, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a59f90, 33, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59f90, 31, 33, 6, 0xa5a5a5bfa5a59f90)
	EXT( 0xa5a5a5a5a5a59f8f, 33, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59f8f, 33, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a59f8f, 63, 33, 7, 0xa5a5a57fa5a59f8f)
	EXT( 0xa5a5a5a5a5a59f8e, 33, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59f8e, 33, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59f8e, 127, 33, 8, 0xa5a5a4ffa5a59f8e)
	EXT( 0xa5a5a5a5a5a59f8d, 33, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a59f8d, 33, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59f8d, 255, 33, 9, 0xa5a5a5ffa5a59f8d)
	EXT( 0xa5a5a5a5a5a59f8c, 33, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a59f8c, 33, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59f8c, 511, 33, 10, 0xa5a5a3ffa5a59f8c)
	EXT( 0xa5a5a5a5a5a59f8b, 33, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59f8b, 33, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59f8b, 1023, 33, 11, 0xa5a5a7ffa5a59f8b)
	EXT( 0xa5a5a5a5a5a59f8a, 33, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59f8a, 33, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59f8a, 2047, 33, 12, 0xa5a5afffa5a59f8a)
	EXT( 0xa5a5a5a5a5a59f89, 33, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a59f89, 33, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59f89, 4095, 33, 13, 0xa5a59fffa5a59f89)
	EXT( 0xa5a5a5a5a5a59f88, 33, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a59f88, 33, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59f88, 8191, 33, 14, 0xa5a5bfffa5a59f88)
	EXT( 0xa5a5a5a5a5a59f87, 33, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a59f87, 33, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a59f87, 16383, 33, 15, 0xa5a57fffa5a59f87)
	EXT( 0xa5a5a5a5a5a59f86, 33, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a59f86, 33, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a59f86, 32767, 33, 16, 0xa5a4ffffa5a59f86)
	EXT( 0xa5a5a5a5a5a59f85, 33, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a59f85, 33, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a59f85, 65535, 33, 17, 0xa5a5ffffa5a59f85)
	EXT( 0xa5a5a5a5a5a59f84, 33, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a59f84, 33, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a59f84, 131071, 33, 18, 0xa5a3ffffa5a59f84)
	EXT( 0xa5a5a5a5a5a59f83, 33, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a59f83, 33, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a59f83, 262143, 33, 19, 0xa5a7ffffa5a59f83)
	EXT( 0xa5a5a5a5a5a59f82, 33, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a59f82, 33, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a59f82, 524287, 33, 20, 0xa5afffffa5a59f82)
	EXT( 0xa5a5a5a5a5a59f81, 33, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a59f81, 33, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a59f81, 1048575, 33, 21, 0xa59fffffa5a59f81)
	EXT( 0xa5a5a5a5a5a59f80, 33, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a59f80, 33, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a59f80, 2097151, 33, 22, 0xa5bfffffa5a59f80)
	EXT( 0xa5a5a5a5a5a59f7f, 33, 23, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a59f7f, 33, 23, 0x000000000052d2d2)
	DEP( 0xa5a5a5a5a5a59f7f, 4194303, 33, 23, 0xa57fffffa5a59f7f)
	EXT( 0xa5a5a5a5a5a59f7e, 33, 24, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a59f7e, 33, 24, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a59f7e, 8388607, 33, 24, 0xa4ffffffa5a59f7e)
	EXT( 0xa5a5a5a5a5a59f7d, 33, 25, 0x0000000000d2d2d2)
	EXTU(0xa5a5a5a5a5a59f7d, 33, 25, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a59f7d, 16777215, 33, 25, 0xa5ffffffa5a59f7d)
	EXT( 0xa5a5a5a5a5a59f7c, 33, 26, 0xfffffffffed2d2d2)
	EXTU(0xa5a5a5a5a5a59f7c, 33, 26, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a59f7c, 33554431, 33, 26, 0xa3ffffffa5a59f7c)
	EXT( 0xa5a5a5a5a5a59f7b, 33, 27, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a59f7b, 33, 27, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a59f7b, 67108863, 33, 27, 0xa7ffffffa5a59f7b)
	EXT( 0xa5a5a5a5a5a59f7a, 33, 28, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a59f7a, 33, 28, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a59f7a, 134217727, 33, 28, 0xafffffffa5a59f7a)
	EXT( 0xa5a5a5a5a5a59f79, 33, 29, 0xfffffffff2d2d2d2)
	EXTU(0xa5a5a5a5a5a59f79, 33, 29, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a59f79, 268435455, 33, 29, 0x9fffffffa5a59f79)
	EXT( 0xa5a5a5a5a5a59f78, 33, 30, 0x0000000012d2d2d2)
	EXTU(0xa5a5a5a5a5a59f78, 33, 30, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a59f78, 536870911, 33, 30, 0xbfffffffa5a59f78)
	EXT( 0xa5a5a5a5a5a59f77, 34, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59f77, 34, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f77, 0, 34, 1, 0xa5a5a5a1a5a59f77)
	EXT( 0xa5a5a5a5a5a59f76, 34, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59f76, 34, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f76, 1, 34, 2, 0xa5a5a5a5a5a59f76)
	EXT( 0xa5a5a5a5a5a59f75, 34, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59f75, 34, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f75, 3, 34, 3, 0xa5a5a5ada5a59f75)
	EXT( 0xa5a5a5a5a5a59f74, 34, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59f74, 34, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59f74, 7, 34, 4, 0xa5a5a59da5a59f74)
	EXT( 0xa5a5a5a5a5a59f73, 34, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a59f73, 34, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59f73, 15, 34, 5, 0xa5a5a5bda5a59f73)
	EXT( 0xa5a5a5a5a5a59f72, 34, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59f72, 34, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a59f72, 31, 34, 6, 0xa5a5a57da5a59f72)
	EXT( 0xa5a5a5a5a5a59f71, 34, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59f71, 34, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59f71, 63, 34, 7, 0xa5a5a4fda5a59f71)
	EXT( 0xa5a5a5a5a5a59f70, 34, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a59f70, 34, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59f70, 127, 34, 8, 0xa5a5a5fda5a59f70)
	EXT( 0xa5a5a5a5a5a59f6f, 34, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a59f6f, 34, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59f6f, 255, 34, 9, 0xa5a5a3fda5a59f6f)
	EXT( 0xa5a5a5a5a5a59f6e, 34, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59f6e, 34, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59f6e, 511, 34, 10, 0xa5a5a7fda5a59f6e)
	EXT( 0xa5a5a5a5a5a59f6d, 34, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59f6d, 34, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59f6d, 1023, 34, 11, 0xa5a5affda5a59f6d)
	EXT( 0xa5a5a5a5a5a59f6c, 34, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a59f6c, 34, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59f6c, 2047, 34, 12, 0xa5a59ffda5a59f6c)
	EXT( 0xa5a5a5a5a5a59f6b, 34, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a59f6b, 34, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59f6b, 4095, 34, 13, 0xa5a5bffda5a59f6b)
	EXT( 0xa5a5a5a5a5a59f6a, 34, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a59f6a, 34, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a59f6a, 8191, 34, 14, 0xa5a57ffda5a59f6a)
	EXT( 0xa5a5a5a5a5a59f69, 34, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a59f69, 34, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a59f69, 16383, 34, 15, 0xa5a4fffda5a59f69)
	EXT( 0xa5a5a5a5a5a59f68, 34, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a59f68, 34, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a59f68, 32767, 34, 16, 0xa5a5fffda5a59f68)
	EXT( 0xa5a5a5a5a5a59f67, 34, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a59f67, 34, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a59f67, 65535, 34, 17, 0xa5a3fffda5a59f67)
	EXT( 0xa5a5a5a5a5a59f66, 34, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a59f66, 34, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a59f66, 131071, 34, 18, 0xa5a7fffda5a59f66)
	EXT( 0xa5a5a5a5a5a59f65, 34, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a59f65, 34, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a59f65, 262143, 34, 19, 0xa5affffda5a59f65)
	EXT( 0xa5a5a5a5a5a59f64, 34, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a59f64, 34, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a59f64, 524287, 34, 20, 0xa59ffffda5a59f64)
	EXT( 0xa5a5a5a5a5a59f63, 34, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a59f63, 34, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a59f63, 1048575, 34, 21, 0xa5bffffda5a59f63)
	EXT( 0xa5a5a5a5a5a59f62, 34, 22, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a59f62, 34, 22, 0x0000000000296969)
	DEP( 0xa5a5a5a5a5a59f62, 2097151, 34, 22, 0xa57ffffda5a59f62)
	EXT( 0xa5a5a5a5a5a59f61, 34, 23, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a59f61, 34, 23, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a59f61, 4194303, 34, 23, 0xa4fffffda5a59f61)
	EXT( 0xa5a5a5a5a5a59f60, 34, 24, 0x0000000000696969)
	EXTU(0xa5a5a5a5a5a59f60, 34, 24, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a59f60, 8388607, 34, 24, 0xa5fffffda5a59f60)
	EXT( 0xa5a5a5a5a5a59f5f, 34, 25, 0xffffffffff696969)
	EXTU(0xa5a5a5a5a5a59f5f, 34, 25, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a59f5f, 16777215, 34, 25, 0xa3fffffda5a59f5f)
	EXT( 0xa5a5a5a5a5a59f5e, 34, 26, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a59f5e, 34, 26, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a59f5e, 33554431, 34, 26, 0xa7fffffda5a59f5e)
	EXT( 0xa5a5a5a5a5a59f5d, 34, 27, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a59f5d, 34, 27, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a59f5d, 67108863, 34, 27, 0xaffffffda5a59f5d)
	EXT( 0xa5a5a5a5a5a59f5c, 34, 28, 0xfffffffff9696969)
	EXTU(0xa5a5a5a5a5a59f5c, 34, 28, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a59f5c, 134217727, 34, 28, 0x9ffffffda5a59f5c)
	EXT( 0xa5a5a5a5a5a59f5b, 34, 29, 0x0000000009696969)
	EXTU(0xa5a5a5a5a5a59f5b, 34, 29, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a59f5b, 268435455, 34, 29, 0xbffffffda5a59f5b)
	EXT( 0xa5a5a5a5a5a59f5a, 35, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f5a, 35, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f5a, 0, 35, 1, 0xa5a5a5a5a5a59f5a)
	EXT( 0xa5a5a5a5a5a59f59, 35, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f59, 35, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f59, 1, 35, 2, 0xa5a5a5ada5a59f59)
	EXT( 0xa5a5a5a5a5a59f58, 35, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59f58, 35, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59f58, 3, 35, 3, 0xa5a5a59da5a59f58)
	EXT( 0xa5a5a5a5a5a59f57, 35, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a59f57, 35, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59f57, 7, 35, 4, 0xa5a5a5bda5a59f57)
	EXT( 0xa5a5a5a5a5a59f56, 35, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59f56, 35, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a59f56, 15, 35, 5, 0xa5a5a57da5a59f56)
	EXT( 0xa5a5a5a5a5a59f55, 35, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59f55, 35, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59f55, 31, 35, 6, 0xa5a5a4fda5a59f55)
	EXT( 0xa5a5a5a5a5a59f54, 35, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a59f54, 35, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59f54, 63, 35, 7, 0xa5a5a5fda5a59f54)
	EXT( 0xa5a5a5a5a5a59f53, 35, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a59f53, 35, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59f53, 127, 35, 8, 0xa5a5a3fda5a59f53)
	EXT( 0xa5a5a5a5a5a59f52, 35, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59f52, 35, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59f52, 255, 35, 9, 0xa5a5a7fda5a59f52)
	EXT( 0xa5a5a5a5a5a59f51, 35, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59f51, 35, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59f51, 511, 35, 10, 0xa5a5affda5a59f51)
	EXT( 0xa5a5a5a5a5a59f50, 35, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a59f50, 35, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59f50, 1023, 35, 11, 0xa5a59ffda5a59f50)
	EXT( 0xa5a5a5a5a5a59f4f, 35, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a59f4f, 35, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59f4f, 2047, 35, 12, 0xa5a5bffda5a59f4f)
	EXT( 0xa5a5a5a5a5a59f4e, 35, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a59f4e, 35, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a59f4e, 4095, 35, 13, 0xa5a57ffda5a59f4e)
	EXT( 0xa5a5a5a5a5a59f4d, 35, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a59f4d, 35, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a59f4d, 8191, 35, 14, 0xa5a4fffda5a59f4d)
	EXT( 0xa5a5a5a5a5a59f4c, 35, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a59f4c, 35, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a59f4c, 16383, 35, 15, 0xa5a5fffda5a59f4c)
	EXT( 0xa5a5a5a5a5a59f4b, 35, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a59f4b, 35, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a59f4b, 32767, 35, 16, 0xa5a3fffda5a59f4b)
	EXT( 0xa5a5a5a5a5a59f4a, 35, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a59f4a, 35, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a59f4a, 65535, 35, 17, 0xa5a7fffda5a59f4a)
	EXT( 0xa5a5a5a5a5a59f49, 35, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a59f49, 35, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a59f49, 131071, 35, 18, 0xa5affffda5a59f49)
	EXT( 0xa5a5a5a5a5a59f48, 35, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a59f48, 35, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a59f48, 262143, 35, 19, 0xa59ffffda5a59f48)
	EXT( 0xa5a5a5a5a5a59f47, 35, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a59f47, 35, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a59f47, 524287, 35, 20, 0xa5bffffda5a59f47)
	EXT( 0xa5a5a5a5a5a59f46, 35, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a59f46, 35, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a59f46, 1048575, 35, 21, 0xa57ffffda5a59f46)
	EXT( 0xa5a5a5a5a5a59f45, 35, 22, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a59f45, 35, 22, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a59f45, 2097151, 35, 22, 0xa4fffffda5a59f45)
	EXT( 0xa5a5a5a5a5a59f44, 35, 23, 0x000000000034b4b4)
	EXTU(0xa5a5a5a5a5a59f44, 35, 23, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a59f44, 4194303, 35, 23, 0xa5fffffda5a59f44)
	EXT( 0xa5a5a5a5a5a59f43, 35, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a59f43, 35, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a59f43, 8388607, 35, 24, 0xa3fffffda5a59f43)
	EXT( 0xa5a5a5a5a5a59f42, 35, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a59f42, 35, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a59f42, 16777215, 35, 25, 0xa7fffffda5a59f42)
	EXT( 0xa5a5a5a5a5a59f41, 35, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a59f41, 35, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a59f41, 33554431, 35, 26, 0xaffffffda5a59f41)
	EXT( 0xa5a5a5a5a5a59f40, 35, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a59f40, 35, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a59f40, 67108863, 35, 27, 0x9ffffffda5a59f40)
	EXT( 0xa5a5a5a5a5a59f3f, 35, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a59f3f, 35, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a59f3f, 134217727, 35, 28, 0xbffffffda5a59f3f)
	EXT( 0xa5a5a5a5a5a59f3e, 36, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f3e, 36, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f3e, 0, 36, 1, 0xa5a5a5a5a5a59f3e)
	EXT( 0xa5a5a5a5a5a59f3d, 36, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59f3d, 36, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f3d, 1, 36, 2, 0xa5a5a595a5a59f3d)
	EXT( 0xa5a5a5a5a5a59f3c, 36, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59f3c, 36, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f3c, 3, 36, 3, 0xa5a5a5b5a5a59f3c)
	EXT( 0xa5a5a5a5a5a59f3b, 36, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59f3b, 36, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a59f3b, 7, 36, 4, 0xa5a5a575a5a59f3b)
	EXT( 0xa5a5a5a5a5a59f3a, 36, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59f3a, 36, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59f3a, 15, 36, 5, 0xa5a5a4f5a5a59f3a)
	EXT( 0xa5a5a5a5a5a59f39, 36, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a59f39, 36, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59f39, 31, 36, 6, 0xa5a5a5f5a5a59f39)
	EXT( 0xa5a5a5a5a5a59f38, 36, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a59f38, 36, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59f38, 63, 36, 7, 0xa5a5a3f5a5a59f38)
	EXT( 0xa5a5a5a5a5a59f37, 36, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59f37, 36, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59f37, 127, 36, 8, 0xa5a5a7f5a5a59f37)
	EXT( 0xa5a5a5a5a5a59f36, 36, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59f36, 36, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59f36, 255, 36, 9, 0xa5a5aff5a5a59f36)
	EXT( 0xa5a5a5a5a5a59f35, 36, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a59f35, 36, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59f35, 511, 36, 10, 0xa5a59ff5a5a59f35)
	EXT( 0xa5a5a5a5a5a59f34, 36, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a59f34, 36, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59f34, 1023, 36, 11, 0xa5a5bff5a5a59f34)
	EXT( 0xa5a5a5a5a5a59f33, 36, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a59f33, 36, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a59f33, 2047, 36, 12, 0xa5a57ff5a5a59f33)
	EXT( 0xa5a5a5a5a5a59f32, 36, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a59f32, 36, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a59f32, 4095, 36, 13, 0xa5a4fff5a5a59f32)
	EXT( 0xa5a5a5a5a5a59f31, 36, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a59f31, 36, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a59f31, 8191, 36, 14, 0xa5a5fff5a5a59f31)
	EXT( 0xa5a5a5a5a5a59f30, 36, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a59f30, 36, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a59f30, 16383, 36, 15, 0xa5a3fff5a5a59f30)
	EXT( 0xa5a5a5a5a5a59f2f, 36, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a59f2f, 36, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a59f2f, 32767, 36, 16, 0xa5a7fff5a5a59f2f)
	EXT( 0xa5a5a5a5a5a59f2e, 36, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a59f2e, 36, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a59f2e, 65535, 36, 17, 0xa5affff5a5a59f2e)
	EXT( 0xa5a5a5a5a5a59f2d, 36, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a59f2d, 36, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a59f2d, 131071, 36, 18, 0xa59ffff5a5a59f2d)
	EXT( 0xa5a5a5a5a5a59f2c, 36, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a59f2c, 36, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a59f2c, 262143, 36, 19, 0xa5bffff5a5a59f2c)
	EXT( 0xa5a5a5a5a5a59f2b, 36, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a59f2b, 36, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a59f2b, 524287, 36, 20, 0xa57ffff5a5a59f2b)
	EXT( 0xa5a5a5a5a5a59f2a, 36, 21, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a59f2a, 36, 21, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a59f2a, 1048575, 36, 21, 0xa4fffff5a5a59f2a)
	EXT( 0xa5a5a5a5a5a59f29, 36, 22, 0x00000000001a5a5a)
	EXTU(0xa5a5a5a5a5a59f29, 36, 22, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a59f29, 2097151, 36, 22, 0xa5fffff5a5a59f29)
	EXT( 0xa5a5a5a5a5a59f28, 36, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a59f28, 36, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a59f28, 4194303, 36, 23, 0xa3fffff5a5a59f28)
	EXT( 0xa5a5a5a5a5a59f27, 36, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a59f27, 36, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a59f27, 8388607, 36, 24, 0xa7fffff5a5a59f27)
	EXT( 0xa5a5a5a5a5a59f26, 36, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a59f26, 36, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a59f26, 16777215, 36, 25, 0xaffffff5a5a59f26)
	EXT( 0xa5a5a5a5a5a59f25, 36, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a59f25, 36, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a59f25, 33554431, 36, 26, 0x9ffffff5a5a59f25)
	EXT( 0xa5a5a5a5a5a59f24, 36, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a59f24, 36, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a59f24, 67108863, 36, 27, 0xbffffff5a5a59f24)
	EXT( 0xa5a5a5a5a5a59f23, 37, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59f23, 37, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f23, 0, 37, 1, 0xa5a5a585a5a59f23)
	EXT( 0xa5a5a5a5a5a59f22, 37, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59f22, 37, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f22, 1, 37, 2, 0xa5a5a5a5a5a59f22)
	EXT( 0xa5a5a5a5a5a59f21, 37, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59f21, 37, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59f21, 3, 37, 3, 0xa5a5a565a5a59f21)
	EXT( 0xa5a5a5a5a5a59f20, 37, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59f20, 37, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59f20, 7, 37, 4, 0xa5a5a4e5a5a59f20)
	EXT( 0xa5a5a5a5a5a59f1f, 37, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a59f1f, 37, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59f1f, 15, 37, 5, 0xa5a5a5e5a5a59f1f)
	EXT( 0xa5a5a5a5a5a59f1e, 37, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a59f1e, 37, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59f1e, 31, 37, 6, 0xa5a5a3e5a5a59f1e)
	EXT( 0xa5a5a5a5a5a59f1d, 37, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59f1d, 37, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59f1d, 63, 37, 7, 0xa5a5a7e5a5a59f1d)
	EXT( 0xa5a5a5a5a5a59f1c, 37, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59f1c, 37, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59f1c, 127, 37, 8, 0xa5a5afe5a5a59f1c)
	EXT( 0xa5a5a5a5a5a59f1b, 37, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a59f1b, 37, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59f1b, 255, 37, 9, 0xa5a59fe5a5a59f1b)
	EXT( 0xa5a5a5a5a5a59f1a, 37, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a59f1a, 37, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59f1a, 511, 37, 10, 0xa5a5bfe5a5a59f1a)
	EXT( 0xa5a5a5a5a5a59f19, 37, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a59f19, 37, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a59f19, 1023, 37, 11, 0xa5a57fe5a5a59f19)
	EXT( 0xa5a5a5a5a5a59f18, 37, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a59f18, 37, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a59f18, 2047, 37, 12, 0xa5a4ffe5a5a59f18)
	EXT( 0xa5a5a5a5a5a59f17, 37, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a59f17, 37, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a59f17, 4095, 37, 13, 0xa5a5ffe5a5a59f17)
	EXT( 0xa5a5a5a5a5a59f16, 37, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a59f16, 37, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a59f16, 8191, 37, 14, 0xa5a3ffe5a5a59f16)
	EXT( 0xa5a5a5a5a5a59f15, 37, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a59f15, 37, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a59f15, 16383, 37, 15, 0xa5a7ffe5a5a59f15)
	EXT( 0xa5a5a5a5a5a59f14, 37, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a59f14, 37, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a59f14, 32767, 37, 16, 0xa5afffe5a5a59f14)
	EXT( 0xa5a5a5a5a5a59f13, 37, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a59f13, 37, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a59f13, 65535, 37, 17, 0xa59fffe5a5a59f13)
	EXT( 0xa5a5a5a5a5a59f12, 37, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a59f12, 37, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a59f12, 131071, 37, 18, 0xa5bfffe5a5a59f12)
	EXT( 0xa5a5a5a5a5a59f11, 37, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a59f11, 37, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a59f11, 262143, 37, 19, 0xa57fffe5a5a59f11)
	EXT( 0xa5a5a5a5a5a59f10, 37, 20, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a59f10, 37, 20, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a59f10, 524287, 37, 20, 0xa4ffffe5a5a59f10)
	EXT( 0xa5a5a5a5a5a59f0f, 37, 21, 0x00000000000d2d2d)
	EXTU(0xa5a5a5a5a5a59f0f, 37, 21, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a59f0f, 1048575, 37, 21, 0xa5ffffe5a5a59f0f)
	EXT( 0xa5a5a5a5a5a59f0e, 37, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a59f0e, 37, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a59f0e, 2097151, 37, 22, 0xa3ffffe5a5a59f0e)
	EXT( 0xa5a5a5a5a5a59f0d, 37, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a59f0d, 37, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a59f0d, 4194303, 37, 23, 0xa7ffffe5a5a59f0d)
	EXT( 0xa5a5a5a5a5a59f0c, 37, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a59f0c, 37, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a59f0c, 8388607, 37, 24, 0xafffffe5a5a59f0c)
	EXT( 0xa5a5a5a5a5a59f0b, 37, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a59f0b, 37, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a59f0b, 16777215, 37, 25, 0x9fffffe5a5a59f0b)
	EXT( 0xa5a5a5a5a5a59f0a, 37, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a59f0a, 37, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a59f0a, 33554431, 37, 26, 0xbfffffe5a5a59f0a)
	EXT( 0xa5a5a5a5a5a59f09, 38, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f09, 38, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f09, 0, 38, 1, 0xa5a5a5a5a5a59f09)
	EXT( 0xa5a5a5a5a5a59f08, 38, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59f08, 38, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f08, 1, 38, 2, 0xa5a5a565a5a59f08)
	EXT( 0xa5a5a5a5a5a59f07, 38, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59f07, 38, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59f07, 3, 38, 3, 0xa5a5a4e5a5a59f07)
	EXT( 0xa5a5a5a5a5a59f06, 38, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a59f06, 38, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59f06, 7, 38, 4, 0xa5a5a5e5a5a59f06)
	EXT( 0xa5a5a5a5a5a59f05, 38, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a59f05, 38, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59f05, 15, 38, 5, 0xa5a5a3e5a5a59f05)
	EXT( 0xa5a5a5a5a5a59f04, 38, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59f04, 38, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59f04, 31, 38, 6, 0xa5a5a7e5a5a59f04)
	EXT( 0xa5a5a5a5a5a59f03, 38, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59f03, 38, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59f03, 63, 38, 7, 0xa5a5afe5a5a59f03)
	EXT( 0xa5a5a5a5a5a59f02, 38, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a59f02, 38, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59f02, 127, 38, 8, 0xa5a59fe5a5a59f02)
	EXT( 0xa5a5a5a5a5a59f01, 38, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a59f01, 38, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59f01, 255, 38, 9, 0xa5a5bfe5a5a59f01)
	EXT( 0xa5a5a5a5a5a59f00, 38, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59f00, 38, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a59f00, 511, 38, 10, 0xa5a57fe5a5a59f00)
	EXT( 0xa5a5a5a5a5a59eff, 38, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59eff, 38, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59eff, 1023, 38, 11, 0xa5a4ffe5a5a59eff)
	EXT( 0xa5a5a5a5a5a59efe, 38, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a59efe, 38, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59efe, 2047, 38, 12, 0xa5a5ffe5a5a59efe)
	EXT( 0xa5a5a5a5a5a59efd, 38, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a59efd, 38, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59efd, 4095, 38, 13, 0xa5a3ffe5a5a59efd)
	EXT( 0xa5a5a5a5a5a59efc, 38, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59efc, 38, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59efc, 8191, 38, 14, 0xa5a7ffe5a5a59efc)
	EXT( 0xa5a5a5a5a5a59efb, 38, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59efb, 38, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59efb, 16383, 38, 15, 0xa5afffe5a5a59efb)
	EXT( 0xa5a5a5a5a5a59efa, 38, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a59efa, 38, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59efa, 32767, 38, 16, 0xa59fffe5a5a59efa)
	EXT( 0xa5a5a5a5a5a59ef9, 38, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a59ef9, 38, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59ef9, 65535, 38, 17, 0xa5bfffe5a5a59ef9)
	EXT( 0xa5a5a5a5a5a59ef8, 38, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a59ef8, 38, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a59ef8, 131071, 38, 18, 0xa57fffe5a5a59ef8)
	EXT( 0xa5a5a5a5a5a59ef7, 38, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a59ef7, 38, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a59ef7, 262143, 38, 19, 0xa4ffffe5a5a59ef7)
	EXT( 0xa5a5a5a5a5a59ef6, 38, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a59ef6, 38, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a59ef6, 524287, 38, 20, 0xa5ffffe5a5a59ef6)
	EXT( 0xa5a5a5a5a5a59ef5, 38, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a59ef5, 38, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a59ef5, 1048575, 38, 21, 0xa3ffffe5a5a59ef5)
	EXT( 0xa5a5a5a5a5a59ef4, 38, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a59ef4, 38, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a59ef4, 2097151, 38, 22, 0xa7ffffe5a5a59ef4)
	EXT( 0xa5a5a5a5a5a59ef3, 38, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a59ef3, 38, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a59ef3, 4194303, 38, 23, 0xafffffe5a5a59ef3)
	EXT( 0xa5a5a5a5a5a59ef2, 38, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a59ef2, 38, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a59ef2, 8388607, 38, 24, 0x9fffffe5a5a59ef2)
	EXT( 0xa5a5a5a5a5a59ef1, 38, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a59ef1, 38, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a59ef1, 16777215, 38, 25, 0xbfffffe5a5a59ef1)
	EXT( 0xa5a5a5a5a5a59ef0, 39, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59ef0, 39, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ef0, 0, 39, 1, 0xa5a5a525a5a59ef0)
	EXT( 0xa5a5a5a5a5a59eef, 39, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59eef, 39, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59eef, 1, 39, 2, 0xa5a5a4a5a5a59eef)
	EXT( 0xa5a5a5a5a5a59eee, 39, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59eee, 39, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59eee, 3, 39, 3, 0xa5a5a5a5a5a59eee)
	EXT( 0xa5a5a5a5a5a59eed, 39, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59eed, 39, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59eed, 7, 39, 4, 0xa5a5a3a5a5a59eed)
	EXT( 0xa5a5a5a5a5a59eec, 39, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59eec, 39, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59eec, 15, 39, 5, 0xa5a5a7a5a5a59eec)
	EXT( 0xa5a5a5a5a5a59eeb, 39, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59eeb, 39, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59eeb, 31, 39, 6, 0xa5a5afa5a5a59eeb)
	EXT( 0xa5a5a5a5a5a59eea, 39, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a59eea, 39, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59eea, 63, 39, 7, 0xa5a59fa5a5a59eea)
	EXT( 0xa5a5a5a5a5a59ee9, 39, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a59ee9, 39, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59ee9, 127, 39, 8, 0xa5a5bfa5a5a59ee9)
	EXT( 0xa5a5a5a5a5a59ee8, 39, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59ee8, 39, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a59ee8, 255, 39, 9, 0xa5a57fa5a5a59ee8)
	EXT( 0xa5a5a5a5a5a59ee7, 39, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59ee7, 39, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59ee7, 511, 39, 10, 0xa5a4ffa5a5a59ee7)
	EXT( 0xa5a5a5a5a5a59ee6, 39, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a59ee6, 39, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59ee6, 1023, 39, 11, 0xa5a5ffa5a5a59ee6)
	EXT( 0xa5a5a5a5a5a59ee5, 39, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a59ee5, 39, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59ee5, 2047, 39, 12, 0xa5a3ffa5a5a59ee5)
	EXT( 0xa5a5a5a5a5a59ee4, 39, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59ee4, 39, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59ee4, 4095, 39, 13, 0xa5a7ffa5a5a59ee4)
	EXT( 0xa5a5a5a5a5a59ee3, 39, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59ee3, 39, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59ee3, 8191, 39, 14, 0xa5afffa5a5a59ee3)
	EXT( 0xa5a5a5a5a5a59ee2, 39, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a59ee2, 39, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59ee2, 16383, 39, 15, 0xa59fffa5a5a59ee2)
	EXT( 0xa5a5a5a5a5a59ee1, 39, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a59ee1, 39, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59ee1, 32767, 39, 16, 0xa5bfffa5a5a59ee1)
	EXT( 0xa5a5a5a5a5a59ee0, 39, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a59ee0, 39, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a59ee0, 65535, 39, 17, 0xa57fffa5a5a59ee0)
	EXT( 0xa5a5a5a5a5a59edf, 39, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a59edf, 39, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a59edf, 131071, 39, 18, 0xa4ffffa5a5a59edf)
	EXT( 0xa5a5a5a5a5a59ede, 39, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a59ede, 39, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a59ede, 262143, 39, 19, 0xa5ffffa5a5a59ede)
	EXT( 0xa5a5a5a5a5a59edd, 39, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a59edd, 39, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a59edd, 524287, 39, 20, 0xa3ffffa5a5a59edd)
	EXT( 0xa5a5a5a5a5a59edc, 39, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a59edc, 39, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a59edc, 1048575, 39, 21, 0xa7ffffa5a5a59edc)
	EXT( 0xa5a5a5a5a5a59edb, 39, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a59edb, 39, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a59edb, 2097151, 39, 22, 0xafffffa5a5a59edb)
	EXT( 0xa5a5a5a5a5a59eda, 39, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a59eda, 39, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a59eda, 4194303, 39, 23, 0x9fffffa5a5a59eda)
	EXT( 0xa5a5a5a5a5a59ed9, 39, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a59ed9, 39, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a59ed9, 8388607, 39, 24, 0xbfffffa5a5a59ed9)
	EXT( 0xa5a5a5a5a5a59ed8, 40, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59ed8, 40, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ed8, 0, 40, 1, 0xa5a5a4a5a5a59ed8)
	EXT( 0xa5a5a5a5a5a59ed7, 40, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59ed7, 40, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ed7, 1, 40, 2, 0xa5a5a5a5a5a59ed7)
	EXT( 0xa5a5a5a5a5a59ed6, 40, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59ed6, 40, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59ed6, 3, 40, 3, 0xa5a5a3a5a5a59ed6)
	EXT( 0xa5a5a5a5a5a59ed5, 40, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59ed5, 40, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59ed5, 7, 40, 4, 0xa5a5a7a5a5a59ed5)
	EXT( 0xa5a5a5a5a5a59ed4, 40, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59ed4, 40, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59ed4, 15, 40, 5, 0xa5a5afa5a5a59ed4)
	EXT( 0xa5a5a5a5a5a59ed3, 40, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a59ed3, 40, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59ed3, 31, 40, 6, 0xa5a59fa5a5a59ed3)
	EXT( 0xa5a5a5a5a5a59ed2, 40, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a59ed2, 40, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59ed2, 63, 40, 7, 0xa5a5bfa5a5a59ed2)
	EXT( 0xa5a5a5a5a5a59ed1, 40, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59ed1, 40, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a59ed1, 127, 40, 8, 0xa5a57fa5a5a59ed1)
	EXT( 0xa5a5a5a5a5a59ed0, 40, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59ed0, 40, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59ed0, 255, 40, 9, 0xa5a4ffa5a5a59ed0)
	EXT( 0xa5a5a5a5a5a59ecf, 40, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a59ecf, 40, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59ecf, 511, 40, 10, 0xa5a5ffa5a5a59ecf)
	EXT( 0xa5a5a5a5a5a59ece, 40, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a59ece, 40, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59ece, 1023, 40, 11, 0xa5a3ffa5a5a59ece)
	EXT( 0xa5a5a5a5a5a59ecd, 40, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59ecd, 40, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59ecd, 2047, 40, 12, 0xa5a7ffa5a5a59ecd)
	EXT( 0xa5a5a5a5a5a59ecc, 40, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59ecc, 40, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59ecc, 4095, 40, 13, 0xa5afffa5a5a59ecc)
	EXT( 0xa5a5a5a5a5a59ecb, 40, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a59ecb, 40, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59ecb, 8191, 40, 14, 0xa59fffa5a5a59ecb)
	EXT( 0xa5a5a5a5a5a59eca, 40, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a59eca, 40, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59eca, 16383, 40, 15, 0xa5bfffa5a5a59eca)
	EXT( 0xa5a5a5a5a5a59ec9, 40, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a59ec9, 40, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a59ec9, 32767, 40, 16, 0xa57fffa5a5a59ec9)
	EXT( 0xa5a5a5a5a5a59ec8, 40, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a59ec8, 40, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a59ec8, 65535, 40, 17, 0xa4ffffa5a5a59ec8)
	EXT( 0xa5a5a5a5a5a59ec7, 40, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a59ec7, 40, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a59ec7, 131071, 40, 18, 0xa5ffffa5a5a59ec7)
	EXT( 0xa5a5a5a5a5a59ec6, 40, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a59ec6, 40, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a59ec6, 262143, 40, 19, 0xa3ffffa5a5a59ec6)
	EXT( 0xa5a5a5a5a5a59ec5, 40, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a59ec5, 40, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a59ec5, 524287, 40, 20, 0xa7ffffa5a5a59ec5)
	EXT( 0xa5a5a5a5a5a59ec4, 40, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a59ec4, 40, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a59ec4, 1048575, 40, 21, 0xafffffa5a5a59ec4)
	EXT( 0xa5a5a5a5a5a59ec3, 40, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a59ec3, 40, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a59ec3, 2097151, 40, 22, 0x9fffffa5a5a59ec3)
	EXT( 0xa5a5a5a5a5a59ec2, 40, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a59ec2, 40, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a59ec2, 4194303, 40, 23, 0xbfffffa5a5a59ec2)
	EXT( 0xa5a5a5a5a5a59ec1, 41, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59ec1, 41, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59ec1, 0, 41, 1, 0xa5a5a5a5a5a59ec1)
	EXT( 0xa5a5a5a5a5a59ec0, 41, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59ec0, 41, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59ec0, 1, 41, 2, 0xa5a5a3a5a5a59ec0)
	EXT( 0xa5a5a5a5a5a59ebf, 41, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59ebf, 41, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59ebf, 3, 41, 3, 0xa5a5a7a5a5a59ebf)
	EXT( 0xa5a5a5a5a5a59ebe, 41, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59ebe, 41, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59ebe, 7, 41, 4, 0xa5a5afa5a5a59ebe)
	EXT( 0xa5a5a5a5a5a59ebd, 41, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a59ebd, 41, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59ebd, 15, 41, 5, 0xa5a59fa5a5a59ebd)
	EXT( 0xa5a5a5a5a5a59ebc, 41, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a59ebc, 41, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59ebc, 31, 41, 6, 0xa5a5bfa5a5a59ebc)
	EXT( 0xa5a5a5a5a5a59ebb, 41, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59ebb, 41, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a59ebb, 63, 41, 7, 0xa5a57fa5a5a59ebb)
	EXT( 0xa5a5a5a5a5a59eba, 41, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59eba, 41, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59eba, 127, 41, 8, 0xa5a4ffa5a5a59eba)
	EXT( 0xa5a5a5a5a5a59eb9, 41, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a59eb9, 41, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59eb9, 255, 41, 9, 0xa5a5ffa5a5a59eb9)
	EXT( 0xa5a5a5a5a5a59eb8, 41, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a59eb8, 41, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59eb8, 511, 41, 10, 0xa5a3ffa5a5a59eb8)
	EXT( 0xa5a5a5a5a5a59eb7, 41, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59eb7, 41, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59eb7, 1023, 41, 11, 0xa5a7ffa5a5a59eb7)
	EXT( 0xa5a5a5a5a5a59eb6, 41, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59eb6, 41, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59eb6, 2047, 41, 12, 0xa5afffa5a5a59eb6)
	EXT( 0xa5a5a5a5a5a59eb5, 41, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a59eb5, 41, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59eb5, 4095, 41, 13, 0xa59fffa5a5a59eb5)
	EXT( 0xa5a5a5a5a5a59eb4, 41, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a59eb4, 41, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59eb4, 8191, 41, 14, 0xa5bfffa5a5a59eb4)
	EXT( 0xa5a5a5a5a5a59eb3, 41, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a59eb3, 41, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a59eb3, 16383, 41, 15, 0xa57fffa5a5a59eb3)
	EXT( 0xa5a5a5a5a5a59eb2, 41, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a59eb2, 41, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a59eb2, 32767, 41, 16, 0xa4ffffa5a5a59eb2)
	EXT( 0xa5a5a5a5a5a59eb1, 41, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a59eb1, 41, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a59eb1, 65535, 41, 17, 0xa5ffffa5a5a59eb1)
	EXT( 0xa5a5a5a5a5a59eb0, 41, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a59eb0, 41, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a59eb0, 131071, 41, 18, 0xa3ffffa5a5a59eb0)
	EXT( 0xa5a5a5a5a5a59eaf, 41, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a59eaf, 41, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a59eaf, 262143, 41, 19, 0xa7ffffa5a5a59eaf)
	EXT( 0xa5a5a5a5a5a59eae, 41, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a59eae, 41, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a59eae, 524287, 41, 20, 0xafffffa5a5a59eae)
	EXT( 0xa5a5a5a5a5a59ead, 41, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a59ead, 41, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a59ead, 1048575, 41, 21, 0x9fffffa5a5a59ead)
	EXT( 0xa5a5a5a5a5a59eac, 41, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a59eac, 41, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a59eac, 2097151, 41, 22, 0xbfffffa5a5a59eac)
	EXT( 0xa5a5a5a5a5a59eab, 42, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59eab, 42, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59eab, 0, 42, 1, 0xa5a5a1a5a5a59eab)
	EXT( 0xa5a5a5a5a5a59eaa, 42, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59eaa, 42, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59eaa, 1, 42, 2, 0xa5a5a5a5a5a59eaa)
	EXT( 0xa5a5a5a5a5a59ea9, 42, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59ea9, 42, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ea9, 3, 42, 3, 0xa5a5ada5a5a59ea9)
	EXT( 0xa5a5a5a5a5a59ea8, 42, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59ea8, 42, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59ea8, 7, 42, 4, 0xa5a59da5a5a59ea8)
	EXT( 0xa5a5a5a5a5a59ea7, 42, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a59ea7, 42, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59ea7, 15, 42, 5, 0xa5a5bda5a5a59ea7)
	EXT( 0xa5a5a5a5a5a59ea6, 42, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59ea6, 42, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a59ea6, 31, 42, 6, 0xa5a57da5a5a59ea6)
	EXT( 0xa5a5a5a5a5a59ea5, 42, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59ea5, 42, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59ea5, 63, 42, 7, 0xa5a4fda5a5a59ea5)
	EXT( 0xa5a5a5a5a5a59ea4, 42, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a59ea4, 42, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59ea4, 127, 42, 8, 0xa5a5fda5a5a59ea4)
	EXT( 0xa5a5a5a5a5a59ea3, 42, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a59ea3, 42, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59ea3, 255, 42, 9, 0xa5a3fda5a5a59ea3)
	EXT( 0xa5a5a5a5a5a59ea2, 42, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59ea2, 42, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59ea2, 511, 42, 10, 0xa5a7fda5a5a59ea2)
	EXT( 0xa5a5a5a5a5a59ea1, 42, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59ea1, 42, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59ea1, 1023, 42, 11, 0xa5affda5a5a59ea1)
	EXT( 0xa5a5a5a5a5a59ea0, 42, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a59ea0, 42, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59ea0, 2047, 42, 12, 0xa59ffda5a5a59ea0)
	EXT( 0xa5a5a5a5a5a59e9f, 42, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a59e9f, 42, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59e9f, 4095, 42, 13, 0xa5bffda5a5a59e9f)
	EXT( 0xa5a5a5a5a5a59e9e, 42, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a59e9e, 42, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a59e9e, 8191, 42, 14, 0xa57ffda5a5a59e9e)
	EXT( 0xa5a5a5a5a5a59e9d, 42, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a59e9d, 42, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a59e9d, 16383, 42, 15, 0xa4fffda5a5a59e9d)
	EXT( 0xa5a5a5a5a5a59e9c, 42, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a59e9c, 42, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a59e9c, 32767, 42, 16, 0xa5fffda5a5a59e9c)
	EXT( 0xa5a5a5a5a5a59e9b, 42, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a59e9b, 42, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a59e9b, 65535, 42, 17, 0xa3fffda5a5a59e9b)
	EXT( 0xa5a5a5a5a5a59e9a, 42, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a59e9a, 42, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a59e9a, 131071, 42, 18, 0xa7fffda5a5a59e9a)
	EXT( 0xa5a5a5a5a5a59e99, 42, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a59e99, 42, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a59e99, 262143, 42, 19, 0xaffffda5a5a59e99)
	EXT( 0xa5a5a5a5a5a59e98, 42, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a59e98, 42, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a59e98, 524287, 42, 20, 0x9ffffda5a5a59e98)
	EXT( 0xa5a5a5a5a5a59e97, 42, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a59e97, 42, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a59e97, 1048575, 42, 21, 0xbffffda5a5a59e97)
	EXT( 0xa5a5a5a5a5a59e96, 43, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e96, 43, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e96, 0, 43, 1, 0xa5a5a5a5a5a59e96)
	EXT( 0xa5a5a5a5a5a59e95, 43, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e95, 43, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e95, 1, 43, 2, 0xa5a5ada5a5a59e95)
	EXT( 0xa5a5a5a5a5a59e94, 43, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59e94, 43, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59e94, 3, 43, 3, 0xa5a59da5a5a59e94)
	EXT( 0xa5a5a5a5a5a59e93, 43, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a59e93, 43, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59e93, 7, 43, 4, 0xa5a5bda5a5a59e93)
	EXT( 0xa5a5a5a5a5a59e92, 43, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59e92, 43, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a59e92, 15, 43, 5, 0xa5a57da5a5a59e92)
	EXT( 0xa5a5a5a5a5a59e91, 43, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59e91, 43, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59e91, 31, 43, 6, 0xa5a4fda5a5a59e91)
	EXT( 0xa5a5a5a5a5a59e90, 43, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a59e90, 43, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59e90, 63, 43, 7, 0xa5a5fda5a5a59e90)
	EXT( 0xa5a5a5a5a5a59e8f, 43, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a59e8f, 43, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59e8f, 127, 43, 8, 0xa5a3fda5a5a59e8f)
	EXT( 0xa5a5a5a5a5a59e8e, 43, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59e8e, 43, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59e8e, 255, 43, 9, 0xa5a7fda5a5a59e8e)
	EXT( 0xa5a5a5a5a5a59e8d, 43, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59e8d, 43, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59e8d, 511, 43, 10, 0xa5affda5a5a59e8d)
	EXT( 0xa5a5a5a5a5a59e8c, 43, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a59e8c, 43, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59e8c, 1023, 43, 11, 0xa59ffda5a5a59e8c)
	EXT( 0xa5a5a5a5a5a59e8b, 43, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a59e8b, 43, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59e8b, 2047, 43, 12, 0xa5bffda5a5a59e8b)
	EXT( 0xa5a5a5a5a5a59e8a, 43, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a59e8a, 43, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a59e8a, 4095, 43, 13, 0xa57ffda5a5a59e8a)
	EXT( 0xa5a5a5a5a5a59e89, 43, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a59e89, 43, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a59e89, 8191, 43, 14, 0xa4fffda5a5a59e89)
	EXT( 0xa5a5a5a5a5a59e88, 43, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a59e88, 43, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a59e88, 16383, 43, 15, 0xa5fffda5a5a59e88)
	EXT( 0xa5a5a5a5a5a59e87, 43, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a59e87, 43, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a59e87, 32767, 43, 16, 0xa3fffda5a5a59e87)
	EXT( 0xa5a5a5a5a5a59e86, 43, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a59e86, 43, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a59e86, 65535, 43, 17, 0xa7fffda5a5a59e86)
	EXT( 0xa5a5a5a5a5a59e85, 43, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a59e85, 43, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a59e85, 131071, 43, 18, 0xaffffda5a5a59e85)
	EXT( 0xa5a5a5a5a5a59e84, 43, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a59e84, 43, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a59e84, 262143, 43, 19, 0x9ffffda5a5a59e84)
	EXT( 0xa5a5a5a5a5a59e83, 43, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a59e83, 43, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a59e83, 524287, 43, 20, 0xbffffda5a5a59e83)
	EXT( 0xa5a5a5a5a5a59e82, 44, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e82, 44, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e82, 0, 44, 1, 0xa5a5a5a5a5a59e82)
	EXT( 0xa5a5a5a5a5a59e81, 44, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e81, 44, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e81, 1, 44, 2, 0xa5a595a5a5a59e81)
	EXT( 0xa5a5a5a5a5a59e80, 44, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59e80, 44, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e80, 3, 44, 3, 0xa5a5b5a5a5a59e80)
	EXT( 0xa5a5a5a5a5a59e7f, 44, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59e7f, 44, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a59e7f, 7, 44, 4, 0xa5a575a5a5a59e7f)
	EXT( 0xa5a5a5a5a5a59e7e, 44, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59e7e, 44, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59e7e, 15, 44, 5, 0xa5a4f5a5a5a59e7e)
	EXT( 0xa5a5a5a5a5a59e7d, 44, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a59e7d, 44, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59e7d, 31, 44, 6, 0xa5a5f5a5a5a59e7d)
	EXT( 0xa5a5a5a5a5a59e7c, 44, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a59e7c, 44, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59e7c, 63, 44, 7, 0xa5a3f5a5a5a59e7c)
	EXT( 0xa5a5a5a5a5a59e7b, 44, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59e7b, 44, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59e7b, 127, 44, 8, 0xa5a7f5a5a5a59e7b)
	EXT( 0xa5a5a5a5a5a59e7a, 44, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59e7a, 44, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59e7a, 255, 44, 9, 0xa5aff5a5a5a59e7a)
	EXT( 0xa5a5a5a5a5a59e79, 44, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a59e79, 44, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59e79, 511, 44, 10, 0xa59ff5a5a5a59e79)
	EXT( 0xa5a5a5a5a5a59e78, 44, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a59e78, 44, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59e78, 1023, 44, 11, 0xa5bff5a5a5a59e78)
	EXT( 0xa5a5a5a5a5a59e77, 44, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a59e77, 44, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a59e77, 2047, 44, 12, 0xa57ff5a5a5a59e77)
	EXT( 0xa5a5a5a5a5a59e76, 44, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a59e76, 44, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a59e76, 4095, 44, 13, 0xa4fff5a5a5a59e76)
	EXT( 0xa5a5a5a5a5a59e75, 44, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a59e75, 44, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a59e75, 8191, 44, 14, 0xa5fff5a5a5a59e75)
	EXT( 0xa5a5a5a5a5a59e74, 44, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a59e74, 44, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a59e74, 16383, 44, 15, 0xa3fff5a5a5a59e74)
	EXT( 0xa5a5a5a5a5a59e73, 44, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a59e73, 44, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a59e73, 32767, 44, 16, 0xa7fff5a5a5a59e73)
	EXT( 0xa5a5a5a5a5a59e72, 44, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a59e72, 44, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a59e72, 65535, 44, 17, 0xaffff5a5a5a59e72)
	EXT( 0xa5a5a5a5a5a59e71, 44, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a59e71, 44, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a59e71, 131071, 44, 18, 0x9ffff5a5a5a59e71)
	EXT( 0xa5a5a5a5a5a59e70, 44, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a59e70, 44, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a59e70, 262143, 44, 19, 0xbffff5a5a5a59e70)
	EXT( 0xa5a5a5a5a5a59e6f, 45, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e6f, 45, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e6f, 0, 45, 1, 0xa5a585a5a5a59e6f)
	EXT( 0xa5a5a5a5a5a59e6e, 45, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e6e, 45, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e6e, 1, 45, 2, 0xa5a5a5a5a5a59e6e)
	EXT( 0xa5a5a5a5a5a59e6d, 45, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59e6d, 45, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59e6d, 3, 45, 3, 0xa5a565a5a5a59e6d)
	EXT( 0xa5a5a5a5a5a59e6c, 45, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59e6c, 45, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59e6c, 7, 45, 4, 0xa5a4e5a5a5a59e6c)
	EXT( 0xa5a5a5a5a5a59e6b, 45, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a59e6b, 45, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59e6b, 15, 45, 5, 0xa5a5e5a5a5a59e6b)
	EXT( 0xa5a5a5a5a5a59e6a, 45, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a59e6a, 45, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59e6a, 31, 45, 6, 0xa5a3e5a5a5a59e6a)
	EXT( 0xa5a5a5a5a5a59e69, 45, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59e69, 45, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59e69, 63, 45, 7, 0xa5a7e5a5a5a59e69)
	EXT( 0xa5a5a5a5a5a59e68, 45, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59e68, 45, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59e68, 127, 45, 8, 0xa5afe5a5a5a59e68)
	EXT( 0xa5a5a5a5a5a59e67, 45, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a59e67, 45, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59e67, 255, 45, 9, 0xa59fe5a5a5a59e67)
	EXT( 0xa5a5a5a5a5a59e66, 45, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a59e66, 45, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59e66, 511, 45, 10, 0xa5bfe5a5a5a59e66)
	EXT( 0xa5a5a5a5a5a59e65, 45, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a59e65, 45, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a59e65, 1023, 45, 11, 0xa57fe5a5a5a59e65)
	EXT( 0xa5a5a5a5a5a59e64, 45, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a59e64, 45, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a59e64, 2047, 45, 12, 0xa4ffe5a5a5a59e64)
	EXT( 0xa5a5a5a5a5a59e63, 45, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a59e63, 45, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a59e63, 4095, 45, 13, 0xa5ffe5a5a5a59e63)
	EXT( 0xa5a5a5a5a5a59e62, 45, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a59e62, 45, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a59e62, 8191, 45, 14, 0xa3ffe5a5a5a59e62)
	EXT( 0xa5a5a5a5a5a59e61, 45, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a59e61, 45, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a59e61, 16383, 45, 15, 0xa7ffe5a5a5a59e61)
	EXT( 0xa5a5a5a5a5a59e60, 45, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a59e60, 45, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a59e60, 32767, 45, 16, 0xafffe5a5a5a59e60)
	EXT( 0xa5a5a5a5a5a59e5f, 45, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a59e5f, 45, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a59e5f, 65535, 45, 17, 0x9fffe5a5a5a59e5f)
	EXT( 0xa5a5a5a5a5a59e5e, 45, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a59e5e, 45, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a59e5e, 131071, 45, 18, 0xbfffe5a5a5a59e5e)
	EXT( 0xa5a5a5a5a5a59e5d, 46, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e5d, 46, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e5d, 0, 46, 1, 0xa5a5a5a5a5a59e5d)
	EXT( 0xa5a5a5a5a5a59e5c, 46, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e5c, 46, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e5c, 1, 46, 2, 0xa5a565a5a5a59e5c)
	EXT( 0xa5a5a5a5a5a59e5b, 46, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e5b, 46, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59e5b, 3, 46, 3, 0xa5a4e5a5a5a59e5b)
	EXT( 0xa5a5a5a5a5a59e5a, 46, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a59e5a, 46, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59e5a, 7, 46, 4, 0xa5a5e5a5a5a59e5a)
	EXT( 0xa5a5a5a5a5a59e59, 46, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a59e59, 46, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59e59, 15, 46, 5, 0xa5a3e5a5a5a59e59)
	EXT( 0xa5a5a5a5a5a59e58, 46, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59e58, 46, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59e58, 31, 46, 6, 0xa5a7e5a5a5a59e58)
	EXT( 0xa5a5a5a5a5a59e57, 46, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59e57, 46, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59e57, 63, 46, 7, 0xa5afe5a5a5a59e57)
	EXT( 0xa5a5a5a5a5a59e56, 46, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a59e56, 46, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59e56, 127, 46, 8, 0xa59fe5a5a5a59e56)
	EXT( 0xa5a5a5a5a5a59e55, 46, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a59e55, 46, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59e55, 255, 46, 9, 0xa5bfe5a5a5a59e55)
	EXT( 0xa5a5a5a5a5a59e54, 46, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59e54, 46, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a59e54, 511, 46, 10, 0xa57fe5a5a5a59e54)
	EXT( 0xa5a5a5a5a5a59e53, 46, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59e53, 46, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59e53, 1023, 46, 11, 0xa4ffe5a5a5a59e53)
	EXT( 0xa5a5a5a5a5a59e52, 46, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a59e52, 46, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59e52, 2047, 46, 12, 0xa5ffe5a5a5a59e52)
	EXT( 0xa5a5a5a5a5a59e51, 46, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a59e51, 46, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59e51, 4095, 46, 13, 0xa3ffe5a5a5a59e51)
	EXT( 0xa5a5a5a5a5a59e50, 46, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59e50, 46, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59e50, 8191, 46, 14, 0xa7ffe5a5a5a59e50)
	EXT( 0xa5a5a5a5a5a59e4f, 46, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59e4f, 46, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59e4f, 16383, 46, 15, 0xafffe5a5a5a59e4f)
	EXT( 0xa5a5a5a5a5a59e4e, 46, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a59e4e, 46, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59e4e, 32767, 46, 16, 0x9fffe5a5a5a59e4e)
	EXT( 0xa5a5a5a5a5a59e4d, 46, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a59e4d, 46, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59e4d, 65535, 46, 17, 0xbfffe5a5a5a59e4d)
	EXT( 0xa5a5a5a5a5a59e4c, 47, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e4c, 47, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e4c, 0, 47, 1, 0xa5a525a5a5a59e4c)
	EXT( 0xa5a5a5a5a5a59e4b, 47, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e4b, 47, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e4b, 1, 47, 2, 0xa5a4a5a5a5a59e4b)
	EXT( 0xa5a5a5a5a5a59e4a, 47, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59e4a, 47, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e4a, 3, 47, 3, 0xa5a5a5a5a5a59e4a)
	EXT( 0xa5a5a5a5a5a59e49, 47, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59e49, 47, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59e49, 7, 47, 4, 0xa5a3a5a5a5a59e49)
	EXT( 0xa5a5a5a5a5a59e48, 47, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59e48, 47, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59e48, 15, 47, 5, 0xa5a7a5a5a5a59e48)
	EXT( 0xa5a5a5a5a5a59e47, 47, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59e47, 47, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59e47, 31, 47, 6, 0xa5afa5a5a5a59e47)
	EXT( 0xa5a5a5a5a5a59e46, 47, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a59e46, 47, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59e46, 63, 47, 7, 0xa59fa5a5a5a59e46)
	EXT( 0xa5a5a5a5a5a59e45, 47, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a59e45, 47, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59e45, 127, 47, 8, 0xa5bfa5a5a5a59e45)
	EXT( 0xa5a5a5a5a5a59e44, 47, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59e44, 47, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a59e44, 255, 47, 9, 0xa57fa5a5a5a59e44)
	EXT( 0xa5a5a5a5a5a59e43, 47, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59e43, 47, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59e43, 511, 47, 10, 0xa4ffa5a5a5a59e43)
	EXT( 0xa5a5a5a5a5a59e42, 47, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a59e42, 47, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59e42, 1023, 47, 11, 0xa5ffa5a5a5a59e42)
	EXT( 0xa5a5a5a5a5a59e41, 47, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a59e41, 47, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59e41, 2047, 47, 12, 0xa3ffa5a5a5a59e41)
	EXT( 0xa5a5a5a5a5a59e40, 47, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59e40, 47, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59e40, 4095, 47, 13, 0xa7ffa5a5a5a59e40)
	EXT( 0xa5a5a5a5a5a59e3f, 47, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59e3f, 47, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59e3f, 8191, 47, 14, 0xafffa5a5a5a59e3f)
	EXT( 0xa5a5a5a5a5a59e3e, 47, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a59e3e, 47, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59e3e, 16383, 47, 15, 0x9fffa5a5a5a59e3e)
	EXT( 0xa5a5a5a5a5a59e3d, 47, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a59e3d, 47, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59e3d, 32767, 47, 16, 0xbfffa5a5a5a59e3d)
	EXT( 0xa5a5a5a5a5a59e3c, 48, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e3c, 48, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e3c, 0, 48, 1, 0xa5a4a5a5a5a59e3c)
	EXT( 0xa5a5a5a5a5a59e3b, 48, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e3b, 48, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e3b, 1, 48, 2, 0xa5a5a5a5a5a59e3b)
	EXT( 0xa5a5a5a5a5a59e3a, 48, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59e3a, 48, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59e3a, 3, 48, 3, 0xa5a3a5a5a5a59e3a)
	EXT( 0xa5a5a5a5a5a59e39, 48, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59e39, 48, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59e39, 7, 48, 4, 0xa5a7a5a5a5a59e39)
	EXT( 0xa5a5a5a5a5a59e38, 48, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59e38, 48, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59e38, 15, 48, 5, 0xa5afa5a5a5a59e38)
	EXT( 0xa5a5a5a5a5a59e37, 48, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a59e37, 48, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59e37, 31, 48, 6, 0xa59fa5a5a5a59e37)
	EXT( 0xa5a5a5a5a5a59e36, 48, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a59e36, 48, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59e36, 63, 48, 7, 0xa5bfa5a5a5a59e36)
	EXT( 0xa5a5a5a5a5a59e35, 48, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59e35, 48, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a59e35, 127, 48, 8, 0xa57fa5a5a5a59e35)
	EXT( 0xa5a5a5a5a5a59e34, 48, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59e34, 48, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59e34, 255, 48, 9, 0xa4ffa5a5a5a59e34)
	EXT( 0xa5a5a5a5a5a59e33, 48, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a59e33, 48, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59e33, 511, 48, 10, 0xa5ffa5a5a5a59e33)
	EXT( 0xa5a5a5a5a5a59e32, 48, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a59e32, 48, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59e32, 1023, 48, 11, 0xa3ffa5a5a5a59e32)
	EXT( 0xa5a5a5a5a5a59e31, 48, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59e31, 48, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59e31, 2047, 48, 12, 0xa7ffa5a5a5a59e31)
	EXT( 0xa5a5a5a5a5a59e30, 48, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59e30, 48, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59e30, 4095, 48, 13, 0xafffa5a5a5a59e30)
	EXT( 0xa5a5a5a5a5a59e2f, 48, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a59e2f, 48, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59e2f, 8191, 48, 14, 0x9fffa5a5a5a59e2f)
	EXT( 0xa5a5a5a5a5a59e2e, 48, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a59e2e, 48, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59e2e, 16383, 48, 15, 0xbfffa5a5a5a59e2e)
	EXT( 0xa5a5a5a5a5a59e2d, 49, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e2d, 49, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e2d, 0, 49, 1, 0xa5a5a5a5a5a59e2d)
	EXT( 0xa5a5a5a5a5a59e2c, 49, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e2c, 49, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e2c, 1, 49, 2, 0xa5a3a5a5a5a59e2c)
	EXT( 0xa5a5a5a5a5a59e2b, 49, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59e2b, 49, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e2b, 3, 49, 3, 0xa5a7a5a5a5a59e2b)
	EXT( 0xa5a5a5a5a5a59e2a, 49, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59e2a, 49, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e2a, 7, 49, 4, 0xa5afa5a5a5a59e2a)
	EXT( 0xa5a5a5a5a5a59e29, 49, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a59e29, 49, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59e29, 15, 49, 5, 0xa59fa5a5a5a59e29)
	EXT( 0xa5a5a5a5a5a59e28, 49, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a59e28, 49, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59e28, 31, 49, 6, 0xa5bfa5a5a5a59e28)
	EXT( 0xa5a5a5a5a5a59e27, 49, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59e27, 49, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a59e27, 63, 49, 7, 0xa57fa5a5a5a59e27)
	EXT( 0xa5a5a5a5a5a59e26, 49, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59e26, 49, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59e26, 127, 49, 8, 0xa4ffa5a5a5a59e26)
	EXT( 0xa5a5a5a5a5a59e25, 49, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a59e25, 49, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59e25, 255, 49, 9, 0xa5ffa5a5a5a59e25)
	EXT( 0xa5a5a5a5a5a59e24, 49, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a59e24, 49, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59e24, 511, 49, 10, 0xa3ffa5a5a5a59e24)
	EXT( 0xa5a5a5a5a5a59e23, 49, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59e23, 49, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59e23, 1023, 49, 11, 0xa7ffa5a5a5a59e23)
	EXT( 0xa5a5a5a5a5a59e22, 49, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59e22, 49, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59e22, 2047, 49, 12, 0xafffa5a5a5a59e22)
	EXT( 0xa5a5a5a5a5a59e21, 49, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a59e21, 49, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59e21, 4095, 49, 13, 0x9fffa5a5a5a59e21)
	EXT( 0xa5a5a5a5a5a59e20, 49, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a59e20, 49, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59e20, 8191, 49, 14, 0xbfffa5a5a5a59e20)
	EXT( 0xa5a5a5a5a5a59e1f, 50, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e1f, 50, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e1f, 0, 50, 1, 0xa5a1a5a5a5a59e1f)
	EXT( 0xa5a5a5a5a5a59e1e, 50, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e1e, 50, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e1e, 1, 50, 2, 0xa5a5a5a5a5a59e1e)
	EXT( 0xa5a5a5a5a5a59e1d, 50, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e1d, 50, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e1d, 3, 50, 3, 0xa5ada5a5a5a59e1d)
	EXT( 0xa5a5a5a5a5a59e1c, 50, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59e1c, 50, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59e1c, 7, 50, 4, 0xa59da5a5a5a59e1c)
	EXT( 0xa5a5a5a5a5a59e1b, 50, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a59e1b, 50, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59e1b, 15, 50, 5, 0xa5bda5a5a5a59e1b)
	EXT( 0xa5a5a5a5a5a59e1a, 50, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59e1a, 50, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a59e1a, 31, 50, 6, 0xa57da5a5a5a59e1a)
	EXT( 0xa5a5a5a5a5a59e19, 50, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59e19, 50, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59e19, 63, 50, 7, 0xa4fda5a5a5a59e19)
	EXT( 0xa5a5a5a5a5a59e18, 50, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a59e18, 50, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59e18, 127, 50, 8, 0xa5fda5a5a5a59e18)
	EXT( 0xa5a5a5a5a5a59e17, 50, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a59e17, 50, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59e17, 255, 50, 9, 0xa3fda5a5a5a59e17)
	EXT( 0xa5a5a5a5a5a59e16, 50, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59e16, 50, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59e16, 511, 50, 10, 0xa7fda5a5a5a59e16)
	EXT( 0xa5a5a5a5a5a59e15, 50, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59e15, 50, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59e15, 1023, 50, 11, 0xaffda5a5a5a59e15)
	EXT( 0xa5a5a5a5a5a59e14, 50, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a59e14, 50, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59e14, 2047, 50, 12, 0x9ffda5a5a5a59e14)
	EXT( 0xa5a5a5a5a5a59e13, 50, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a59e13, 50, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59e13, 4095, 50, 13, 0xbffda5a5a5a59e13)
	EXT( 0xa5a5a5a5a5a59e12, 51, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e12, 51, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e12, 0, 51, 1, 0xa5a5a5a5a5a59e12)
	EXT( 0xa5a5a5a5a5a59e11, 51, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e11, 51, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e11, 1, 51, 2, 0xa5ada5a5a5a59e11)
	EXT( 0xa5a5a5a5a5a59e10, 51, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59e10, 51, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59e10, 3, 51, 3, 0xa59da5a5a5a59e10)
	EXT( 0xa5a5a5a5a5a59e0f, 51, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a59e0f, 51, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59e0f, 7, 51, 4, 0xa5bda5a5a5a59e0f)
	EXT( 0xa5a5a5a5a5a59e0e, 51, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59e0e, 51, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a59e0e, 15, 51, 5, 0xa57da5a5a5a59e0e)
	EXT( 0xa5a5a5a5a5a59e0d, 51, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59e0d, 51, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59e0d, 31, 51, 6, 0xa4fda5a5a5a59e0d)
	EXT( 0xa5a5a5a5a5a59e0c, 51, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a59e0c, 51, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59e0c, 63, 51, 7, 0xa5fda5a5a5a59e0c)
	EXT( 0xa5a5a5a5a5a59e0b, 51, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a59e0b, 51, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59e0b, 127, 51, 8, 0xa3fda5a5a5a59e0b)
	EXT( 0xa5a5a5a5a5a59e0a, 51, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59e0a, 51, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59e0a, 255, 51, 9, 0xa7fda5a5a5a59e0a)
	EXT( 0xa5a5a5a5a5a59e09, 51, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59e09, 51, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59e09, 511, 51, 10, 0xaffda5a5a5a59e09)
	EXT( 0xa5a5a5a5a5a59e08, 51, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a59e08, 51, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59e08, 1023, 51, 11, 0x9ffda5a5a5a59e08)
	EXT( 0xa5a5a5a5a5a59e07, 51, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a59e07, 51, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59e07, 2047, 51, 12, 0xbffda5a5a5a59e07)
	EXT( 0xa5a5a5a5a5a59e06, 52, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e06, 52, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e06, 0, 52, 1, 0xa5a5a5a5a5a59e06)
	EXT( 0xa5a5a5a5a5a59e05, 52, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e05, 52, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e05, 1, 52, 2, 0xa595a5a5a5a59e05)
	EXT( 0xa5a5a5a5a5a59e04, 52, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59e04, 52, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e04, 3, 52, 3, 0xa5b5a5a5a5a59e04)
	EXT( 0xa5a5a5a5a5a59e03, 52, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59e03, 52, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a59e03, 7, 52, 4, 0xa575a5a5a5a59e03)
	EXT( 0xa5a5a5a5a5a59e02, 52, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59e02, 52, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59e02, 15, 52, 5, 0xa4f5a5a5a5a59e02)
	EXT( 0xa5a5a5a5a5a59e01, 52, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a59e01, 52, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59e01, 31, 52, 6, 0xa5f5a5a5a5a59e01)
	EXT( 0xa5a5a5a5a5a59e00, 52, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a59e00, 52, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59e00, 63, 52, 7, 0xa3f5a5a5a5a59e00)
	EXT( 0xa5a5a5a5a5a59dff, 52, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59dff, 52, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59dff, 127, 52, 8, 0xa7f5a5a5a5a59dff)
	EXT( 0xa5a5a5a5a5a59dfe, 52, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59dfe, 52, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59dfe, 255, 52, 9, 0xaff5a5a5a5a59dfe)
	EXT( 0xa5a5a5a5a5a59dfd, 52, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a59dfd, 52, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59dfd, 511, 52, 10, 0x9ff5a5a5a5a59dfd)
	EXT( 0xa5a5a5a5a5a59dfc, 52, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a59dfc, 52, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59dfc, 1023, 52, 11, 0xbff5a5a5a5a59dfc)
	EXT( 0xa5a5a5a5a5a59dfb, 53, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dfb, 53, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dfb, 0, 53, 1, 0xa585a5a5a5a59dfb)
	EXT( 0xa5a5a5a5a5a59dfa, 53, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59dfa, 53, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dfa, 1, 53, 2, 0xa5a5a5a5a5a59dfa)
	EXT( 0xa5a5a5a5a5a59df9, 53, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59df9, 53, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59df9, 3, 53, 3, 0xa565a5a5a5a59df9)
	EXT( 0xa5a5a5a5a5a59df8, 53, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59df8, 53, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59df8, 7, 53, 4, 0xa4e5a5a5a5a59df8)
	EXT( 0xa5a5a5a5a5a59df7, 53, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a59df7, 53, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59df7, 15, 53, 5, 0xa5e5a5a5a5a59df7)
	EXT( 0xa5a5a5a5a5a59df6, 53, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a59df6, 53, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59df6, 31, 53, 6, 0xa3e5a5a5a5a59df6)
	EXT( 0xa5a5a5a5a5a59df5, 53, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59df5, 53, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59df5, 63, 53, 7, 0xa7e5a5a5a5a59df5)
	EXT( 0xa5a5a5a5a5a59df4, 53, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59df4, 53, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59df4, 127, 53, 8, 0xafe5a5a5a5a59df4)
	EXT( 0xa5a5a5a5a5a59df3, 53, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a59df3, 53, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59df3, 255, 53, 9, 0x9fe5a5a5a5a59df3)
	EXT( 0xa5a5a5a5a5a59df2, 53, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a59df2, 53, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59df2, 511, 53, 10, 0xbfe5a5a5a5a59df2)
	EXT( 0xa5a5a5a5a5a59df1, 54, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59df1, 54, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59df1, 0, 54, 1, 0xa5a5a5a5a5a59df1)
	EXT( 0xa5a5a5a5a5a59df0, 54, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59df0, 54, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59df0, 1, 54, 2, 0xa565a5a5a5a59df0)
	EXT( 0xa5a5a5a5a5a59def, 54, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59def, 54, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59def, 3, 54, 3, 0xa4e5a5a5a5a59def)
	EXT( 0xa5a5a5a5a5a59dee, 54, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a59dee, 54, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59dee, 7, 54, 4, 0xa5e5a5a5a5a59dee)
	EXT( 0xa5a5a5a5a5a59ded, 54, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a59ded, 54, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59ded, 15, 54, 5, 0xa3e5a5a5a5a59ded)
	EXT( 0xa5a5a5a5a5a59dec, 54, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59dec, 54, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59dec, 31, 54, 6, 0xa7e5a5a5a5a59dec)
	EXT( 0xa5a5a5a5a5a59deb, 54, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59deb, 54, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59deb, 63, 54, 7, 0xafe5a5a5a5a59deb)
	EXT( 0xa5a5a5a5a5a59dea, 54, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a59dea, 54, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59dea, 127, 54, 8, 0x9fe5a5a5a5a59dea)
	EXT( 0xa5a5a5a5a5a59de9, 54, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a59de9, 54, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59de9, 255, 54, 9, 0xbfe5a5a5a5a59de9)
	EXT( 0xa5a5a5a5a5a59de8, 55, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de8, 55, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59de8, 0, 55, 1, 0xa525a5a5a5a59de8)
	EXT( 0xa5a5a5a5a5a59de7, 55, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de7, 55, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59de7, 1, 55, 2, 0xa4a5a5a5a5a59de7)
	EXT( 0xa5a5a5a5a5a59de6, 55, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59de6, 55, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59de6, 3, 55, 3, 0xa5a5a5a5a5a59de6)
	EXT( 0xa5a5a5a5a5a59de5, 55, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59de5, 55, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59de5, 7, 55, 4, 0xa3a5a5a5a5a59de5)
	EXT( 0xa5a5a5a5a5a59de4, 55, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59de4, 55, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59de4, 15, 55, 5, 0xa7a5a5a5a5a59de4)
	EXT( 0xa5a5a5a5a5a59de3, 55, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59de3, 55, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59de3, 31, 55, 6, 0xafa5a5a5a5a59de3)
	EXT( 0xa5a5a5a5a5a59de2, 55, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a59de2, 55, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59de2, 63, 55, 7, 0x9fa5a5a5a5a59de2)
	EXT( 0xa5a5a5a5a5a59de1, 55, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a59de1, 55, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59de1, 127, 55, 8, 0xbfa5a5a5a5a59de1)
	EXT( 0xa5a5a5a5a5a59de0, 56, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de0, 56, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59de0, 0, 56, 1, 0xa4a5a5a5a5a59de0)
	EXT( 0xa5a5a5a5a5a59ddf, 56, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59ddf, 56, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ddf, 1, 56, 2, 0xa5a5a5a5a5a59ddf)
	EXT( 0xa5a5a5a5a5a59dde, 56, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59dde, 56, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59dde, 3, 56, 3, 0xa3a5a5a5a5a59dde)
	EXT( 0xa5a5a5a5a5a59ddd, 56, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59ddd, 56, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59ddd, 7, 56, 4, 0xa7a5a5a5a5a59ddd)
	EXT( 0xa5a5a5a5a5a59ddc, 56, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59ddc, 56, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59ddc, 15, 56, 5, 0xafa5a5a5a5a59ddc)
	EXT( 0xa5a5a5a5a5a59ddb, 56, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a59ddb, 56, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59ddb, 31, 56, 6, 0x9fa5a5a5a5a59ddb)
	EXT( 0xa5a5a5a5a5a59dda, 56, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a59dda, 56, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59dda, 63, 56, 7, 0xbfa5a5a5a5a59dda)
	EXT( 0xa5a5a5a5a5a59dd9, 57, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dd9, 57, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dd9, 0, 57, 1, 0xa5a5a5a5a5a59dd9)
	EXT( 0xa5a5a5a5a5a59dd8, 57, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59dd8, 57, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dd8, 1, 57, 2, 0xa3a5a5a5a5a59dd8)
	EXT( 0xa5a5a5a5a5a59dd7, 57, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59dd7, 57, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dd7, 3, 57, 3, 0xa7a5a5a5a5a59dd7)
	EXT( 0xa5a5a5a5a5a59dd6, 57, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59dd6, 57, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dd6, 7, 57, 4, 0xafa5a5a5a5a59dd6)
	EXT( 0xa5a5a5a5a5a59dd5, 57, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a59dd5, 57, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59dd5, 15, 57, 5, 0x9fa5a5a5a5a59dd5)
	EXT( 0xa5a5a5a5a5a59dd4, 57, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a59dd4, 57, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59dd4, 31, 57, 6, 0xbfa5a5a5a5a59dd4)
	EXT( 0xa5a5a5a5a5a59dd3, 58, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dd3, 58, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dd3, 0, 58, 1, 0xa1a5a5a5a5a59dd3)
	EXT( 0xa5a5a5a5a5a59dd2, 58, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59dd2, 58, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dd2, 1, 58, 2, 0xa5a5a5a5a5a59dd2)
	EXT( 0xa5a5a5a5a5a59dd1, 58, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59dd1, 58, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dd1, 3, 58, 3, 0xada5a5a5a5a59dd1)
	EXT( 0xa5a5a5a5a5a59dd0, 58, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59dd0, 58, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59dd0, 7, 58, 4, 0x9da5a5a5a5a59dd0)
	EXT( 0xa5a5a5a5a5a59dcf, 58, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a59dcf, 58, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59dcf, 15, 58, 5, 0xbda5a5a5a5a59dcf)
	EXT( 0xa5a5a5a5a5a59dce, 59, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dce, 59, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dce, 0, 59, 1, 0xa5a5a5a5a5a59dce)
	EXT( 0xa5a5a5a5a5a59dcd, 59, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dcd, 59, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dcd, 1, 59, 2, 0xada5a5a5a5a59dcd)
	EXT( 0xa5a5a5a5a5a59dcc, 59, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59dcc, 59, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59dcc, 3, 59, 3, 0x9da5a5a5a5a59dcc)
	EXT( 0xa5a5a5a5a5a59dcb, 59, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a59dcb, 59, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59dcb, 7, 59, 4, 0xbda5a5a5a5a59dcb)
	EXT( 0xa5a5a5a5a5a59dca, 60, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dca, 60, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dca, 0, 60, 1, 0xa5a5a5a5a5a59dca)
	EXT( 0xa5a5a5a5a5a59dc9, 60, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59dc9, 60, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dc9, 1, 60, 2, 0x95a5a5a5a5a59dc9)
	EXT( 0xa5a5a5a5a5a59dc8, 60, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59dc8, 60, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dc8, 3, 60, 3, 0xb5a5a5a5a5a59dc8)
	EXT( 0xa5a5a5a5a5a59dc7, 61, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dc7, 61, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dc7, 0, 61, 1, 0x85a5a5a5a5a59dc7)
	EXT( 0xa5a5a5a5a5a59dc6, 61, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59dc6, 61, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dc6, 1, 61, 2, 0xa5a5a5a5a5a59dc6)
	EXT( 0xa5a5a5a5a5a59dc5, 62, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dc5, 62, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dc5, 0, 62, 1, 0xa5a5a5a5a5a59dc5)

#    else
	EXT( 0xa5a5a5a5a5a5a5a4, 0, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a5a4, 0, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a5a4, 0, 0, 1, 0x25a5a5a5a5a5a5a4)
	EXT( 0xa5a5a5a5a5a5a5a3, 0, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a5a3, 0, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a5a3, 1, 0, 2, 0x65a5a5a5a5a5a5a3)
	EXT( 0xa5a5a5a5a5a5a5a2, 0, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a5a2, 0, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a5a2, 3, 0, 3, 0x65a5a5a5a5a5a5a2)
	EXT( 0xa5a5a5a5a5a5a5a1, 0, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a5a1, 0, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a5a1, 7, 0, 4, 0x75a5a5a5a5a5a5a1)
	EXT( 0xa5a5a5a5a5a5a5a0, 0, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a5a0, 0, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a5a5a0, 15, 0, 5, 0x7da5a5a5a5a5a5a0)
	EXT( 0xa5a5a5a5a5a5a59f, 0, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a59f, 0, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a5a59f, 31, 0, 6, 0x7da5a5a5a5a5a59f)
	EXT( 0xa5a5a5a5a5a5a59e, 0, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a59e, 0, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a5a59e, 63, 0, 7, 0x7fa5a5a5a5a5a59e)
	EXT( 0xa5a5a5a5a5a5a59d, 0, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a59d, 0, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a5a59d, 127, 0, 8, 0x7fa5a5a5a5a5a59d)
	EXT( 0xa5a5a5a5a5a5a59c, 0, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a59c, 0, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a5a59c, 255, 0, 9, 0x7fa5a5a5a5a5a59c)
	EXT( 0xa5a5a5a5a5a5a59b, 0, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a59b, 0, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a5a59b, 511, 0, 10, 0x7fe5a5a5a5a5a59b)
	EXT( 0xa5a5a5a5a5a5a59a, 0, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a59a, 0, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a5a59a, 1023, 0, 11, 0x7fe5a5a5a5a5a59a)
	EXT( 0xa5a5a5a5a5a5a599, 0, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a599, 0, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a5a599, 2047, 0, 12, 0x7ff5a5a5a5a5a599)
	EXT( 0xa5a5a5a5a5a5a598, 0, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a598, 0, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a5a598, 4095, 0, 13, 0x7ffda5a5a5a5a598)
	EXT( 0xa5a5a5a5a5a5a597, 0, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a597, 0, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a5a597, 8191, 0, 14, 0x7ffda5a5a5a5a597)
	EXT( 0xa5a5a5a5a5a5a596, 0, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a596, 0, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a5a596, 16383, 0, 15, 0x7fffa5a5a5a5a596)
	EXT( 0xa5a5a5a5a5a5a595, 0, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a595, 0, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a5a595, 32767, 0, 16, 0x7fffa5a5a5a5a595)
	EXT( 0xa5a5a5a5a5a5a594, 0, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a594, 0, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a5a594, 65535, 0, 17, 0x7fffa5a5a5a5a594)
	EXT( 0xa5a5a5a5a5a5a593, 0, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a593, 0, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a5a593, 131071, 0, 18, 0x7fffe5a5a5a5a593)
	EXT( 0xa5a5a5a5a5a5a592, 0, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a592, 0, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a5a592, 262143, 0, 19, 0x7fffe5a5a5a5a592)
	EXT( 0xa5a5a5a5a5a5a591, 0, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a591, 0, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a5a591, 524287, 0, 20, 0x7ffff5a5a5a5a591)
	EXT( 0xa5a5a5a5a5a5a590, 0, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a590, 0, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a5a590, 1048575, 0, 21, 0x7ffffda5a5a5a590)
	EXT( 0xa5a5a5a5a5a5a58f, 0, 22, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a58f, 0, 22, 0x0000000000296969)
	DEP( 0xa5a5a5a5a5a5a58f, 2097151, 0, 22, 0x7ffffda5a5a5a58f)
	EXT( 0xa5a5a5a5a5a5a58e, 0, 23, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a58e, 0, 23, 0x000000000052d2d2)
	DEP( 0xa5a5a5a5a5a5a58e, 4194303, 0, 23, 0x7fffffa5a5a5a58e)
	EXT( 0xa5a5a5a5a5a5a58d, 0, 24, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a58d, 0, 24, 0x0000000000a5a5a5)
	DEP( 0xa5a5a5a5a5a5a58d, 8388607, 0, 24, 0x7fffffa5a5a5a58d)
	EXT( 0xa5a5a5a5a5a5a58c, 0, 25, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a58c, 0, 25, 0x00000000014b4b4b)
	DEP( 0xa5a5a5a5a5a5a58c, 16777215, 0, 25, 0x7fffffa5a5a5a58c)
	EXT( 0xa5a5a5a5a5a5a58b, 0, 26, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a58b, 0, 26, 0x0000000002969696)
	DEP( 0xa5a5a5a5a5a5a58b, 33554431, 0, 26, 0x7fffffe5a5a5a58b)
	EXT( 0xa5a5a5a5a5a5a58a, 0, 27, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a58a, 0, 27, 0x00000000052d2d2d)
	DEP( 0xa5a5a5a5a5a5a58a, 67108863, 0, 27, 0x7fffffe5a5a5a58a)
	EXT( 0xa5a5a5a5a5a5a589, 0, 28, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a589, 0, 28, 0x000000000a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a589, 134217727, 0, 28, 0x7ffffff5a5a5a589)
	EXT( 0xa5a5a5a5a5a5a588, 0, 29, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a588, 0, 29, 0x0000000014b4b4b4)
	DEP( 0xa5a5a5a5a5a5a588, 268435455, 0, 29, 0x7ffffffda5a5a588)
	EXT( 0xa5a5a5a5a5a5a587, 0, 30, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a587, 0, 30, 0x0000000029696969)
	DEP( 0xa5a5a5a5a5a5a587, 536870911, 0, 30, 0x7ffffffda5a5a587)
	EXT( 0xa5a5a5a5a5a5a586, 0, 31, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a586, 0, 31, 0x0000000052d2d2d2)
	DEP( 0xa5a5a5a5a5a5a586, 1073741823, 0, 31, 0x7fffffffa5a5a586)
	EXT( 0xa5a5a5a5a5a5a585, 0, 32, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a585, 0, 32, 0x00000000a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a585, 2147483647, 0, 32, 0x7fffffffa5a5a585)
	EXT( 0xa5a5a5a5a5a5a584, 0, 33, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a584, 0, 33, 0x000000014b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a584, 4294967295, 0, 33, 0x7fffffffa5a5a584)
	EXT( 0xa5a5a5a5a5a5a583, 0, 34, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a583, 0, 34, 0x0000000296969696)
	DEP( 0xa5a5a5a5a5a5a583, 8589934591, 0, 34, 0x7fffffffe5a5a583)
	EXT( 0xa5a5a5a5a5a5a582, 0, 35, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a582, 0, 35, 0x000000052d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a582, 17179869183, 0, 35, 0x7fffffffe5a5a582)
	EXT( 0xa5a5a5a5a5a5a581, 0, 36, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a581, 0, 36, 0x0000000a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a581, 34359738367, 0, 36, 0x7ffffffff5a5a581)
	EXT( 0xa5a5a5a5a5a5a580, 0, 37, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a580, 0, 37, 0x00000014b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a580, 68719476735, 0, 37, 0x7ffffffffda5a580)
	EXT( 0xa5a5a5a5a5a5a57f, 0, 38, 0xffffffe969696969)
	EXTU(0xa5a5a5a5a5a5a57f, 0, 38, 0x0000002969696969)
	DEP( 0xa5a5a5a5a5a5a57f, 137438953471, 0, 38, 0x7ffffffffda5a57f)
	EXT( 0xa5a5a5a5a5a5a57e, 0, 39, 0xffffffd2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a57e, 0, 39, 0x00000052d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a57e, 274877906943, 0, 39, 0x7fffffffffa5a57e)
	EXT( 0xa5a5a5a5a5a5a57d, 0, 40, 0xffffffa5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a57d, 0, 40, 0x000000a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a57d, 549755813887, 0, 40, 0x7fffffffffa5a57d)
	EXT( 0xa5a5a5a5a5a5a57c, 0, 41, 0xffffff4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a57c, 0, 41, 0x0000014b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a57c, 1099511627775, 0, 41, 0x7fffffffffa5a57c)
	EXT( 0xa5a5a5a5a5a5a57b, 0, 42, 0xfffffe9696969696)
	EXTU(0xa5a5a5a5a5a5a57b, 0, 42, 0x0000029696969696)
	DEP( 0xa5a5a5a5a5a5a57b, 2199023255551, 0, 42, 0x7fffffffffe5a57b)
	EXT( 0xa5a5a5a5a5a5a57a, 0, 43, 0xfffffd2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a57a, 0, 43, 0x0000052d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a57a, 4398046511103, 0, 43, 0x7fffffffffe5a57a)
	EXT( 0xa5a5a5a5a5a5a579, 0, 44, 0xfffffa5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a579, 0, 44, 0x00000a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a579, 8796093022207, 0, 44, 0x7ffffffffff5a579)
	EXT( 0xa5a5a5a5a5a5a578, 0, 45, 0xfffff4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a578, 0, 45, 0x000014b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a578, 17592186044415, 0, 45, 0x7ffffffffffda578)
	EXT( 0xa5a5a5a5a5a5a577, 0, 46, 0xffffe96969696969)
	EXTU(0xa5a5a5a5a5a5a577, 0, 46, 0x0000296969696969)
	DEP( 0xa5a5a5a5a5a5a577, 35184372088831, 0, 46, 0x7ffffffffffda577)
	EXT( 0xa5a5a5a5a5a5a576, 0, 47, 0xffffd2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a576, 0, 47, 0x000052d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a576, 70368744177663, 0, 47, 0x7fffffffffffa576)
	EXT( 0xa5a5a5a5a5a5a575, 0, 48, 0xffffa5a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a575, 0, 48, 0x0000a5a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a575, 140737488355327, 0, 48, 0x7fffffffffffa575)
	EXT( 0xa5a5a5a5a5a5a574, 0, 49, 0xffff4b4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a574, 0, 49, 0x00014b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a574, 281474976710655, 0, 49, 0x7fffffffffffa574)
	EXT( 0xa5a5a5a5a5a5a573, 0, 50, 0xfffe969696969696)
	EXTU(0xa5a5a5a5a5a5a573, 0, 50, 0x0002969696969696)
	DEP( 0xa5a5a5a5a5a5a573, 562949953421311, 0, 50, 0x7fffffffffffe573)
	EXT( 0xa5a5a5a5a5a5a572, 0, 51, 0xfffd2d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a572, 0, 51, 0x00052d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a572, 1125899906842623, 0, 51, 0x7fffffffffffe572)
	EXT( 0xa5a5a5a5a5a5a571, 0, 52, 0xfffa5a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a571, 0, 52, 0x000a5a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a571, 2251799813685247, 0, 52, 0x7ffffffffffff571)
	EXT( 0xa5a5a5a5a5a5a570, 0, 53, 0xfff4b4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a570, 0, 53, 0x0014b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a570, 4503599627370495, 0, 53, 0x7ffffffffffffd70)
	EXT( 0xa5a5a5a5a5a5a56f, 0, 54, 0xffe9696969696969)
	EXTU(0xa5a5a5a5a5a5a56f, 0, 54, 0x0029696969696969)
	DEP( 0xa5a5a5a5a5a5a56f, 9007199254740991, 0, 54, 0x7ffffffffffffd6f)
	EXT( 0xa5a5a5a5a5a5a56e, 0, 55, 0xffd2d2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a56e, 0, 55, 0x0052d2d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a56e, 18014398509481983, 0, 55, 0x7fffffffffffff6e)
	EXT( 0xa5a5a5a5a5a5a56d, 0, 56, 0xffa5a5a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a56d, 0, 56, 0x00a5a5a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a56d, 36028797018963967, 0, 56, 0x7fffffffffffff6d)
	EXT( 0xa5a5a5a5a5a5a56c, 0, 57, 0xff4b4b4b4b4b4b4a)
	EXTU(0xa5a5a5a5a5a5a56c, 0, 57, 0x014b4b4b4b4b4b4a)
	DEP( 0xa5a5a5a5a5a5a56c, 72057594037927935, 0, 57, 0x7fffffffffffffec)
	EXT( 0xa5a5a5a5a5a5a56b, 0, 58, 0xfe96969696969695)
	EXTU(0xa5a5a5a5a5a5a56b, 0, 58, 0x0296969696969695)
	DEP( 0xa5a5a5a5a5a5a56b, 144115188075855871, 0, 58, 0x7fffffffffffffeb)
	EXT( 0xa5a5a5a5a5a5a56a, 0, 59, 0xfd2d2d2d2d2d2d2b)
	EXTU(0xa5a5a5a5a5a5a56a, 0, 59, 0x052d2d2d2d2d2d2b)
	DEP( 0xa5a5a5a5a5a5a56a, 288230376151711743, 0, 59, 0x7fffffffffffffea)
	EXT( 0xa5a5a5a5a5a5a569, 0, 60, 0xfa5a5a5a5a5a5a56)
	EXTU(0xa5a5a5a5a5a5a569, 0, 60, 0x0a5a5a5a5a5a5a56)
	DEP( 0xa5a5a5a5a5a5a569, 576460752303423487, 0, 60, 0x7ffffffffffffff9)
	EXT( 0xa5a5a5a5a5a5a568, 0, 61, 0xf4b4b4b4b4b4b4ad)
	EXTU(0xa5a5a5a5a5a5a568, 0, 61, 0x14b4b4b4b4b4b4ad)
	DEP( 0xa5a5a5a5a5a5a568, 1152921504606846975, 0, 61, 0x7ffffffffffffff8)
	EXT( 0xa5a5a5a5a5a5a567, 0, 62, 0xe969696969696959)
	EXTU(0xa5a5a5a5a5a5a567, 0, 62, 0x2969696969696959)
	DEP( 0xa5a5a5a5a5a5a567, 2305843009213693951, 0, 62, 0x7fffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a566, 0, 63, 0xd2d2d2d2d2d2d2b3)
	EXTU(0xa5a5a5a5a5a5a566, 0, 63, 0x52d2d2d2d2d2d2b3)
	DEP( 0xa5a5a5a5a5a5a566, 4611686018427387903, 0, 63, 0x7ffffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a565, 1, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a565, 1, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a565, 0, 1, 1, 0xa5a5a5a5a5a5a565)
	EXT( 0xa5a5a5a5a5a5a564, 1, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a564, 1, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a564, 1, 1, 2, 0xa5a5a5a5a5a5a564)
	EXT( 0xa5a5a5a5a5a5a563, 1, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a563, 1, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a563, 3, 1, 3, 0xb5a5a5a5a5a5a563)
	EXT( 0xa5a5a5a5a5a5a562, 1, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a5a562, 1, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a562, 7, 1, 4, 0xbda5a5a5a5a5a562)
	EXT( 0xa5a5a5a5a5a5a561, 1, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a5a561, 1, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a561, 15, 1, 5, 0xbda5a5a5a5a5a561)
	EXT( 0xa5a5a5a5a5a5a560, 1, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a5a560, 1, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a560, 31, 1, 6, 0xbfa5a5a5a5a5a560)
	EXT( 0xa5a5a5a5a5a5a55f, 1, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a5a55f, 1, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a55f, 63, 1, 7, 0xbfa5a5a5a5a5a55f)
	EXT( 0xa5a5a5a5a5a5a55e, 1, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a5a55e, 1, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a55e, 127, 1, 8, 0xbfa5a5a5a5a5a55e)
	EXT( 0xa5a5a5a5a5a5a55d, 1, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a5a55d, 1, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a55d, 255, 1, 9, 0xbfe5a5a5a5a5a55d)
	EXT( 0xa5a5a5a5a5a5a55c, 1, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a5a55c, 1, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a55c, 511, 1, 10, 0xbfe5a5a5a5a5a55c)
	EXT( 0xa5a5a5a5a5a5a55b, 1, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a5a55b, 1, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a55b, 1023, 1, 11, 0xbff5a5a5a5a5a55b)
	EXT( 0xa5a5a5a5a5a5a55a, 1, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a5a55a, 1, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a55a, 2047, 1, 12, 0xbffda5a5a5a5a55a)
	EXT( 0xa5a5a5a5a5a5a559, 1, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a5a559, 1, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a559, 4095, 1, 13, 0xbffda5a5a5a5a559)
	EXT( 0xa5a5a5a5a5a5a558, 1, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a5a558, 1, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a558, 8191, 1, 14, 0xbfffa5a5a5a5a558)
	EXT( 0xa5a5a5a5a5a5a557, 1, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a5a557, 1, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a557, 16383, 1, 15, 0xbfffa5a5a5a5a557)
	EXT( 0xa5a5a5a5a5a5a556, 1, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a5a556, 1, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a556, 32767, 1, 16, 0xbfffa5a5a5a5a556)
	EXT( 0xa5a5a5a5a5a5a555, 1, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a5a555, 1, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a555, 65535, 1, 17, 0xbfffe5a5a5a5a555)
	EXT( 0xa5a5a5a5a5a5a554, 1, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a5a554, 1, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a554, 131071, 1, 18, 0xbfffe5a5a5a5a554)
	EXT( 0xa5a5a5a5a5a5a553, 1, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a5a553, 1, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a553, 262143, 1, 19, 0xbffff5a5a5a5a553)
	EXT( 0xa5a5a5a5a5a5a552, 1, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a5a552, 1, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a552, 524287, 1, 20, 0xbffffda5a5a5a552)
	EXT( 0xa5a5a5a5a5a5a551, 1, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a5a551, 1, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a551, 1048575, 1, 21, 0xbffffda5a5a5a551)
	EXT( 0xa5a5a5a5a5a5a550, 1, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a5a550, 1, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a550, 2097151, 1, 22, 0xbfffffa5a5a5a550)
	EXT( 0xa5a5a5a5a5a5a54f, 1, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a5a54f, 1, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a54f, 4194303, 1, 23, 0xbfffffa5a5a5a54f)
	EXT( 0xa5a5a5a5a5a5a54e, 1, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a5a54e, 1, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a54e, 8388607, 1, 24, 0xbfffffa5a5a5a54e)
	EXT( 0xa5a5a5a5a5a5a54d, 1, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a5a54d, 1, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a54d, 16777215, 1, 25, 0xbfffffe5a5a5a54d)
	EXT( 0xa5a5a5a5a5a5a54c, 1, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a5a54c, 1, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a54c, 33554431, 1, 26, 0xbfffffe5a5a5a54c)
	EXT( 0xa5a5a5a5a5a5a54b, 1, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a5a54b, 1, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a54b, 67108863, 1, 27, 0xbffffff5a5a5a54b)
	EXT( 0xa5a5a5a5a5a5a54a, 1, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a5a54a, 1, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a54a, 134217727, 1, 28, 0xbffffffda5a5a54a)
	EXT( 0xa5a5a5a5a5a5a549, 1, 29, 0x0000000009696969)
	EXTU(0xa5a5a5a5a5a5a549, 1, 29, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a549, 268435455, 1, 29, 0xbffffffda5a5a549)
	EXT( 0xa5a5a5a5a5a5a548, 1, 30, 0x0000000012d2d2d2)
	EXTU(0xa5a5a5a5a5a5a548, 1, 30, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a548, 536870911, 1, 30, 0xbfffffffa5a5a548)
	EXT( 0xa5a5a5a5a5a5a547, 1, 31, 0x0000000025a5a5a5)
	EXTU(0xa5a5a5a5a5a5a547, 1, 31, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a547, 1073741823, 1, 31, 0xbfffffffa5a5a547)
	EXT( 0xa5a5a5a5a5a5a546, 1, 32, 0x000000004b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a546, 1, 32, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a546, 2147483647, 1, 32, 0xbfffffffa5a5a546)
	EXT( 0xa5a5a5a5a5a5a545, 1, 33, 0x0000000096969696)
	EXTU(0xa5a5a5a5a5a5a545, 1, 33, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a545, 4294967295, 1, 33, 0xbfffffffe5a5a545)
	EXT( 0xa5a5a5a5a5a5a544, 1, 34, 0x000000012d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a544, 1, 34, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a544, 8589934591, 1, 34, 0xbfffffffe5a5a544)
	EXT( 0xa5a5a5a5a5a5a543, 1, 35, 0x000000025a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a543, 1, 35, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a543, 17179869183, 1, 35, 0xbffffffff5a5a543)
	EXT( 0xa5a5a5a5a5a5a542, 1, 36, 0x00000004b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a542, 1, 36, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a542, 34359738367, 1, 36, 0xbffffffffda5a542)
	EXT( 0xa5a5a5a5a5a5a541, 1, 37, 0x0000000969696969)
	EXTU(0xa5a5a5a5a5a5a541, 1, 37, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a541, 68719476735, 1, 37, 0xbffffffffda5a541)
	EXT( 0xa5a5a5a5a5a5a540, 1, 38, 0x00000012d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a540, 1, 38, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a540, 137438953471, 1, 38, 0xbfffffffffa5a540)
	EXT( 0xa5a5a5a5a5a5a53f, 1, 39, 0x00000025a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a53f, 1, 39, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a53f, 274877906943, 1, 39, 0xbfffffffffa5a53f)
	EXT( 0xa5a5a5a5a5a5a53e, 1, 40, 0x0000004b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a53e, 1, 40, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a53e, 549755813887, 1, 40, 0xbfffffffffa5a53e)
	EXT( 0xa5a5a5a5a5a5a53d, 1, 41, 0x0000009696969696)
	EXTU(0xa5a5a5a5a5a5a53d, 1, 41, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a53d, 1099511627775, 1, 41, 0xbfffffffffe5a53d)
	EXT( 0xa5a5a5a5a5a5a53c, 1, 42, 0x0000012d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a53c, 1, 42, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a53c, 2199023255551, 1, 42, 0xbfffffffffe5a53c)
	EXT( 0xa5a5a5a5a5a5a53b, 1, 43, 0x0000025a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a53b, 1, 43, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a53b, 4398046511103, 1, 43, 0xbffffffffff5a53b)
	EXT( 0xa5a5a5a5a5a5a53a, 1, 44, 0x000004b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a53a, 1, 44, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a53a, 8796093022207, 1, 44, 0xbffffffffffda53a)
	EXT( 0xa5a5a5a5a5a5a539, 1, 45, 0x0000096969696969)
	EXTU(0xa5a5a5a5a5a5a539, 1, 45, 0x0000096969696969)
	DEP( 0xa5a5a5a5a5a5a539, 17592186044415, 1, 45, 0xbffffffffffda539)
	EXT( 0xa5a5a5a5a5a5a538, 1, 46, 0x000012d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a538, 1, 46, 0x000012d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a538, 35184372088831, 1, 46, 0xbfffffffffffa538)
	EXT( 0xa5a5a5a5a5a5a537, 1, 47, 0x000025a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a537, 1, 47, 0x000025a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a537, 70368744177663, 1, 47, 0xbfffffffffffa537)
	EXT( 0xa5a5a5a5a5a5a536, 1, 48, 0x00004b4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a536, 1, 48, 0x00004b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a536, 140737488355327, 1, 48, 0xbfffffffffffa536)
	EXT( 0xa5a5a5a5a5a5a535, 1, 49, 0x0000969696969696)
	EXTU(0xa5a5a5a5a5a5a535, 1, 49, 0x0000969696969696)
	DEP( 0xa5a5a5a5a5a5a535, 281474976710655, 1, 49, 0xbfffffffffffe535)
	EXT( 0xa5a5a5a5a5a5a534, 1, 50, 0x00012d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a534, 1, 50, 0x00012d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a534, 562949953421311, 1, 50, 0xbfffffffffffe534)
	EXT( 0xa5a5a5a5a5a5a533, 1, 51, 0x00025a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a533, 1, 51, 0x00025a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a533, 1125899906842623, 1, 51, 0xbffffffffffff533)
	EXT( 0xa5a5a5a5a5a5a532, 1, 52, 0x0004b4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a532, 1, 52, 0x0004b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a532, 2251799813685247, 1, 52, 0xbffffffffffffd32)
	EXT( 0xa5a5a5a5a5a5a531, 1, 53, 0x0009696969696969)
	EXTU(0xa5a5a5a5a5a5a531, 1, 53, 0x0009696969696969)
	DEP( 0xa5a5a5a5a5a5a531, 4503599627370495, 1, 53, 0xbffffffffffffd31)
	EXT( 0xa5a5a5a5a5a5a530, 1, 54, 0x0012d2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a530, 1, 54, 0x0012d2d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a530, 9007199254740991, 1, 54, 0xbfffffffffffff30)
	EXT( 0xa5a5a5a5a5a5a52f, 1, 55, 0x0025a5a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a52f, 1, 55, 0x0025a5a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a52f, 18014398509481983, 1, 55, 0xbfffffffffffff2f)
	EXT( 0xa5a5a5a5a5a5a52e, 1, 56, 0x004b4b4b4b4b4b4a)
	EXTU(0xa5a5a5a5a5a5a52e, 1, 56, 0x004b4b4b4b4b4b4a)
	DEP( 0xa5a5a5a5a5a5a52e, 36028797018963967, 1, 56, 0xbfffffffffffffae)
	EXT( 0xa5a5a5a5a5a5a52d, 1, 57, 0x0096969696969694)
	EXTU(0xa5a5a5a5a5a5a52d, 1, 57, 0x0096969696969694)
	DEP( 0xa5a5a5a5a5a5a52d, 72057594037927935, 1, 57, 0xbfffffffffffffed)
	EXT( 0xa5a5a5a5a5a5a52c, 1, 58, 0x012d2d2d2d2d2d29)
	EXTU(0xa5a5a5a5a5a5a52c, 1, 58, 0x012d2d2d2d2d2d29)
	DEP( 0xa5a5a5a5a5a5a52c, 144115188075855871, 1, 58, 0xbfffffffffffffec)
	EXT( 0xa5a5a5a5a5a5a52b, 1, 59, 0x025a5a5a5a5a5a52)
	EXTU(0xa5a5a5a5a5a5a52b, 1, 59, 0x025a5a5a5a5a5a52)
	DEP( 0xa5a5a5a5a5a5a52b, 288230376151711743, 1, 59, 0xbffffffffffffffb)
	EXT( 0xa5a5a5a5a5a5a52a, 1, 60, 0x04b4b4b4b4b4b4a5)
	EXTU(0xa5a5a5a5a5a5a52a, 1, 60, 0x04b4b4b4b4b4b4a5)
	DEP( 0xa5a5a5a5a5a5a52a, 576460752303423487, 1, 60, 0xbffffffffffffffa)
	EXT( 0xa5a5a5a5a5a5a529, 1, 61, 0x096969696969694a)
	EXTU(0xa5a5a5a5a5a5a529, 1, 61, 0x096969696969694a)
	DEP( 0xa5a5a5a5a5a5a529, 1152921504606846975, 1, 61, 0xbffffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a528, 1, 62, 0x12d2d2d2d2d2d294)
	EXTU(0xa5a5a5a5a5a5a528, 1, 62, 0x12d2d2d2d2d2d294)
	DEP( 0xa5a5a5a5a5a5a528, 2305843009213693951, 1, 62, 0xbffffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a527, 2, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a527, 2, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a527, 0, 2, 1, 0x85a5a5a5a5a5a527)
	EXT( 0xa5a5a5a5a5a5a526, 2, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a526, 2, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a526, 1, 2, 2, 0x95a5a5a5a5a5a526)
	EXT( 0xa5a5a5a5a5a5a525, 2, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a525, 2, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a525, 3, 2, 3, 0x9da5a5a5a5a5a525)
	EXT( 0xa5a5a5a5a5a5a524, 2, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a5a524, 2, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a524, 7, 2, 4, 0x9da5a5a5a5a5a524)
	EXT( 0xa5a5a5a5a5a5a523, 2, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a5a523, 2, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a523, 15, 2, 5, 0x9fa5a5a5a5a5a523)
	EXT( 0xa5a5a5a5a5a5a522, 2, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a5a522, 2, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a522, 31, 2, 6, 0x9fa5a5a5a5a5a522)
	EXT( 0xa5a5a5a5a5a5a521, 2, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a5a521, 2, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a521, 63, 2, 7, 0x9fa5a5a5a5a5a521)
	EXT( 0xa5a5a5a5a5a5a520, 2, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a5a520, 2, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a520, 127, 2, 8, 0x9fe5a5a5a5a5a520)
	EXT( 0xa5a5a5a5a5a5a51f, 2, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a5a51f, 2, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a51f, 255, 2, 9, 0x9fe5a5a5a5a5a51f)
	EXT( 0xa5a5a5a5a5a5a51e, 2, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a5a51e, 2, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a51e, 511, 2, 10, 0x9ff5a5a5a5a5a51e)
	EXT( 0xa5a5a5a5a5a5a51d, 2, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a5a51d, 2, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a51d, 1023, 2, 11, 0x9ffda5a5a5a5a51d)
	EXT( 0xa5a5a5a5a5a5a51c, 2, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a5a51c, 2, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a51c, 2047, 2, 12, 0x9ffda5a5a5a5a51c)
	EXT( 0xa5a5a5a5a5a5a51b, 2, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a5a51b, 2, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a51b, 4095, 2, 13, 0x9fffa5a5a5a5a51b)
	EXT( 0xa5a5a5a5a5a5a51a, 2, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a5a51a, 2, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a51a, 8191, 2, 14, 0x9fffa5a5a5a5a51a)
	EXT( 0xa5a5a5a5a5a5a519, 2, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a5a519, 2, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a519, 16383, 2, 15, 0x9fffa5a5a5a5a519)
	EXT( 0xa5a5a5a5a5a5a518, 2, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a5a518, 2, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a518, 32767, 2, 16, 0x9fffe5a5a5a5a518)
	EXT( 0xa5a5a5a5a5a5a517, 2, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a5a517, 2, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a517, 65535, 2, 17, 0x9fffe5a5a5a5a517)
	EXT( 0xa5a5a5a5a5a5a516, 2, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a5a516, 2, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a516, 131071, 2, 18, 0x9ffff5a5a5a5a516)
	EXT( 0xa5a5a5a5a5a5a515, 2, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a5a515, 2, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a515, 262143, 2, 19, 0x9ffffda5a5a5a515)
	EXT( 0xa5a5a5a5a5a5a514, 2, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a5a514, 2, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a514, 524287, 2, 20, 0x9ffffda5a5a5a514)
	EXT( 0xa5a5a5a5a5a5a513, 2, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a5a513, 2, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a513, 1048575, 2, 21, 0x9fffffa5a5a5a513)
	EXT( 0xa5a5a5a5a5a5a512, 2, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a5a512, 2, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a512, 2097151, 2, 22, 0x9fffffa5a5a5a512)
	EXT( 0xa5a5a5a5a5a5a511, 2, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a5a511, 2, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a511, 4194303, 2, 23, 0x9fffffa5a5a5a511)
	EXT( 0xa5a5a5a5a5a5a510, 2, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a5a510, 2, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a510, 8388607, 2, 24, 0x9fffffe5a5a5a510)
	EXT( 0xa5a5a5a5a5a5a50f, 2, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a5a50f, 2, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a50f, 16777215, 2, 25, 0x9fffffe5a5a5a50f)
	EXT( 0xa5a5a5a5a5a5a50e, 2, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a5a50e, 2, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a50e, 33554431, 2, 26, 0x9ffffff5a5a5a50e)
	EXT( 0xa5a5a5a5a5a5a50d, 2, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a5a50d, 2, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a50d, 67108863, 2, 27, 0x9ffffffda5a5a50d)
	EXT( 0xa5a5a5a5a5a5a50c, 2, 28, 0xfffffffff9696969)
	EXTU(0xa5a5a5a5a5a5a50c, 2, 28, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a50c, 134217727, 2, 28, 0x9ffffffda5a5a50c)
	EXT( 0xa5a5a5a5a5a5a50b, 2, 29, 0xfffffffff2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a50b, 2, 29, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a50b, 268435455, 2, 29, 0x9fffffffa5a5a50b)
	EXT( 0xa5a5a5a5a5a5a50a, 2, 30, 0xffffffffe5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a50a, 2, 30, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a50a, 536870911, 2, 30, 0x9fffffffa5a5a50a)
	EXT( 0xa5a5a5a5a5a5a509, 2, 31, 0xffffffffcb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a509, 2, 31, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a509, 1073741823, 2, 31, 0x9fffffffa5a5a509)
	EXT( 0xa5a5a5a5a5a5a508, 2, 32, 0xffffffff96969696)
	EXTU(0xa5a5a5a5a5a5a508, 2, 32, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a508, 2147483647, 2, 32, 0x9fffffffe5a5a508)
	EXT( 0xa5a5a5a5a5a5a507, 2, 33, 0xffffffff2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a507, 2, 33, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a507, 4294967295, 2, 33, 0x9fffffffe5a5a507)
	EXT( 0xa5a5a5a5a5a5a506, 2, 34, 0xfffffffe5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a506, 2, 34, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a506, 8589934591, 2, 34, 0x9ffffffff5a5a506)
	EXT( 0xa5a5a5a5a5a5a505, 2, 35, 0xfffffffcb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a505, 2, 35, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a505, 17179869183, 2, 35, 0x9ffffffffda5a505)
	EXT( 0xa5a5a5a5a5a5a504, 2, 36, 0xfffffff969696969)
	EXTU(0xa5a5a5a5a5a5a504, 2, 36, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a504, 34359738367, 2, 36, 0x9ffffffffda5a504)
	EXT( 0xa5a5a5a5a5a5a503, 2, 37, 0xfffffff2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a503, 2, 37, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a503, 68719476735, 2, 37, 0x9fffffffffa5a503)
	EXT( 0xa5a5a5a5a5a5a502, 2, 38, 0xffffffe5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a502, 2, 38, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a502, 137438953471, 2, 38, 0x9fffffffffa5a502)
	EXT( 0xa5a5a5a5a5a5a501, 2, 39, 0xffffffcb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a501, 2, 39, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a501, 274877906943, 2, 39, 0x9fffffffffa5a501)
	EXT( 0xa5a5a5a5a5a5a500, 2, 40, 0xffffff9696969696)
	EXTU(0xa5a5a5a5a5a5a500, 2, 40, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a500, 549755813887, 2, 40, 0x9fffffffffe5a500)
	EXT( 0xa5a5a5a5a5a5a4ff, 2, 41, 0xffffff2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a4ff, 2, 41, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a4ff, 1099511627775, 2, 41, 0x9fffffffffe5a4ff)
	EXT( 0xa5a5a5a5a5a5a4fe, 2, 42, 0xfffffe5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a4fe, 2, 42, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a4fe, 2199023255551, 2, 42, 0x9ffffffffff5a4fe)
	EXT( 0xa5a5a5a5a5a5a4fd, 2, 43, 0xfffffcb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a4fd, 2, 43, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a4fd, 4398046511103, 2, 43, 0x9ffffffffffda4fd)
	EXT( 0xa5a5a5a5a5a5a4fc, 2, 44, 0xfffff96969696969)
	EXTU(0xa5a5a5a5a5a5a4fc, 2, 44, 0x0000096969696969)
	DEP( 0xa5a5a5a5a5a5a4fc, 8796093022207, 2, 44, 0x9ffffffffffda4fc)
	EXT( 0xa5a5a5a5a5a5a4fb, 2, 45, 0xfffff2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a4fb, 2, 45, 0x000012d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a4fb, 17592186044415, 2, 45, 0x9fffffffffffa4fb)
	EXT( 0xa5a5a5a5a5a5a4fa, 2, 46, 0xffffe5a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a4fa, 2, 46, 0x000025a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a4fa, 35184372088831, 2, 46, 0x9fffffffffffa4fa)
	EXT( 0xa5a5a5a5a5a5a4f9, 2, 47, 0xffffcb4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a4f9, 2, 47, 0x00004b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a4f9, 70368744177663, 2, 47, 0x9fffffffffffa4f9)
	EXT( 0xa5a5a5a5a5a5a4f8, 2, 48, 0xffff969696969696)
	EXTU(0xa5a5a5a5a5a5a4f8, 2, 48, 0x0000969696969696)
	DEP( 0xa5a5a5a5a5a5a4f8, 140737488355327, 2, 48, 0x9fffffffffffe4f8)
	EXT( 0xa5a5a5a5a5a5a4f7, 2, 49, 0xffff2d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a4f7, 2, 49, 0x00012d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a4f7, 281474976710655, 2, 49, 0x9fffffffffffe4f7)
	EXT( 0xa5a5a5a5a5a5a4f6, 2, 50, 0xfffe5a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a4f6, 2, 50, 0x00025a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a4f6, 562949953421311, 2, 50, 0x9ffffffffffff4f6)
	EXT( 0xa5a5a5a5a5a5a4f5, 2, 51, 0xfffcb4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a4f5, 2, 51, 0x0004b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a4f5, 1125899906842623, 2, 51, 0x9ffffffffffffcf5)
	EXT( 0xa5a5a5a5a5a5a4f4, 2, 52, 0xfff9696969696969)
	EXTU(0xa5a5a5a5a5a5a4f4, 2, 52, 0x0009696969696969)
	DEP( 0xa5a5a5a5a5a5a4f4, 2251799813685247, 2, 52, 0x9ffffffffffffcf4)
	EXT( 0xa5a5a5a5a5a5a4f3, 2, 53, 0xfff2d2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a4f3, 2, 53, 0x0012d2d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a4f3, 4503599627370495, 2, 53, 0x9ffffffffffffef3)
	EXT( 0xa5a5a5a5a5a5a4f2, 2, 54, 0xffe5a5a5a5a5a5a4)
	EXTU(0xa5a5a5a5a5a5a4f2, 2, 54, 0x0025a5a5a5a5a5a4)
	DEP( 0xa5a5a5a5a5a5a4f2, 9007199254740991, 2, 54, 0x9ffffffffffffff2)
	EXT( 0xa5a5a5a5a5a5a4f1, 2, 55, 0xffcb4b4b4b4b4b49)
	EXTU(0xa5a5a5a5a5a5a4f1, 2, 55, 0x004b4b4b4b4b4b49)
	DEP( 0xa5a5a5a5a5a5a4f1, 18014398509481983, 2, 55, 0x9ffffffffffffff1)
	EXT( 0xa5a5a5a5a5a5a4f0, 2, 56, 0xff96969696969693)
	EXTU(0xa5a5a5a5a5a5a4f0, 2, 56, 0x0096969696969693)
	DEP( 0xa5a5a5a5a5a5a4f0, 36028797018963967, 2, 56, 0x9ffffffffffffff0)
	EXT( 0xa5a5a5a5a5a5a4ef, 2, 57, 0xff2d2d2d2d2d2d27)
	EXTU(0xa5a5a5a5a5a5a4ef, 2, 57, 0x012d2d2d2d2d2d27)
	DEP( 0xa5a5a5a5a5a5a4ef, 72057594037927935, 2, 57, 0x9fffffffffffffef)
	EXT( 0xa5a5a5a5a5a5a4ee, 2, 58, 0xfe5a5a5a5a5a5a4e)
	EXTU(0xa5a5a5a5a5a5a4ee, 2, 58, 0x025a5a5a5a5a5a4e)
	DEP( 0xa5a5a5a5a5a5a4ee, 144115188075855871, 2, 58, 0x9ffffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a4ed, 2, 59, 0xfcb4b4b4b4b4b49d)
	EXTU(0xa5a5a5a5a5a5a4ed, 2, 59, 0x04b4b4b4b4b4b49d)
	DEP( 0xa5a5a5a5a5a5a4ed, 288230376151711743, 2, 59, 0x9ffffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a4ec, 2, 60, 0xf96969696969693b)
	EXTU(0xa5a5a5a5a5a5a4ec, 2, 60, 0x096969696969693b)
	DEP( 0xa5a5a5a5a5a5a4ec, 576460752303423487, 2, 60, 0x9ffffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4eb, 2, 61, 0xf2d2d2d2d2d2d275)
	EXTU(0xa5a5a5a5a5a5a4eb, 2, 61, 0x12d2d2d2d2d2d275)
	DEP( 0xa5a5a5a5a5a5a4eb, 1152921504606846975, 2, 61, 0x9fffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4ea, 3, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a4ea, 3, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a4ea, 0, 3, 1, 0xa5a5a5a5a5a5a4ea)
	EXT( 0xa5a5a5a5a5a5a4e9, 3, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a4e9, 3, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a4e9, 1, 3, 2, 0xada5a5a5a5a5a4e9)
	EXT( 0xa5a5a5a5a5a5a4e8, 3, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a4e8, 3, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a4e8, 3, 3, 3, 0xada5a5a5a5a5a4e8)
	EXT( 0xa5a5a5a5a5a5a4e7, 3, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a4e7, 3, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a4e7, 7, 3, 4, 0xafa5a5a5a5a5a4e7)
	EXT( 0xa5a5a5a5a5a5a4e6, 3, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a4e6, 3, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a4e6, 15, 3, 5, 0xafa5a5a5a5a5a4e6)
	EXT( 0xa5a5a5a5a5a5a4e5, 3, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a4e5, 3, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a4e5, 31, 3, 6, 0xafa5a5a5a5a5a4e5)
	EXT( 0xa5a5a5a5a5a5a4e4, 3, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a4e4, 3, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a4e4, 63, 3, 7, 0xafe5a5a5a5a5a4e4)
	EXT( 0xa5a5a5a5a5a5a4e3, 3, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a4e3, 3, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a4e3, 127, 3, 8, 0xafe5a5a5a5a5a4e3)
	EXT( 0xa5a5a5a5a5a5a4e2, 3, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a4e2, 3, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a4e2, 255, 3, 9, 0xaff5a5a5a5a5a4e2)
	EXT( 0xa5a5a5a5a5a5a4e1, 3, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a4e1, 3, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a4e1, 511, 3, 10, 0xaffda5a5a5a5a4e1)
	EXT( 0xa5a5a5a5a5a5a4e0, 3, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a4e0, 3, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a4e0, 1023, 3, 11, 0xaffda5a5a5a5a4e0)
	EXT( 0xa5a5a5a5a5a5a4df, 3, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a4df, 3, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a4df, 2047, 3, 12, 0xafffa5a5a5a5a4df)
	EXT( 0xa5a5a5a5a5a5a4de, 3, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a4de, 3, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a4de, 4095, 3, 13, 0xafffa5a5a5a5a4de)
	EXT( 0xa5a5a5a5a5a5a4dd, 3, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a4dd, 3, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a4dd, 8191, 3, 14, 0xafffa5a5a5a5a4dd)
	EXT( 0xa5a5a5a5a5a5a4dc, 3, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a4dc, 3, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a4dc, 16383, 3, 15, 0xafffe5a5a5a5a4dc)
	EXT( 0xa5a5a5a5a5a5a4db, 3, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a4db, 3, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a4db, 32767, 3, 16, 0xafffe5a5a5a5a4db)
	EXT( 0xa5a5a5a5a5a5a4da, 3, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a4da, 3, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a4da, 65535, 3, 17, 0xaffff5a5a5a5a4da)
	EXT( 0xa5a5a5a5a5a5a4d9, 3, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a4d9, 3, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a4d9, 131071, 3, 18, 0xaffffda5a5a5a4d9)
	EXT( 0xa5a5a5a5a5a5a4d8, 3, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a4d8, 3, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a4d8, 262143, 3, 19, 0xaffffda5a5a5a4d8)
	EXT( 0xa5a5a5a5a5a5a4d7, 3, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a4d7, 3, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a4d7, 524287, 3, 20, 0xafffffa5a5a5a4d7)
	EXT( 0xa5a5a5a5a5a5a4d6, 3, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a4d6, 3, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a4d6, 1048575, 3, 21, 0xafffffa5a5a5a4d6)
	EXT( 0xa5a5a5a5a5a5a4d5, 3, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a4d5, 3, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a4d5, 2097151, 3, 22, 0xafffffa5a5a5a4d5)
	EXT( 0xa5a5a5a5a5a5a4d4, 3, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a4d4, 3, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a4d4, 4194303, 3, 23, 0xafffffe5a5a5a4d4)
	EXT( 0xa5a5a5a5a5a5a4d3, 3, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a4d3, 3, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a4d3, 8388607, 3, 24, 0xafffffe5a5a5a4d3)
	EXT( 0xa5a5a5a5a5a5a4d2, 3, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a4d2, 3, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a4d2, 16777215, 3, 25, 0xaffffff5a5a5a4d2)
	EXT( 0xa5a5a5a5a5a5a4d1, 3, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a4d1, 3, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a4d1, 33554431, 3, 26, 0xaffffffda5a5a4d1)
	EXT( 0xa5a5a5a5a5a5a4d0, 3, 27, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a4d0, 3, 27, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a4d0, 67108863, 3, 27, 0xaffffffda5a5a4d0)
	EXT( 0xa5a5a5a5a5a5a4cf, 3, 28, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a4cf, 3, 28, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a4cf, 134217727, 3, 28, 0xafffffffa5a5a4cf)
	EXT( 0xa5a5a5a5a5a5a4ce, 3, 29, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a4ce, 3, 29, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a4ce, 268435455, 3, 29, 0xafffffffa5a5a4ce)
	EXT( 0xa5a5a5a5a5a5a4cd, 3, 30, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a4cd, 3, 30, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a4cd, 536870911, 3, 30, 0xafffffffa5a5a4cd)
	EXT( 0xa5a5a5a5a5a5a4cc, 3, 31, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a4cc, 3, 31, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a4cc, 1073741823, 3, 31, 0xafffffffe5a5a4cc)
	EXT( 0xa5a5a5a5a5a5a4cb, 3, 32, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a4cb, 3, 32, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a4cb, 2147483647, 3, 32, 0xafffffffe5a5a4cb)
	EXT( 0xa5a5a5a5a5a5a4ca, 3, 33, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a4ca, 3, 33, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a4ca, 4294967295, 3, 33, 0xaffffffff5a5a4ca)
	EXT( 0xa5a5a5a5a5a5a4c9, 3, 34, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a4c9, 3, 34, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a4c9, 8589934591, 3, 34, 0xaffffffffda5a4c9)
	EXT( 0xa5a5a5a5a5a5a4c8, 3, 35, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a4c8, 3, 35, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a4c8, 17179869183, 3, 35, 0xaffffffffda5a4c8)
	EXT( 0xa5a5a5a5a5a5a4c7, 3, 36, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a4c7, 3, 36, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a4c7, 34359738367, 3, 36, 0xafffffffffa5a4c7)
	EXT( 0xa5a5a5a5a5a5a4c6, 3, 37, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a4c6, 3, 37, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a4c6, 68719476735, 3, 37, 0xafffffffffa5a4c6)
	EXT( 0xa5a5a5a5a5a5a4c5, 3, 38, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a4c5, 3, 38, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a4c5, 137438953471, 3, 38, 0xafffffffffa5a4c5)
	EXT( 0xa5a5a5a5a5a5a4c4, 3, 39, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a4c4, 3, 39, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a4c4, 274877906943, 3, 39, 0xafffffffffe5a4c4)
	EXT( 0xa5a5a5a5a5a5a4c3, 3, 40, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a4c3, 3, 40, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a4c3, 549755813887, 3, 40, 0xafffffffffe5a4c3)
	EXT( 0xa5a5a5a5a5a5a4c2, 3, 41, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a4c2, 3, 41, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a4c2, 1099511627775, 3, 41, 0xaffffffffff5a4c2)
	EXT( 0xa5a5a5a5a5a5a4c1, 3, 42, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a4c1, 3, 42, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a4c1, 2199023255551, 3, 42, 0xaffffffffffda4c1)
	EXT( 0xa5a5a5a5a5a5a4c0, 3, 43, 0x0000016969696969)
	EXTU(0xa5a5a5a5a5a5a4c0, 3, 43, 0x0000016969696969)
	DEP( 0xa5a5a5a5a5a5a4c0, 4398046511103, 3, 43, 0xaffffffffffda4c0)
	EXT( 0xa5a5a5a5a5a5a4bf, 3, 44, 0x000002d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a4bf, 3, 44, 0x000002d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a4bf, 8796093022207, 3, 44, 0xafffffffffffa4bf)
	EXT( 0xa5a5a5a5a5a5a4be, 3, 45, 0x000005a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a4be, 3, 45, 0x000005a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a4be, 17592186044415, 3, 45, 0xafffffffffffa4be)
	EXT( 0xa5a5a5a5a5a5a4bd, 3, 46, 0x00000b4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a4bd, 3, 46, 0x00000b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a4bd, 35184372088831, 3, 46, 0xafffffffffffa4bd)
	EXT( 0xa5a5a5a5a5a5a4bc, 3, 47, 0x0000169696969696)
	EXTU(0xa5a5a5a5a5a5a4bc, 3, 47, 0x0000169696969696)
	DEP( 0xa5a5a5a5a5a5a4bc, 70368744177663, 3, 47, 0xafffffffffffe4bc)
	EXT( 0xa5a5a5a5a5a5a4bb, 3, 48, 0x00002d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a4bb, 3, 48, 0x00002d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a4bb, 140737488355327, 3, 48, 0xafffffffffffe4bb)
	EXT( 0xa5a5a5a5a5a5a4ba, 3, 49, 0x00005a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a4ba, 3, 49, 0x00005a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a4ba, 281474976710655, 3, 49, 0xaffffffffffff4ba)
	EXT( 0xa5a5a5a5a5a5a4b9, 3, 50, 0x0000b4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a4b9, 3, 50, 0x0000b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a4b9, 562949953421311, 3, 50, 0xaffffffffffffcb9)
	EXT( 0xa5a5a5a5a5a5a4b8, 3, 51, 0x0001696969696969)
	EXTU(0xa5a5a5a5a5a5a4b8, 3, 51, 0x0001696969696969)
	DEP( 0xa5a5a5a5a5a5a4b8, 1125899906842623, 3, 51, 0xaffffffffffffcb8)
	EXT( 0xa5a5a5a5a5a5a4b7, 3, 52, 0x0002d2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a4b7, 3, 52, 0x0002d2d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a4b7, 2251799813685247, 3, 52, 0xaffffffffffffeb7)
	EXT( 0xa5a5a5a5a5a5a4b6, 3, 53, 0x0005a5a5a5a5a5a4)
	EXTU(0xa5a5a5a5a5a5a4b6, 3, 53, 0x0005a5a5a5a5a5a4)
	DEP( 0xa5a5a5a5a5a5a4b6, 4503599627370495, 3, 53, 0xafffffffffffffb6)
	EXT( 0xa5a5a5a5a5a5a4b5, 3, 54, 0x000b4b4b4b4b4b49)
	EXTU(0xa5a5a5a5a5a5a4b5, 3, 54, 0x000b4b4b4b4b4b49)
	DEP( 0xa5a5a5a5a5a5a4b5, 9007199254740991, 3, 54, 0xafffffffffffffb5)
	EXT( 0xa5a5a5a5a5a5a4b4, 3, 55, 0x0016969696969692)
	EXTU(0xa5a5a5a5a5a5a4b4, 3, 55, 0x0016969696969692)
	DEP( 0xa5a5a5a5a5a5a4b4, 18014398509481983, 3, 55, 0xaffffffffffffff4)
	EXT( 0xa5a5a5a5a5a5a4b3, 3, 56, 0x002d2d2d2d2d2d25)
	EXTU(0xa5a5a5a5a5a5a4b3, 3, 56, 0x002d2d2d2d2d2d25)
	DEP( 0xa5a5a5a5a5a5a4b3, 36028797018963967, 3, 56, 0xaffffffffffffff3)
	EXT( 0xa5a5a5a5a5a5a4b2, 3, 57, 0x005a5a5a5a5a5a4b)
	EXTU(0xa5a5a5a5a5a5a4b2, 3, 57, 0x005a5a5a5a5a5a4b)
	DEP( 0xa5a5a5a5a5a5a4b2, 72057594037927935, 3, 57, 0xaffffffffffffff2)
	EXT( 0xa5a5a5a5a5a5a4b1, 3, 58, 0x00b4b4b4b4b4b496)
	EXTU(0xa5a5a5a5a5a5a4b1, 3, 58, 0x00b4b4b4b4b4b496)
	DEP( 0xa5a5a5a5a5a5a4b1, 144115188075855871, 3, 58, 0xaffffffffffffff9)
	EXT( 0xa5a5a5a5a5a5a4b0, 3, 59, 0x016969696969692c)
	EXTU(0xa5a5a5a5a5a5a4b0, 3, 59, 0x016969696969692c)
	DEP( 0xa5a5a5a5a5a5a4b0, 288230376151711743, 3, 59, 0xaffffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a4af, 3, 60, 0x02d2d2d2d2d2d257)
	EXTU(0xa5a5a5a5a5a5a4af, 3, 60, 0x02d2d2d2d2d2d257)
	DEP( 0xa5a5a5a5a5a5a4af, 576460752303423487, 3, 60, 0xafffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a4ae, 4, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a4ae, 4, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a4ae, 0, 4, 1, 0xa5a5a5a5a5a5a4ae)
	EXT( 0xa5a5a5a5a5a5a4ad, 4, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a4ad, 4, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a4ad, 1, 4, 2, 0xa5a5a5a5a5a5a4ad)
	EXT( 0xa5a5a5a5a5a5a4ac, 4, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a4ac, 4, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a4ac, 3, 4, 3, 0xa7a5a5a5a5a5a4ac)
	EXT( 0xa5a5a5a5a5a5a4ab, 4, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a4ab, 4, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a4ab, 7, 4, 4, 0xa7a5a5a5a5a5a4ab)
	EXT( 0xa5a5a5a5a5a5a4aa, 4, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a4aa, 4, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a4aa, 15, 4, 5, 0xa7a5a5a5a5a5a4aa)
	EXT( 0xa5a5a5a5a5a5a4a9, 4, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a4a9, 4, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a4a9, 31, 4, 6, 0xa7e5a5a5a5a5a4a9)
	EXT( 0xa5a5a5a5a5a5a4a8, 4, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a4a8, 4, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a4a8, 63, 4, 7, 0xa7e5a5a5a5a5a4a8)
	EXT( 0xa5a5a5a5a5a5a4a7, 4, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a4a7, 4, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a4a7, 127, 4, 8, 0xa7f5a5a5a5a5a4a7)
	EXT( 0xa5a5a5a5a5a5a4a6, 4, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a4a6, 4, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a4a6, 255, 4, 9, 0xa7fda5a5a5a5a4a6)
	EXT( 0xa5a5a5a5a5a5a4a5, 4, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a4a5, 4, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a4a5, 511, 4, 10, 0xa7fda5a5a5a5a4a5)
	EXT( 0xa5a5a5a5a5a5a4a4, 4, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a4a4, 4, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a4a4, 1023, 4, 11, 0xa7ffa5a5a5a5a4a4)
	EXT( 0xa5a5a5a5a5a5a4a3, 4, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a4a3, 4, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a4a3, 2047, 4, 12, 0xa7ffa5a5a5a5a4a3)
	EXT( 0xa5a5a5a5a5a5a4a2, 4, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a4a2, 4, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a4a2, 4095, 4, 13, 0xa7ffa5a5a5a5a4a2)
	EXT( 0xa5a5a5a5a5a5a4a1, 4, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a4a1, 4, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a4a1, 8191, 4, 14, 0xa7ffe5a5a5a5a4a1)
	EXT( 0xa5a5a5a5a5a5a4a0, 4, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a4a0, 4, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a4a0, 16383, 4, 15, 0xa7ffe5a5a5a5a4a0)
	EXT( 0xa5a5a5a5a5a5a49f, 4, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a49f, 4, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a49f, 32767, 4, 16, 0xa7fff5a5a5a5a49f)
	EXT( 0xa5a5a5a5a5a5a49e, 4, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a49e, 4, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a49e, 65535, 4, 17, 0xa7fffda5a5a5a49e)
	EXT( 0xa5a5a5a5a5a5a49d, 4, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a49d, 4, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a49d, 131071, 4, 18, 0xa7fffda5a5a5a49d)
	EXT( 0xa5a5a5a5a5a5a49c, 4, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a49c, 4, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a49c, 262143, 4, 19, 0xa7ffffa5a5a5a49c)
	EXT( 0xa5a5a5a5a5a5a49b, 4, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a49b, 4, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a49b, 524287, 4, 20, 0xa7ffffa5a5a5a49b)
	EXT( 0xa5a5a5a5a5a5a49a, 4, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a49a, 4, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a49a, 1048575, 4, 21, 0xa7ffffa5a5a5a49a)
	EXT( 0xa5a5a5a5a5a5a499, 4, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a499, 4, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a499, 2097151, 4, 22, 0xa7ffffe5a5a5a499)
	EXT( 0xa5a5a5a5a5a5a498, 4, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a498, 4, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a498, 4194303, 4, 23, 0xa7ffffe5a5a5a498)
	EXT( 0xa5a5a5a5a5a5a497, 4, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a497, 4, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a497, 8388607, 4, 24, 0xa7fffff5a5a5a497)
	EXT( 0xa5a5a5a5a5a5a496, 4, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a496, 4, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a496, 16777215, 4, 25, 0xa7fffffda5a5a496)
	EXT( 0xa5a5a5a5a5a5a495, 4, 26, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a495, 4, 26, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a495, 33554431, 4, 26, 0xa7fffffda5a5a495)
	EXT( 0xa5a5a5a5a5a5a494, 4, 27, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a494, 4, 27, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a494, 67108863, 4, 27, 0xa7ffffffa5a5a494)
	EXT( 0xa5a5a5a5a5a5a493, 4, 28, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a493, 4, 28, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a493, 134217727, 4, 28, 0xa7ffffffa5a5a493)
	EXT( 0xa5a5a5a5a5a5a492, 4, 29, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a492, 4, 29, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a492, 268435455, 4, 29, 0xa7ffffffa5a5a492)
	EXT( 0xa5a5a5a5a5a5a491, 4, 30, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a491, 4, 30, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a491, 536870911, 4, 30, 0xa7ffffffe5a5a491)
	EXT( 0xa5a5a5a5a5a5a490, 4, 31, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a490, 4, 31, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a490, 1073741823, 4, 31, 0xa7ffffffe5a5a490)
	EXT( 0xa5a5a5a5a5a5a48f, 4, 32, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a48f, 4, 32, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a48f, 2147483647, 4, 32, 0xa7fffffff5a5a48f)
	EXT( 0xa5a5a5a5a5a5a48e, 4, 33, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a48e, 4, 33, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a48e, 4294967295, 4, 33, 0xa7fffffffda5a48e)
	EXT( 0xa5a5a5a5a5a5a48d, 4, 34, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a48d, 4, 34, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a48d, 8589934591, 4, 34, 0xa7fffffffda5a48d)
	EXT( 0xa5a5a5a5a5a5a48c, 4, 35, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a48c, 4, 35, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a48c, 17179869183, 4, 35, 0xa7ffffffffa5a48c)
	EXT( 0xa5a5a5a5a5a5a48b, 4, 36, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a48b, 4, 36, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a48b, 34359738367, 4, 36, 0xa7ffffffffa5a48b)
	EXT( 0xa5a5a5a5a5a5a48a, 4, 37, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a48a, 4, 37, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a48a, 68719476735, 4, 37, 0xa7ffffffffa5a48a)
	EXT( 0xa5a5a5a5a5a5a489, 4, 38, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a489, 4, 38, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a489, 137438953471, 4, 38, 0xa7ffffffffe5a489)
	EXT( 0xa5a5a5a5a5a5a488, 4, 39, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a488, 4, 39, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a488, 274877906943, 4, 39, 0xa7ffffffffe5a488)
	EXT( 0xa5a5a5a5a5a5a487, 4, 40, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a487, 4, 40, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a487, 549755813887, 4, 40, 0xa7fffffffff5a487)
	EXT( 0xa5a5a5a5a5a5a486, 4, 41, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a486, 4, 41, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a486, 1099511627775, 4, 41, 0xa7fffffffffda486)
	EXT( 0xa5a5a5a5a5a5a485, 4, 42, 0x0000016969696969)
	EXTU(0xa5a5a5a5a5a5a485, 4, 42, 0x0000016969696969)
	DEP( 0xa5a5a5a5a5a5a485, 2199023255551, 4, 42, 0xa7fffffffffda485)
	EXT( 0xa5a5a5a5a5a5a484, 4, 43, 0x000002d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a484, 4, 43, 0x000002d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a484, 4398046511103, 4, 43, 0xa7ffffffffffa484)
	EXT( 0xa5a5a5a5a5a5a483, 4, 44, 0x000005a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a483, 4, 44, 0x000005a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a483, 8796093022207, 4, 44, 0xa7ffffffffffa483)
	EXT( 0xa5a5a5a5a5a5a482, 4, 45, 0x00000b4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a482, 4, 45, 0x00000b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a482, 17592186044415, 4, 45, 0xa7ffffffffffa482)
	EXT( 0xa5a5a5a5a5a5a481, 4, 46, 0x0000169696969696)
	EXTU(0xa5a5a5a5a5a5a481, 4, 46, 0x0000169696969696)
	DEP( 0xa5a5a5a5a5a5a481, 35184372088831, 4, 46, 0xa7ffffffffffe481)
	EXT( 0xa5a5a5a5a5a5a480, 4, 47, 0x00002d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a480, 4, 47, 0x00002d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a480, 70368744177663, 4, 47, 0xa7ffffffffffe480)
	EXT( 0xa5a5a5a5a5a5a47f, 4, 48, 0x00005a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a47f, 4, 48, 0x00005a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a47f, 140737488355327, 4, 48, 0xa7fffffffffff47f)
	EXT( 0xa5a5a5a5a5a5a47e, 4, 49, 0x0000b4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a47e, 4, 49, 0x0000b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a47e, 281474976710655, 4, 49, 0xa7fffffffffffc7e)
	EXT( 0xa5a5a5a5a5a5a47d, 4, 50, 0x0001696969696969)
	EXTU(0xa5a5a5a5a5a5a47d, 4, 50, 0x0001696969696969)
	DEP( 0xa5a5a5a5a5a5a47d, 562949953421311, 4, 50, 0xa7fffffffffffc7d)
	EXT( 0xa5a5a5a5a5a5a47c, 4, 51, 0x0002d2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a47c, 4, 51, 0x0002d2d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a47c, 1125899906842623, 4, 51, 0xa7fffffffffffe7c)
	EXT( 0xa5a5a5a5a5a5a47b, 4, 52, 0x0005a5a5a5a5a5a4)
	EXTU(0xa5a5a5a5a5a5a47b, 4, 52, 0x0005a5a5a5a5a5a4)
	DEP( 0xa5a5a5a5a5a5a47b, 2251799813685247, 4, 52, 0xa7ffffffffffff7b)
	EXT( 0xa5a5a5a5a5a5a47a, 4, 53, 0x000b4b4b4b4b4b48)
	EXTU(0xa5a5a5a5a5a5a47a, 4, 53, 0x000b4b4b4b4b4b48)
	DEP( 0xa5a5a5a5a5a5a47a, 4503599627370495, 4, 53, 0xa7fffffffffffffa)
	EXT( 0xa5a5a5a5a5a5a479, 4, 54, 0x0016969696969691)
	EXTU(0xa5a5a5a5a5a5a479, 4, 54, 0x0016969696969691)
	DEP( 0xa5a5a5a5a5a5a479, 9007199254740991, 4, 54, 0xa7fffffffffffff9)
	EXT( 0xa5a5a5a5a5a5a478, 4, 55, 0x002d2d2d2d2d2d23)
	EXTU(0xa5a5a5a5a5a5a478, 4, 55, 0x002d2d2d2d2d2d23)
	DEP( 0xa5a5a5a5a5a5a478, 18014398509481983, 4, 55, 0xa7fffffffffffff8)
	EXT( 0xa5a5a5a5a5a5a477, 4, 56, 0x005a5a5a5a5a5a47)
	EXTU(0xa5a5a5a5a5a5a477, 4, 56, 0x005a5a5a5a5a5a47)
	DEP( 0xa5a5a5a5a5a5a477, 36028797018963967, 4, 56, 0xa7fffffffffffff7)
	EXT( 0xa5a5a5a5a5a5a476, 4, 57, 0x00b4b4b4b4b4b48e)
	EXTU(0xa5a5a5a5a5a5a476, 4, 57, 0x00b4b4b4b4b4b48e)
	DEP( 0xa5a5a5a5a5a5a476, 72057594037927935, 4, 57, 0xa7fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a475, 4, 58, 0x016969696969691d)
	EXTU(0xa5a5a5a5a5a5a475, 4, 58, 0x016969696969691d)
	DEP( 0xa5a5a5a5a5a5a475, 144115188075855871, 4, 58, 0xa7fffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a474, 4, 59, 0x02d2d2d2d2d2d23a)
	EXTU(0xa5a5a5a5a5a5a474, 4, 59, 0x02d2d2d2d2d2d23a)
	DEP( 0xa5a5a5a5a5a5a474, 288230376151711743, 4, 59, 0xa7fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a473, 5, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a473, 5, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a473, 0, 5, 1, 0xa1a5a5a5a5a5a473)
	EXT( 0xa5a5a5a5a5a5a472, 5, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a472, 5, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a472, 1, 5, 2, 0xa3a5a5a5a5a5a472)
	EXT( 0xa5a5a5a5a5a5a471, 5, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a471, 5, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a471, 3, 5, 3, 0xa3a5a5a5a5a5a471)
	EXT( 0xa5a5a5a5a5a5a470, 5, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a5a470, 5, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a470, 7, 5, 4, 0xa3a5a5a5a5a5a470)
	EXT( 0xa5a5a5a5a5a5a46f, 5, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a5a46f, 5, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a46f, 15, 5, 5, 0xa3e5a5a5a5a5a46f)
	EXT( 0xa5a5a5a5a5a5a46e, 5, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a5a46e, 5, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a46e, 31, 5, 6, 0xa3e5a5a5a5a5a46e)
	EXT( 0xa5a5a5a5a5a5a46d, 5, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a5a46d, 5, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a46d, 63, 5, 7, 0xa3f5a5a5a5a5a46d)
	EXT( 0xa5a5a5a5a5a5a46c, 5, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a5a46c, 5, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a46c, 127, 5, 8, 0xa3fda5a5a5a5a46c)
	EXT( 0xa5a5a5a5a5a5a46b, 5, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a5a46b, 5, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a46b, 255, 5, 9, 0xa3fda5a5a5a5a46b)
	EXT( 0xa5a5a5a5a5a5a46a, 5, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a5a46a, 5, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a46a, 511, 5, 10, 0xa3ffa5a5a5a5a46a)
	EXT( 0xa5a5a5a5a5a5a469, 5, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a5a469, 5, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a469, 1023, 5, 11, 0xa3ffa5a5a5a5a469)
	EXT( 0xa5a5a5a5a5a5a468, 5, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a5a468, 5, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a468, 2047, 5, 12, 0xa3ffa5a5a5a5a468)
	EXT( 0xa5a5a5a5a5a5a467, 5, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a5a467, 5, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a467, 4095, 5, 13, 0xa3ffe5a5a5a5a467)
	EXT( 0xa5a5a5a5a5a5a466, 5, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a5a466, 5, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a466, 8191, 5, 14, 0xa3ffe5a5a5a5a466)
	EXT( 0xa5a5a5a5a5a5a465, 5, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a5a465, 5, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a465, 16383, 5, 15, 0xa3fff5a5a5a5a465)
	EXT( 0xa5a5a5a5a5a5a464, 5, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a5a464, 5, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a464, 32767, 5, 16, 0xa3fffda5a5a5a464)
	EXT( 0xa5a5a5a5a5a5a463, 5, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a5a463, 5, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a463, 65535, 5, 17, 0xa3fffda5a5a5a463)
	EXT( 0xa5a5a5a5a5a5a462, 5, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a5a462, 5, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a462, 131071, 5, 18, 0xa3ffffa5a5a5a462)
	EXT( 0xa5a5a5a5a5a5a461, 5, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a5a461, 5, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a461, 262143, 5, 19, 0xa3ffffa5a5a5a461)
	EXT( 0xa5a5a5a5a5a5a460, 5, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a5a460, 5, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a460, 524287, 5, 20, 0xa3ffffa5a5a5a460)
	EXT( 0xa5a5a5a5a5a5a45f, 5, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a5a45f, 5, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a45f, 1048575, 5, 21, 0xa3ffffe5a5a5a45f)
	EXT( 0xa5a5a5a5a5a5a45e, 5, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a5a45e, 5, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a45e, 2097151, 5, 22, 0xa3ffffe5a5a5a45e)
	EXT( 0xa5a5a5a5a5a5a45d, 5, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a5a45d, 5, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a45d, 4194303, 5, 23, 0xa3fffff5a5a5a45d)
	EXT( 0xa5a5a5a5a5a5a45c, 5, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a5a45c, 5, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a45c, 8388607, 5, 24, 0xa3fffffda5a5a45c)
	EXT( 0xa5a5a5a5a5a5a45b, 5, 25, 0xffffffffff696969)
	EXTU(0xa5a5a5a5a5a5a45b, 5, 25, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a45b, 16777215, 5, 25, 0xa3fffffda5a5a45b)
	EXT( 0xa5a5a5a5a5a5a45a, 5, 26, 0xfffffffffed2d2d2)
	EXTU(0xa5a5a5a5a5a5a45a, 5, 26, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a45a, 33554431, 5, 26, 0xa3ffffffa5a5a45a)
	EXT( 0xa5a5a5a5a5a5a459, 5, 27, 0xfffffffffda5a5a5)
	EXTU(0xa5a5a5a5a5a5a459, 5, 27, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a459, 67108863, 5, 27, 0xa3ffffffa5a5a459)
	EXT( 0xa5a5a5a5a5a5a458, 5, 28, 0xfffffffffb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a458, 5, 28, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a458, 134217727, 5, 28, 0xa3ffffffa5a5a458)
	EXT( 0xa5a5a5a5a5a5a457, 5, 29, 0xfffffffff6969696)
	EXTU(0xa5a5a5a5a5a5a457, 5, 29, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a457, 268435455, 5, 29, 0xa3ffffffe5a5a457)
	EXT( 0xa5a5a5a5a5a5a456, 5, 30, 0xffffffffed2d2d2d)
	EXTU(0xa5a5a5a5a5a5a456, 5, 30, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a456, 536870911, 5, 30, 0xa3ffffffe5a5a456)
	EXT( 0xa5a5a5a5a5a5a455, 5, 31, 0xffffffffda5a5a5a)
	EXTU(0xa5a5a5a5a5a5a455, 5, 31, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a455, 1073741823, 5, 31, 0xa3fffffff5a5a455)
	EXT( 0xa5a5a5a5a5a5a454, 5, 32, 0xffffffffb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a454, 5, 32, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a454, 2147483647, 5, 32, 0xa3fffffffda5a454)
	EXT( 0xa5a5a5a5a5a5a453, 5, 33, 0xffffffff69696969)
	EXTU(0xa5a5a5a5a5a5a453, 5, 33, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a453, 4294967295, 5, 33, 0xa3fffffffda5a453)
	EXT( 0xa5a5a5a5a5a5a452, 5, 34, 0xfffffffed2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a452, 5, 34, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a452, 8589934591, 5, 34, 0xa3ffffffffa5a452)
	EXT( 0xa5a5a5a5a5a5a451, 5, 35, 0xfffffffda5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a451, 5, 35, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a451, 17179869183, 5, 35, 0xa3ffffffffa5a451)
	EXT( 0xa5a5a5a5a5a5a450, 5, 36, 0xfffffffb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a450, 5, 36, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a450, 34359738367, 5, 36, 0xa3ffffffffa5a450)
	EXT( 0xa5a5a5a5a5a5a44f, 5, 37, 0xfffffff696969696)
	EXTU(0xa5a5a5a5a5a5a44f, 5, 37, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a44f, 68719476735, 5, 37, 0xa3ffffffffe5a44f)
	EXT( 0xa5a5a5a5a5a5a44e, 5, 38, 0xffffffed2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a44e, 5, 38, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a44e, 137438953471, 5, 38, 0xa3ffffffffe5a44e)
	EXT( 0xa5a5a5a5a5a5a44d, 5, 39, 0xffffffda5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a44d, 5, 39, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a44d, 274877906943, 5, 39, 0xa3fffffffff5a44d)
	EXT( 0xa5a5a5a5a5a5a44c, 5, 40, 0xffffffb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a44c, 5, 40, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a44c, 549755813887, 5, 40, 0xa3fffffffffda44c)
	EXT( 0xa5a5a5a5a5a5a44b, 5, 41, 0xffffff6969696969)
	EXTU(0xa5a5a5a5a5a5a44b, 5, 41, 0x0000016969696969)
	DEP( 0xa5a5a5a5a5a5a44b, 1099511627775, 5, 41, 0xa3fffffffffda44b)
	EXT( 0xa5a5a5a5a5a5a44a, 5, 42, 0xfffffed2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a44a, 5, 42, 0x000002d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a44a, 2199023255551, 5, 42, 0xa3ffffffffffa44a)
	EXT( 0xa5a5a5a5a5a5a449, 5, 43, 0xfffffda5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a449, 5, 43, 0x000005a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a449, 4398046511103, 5, 43, 0xa3ffffffffffa449)
	EXT( 0xa5a5a5a5a5a5a448, 5, 44, 0xfffffb4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a448, 5, 44, 0x00000b4b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a448, 8796093022207, 5, 44, 0xa3ffffffffffa448)
	EXT( 0xa5a5a5a5a5a5a447, 5, 45, 0xfffff69696969696)
	EXTU(0xa5a5a5a5a5a5a447, 5, 45, 0x0000169696969696)
	DEP( 0xa5a5a5a5a5a5a447, 17592186044415, 5, 45, 0xa3ffffffffffe447)
	EXT( 0xa5a5a5a5a5a5a446, 5, 46, 0xffffed2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a446, 5, 46, 0x00002d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a446, 35184372088831, 5, 46, 0xa3ffffffffffe446)
	EXT( 0xa5a5a5a5a5a5a445, 5, 47, 0xffffda5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a445, 5, 47, 0x00005a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a445, 70368744177663, 5, 47, 0xa3fffffffffff445)
	EXT( 0xa5a5a5a5a5a5a444, 5, 48, 0xffffb4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a444, 5, 48, 0x0000b4b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a444, 140737488355327, 5, 48, 0xa3fffffffffffc44)
	EXT( 0xa5a5a5a5a5a5a443, 5, 49, 0xffff696969696969)
	EXTU(0xa5a5a5a5a5a5a443, 5, 49, 0x0001696969696969)
	DEP( 0xa5a5a5a5a5a5a443, 281474976710655, 5, 49, 0xa3fffffffffffc43)
	EXT( 0xa5a5a5a5a5a5a442, 5, 50, 0xfffed2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a442, 5, 50, 0x0002d2d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a442, 562949953421311, 5, 50, 0xa3fffffffffffe42)
	EXT( 0xa5a5a5a5a5a5a441, 5, 51, 0xfffda5a5a5a5a5a4)
	EXTU(0xa5a5a5a5a5a5a441, 5, 51, 0x0005a5a5a5a5a5a4)
	DEP( 0xa5a5a5a5a5a5a441, 1125899906842623, 5, 51, 0xa3ffffffffffff41)
	EXT( 0xa5a5a5a5a5a5a440, 5, 52, 0xfffb4b4b4b4b4b48)
	EXTU(0xa5a5a5a5a5a5a440, 5, 52, 0x000b4b4b4b4b4b48)
	DEP( 0xa5a5a5a5a5a5a440, 2251799813685247, 5, 52, 0xa3ffffffffffffc0)
	EXT( 0xa5a5a5a5a5a5a43f, 5, 53, 0xfff6969696969690)
	EXTU(0xa5a5a5a5a5a5a43f, 5, 53, 0x0016969696969690)
	DEP( 0xa5a5a5a5a5a5a43f, 4503599627370495, 5, 53, 0xa3ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a43e, 5, 54, 0xffed2d2d2d2d2d21)
	EXTU(0xa5a5a5a5a5a5a43e, 5, 54, 0x002d2d2d2d2d2d21)
	DEP( 0xa5a5a5a5a5a5a43e, 9007199254740991, 5, 54, 0xa3fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a43d, 5, 55, 0xffda5a5a5a5a5a43)
	EXTU(0xa5a5a5a5a5a5a43d, 5, 55, 0x005a5a5a5a5a5a43)
	DEP( 0xa5a5a5a5a5a5a43d, 18014398509481983, 5, 55, 0xa3fffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a43c, 5, 56, 0xffb4b4b4b4b4b487)
	EXTU(0xa5a5a5a5a5a5a43c, 5, 56, 0x00b4b4b4b4b4b487)
	DEP( 0xa5a5a5a5a5a5a43c, 36028797018963967, 5, 56, 0xa3fffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a43b, 5, 57, 0xff6969696969690e)
	EXTU(0xa5a5a5a5a5a5a43b, 5, 57, 0x016969696969690e)
	DEP( 0xa5a5a5a5a5a5a43b, 72057594037927935, 5, 57, 0xa3ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a43a, 5, 58, 0xfed2d2d2d2d2d21d)
	EXTU(0xa5a5a5a5a5a5a43a, 5, 58, 0x02d2d2d2d2d2d21d)
	DEP( 0xa5a5a5a5a5a5a43a, 144115188075855871, 5, 58, 0xa3fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a439, 6, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a439, 6, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a439, 0, 6, 1, 0xa5a5a5a5a5a5a439)
	EXT( 0xa5a5a5a5a5a5a438, 6, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a438, 6, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a438, 1, 6, 2, 0xa5a5a5a5a5a5a438)
	EXT( 0xa5a5a5a5a5a5a437, 6, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a437, 6, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a437, 3, 6, 3, 0xa5a5a5a5a5a5a437)
	EXT( 0xa5a5a5a5a5a5a436, 6, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a5a436, 6, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a436, 7, 6, 4, 0xa5e5a5a5a5a5a436)
	EXT( 0xa5a5a5a5a5a5a435, 6, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a5a435, 6, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a435, 15, 6, 5, 0xa5e5a5a5a5a5a435)
	EXT( 0xa5a5a5a5a5a5a434, 6, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a5a434, 6, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a434, 31, 6, 6, 0xa5f5a5a5a5a5a434)
	EXT( 0xa5a5a5a5a5a5a433, 6, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a5a433, 6, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a433, 63, 6, 7, 0xa5fda5a5a5a5a433)
	EXT( 0xa5a5a5a5a5a5a432, 6, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a5a432, 6, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a432, 127, 6, 8, 0xa5fda5a5a5a5a432)
	EXT( 0xa5a5a5a5a5a5a431, 6, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a5a431, 6, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a431, 255, 6, 9, 0xa5ffa5a5a5a5a431)
	EXT( 0xa5a5a5a5a5a5a430, 6, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a5a430, 6, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a430, 511, 6, 10, 0xa5ffa5a5a5a5a430)
	EXT( 0xa5a5a5a5a5a5a42f, 6, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a5a42f, 6, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a42f, 1023, 6, 11, 0xa5ffa5a5a5a5a42f)
	EXT( 0xa5a5a5a5a5a5a42e, 6, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a5a42e, 6, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a42e, 2047, 6, 12, 0xa5ffe5a5a5a5a42e)
	EXT( 0xa5a5a5a5a5a5a42d, 6, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a5a42d, 6, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a42d, 4095, 6, 13, 0xa5ffe5a5a5a5a42d)
	EXT( 0xa5a5a5a5a5a5a42c, 6, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a5a42c, 6, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a42c, 8191, 6, 14, 0xa5fff5a5a5a5a42c)
	EXT( 0xa5a5a5a5a5a5a42b, 6, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a5a42b, 6, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a42b, 16383, 6, 15, 0xa5fffda5a5a5a42b)
	EXT( 0xa5a5a5a5a5a5a42a, 6, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a5a42a, 6, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a42a, 32767, 6, 16, 0xa5fffda5a5a5a42a)
	EXT( 0xa5a5a5a5a5a5a429, 6, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a5a429, 6, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a429, 65535, 6, 17, 0xa5ffffa5a5a5a429)
	EXT( 0xa5a5a5a5a5a5a428, 6, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a5a428, 6, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a428, 131071, 6, 18, 0xa5ffffa5a5a5a428)
	EXT( 0xa5a5a5a5a5a5a427, 6, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a5a427, 6, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a427, 262143, 6, 19, 0xa5ffffa5a5a5a427)
	EXT( 0xa5a5a5a5a5a5a426, 6, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a5a426, 6, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a426, 524287, 6, 20, 0xa5ffffe5a5a5a426)
	EXT( 0xa5a5a5a5a5a5a425, 6, 21, 0x00000000000d2d2d)
	EXTU(0xa5a5a5a5a5a5a425, 6, 21, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a425, 1048575, 6, 21, 0xa5ffffe5a5a5a425)
	EXT( 0xa5a5a5a5a5a5a424, 6, 22, 0x00000000001a5a5a)
	EXTU(0xa5a5a5a5a5a5a424, 6, 22, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a424, 2097151, 6, 22, 0xa5fffff5a5a5a424)
	EXT( 0xa5a5a5a5a5a5a423, 6, 23, 0x000000000034b4b4)
	EXTU(0xa5a5a5a5a5a5a423, 6, 23, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a423, 4194303, 6, 23, 0xa5fffffda5a5a423)
	EXT( 0xa5a5a5a5a5a5a422, 6, 24, 0x0000000000696969)
	EXTU(0xa5a5a5a5a5a5a422, 6, 24, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a422, 8388607, 6, 24, 0xa5fffffda5a5a422)
	EXT( 0xa5a5a5a5a5a5a421, 6, 25, 0x0000000000d2d2d2)
	EXTU(0xa5a5a5a5a5a5a421, 6, 25, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a421, 16777215, 6, 25, 0xa5ffffffa5a5a421)
	EXT( 0xa5a5a5a5a5a5a420, 6, 26, 0x0000000001a5a5a5)
	EXTU(0xa5a5a5a5a5a5a420, 6, 26, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a420, 33554431, 6, 26, 0xa5ffffffa5a5a420)
	EXT( 0xa5a5a5a5a5a5a41f, 6, 27, 0x00000000034b4b4b)
	EXTU(0xa5a5a5a5a5a5a41f, 6, 27, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a41f, 67108863, 6, 27, 0xa5ffffffa5a5a41f)
	EXT( 0xa5a5a5a5a5a5a41e, 6, 28, 0x0000000006969696)
	EXTU(0xa5a5a5a5a5a5a41e, 6, 28, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a41e, 134217727, 6, 28, 0xa5ffffffe5a5a41e)
	EXT( 0xa5a5a5a5a5a5a41d, 6, 29, 0x000000000d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a41d, 6, 29, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a41d, 268435455, 6, 29, 0xa5ffffffe5a5a41d)
	EXT( 0xa5a5a5a5a5a5a41c, 6, 30, 0x000000001a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a41c, 6, 30, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a41c, 536870911, 6, 30, 0xa5fffffff5a5a41c)
	EXT( 0xa5a5a5a5a5a5a41b, 6, 31, 0x0000000034b4b4b4)
	EXTU(0xa5a5a5a5a5a5a41b, 6, 31, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a41b, 1073741823, 6, 31, 0xa5fffffffda5a41b)
	EXT( 0xa5a5a5a5a5a5a41a, 6, 32, 0x0000000069696969)
	EXTU(0xa5a5a5a5a5a5a41a, 6, 32, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a41a, 2147483647, 6, 32, 0xa5fffffffda5a41a)
	EXT( 0xa5a5a5a5a5a5a419, 6, 33, 0x00000000d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a419, 6, 33, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a419, 4294967295, 6, 33, 0xa5ffffffffa5a419)
	EXT( 0xa5a5a5a5a5a5a418, 6, 34, 0x00000001a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a418, 6, 34, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a418, 8589934591, 6, 34, 0xa5ffffffffa5a418)
	EXT( 0xa5a5a5a5a5a5a417, 6, 35, 0x000000034b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a417, 6, 35, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a417, 17179869183, 6, 35, 0xa5ffffffffa5a417)
	EXT( 0xa5a5a5a5a5a5a416, 6, 36, 0x0000000696969696)
	EXTU(0xa5a5a5a5a5a5a416, 6, 36, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a416, 34359738367, 6, 36, 0xa5ffffffffe5a416)
	EXT( 0xa5a5a5a5a5a5a415, 6, 37, 0x0000000d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a415, 6, 37, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a415, 68719476735, 6, 37, 0xa5ffffffffe5a415)
	EXT( 0xa5a5a5a5a5a5a414, 6, 38, 0x0000001a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a414, 6, 38, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a414, 137438953471, 6, 38, 0xa5fffffffff5a414)
	EXT( 0xa5a5a5a5a5a5a413, 6, 39, 0x00000034b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a413, 6, 39, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a413, 274877906943, 6, 39, 0xa5fffffffffda413)
	EXT( 0xa5a5a5a5a5a5a412, 6, 40, 0x0000006969696969)
	EXTU(0xa5a5a5a5a5a5a412, 6, 40, 0x0000006969696969)
	DEP( 0xa5a5a5a5a5a5a412, 549755813887, 6, 40, 0xa5fffffffffda412)
	EXT( 0xa5a5a5a5a5a5a411, 6, 41, 0x000000d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a411, 6, 41, 0x000000d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a411, 1099511627775, 6, 41, 0xa5ffffffffffa411)
	EXT( 0xa5a5a5a5a5a5a410, 6, 42, 0x000001a5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a410, 6, 42, 0x000001a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a410, 2199023255551, 6, 42, 0xa5ffffffffffa410)
	EXT( 0xa5a5a5a5a5a5a40f, 6, 43, 0x0000034b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a40f, 6, 43, 0x0000034b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a40f, 4398046511103, 6, 43, 0xa5ffffffffffa40f)
	EXT( 0xa5a5a5a5a5a5a40e, 6, 44, 0x0000069696969696)
	EXTU(0xa5a5a5a5a5a5a40e, 6, 44, 0x0000069696969696)
	DEP( 0xa5a5a5a5a5a5a40e, 8796093022207, 6, 44, 0xa5ffffffffffe40e)
	EXT( 0xa5a5a5a5a5a5a40d, 6, 45, 0x00000d2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a40d, 6, 45, 0x00000d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a40d, 17592186044415, 6, 45, 0xa5ffffffffffe40d)
	EXT( 0xa5a5a5a5a5a5a40c, 6, 46, 0x00001a5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a40c, 6, 46, 0x00001a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a40c, 35184372088831, 6, 46, 0xa5fffffffffff40c)
	EXT( 0xa5a5a5a5a5a5a40b, 6, 47, 0x000034b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a40b, 6, 47, 0x000034b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a40b, 70368744177663, 6, 47, 0xa5fffffffffffc0b)
	EXT( 0xa5a5a5a5a5a5a40a, 6, 48, 0x0000696969696969)
	EXTU(0xa5a5a5a5a5a5a40a, 6, 48, 0x0000696969696969)
	DEP( 0xa5a5a5a5a5a5a40a, 140737488355327, 6, 48, 0xa5fffffffffffc0a)
	EXT( 0xa5a5a5a5a5a5a409, 6, 49, 0x0000d2d2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a409, 6, 49, 0x0000d2d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a409, 281474976710655, 6, 49, 0xa5fffffffffffe09)
	EXT( 0xa5a5a5a5a5a5a408, 6, 50, 0x0001a5a5a5a5a5a4)
	EXTU(0xa5a5a5a5a5a5a408, 6, 50, 0x0001a5a5a5a5a5a4)
	DEP( 0xa5a5a5a5a5a5a408, 562949953421311, 6, 50, 0xa5ffffffffffff08)
	EXT( 0xa5a5a5a5a5a5a407, 6, 51, 0x00034b4b4b4b4b48)
	EXTU(0xa5a5a5a5a5a5a407, 6, 51, 0x00034b4b4b4b4b48)
	DEP( 0xa5a5a5a5a5a5a407, 1125899906842623, 6, 51, 0xa5ffffffffffff87)
	EXT( 0xa5a5a5a5a5a5a406, 6, 52, 0x0006969696969690)
	EXTU(0xa5a5a5a5a5a5a406, 6, 52, 0x0006969696969690)
	DEP( 0xa5a5a5a5a5a5a406, 2251799813685247, 6, 52, 0xa5ffffffffffffc6)
	EXT( 0xa5a5a5a5a5a5a405, 6, 53, 0x000d2d2d2d2d2d20)
	EXTU(0xa5a5a5a5a5a5a405, 6, 53, 0x000d2d2d2d2d2d20)
	DEP( 0xa5a5a5a5a5a5a405, 4503599627370495, 6, 53, 0xa5ffffffffffffe5)
	EXT( 0xa5a5a5a5a5a5a404, 6, 54, 0x001a5a5a5a5a5a40)
	EXTU(0xa5a5a5a5a5a5a404, 6, 54, 0x001a5a5a5a5a5a40)
	DEP( 0xa5a5a5a5a5a5a404, 9007199254740991, 6, 54, 0xa5fffffffffffff4)
	EXT( 0xa5a5a5a5a5a5a403, 6, 55, 0x0034b4b4b4b4b480)
	EXTU(0xa5a5a5a5a5a5a403, 6, 55, 0x0034b4b4b4b4b480)
	DEP( 0xa5a5a5a5a5a5a403, 18014398509481983, 6, 55, 0xa5fffffffffffffb)
	EXT( 0xa5a5a5a5a5a5a402, 6, 56, 0x0069696969696900)
	EXTU(0xa5a5a5a5a5a5a402, 6, 56, 0x0069696969696900)
	DEP( 0xa5a5a5a5a5a5a402, 36028797018963967, 6, 56, 0xa5fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a401, 6, 57, 0x00d2d2d2d2d2d200)
	EXTU(0xa5a5a5a5a5a5a401, 6, 57, 0x00d2d2d2d2d2d200)
	DEP( 0xa5a5a5a5a5a5a401, 72057594037927935, 6, 57, 0xa5ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a400, 7, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a400, 7, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a400, 0, 7, 1, 0xa4a5a5a5a5a5a400)
	EXT( 0xa5a5a5a5a5a5a3ff, 7, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a3ff, 7, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a3ff, 1, 7, 2, 0xa4a5a5a5a5a5a3ff)
	EXT( 0xa5a5a5a5a5a5a3fe, 7, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a3fe, 7, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a3fe, 3, 7, 3, 0xa4e5a5a5a5a5a3fe)
	EXT( 0xa5a5a5a5a5a5a3fd, 7, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a3fd, 7, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a3fd, 7, 7, 4, 0xa4e5a5a5a5a5a3fd)
	EXT( 0xa5a5a5a5a5a5a3fc, 7, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a3fc, 7, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a3fc, 15, 7, 5, 0xa4f5a5a5a5a5a3fc)
	EXT( 0xa5a5a5a5a5a5a3fb, 7, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a3fb, 7, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a3fb, 31, 7, 6, 0xa4fda5a5a5a5a3fb)
	EXT( 0xa5a5a5a5a5a5a3fa, 7, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a3fa, 7, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a3fa, 63, 7, 7, 0xa4fda5a5a5a5a3fa)
	EXT( 0xa5a5a5a5a5a5a3f9, 7, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a3f9, 7, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a3f9, 127, 7, 8, 0xa4ffa5a5a5a5a3f9)
	EXT( 0xa5a5a5a5a5a5a3f8, 7, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a3f8, 7, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a3f8, 255, 7, 9, 0xa4ffa5a5a5a5a3f8)
	EXT( 0xa5a5a5a5a5a5a3f7, 7, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a3f7, 7, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a3f7, 511, 7, 10, 0xa4ffa5a5a5a5a3f7)
	EXT( 0xa5a5a5a5a5a5a3f6, 7, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a3f6, 7, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a3f6, 1023, 7, 11, 0xa4ffe5a5a5a5a3f6)
	EXT( 0xa5a5a5a5a5a5a3f5, 7, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a3f5, 7, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a3f5, 2047, 7, 12, 0xa4ffe5a5a5a5a3f5)
	EXT( 0xa5a5a5a5a5a5a3f4, 7, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a3f4, 7, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a3f4, 4095, 7, 13, 0xa4fff5a5a5a5a3f4)
	EXT( 0xa5a5a5a5a5a5a3f3, 7, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a3f3, 7, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a3f3, 8191, 7, 14, 0xa4fffda5a5a5a3f3)
	EXT( 0xa5a5a5a5a5a5a3f2, 7, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a3f2, 7, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a3f2, 16383, 7, 15, 0xa4fffda5a5a5a3f2)
	EXT( 0xa5a5a5a5a5a5a3f1, 7, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a3f1, 7, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a3f1, 32767, 7, 16, 0xa4ffffa5a5a5a3f1)
	EXT( 0xa5a5a5a5a5a5a3f0, 7, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a3f0, 7, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a3f0, 65535, 7, 17, 0xa4ffffa5a5a5a3f0)
	EXT( 0xa5a5a5a5a5a5a3ef, 7, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a3ef, 7, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a3ef, 131071, 7, 18, 0xa4ffffa5a5a5a3ef)
	EXT( 0xa5a5a5a5a5a5a3ee, 7, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a3ee, 7, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a3ee, 262143, 7, 19, 0xa4ffffe5a5a5a3ee)
	EXT( 0xa5a5a5a5a5a5a3ed, 7, 20, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a3ed, 7, 20, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a3ed, 524287, 7, 20, 0xa4ffffe5a5a5a3ed)
	EXT( 0xa5a5a5a5a5a5a3ec, 7, 21, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a3ec, 7, 21, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a3ec, 1048575, 7, 21, 0xa4fffff5a5a5a3ec)
	EXT( 0xa5a5a5a5a5a5a3eb, 7, 22, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a3eb, 7, 22, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a3eb, 2097151, 7, 22, 0xa4fffffda5a5a3eb)
	EXT( 0xa5a5a5a5a5a5a3ea, 7, 23, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a3ea, 7, 23, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a3ea, 4194303, 7, 23, 0xa4fffffda5a5a3ea)
	EXT( 0xa5a5a5a5a5a5a3e9, 7, 24, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a3e9, 7, 24, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a3e9, 8388607, 7, 24, 0xa4ffffffa5a5a3e9)
	EXT( 0xa5a5a5a5a5a5a3e8, 7, 25, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a3e8, 7, 25, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a3e8, 16777215, 7, 25, 0xa4ffffffa5a5a3e8)
	EXT( 0xa5a5a5a5a5a5a3e7, 7, 26, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a3e7, 7, 26, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a3e7, 33554431, 7, 26, 0xa4ffffffa5a5a3e7)
	EXT( 0xa5a5a5a5a5a5a3e6, 7, 27, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a3e6, 7, 27, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a3e6, 67108863, 7, 27, 0xa4ffffffe5a5a3e6)
	EXT( 0xa5a5a5a5a5a5a3e5, 7, 28, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a3e5, 7, 28, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a3e5, 134217727, 7, 28, 0xa4ffffffe5a5a3e5)
	EXT( 0xa5a5a5a5a5a5a3e4, 7, 29, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a3e4, 7, 29, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a3e4, 268435455, 7, 29, 0xa4fffffff5a5a3e4)
	EXT( 0xa5a5a5a5a5a5a3e3, 7, 30, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a3e3, 7, 30, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a3e3, 536870911, 7, 30, 0xa4fffffffda5a3e3)
	EXT( 0xa5a5a5a5a5a5a3e2, 7, 31, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a3e2, 7, 31, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a3e2, 1073741823, 7, 31, 0xa4fffffffda5a3e2)
	EXT( 0xa5a5a5a5a5a5a3e1, 7, 32, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a3e1, 7, 32, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a3e1, 2147483647, 7, 32, 0xa4ffffffffa5a3e1)
	EXT( 0xa5a5a5a5a5a5a3e0, 7, 33, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a3e0, 7, 33, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a3e0, 4294967295, 7, 33, 0xa4ffffffffa5a3e0)
	EXT( 0xa5a5a5a5a5a5a3df, 7, 34, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a3df, 7, 34, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a3df, 8589934591, 7, 34, 0xa4ffffffffa5a3df)
	EXT( 0xa5a5a5a5a5a5a3de, 7, 35, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a3de, 7, 35, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a3de, 17179869183, 7, 35, 0xa4ffffffffe5a3de)
	EXT( 0xa5a5a5a5a5a5a3dd, 7, 36, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a3dd, 7, 36, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a3dd, 34359738367, 7, 36, 0xa4ffffffffe5a3dd)
	EXT( 0xa5a5a5a5a5a5a3dc, 7, 37, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a3dc, 7, 37, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a3dc, 68719476735, 7, 37, 0xa4fffffffff5a3dc)
	EXT( 0xa5a5a5a5a5a5a3db, 7, 38, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a3db, 7, 38, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a3db, 137438953471, 7, 38, 0xa4fffffffffda3db)
	EXT( 0xa5a5a5a5a5a5a3da, 7, 39, 0xffffffe969696969)
	EXTU(0xa5a5a5a5a5a5a3da, 7, 39, 0x0000006969696969)
	DEP( 0xa5a5a5a5a5a5a3da, 274877906943, 7, 39, 0xa4fffffffffda3da)
	EXT( 0xa5a5a5a5a5a5a3d9, 7, 40, 0xffffffd2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a3d9, 7, 40, 0x000000d2d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a3d9, 549755813887, 7, 40, 0xa4ffffffffffa3d9)
	EXT( 0xa5a5a5a5a5a5a3d8, 7, 41, 0xffffffa5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a3d8, 7, 41, 0x000001a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a3d8, 1099511627775, 7, 41, 0xa4ffffffffffa3d8)
	EXT( 0xa5a5a5a5a5a5a3d7, 7, 42, 0xffffff4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a3d7, 7, 42, 0x0000034b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a3d7, 2199023255551, 7, 42, 0xa4ffffffffffa3d7)
	EXT( 0xa5a5a5a5a5a5a3d6, 7, 43, 0xfffffe9696969696)
	EXTU(0xa5a5a5a5a5a5a3d6, 7, 43, 0x0000069696969696)
	DEP( 0xa5a5a5a5a5a5a3d6, 4398046511103, 7, 43, 0xa4ffffffffffe3d6)
	EXT( 0xa5a5a5a5a5a5a3d5, 7, 44, 0xfffffd2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a3d5, 7, 44, 0x00000d2d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a3d5, 8796093022207, 7, 44, 0xa4ffffffffffe3d5)
	EXT( 0xa5a5a5a5a5a5a3d4, 7, 45, 0xfffffa5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a3d4, 7, 45, 0x00001a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a3d4, 17592186044415, 7, 45, 0xa4fffffffffff3d4)
	EXT( 0xa5a5a5a5a5a5a3d3, 7, 46, 0xfffff4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a3d3, 7, 46, 0x000034b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a3d3, 35184372088831, 7, 46, 0xa4fffffffffffbd3)
	EXT( 0xa5a5a5a5a5a5a3d2, 7, 47, 0xffffe96969696968)
	EXTU(0xa5a5a5a5a5a5a3d2, 7, 47, 0x0000696969696968)
	DEP( 0xa5a5a5a5a5a5a3d2, 70368744177663, 7, 47, 0xa4ffffffffffffd2)
	EXT( 0xa5a5a5a5a5a5a3d1, 7, 48, 0xffffd2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a3d1, 7, 48, 0x0000d2d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a3d1, 140737488355327, 7, 48, 0xa4ffffffffffffd1)
	EXT( 0xa5a5a5a5a5a5a3d0, 7, 49, 0xffffa5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a3d0, 7, 49, 0x0001a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a3d0, 281474976710655, 7, 49, 0xa4ffffffffffffd0)
	EXT( 0xa5a5a5a5a5a5a3cf, 7, 50, 0xffff4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a3cf, 7, 50, 0x00034b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a3cf, 562949953421311, 7, 50, 0xa4ffffffffffffcf)
	EXT( 0xa5a5a5a5a5a5a3ce, 7, 51, 0xfffe96969696968f)
	EXTU(0xa5a5a5a5a5a5a3ce, 7, 51, 0x000696969696968f)
	DEP( 0xa5a5a5a5a5a5a3ce, 1125899906842623, 7, 51, 0xa4ffffffffffffce)
	EXT( 0xa5a5a5a5a5a5a3cd, 7, 52, 0xfffd2d2d2d2d2d1e)
	EXTU(0xa5a5a5a5a5a5a3cd, 7, 52, 0x000d2d2d2d2d2d1e)
	DEP( 0xa5a5a5a5a5a5a3cd, 2251799813685247, 7, 52, 0xa4ffffffffffffed)
	EXT( 0xa5a5a5a5a5a5a3cc, 7, 53, 0xfffa5a5a5a5a5a3c)
	EXTU(0xa5a5a5a5a5a5a3cc, 7, 53, 0x001a5a5a5a5a5a3c)
	DEP( 0xa5a5a5a5a5a5a3cc, 4503599627370495, 7, 53, 0xa4fffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a3cb, 7, 54, 0xfff4b4b4b4b4b479)
	EXTU(0xa5a5a5a5a5a5a3cb, 7, 54, 0x0034b4b4b4b4b479)
	DEP( 0xa5a5a5a5a5a5a3cb, 9007199254740991, 7, 54, 0xa4fffffffffffffb)
	EXT( 0xa5a5a5a5a5a5a3ca, 7, 55, 0xffe96969696968f2)
	EXTU(0xa5a5a5a5a5a5a3ca, 7, 55, 0x00696969696968f2)
	DEP( 0xa5a5a5a5a5a5a3ca, 18014398509481983, 7, 55, 0xa4fffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a3c9, 7, 56, 0xffd2d2d2d2d2d1e4)
	EXTU(0xa5a5a5a5a5a5a3c9, 7, 56, 0x00d2d2d2d2d2d1e4)
	DEP( 0xa5a5a5a5a5a5a3c9, 36028797018963967, 7, 56, 0xa4ffffffffffffff)
	EXT( 0xa5a5a5a5a5a5a3c8, 8, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a3c8, 8, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a3c8, 0, 8, 1, 0xa525a5a5a5a5a3c8)
	EXT( 0xa5a5a5a5a5a5a3c7, 8, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a3c7, 8, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a3c7, 1, 8, 2, 0xa565a5a5a5a5a3c7)
	EXT( 0xa5a5a5a5a5a5a3c6, 8, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a3c6, 8, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a3c6, 3, 8, 3, 0xa565a5a5a5a5a3c6)
	EXT( 0xa5a5a5a5a5a5a3c5, 8, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a3c5, 8, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a3c5, 7, 8, 4, 0xa575a5a5a5a5a3c5)
	EXT( 0xa5a5a5a5a5a5a3c4, 8, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a3c4, 8, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a5a3c4, 15, 8, 5, 0xa57da5a5a5a5a3c4)
	EXT( 0xa5a5a5a5a5a5a3c3, 8, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a3c3, 8, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a5a3c3, 31, 8, 6, 0xa57da5a5a5a5a3c3)
	EXT( 0xa5a5a5a5a5a5a3c2, 8, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a3c2, 8, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a5a3c2, 63, 8, 7, 0xa57fa5a5a5a5a3c2)
	EXT( 0xa5a5a5a5a5a5a3c1, 8, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a3c1, 8, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a5a3c1, 127, 8, 8, 0xa57fa5a5a5a5a3c1)
	EXT( 0xa5a5a5a5a5a5a3c0, 8, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a3c0, 8, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a5a3c0, 255, 8, 9, 0xa57fa5a5a5a5a3c0)
	EXT( 0xa5a5a5a5a5a5a3bf, 8, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a3bf, 8, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a5a3bf, 511, 8, 10, 0xa57fe5a5a5a5a3bf)
	EXT( 0xa5a5a5a5a5a5a3be, 8, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a3be, 8, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a5a3be, 1023, 8, 11, 0xa57fe5a5a5a5a3be)
	EXT( 0xa5a5a5a5a5a5a3bd, 8, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a3bd, 8, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a5a3bd, 2047, 8, 12, 0xa57ff5a5a5a5a3bd)
	EXT( 0xa5a5a5a5a5a5a3bc, 8, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a3bc, 8, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a5a3bc, 4095, 8, 13, 0xa57ffda5a5a5a3bc)
	EXT( 0xa5a5a5a5a5a5a3bb, 8, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a3bb, 8, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a5a3bb, 8191, 8, 14, 0xa57ffda5a5a5a3bb)
	EXT( 0xa5a5a5a5a5a5a3ba, 8, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a3ba, 8, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a5a3ba, 16383, 8, 15, 0xa57fffa5a5a5a3ba)
	EXT( 0xa5a5a5a5a5a5a3b9, 8, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a3b9, 8, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a5a3b9, 32767, 8, 16, 0xa57fffa5a5a5a3b9)
	EXT( 0xa5a5a5a5a5a5a3b8, 8, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a3b8, 8, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a5a3b8, 65535, 8, 17, 0xa57fffa5a5a5a3b8)
	EXT( 0xa5a5a5a5a5a5a3b7, 8, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a3b7, 8, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a5a3b7, 131071, 8, 18, 0xa57fffe5a5a5a3b7)
	EXT( 0xa5a5a5a5a5a5a3b6, 8, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a3b6, 8, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a5a3b6, 262143, 8, 19, 0xa57fffe5a5a5a3b6)
	EXT( 0xa5a5a5a5a5a5a3b5, 8, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a3b5, 8, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a5a3b5, 524287, 8, 20, 0xa57ffff5a5a5a3b5)
	EXT( 0xa5a5a5a5a5a5a3b4, 8, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a3b4, 8, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a5a3b4, 1048575, 8, 21, 0xa57ffffda5a5a3b4)
	EXT( 0xa5a5a5a5a5a5a3b3, 8, 22, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a3b3, 8, 22, 0x0000000000296969)
	DEP( 0xa5a5a5a5a5a5a3b3, 2097151, 8, 22, 0xa57ffffda5a5a3b3)
	EXT( 0xa5a5a5a5a5a5a3b2, 8, 23, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a3b2, 8, 23, 0x000000000052d2d2)
	DEP( 0xa5a5a5a5a5a5a3b2, 4194303, 8, 23, 0xa57fffffa5a5a3b2)
	EXT( 0xa5a5a5a5a5a5a3b1, 8, 24, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a3b1, 8, 24, 0x0000000000a5a5a5)
	DEP( 0xa5a5a5a5a5a5a3b1, 8388607, 8, 24, 0xa57fffffa5a5a3b1)
	EXT( 0xa5a5a5a5a5a5a3b0, 8, 25, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a3b0, 8, 25, 0x00000000014b4b4b)
	DEP( 0xa5a5a5a5a5a5a3b0, 16777215, 8, 25, 0xa57fffffa5a5a3b0)
	EXT( 0xa5a5a5a5a5a5a3af, 8, 26, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a3af, 8, 26, 0x0000000002969696)
	DEP( 0xa5a5a5a5a5a5a3af, 33554431, 8, 26, 0xa57fffffe5a5a3af)
	EXT( 0xa5a5a5a5a5a5a3ae, 8, 27, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a3ae, 8, 27, 0x00000000052d2d2d)
	DEP( 0xa5a5a5a5a5a5a3ae, 67108863, 8, 27, 0xa57fffffe5a5a3ae)
	EXT( 0xa5a5a5a5a5a5a3ad, 8, 28, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a3ad, 8, 28, 0x000000000a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a3ad, 134217727, 8, 28, 0xa57ffffff5a5a3ad)
	EXT( 0xa5a5a5a5a5a5a3ac, 8, 29, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a3ac, 8, 29, 0x0000000014b4b4b4)
	DEP( 0xa5a5a5a5a5a5a3ac, 268435455, 8, 29, 0xa57ffffffda5a3ac)
	EXT( 0xa5a5a5a5a5a5a3ab, 8, 30, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a3ab, 8, 30, 0x0000000029696969)
	DEP( 0xa5a5a5a5a5a5a3ab, 536870911, 8, 30, 0xa57ffffffda5a3ab)
	EXT( 0xa5a5a5a5a5a5a3aa, 8, 31, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a3aa, 8, 31, 0x0000000052d2d2d2)
	DEP( 0xa5a5a5a5a5a5a3aa, 1073741823, 8, 31, 0xa57fffffffa5a3aa)
	EXT( 0xa5a5a5a5a5a5a3a9, 8, 32, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a3a9, 8, 32, 0x00000000a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a3a9, 2147483647, 8, 32, 0xa57fffffffa5a3a9)
	EXT( 0xa5a5a5a5a5a5a3a8, 8, 33, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a3a8, 8, 33, 0x000000014b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a3a8, 4294967295, 8, 33, 0xa57fffffffa5a3a8)
	EXT( 0xa5a5a5a5a5a5a3a7, 8, 34, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a3a7, 8, 34, 0x0000000296969696)
	DEP( 0xa5a5a5a5a5a5a3a7, 8589934591, 8, 34, 0xa57fffffffe5a3a7)
	EXT( 0xa5a5a5a5a5a5a3a6, 8, 35, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a3a6, 8, 35, 0x000000052d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a3a6, 17179869183, 8, 35, 0xa57fffffffe5a3a6)
	EXT( 0xa5a5a5a5a5a5a3a5, 8, 36, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a3a5, 8, 36, 0x0000000a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a3a5, 34359738367, 8, 36, 0xa57ffffffff5a3a5)
	EXT( 0xa5a5a5a5a5a5a3a4, 8, 37, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a3a4, 8, 37, 0x00000014b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a3a4, 68719476735, 8, 37, 0xa57ffffffffda3a4)
	EXT( 0xa5a5a5a5a5a5a3a3, 8, 38, 0xffffffe969696969)
	EXTU(0xa5a5a5a5a5a5a3a3, 8, 38, 0x0000002969696969)
	DEP( 0xa5a5a5a5a5a5a3a3, 137438953471, 8, 38, 0xa57ffffffffda3a3)
	EXT( 0xa5a5a5a5a5a5a3a2, 8, 39, 0xffffffd2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a3a2, 8, 39, 0x00000052d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a3a2, 274877906943, 8, 39, 0xa57fffffffffa3a2)
	EXT( 0xa5a5a5a5a5a5a3a1, 8, 40, 0xffffffa5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a3a1, 8, 40, 0x000000a5a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a3a1, 549755813887, 8, 40, 0xa57fffffffffa3a1)
	EXT( 0xa5a5a5a5a5a5a3a0, 8, 41, 0xffffff4b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a3a0, 8, 41, 0x0000014b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a3a0, 1099511627775, 8, 41, 0xa57fffffffffa3a0)
	EXT( 0xa5a5a5a5a5a5a39f, 8, 42, 0xfffffe9696969696)
	EXTU(0xa5a5a5a5a5a5a39f, 8, 42, 0x0000029696969696)
	DEP( 0xa5a5a5a5a5a5a39f, 2199023255551, 8, 42, 0xa57fffffffffe39f)
	EXT( 0xa5a5a5a5a5a5a39e, 8, 43, 0xfffffd2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a39e, 8, 43, 0x0000052d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a39e, 4398046511103, 8, 43, 0xa57fffffffffe39e)
	EXT( 0xa5a5a5a5a5a5a39d, 8, 44, 0xfffffa5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a39d, 8, 44, 0x00000a5a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a39d, 8796093022207, 8, 44, 0xa57ffffffffff39d)
	EXT( 0xa5a5a5a5a5a5a39c, 8, 45, 0xfffff4b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a39c, 8, 45, 0x000014b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a39c, 17592186044415, 8, 45, 0xa57ffffffffffb9c)
	EXT( 0xa5a5a5a5a5a5a39b, 8, 46, 0xffffe96969696968)
	EXTU(0xa5a5a5a5a5a5a39b, 8, 46, 0x0000296969696968)
	DEP( 0xa5a5a5a5a5a5a39b, 35184372088831, 8, 46, 0xa57fffffffffff9b)
	EXT( 0xa5a5a5a5a5a5a39a, 8, 47, 0xffffd2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a39a, 8, 47, 0x000052d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a39a, 70368744177663, 8, 47, 0xa57fffffffffff9a)
	EXT( 0xa5a5a5a5a5a5a399, 8, 48, 0xffffa5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a399, 8, 48, 0x0000a5a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a399, 140737488355327, 8, 48, 0xa57fffffffffff99)
	EXT( 0xa5a5a5a5a5a5a398, 8, 49, 0xffff4b4b4b4b4b47)
	EXTU(0xa5a5a5a5a5a5a398, 8, 49, 0x00014b4b4b4b4b47)
	DEP( 0xa5a5a5a5a5a5a398, 281474976710655, 8, 49, 0xa57fffffffffff98)
	EXT( 0xa5a5a5a5a5a5a397, 8, 50, 0xfffe96969696968e)
	EXTU(0xa5a5a5a5a5a5a397, 8, 50, 0x000296969696968e)
	DEP( 0xa5a5a5a5a5a5a397, 562949953421311, 8, 50, 0xa57fffffffffffd7)
	EXT( 0xa5a5a5a5a5a5a396, 8, 51, 0xfffd2d2d2d2d2d1c)
	EXTU(0xa5a5a5a5a5a5a396, 8, 51, 0x00052d2d2d2d2d1c)
	DEP( 0xa5a5a5a5a5a5a396, 1125899906842623, 8, 51, 0xa57ffffffffffff6)
	EXT( 0xa5a5a5a5a5a5a395, 8, 52, 0xfffa5a5a5a5a5a39)
	EXTU(0xa5a5a5a5a5a5a395, 8, 52, 0x000a5a5a5a5a5a39)
	DEP( 0xa5a5a5a5a5a5a395, 2251799813685247, 8, 52, 0xa57ffffffffffff5)
	EXT( 0xa5a5a5a5a5a5a394, 8, 53, 0xfff4b4b4b4b4b472)
	EXTU(0xa5a5a5a5a5a5a394, 8, 53, 0x0014b4b4b4b4b472)
	DEP( 0xa5a5a5a5a5a5a394, 4503599627370495, 8, 53, 0xa57ffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a393, 8, 54, 0xffe96969696968e4)
	EXTU(0xa5a5a5a5a5a5a393, 8, 54, 0x00296969696968e4)
	DEP( 0xa5a5a5a5a5a5a393, 9007199254740991, 8, 54, 0xa57fffffffffffff)
	EXT( 0xa5a5a5a5a5a5a392, 8, 55, 0xffd2d2d2d2d2d1c9)
	EXTU(0xa5a5a5a5a5a5a392, 8, 55, 0x0052d2d2d2d2d1c9)
	DEP( 0xa5a5a5a5a5a5a392, 18014398509481983, 8, 55, 0xa57ffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a391, 9, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a391, 9, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a391, 0, 9, 1, 0xa5a5a5a5a5a5a391)
	EXT( 0xa5a5a5a5a5a5a390, 9, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a390, 9, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a390, 1, 9, 2, 0xa5a5a5a5a5a5a390)
	EXT( 0xa5a5a5a5a5a5a38f, 9, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a38f, 9, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a38f, 3, 9, 3, 0xa5b5a5a5a5a5a38f)
	EXT( 0xa5a5a5a5a5a5a38e, 9, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a5a38e, 9, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a38e, 7, 9, 4, 0xa5bda5a5a5a5a38e)
	EXT( 0xa5a5a5a5a5a5a38d, 9, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a5a38d, 9, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a38d, 15, 9, 5, 0xa5bda5a5a5a5a38d)
	EXT( 0xa5a5a5a5a5a5a38c, 9, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a5a38c, 9, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a38c, 31, 9, 6, 0xa5bfa5a5a5a5a38c)
	EXT( 0xa5a5a5a5a5a5a38b, 9, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a5a38b, 9, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a38b, 63, 9, 7, 0xa5bfa5a5a5a5a38b)
	EXT( 0xa5a5a5a5a5a5a38a, 9, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a5a38a, 9, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a38a, 127, 9, 8, 0xa5bfa5a5a5a5a38a)
	EXT( 0xa5a5a5a5a5a5a389, 9, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a5a389, 9, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a389, 255, 9, 9, 0xa5bfe5a5a5a5a389)
	EXT( 0xa5a5a5a5a5a5a388, 9, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a5a388, 9, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a388, 511, 9, 10, 0xa5bfe5a5a5a5a388)
	EXT( 0xa5a5a5a5a5a5a387, 9, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a5a387, 9, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a387, 1023, 9, 11, 0xa5bff5a5a5a5a387)
	EXT( 0xa5a5a5a5a5a5a386, 9, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a5a386, 9, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a386, 2047, 9, 12, 0xa5bffda5a5a5a386)
	EXT( 0xa5a5a5a5a5a5a385, 9, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a5a385, 9, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a385, 4095, 9, 13, 0xa5bffda5a5a5a385)
	EXT( 0xa5a5a5a5a5a5a384, 9, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a5a384, 9, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a384, 8191, 9, 14, 0xa5bfffa5a5a5a384)
	EXT( 0xa5a5a5a5a5a5a383, 9, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a5a383, 9, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a383, 16383, 9, 15, 0xa5bfffa5a5a5a383)
	EXT( 0xa5a5a5a5a5a5a382, 9, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a5a382, 9, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a382, 32767, 9, 16, 0xa5bfffa5a5a5a382)
	EXT( 0xa5a5a5a5a5a5a381, 9, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a5a381, 9, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a381, 65535, 9, 17, 0xa5bfffe5a5a5a381)
	EXT( 0xa5a5a5a5a5a5a380, 9, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a5a380, 9, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a380, 131071, 9, 18, 0xa5bfffe5a5a5a380)
	EXT( 0xa5a5a5a5a5a5a37f, 9, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a5a37f, 9, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a37f, 262143, 9, 19, 0xa5bffff5a5a5a37f)
	EXT( 0xa5a5a5a5a5a5a37e, 9, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a5a37e, 9, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a37e, 524287, 9, 20, 0xa5bffffda5a5a37e)
	EXT( 0xa5a5a5a5a5a5a37d, 9, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a5a37d, 9, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a37d, 1048575, 9, 21, 0xa5bffffda5a5a37d)
	EXT( 0xa5a5a5a5a5a5a37c, 9, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a5a37c, 9, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a37c, 2097151, 9, 22, 0xa5bfffffa5a5a37c)
	EXT( 0xa5a5a5a5a5a5a37b, 9, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a5a37b, 9, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a37b, 4194303, 9, 23, 0xa5bfffffa5a5a37b)
	EXT( 0xa5a5a5a5a5a5a37a, 9, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a5a37a, 9, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a37a, 8388607, 9, 24, 0xa5bfffffa5a5a37a)
	EXT( 0xa5a5a5a5a5a5a379, 9, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a5a379, 9, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a379, 16777215, 9, 25, 0xa5bfffffe5a5a379)
	EXT( 0xa5a5a5a5a5a5a378, 9, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a5a378, 9, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a378, 33554431, 9, 26, 0xa5bfffffe5a5a378)
	EXT( 0xa5a5a5a5a5a5a377, 9, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a5a377, 9, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a377, 67108863, 9, 27, 0xa5bffffff5a5a377)
	EXT( 0xa5a5a5a5a5a5a376, 9, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a5a376, 9, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a376, 134217727, 9, 28, 0xa5bffffffda5a376)
	EXT( 0xa5a5a5a5a5a5a375, 9, 29, 0x0000000009696969)
	EXTU(0xa5a5a5a5a5a5a375, 9, 29, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a375, 268435455, 9, 29, 0xa5bffffffda5a375)
	EXT( 0xa5a5a5a5a5a5a374, 9, 30, 0x0000000012d2d2d2)
	EXTU(0xa5a5a5a5a5a5a374, 9, 30, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a374, 536870911, 9, 30, 0xa5bfffffffa5a374)
	EXT( 0xa5a5a5a5a5a5a373, 9, 31, 0x0000000025a5a5a5)
	EXTU(0xa5a5a5a5a5a5a373, 9, 31, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a373, 1073741823, 9, 31, 0xa5bfffffffa5a373)
	EXT( 0xa5a5a5a5a5a5a372, 9, 32, 0x000000004b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a372, 9, 32, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a372, 2147483647, 9, 32, 0xa5bfffffffa5a372)
	EXT( 0xa5a5a5a5a5a5a371, 9, 33, 0x0000000096969696)
	EXTU(0xa5a5a5a5a5a5a371, 9, 33, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a371, 4294967295, 9, 33, 0xa5bfffffffe5a371)
	EXT( 0xa5a5a5a5a5a5a370, 9, 34, 0x000000012d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a370, 9, 34, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a370, 8589934591, 9, 34, 0xa5bfffffffe5a370)
	EXT( 0xa5a5a5a5a5a5a36f, 9, 35, 0x000000025a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a36f, 9, 35, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a36f, 17179869183, 9, 35, 0xa5bffffffff5a36f)
	EXT( 0xa5a5a5a5a5a5a36e, 9, 36, 0x00000004b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a36e, 9, 36, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a36e, 34359738367, 9, 36, 0xa5bffffffffda36e)
	EXT( 0xa5a5a5a5a5a5a36d, 9, 37, 0x0000000969696969)
	EXTU(0xa5a5a5a5a5a5a36d, 9, 37, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a36d, 68719476735, 9, 37, 0xa5bffffffffda36d)
	EXT( 0xa5a5a5a5a5a5a36c, 9, 38, 0x00000012d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a36c, 9, 38, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a36c, 137438953471, 9, 38, 0xa5bfffffffffa36c)
	EXT( 0xa5a5a5a5a5a5a36b, 9, 39, 0x00000025a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a36b, 9, 39, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a36b, 274877906943, 9, 39, 0xa5bfffffffffa36b)
	EXT( 0xa5a5a5a5a5a5a36a, 9, 40, 0x0000004b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a36a, 9, 40, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a36a, 549755813887, 9, 40, 0xa5bfffffffffa36a)
	EXT( 0xa5a5a5a5a5a5a369, 9, 41, 0x0000009696969696)
	EXTU(0xa5a5a5a5a5a5a369, 9, 41, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a369, 1099511627775, 9, 41, 0xa5bfffffffffe369)
	EXT( 0xa5a5a5a5a5a5a368, 9, 42, 0x0000012d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a368, 9, 42, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a368, 2199023255551, 9, 42, 0xa5bfffffffffe368)
	EXT( 0xa5a5a5a5a5a5a367, 9, 43, 0x0000025a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a367, 9, 43, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a367, 4398046511103, 9, 43, 0xa5bffffffffff367)
	EXT( 0xa5a5a5a5a5a5a366, 9, 44, 0x000004b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a366, 9, 44, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a366, 8796093022207, 9, 44, 0xa5bffffffffffb66)
	EXT( 0xa5a5a5a5a5a5a365, 9, 45, 0x0000096969696968)
	EXTU(0xa5a5a5a5a5a5a365, 9, 45, 0x0000096969696968)
	DEP( 0xa5a5a5a5a5a5a365, 17592186044415, 9, 45, 0xa5bfffffffffff65)
	EXT( 0xa5a5a5a5a5a5a364, 9, 46, 0x000012d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a364, 9, 46, 0x000012d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a364, 35184372088831, 9, 46, 0xa5bfffffffffff64)
	EXT( 0xa5a5a5a5a5a5a363, 9, 47, 0x000025a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a363, 9, 47, 0x000025a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a363, 70368744177663, 9, 47, 0xa5bfffffffffff63)
	EXT( 0xa5a5a5a5a5a5a362, 9, 48, 0x00004b4b4b4b4b46)
	EXTU(0xa5a5a5a5a5a5a362, 9, 48, 0x00004b4b4b4b4b46)
	DEP( 0xa5a5a5a5a5a5a362, 140737488355327, 9, 48, 0xa5bfffffffffffe2)
	EXT( 0xa5a5a5a5a5a5a361, 9, 49, 0x000096969696968d)
	EXTU(0xa5a5a5a5a5a5a361, 9, 49, 0x000096969696968d)
	DEP( 0xa5a5a5a5a5a5a361, 281474976710655, 9, 49, 0xa5bfffffffffffe1)
	EXT( 0xa5a5a5a5a5a5a360, 9, 50, 0x00012d2d2d2d2d1b)
	EXTU(0xa5a5a5a5a5a5a360, 9, 50, 0x00012d2d2d2d2d1b)
	DEP( 0xa5a5a5a5a5a5a360, 562949953421311, 9, 50, 0xa5bfffffffffffe0)
	EXT( 0xa5a5a5a5a5a5a35f, 9, 51, 0x00025a5a5a5a5a35)
	EXTU(0xa5a5a5a5a5a5a35f, 9, 51, 0x00025a5a5a5a5a35)
	DEP( 0xa5a5a5a5a5a5a35f, 1125899906842623, 9, 51, 0xa5bfffffffffffff)
	EXT( 0xa5a5a5a5a5a5a35e, 9, 52, 0x0004b4b4b4b4b46b)
	EXTU(0xa5a5a5a5a5a5a35e, 9, 52, 0x0004b4b4b4b4b46b)
	DEP( 0xa5a5a5a5a5a5a35e, 2251799813685247, 9, 52, 0xa5bffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a35d, 9, 53, 0x00096969696968d7)
	EXTU(0xa5a5a5a5a5a5a35d, 9, 53, 0x00096969696968d7)
	DEP( 0xa5a5a5a5a5a5a35d, 4503599627370495, 9, 53, 0xa5bffffffffffffd)
	EXT( 0xa5a5a5a5a5a5a35c, 9, 54, 0x0012d2d2d2d2d1ae)
	EXTU(0xa5a5a5a5a5a5a35c, 9, 54, 0x0012d2d2d2d2d1ae)
	DEP( 0xa5a5a5a5a5a5a35c, 9007199254740991, 9, 54, 0xa5bffffffffffffe)
	EXT( 0xa5a5a5a5a5a5a35b, 10, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a35b, 10, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a35b, 0, 10, 1, 0xa585a5a5a5a5a35b)
	EXT( 0xa5a5a5a5a5a5a35a, 10, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a35a, 10, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a35a, 1, 10, 2, 0xa595a5a5a5a5a35a)
	EXT( 0xa5a5a5a5a5a5a359, 10, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a359, 10, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a359, 3, 10, 3, 0xa59da5a5a5a5a359)
	EXT( 0xa5a5a5a5a5a5a358, 10, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a5a358, 10, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a358, 7, 10, 4, 0xa59da5a5a5a5a358)
	EXT( 0xa5a5a5a5a5a5a357, 10, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a5a357, 10, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a357, 15, 10, 5, 0xa59fa5a5a5a5a357)
	EXT( 0xa5a5a5a5a5a5a356, 10, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a5a356, 10, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a356, 31, 10, 6, 0xa59fa5a5a5a5a356)
	EXT( 0xa5a5a5a5a5a5a355, 10, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a5a355, 10, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a355, 63, 10, 7, 0xa59fa5a5a5a5a355)
	EXT( 0xa5a5a5a5a5a5a354, 10, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a5a354, 10, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a354, 127, 10, 8, 0xa59fe5a5a5a5a354)
	EXT( 0xa5a5a5a5a5a5a353, 10, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a5a353, 10, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a353, 255, 10, 9, 0xa59fe5a5a5a5a353)
	EXT( 0xa5a5a5a5a5a5a352, 10, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a5a352, 10, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a352, 511, 10, 10, 0xa59ff5a5a5a5a352)
	EXT( 0xa5a5a5a5a5a5a351, 10, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a5a351, 10, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a351, 1023, 10, 11, 0xa59ffda5a5a5a351)
	EXT( 0xa5a5a5a5a5a5a350, 10, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a5a350, 10, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a350, 2047, 10, 12, 0xa59ffda5a5a5a350)
	EXT( 0xa5a5a5a5a5a5a34f, 10, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a5a34f, 10, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a34f, 4095, 10, 13, 0xa59fffa5a5a5a34f)
	EXT( 0xa5a5a5a5a5a5a34e, 10, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a5a34e, 10, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a34e, 8191, 10, 14, 0xa59fffa5a5a5a34e)
	EXT( 0xa5a5a5a5a5a5a34d, 10, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a5a34d, 10, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a34d, 16383, 10, 15, 0xa59fffa5a5a5a34d)
	EXT( 0xa5a5a5a5a5a5a34c, 10, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a5a34c, 10, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a34c, 32767, 10, 16, 0xa59fffe5a5a5a34c)
	EXT( 0xa5a5a5a5a5a5a34b, 10, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a5a34b, 10, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a34b, 65535, 10, 17, 0xa59fffe5a5a5a34b)
	EXT( 0xa5a5a5a5a5a5a34a, 10, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a5a34a, 10, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a34a, 131071, 10, 18, 0xa59ffff5a5a5a34a)
	EXT( 0xa5a5a5a5a5a5a349, 10, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a5a349, 10, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a349, 262143, 10, 19, 0xa59ffffda5a5a349)
	EXT( 0xa5a5a5a5a5a5a348, 10, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a5a348, 10, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a348, 524287, 10, 20, 0xa59ffffda5a5a348)
	EXT( 0xa5a5a5a5a5a5a347, 10, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a5a347, 10, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a347, 1048575, 10, 21, 0xa59fffffa5a5a347)
	EXT( 0xa5a5a5a5a5a5a346, 10, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a5a346, 10, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a346, 2097151, 10, 22, 0xa59fffffa5a5a346)
	EXT( 0xa5a5a5a5a5a5a345, 10, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a5a345, 10, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a345, 4194303, 10, 23, 0xa59fffffa5a5a345)
	EXT( 0xa5a5a5a5a5a5a344, 10, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a5a344, 10, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a344, 8388607, 10, 24, 0xa59fffffe5a5a344)
	EXT( 0xa5a5a5a5a5a5a343, 10, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a5a343, 10, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a343, 16777215, 10, 25, 0xa59fffffe5a5a343)
	EXT( 0xa5a5a5a5a5a5a342, 10, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a5a342, 10, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a342, 33554431, 10, 26, 0xa59ffffff5a5a342)
	EXT( 0xa5a5a5a5a5a5a341, 10, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a5a341, 10, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a341, 67108863, 10, 27, 0xa59ffffffda5a341)
	EXT( 0xa5a5a5a5a5a5a340, 10, 28, 0xfffffffff9696969)
	EXTU(0xa5a5a5a5a5a5a340, 10, 28, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a340, 134217727, 10, 28, 0xa59ffffffda5a340)
	EXT( 0xa5a5a5a5a5a5a33f, 10, 29, 0xfffffffff2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a33f, 10, 29, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a33f, 268435455, 10, 29, 0xa59fffffffa5a33f)
	EXT( 0xa5a5a5a5a5a5a33e, 10, 30, 0xffffffffe5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a33e, 10, 30, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a33e, 536870911, 10, 30, 0xa59fffffffa5a33e)
	EXT( 0xa5a5a5a5a5a5a33d, 10, 31, 0xffffffffcb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a33d, 10, 31, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a33d, 1073741823, 10, 31, 0xa59fffffffa5a33d)
	EXT( 0xa5a5a5a5a5a5a33c, 10, 32, 0xffffffff96969696)
	EXTU(0xa5a5a5a5a5a5a33c, 10, 32, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a33c, 2147483647, 10, 32, 0xa59fffffffe5a33c)
	EXT( 0xa5a5a5a5a5a5a33b, 10, 33, 0xffffffff2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a33b, 10, 33, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a33b, 4294967295, 10, 33, 0xa59fffffffe5a33b)
	EXT( 0xa5a5a5a5a5a5a33a, 10, 34, 0xfffffffe5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a33a, 10, 34, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a33a, 8589934591, 10, 34, 0xa59ffffffff5a33a)
	EXT( 0xa5a5a5a5a5a5a339, 10, 35, 0xfffffffcb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a339, 10, 35, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a339, 17179869183, 10, 35, 0xa59ffffffffda339)
	EXT( 0xa5a5a5a5a5a5a338, 10, 36, 0xfffffff969696969)
	EXTU(0xa5a5a5a5a5a5a338, 10, 36, 0x0000000969696969)
	DEP( 0xa5a5a5a5a5a5a338, 34359738367, 10, 36, 0xa59ffffffffda338)
	EXT( 0xa5a5a5a5a5a5a337, 10, 37, 0xfffffff2d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a337, 10, 37, 0x00000012d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a337, 68719476735, 10, 37, 0xa59fffffffffa337)
	EXT( 0xa5a5a5a5a5a5a336, 10, 38, 0xffffffe5a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a336, 10, 38, 0x00000025a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a336, 137438953471, 10, 38, 0xa59fffffffffa336)
	EXT( 0xa5a5a5a5a5a5a335, 10, 39, 0xffffffcb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a335, 10, 39, 0x0000004b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a335, 274877906943, 10, 39, 0xa59fffffffffa335)
	EXT( 0xa5a5a5a5a5a5a334, 10, 40, 0xffffff9696969696)
	EXTU(0xa5a5a5a5a5a5a334, 10, 40, 0x0000009696969696)
	DEP( 0xa5a5a5a5a5a5a334, 549755813887, 10, 40, 0xa59fffffffffe334)
	EXT( 0xa5a5a5a5a5a5a333, 10, 41, 0xffffff2d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a333, 10, 41, 0x0000012d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a333, 1099511627775, 10, 41, 0xa59fffffffffe333)
	EXT( 0xa5a5a5a5a5a5a332, 10, 42, 0xfffffe5a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a332, 10, 42, 0x0000025a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a332, 2199023255551, 10, 42, 0xa59ffffffffff332)
	EXT( 0xa5a5a5a5a5a5a331, 10, 43, 0xfffffcb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a331, 10, 43, 0x000004b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a331, 4398046511103, 10, 43, 0xa59ffffffffffb31)
	EXT( 0xa5a5a5a5a5a5a330, 10, 44, 0xfffff96969696968)
	EXTU(0xa5a5a5a5a5a5a330, 10, 44, 0x0000096969696968)
	DEP( 0xa5a5a5a5a5a5a330, 8796093022207, 10, 44, 0xa59fffffffffff30)
	EXT( 0xa5a5a5a5a5a5a32f, 10, 45, 0xfffff2d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a32f, 10, 45, 0x000012d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a32f, 17592186044415, 10, 45, 0xa59fffffffffff2f)
	EXT( 0xa5a5a5a5a5a5a32e, 10, 46, 0xffffe5a5a5a5a5a3)
	EXTU(0xa5a5a5a5a5a5a32e, 10, 46, 0x000025a5a5a5a5a3)
	DEP( 0xa5a5a5a5a5a5a32e, 35184372088831, 10, 46, 0xa59fffffffffff2e)
	EXT( 0xa5a5a5a5a5a5a32d, 10, 47, 0xffffcb4b4b4b4b46)
	EXTU(0xa5a5a5a5a5a5a32d, 10, 47, 0x00004b4b4b4b4b46)
	DEP( 0xa5a5a5a5a5a5a32d, 70368744177663, 10, 47, 0xa59fffffffffffad)
	EXT( 0xa5a5a5a5a5a5a32c, 10, 48, 0xffff96969696968c)
	EXTU(0xa5a5a5a5a5a5a32c, 10, 48, 0x000096969696968c)
	DEP( 0xa5a5a5a5a5a5a32c, 140737488355327, 10, 48, 0xa59fffffffffffec)
	EXT( 0xa5a5a5a5a5a5a32b, 10, 49, 0xffff2d2d2d2d2d19)
	EXTU(0xa5a5a5a5a5a5a32b, 10, 49, 0x00012d2d2d2d2d19)
	DEP( 0xa5a5a5a5a5a5a32b, 281474976710655, 10, 49, 0xa59fffffffffffeb)
	EXT( 0xa5a5a5a5a5a5a32a, 10, 50, 0xfffe5a5a5a5a5a32)
	EXTU(0xa5a5a5a5a5a5a32a, 10, 50, 0x00025a5a5a5a5a32)
	DEP( 0xa5a5a5a5a5a5a32a, 562949953421311, 10, 50, 0xa59ffffffffffffa)
	EXT( 0xa5a5a5a5a5a5a329, 10, 51, 0xfffcb4b4b4b4b465)
	EXTU(0xa5a5a5a5a5a5a329, 10, 51, 0x0004b4b4b4b4b465)
	DEP( 0xa5a5a5a5a5a5a329, 1125899906842623, 10, 51, 0xa59ffffffffffff9)
	EXT( 0xa5a5a5a5a5a5a328, 10, 52, 0xfff96969696968ca)
	EXTU(0xa5a5a5a5a5a5a328, 10, 52, 0x00096969696968ca)
	DEP( 0xa5a5a5a5a5a5a328, 2251799813685247, 10, 52, 0xa59ffffffffffffc)
	EXT( 0xa5a5a5a5a5a5a327, 10, 53, 0xfff2d2d2d2d2d193)
	EXTU(0xa5a5a5a5a5a5a327, 10, 53, 0x0012d2d2d2d2d193)
	DEP( 0xa5a5a5a5a5a5a327, 4503599627370495, 10, 53, 0xa59fffffffffffff)
	EXT( 0xa5a5a5a5a5a5a326, 11, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a326, 11, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a326, 0, 11, 1, 0xa5a5a5a5a5a5a326)
	EXT( 0xa5a5a5a5a5a5a325, 11, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a325, 11, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a325, 1, 11, 2, 0xa5ada5a5a5a5a325)
	EXT( 0xa5a5a5a5a5a5a324, 11, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a324, 11, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a324, 3, 11, 3, 0xa5ada5a5a5a5a324)
	EXT( 0xa5a5a5a5a5a5a323, 11, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a323, 11, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a323, 7, 11, 4, 0xa5afa5a5a5a5a323)
	EXT( 0xa5a5a5a5a5a5a322, 11, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a322, 11, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a322, 15, 11, 5, 0xa5afa5a5a5a5a322)
	EXT( 0xa5a5a5a5a5a5a321, 11, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a321, 11, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a321, 31, 11, 6, 0xa5afa5a5a5a5a321)
	EXT( 0xa5a5a5a5a5a5a320, 11, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a320, 11, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a320, 63, 11, 7, 0xa5afe5a5a5a5a320)
	EXT( 0xa5a5a5a5a5a5a31f, 11, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a31f, 11, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a31f, 127, 11, 8, 0xa5afe5a5a5a5a31f)
	EXT( 0xa5a5a5a5a5a5a31e, 11, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a31e, 11, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a31e, 255, 11, 9, 0xa5aff5a5a5a5a31e)
	EXT( 0xa5a5a5a5a5a5a31d, 11, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a31d, 11, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a31d, 511, 11, 10, 0xa5affda5a5a5a31d)
	EXT( 0xa5a5a5a5a5a5a31c, 11, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a31c, 11, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a31c, 1023, 11, 11, 0xa5affda5a5a5a31c)
	EXT( 0xa5a5a5a5a5a5a31b, 11, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a31b, 11, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a31b, 2047, 11, 12, 0xa5afffa5a5a5a31b)
	EXT( 0xa5a5a5a5a5a5a31a, 11, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a31a, 11, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a31a, 4095, 11, 13, 0xa5afffa5a5a5a31a)
	EXT( 0xa5a5a5a5a5a5a319, 11, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a319, 11, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a319, 8191, 11, 14, 0xa5afffa5a5a5a319)
	EXT( 0xa5a5a5a5a5a5a318, 11, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a318, 11, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a318, 16383, 11, 15, 0xa5afffe5a5a5a318)
	EXT( 0xa5a5a5a5a5a5a317, 11, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a317, 11, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a317, 32767, 11, 16, 0xa5afffe5a5a5a317)
	EXT( 0xa5a5a5a5a5a5a316, 11, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a316, 11, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a316, 65535, 11, 17, 0xa5affff5a5a5a316)
	EXT( 0xa5a5a5a5a5a5a315, 11, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a315, 11, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a315, 131071, 11, 18, 0xa5affffda5a5a315)
	EXT( 0xa5a5a5a5a5a5a314, 11, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a314, 11, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a314, 262143, 11, 19, 0xa5affffda5a5a314)
	EXT( 0xa5a5a5a5a5a5a313, 11, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a313, 11, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a313, 524287, 11, 20, 0xa5afffffa5a5a313)
	EXT( 0xa5a5a5a5a5a5a312, 11, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a312, 11, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a312, 1048575, 11, 21, 0xa5afffffa5a5a312)
	EXT( 0xa5a5a5a5a5a5a311, 11, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a311, 11, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a311, 2097151, 11, 22, 0xa5afffffa5a5a311)
	EXT( 0xa5a5a5a5a5a5a310, 11, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a310, 11, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a310, 4194303, 11, 23, 0xa5afffffe5a5a310)
	EXT( 0xa5a5a5a5a5a5a30f, 11, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a30f, 11, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a30f, 8388607, 11, 24, 0xa5afffffe5a5a30f)
	EXT( 0xa5a5a5a5a5a5a30e, 11, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a30e, 11, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a30e, 16777215, 11, 25, 0xa5affffff5a5a30e)
	EXT( 0xa5a5a5a5a5a5a30d, 11, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a30d, 11, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a30d, 33554431, 11, 26, 0xa5affffffda5a30d)
	EXT( 0xa5a5a5a5a5a5a30c, 11, 27, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a30c, 11, 27, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a30c, 67108863, 11, 27, 0xa5affffffda5a30c)
	EXT( 0xa5a5a5a5a5a5a30b, 11, 28, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a30b, 11, 28, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a30b, 134217727, 11, 28, 0xa5afffffffa5a30b)
	EXT( 0xa5a5a5a5a5a5a30a, 11, 29, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a30a, 11, 29, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a30a, 268435455, 11, 29, 0xa5afffffffa5a30a)
	EXT( 0xa5a5a5a5a5a5a309, 11, 30, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a309, 11, 30, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a309, 536870911, 11, 30, 0xa5afffffffa5a309)
	EXT( 0xa5a5a5a5a5a5a308, 11, 31, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a308, 11, 31, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a308, 1073741823, 11, 31, 0xa5afffffffe5a308)
	EXT( 0xa5a5a5a5a5a5a307, 11, 32, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a307, 11, 32, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a307, 2147483647, 11, 32, 0xa5afffffffe5a307)
	EXT( 0xa5a5a5a5a5a5a306, 11, 33, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a306, 11, 33, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a306, 4294967295, 11, 33, 0xa5affffffff5a306)
	EXT( 0xa5a5a5a5a5a5a305, 11, 34, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a305, 11, 34, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a305, 8589934591, 11, 34, 0xa5affffffffda305)
	EXT( 0xa5a5a5a5a5a5a304, 11, 35, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a304, 11, 35, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a304, 17179869183, 11, 35, 0xa5affffffffda304)
	EXT( 0xa5a5a5a5a5a5a303, 11, 36, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a303, 11, 36, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a303, 34359738367, 11, 36, 0xa5afffffffffa303)
	EXT( 0xa5a5a5a5a5a5a302, 11, 37, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a302, 11, 37, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a302, 68719476735, 11, 37, 0xa5afffffffffa302)
	EXT( 0xa5a5a5a5a5a5a301, 11, 38, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a301, 11, 38, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a301, 137438953471, 11, 38, 0xa5afffffffffa301)
	EXT( 0xa5a5a5a5a5a5a300, 11, 39, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a300, 11, 39, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a300, 274877906943, 11, 39, 0xa5afffffffffe300)
	EXT( 0xa5a5a5a5a5a5a2ff, 11, 40, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2ff, 11, 40, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2ff, 549755813887, 11, 40, 0xa5afffffffffe2ff)
	EXT( 0xa5a5a5a5a5a5a2fe, 11, 41, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2fe, 11, 41, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2fe, 1099511627775, 11, 41, 0xa5affffffffff2fe)
	EXT( 0xa5a5a5a5a5a5a2fd, 11, 42, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2fd, 11, 42, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2fd, 2199023255551, 11, 42, 0xa5affffffffffafd)
	EXT( 0xa5a5a5a5a5a5a2fc, 11, 43, 0x0000016969696968)
	EXTU(0xa5a5a5a5a5a5a2fc, 11, 43, 0x0000016969696968)
	DEP( 0xa5a5a5a5a5a5a2fc, 4398046511103, 11, 43, 0xa5affffffffffefc)
	EXT( 0xa5a5a5a5a5a5a2fb, 11, 44, 0x000002d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a2fb, 11, 44, 0x000002d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a2fb, 8796093022207, 11, 44, 0xa5affffffffffefb)
	EXT( 0xa5a5a5a5a5a5a2fa, 11, 45, 0x000005a5a5a5a5a2)
	EXTU(0xa5a5a5a5a5a5a2fa, 11, 45, 0x000005a5a5a5a5a2)
	DEP( 0xa5a5a5a5a5a5a2fa, 17592186044415, 11, 45, 0xa5affffffffffffa)
	EXT( 0xa5a5a5a5a5a5a2f9, 11, 46, 0x00000b4b4b4b4b45)
	EXTU(0xa5a5a5a5a5a5a2f9, 11, 46, 0x00000b4b4b4b4b45)
	DEP( 0xa5a5a5a5a5a5a2f9, 35184372088831, 11, 46, 0xa5affffffffffff9)
	EXT( 0xa5a5a5a5a5a5a2f8, 11, 47, 0x000016969696968b)
	EXTU(0xa5a5a5a5a5a5a2f8, 11, 47, 0x000016969696968b)
	DEP( 0xa5a5a5a5a5a5a2f8, 70368744177663, 11, 47, 0xa5affffffffffff8)
	EXT( 0xa5a5a5a5a5a5a2f7, 11, 48, 0x00002d2d2d2d2d17)
	EXTU(0xa5a5a5a5a5a5a2f7, 11, 48, 0x00002d2d2d2d2d17)
	DEP( 0xa5a5a5a5a5a5a2f7, 140737488355327, 11, 48, 0xa5affffffffffff7)
	EXT( 0xa5a5a5a5a5a5a2f6, 11, 49, 0x00005a5a5a5a5a2f)
	EXTU(0xa5a5a5a5a5a5a2f6, 11, 49, 0x00005a5a5a5a5a2f)
	DEP( 0xa5a5a5a5a5a5a2f6, 281474976710655, 11, 49, 0xa5affffffffffff6)
	EXT( 0xa5a5a5a5a5a5a2f5, 11, 50, 0x0000b4b4b4b4b45e)
	EXTU(0xa5a5a5a5a5a5a2f5, 11, 50, 0x0000b4b4b4b4b45e)
	DEP( 0xa5a5a5a5a5a5a2f5, 562949953421311, 11, 50, 0xa5affffffffffffd)
	EXT( 0xa5a5a5a5a5a5a2f4, 11, 51, 0x00016969696968bd)
	EXTU(0xa5a5a5a5a5a5a2f4, 11, 51, 0x00016969696968bd)
	DEP( 0xa5a5a5a5a5a5a2f4, 1125899906842623, 11, 51, 0xa5affffffffffffc)
	EXT( 0xa5a5a5a5a5a5a2f3, 11, 52, 0x0002d2d2d2d2d179)
	EXTU(0xa5a5a5a5a5a5a2f3, 11, 52, 0x0002d2d2d2d2d179)
	DEP( 0xa5a5a5a5a5a5a2f3, 2251799813685247, 11, 52, 0xa5afffffffffffff)
	EXT( 0xa5a5a5a5a5a5a2f2, 12, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a2f2, 12, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a2f2, 0, 12, 1, 0xa5a5a5a5a5a5a2f2)
	EXT( 0xa5a5a5a5a5a5a2f1, 12, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a2f1, 12, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a2f1, 1, 12, 2, 0xa5a5a5a5a5a5a2f1)
	EXT( 0xa5a5a5a5a5a5a2f0, 12, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a2f0, 12, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a2f0, 3, 12, 3, 0xa5a7a5a5a5a5a2f0)
	EXT( 0xa5a5a5a5a5a5a2ef, 12, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a2ef, 12, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a2ef, 7, 12, 4, 0xa5a7a5a5a5a5a2ef)
	EXT( 0xa5a5a5a5a5a5a2ee, 12, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a2ee, 12, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a2ee, 15, 12, 5, 0xa5a7a5a5a5a5a2ee)
	EXT( 0xa5a5a5a5a5a5a2ed, 12, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a2ed, 12, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a2ed, 31, 12, 6, 0xa5a7e5a5a5a5a2ed)
	EXT( 0xa5a5a5a5a5a5a2ec, 12, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a2ec, 12, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a2ec, 63, 12, 7, 0xa5a7e5a5a5a5a2ec)
	EXT( 0xa5a5a5a5a5a5a2eb, 12, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a2eb, 12, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a2eb, 127, 12, 8, 0xa5a7f5a5a5a5a2eb)
	EXT( 0xa5a5a5a5a5a5a2ea, 12, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a2ea, 12, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a2ea, 255, 12, 9, 0xa5a7fda5a5a5a2ea)
	EXT( 0xa5a5a5a5a5a5a2e9, 12, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a2e9, 12, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a2e9, 511, 12, 10, 0xa5a7fda5a5a5a2e9)
	EXT( 0xa5a5a5a5a5a5a2e8, 12, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a2e8, 12, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a2e8, 1023, 12, 11, 0xa5a7ffa5a5a5a2e8)
	EXT( 0xa5a5a5a5a5a5a2e7, 12, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a2e7, 12, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a2e7, 2047, 12, 12, 0xa5a7ffa5a5a5a2e7)
	EXT( 0xa5a5a5a5a5a5a2e6, 12, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a2e6, 12, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a2e6, 4095, 12, 13, 0xa5a7ffa5a5a5a2e6)
	EXT( 0xa5a5a5a5a5a5a2e5, 12, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a2e5, 12, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a2e5, 8191, 12, 14, 0xa5a7ffe5a5a5a2e5)
	EXT( 0xa5a5a5a5a5a5a2e4, 12, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a2e4, 12, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a2e4, 16383, 12, 15, 0xa5a7ffe5a5a5a2e4)
	EXT( 0xa5a5a5a5a5a5a2e3, 12, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a2e3, 12, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a2e3, 32767, 12, 16, 0xa5a7fff5a5a5a2e3)
	EXT( 0xa5a5a5a5a5a5a2e2, 12, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a2e2, 12, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a2e2, 65535, 12, 17, 0xa5a7fffda5a5a2e2)
	EXT( 0xa5a5a5a5a5a5a2e1, 12, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a2e1, 12, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a2e1, 131071, 12, 18, 0xa5a7fffda5a5a2e1)
	EXT( 0xa5a5a5a5a5a5a2e0, 12, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a2e0, 12, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a2e0, 262143, 12, 19, 0xa5a7ffffa5a5a2e0)
	EXT( 0xa5a5a5a5a5a5a2df, 12, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a2df, 12, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a2df, 524287, 12, 20, 0xa5a7ffffa5a5a2df)
	EXT( 0xa5a5a5a5a5a5a2de, 12, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a2de, 12, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a2de, 1048575, 12, 21, 0xa5a7ffffa5a5a2de)
	EXT( 0xa5a5a5a5a5a5a2dd, 12, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a2dd, 12, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a2dd, 2097151, 12, 22, 0xa5a7ffffe5a5a2dd)
	EXT( 0xa5a5a5a5a5a5a2dc, 12, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a2dc, 12, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a2dc, 4194303, 12, 23, 0xa5a7ffffe5a5a2dc)
	EXT( 0xa5a5a5a5a5a5a2db, 12, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a2db, 12, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a2db, 8388607, 12, 24, 0xa5a7fffff5a5a2db)
	EXT( 0xa5a5a5a5a5a5a2da, 12, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2da, 12, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2da, 16777215, 12, 25, 0xa5a7fffffda5a2da)
	EXT( 0xa5a5a5a5a5a5a2d9, 12, 26, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a2d9, 12, 26, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a2d9, 33554431, 12, 26, 0xa5a7fffffda5a2d9)
	EXT( 0xa5a5a5a5a5a5a2d8, 12, 27, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a2d8, 12, 27, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a2d8, 67108863, 12, 27, 0xa5a7ffffffa5a2d8)
	EXT( 0xa5a5a5a5a5a5a2d7, 12, 28, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a2d7, 12, 28, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a2d7, 134217727, 12, 28, 0xa5a7ffffffa5a2d7)
	EXT( 0xa5a5a5a5a5a5a2d6, 12, 29, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a2d6, 12, 29, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a2d6, 268435455, 12, 29, 0xa5a7ffffffa5a2d6)
	EXT( 0xa5a5a5a5a5a5a2d5, 12, 30, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a2d5, 12, 30, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a2d5, 536870911, 12, 30, 0xa5a7ffffffe5a2d5)
	EXT( 0xa5a5a5a5a5a5a2d4, 12, 31, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2d4, 12, 31, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2d4, 1073741823, 12, 31, 0xa5a7ffffffe5a2d4)
	EXT( 0xa5a5a5a5a5a5a2d3, 12, 32, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2d3, 12, 32, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2d3, 2147483647, 12, 32, 0xa5a7fffffff5a2d3)
	EXT( 0xa5a5a5a5a5a5a2d2, 12, 33, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2d2, 12, 33, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2d2, 4294967295, 12, 33, 0xa5a7fffffffda2d2)
	EXT( 0xa5a5a5a5a5a5a2d1, 12, 34, 0x0000000169696969)
	EXTU(0xa5a5a5a5a5a5a2d1, 12, 34, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a2d1, 8589934591, 12, 34, 0xa5a7fffffffda2d1)
	EXT( 0xa5a5a5a5a5a5a2d0, 12, 35, 0x00000002d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a2d0, 12, 35, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a2d0, 17179869183, 12, 35, 0xa5a7ffffffffa2d0)
	EXT( 0xa5a5a5a5a5a5a2cf, 12, 36, 0x00000005a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a2cf, 12, 36, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a2cf, 34359738367, 12, 36, 0xa5a7ffffffffa2cf)
	EXT( 0xa5a5a5a5a5a5a2ce, 12, 37, 0x0000000b4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a2ce, 12, 37, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a2ce, 68719476735, 12, 37, 0xa5a7ffffffffa2ce)
	EXT( 0xa5a5a5a5a5a5a2cd, 12, 38, 0x0000001696969696)
	EXTU(0xa5a5a5a5a5a5a2cd, 12, 38, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a2cd, 137438953471, 12, 38, 0xa5a7ffffffffe2cd)
	EXT( 0xa5a5a5a5a5a5a2cc, 12, 39, 0x0000002d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2cc, 12, 39, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2cc, 274877906943, 12, 39, 0xa5a7ffffffffe2cc)
	EXT( 0xa5a5a5a5a5a5a2cb, 12, 40, 0x0000005a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2cb, 12, 40, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2cb, 549755813887, 12, 40, 0xa5a7fffffffff2cb)
	EXT( 0xa5a5a5a5a5a5a2ca, 12, 41, 0x000000b4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2ca, 12, 41, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2ca, 1099511627775, 12, 41, 0xa5a7fffffffffaca)
	EXT( 0xa5a5a5a5a5a5a2c9, 12, 42, 0x0000016969696968)
	EXTU(0xa5a5a5a5a5a5a2c9, 12, 42, 0x0000016969696968)
	DEP( 0xa5a5a5a5a5a5a2c9, 2199023255551, 12, 42, 0xa5a7fffffffffec9)
	EXT( 0xa5a5a5a5a5a5a2c8, 12, 43, 0x000002d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a2c8, 12, 43, 0x000002d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a2c8, 4398046511103, 12, 43, 0xa5a7fffffffffec8)
	EXT( 0xa5a5a5a5a5a5a2c7, 12, 44, 0x000005a5a5a5a5a2)
	EXTU(0xa5a5a5a5a5a5a2c7, 12, 44, 0x000005a5a5a5a5a2)
	DEP( 0xa5a5a5a5a5a5a2c7, 8796093022207, 12, 44, 0xa5a7ffffffffffc7)
	EXT( 0xa5a5a5a5a5a5a2c6, 12, 45, 0x00000b4b4b4b4b45)
	EXTU(0xa5a5a5a5a5a5a2c6, 12, 45, 0x00000b4b4b4b4b45)
	DEP( 0xa5a5a5a5a5a5a2c6, 17592186044415, 12, 45, 0xa5a7ffffffffffc6)
	EXT( 0xa5a5a5a5a5a5a2c5, 12, 46, 0x000016969696968b)
	EXTU(0xa5a5a5a5a5a5a2c5, 12, 46, 0x000016969696968b)
	DEP( 0xa5a5a5a5a5a5a2c5, 35184372088831, 12, 46, 0xa5a7ffffffffffc5)
	EXT( 0xa5a5a5a5a5a5a2c4, 12, 47, 0x00002d2d2d2d2d16)
	EXTU(0xa5a5a5a5a5a5a2c4, 12, 47, 0x00002d2d2d2d2d16)
	DEP( 0xa5a5a5a5a5a5a2c4, 70368744177663, 12, 47, 0xa5a7ffffffffffe4)
	EXT( 0xa5a5a5a5a5a5a2c3, 12, 48, 0x00005a5a5a5a5a2c)
	EXTU(0xa5a5a5a5a5a5a2c3, 12, 48, 0x00005a5a5a5a5a2c)
	DEP( 0xa5a5a5a5a5a5a2c3, 140737488355327, 12, 48, 0xa5a7fffffffffff3)
	EXT( 0xa5a5a5a5a5a5a2c2, 12, 49, 0x0000b4b4b4b4b458)
	EXTU(0xa5a5a5a5a5a5a2c2, 12, 49, 0x0000b4b4b4b4b458)
	DEP( 0xa5a5a5a5a5a5a2c2, 281474976710655, 12, 49, 0xa5a7fffffffffffa)
	EXT( 0xa5a5a5a5a5a5a2c1, 12, 50, 0x00016969696968b0)
	EXTU(0xa5a5a5a5a5a5a2c1, 12, 50, 0x00016969696968b0)
	DEP( 0xa5a5a5a5a5a5a2c1, 562949953421311, 12, 50, 0xa5a7fffffffffffd)
	EXT( 0xa5a5a5a5a5a5a2c0, 12, 51, 0x0002d2d2d2d2d160)
	EXTU(0xa5a5a5a5a5a5a2c0, 12, 51, 0x0002d2d2d2d2d160)
	DEP( 0xa5a5a5a5a5a5a2c0, 1125899906842623, 12, 51, 0xa5a7fffffffffffe)
	EXT( 0xa5a5a5a5a5a5a2bf, 13, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a2bf, 13, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a2bf, 0, 13, 1, 0xa5a1a5a5a5a5a2bf)
	EXT( 0xa5a5a5a5a5a5a2be, 13, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a2be, 13, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a2be, 1, 13, 2, 0xa5a3a5a5a5a5a2be)
	EXT( 0xa5a5a5a5a5a5a2bd, 13, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a2bd, 13, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a2bd, 3, 13, 3, 0xa5a3a5a5a5a5a2bd)
	EXT( 0xa5a5a5a5a5a5a2bc, 13, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a5a2bc, 13, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a2bc, 7, 13, 4, 0xa5a3a5a5a5a5a2bc)
	EXT( 0xa5a5a5a5a5a5a2bb, 13, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a5a2bb, 13, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a2bb, 15, 13, 5, 0xa5a3e5a5a5a5a2bb)
	EXT( 0xa5a5a5a5a5a5a2ba, 13, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a5a2ba, 13, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a2ba, 31, 13, 6, 0xa5a3e5a5a5a5a2ba)
	EXT( 0xa5a5a5a5a5a5a2b9, 13, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a5a2b9, 13, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a2b9, 63, 13, 7, 0xa5a3f5a5a5a5a2b9)
	EXT( 0xa5a5a5a5a5a5a2b8, 13, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a5a2b8, 13, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a2b8, 127, 13, 8, 0xa5a3fda5a5a5a2b8)
	EXT( 0xa5a5a5a5a5a5a2b7, 13, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a5a2b7, 13, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a2b7, 255, 13, 9, 0xa5a3fda5a5a5a2b7)
	EXT( 0xa5a5a5a5a5a5a2b6, 13, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a5a2b6, 13, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a2b6, 511, 13, 10, 0xa5a3ffa5a5a5a2b6)
	EXT( 0xa5a5a5a5a5a5a2b5, 13, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a5a2b5, 13, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a2b5, 1023, 13, 11, 0xa5a3ffa5a5a5a2b5)
	EXT( 0xa5a5a5a5a5a5a2b4, 13, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a5a2b4, 13, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a2b4, 2047, 13, 12, 0xa5a3ffa5a5a5a2b4)
	EXT( 0xa5a5a5a5a5a5a2b3, 13, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a5a2b3, 13, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a2b3, 4095, 13, 13, 0xa5a3ffe5a5a5a2b3)
	EXT( 0xa5a5a5a5a5a5a2b2, 13, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a5a2b2, 13, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a2b2, 8191, 13, 14, 0xa5a3ffe5a5a5a2b2)
	EXT( 0xa5a5a5a5a5a5a2b1, 13, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a5a2b1, 13, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a2b1, 16383, 13, 15, 0xa5a3fff5a5a5a2b1)
	EXT( 0xa5a5a5a5a5a5a2b0, 13, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a5a2b0, 13, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a2b0, 32767, 13, 16, 0xa5a3fffda5a5a2b0)
	EXT( 0xa5a5a5a5a5a5a2af, 13, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a5a2af, 13, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a2af, 65535, 13, 17, 0xa5a3fffda5a5a2af)
	EXT( 0xa5a5a5a5a5a5a2ae, 13, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a5a2ae, 13, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a2ae, 131071, 13, 18, 0xa5a3ffffa5a5a2ae)
	EXT( 0xa5a5a5a5a5a5a2ad, 13, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a5a2ad, 13, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a2ad, 262143, 13, 19, 0xa5a3ffffa5a5a2ad)
	EXT( 0xa5a5a5a5a5a5a2ac, 13, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a5a2ac, 13, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a2ac, 524287, 13, 20, 0xa5a3ffffa5a5a2ac)
	EXT( 0xa5a5a5a5a5a5a2ab, 13, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a5a2ab, 13, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a2ab, 1048575, 13, 21, 0xa5a3ffffe5a5a2ab)
	EXT( 0xa5a5a5a5a5a5a2aa, 13, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a5a2aa, 13, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a2aa, 2097151, 13, 22, 0xa5a3ffffe5a5a2aa)
	EXT( 0xa5a5a5a5a5a5a2a9, 13, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a5a2a9, 13, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a2a9, 4194303, 13, 23, 0xa5a3fffff5a5a2a9)
	EXT( 0xa5a5a5a5a5a5a2a8, 13, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a5a2a8, 13, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2a8, 8388607, 13, 24, 0xa5a3fffffda5a2a8)
	EXT( 0xa5a5a5a5a5a5a2a7, 13, 25, 0xffffffffff696969)
	EXTU(0xa5a5a5a5a5a5a2a7, 13, 25, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a2a7, 16777215, 13, 25, 0xa5a3fffffda5a2a7)
	EXT( 0xa5a5a5a5a5a5a2a6, 13, 26, 0xfffffffffed2d2d2)
	EXTU(0xa5a5a5a5a5a5a2a6, 13, 26, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a2a6, 33554431, 13, 26, 0xa5a3ffffffa5a2a6)
	EXT( 0xa5a5a5a5a5a5a2a5, 13, 27, 0xfffffffffda5a5a5)
	EXTU(0xa5a5a5a5a5a5a2a5, 13, 27, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a2a5, 67108863, 13, 27, 0xa5a3ffffffa5a2a5)
	EXT( 0xa5a5a5a5a5a5a2a4, 13, 28, 0xfffffffffb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a2a4, 13, 28, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a2a4, 134217727, 13, 28, 0xa5a3ffffffa5a2a4)
	EXT( 0xa5a5a5a5a5a5a2a3, 13, 29, 0xfffffffff6969696)
	EXTU(0xa5a5a5a5a5a5a2a3, 13, 29, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a2a3, 268435455, 13, 29, 0xa5a3ffffffe5a2a3)
	EXT( 0xa5a5a5a5a5a5a2a2, 13, 30, 0xffffffffed2d2d2d)
	EXTU(0xa5a5a5a5a5a5a2a2, 13, 30, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a2a2, 536870911, 13, 30, 0xa5a3ffffffe5a2a2)
	EXT( 0xa5a5a5a5a5a5a2a1, 13, 31, 0xffffffffda5a5a5a)
	EXTU(0xa5a5a5a5a5a5a2a1, 13, 31, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a2a1, 1073741823, 13, 31, 0xa5a3fffffff5a2a1)
	EXT( 0xa5a5a5a5a5a5a2a0, 13, 32, 0xffffffffb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a2a0, 13, 32, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a2a0, 2147483647, 13, 32, 0xa5a3fffffffda2a0)
	EXT( 0xa5a5a5a5a5a5a29f, 13, 33, 0xffffffff69696969)
	EXTU(0xa5a5a5a5a5a5a29f, 13, 33, 0x0000000169696969)
	DEP( 0xa5a5a5a5a5a5a29f, 4294967295, 13, 33, 0xa5a3fffffffda29f)
	EXT( 0xa5a5a5a5a5a5a29e, 13, 34, 0xfffffffed2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a29e, 13, 34, 0x00000002d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a29e, 8589934591, 13, 34, 0xa5a3ffffffffa29e)
	EXT( 0xa5a5a5a5a5a5a29d, 13, 35, 0xfffffffda5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a29d, 13, 35, 0x00000005a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a29d, 17179869183, 13, 35, 0xa5a3ffffffffa29d)
	EXT( 0xa5a5a5a5a5a5a29c, 13, 36, 0xfffffffb4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a29c, 13, 36, 0x0000000b4b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a29c, 34359738367, 13, 36, 0xa5a3ffffffffa29c)
	EXT( 0xa5a5a5a5a5a5a29b, 13, 37, 0xfffffff696969696)
	EXTU(0xa5a5a5a5a5a5a29b, 13, 37, 0x0000001696969696)
	DEP( 0xa5a5a5a5a5a5a29b, 68719476735, 13, 37, 0xa5a3ffffffffe29b)
	EXT( 0xa5a5a5a5a5a5a29a, 13, 38, 0xffffffed2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a29a, 13, 38, 0x0000002d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a29a, 137438953471, 13, 38, 0xa5a3ffffffffe29a)
	EXT( 0xa5a5a5a5a5a5a299, 13, 39, 0xffffffda5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a299, 13, 39, 0x0000005a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a299, 274877906943, 13, 39, 0xa5a3fffffffff299)
	EXT( 0xa5a5a5a5a5a5a298, 13, 40, 0xffffffb4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a298, 13, 40, 0x000000b4b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a298, 549755813887, 13, 40, 0xa5a3fffffffffa98)
	EXT( 0xa5a5a5a5a5a5a297, 13, 41, 0xffffff6969696968)
	EXTU(0xa5a5a5a5a5a5a297, 13, 41, 0x0000016969696968)
	DEP( 0xa5a5a5a5a5a5a297, 1099511627775, 13, 41, 0xa5a3fffffffffe97)
	EXT( 0xa5a5a5a5a5a5a296, 13, 42, 0xfffffed2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a296, 13, 42, 0x000002d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a296, 2199023255551, 13, 42, 0xa5a3fffffffffe96)
	EXT( 0xa5a5a5a5a5a5a295, 13, 43, 0xfffffda5a5a5a5a2)
	EXTU(0xa5a5a5a5a5a5a295, 13, 43, 0x000005a5a5a5a5a2)
	DEP( 0xa5a5a5a5a5a5a295, 4398046511103, 13, 43, 0xa5a3ffffffffff95)
	EXT( 0xa5a5a5a5a5a5a294, 13, 44, 0xfffffb4b4b4b4b45)
	EXTU(0xa5a5a5a5a5a5a294, 13, 44, 0x00000b4b4b4b4b45)
	DEP( 0xa5a5a5a5a5a5a294, 8796093022207, 13, 44, 0xa5a3ffffffffff94)
	EXT( 0xa5a5a5a5a5a5a293, 13, 45, 0xfffff6969696968a)
	EXTU(0xa5a5a5a5a5a5a293, 13, 45, 0x000016969696968a)
	DEP( 0xa5a5a5a5a5a5a293, 17592186044415, 13, 45, 0xa5a3ffffffffffd3)
	EXT( 0xa5a5a5a5a5a5a292, 13, 46, 0xffffed2d2d2d2d14)
	EXTU(0xa5a5a5a5a5a5a292, 13, 46, 0x00002d2d2d2d2d14)
	DEP( 0xa5a5a5a5a5a5a292, 35184372088831, 13, 46, 0xa5a3fffffffffff2)
	EXT( 0xa5a5a5a5a5a5a291, 13, 47, 0xffffda5a5a5a5a29)
	EXTU(0xa5a5a5a5a5a5a291, 13, 47, 0x00005a5a5a5a5a29)
	DEP( 0xa5a5a5a5a5a5a291, 70368744177663, 13, 47, 0xa5a3fffffffffff1)
	EXT( 0xa5a5a5a5a5a5a290, 13, 48, 0xffffb4b4b4b4b452)
	EXTU(0xa5a5a5a5a5a5a290, 13, 48, 0x0000b4b4b4b4b452)
	DEP( 0xa5a5a5a5a5a5a290, 140737488355327, 13, 48, 0xa5a3fffffffffff8)
	EXT( 0xa5a5a5a5a5a5a28f, 13, 49, 0xffff6969696968a3)
	EXTU(0xa5a5a5a5a5a5a28f, 13, 49, 0x00016969696968a3)
	DEP( 0xa5a5a5a5a5a5a28f, 281474976710655, 13, 49, 0xa5a3ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a28e, 13, 50, 0xfffed2d2d2d2d147)
	EXTU(0xa5a5a5a5a5a5a28e, 13, 50, 0x0002d2d2d2d2d147)
	DEP( 0xa5a5a5a5a5a5a28e, 562949953421311, 13, 50, 0xa5a3fffffffffffe)
	EXT( 0xa5a5a5a5a5a5a28d, 14, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a28d, 14, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a28d, 0, 14, 1, 0xa5a5a5a5a5a5a28d)
	EXT( 0xa5a5a5a5a5a5a28c, 14, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a28c, 14, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a28c, 1, 14, 2, 0xa5a5a5a5a5a5a28c)
	EXT( 0xa5a5a5a5a5a5a28b, 14, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a28b, 14, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a28b, 3, 14, 3, 0xa5a5a5a5a5a5a28b)
	EXT( 0xa5a5a5a5a5a5a28a, 14, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a5a28a, 14, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a28a, 7, 14, 4, 0xa5a5e5a5a5a5a28a)
	EXT( 0xa5a5a5a5a5a5a289, 14, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a5a289, 14, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a289, 15, 14, 5, 0xa5a5e5a5a5a5a289)
	EXT( 0xa5a5a5a5a5a5a288, 14, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a5a288, 14, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a288, 31, 14, 6, 0xa5a5f5a5a5a5a288)
	EXT( 0xa5a5a5a5a5a5a287, 14, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a5a287, 14, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a287, 63, 14, 7, 0xa5a5fda5a5a5a287)
	EXT( 0xa5a5a5a5a5a5a286, 14, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a5a286, 14, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a286, 127, 14, 8, 0xa5a5fda5a5a5a286)
	EXT( 0xa5a5a5a5a5a5a285, 14, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a5a285, 14, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a285, 255, 14, 9, 0xa5a5ffa5a5a5a285)
	EXT( 0xa5a5a5a5a5a5a284, 14, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a5a284, 14, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a284, 511, 14, 10, 0xa5a5ffa5a5a5a284)
	EXT( 0xa5a5a5a5a5a5a283, 14, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a5a283, 14, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a283, 1023, 14, 11, 0xa5a5ffa5a5a5a283)
	EXT( 0xa5a5a5a5a5a5a282, 14, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a5a282, 14, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a282, 2047, 14, 12, 0xa5a5ffe5a5a5a282)
	EXT( 0xa5a5a5a5a5a5a281, 14, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a5a281, 14, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a281, 4095, 14, 13, 0xa5a5ffe5a5a5a281)
	EXT( 0xa5a5a5a5a5a5a280, 14, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a5a280, 14, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a280, 8191, 14, 14, 0xa5a5fff5a5a5a280)
	EXT( 0xa5a5a5a5a5a5a27f, 14, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a5a27f, 14, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a27f, 16383, 14, 15, 0xa5a5fffda5a5a27f)
	EXT( 0xa5a5a5a5a5a5a27e, 14, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a5a27e, 14, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a27e, 32767, 14, 16, 0xa5a5fffda5a5a27e)
	EXT( 0xa5a5a5a5a5a5a27d, 14, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a5a27d, 14, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a27d, 65535, 14, 17, 0xa5a5ffffa5a5a27d)
	EXT( 0xa5a5a5a5a5a5a27c, 14, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a5a27c, 14, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a27c, 131071, 14, 18, 0xa5a5ffffa5a5a27c)
	EXT( 0xa5a5a5a5a5a5a27b, 14, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a5a27b, 14, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a27b, 262143, 14, 19, 0xa5a5ffffa5a5a27b)
	EXT( 0xa5a5a5a5a5a5a27a, 14, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a5a27a, 14, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a27a, 524287, 14, 20, 0xa5a5ffffe5a5a27a)
	EXT( 0xa5a5a5a5a5a5a279, 14, 21, 0x00000000000d2d2d)
	EXTU(0xa5a5a5a5a5a5a279, 14, 21, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a279, 1048575, 14, 21, 0xa5a5ffffe5a5a279)
	EXT( 0xa5a5a5a5a5a5a278, 14, 22, 0x00000000001a5a5a)
	EXTU(0xa5a5a5a5a5a5a278, 14, 22, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a278, 2097151, 14, 22, 0xa5a5fffff5a5a278)
	EXT( 0xa5a5a5a5a5a5a277, 14, 23, 0x000000000034b4b4)
	EXTU(0xa5a5a5a5a5a5a277, 14, 23, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a277, 4194303, 14, 23, 0xa5a5fffffda5a277)
	EXT( 0xa5a5a5a5a5a5a276, 14, 24, 0x0000000000696969)
	EXTU(0xa5a5a5a5a5a5a276, 14, 24, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a276, 8388607, 14, 24, 0xa5a5fffffda5a276)
	EXT( 0xa5a5a5a5a5a5a275, 14, 25, 0x0000000000d2d2d2)
	EXTU(0xa5a5a5a5a5a5a275, 14, 25, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a275, 16777215, 14, 25, 0xa5a5ffffffa5a275)
	EXT( 0xa5a5a5a5a5a5a274, 14, 26, 0x0000000001a5a5a5)
	EXTU(0xa5a5a5a5a5a5a274, 14, 26, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a274, 33554431, 14, 26, 0xa5a5ffffffa5a274)
	EXT( 0xa5a5a5a5a5a5a273, 14, 27, 0x00000000034b4b4b)
	EXTU(0xa5a5a5a5a5a5a273, 14, 27, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a273, 67108863, 14, 27, 0xa5a5ffffffa5a273)
	EXT( 0xa5a5a5a5a5a5a272, 14, 28, 0x0000000006969696)
	EXTU(0xa5a5a5a5a5a5a272, 14, 28, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a272, 134217727, 14, 28, 0xa5a5ffffffe5a272)
	EXT( 0xa5a5a5a5a5a5a271, 14, 29, 0x000000000d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a271, 14, 29, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a271, 268435455, 14, 29, 0xa5a5ffffffe5a271)
	EXT( 0xa5a5a5a5a5a5a270, 14, 30, 0x000000001a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a270, 14, 30, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a270, 536870911, 14, 30, 0xa5a5fffffff5a270)
	EXT( 0xa5a5a5a5a5a5a26f, 14, 31, 0x0000000034b4b4b4)
	EXTU(0xa5a5a5a5a5a5a26f, 14, 31, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a26f, 1073741823, 14, 31, 0xa5a5fffffffda26f)
	EXT( 0xa5a5a5a5a5a5a26e, 14, 32, 0x0000000069696969)
	EXTU(0xa5a5a5a5a5a5a26e, 14, 32, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a26e, 2147483647, 14, 32, 0xa5a5fffffffda26e)
	EXT( 0xa5a5a5a5a5a5a26d, 14, 33, 0x00000000d2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a26d, 14, 33, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a26d, 4294967295, 14, 33, 0xa5a5ffffffffa26d)
	EXT( 0xa5a5a5a5a5a5a26c, 14, 34, 0x00000001a5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a26c, 14, 34, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a26c, 8589934591, 14, 34, 0xa5a5ffffffffa26c)
	EXT( 0xa5a5a5a5a5a5a26b, 14, 35, 0x000000034b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a26b, 14, 35, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a26b, 17179869183, 14, 35, 0xa5a5ffffffffa26b)
	EXT( 0xa5a5a5a5a5a5a26a, 14, 36, 0x0000000696969696)
	EXTU(0xa5a5a5a5a5a5a26a, 14, 36, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a26a, 34359738367, 14, 36, 0xa5a5ffffffffe26a)
	EXT( 0xa5a5a5a5a5a5a269, 14, 37, 0x0000000d2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a269, 14, 37, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a269, 68719476735, 14, 37, 0xa5a5ffffffffe269)
	EXT( 0xa5a5a5a5a5a5a268, 14, 38, 0x0000001a5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a268, 14, 38, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a268, 137438953471, 14, 38, 0xa5a5fffffffff268)
	EXT( 0xa5a5a5a5a5a5a267, 14, 39, 0x00000034b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a267, 14, 39, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a267, 274877906943, 14, 39, 0xa5a5fffffffffa67)
	EXT( 0xa5a5a5a5a5a5a266, 14, 40, 0x0000006969696968)
	EXTU(0xa5a5a5a5a5a5a266, 14, 40, 0x0000006969696968)
	DEP( 0xa5a5a5a5a5a5a266, 549755813887, 14, 40, 0xa5a5fffffffffe66)
	EXT( 0xa5a5a5a5a5a5a265, 14, 41, 0x000000d2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a265, 14, 41, 0x000000d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a265, 1099511627775, 14, 41, 0xa5a5fffffffffe65)
	EXT( 0xa5a5a5a5a5a5a264, 14, 42, 0x000001a5a5a5a5a2)
	EXTU(0xa5a5a5a5a5a5a264, 14, 42, 0x000001a5a5a5a5a2)
	DEP( 0xa5a5a5a5a5a5a264, 2199023255551, 14, 42, 0xa5a5ffffffffff64)
	EXT( 0xa5a5a5a5a5a5a263, 14, 43, 0x0000034b4b4b4b44)
	EXTU(0xa5a5a5a5a5a5a263, 14, 43, 0x0000034b4b4b4b44)
	DEP( 0xa5a5a5a5a5a5a263, 4398046511103, 14, 43, 0xa5a5ffffffffffe3)
	EXT( 0xa5a5a5a5a5a5a262, 14, 44, 0x0000069696969689)
	EXTU(0xa5a5a5a5a5a5a262, 14, 44, 0x0000069696969689)
	DEP( 0xa5a5a5a5a5a5a262, 8796093022207, 14, 44, 0xa5a5ffffffffffe2)
	EXT( 0xa5a5a5a5a5a5a261, 14, 45, 0x00000d2d2d2d2d13)
	EXTU(0xa5a5a5a5a5a5a261, 14, 45, 0x00000d2d2d2d2d13)
	DEP( 0xa5a5a5a5a5a5a261, 17592186044415, 14, 45, 0xa5a5ffffffffffe1)
	EXT( 0xa5a5a5a5a5a5a260, 14, 46, 0x00001a5a5a5a5a26)
	EXTU(0xa5a5a5a5a5a5a260, 14, 46, 0x00001a5a5a5a5a26)
	DEP( 0xa5a5a5a5a5a5a260, 35184372088831, 14, 46, 0xa5a5fffffffffff0)
	EXT( 0xa5a5a5a5a5a5a25f, 14, 47, 0x000034b4b4b4b44b)
	EXTU(0xa5a5a5a5a5a5a25f, 14, 47, 0x000034b4b4b4b44b)
	DEP( 0xa5a5a5a5a5a5a25f, 70368744177663, 14, 47, 0xa5a5ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a25e, 14, 48, 0x0000696969696897)
	EXTU(0xa5a5a5a5a5a5a25e, 14, 48, 0x0000696969696897)
	DEP( 0xa5a5a5a5a5a5a25e, 140737488355327, 14, 48, 0xa5a5fffffffffffe)
	EXT( 0xa5a5a5a5a5a5a25d, 14, 49, 0x0000d2d2d2d2d12e)
	EXTU(0xa5a5a5a5a5a5a25d, 14, 49, 0x0000d2d2d2d2d12e)
	DEP( 0xa5a5a5a5a5a5a25d, 281474976710655, 14, 49, 0xa5a5ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a25c, 15, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a25c, 15, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a25c, 0, 15, 1, 0xa5a4a5a5a5a5a25c)
	EXT( 0xa5a5a5a5a5a5a25b, 15, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a25b, 15, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a25b, 1, 15, 2, 0xa5a4a5a5a5a5a25b)
	EXT( 0xa5a5a5a5a5a5a25a, 15, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a25a, 15, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a25a, 3, 15, 3, 0xa5a4e5a5a5a5a25a)
	EXT( 0xa5a5a5a5a5a5a259, 15, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a259, 15, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a259, 7, 15, 4, 0xa5a4e5a5a5a5a259)
	EXT( 0xa5a5a5a5a5a5a258, 15, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a258, 15, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a258, 15, 15, 5, 0xa5a4f5a5a5a5a258)
	EXT( 0xa5a5a5a5a5a5a257, 15, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a257, 15, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a257, 31, 15, 6, 0xa5a4fda5a5a5a257)
	EXT( 0xa5a5a5a5a5a5a256, 15, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a256, 15, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a256, 63, 15, 7, 0xa5a4fda5a5a5a256)
	EXT( 0xa5a5a5a5a5a5a255, 15, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a255, 15, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a255, 127, 15, 8, 0xa5a4ffa5a5a5a255)
	EXT( 0xa5a5a5a5a5a5a254, 15, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a254, 15, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a254, 255, 15, 9, 0xa5a4ffa5a5a5a254)
	EXT( 0xa5a5a5a5a5a5a253, 15, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a253, 15, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a253, 511, 15, 10, 0xa5a4ffa5a5a5a253)
	EXT( 0xa5a5a5a5a5a5a252, 15, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a252, 15, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a252, 1023, 15, 11, 0xa5a4ffe5a5a5a252)
	EXT( 0xa5a5a5a5a5a5a251, 15, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a251, 15, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a251, 2047, 15, 12, 0xa5a4ffe5a5a5a251)
	EXT( 0xa5a5a5a5a5a5a250, 15, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a250, 15, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a250, 4095, 15, 13, 0xa5a4fff5a5a5a250)
	EXT( 0xa5a5a5a5a5a5a24f, 15, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a24f, 15, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a24f, 8191, 15, 14, 0xa5a4fffda5a5a24f)
	EXT( 0xa5a5a5a5a5a5a24e, 15, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a24e, 15, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a24e, 16383, 15, 15, 0xa5a4fffda5a5a24e)
	EXT( 0xa5a5a5a5a5a5a24d, 15, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a24d, 15, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a24d, 32767, 15, 16, 0xa5a4ffffa5a5a24d)
	EXT( 0xa5a5a5a5a5a5a24c, 15, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a24c, 15, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a24c, 65535, 15, 17, 0xa5a4ffffa5a5a24c)
	EXT( 0xa5a5a5a5a5a5a24b, 15, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a24b, 15, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a24b, 131071, 15, 18, 0xa5a4ffffa5a5a24b)
	EXT( 0xa5a5a5a5a5a5a24a, 15, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a24a, 15, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a24a, 262143, 15, 19, 0xa5a4ffffe5a5a24a)
	EXT( 0xa5a5a5a5a5a5a249, 15, 20, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a249, 15, 20, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a249, 524287, 15, 20, 0xa5a4ffffe5a5a249)
	EXT( 0xa5a5a5a5a5a5a248, 15, 21, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a248, 15, 21, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a248, 1048575, 15, 21, 0xa5a4fffff5a5a248)
	EXT( 0xa5a5a5a5a5a5a247, 15, 22, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a247, 15, 22, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a247, 2097151, 15, 22, 0xa5a4fffffda5a247)
	EXT( 0xa5a5a5a5a5a5a246, 15, 23, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a246, 15, 23, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a246, 4194303, 15, 23, 0xa5a4fffffda5a246)
	EXT( 0xa5a5a5a5a5a5a245, 15, 24, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a245, 15, 24, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a245, 8388607, 15, 24, 0xa5a4ffffffa5a245)
	EXT( 0xa5a5a5a5a5a5a244, 15, 25, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a244, 15, 25, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a244, 16777215, 15, 25, 0xa5a4ffffffa5a244)
	EXT( 0xa5a5a5a5a5a5a243, 15, 26, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a243, 15, 26, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a243, 33554431, 15, 26, 0xa5a4ffffffa5a243)
	EXT( 0xa5a5a5a5a5a5a242, 15, 27, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a242, 15, 27, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a242, 67108863, 15, 27, 0xa5a4ffffffe5a242)
	EXT( 0xa5a5a5a5a5a5a241, 15, 28, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a241, 15, 28, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a241, 134217727, 15, 28, 0xa5a4ffffffe5a241)
	EXT( 0xa5a5a5a5a5a5a240, 15, 29, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a240, 15, 29, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a240, 268435455, 15, 29, 0xa5a4fffffff5a240)
	EXT( 0xa5a5a5a5a5a5a23f, 15, 30, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a23f, 15, 30, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a23f, 536870911, 15, 30, 0xa5a4fffffffda23f)
	EXT( 0xa5a5a5a5a5a5a23e, 15, 31, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a23e, 15, 31, 0x0000000069696969)
	DEP( 0xa5a5a5a5a5a5a23e, 1073741823, 15, 31, 0xa5a4fffffffda23e)
	EXT( 0xa5a5a5a5a5a5a23d, 15, 32, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a23d, 15, 32, 0x00000000d2d2d2d2)
	DEP( 0xa5a5a5a5a5a5a23d, 2147483647, 15, 32, 0xa5a4ffffffffa23d)
	EXT( 0xa5a5a5a5a5a5a23c, 15, 33, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a23c, 15, 33, 0x00000001a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a23c, 4294967295, 15, 33, 0xa5a4ffffffffa23c)
	EXT( 0xa5a5a5a5a5a5a23b, 15, 34, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a23b, 15, 34, 0x000000034b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a23b, 8589934591, 15, 34, 0xa5a4ffffffffa23b)
	EXT( 0xa5a5a5a5a5a5a23a, 15, 35, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a23a, 15, 35, 0x0000000696969696)
	DEP( 0xa5a5a5a5a5a5a23a, 17179869183, 15, 35, 0xa5a4ffffffffe23a)
	EXT( 0xa5a5a5a5a5a5a239, 15, 36, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a239, 15, 36, 0x0000000d2d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a239, 34359738367, 15, 36, 0xa5a4ffffffffe239)
	EXT( 0xa5a5a5a5a5a5a238, 15, 37, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a238, 15, 37, 0x0000001a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a238, 68719476735, 15, 37, 0xa5a4fffffffff238)
	EXT( 0xa5a5a5a5a5a5a237, 15, 38, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a237, 15, 38, 0x00000034b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a237, 137438953471, 15, 38, 0xa5a4fffffffffa37)
	EXT( 0xa5a5a5a5a5a5a236, 15, 39, 0xffffffe969696968)
	EXTU(0xa5a5a5a5a5a5a236, 15, 39, 0x0000006969696968)
	DEP( 0xa5a5a5a5a5a5a236, 274877906943, 15, 39, 0xa5a4fffffffffe36)
	EXT( 0xa5a5a5a5a5a5a235, 15, 40, 0xffffffd2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a235, 15, 40, 0x000000d2d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a235, 549755813887, 15, 40, 0xa5a4fffffffffe35)
	EXT( 0xa5a5a5a5a5a5a234, 15, 41, 0xffffffa5a5a5a5a2)
	EXTU(0xa5a5a5a5a5a5a234, 15, 41, 0x000001a5a5a5a5a2)
	DEP( 0xa5a5a5a5a5a5a234, 1099511627775, 15, 41, 0xa5a4ffffffffff34)
	EXT( 0xa5a5a5a5a5a5a233, 15, 42, 0xffffff4b4b4b4b44)
	EXTU(0xa5a5a5a5a5a5a233, 15, 42, 0x0000034b4b4b4b44)
	DEP( 0xa5a5a5a5a5a5a233, 2199023255551, 15, 42, 0xa5a4ffffffffffb3)
	EXT( 0xa5a5a5a5a5a5a232, 15, 43, 0xfffffe9696969688)
	EXTU(0xa5a5a5a5a5a5a232, 15, 43, 0x0000069696969688)
	DEP( 0xa5a5a5a5a5a5a232, 4398046511103, 15, 43, 0xa5a4fffffffffff2)
	EXT( 0xa5a5a5a5a5a5a231, 15, 44, 0xfffffd2d2d2d2d11)
	EXTU(0xa5a5a5a5a5a5a231, 15, 44, 0x00000d2d2d2d2d11)
	DEP( 0xa5a5a5a5a5a5a231, 8796093022207, 15, 44, 0xa5a4fffffffffff1)
	EXT( 0xa5a5a5a5a5a5a230, 15, 45, 0xfffffa5a5a5a5a23)
	EXTU(0xa5a5a5a5a5a5a230, 15, 45, 0x00001a5a5a5a5a23)
	DEP( 0xa5a5a5a5a5a5a230, 17592186044415, 15, 45, 0xa5a4fffffffffff0)
	EXT( 0xa5a5a5a5a5a5a22f, 15, 46, 0xfffff4b4b4b4b445)
	EXTU(0xa5a5a5a5a5a5a22f, 15, 46, 0x000034b4b4b4b445)
	DEP( 0xa5a5a5a5a5a5a22f, 35184372088831, 15, 46, 0xa5a4ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a22e, 15, 47, 0xffffe9696969688b)
	EXTU(0xa5a5a5a5a5a5a22e, 15, 47, 0x000069696969688b)
	DEP( 0xa5a5a5a5a5a5a22e, 70368744177663, 15, 47, 0xa5a4fffffffffffe)
	EXT( 0xa5a5a5a5a5a5a22d, 15, 48, 0xffffd2d2d2d2d116)
	EXTU(0xa5a5a5a5a5a5a22d, 15, 48, 0x0000d2d2d2d2d116)
	DEP( 0xa5a5a5a5a5a5a22d, 140737488355327, 15, 48, 0xa5a4ffffffffffff)
	EXT( 0xa5a5a5a5a5a5a22c, 16, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a22c, 16, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a22c, 0, 16, 1, 0xa5a525a5a5a5a22c)
	EXT( 0xa5a5a5a5a5a5a22b, 16, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a22b, 16, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a22b, 1, 16, 2, 0xa5a565a5a5a5a22b)
	EXT( 0xa5a5a5a5a5a5a22a, 16, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a22a, 16, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a22a, 3, 16, 3, 0xa5a565a5a5a5a22a)
	EXT( 0xa5a5a5a5a5a5a229, 16, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a229, 16, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a229, 7, 16, 4, 0xa5a575a5a5a5a229)
	EXT( 0xa5a5a5a5a5a5a228, 16, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a228, 16, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a5a228, 15, 16, 5, 0xa5a57da5a5a5a228)
	EXT( 0xa5a5a5a5a5a5a227, 16, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a227, 16, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a5a227, 31, 16, 6, 0xa5a57da5a5a5a227)
	EXT( 0xa5a5a5a5a5a5a226, 16, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a226, 16, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a5a226, 63, 16, 7, 0xa5a57fa5a5a5a226)
	EXT( 0xa5a5a5a5a5a5a225, 16, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a225, 16, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a5a225, 127, 16, 8, 0xa5a57fa5a5a5a225)
	EXT( 0xa5a5a5a5a5a5a224, 16, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a224, 16, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a5a224, 255, 16, 9, 0xa5a57fa5a5a5a224)
	EXT( 0xa5a5a5a5a5a5a223, 16, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a223, 16, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a5a223, 511, 16, 10, 0xa5a57fe5a5a5a223)
	EXT( 0xa5a5a5a5a5a5a222, 16, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a222, 16, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a5a222, 1023, 16, 11, 0xa5a57fe5a5a5a222)
	EXT( 0xa5a5a5a5a5a5a221, 16, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a221, 16, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a5a221, 2047, 16, 12, 0xa5a57ff5a5a5a221)
	EXT( 0xa5a5a5a5a5a5a220, 16, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a220, 16, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a5a220, 4095, 16, 13, 0xa5a57ffda5a5a220)
	EXT( 0xa5a5a5a5a5a5a21f, 16, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a21f, 16, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a5a21f, 8191, 16, 14, 0xa5a57ffda5a5a21f)
	EXT( 0xa5a5a5a5a5a5a21e, 16, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a21e, 16, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a5a21e, 16383, 16, 15, 0xa5a57fffa5a5a21e)
	EXT( 0xa5a5a5a5a5a5a21d, 16, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a21d, 16, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a5a21d, 32767, 16, 16, 0xa5a57fffa5a5a21d)
	EXT( 0xa5a5a5a5a5a5a21c, 16, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a21c, 16, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a5a21c, 65535, 16, 17, 0xa5a57fffa5a5a21c)
	EXT( 0xa5a5a5a5a5a5a21b, 16, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a21b, 16, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a5a21b, 131071, 16, 18, 0xa5a57fffe5a5a21b)
	EXT( 0xa5a5a5a5a5a5a21a, 16, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a21a, 16, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a5a21a, 262143, 16, 19, 0xa5a57fffe5a5a21a)
	EXT( 0xa5a5a5a5a5a5a219, 16, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a219, 16, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a5a219, 524287, 16, 20, 0xa5a57ffff5a5a219)
	EXT( 0xa5a5a5a5a5a5a218, 16, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a218, 16, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a5a218, 1048575, 16, 21, 0xa5a57ffffda5a218)
	EXT( 0xa5a5a5a5a5a5a217, 16, 22, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a217, 16, 22, 0x0000000000296969)
	DEP( 0xa5a5a5a5a5a5a217, 2097151, 16, 22, 0xa5a57ffffda5a217)
	EXT( 0xa5a5a5a5a5a5a216, 16, 23, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a216, 16, 23, 0x000000000052d2d2)
	DEP( 0xa5a5a5a5a5a5a216, 4194303, 16, 23, 0xa5a57fffffa5a216)
	EXT( 0xa5a5a5a5a5a5a215, 16, 24, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a215, 16, 24, 0x0000000000a5a5a5)
	DEP( 0xa5a5a5a5a5a5a215, 8388607, 16, 24, 0xa5a57fffffa5a215)
	EXT( 0xa5a5a5a5a5a5a214, 16, 25, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a214, 16, 25, 0x00000000014b4b4b)
	DEP( 0xa5a5a5a5a5a5a214, 16777215, 16, 25, 0xa5a57fffffa5a214)
	EXT( 0xa5a5a5a5a5a5a213, 16, 26, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a213, 16, 26, 0x0000000002969696)
	DEP( 0xa5a5a5a5a5a5a213, 33554431, 16, 26, 0xa5a57fffffe5a213)
	EXT( 0xa5a5a5a5a5a5a212, 16, 27, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a212, 16, 27, 0x00000000052d2d2d)
	DEP( 0xa5a5a5a5a5a5a212, 67108863, 16, 27, 0xa5a57fffffe5a212)
	EXT( 0xa5a5a5a5a5a5a211, 16, 28, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a211, 16, 28, 0x000000000a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a211, 134217727, 16, 28, 0xa5a57ffffff5a211)
	EXT( 0xa5a5a5a5a5a5a210, 16, 29, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a210, 16, 29, 0x0000000014b4b4b4)
	DEP( 0xa5a5a5a5a5a5a210, 268435455, 16, 29, 0xa5a57ffffffda210)
	EXT( 0xa5a5a5a5a5a5a20f, 16, 30, 0xffffffffe9696969)
	EXTU(0xa5a5a5a5a5a5a20f, 16, 30, 0x0000000029696969)
	DEP( 0xa5a5a5a5a5a5a20f, 536870911, 16, 30, 0xa5a57ffffffda20f)
	EXT( 0xa5a5a5a5a5a5a20e, 16, 31, 0xffffffffd2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a20e, 16, 31, 0x0000000052d2d2d2)
	DEP( 0xa5a5a5a5a5a5a20e, 1073741823, 16, 31, 0xa5a57fffffffa20e)
	EXT( 0xa5a5a5a5a5a5a20d, 16, 32, 0xffffffffa5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a20d, 16, 32, 0x00000000a5a5a5a5)
	DEP( 0xa5a5a5a5a5a5a20d, 2147483647, 16, 32, 0xa5a57fffffffa20d)
	EXT( 0xa5a5a5a5a5a5a20c, 16, 33, 0xffffffff4b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a20c, 16, 33, 0x000000014b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a20c, 4294967295, 16, 33, 0xa5a57fffffffa20c)
	EXT( 0xa5a5a5a5a5a5a20b, 16, 34, 0xfffffffe96969696)
	EXTU(0xa5a5a5a5a5a5a20b, 16, 34, 0x0000000296969696)
	DEP( 0xa5a5a5a5a5a5a20b, 8589934591, 16, 34, 0xa5a57fffffffe20b)
	EXT( 0xa5a5a5a5a5a5a20a, 16, 35, 0xfffffffd2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a20a, 16, 35, 0x000000052d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a20a, 17179869183, 16, 35, 0xa5a57fffffffe20a)
	EXT( 0xa5a5a5a5a5a5a209, 16, 36, 0xfffffffa5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a209, 16, 36, 0x0000000a5a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a209, 34359738367, 16, 36, 0xa5a57ffffffff209)
	EXT( 0xa5a5a5a5a5a5a208, 16, 37, 0xfffffff4b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a208, 16, 37, 0x00000014b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a208, 68719476735, 16, 37, 0xa5a57ffffffffa08)
	EXT( 0xa5a5a5a5a5a5a207, 16, 38, 0xffffffe969696968)
	EXTU(0xa5a5a5a5a5a5a207, 16, 38, 0x0000002969696968)
	DEP( 0xa5a5a5a5a5a5a207, 137438953471, 16, 38, 0xa5a57ffffffffe07)
	EXT( 0xa5a5a5a5a5a5a206, 16, 39, 0xffffffd2d2d2d2d1)
	EXTU(0xa5a5a5a5a5a5a206, 16, 39, 0x00000052d2d2d2d1)
	DEP( 0xa5a5a5a5a5a5a206, 274877906943, 16, 39, 0xa5a57ffffffffe06)
	EXT( 0xa5a5a5a5a5a5a205, 16, 40, 0xffffffa5a5a5a5a2)
	EXTU(0xa5a5a5a5a5a5a205, 16, 40, 0x000000a5a5a5a5a2)
	DEP( 0xa5a5a5a5a5a5a205, 549755813887, 16, 40, 0xa5a57fffffffff05)
	EXT( 0xa5a5a5a5a5a5a204, 16, 41, 0xffffff4b4b4b4b44)
	EXTU(0xa5a5a5a5a5a5a204, 16, 41, 0x0000014b4b4b4b44)
	DEP( 0xa5a5a5a5a5a5a204, 1099511627775, 16, 41, 0xa5a57fffffffff84)
	EXT( 0xa5a5a5a5a5a5a203, 16, 42, 0xfffffe9696969688)
	EXTU(0xa5a5a5a5a5a5a203, 16, 42, 0x0000029696969688)
	DEP( 0xa5a5a5a5a5a5a203, 2199023255551, 16, 42, 0xa5a57fffffffffc3)
	EXT( 0xa5a5a5a5a5a5a202, 16, 43, 0xfffffd2d2d2d2d10)
	EXTU(0xa5a5a5a5a5a5a202, 16, 43, 0x0000052d2d2d2d10)
	DEP( 0xa5a5a5a5a5a5a202, 4398046511103, 16, 43, 0xa5a57fffffffffe2)
	EXT( 0xa5a5a5a5a5a5a201, 16, 44, 0xfffffa5a5a5a5a20)
	EXTU(0xa5a5a5a5a5a5a201, 16, 44, 0x00000a5a5a5a5a20)
	DEP( 0xa5a5a5a5a5a5a201, 8796093022207, 16, 44, 0xa5a57ffffffffff1)
	EXT( 0xa5a5a5a5a5a5a200, 16, 45, 0xfffff4b4b4b4b440)
	EXTU(0xa5a5a5a5a5a5a200, 16, 45, 0x000014b4b4b4b440)
	DEP( 0xa5a5a5a5a5a5a200, 17592186044415, 16, 45, 0xa5a57ffffffffff8)
	EXT( 0xa5a5a5a5a5a5a1ff, 16, 46, 0xffffe9696969687f)
	EXTU(0xa5a5a5a5a5a5a1ff, 16, 46, 0x000029696969687f)
	DEP( 0xa5a5a5a5a5a5a1ff, 35184372088831, 16, 46, 0xa5a57fffffffffff)
	EXT( 0xa5a5a5a5a5a5a1fe, 16, 47, 0xffffd2d2d2d2d0ff)
	EXTU(0xa5a5a5a5a5a5a1fe, 16, 47, 0x000052d2d2d2d0ff)
	DEP( 0xa5a5a5a5a5a5a1fe, 70368744177663, 16, 47, 0xa5a57ffffffffffe)
	EXT( 0xa5a5a5a5a5a5a1fd, 17, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a1fd, 17, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a1fd, 0, 17, 1, 0xa5a5a5a5a5a5a1fd)
	EXT( 0xa5a5a5a5a5a5a1fc, 17, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a1fc, 17, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a1fc, 1, 17, 2, 0xa5a5a5a5a5a5a1fc)
	EXT( 0xa5a5a5a5a5a5a1fb, 17, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a1fb, 17, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a1fb, 3, 17, 3, 0xa5a5b5a5a5a5a1fb)
	EXT( 0xa5a5a5a5a5a5a1fa, 17, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a5a1fa, 17, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a1fa, 7, 17, 4, 0xa5a5bda5a5a5a1fa)
	EXT( 0xa5a5a5a5a5a5a1f9, 17, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a5a1f9, 17, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a1f9, 15, 17, 5, 0xa5a5bda5a5a5a1f9)
	EXT( 0xa5a5a5a5a5a5a1f8, 17, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a5a1f8, 17, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a1f8, 31, 17, 6, 0xa5a5bfa5a5a5a1f8)
	EXT( 0xa5a5a5a5a5a5a1f7, 17, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a5a1f7, 17, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a1f7, 63, 17, 7, 0xa5a5bfa5a5a5a1f7)
	EXT( 0xa5a5a5a5a5a5a1f6, 17, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a5a1f6, 17, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a1f6, 127, 17, 8, 0xa5a5bfa5a5a5a1f6)
	EXT( 0xa5a5a5a5a5a5a1f5, 17, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a5a1f5, 17, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a1f5, 255, 17, 9, 0xa5a5bfe5a5a5a1f5)
	EXT( 0xa5a5a5a5a5a5a1f4, 17, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a5a1f4, 17, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a1f4, 511, 17, 10, 0xa5a5bfe5a5a5a1f4)
	EXT( 0xa5a5a5a5a5a5a1f3, 17, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a5a1f3, 17, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a1f3, 1023, 17, 11, 0xa5a5bff5a5a5a1f3)
	EXT( 0xa5a5a5a5a5a5a1f2, 17, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a5a1f2, 17, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a1f2, 2047, 17, 12, 0xa5a5bffda5a5a1f2)
	EXT( 0xa5a5a5a5a5a5a1f1, 17, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a5a1f1, 17, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a1f1, 4095, 17, 13, 0xa5a5bffda5a5a1f1)
	EXT( 0xa5a5a5a5a5a5a1f0, 17, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a5a1f0, 17, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a1f0, 8191, 17, 14, 0xa5a5bfffa5a5a1f0)
	EXT( 0xa5a5a5a5a5a5a1ef, 17, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a5a1ef, 17, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a1ef, 16383, 17, 15, 0xa5a5bfffa5a5a1ef)
	EXT( 0xa5a5a5a5a5a5a1ee, 17, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a5a1ee, 17, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a1ee, 32767, 17, 16, 0xa5a5bfffa5a5a1ee)
	EXT( 0xa5a5a5a5a5a5a1ed, 17, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a5a1ed, 17, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a1ed, 65535, 17, 17, 0xa5a5bfffe5a5a1ed)
	EXT( 0xa5a5a5a5a5a5a1ec, 17, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a5a1ec, 17, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a1ec, 131071, 17, 18, 0xa5a5bfffe5a5a1ec)
	EXT( 0xa5a5a5a5a5a5a1eb, 17, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a5a1eb, 17, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a1eb, 262143, 17, 19, 0xa5a5bffff5a5a1eb)
	EXT( 0xa5a5a5a5a5a5a1ea, 17, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a5a1ea, 17, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a1ea, 524287, 17, 20, 0xa5a5bffffda5a1ea)
	EXT( 0xa5a5a5a5a5a5a1e9, 17, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a5a1e9, 17, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a1e9, 1048575, 17, 21, 0xa5a5bffffda5a1e9)
	EXT( 0xa5a5a5a5a5a5a1e8, 17, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a5a1e8, 17, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a1e8, 2097151, 17, 22, 0xa5a5bfffffa5a1e8)
	EXT( 0xa5a5a5a5a5a5a1e7, 17, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a5a1e7, 17, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a1e7, 4194303, 17, 23, 0xa5a5bfffffa5a1e7)
	EXT( 0xa5a5a5a5a5a5a1e6, 17, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a5a1e6, 17, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a1e6, 8388607, 17, 24, 0xa5a5bfffffa5a1e6)
	EXT( 0xa5a5a5a5a5a5a1e5, 17, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a5a1e5, 17, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a1e5, 16777215, 17, 25, 0xa5a5bfffffe5a1e5)
	EXT( 0xa5a5a5a5a5a5a1e4, 17, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a5a1e4, 17, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a1e4, 33554431, 17, 26, 0xa5a5bfffffe5a1e4)
	EXT( 0xa5a5a5a5a5a5a1e3, 17, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a5a1e3, 17, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a1e3, 67108863, 17, 27, 0xa5a5bffffff5a1e3)
	EXT( 0xa5a5a5a5a5a5a1e2, 17, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a5a1e2, 17, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a1e2, 134217727, 17, 28, 0xa5a5bffffffda1e2)
	EXT( 0xa5a5a5a5a5a5a1e1, 17, 29, 0x0000000009696969)
	EXTU(0xa5a5a5a5a5a5a1e1, 17, 29, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a1e1, 268435455, 17, 29, 0xa5a5bffffffda1e1)
	EXT( 0xa5a5a5a5a5a5a1e0, 17, 30, 0x0000000012d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1e0, 17, 30, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1e0, 536870911, 17, 30, 0xa5a5bfffffffa1e0)
	EXT( 0xa5a5a5a5a5a5a1df, 17, 31, 0x0000000025a5a5a5)
	EXTU(0xa5a5a5a5a5a5a1df, 17, 31, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a1df, 1073741823, 17, 31, 0xa5a5bfffffffa1df)
	EXT( 0xa5a5a5a5a5a5a1de, 17, 32, 0x000000004b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a1de, 17, 32, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a1de, 2147483647, 17, 32, 0xa5a5bfffffffa1de)
	EXT( 0xa5a5a5a5a5a5a1dd, 17, 33, 0x0000000096969696)
	EXTU(0xa5a5a5a5a5a5a1dd, 17, 33, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a1dd, 4294967295, 17, 33, 0xa5a5bfffffffe1dd)
	EXT( 0xa5a5a5a5a5a5a1dc, 17, 34, 0x000000012d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a1dc, 17, 34, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a1dc, 8589934591, 17, 34, 0xa5a5bfffffffe1dc)
	EXT( 0xa5a5a5a5a5a5a1db, 17, 35, 0x000000025a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a1db, 17, 35, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a1db, 17179869183, 17, 35, 0xa5a5bffffffff1db)
	EXT( 0xa5a5a5a5a5a5a1da, 17, 36, 0x00000004b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a1da, 17, 36, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a1da, 34359738367, 17, 36, 0xa5a5bffffffff9da)
	EXT( 0xa5a5a5a5a5a5a1d9, 17, 37, 0x0000000969696968)
	EXTU(0xa5a5a5a5a5a5a1d9, 17, 37, 0x0000000969696968)
	DEP( 0xa5a5a5a5a5a5a1d9, 68719476735, 17, 37, 0xa5a5bffffffffdd9)
	EXT( 0xa5a5a5a5a5a5a1d8, 17, 38, 0x00000012d2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a1d8, 17, 38, 0x00000012d2d2d2d0)
	DEP( 0xa5a5a5a5a5a5a1d8, 137438953471, 17, 38, 0xa5a5bfffffffffd8)
	EXT( 0xa5a5a5a5a5a5a1d7, 17, 39, 0x00000025a5a5a5a1)
	EXTU(0xa5a5a5a5a5a5a1d7, 17, 39, 0x00000025a5a5a5a1)
	DEP( 0xa5a5a5a5a5a5a1d7, 274877906943, 17, 39, 0xa5a5bfffffffffd7)
	EXT( 0xa5a5a5a5a5a5a1d6, 17, 40, 0x0000004b4b4b4b43)
	EXTU(0xa5a5a5a5a5a5a1d6, 17, 40, 0x0000004b4b4b4b43)
	DEP( 0xa5a5a5a5a5a5a1d6, 549755813887, 17, 40, 0xa5a5bfffffffffd6)
	EXT( 0xa5a5a5a5a5a5a1d5, 17, 41, 0x0000009696969687)
	EXTU(0xa5a5a5a5a5a5a1d5, 17, 41, 0x0000009696969687)
	DEP( 0xa5a5a5a5a5a5a1d5, 1099511627775, 17, 41, 0xa5a5bfffffffffd5)
	EXT( 0xa5a5a5a5a5a5a1d4, 17, 42, 0x0000012d2d2d2d0e)
	EXTU(0xa5a5a5a5a5a5a1d4, 17, 42, 0x0000012d2d2d2d0e)
	DEP( 0xa5a5a5a5a5a5a1d4, 2199023255551, 17, 42, 0xa5a5bffffffffff4)
	EXT( 0xa5a5a5a5a5a5a1d3, 17, 43, 0x0000025a5a5a5a1d)
	EXTU(0xa5a5a5a5a5a5a1d3, 17, 43, 0x0000025a5a5a5a1d)
	DEP( 0xa5a5a5a5a5a5a1d3, 4398046511103, 17, 43, 0xa5a5bffffffffff3)
	EXT( 0xa5a5a5a5a5a5a1d2, 17, 44, 0x000004b4b4b4b43a)
	EXTU(0xa5a5a5a5a5a5a1d2, 17, 44, 0x000004b4b4b4b43a)
	DEP( 0xa5a5a5a5a5a5a1d2, 8796093022207, 17, 44, 0xa5a5bffffffffffa)
	EXT( 0xa5a5a5a5a5a5a1d1, 17, 45, 0x0000096969696874)
	EXTU(0xa5a5a5a5a5a5a1d1, 17, 45, 0x0000096969696874)
	DEP( 0xa5a5a5a5a5a5a1d1, 17592186044415, 17, 45, 0xa5a5bffffffffffd)
	EXT( 0xa5a5a5a5a5a5a1d0, 17, 46, 0x000012d2d2d2d0e8)
	EXTU(0xa5a5a5a5a5a5a1d0, 17, 46, 0x000012d2d2d2d0e8)
	DEP( 0xa5a5a5a5a5a5a1d0, 35184372088831, 17, 46, 0xa5a5bffffffffffe)
	EXT( 0xa5a5a5a5a5a5a1cf, 18, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a1cf, 18, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a1cf, 0, 18, 1, 0xa5a585a5a5a5a1cf)
	EXT( 0xa5a5a5a5a5a5a1ce, 18, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a1ce, 18, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a1ce, 1, 18, 2, 0xa5a595a5a5a5a1ce)
	EXT( 0xa5a5a5a5a5a5a1cd, 18, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a1cd, 18, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a1cd, 3, 18, 3, 0xa5a59da5a5a5a1cd)
	EXT( 0xa5a5a5a5a5a5a1cc, 18, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a5a1cc, 18, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a1cc, 7, 18, 4, 0xa5a59da5a5a5a1cc)
	EXT( 0xa5a5a5a5a5a5a1cb, 18, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a5a1cb, 18, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a1cb, 15, 18, 5, 0xa5a59fa5a5a5a1cb)
	EXT( 0xa5a5a5a5a5a5a1ca, 18, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a5a1ca, 18, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a1ca, 31, 18, 6, 0xa5a59fa5a5a5a1ca)
	EXT( 0xa5a5a5a5a5a5a1c9, 18, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a5a1c9, 18, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a1c9, 63, 18, 7, 0xa5a59fa5a5a5a1c9)
	EXT( 0xa5a5a5a5a5a5a1c8, 18, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a5a1c8, 18, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a1c8, 127, 18, 8, 0xa5a59fe5a5a5a1c8)
	EXT( 0xa5a5a5a5a5a5a1c7, 18, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a5a1c7, 18, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a1c7, 255, 18, 9, 0xa5a59fe5a5a5a1c7)
	EXT( 0xa5a5a5a5a5a5a1c6, 18, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a5a1c6, 18, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a1c6, 511, 18, 10, 0xa5a59ff5a5a5a1c6)
	EXT( 0xa5a5a5a5a5a5a1c5, 18, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a5a1c5, 18, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a1c5, 1023, 18, 11, 0xa5a59ffda5a5a1c5)
	EXT( 0xa5a5a5a5a5a5a1c4, 18, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a5a1c4, 18, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a1c4, 2047, 18, 12, 0xa5a59ffda5a5a1c4)
	EXT( 0xa5a5a5a5a5a5a1c3, 18, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a5a1c3, 18, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a1c3, 4095, 18, 13, 0xa5a59fffa5a5a1c3)
	EXT( 0xa5a5a5a5a5a5a1c2, 18, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a5a1c2, 18, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a1c2, 8191, 18, 14, 0xa5a59fffa5a5a1c2)
	EXT( 0xa5a5a5a5a5a5a1c1, 18, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a5a1c1, 18, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a1c1, 16383, 18, 15, 0xa5a59fffa5a5a1c1)
	EXT( 0xa5a5a5a5a5a5a1c0, 18, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a5a1c0, 18, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a1c0, 32767, 18, 16, 0xa5a59fffe5a5a1c0)
	EXT( 0xa5a5a5a5a5a5a1bf, 18, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a5a1bf, 18, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a1bf, 65535, 18, 17, 0xa5a59fffe5a5a1bf)
	EXT( 0xa5a5a5a5a5a5a1be, 18, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a5a1be, 18, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a1be, 131071, 18, 18, 0xa5a59ffff5a5a1be)
	EXT( 0xa5a5a5a5a5a5a1bd, 18, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a5a1bd, 18, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a1bd, 262143, 18, 19, 0xa5a59ffffda5a1bd)
	EXT( 0xa5a5a5a5a5a5a1bc, 18, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a5a1bc, 18, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a1bc, 524287, 18, 20, 0xa5a59ffffda5a1bc)
	EXT( 0xa5a5a5a5a5a5a1bb, 18, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a5a1bb, 18, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a1bb, 1048575, 18, 21, 0xa5a59fffffa5a1bb)
	EXT( 0xa5a5a5a5a5a5a1ba, 18, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a5a1ba, 18, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a1ba, 2097151, 18, 22, 0xa5a59fffffa5a1ba)
	EXT( 0xa5a5a5a5a5a5a1b9, 18, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a5a1b9, 18, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a1b9, 4194303, 18, 23, 0xa5a59fffffa5a1b9)
	EXT( 0xa5a5a5a5a5a5a1b8, 18, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a5a1b8, 18, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a1b8, 8388607, 18, 24, 0xa5a59fffffe5a1b8)
	EXT( 0xa5a5a5a5a5a5a1b7, 18, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a5a1b7, 18, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a1b7, 16777215, 18, 25, 0xa5a59fffffe5a1b7)
	EXT( 0xa5a5a5a5a5a5a1b6, 18, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a5a1b6, 18, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a1b6, 33554431, 18, 26, 0xa5a59ffffff5a1b6)
	EXT( 0xa5a5a5a5a5a5a1b5, 18, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a5a1b5, 18, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a1b5, 67108863, 18, 27, 0xa5a59ffffffda1b5)
	EXT( 0xa5a5a5a5a5a5a1b4, 18, 28, 0xfffffffff9696969)
	EXTU(0xa5a5a5a5a5a5a1b4, 18, 28, 0x0000000009696969)
	DEP( 0xa5a5a5a5a5a5a1b4, 134217727, 18, 28, 0xa5a59ffffffda1b4)
	EXT( 0xa5a5a5a5a5a5a1b3, 18, 29, 0xfffffffff2d2d2d2)
	EXTU(0xa5a5a5a5a5a5a1b3, 18, 29, 0x0000000012d2d2d2)
	DEP( 0xa5a5a5a5a5a5a1b3, 268435455, 18, 29, 0xa5a59fffffffa1b3)
	EXT( 0xa5a5a5a5a5a5a1b2, 18, 30, 0xffffffffe5a5a5a5)
	EXTU(0xa5a5a5a5a5a5a1b2, 18, 30, 0x0000000025a5a5a5)
	DEP( 0xa5a5a5a5a5a5a1b2, 536870911, 18, 30, 0xa5a59fffffffa1b2)
	EXT( 0xa5a5a5a5a5a5a1b1, 18, 31, 0xffffffffcb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a1b1, 18, 31, 0x000000004b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a1b1, 1073741823, 18, 31, 0xa5a59fffffffa1b1)
	EXT( 0xa5a5a5a5a5a5a1b0, 18, 32, 0xffffffff96969696)
	EXTU(0xa5a5a5a5a5a5a1b0, 18, 32, 0x0000000096969696)
	DEP( 0xa5a5a5a5a5a5a1b0, 2147483647, 18, 32, 0xa5a59fffffffe1b0)
	EXT( 0xa5a5a5a5a5a5a1af, 18, 33, 0xffffffff2d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a1af, 18, 33, 0x000000012d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a1af, 4294967295, 18, 33, 0xa5a59fffffffe1af)
	EXT( 0xa5a5a5a5a5a5a1ae, 18, 34, 0xfffffffe5a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a1ae, 18, 34, 0x000000025a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a1ae, 8589934591, 18, 34, 0xa5a59ffffffff1ae)
	EXT( 0xa5a5a5a5a5a5a1ad, 18, 35, 0xfffffffcb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a1ad, 18, 35, 0x00000004b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a1ad, 17179869183, 18, 35, 0xa5a59ffffffff9ad)
	EXT( 0xa5a5a5a5a5a5a1ac, 18, 36, 0xfffffff969696968)
	EXTU(0xa5a5a5a5a5a5a1ac, 18, 36, 0x0000000969696968)
	DEP( 0xa5a5a5a5a5a5a1ac, 34359738367, 18, 36, 0xa5a59ffffffffdac)
	EXT( 0xa5a5a5a5a5a5a1ab, 18, 37, 0xfffffff2d2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a1ab, 18, 37, 0x00000012d2d2d2d0)
	DEP( 0xa5a5a5a5a5a5a1ab, 68719476735, 18, 37, 0xa5a59fffffffffab)
	EXT( 0xa5a5a5a5a5a5a1aa, 18, 38, 0xffffffe5a5a5a5a1)
	EXTU(0xa5a5a5a5a5a5a1aa, 18, 38, 0x00000025a5a5a5a1)
	DEP( 0xa5a5a5a5a5a5a1aa, 137438953471, 18, 38, 0xa5a59fffffffffaa)
	EXT( 0xa5a5a5a5a5a5a1a9, 18, 39, 0xffffffcb4b4b4b43)
	EXTU(0xa5a5a5a5a5a5a1a9, 18, 39, 0x0000004b4b4b4b43)
	DEP( 0xa5a5a5a5a5a5a1a9, 274877906943, 18, 39, 0xa5a59fffffffffa9)
	EXT( 0xa5a5a5a5a5a5a1a8, 18, 40, 0xffffff9696969686)
	EXTU(0xa5a5a5a5a5a5a1a8, 18, 40, 0x0000009696969686)
	DEP( 0xa5a5a5a5a5a5a1a8, 549755813887, 18, 40, 0xa5a59fffffffffe8)
	EXT( 0xa5a5a5a5a5a5a1a7, 18, 41, 0xffffff2d2d2d2d0d)
	EXTU(0xa5a5a5a5a5a5a1a7, 18, 41, 0x0000012d2d2d2d0d)
	DEP( 0xa5a5a5a5a5a5a1a7, 1099511627775, 18, 41, 0xa5a59fffffffffe7)
	EXT( 0xa5a5a5a5a5a5a1a6, 18, 42, 0xfffffe5a5a5a5a1a)
	EXTU(0xa5a5a5a5a5a5a1a6, 18, 42, 0x0000025a5a5a5a1a)
	DEP( 0xa5a5a5a5a5a5a1a6, 2199023255551, 18, 42, 0xa5a59ffffffffff6)
	EXT( 0xa5a5a5a5a5a5a1a5, 18, 43, 0xfffffcb4b4b4b434)
	EXTU(0xa5a5a5a5a5a5a1a5, 18, 43, 0x000004b4b4b4b434)
	DEP( 0xa5a5a5a5a5a5a1a5, 4398046511103, 18, 43, 0xa5a59ffffffffffd)
	EXT( 0xa5a5a5a5a5a5a1a4, 18, 44, 0xfffff96969696869)
	EXTU(0xa5a5a5a5a5a5a1a4, 18, 44, 0x0000096969696869)
	DEP( 0xa5a5a5a5a5a5a1a4, 8796093022207, 18, 44, 0xa5a59ffffffffffc)
	EXT( 0xa5a5a5a5a5a5a1a3, 18, 45, 0xfffff2d2d2d2d0d1)
	EXTU(0xa5a5a5a5a5a5a1a3, 18, 45, 0x000012d2d2d2d0d1)
	DEP( 0xa5a5a5a5a5a5a1a3, 17592186044415, 18, 45, 0xa5a59fffffffffff)
	EXT( 0xa5a5a5a5a5a5a1a2, 19, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a1a2, 19, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a1a2, 0, 19, 1, 0xa5a5a5a5a5a5a1a2)
	EXT( 0xa5a5a5a5a5a5a1a1, 19, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a1a1, 19, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a1a1, 1, 19, 2, 0xa5a5ada5a5a5a1a1)
	EXT( 0xa5a5a5a5a5a5a1a0, 19, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a1a0, 19, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a1a0, 3, 19, 3, 0xa5a5ada5a5a5a1a0)
	EXT( 0xa5a5a5a5a5a5a19f, 19, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a19f, 19, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a19f, 7, 19, 4, 0xa5a5afa5a5a5a19f)
	EXT( 0xa5a5a5a5a5a5a19e, 19, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a19e, 19, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a19e, 15, 19, 5, 0xa5a5afa5a5a5a19e)
	EXT( 0xa5a5a5a5a5a5a19d, 19, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a19d, 19, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a19d, 31, 19, 6, 0xa5a5afa5a5a5a19d)
	EXT( 0xa5a5a5a5a5a5a19c, 19, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a19c, 19, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a19c, 63, 19, 7, 0xa5a5afe5a5a5a19c)
	EXT( 0xa5a5a5a5a5a5a19b, 19, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a19b, 19, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a19b, 127, 19, 8, 0xa5a5afe5a5a5a19b)
	EXT( 0xa5a5a5a5a5a5a19a, 19, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a19a, 19, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a19a, 255, 19, 9, 0xa5a5aff5a5a5a19a)
	EXT( 0xa5a5a5a5a5a5a199, 19, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a199, 19, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a199, 511, 19, 10, 0xa5a5affda5a5a199)
	EXT( 0xa5a5a5a5a5a5a198, 19, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a198, 19, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a198, 1023, 19, 11, 0xa5a5affda5a5a198)
	EXT( 0xa5a5a5a5a5a5a197, 19, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a197, 19, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a197, 2047, 19, 12, 0xa5a5afffa5a5a197)
	EXT( 0xa5a5a5a5a5a5a196, 19, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a196, 19, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a196, 4095, 19, 13, 0xa5a5afffa5a5a196)
	EXT( 0xa5a5a5a5a5a5a195, 19, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a195, 19, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a195, 8191, 19, 14, 0xa5a5afffa5a5a195)
	EXT( 0xa5a5a5a5a5a5a194, 19, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a194, 19, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a194, 16383, 19, 15, 0xa5a5afffe5a5a194)
	EXT( 0xa5a5a5a5a5a5a193, 19, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a193, 19, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a193, 32767, 19, 16, 0xa5a5afffe5a5a193)
	EXT( 0xa5a5a5a5a5a5a192, 19, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a192, 19, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a192, 65535, 19, 17, 0xa5a5affff5a5a192)
	EXT( 0xa5a5a5a5a5a5a191, 19, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a191, 19, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a191, 131071, 19, 18, 0xa5a5affffda5a191)
	EXT( 0xa5a5a5a5a5a5a190, 19, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a190, 19, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a190, 262143, 19, 19, 0xa5a5affffda5a190)
	EXT( 0xa5a5a5a5a5a5a18f, 19, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a18f, 19, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a18f, 524287, 19, 20, 0xa5a5afffffa5a18f)
	EXT( 0xa5a5a5a5a5a5a18e, 19, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a18e, 19, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a18e, 1048575, 19, 21, 0xa5a5afffffa5a18e)
	EXT( 0xa5a5a5a5a5a5a18d, 19, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a18d, 19, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a18d, 2097151, 19, 22, 0xa5a5afffffa5a18d)
	EXT( 0xa5a5a5a5a5a5a18c, 19, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a18c, 19, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a18c, 4194303, 19, 23, 0xa5a5afffffe5a18c)
	EXT( 0xa5a5a5a5a5a5a18b, 19, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a18b, 19, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a18b, 8388607, 19, 24, 0xa5a5afffffe5a18b)
	EXT( 0xa5a5a5a5a5a5a18a, 19, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a18a, 19, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a18a, 16777215, 19, 25, 0xa5a5affffff5a18a)
	EXT( 0xa5a5a5a5a5a5a189, 19, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a189, 19, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a189, 33554431, 19, 26, 0xa5a5affffffda189)
	EXT( 0xa5a5a5a5a5a5a188, 19, 27, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a188, 19, 27, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a188, 67108863, 19, 27, 0xa5a5affffffda188)
	EXT( 0xa5a5a5a5a5a5a187, 19, 28, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a187, 19, 28, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a187, 134217727, 19, 28, 0xa5a5afffffffa187)
	EXT( 0xa5a5a5a5a5a5a186, 19, 29, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a186, 19, 29, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a186, 268435455, 19, 29, 0xa5a5afffffffa186)
	EXT( 0xa5a5a5a5a5a5a185, 19, 30, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a185, 19, 30, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a185, 536870911, 19, 30, 0xa5a5afffffffa185)
	EXT( 0xa5a5a5a5a5a5a184, 19, 31, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a184, 19, 31, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a184, 1073741823, 19, 31, 0xa5a5afffffffe184)
	EXT( 0xa5a5a5a5a5a5a183, 19, 32, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a183, 19, 32, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a183, 2147483647, 19, 32, 0xa5a5afffffffe183)
	EXT( 0xa5a5a5a5a5a5a182, 19, 33, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a182, 19, 33, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a182, 4294967295, 19, 33, 0xa5a5affffffff182)
	EXT( 0xa5a5a5a5a5a5a181, 19, 34, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a181, 19, 34, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a181, 8589934591, 19, 34, 0xa5a5affffffff981)
	EXT( 0xa5a5a5a5a5a5a180, 19, 35, 0x0000000169696968)
	EXTU(0xa5a5a5a5a5a5a180, 19, 35, 0x0000000169696968)
	DEP( 0xa5a5a5a5a5a5a180, 17179869183, 19, 35, 0xa5a5affffffffd80)
	EXT( 0xa5a5a5a5a5a5a17f, 19, 36, 0x00000002d2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a17f, 19, 36, 0x00000002d2d2d2d0)
	DEP( 0xa5a5a5a5a5a5a17f, 34359738367, 19, 36, 0xa5a5afffffffff7f)
	EXT( 0xa5a5a5a5a5a5a17e, 19, 37, 0x00000005a5a5a5a1)
	EXTU(0xa5a5a5a5a5a5a17e, 19, 37, 0x00000005a5a5a5a1)
	DEP( 0xa5a5a5a5a5a5a17e, 68719476735, 19, 37, 0xa5a5afffffffff7e)
	EXT( 0xa5a5a5a5a5a5a17d, 19, 38, 0x0000000b4b4b4b42)
	EXTU(0xa5a5a5a5a5a5a17d, 19, 38, 0x0000000b4b4b4b42)
	DEP( 0xa5a5a5a5a5a5a17d, 137438953471, 19, 38, 0xa5a5affffffffffd)
	EXT( 0xa5a5a5a5a5a5a17c, 19, 39, 0x0000001696969685)
	EXTU(0xa5a5a5a5a5a5a17c, 19, 39, 0x0000001696969685)
	DEP( 0xa5a5a5a5a5a5a17c, 274877906943, 19, 39, 0xa5a5affffffffffc)
	EXT( 0xa5a5a5a5a5a5a17b, 19, 40, 0x0000002d2d2d2d0b)
	EXTU(0xa5a5a5a5a5a5a17b, 19, 40, 0x0000002d2d2d2d0b)
	DEP( 0xa5a5a5a5a5a5a17b, 549755813887, 19, 40, 0xa5a5affffffffffb)
	EXT( 0xa5a5a5a5a5a5a17a, 19, 41, 0x0000005a5a5a5a17)
	EXTU(0xa5a5a5a5a5a5a17a, 19, 41, 0x0000005a5a5a5a17)
	DEP( 0xa5a5a5a5a5a5a17a, 1099511627775, 19, 41, 0xa5a5affffffffffa)
	EXT( 0xa5a5a5a5a5a5a179, 19, 42, 0x000000b4b4b4b42f)
	EXTU(0xa5a5a5a5a5a5a179, 19, 42, 0x000000b4b4b4b42f)
	DEP( 0xa5a5a5a5a5a5a179, 2199023255551, 19, 42, 0xa5a5affffffffff9)
	EXT( 0xa5a5a5a5a5a5a178, 19, 43, 0x000001696969685e)
	EXTU(0xa5a5a5a5a5a5a178, 19, 43, 0x000001696969685e)
	DEP( 0xa5a5a5a5a5a5a178, 4398046511103, 19, 43, 0xa5a5affffffffffc)
	EXT( 0xa5a5a5a5a5a5a177, 19, 44, 0x000002d2d2d2d0bb)
	EXTU(0xa5a5a5a5a5a5a177, 19, 44, 0x000002d2d2d2d0bb)
	DEP( 0xa5a5a5a5a5a5a177, 8796093022207, 19, 44, 0xa5a5afffffffffff)
	EXT( 0xa5a5a5a5a5a5a176, 20, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a176, 20, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a176, 0, 20, 1, 0xa5a5a5a5a5a5a176)
	EXT( 0xa5a5a5a5a5a5a175, 20, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a175, 20, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a175, 1, 20, 2, 0xa5a5a5a5a5a5a175)
	EXT( 0xa5a5a5a5a5a5a174, 20, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a174, 20, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a174, 3, 20, 3, 0xa5a5a7a5a5a5a174)
	EXT( 0xa5a5a5a5a5a5a173, 20, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a173, 20, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a173, 7, 20, 4, 0xa5a5a7a5a5a5a173)
	EXT( 0xa5a5a5a5a5a5a172, 20, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a172, 20, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a172, 15, 20, 5, 0xa5a5a7a5a5a5a172)
	EXT( 0xa5a5a5a5a5a5a171, 20, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a171, 20, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a171, 31, 20, 6, 0xa5a5a7e5a5a5a171)
	EXT( 0xa5a5a5a5a5a5a170, 20, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a170, 20, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a170, 63, 20, 7, 0xa5a5a7e5a5a5a170)
	EXT( 0xa5a5a5a5a5a5a16f, 20, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a16f, 20, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a16f, 127, 20, 8, 0xa5a5a7f5a5a5a16f)
	EXT( 0xa5a5a5a5a5a5a16e, 20, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a16e, 20, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a16e, 255, 20, 9, 0xa5a5a7fda5a5a16e)
	EXT( 0xa5a5a5a5a5a5a16d, 20, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a16d, 20, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a16d, 511, 20, 10, 0xa5a5a7fda5a5a16d)
	EXT( 0xa5a5a5a5a5a5a16c, 20, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a16c, 20, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a16c, 1023, 20, 11, 0xa5a5a7ffa5a5a16c)
	EXT( 0xa5a5a5a5a5a5a16b, 20, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a16b, 20, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a16b, 2047, 20, 12, 0xa5a5a7ffa5a5a16b)
	EXT( 0xa5a5a5a5a5a5a16a, 20, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a16a, 20, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a16a, 4095, 20, 13, 0xa5a5a7ffa5a5a16a)
	EXT( 0xa5a5a5a5a5a5a169, 20, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a169, 20, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a169, 8191, 20, 14, 0xa5a5a7ffe5a5a169)
	EXT( 0xa5a5a5a5a5a5a168, 20, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a168, 20, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a168, 16383, 20, 15, 0xa5a5a7ffe5a5a168)
	EXT( 0xa5a5a5a5a5a5a167, 20, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a167, 20, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a167, 32767, 20, 16, 0xa5a5a7fff5a5a167)
	EXT( 0xa5a5a5a5a5a5a166, 20, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a166, 20, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a166, 65535, 20, 17, 0xa5a5a7fffda5a166)
	EXT( 0xa5a5a5a5a5a5a165, 20, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a165, 20, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a165, 131071, 20, 18, 0xa5a5a7fffda5a165)
	EXT( 0xa5a5a5a5a5a5a164, 20, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a164, 20, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a164, 262143, 20, 19, 0xa5a5a7ffffa5a164)
	EXT( 0xa5a5a5a5a5a5a163, 20, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a163, 20, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a163, 524287, 20, 20, 0xa5a5a7ffffa5a163)
	EXT( 0xa5a5a5a5a5a5a162, 20, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a162, 20, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a162, 1048575, 20, 21, 0xa5a5a7ffffa5a162)
	EXT( 0xa5a5a5a5a5a5a161, 20, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a161, 20, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a161, 2097151, 20, 22, 0xa5a5a7ffffe5a161)
	EXT( 0xa5a5a5a5a5a5a160, 20, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a160, 20, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a160, 4194303, 20, 23, 0xa5a5a7ffffe5a160)
	EXT( 0xa5a5a5a5a5a5a15f, 20, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a15f, 20, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a15f, 8388607, 20, 24, 0xa5a5a7fffff5a15f)
	EXT( 0xa5a5a5a5a5a5a15e, 20, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a15e, 20, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a15e, 16777215, 20, 25, 0xa5a5a7fffffda15e)
	EXT( 0xa5a5a5a5a5a5a15d, 20, 26, 0x0000000001696969)
	EXTU(0xa5a5a5a5a5a5a15d, 20, 26, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a15d, 33554431, 20, 26, 0xa5a5a7fffffda15d)
	EXT( 0xa5a5a5a5a5a5a15c, 20, 27, 0x0000000002d2d2d2)
	EXTU(0xa5a5a5a5a5a5a15c, 20, 27, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a15c, 67108863, 20, 27, 0xa5a5a7ffffffa15c)
	EXT( 0xa5a5a5a5a5a5a15b, 20, 28, 0x0000000005a5a5a5)
	EXTU(0xa5a5a5a5a5a5a15b, 20, 28, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a15b, 134217727, 20, 28, 0xa5a5a7ffffffa15b)
	EXT( 0xa5a5a5a5a5a5a15a, 20, 29, 0x000000000b4b4b4b)
	EXTU(0xa5a5a5a5a5a5a15a, 20, 29, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a15a, 268435455, 20, 29, 0xa5a5a7ffffffa15a)
	EXT( 0xa5a5a5a5a5a5a159, 20, 30, 0x0000000016969696)
	EXTU(0xa5a5a5a5a5a5a159, 20, 30, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a159, 536870911, 20, 30, 0xa5a5a7ffffffe159)
	EXT( 0xa5a5a5a5a5a5a158, 20, 31, 0x000000002d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a158, 20, 31, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a158, 1073741823, 20, 31, 0xa5a5a7ffffffe158)
	EXT( 0xa5a5a5a5a5a5a157, 20, 32, 0x000000005a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a157, 20, 32, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a157, 2147483647, 20, 32, 0xa5a5a7fffffff157)
	EXT( 0xa5a5a5a5a5a5a156, 20, 33, 0x00000000b4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a156, 20, 33, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a156, 4294967295, 20, 33, 0xa5a5a7fffffff956)
	EXT( 0xa5a5a5a5a5a5a155, 20, 34, 0x0000000169696968)
	EXTU(0xa5a5a5a5a5a5a155, 20, 34, 0x0000000169696968)
	DEP( 0xa5a5a5a5a5a5a155, 8589934591, 20, 34, 0xa5a5a7fffffffd55)
	EXT( 0xa5a5a5a5a5a5a154, 20, 35, 0x00000002d2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a154, 20, 35, 0x00000002d2d2d2d0)
	DEP( 0xa5a5a5a5a5a5a154, 17179869183, 20, 35, 0xa5a5a7ffffffff54)
	EXT( 0xa5a5a5a5a5a5a153, 20, 36, 0x00000005a5a5a5a1)
	EXTU(0xa5a5a5a5a5a5a153, 20, 36, 0x00000005a5a5a5a1)
	DEP( 0xa5a5a5a5a5a5a153, 34359738367, 20, 36, 0xa5a5a7ffffffff53)
	EXT( 0xa5a5a5a5a5a5a152, 20, 37, 0x0000000b4b4b4b42)
	EXTU(0xa5a5a5a5a5a5a152, 20, 37, 0x0000000b4b4b4b42)
	DEP( 0xa5a5a5a5a5a5a152, 68719476735, 20, 37, 0xa5a5a7ffffffffd2)
	EXT( 0xa5a5a5a5a5a5a151, 20, 38, 0x0000001696969685)
	EXTU(0xa5a5a5a5a5a5a151, 20, 38, 0x0000001696969685)
	DEP( 0xa5a5a5a5a5a5a151, 137438953471, 20, 38, 0xa5a5a7ffffffffd1)
	EXT( 0xa5a5a5a5a5a5a150, 20, 39, 0x0000002d2d2d2d0a)
	EXTU(0xa5a5a5a5a5a5a150, 20, 39, 0x0000002d2d2d2d0a)
	DEP( 0xa5a5a5a5a5a5a150, 274877906943, 20, 39, 0xa5a5a7fffffffff0)
	EXT( 0xa5a5a5a5a5a5a14f, 20, 40, 0x0000005a5a5a5a14)
	EXTU(0xa5a5a5a5a5a5a14f, 20, 40, 0x0000005a5a5a5a14)
	DEP( 0xa5a5a5a5a5a5a14f, 549755813887, 20, 40, 0xa5a5a7ffffffffff)
	EXT( 0xa5a5a5a5a5a5a14e, 20, 41, 0x000000b4b4b4b429)
	EXTU(0xa5a5a5a5a5a5a14e, 20, 41, 0x000000b4b4b4b429)
	DEP( 0xa5a5a5a5a5a5a14e, 1099511627775, 20, 41, 0xa5a5a7fffffffffe)
	EXT( 0xa5a5a5a5a5a5a14d, 20, 42, 0x0000016969696853)
	EXTU(0xa5a5a5a5a5a5a14d, 20, 42, 0x0000016969696853)
	DEP( 0xa5a5a5a5a5a5a14d, 2199023255551, 20, 42, 0xa5a5a7fffffffffd)
	EXT( 0xa5a5a5a5a5a5a14c, 20, 43, 0x000002d2d2d2d0a6)
	EXTU(0xa5a5a5a5a5a5a14c, 20, 43, 0x000002d2d2d2d0a6)
	DEP( 0xa5a5a5a5a5a5a14c, 4398046511103, 20, 43, 0xa5a5a7fffffffffe)
	EXT( 0xa5a5a5a5a5a5a14b, 21, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a14b, 21, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a14b, 0, 21, 1, 0xa5a5a1a5a5a5a14b)
	EXT( 0xa5a5a5a5a5a5a14a, 21, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a14a, 21, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a14a, 1, 21, 2, 0xa5a5a3a5a5a5a14a)
	EXT( 0xa5a5a5a5a5a5a149, 21, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a149, 21, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a149, 3, 21, 3, 0xa5a5a3a5a5a5a149)
	EXT( 0xa5a5a5a5a5a5a148, 21, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a5a148, 21, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a148, 7, 21, 4, 0xa5a5a3a5a5a5a148)
	EXT( 0xa5a5a5a5a5a5a147, 21, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a5a147, 21, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a147, 15, 21, 5, 0xa5a5a3e5a5a5a147)
	EXT( 0xa5a5a5a5a5a5a146, 21, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a5a146, 21, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a146, 31, 21, 6, 0xa5a5a3e5a5a5a146)
	EXT( 0xa5a5a5a5a5a5a145, 21, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a5a145, 21, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a145, 63, 21, 7, 0xa5a5a3f5a5a5a145)
	EXT( 0xa5a5a5a5a5a5a144, 21, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a5a144, 21, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a144, 127, 21, 8, 0xa5a5a3fda5a5a144)
	EXT( 0xa5a5a5a5a5a5a143, 21, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a5a143, 21, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a143, 255, 21, 9, 0xa5a5a3fda5a5a143)
	EXT( 0xa5a5a5a5a5a5a142, 21, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a5a142, 21, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a142, 511, 21, 10, 0xa5a5a3ffa5a5a142)
	EXT( 0xa5a5a5a5a5a5a141, 21, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a5a141, 21, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a141, 1023, 21, 11, 0xa5a5a3ffa5a5a141)
	EXT( 0xa5a5a5a5a5a5a140, 21, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a5a140, 21, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a140, 2047, 21, 12, 0xa5a5a3ffa5a5a140)
	EXT( 0xa5a5a5a5a5a5a13f, 21, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a5a13f, 21, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a13f, 4095, 21, 13, 0xa5a5a3ffe5a5a13f)
	EXT( 0xa5a5a5a5a5a5a13e, 21, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a5a13e, 21, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a13e, 8191, 21, 14, 0xa5a5a3ffe5a5a13e)
	EXT( 0xa5a5a5a5a5a5a13d, 21, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a5a13d, 21, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a13d, 16383, 21, 15, 0xa5a5a3fff5a5a13d)
	EXT( 0xa5a5a5a5a5a5a13c, 21, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a5a13c, 21, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a13c, 32767, 21, 16, 0xa5a5a3fffda5a13c)
	EXT( 0xa5a5a5a5a5a5a13b, 21, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a5a13b, 21, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a13b, 65535, 21, 17, 0xa5a5a3fffda5a13b)
	EXT( 0xa5a5a5a5a5a5a13a, 21, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a5a13a, 21, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a13a, 131071, 21, 18, 0xa5a5a3ffffa5a13a)
	EXT( 0xa5a5a5a5a5a5a139, 21, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a5a139, 21, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a139, 262143, 21, 19, 0xa5a5a3ffffa5a139)
	EXT( 0xa5a5a5a5a5a5a138, 21, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a5a138, 21, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a138, 524287, 21, 20, 0xa5a5a3ffffa5a138)
	EXT( 0xa5a5a5a5a5a5a137, 21, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a5a137, 21, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a137, 1048575, 21, 21, 0xa5a5a3ffffe5a137)
	EXT( 0xa5a5a5a5a5a5a136, 21, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a5a136, 21, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a136, 2097151, 21, 22, 0xa5a5a3ffffe5a136)
	EXT( 0xa5a5a5a5a5a5a135, 21, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a5a135, 21, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a135, 4194303, 21, 23, 0xa5a5a3fffff5a135)
	EXT( 0xa5a5a5a5a5a5a134, 21, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a5a134, 21, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a134, 8388607, 21, 24, 0xa5a5a3fffffda134)
	EXT( 0xa5a5a5a5a5a5a133, 21, 25, 0xffffffffff696969)
	EXTU(0xa5a5a5a5a5a5a133, 21, 25, 0x0000000001696969)
	DEP( 0xa5a5a5a5a5a5a133, 16777215, 21, 25, 0xa5a5a3fffffda133)
	EXT( 0xa5a5a5a5a5a5a132, 21, 26, 0xfffffffffed2d2d2)
	EXTU(0xa5a5a5a5a5a5a132, 21, 26, 0x0000000002d2d2d2)
	DEP( 0xa5a5a5a5a5a5a132, 33554431, 21, 26, 0xa5a5a3ffffffa132)
	EXT( 0xa5a5a5a5a5a5a131, 21, 27, 0xfffffffffda5a5a5)
	EXTU(0xa5a5a5a5a5a5a131, 21, 27, 0x0000000005a5a5a5)
	DEP( 0xa5a5a5a5a5a5a131, 67108863, 21, 27, 0xa5a5a3ffffffa131)
	EXT( 0xa5a5a5a5a5a5a130, 21, 28, 0xfffffffffb4b4b4b)
	EXTU(0xa5a5a5a5a5a5a130, 21, 28, 0x000000000b4b4b4b)
	DEP( 0xa5a5a5a5a5a5a130, 134217727, 21, 28, 0xa5a5a3ffffffa130)
	EXT( 0xa5a5a5a5a5a5a12f, 21, 29, 0xfffffffff6969696)
	EXTU(0xa5a5a5a5a5a5a12f, 21, 29, 0x0000000016969696)
	DEP( 0xa5a5a5a5a5a5a12f, 268435455, 21, 29, 0xa5a5a3ffffffe12f)
	EXT( 0xa5a5a5a5a5a5a12e, 21, 30, 0xffffffffed2d2d2d)
	EXTU(0xa5a5a5a5a5a5a12e, 21, 30, 0x000000002d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a12e, 536870911, 21, 30, 0xa5a5a3ffffffe12e)
	EXT( 0xa5a5a5a5a5a5a12d, 21, 31, 0xffffffffda5a5a5a)
	EXTU(0xa5a5a5a5a5a5a12d, 21, 31, 0x000000005a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a12d, 1073741823, 21, 31, 0xa5a5a3fffffff12d)
	EXT( 0xa5a5a5a5a5a5a12c, 21, 32, 0xffffffffb4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a12c, 21, 32, 0x00000000b4b4b4b4)
	DEP( 0xa5a5a5a5a5a5a12c, 2147483647, 21, 32, 0xa5a5a3fffffff92c)
	EXT( 0xa5a5a5a5a5a5a12b, 21, 33, 0xffffffff69696968)
	EXTU(0xa5a5a5a5a5a5a12b, 21, 33, 0x0000000169696968)
	DEP( 0xa5a5a5a5a5a5a12b, 4294967295, 21, 33, 0xa5a5a3fffffffd2b)
	EXT( 0xa5a5a5a5a5a5a12a, 21, 34, 0xfffffffed2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a12a, 21, 34, 0x00000002d2d2d2d0)
	DEP( 0xa5a5a5a5a5a5a12a, 8589934591, 21, 34, 0xa5a5a3ffffffff2a)
	EXT( 0xa5a5a5a5a5a5a129, 21, 35, 0xfffffffda5a5a5a1)
	EXTU(0xa5a5a5a5a5a5a129, 21, 35, 0x00000005a5a5a5a1)
	DEP( 0xa5a5a5a5a5a5a129, 17179869183, 21, 35, 0xa5a5a3ffffffff29)
	EXT( 0xa5a5a5a5a5a5a128, 21, 36, 0xfffffffb4b4b4b42)
	EXTU(0xa5a5a5a5a5a5a128, 21, 36, 0x0000000b4b4b4b42)
	DEP( 0xa5a5a5a5a5a5a128, 34359738367, 21, 36, 0xa5a5a3ffffffffa8)
	EXT( 0xa5a5a5a5a5a5a127, 21, 37, 0xfffffff696969684)
	EXTU(0xa5a5a5a5a5a5a127, 21, 37, 0x0000001696969684)
	DEP( 0xa5a5a5a5a5a5a127, 68719476735, 21, 37, 0xa5a5a3ffffffffe7)
	EXT( 0xa5a5a5a5a5a5a126, 21, 38, 0xffffffed2d2d2d09)
	EXTU(0xa5a5a5a5a5a5a126, 21, 38, 0x0000002d2d2d2d09)
	DEP( 0xa5a5a5a5a5a5a126, 137438953471, 21, 38, 0xa5a5a3ffffffffe6)
	EXT( 0xa5a5a5a5a5a5a125, 21, 39, 0xffffffda5a5a5a12)
	EXTU(0xa5a5a5a5a5a5a125, 21, 39, 0x0000005a5a5a5a12)
	DEP( 0xa5a5a5a5a5a5a125, 274877906943, 21, 39, 0xa5a5a3fffffffff5)
	EXT( 0xa5a5a5a5a5a5a124, 21, 40, 0xffffffb4b4b4b424)
	EXTU(0xa5a5a5a5a5a5a124, 21, 40, 0x000000b4b4b4b424)
	DEP( 0xa5a5a5a5a5a5a124, 549755813887, 21, 40, 0xa5a5a3fffffffffc)
	EXT( 0xa5a5a5a5a5a5a123, 21, 41, 0xffffff6969696848)
	EXTU(0xa5a5a5a5a5a5a123, 21, 41, 0x0000016969696848)
	DEP( 0xa5a5a5a5a5a5a123, 1099511627775, 21, 41, 0xa5a5a3ffffffffff)
	EXT( 0xa5a5a5a5a5a5a122, 21, 42, 0xfffffed2d2d2d091)
	EXTU(0xa5a5a5a5a5a5a122, 21, 42, 0x000002d2d2d2d091)
	DEP( 0xa5a5a5a5a5a5a122, 2199023255551, 21, 42, 0xa5a5a3fffffffffe)
	EXT( 0xa5a5a5a5a5a5a121, 22, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a121, 22, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a121, 0, 22, 1, 0xa5a5a5a5a5a5a121)
	EXT( 0xa5a5a5a5a5a5a120, 22, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a120, 22, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a120, 1, 22, 2, 0xa5a5a5a5a5a5a120)
	EXT( 0xa5a5a5a5a5a5a11f, 22, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a5a11f, 22, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a11f, 3, 22, 3, 0xa5a5a5a5a5a5a11f)
	EXT( 0xa5a5a5a5a5a5a11e, 22, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a5a11e, 22, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a11e, 7, 22, 4, 0xa5a5a5e5a5a5a11e)
	EXT( 0xa5a5a5a5a5a5a11d, 22, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a5a11d, 22, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a11d, 15, 22, 5, 0xa5a5a5e5a5a5a11d)
	EXT( 0xa5a5a5a5a5a5a11c, 22, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a5a11c, 22, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a11c, 31, 22, 6, 0xa5a5a5f5a5a5a11c)
	EXT( 0xa5a5a5a5a5a5a11b, 22, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a5a11b, 22, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a11b, 63, 22, 7, 0xa5a5a5fda5a5a11b)
	EXT( 0xa5a5a5a5a5a5a11a, 22, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a5a11a, 22, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a11a, 127, 22, 8, 0xa5a5a5fda5a5a11a)
	EXT( 0xa5a5a5a5a5a5a119, 22, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a5a119, 22, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a119, 255, 22, 9, 0xa5a5a5ffa5a5a119)
	EXT( 0xa5a5a5a5a5a5a118, 22, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a5a118, 22, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a118, 511, 22, 10, 0xa5a5a5ffa5a5a118)
	EXT( 0xa5a5a5a5a5a5a117, 22, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a5a117, 22, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a117, 1023, 22, 11, 0xa5a5a5ffa5a5a117)
	EXT( 0xa5a5a5a5a5a5a116, 22, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a5a116, 22, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a116, 2047, 22, 12, 0xa5a5a5ffe5a5a116)
	EXT( 0xa5a5a5a5a5a5a115, 22, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a5a115, 22, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a115, 4095, 22, 13, 0xa5a5a5ffe5a5a115)
	EXT( 0xa5a5a5a5a5a5a114, 22, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a5a114, 22, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a114, 8191, 22, 14, 0xa5a5a5fff5a5a114)
	EXT( 0xa5a5a5a5a5a5a113, 22, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a5a113, 22, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a113, 16383, 22, 15, 0xa5a5a5fffda5a113)
	EXT( 0xa5a5a5a5a5a5a112, 22, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a5a112, 22, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a112, 32767, 22, 16, 0xa5a5a5fffda5a112)
	EXT( 0xa5a5a5a5a5a5a111, 22, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a5a111, 22, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a111, 65535, 22, 17, 0xa5a5a5ffffa5a111)
	EXT( 0xa5a5a5a5a5a5a110, 22, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a5a110, 22, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a110, 131071, 22, 18, 0xa5a5a5ffffa5a110)
	EXT( 0xa5a5a5a5a5a5a10f, 22, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a5a10f, 22, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a10f, 262143, 22, 19, 0xa5a5a5ffffa5a10f)
	EXT( 0xa5a5a5a5a5a5a10e, 22, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a5a10e, 22, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a10e, 524287, 22, 20, 0xa5a5a5ffffe5a10e)
	EXT( 0xa5a5a5a5a5a5a10d, 22, 21, 0x00000000000d2d2d)
	EXTU(0xa5a5a5a5a5a5a10d, 22, 21, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a10d, 1048575, 22, 21, 0xa5a5a5ffffe5a10d)
	EXT( 0xa5a5a5a5a5a5a10c, 22, 22, 0x00000000001a5a5a)
	EXTU(0xa5a5a5a5a5a5a10c, 22, 22, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a10c, 2097151, 22, 22, 0xa5a5a5fffff5a10c)
	EXT( 0xa5a5a5a5a5a5a10b, 22, 23, 0x000000000034b4b4)
	EXTU(0xa5a5a5a5a5a5a10b, 22, 23, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a10b, 4194303, 22, 23, 0xa5a5a5fffffda10b)
	EXT( 0xa5a5a5a5a5a5a10a, 22, 24, 0x0000000000696969)
	EXTU(0xa5a5a5a5a5a5a10a, 22, 24, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a10a, 8388607, 22, 24, 0xa5a5a5fffffda10a)
	EXT( 0xa5a5a5a5a5a5a109, 22, 25, 0x0000000000d2d2d2)
	EXTU(0xa5a5a5a5a5a5a109, 22, 25, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a109, 16777215, 22, 25, 0xa5a5a5ffffffa109)
	EXT( 0xa5a5a5a5a5a5a108, 22, 26, 0x0000000001a5a5a5)
	EXTU(0xa5a5a5a5a5a5a108, 22, 26, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a108, 33554431, 22, 26, 0xa5a5a5ffffffa108)
	EXT( 0xa5a5a5a5a5a5a107, 22, 27, 0x00000000034b4b4b)
	EXTU(0xa5a5a5a5a5a5a107, 22, 27, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a107, 67108863, 22, 27, 0xa5a5a5ffffffa107)
	EXT( 0xa5a5a5a5a5a5a106, 22, 28, 0x0000000006969696)
	EXTU(0xa5a5a5a5a5a5a106, 22, 28, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a106, 134217727, 22, 28, 0xa5a5a5ffffffe106)
	EXT( 0xa5a5a5a5a5a5a105, 22, 29, 0x000000000d2d2d2d)
	EXTU(0xa5a5a5a5a5a5a105, 22, 29, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a105, 268435455, 22, 29, 0xa5a5a5ffffffe105)
	EXT( 0xa5a5a5a5a5a5a104, 22, 30, 0x000000001a5a5a5a)
	EXTU(0xa5a5a5a5a5a5a104, 22, 30, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a104, 536870911, 22, 30, 0xa5a5a5fffffff104)
	EXT( 0xa5a5a5a5a5a5a103, 22, 31, 0x0000000034b4b4b4)
	EXTU(0xa5a5a5a5a5a5a103, 22, 31, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a103, 1073741823, 22, 31, 0xa5a5a5fffffff903)
	EXT( 0xa5a5a5a5a5a5a102, 22, 32, 0x0000000069696968)
	EXTU(0xa5a5a5a5a5a5a102, 22, 32, 0x0000000069696968)
	DEP( 0xa5a5a5a5a5a5a102, 2147483647, 22, 32, 0xa5a5a5fffffffd02)
	EXT( 0xa5a5a5a5a5a5a101, 22, 33, 0x00000000d2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a101, 22, 33, 0x00000000d2d2d2d0)
	DEP( 0xa5a5a5a5a5a5a101, 4294967295, 22, 33, 0xa5a5a5ffffffff01)
	EXT( 0xa5a5a5a5a5a5a100, 22, 34, 0x00000001a5a5a5a1)
	EXTU(0xa5a5a5a5a5a5a100, 22, 34, 0x00000001a5a5a5a1)
	DEP( 0xa5a5a5a5a5a5a100, 8589934591, 22, 34, 0xa5a5a5ffffffff00)
	EXT( 0xa5a5a5a5a5a5a0ff, 22, 35, 0x000000034b4b4b41)
	EXTU(0xa5a5a5a5a5a5a0ff, 22, 35, 0x000000034b4b4b41)
	DEP( 0xa5a5a5a5a5a5a0ff, 17179869183, 22, 35, 0xa5a5a5ffffffffff)
	EXT( 0xa5a5a5a5a5a5a0fe, 22, 36, 0x0000000696969683)
	EXTU(0xa5a5a5a5a5a5a0fe, 22, 36, 0x0000000696969683)
	DEP( 0xa5a5a5a5a5a5a0fe, 34359738367, 22, 36, 0xa5a5a5fffffffffe)
	EXT( 0xa5a5a5a5a5a5a0fd, 22, 37, 0x0000000d2d2d2d07)
	EXTU(0xa5a5a5a5a5a5a0fd, 22, 37, 0x0000000d2d2d2d07)
	DEP( 0xa5a5a5a5a5a5a0fd, 68719476735, 22, 37, 0xa5a5a5fffffffffd)
	EXT( 0xa5a5a5a5a5a5a0fc, 22, 38, 0x0000001a5a5a5a0f)
	EXTU(0xa5a5a5a5a5a5a0fc, 22, 38, 0x0000001a5a5a5a0f)
	DEP( 0xa5a5a5a5a5a5a0fc, 137438953471, 22, 38, 0xa5a5a5fffffffffc)
	EXT( 0xa5a5a5a5a5a5a0fb, 22, 39, 0x00000034b4b4b41f)
	EXTU(0xa5a5a5a5a5a5a0fb, 22, 39, 0x00000034b4b4b41f)
	DEP( 0xa5a5a5a5a5a5a0fb, 274877906943, 22, 39, 0xa5a5a5fffffffffb)
	EXT( 0xa5a5a5a5a5a5a0fa, 22, 40, 0x000000696969683e)
	EXTU(0xa5a5a5a5a5a5a0fa, 22, 40, 0x000000696969683e)
	DEP( 0xa5a5a5a5a5a5a0fa, 549755813887, 22, 40, 0xa5a5a5fffffffffe)
	EXT( 0xa5a5a5a5a5a5a0f9, 22, 41, 0x000000d2d2d2d07c)
	EXTU(0xa5a5a5a5a5a5a0f9, 22, 41, 0x000000d2d2d2d07c)
	DEP( 0xa5a5a5a5a5a5a0f9, 1099511627775, 22, 41, 0xa5a5a5ffffffffff)
	EXT( 0xa5a5a5a5a5a5a0f8, 23, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a0f8, 23, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a0f8, 0, 23, 1, 0xa5a5a4a5a5a5a0f8)
	EXT( 0xa5a5a5a5a5a5a0f7, 23, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a0f7, 23, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a5a0f7, 1, 23, 2, 0xa5a5a4a5a5a5a0f7)
	EXT( 0xa5a5a5a5a5a5a0f6, 23, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a0f6, 23, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a5a0f6, 3, 23, 3, 0xa5a5a4e5a5a5a0f6)
	EXT( 0xa5a5a5a5a5a5a0f5, 23, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a0f5, 23, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a5a0f5, 7, 23, 4, 0xa5a5a4e5a5a5a0f5)
	EXT( 0xa5a5a5a5a5a5a0f4, 23, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a0f4, 23, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a5a0f4, 15, 23, 5, 0xa5a5a4f5a5a5a0f4)
	EXT( 0xa5a5a5a5a5a5a0f3, 23, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a0f3, 23, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a5a0f3, 31, 23, 6, 0xa5a5a4fda5a5a0f3)
	EXT( 0xa5a5a5a5a5a5a0f2, 23, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a0f2, 23, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a5a0f2, 63, 23, 7, 0xa5a5a4fda5a5a0f2)
	EXT( 0xa5a5a5a5a5a5a0f1, 23, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a0f1, 23, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a5a0f1, 127, 23, 8, 0xa5a5a4ffa5a5a0f1)
	EXT( 0xa5a5a5a5a5a5a0f0, 23, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a0f0, 23, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a5a0f0, 255, 23, 9, 0xa5a5a4ffa5a5a0f0)
	EXT( 0xa5a5a5a5a5a5a0ef, 23, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a0ef, 23, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a5a0ef, 511, 23, 10, 0xa5a5a4ffa5a5a0ef)
	EXT( 0xa5a5a5a5a5a5a0ee, 23, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a0ee, 23, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a5a0ee, 1023, 23, 11, 0xa5a5a4ffe5a5a0ee)
	EXT( 0xa5a5a5a5a5a5a0ed, 23, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a0ed, 23, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a5a0ed, 2047, 23, 12, 0xa5a5a4ffe5a5a0ed)
	EXT( 0xa5a5a5a5a5a5a0ec, 23, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a0ec, 23, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a5a0ec, 4095, 23, 13, 0xa5a5a4fff5a5a0ec)
	EXT( 0xa5a5a5a5a5a5a0eb, 23, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a0eb, 23, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a5a0eb, 8191, 23, 14, 0xa5a5a4fffda5a0eb)
	EXT( 0xa5a5a5a5a5a5a0ea, 23, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a0ea, 23, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a5a0ea, 16383, 23, 15, 0xa5a5a4fffda5a0ea)
	EXT( 0xa5a5a5a5a5a5a0e9, 23, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a0e9, 23, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a5a0e9, 32767, 23, 16, 0xa5a5a4ffffa5a0e9)
	EXT( 0xa5a5a5a5a5a5a0e8, 23, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a0e8, 23, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a5a0e8, 65535, 23, 17, 0xa5a5a4ffffa5a0e8)
	EXT( 0xa5a5a5a5a5a5a0e7, 23, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a0e7, 23, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a5a0e7, 131071, 23, 18, 0xa5a5a4ffffa5a0e7)
	EXT( 0xa5a5a5a5a5a5a0e6, 23, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a0e6, 23, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a5a0e6, 262143, 23, 19, 0xa5a5a4ffffe5a0e6)
	EXT( 0xa5a5a5a5a5a5a0e5, 23, 20, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a0e5, 23, 20, 0x00000000000d2d2d)
	DEP( 0xa5a5a5a5a5a5a0e5, 524287, 23, 20, 0xa5a5a4ffffe5a0e5)
	EXT( 0xa5a5a5a5a5a5a0e4, 23, 21, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a0e4, 23, 21, 0x00000000001a5a5a)
	DEP( 0xa5a5a5a5a5a5a0e4, 1048575, 23, 21, 0xa5a5a4fffff5a0e4)
	EXT( 0xa5a5a5a5a5a5a0e3, 23, 22, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a0e3, 23, 22, 0x000000000034b4b4)
	DEP( 0xa5a5a5a5a5a5a0e3, 2097151, 23, 22, 0xa5a5a4fffffda0e3)
	EXT( 0xa5a5a5a5a5a5a0e2, 23, 23, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a0e2, 23, 23, 0x0000000000696969)
	DEP( 0xa5a5a5a5a5a5a0e2, 4194303, 23, 23, 0xa5a5a4fffffda0e2)
	EXT( 0xa5a5a5a5a5a5a0e1, 23, 24, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a0e1, 23, 24, 0x0000000000d2d2d2)
	DEP( 0xa5a5a5a5a5a5a0e1, 8388607, 23, 24, 0xa5a5a4ffffffa0e1)
	EXT( 0xa5a5a5a5a5a5a0e0, 23, 25, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a0e0, 23, 25, 0x0000000001a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0e0, 16777215, 23, 25, 0xa5a5a4ffffffa0e0)
	EXT( 0xa5a5a5a5a5a5a0df, 23, 26, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0df, 23, 26, 0x00000000034b4b4b)
	DEP( 0xa5a5a5a5a5a5a0df, 33554431, 23, 26, 0xa5a5a4ffffffa0df)
	EXT( 0xa5a5a5a5a5a5a0de, 23, 27, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a0de, 23, 27, 0x0000000006969696)
	DEP( 0xa5a5a5a5a5a5a0de, 67108863, 23, 27, 0xa5a5a4ffffffe0de)
	EXT( 0xa5a5a5a5a5a5a0dd, 23, 28, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a0dd, 23, 28, 0x000000000d2d2d2d)
	DEP( 0xa5a5a5a5a5a5a0dd, 134217727, 23, 28, 0xa5a5a4ffffffe0dd)
	EXT( 0xa5a5a5a5a5a5a0dc, 23, 29, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a0dc, 23, 29, 0x000000001a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a0dc, 268435455, 23, 29, 0xa5a5a4fffffff0dc)
	EXT( 0xa5a5a5a5a5a5a0db, 23, 30, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a0db, 23, 30, 0x0000000034b4b4b4)
	DEP( 0xa5a5a5a5a5a5a0db, 536870911, 23, 30, 0xa5a5a4fffffff8db)
	EXT( 0xa5a5a5a5a5a5a0da, 23, 31, 0xffffffffe9696968)
	EXTU(0xa5a5a5a5a5a5a0da, 23, 31, 0x0000000069696968)
	DEP( 0xa5a5a5a5a5a5a0da, 1073741823, 23, 31, 0xa5a5a4fffffffcda)
	EXT( 0xa5a5a5a5a5a5a0d9, 23, 32, 0xffffffffd2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a0d9, 23, 32, 0x00000000d2d2d2d0)
	DEP( 0xa5a5a5a5a5a5a0d9, 2147483647, 23, 32, 0xa5a5a4fffffffed9)
	EXT( 0xa5a5a5a5a5a5a0d8, 23, 33, 0xffffffffa5a5a5a0)
	EXTU(0xa5a5a5a5a5a5a0d8, 23, 33, 0x00000001a5a5a5a0)
	DEP( 0xa5a5a5a5a5a5a0d8, 4294967295, 23, 33, 0xa5a5a4ffffffffd8)
	EXT( 0xa5a5a5a5a5a5a0d7, 23, 34, 0xffffffff4b4b4b41)
	EXTU(0xa5a5a5a5a5a5a0d7, 23, 34, 0x000000034b4b4b41)
	DEP( 0xa5a5a5a5a5a5a0d7, 8589934591, 23, 34, 0xa5a5a4ffffffffd7)
	EXT( 0xa5a5a5a5a5a5a0d6, 23, 35, 0xfffffffe96969683)
	EXTU(0xa5a5a5a5a5a5a0d6, 23, 35, 0x0000000696969683)
	DEP( 0xa5a5a5a5a5a5a0d6, 17179869183, 23, 35, 0xa5a5a4ffffffffd6)
	EXT( 0xa5a5a5a5a5a5a0d5, 23, 36, 0xfffffffd2d2d2d06)
	EXTU(0xa5a5a5a5a5a5a0d5, 23, 36, 0x0000000d2d2d2d06)
	DEP( 0xa5a5a5a5a5a5a0d5, 34359738367, 23, 36, 0xa5a5a4fffffffff5)
	EXT( 0xa5a5a5a5a5a5a0d4, 23, 37, 0xfffffffa5a5a5a0d)
	EXTU(0xa5a5a5a5a5a5a0d4, 23, 37, 0x0000001a5a5a5a0d)
	DEP( 0xa5a5a5a5a5a5a0d4, 68719476735, 23, 37, 0xa5a5a4fffffffff4)
	EXT( 0xa5a5a5a5a5a5a0d3, 23, 38, 0xfffffff4b4b4b41a)
	EXTU(0xa5a5a5a5a5a5a0d3, 23, 38, 0x00000034b4b4b41a)
	DEP( 0xa5a5a5a5a5a5a0d3, 137438953471, 23, 38, 0xa5a5a4fffffffffb)
	EXT( 0xa5a5a5a5a5a5a0d2, 23, 39, 0xffffffe969696834)
	EXTU(0xa5a5a5a5a5a5a0d2, 23, 39, 0x0000006969696834)
	DEP( 0xa5a5a5a5a5a5a0d2, 274877906943, 23, 39, 0xa5a5a4fffffffffe)
	EXT( 0xa5a5a5a5a5a5a0d1, 23, 40, 0xffffffd2d2d2d068)
	EXTU(0xa5a5a5a5a5a5a0d1, 23, 40, 0x000000d2d2d2d068)
	DEP( 0xa5a5a5a5a5a5a0d1, 549755813887, 23, 40, 0xa5a5a4ffffffffff)
	EXT( 0xa5a5a5a5a5a5a0d0, 24, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a0d0, 24, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a0d0, 0, 24, 1, 0xa5a5a525a5a5a0d0)
	EXT( 0xa5a5a5a5a5a5a0cf, 24, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a0cf, 24, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a0cf, 1, 24, 2, 0xa5a5a565a5a5a0cf)
	EXT( 0xa5a5a5a5a5a5a0ce, 24, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a0ce, 24, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a0ce, 3, 24, 3, 0xa5a5a565a5a5a0ce)
	EXT( 0xa5a5a5a5a5a5a0cd, 24, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a5a0cd, 24, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a5a0cd, 7, 24, 4, 0xa5a5a575a5a5a0cd)
	EXT( 0xa5a5a5a5a5a5a0cc, 24, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a5a0cc, 24, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a5a0cc, 15, 24, 5, 0xa5a5a57da5a5a0cc)
	EXT( 0xa5a5a5a5a5a5a0cb, 24, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a5a0cb, 24, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a5a0cb, 31, 24, 6, 0xa5a5a57da5a5a0cb)
	EXT( 0xa5a5a5a5a5a5a0ca, 24, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a5a0ca, 24, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a5a0ca, 63, 24, 7, 0xa5a5a57fa5a5a0ca)
	EXT( 0xa5a5a5a5a5a5a0c9, 24, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a5a0c9, 24, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a5a0c9, 127, 24, 8, 0xa5a5a57fa5a5a0c9)
	EXT( 0xa5a5a5a5a5a5a0c8, 24, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a5a0c8, 24, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a5a0c8, 255, 24, 9, 0xa5a5a57fa5a5a0c8)
	EXT( 0xa5a5a5a5a5a5a0c7, 24, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a5a0c7, 24, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a5a0c7, 511, 24, 10, 0xa5a5a57fe5a5a0c7)
	EXT( 0xa5a5a5a5a5a5a0c6, 24, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a5a0c6, 24, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a5a0c6, 1023, 24, 11, 0xa5a5a57fe5a5a0c6)
	EXT( 0xa5a5a5a5a5a5a0c5, 24, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a5a0c5, 24, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a5a0c5, 2047, 24, 12, 0xa5a5a57ff5a5a0c5)
	EXT( 0xa5a5a5a5a5a5a0c4, 24, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a5a0c4, 24, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a5a0c4, 4095, 24, 13, 0xa5a5a57ffda5a0c4)
	EXT( 0xa5a5a5a5a5a5a0c3, 24, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a5a0c3, 24, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a5a0c3, 8191, 24, 14, 0xa5a5a57ffda5a0c3)
	EXT( 0xa5a5a5a5a5a5a0c2, 24, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a5a0c2, 24, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a5a0c2, 16383, 24, 15, 0xa5a5a57fffa5a0c2)
	EXT( 0xa5a5a5a5a5a5a0c1, 24, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a5a0c1, 24, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a5a0c1, 32767, 24, 16, 0xa5a5a57fffa5a0c1)
	EXT( 0xa5a5a5a5a5a5a0c0, 24, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a5a0c0, 24, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a5a0c0, 65535, 24, 17, 0xa5a5a57fffa5a0c0)
	EXT( 0xa5a5a5a5a5a5a0bf, 24, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a5a0bf, 24, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a5a0bf, 131071, 24, 18, 0xa5a5a57fffe5a0bf)
	EXT( 0xa5a5a5a5a5a5a0be, 24, 19, 0xfffffffffffd2d2d)
	EXTU(0xa5a5a5a5a5a5a0be, 24, 19, 0x0000000000052d2d)
	DEP( 0xa5a5a5a5a5a5a0be, 262143, 24, 19, 0xa5a5a57fffe5a0be)
	EXT( 0xa5a5a5a5a5a5a0bd, 24, 20, 0xfffffffffffa5a5a)
	EXTU(0xa5a5a5a5a5a5a0bd, 24, 20, 0x00000000000a5a5a)
	DEP( 0xa5a5a5a5a5a5a0bd, 524287, 24, 20, 0xa5a5a57ffff5a0bd)
	EXT( 0xa5a5a5a5a5a5a0bc, 24, 21, 0xfffffffffff4b4b4)
	EXTU(0xa5a5a5a5a5a5a0bc, 24, 21, 0x000000000014b4b4)
	DEP( 0xa5a5a5a5a5a5a0bc, 1048575, 24, 21, 0xa5a5a57ffffda0bc)
	EXT( 0xa5a5a5a5a5a5a0bb, 24, 22, 0xffffffffffe96969)
	EXTU(0xa5a5a5a5a5a5a0bb, 24, 22, 0x0000000000296969)
	DEP( 0xa5a5a5a5a5a5a0bb, 2097151, 24, 22, 0xa5a5a57ffffda0bb)
	EXT( 0xa5a5a5a5a5a5a0ba, 24, 23, 0xffffffffffd2d2d2)
	EXTU(0xa5a5a5a5a5a5a0ba, 24, 23, 0x000000000052d2d2)
	DEP( 0xa5a5a5a5a5a5a0ba, 4194303, 24, 23, 0xa5a5a57fffffa0ba)
	EXT( 0xa5a5a5a5a5a5a0b9, 24, 24, 0xffffffffffa5a5a5)
	EXTU(0xa5a5a5a5a5a5a0b9, 24, 24, 0x0000000000a5a5a5)
	DEP( 0xa5a5a5a5a5a5a0b9, 8388607, 24, 24, 0xa5a5a57fffffa0b9)
	EXT( 0xa5a5a5a5a5a5a0b8, 24, 25, 0xffffffffff4b4b4b)
	EXTU(0xa5a5a5a5a5a5a0b8, 24, 25, 0x00000000014b4b4b)
	DEP( 0xa5a5a5a5a5a5a0b8, 16777215, 24, 25, 0xa5a5a57fffffa0b8)
	EXT( 0xa5a5a5a5a5a5a0b7, 24, 26, 0xfffffffffe969696)
	EXTU(0xa5a5a5a5a5a5a0b7, 24, 26, 0x0000000002969696)
	DEP( 0xa5a5a5a5a5a5a0b7, 33554431, 24, 26, 0xa5a5a57fffffe0b7)
	EXT( 0xa5a5a5a5a5a5a0b6, 24, 27, 0xfffffffffd2d2d2d)
	EXTU(0xa5a5a5a5a5a5a0b6, 24, 27, 0x00000000052d2d2d)
	DEP( 0xa5a5a5a5a5a5a0b6, 67108863, 24, 27, 0xa5a5a57fffffe0b6)
	EXT( 0xa5a5a5a5a5a5a0b5, 24, 28, 0xfffffffffa5a5a5a)
	EXTU(0xa5a5a5a5a5a5a0b5, 24, 28, 0x000000000a5a5a5a)
	DEP( 0xa5a5a5a5a5a5a0b5, 134217727, 24, 28, 0xa5a5a57ffffff0b5)
	EXT( 0xa5a5a5a5a5a5a0b4, 24, 29, 0xfffffffff4b4b4b4)
	EXTU(0xa5a5a5a5a5a5a0b4, 24, 29, 0x0000000014b4b4b4)
	DEP( 0xa5a5a5a5a5a5a0b4, 268435455, 24, 29, 0xa5a5a57ffffff8b4)
	EXT( 0xa5a5a5a5a5a5a0b3, 24, 30, 0xffffffffe9696968)
	EXTU(0xa5a5a5a5a5a5a0b3, 24, 30, 0x0000000029696968)
	DEP( 0xa5a5a5a5a5a5a0b3, 536870911, 24, 30, 0xa5a5a57ffffffcb3)
	EXT( 0xa5a5a5a5a5a5a0b2, 24, 31, 0xffffffffd2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a0b2, 24, 31, 0x0000000052d2d2d0)
	DEP( 0xa5a5a5a5a5a5a0b2, 1073741823, 24, 31, 0xa5a5a57ffffffeb2)
	EXT( 0xa5a5a5a5a5a5a0b1, 24, 32, 0xffffffffa5a5a5a0)
	EXTU(0xa5a5a5a5a5a5a0b1, 24, 32, 0x00000000a5a5a5a0)
	DEP( 0xa5a5a5a5a5a5a0b1, 2147483647, 24, 32, 0xa5a5a57fffffffb1)
	EXT( 0xa5a5a5a5a5a5a0b0, 24, 33, 0xffffffff4b4b4b41)
	EXTU(0xa5a5a5a5a5a5a0b0, 24, 33, 0x000000014b4b4b41)
	DEP( 0xa5a5a5a5a5a5a0b0, 4294967295, 24, 33, 0xa5a5a57fffffffb0)
	EXT( 0xa5a5a5a5a5a5a0af, 24, 34, 0xfffffffe96969682)
	EXTU(0xa5a5a5a5a5a5a0af, 24, 34, 0x0000000296969682)
	DEP( 0xa5a5a5a5a5a5a0af, 8589934591, 24, 34, 0xa5a5a57fffffffef)
	EXT( 0xa5a5a5a5a5a5a0ae, 24, 35, 0xfffffffd2d2d2d05)
	EXTU(0xa5a5a5a5a5a5a0ae, 24, 35, 0x000000052d2d2d05)
	DEP( 0xa5a5a5a5a5a5a0ae, 17179869183, 24, 35, 0xa5a5a57fffffffee)
	EXT( 0xa5a5a5a5a5a5a0ad, 24, 36, 0xfffffffa5a5a5a0a)
	EXTU(0xa5a5a5a5a5a5a0ad, 24, 36, 0x0000000a5a5a5a0a)
	DEP( 0xa5a5a5a5a5a5a0ad, 34359738367, 24, 36, 0xa5a5a57ffffffffd)
	EXT( 0xa5a5a5a5a5a5a0ac, 24, 37, 0xfffffff4b4b4b415)
	EXTU(0xa5a5a5a5a5a5a0ac, 24, 37, 0x00000014b4b4b415)
	DEP( 0xa5a5a5a5a5a5a0ac, 68719476735, 24, 37, 0xa5a5a57ffffffffc)
	EXT( 0xa5a5a5a5a5a5a0ab, 24, 38, 0xffffffe96969682a)
	EXTU(0xa5a5a5a5a5a5a0ab, 24, 38, 0x000000296969682a)
	DEP( 0xa5a5a5a5a5a5a0ab, 137438953471, 24, 38, 0xa5a5a57fffffffff)
	EXT( 0xa5a5a5a5a5a5a0aa, 24, 39, 0xffffffd2d2d2d055)
	EXTU(0xa5a5a5a5a5a5a0aa, 24, 39, 0x00000052d2d2d055)
	DEP( 0xa5a5a5a5a5a5a0aa, 274877906943, 24, 39, 0xa5a5a57ffffffffe)
	EXT( 0xa5a5a5a5a5a5a0a9, 25, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a0a9, 25, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a0a9, 0, 25, 1, 0xa5a5a5a5a5a5a0a9)
	EXT( 0xa5a5a5a5a5a5a0a8, 25, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a0a8, 25, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a0a8, 1, 25, 2, 0xa5a5a5a5a5a5a0a8)
	EXT( 0xa5a5a5a5a5a5a0a7, 25, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a0a7, 25, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a0a7, 3, 25, 3, 0xa5a5a5b5a5a5a0a7)
	EXT( 0xa5a5a5a5a5a5a0a6, 25, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a5a0a6, 25, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a0a6, 7, 25, 4, 0xa5a5a5bda5a5a0a6)
	EXT( 0xa5a5a5a5a5a5a0a5, 25, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a5a0a5, 25, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a0a5, 15, 25, 5, 0xa5a5a5bda5a5a0a5)
	EXT( 0xa5a5a5a5a5a5a0a4, 25, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a5a0a4, 25, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a0a4, 31, 25, 6, 0xa5a5a5bfa5a5a0a4)
	EXT( 0xa5a5a5a5a5a5a0a3, 25, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a5a0a3, 25, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a0a3, 63, 25, 7, 0xa5a5a5bfa5a5a0a3)
	EXT( 0xa5a5a5a5a5a5a0a2, 25, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a5a0a2, 25, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a0a2, 127, 25, 8, 0xa5a5a5bfa5a5a0a2)
	EXT( 0xa5a5a5a5a5a5a0a1, 25, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a5a0a1, 25, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a0a1, 255, 25, 9, 0xa5a5a5bfe5a5a0a1)
	EXT( 0xa5a5a5a5a5a5a0a0, 25, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a5a0a0, 25, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a0a0, 511, 25, 10, 0xa5a5a5bfe5a5a0a0)
	EXT( 0xa5a5a5a5a5a5a09f, 25, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a5a09f, 25, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a09f, 1023, 25, 11, 0xa5a5a5bff5a5a09f)
	EXT( 0xa5a5a5a5a5a5a09e, 25, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a5a09e, 25, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a09e, 2047, 25, 12, 0xa5a5a5bffda5a09e)
	EXT( 0xa5a5a5a5a5a5a09d, 25, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a5a09d, 25, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a09d, 4095, 25, 13, 0xa5a5a5bffda5a09d)
	EXT( 0xa5a5a5a5a5a5a09c, 25, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a5a09c, 25, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a09c, 8191, 25, 14, 0xa5a5a5bfffa5a09c)
	EXT( 0xa5a5a5a5a5a5a09b, 25, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a5a09b, 25, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a09b, 16383, 25, 15, 0xa5a5a5bfffa5a09b)
	EXT( 0xa5a5a5a5a5a5a09a, 25, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a5a09a, 25, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a09a, 32767, 25, 16, 0xa5a5a5bfffa5a09a)
	EXT( 0xa5a5a5a5a5a5a099, 25, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a5a099, 25, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a099, 65535, 25, 17, 0xa5a5a5bfffe5a099)
	EXT( 0xa5a5a5a5a5a5a098, 25, 18, 0x0000000000012d2d)
	EXTU(0xa5a5a5a5a5a5a098, 25, 18, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a098, 131071, 25, 18, 0xa5a5a5bfffe5a098)
	EXT( 0xa5a5a5a5a5a5a097, 25, 19, 0x0000000000025a5a)
	EXTU(0xa5a5a5a5a5a5a097, 25, 19, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a097, 262143, 25, 19, 0xa5a5a5bffff5a097)
	EXT( 0xa5a5a5a5a5a5a096, 25, 20, 0x000000000004b4b4)
	EXTU(0xa5a5a5a5a5a5a096, 25, 20, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a096, 524287, 25, 20, 0xa5a5a5bffffda096)
	EXT( 0xa5a5a5a5a5a5a095, 25, 21, 0x0000000000096969)
	EXTU(0xa5a5a5a5a5a5a095, 25, 21, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a095, 1048575, 25, 21, 0xa5a5a5bffffda095)
	EXT( 0xa5a5a5a5a5a5a094, 25, 22, 0x000000000012d2d2)
	EXTU(0xa5a5a5a5a5a5a094, 25, 22, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a094, 2097151, 25, 22, 0xa5a5a5bfffffa094)
	EXT( 0xa5a5a5a5a5a5a093, 25, 23, 0x000000000025a5a5)
	EXTU(0xa5a5a5a5a5a5a093, 25, 23, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a093, 4194303, 25, 23, 0xa5a5a5bfffffa093)
	EXT( 0xa5a5a5a5a5a5a092, 25, 24, 0x00000000004b4b4b)
	EXTU(0xa5a5a5a5a5a5a092, 25, 24, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a092, 8388607, 25, 24, 0xa5a5a5bfffffa092)
	EXT( 0xa5a5a5a5a5a5a091, 25, 25, 0x0000000000969696)
	EXTU(0xa5a5a5a5a5a5a091, 25, 25, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a091, 16777215, 25, 25, 0xa5a5a5bfffffe091)
	EXT( 0xa5a5a5a5a5a5a090, 25, 26, 0x00000000012d2d2d)
	EXTU(0xa5a5a5a5a5a5a090, 25, 26, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a090, 33554431, 25, 26, 0xa5a5a5bfffffe090)
	EXT( 0xa5a5a5a5a5a5a08f, 25, 27, 0x00000000025a5a5a)
	EXTU(0xa5a5a5a5a5a5a08f, 25, 27, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a08f, 67108863, 25, 27, 0xa5a5a5bffffff08f)
	EXT( 0xa5a5a5a5a5a5a08e, 25, 28, 0x0000000004b4b4b4)
	EXTU(0xa5a5a5a5a5a5a08e, 25, 28, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a08e, 134217727, 25, 28, 0xa5a5a5bffffff88e)
	EXT( 0xa5a5a5a5a5a5a08d, 25, 29, 0x0000000009696968)
	EXTU(0xa5a5a5a5a5a5a08d, 25, 29, 0x0000000009696968)
	DEP( 0xa5a5a5a5a5a5a08d, 268435455, 25, 29, 0xa5a5a5bffffffc8d)
	EXT( 0xa5a5a5a5a5a5a08c, 25, 30, 0x0000000012d2d2d0)
	EXTU(0xa5a5a5a5a5a5a08c, 25, 30, 0x0000000012d2d2d0)
	DEP( 0xa5a5a5a5a5a5a08c, 536870911, 25, 30, 0xa5a5a5bffffffe8c)
	EXT( 0xa5a5a5a5a5a5a08b, 25, 31, 0x0000000025a5a5a0)
	EXTU(0xa5a5a5a5a5a5a08b, 25, 31, 0x0000000025a5a5a0)
	DEP( 0xa5a5a5a5a5a5a08b, 1073741823, 25, 31, 0xa5a5a5bfffffff8b)
	EXT( 0xa5a5a5a5a5a5a08a, 25, 32, 0x000000004b4b4b41)
	EXTU(0xa5a5a5a5a5a5a08a, 25, 32, 0x000000004b4b4b41)
	DEP( 0xa5a5a5a5a5a5a08a, 2147483647, 25, 32, 0xa5a5a5bfffffff8a)
	EXT( 0xa5a5a5a5a5a5a089, 25, 33, 0x0000000096969682)
	EXTU(0xa5a5a5a5a5a5a089, 25, 33, 0x0000000096969682)
	DEP( 0xa5a5a5a5a5a5a089, 4294967295, 25, 33, 0xa5a5a5bfffffffc9)
	EXT( 0xa5a5a5a5a5a5a088, 25, 34, 0x000000012d2d2d04)
	EXTU(0xa5a5a5a5a5a5a088, 25, 34, 0x000000012d2d2d04)
	DEP( 0xa5a5a5a5a5a5a088, 8589934591, 25, 34, 0xa5a5a5bfffffffe8)
	EXT( 0xa5a5a5a5a5a5a087, 25, 35, 0x000000025a5a5a08)
	EXTU(0xa5a5a5a5a5a5a087, 25, 35, 0x000000025a5a5a08)
	DEP( 0xa5a5a5a5a5a5a087, 17179869183, 25, 35, 0xa5a5a5bffffffff7)
	EXT( 0xa5a5a5a5a5a5a086, 25, 36, 0x00000004b4b4b410)
	EXTU(0xa5a5a5a5a5a5a086, 25, 36, 0x00000004b4b4b410)
	DEP( 0xa5a5a5a5a5a5a086, 34359738367, 25, 36, 0xa5a5a5bffffffffe)
	EXT( 0xa5a5a5a5a5a5a085, 25, 37, 0x0000000969696821)
	EXTU(0xa5a5a5a5a5a5a085, 25, 37, 0x0000000969696821)
	DEP( 0xa5a5a5a5a5a5a085, 68719476735, 25, 37, 0xa5a5a5bffffffffd)
	EXT( 0xa5a5a5a5a5a5a084, 25, 38, 0x00000012d2d2d042)
	EXTU(0xa5a5a5a5a5a5a084, 25, 38, 0x00000012d2d2d042)
	DEP( 0xa5a5a5a5a5a5a084, 137438953471, 25, 38, 0xa5a5a5bffffffffe)
	EXT( 0xa5a5a5a5a5a5a083, 26, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a083, 26, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a083, 0, 26, 1, 0xa5a5a585a5a5a083)
	EXT( 0xa5a5a5a5a5a5a082, 26, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a082, 26, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a082, 1, 26, 2, 0xa5a5a595a5a5a082)
	EXT( 0xa5a5a5a5a5a5a081, 26, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a5a081, 26, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a5a081, 3, 26, 3, 0xa5a5a59da5a5a081)
	EXT( 0xa5a5a5a5a5a5a080, 26, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a5a080, 26, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a5a080, 7, 26, 4, 0xa5a5a59da5a5a080)
	EXT( 0xa5a5a5a5a5a5a07f, 26, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a5a07f, 26, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a5a07f, 15, 26, 5, 0xa5a5a59fa5a5a07f)
	EXT( 0xa5a5a5a5a5a5a07e, 26, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a5a07e, 26, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a5a07e, 31, 26, 6, 0xa5a5a59fa5a5a07e)
	EXT( 0xa5a5a5a5a5a5a07d, 26, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a5a07d, 26, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a5a07d, 63, 26, 7, 0xa5a5a59fa5a5a07d)
	EXT( 0xa5a5a5a5a5a5a07c, 26, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a5a07c, 26, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a5a07c, 127, 26, 8, 0xa5a5a59fe5a5a07c)
	EXT( 0xa5a5a5a5a5a5a07b, 26, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a5a07b, 26, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a5a07b, 255, 26, 9, 0xa5a5a59fe5a5a07b)
	EXT( 0xa5a5a5a5a5a5a07a, 26, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a5a07a, 26, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a5a07a, 511, 26, 10, 0xa5a5a59ff5a5a07a)
	EXT( 0xa5a5a5a5a5a5a079, 26, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a5a079, 26, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a5a079, 1023, 26, 11, 0xa5a5a59ffda5a079)
	EXT( 0xa5a5a5a5a5a5a078, 26, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a5a078, 26, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a5a078, 2047, 26, 12, 0xa5a5a59ffda5a078)
	EXT( 0xa5a5a5a5a5a5a077, 26, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a5a077, 26, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a5a077, 4095, 26, 13, 0xa5a5a59fffa5a077)
	EXT( 0xa5a5a5a5a5a5a076, 26, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a5a076, 26, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a5a076, 8191, 26, 14, 0xa5a5a59fffa5a076)
	EXT( 0xa5a5a5a5a5a5a075, 26, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a5a075, 26, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a5a075, 16383, 26, 15, 0xa5a5a59fffa5a075)
	EXT( 0xa5a5a5a5a5a5a074, 26, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a5a074, 26, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a5a074, 32767, 26, 16, 0xa5a5a59fffe5a074)
	EXT( 0xa5a5a5a5a5a5a073, 26, 17, 0xffffffffffff2d2d)
	EXTU(0xa5a5a5a5a5a5a073, 26, 17, 0x0000000000012d2d)
	DEP( 0xa5a5a5a5a5a5a073, 65535, 26, 17, 0xa5a5a59fffe5a073)
	EXT( 0xa5a5a5a5a5a5a072, 26, 18, 0xfffffffffffe5a5a)
	EXTU(0xa5a5a5a5a5a5a072, 26, 18, 0x0000000000025a5a)
	DEP( 0xa5a5a5a5a5a5a072, 131071, 26, 18, 0xa5a5a59ffff5a072)
	EXT( 0xa5a5a5a5a5a5a071, 26, 19, 0xfffffffffffcb4b4)
	EXTU(0xa5a5a5a5a5a5a071, 26, 19, 0x000000000004b4b4)
	DEP( 0xa5a5a5a5a5a5a071, 262143, 26, 19, 0xa5a5a59ffffda071)
	EXT( 0xa5a5a5a5a5a5a070, 26, 20, 0xfffffffffff96969)
	EXTU(0xa5a5a5a5a5a5a070, 26, 20, 0x0000000000096969)
	DEP( 0xa5a5a5a5a5a5a070, 524287, 26, 20, 0xa5a5a59ffffda070)
	EXT( 0xa5a5a5a5a5a5a06f, 26, 21, 0xfffffffffff2d2d2)
	EXTU(0xa5a5a5a5a5a5a06f, 26, 21, 0x000000000012d2d2)
	DEP( 0xa5a5a5a5a5a5a06f, 1048575, 26, 21, 0xa5a5a59fffffa06f)
	EXT( 0xa5a5a5a5a5a5a06e, 26, 22, 0xffffffffffe5a5a5)
	EXTU(0xa5a5a5a5a5a5a06e, 26, 22, 0x000000000025a5a5)
	DEP( 0xa5a5a5a5a5a5a06e, 2097151, 26, 22, 0xa5a5a59fffffa06e)
	EXT( 0xa5a5a5a5a5a5a06d, 26, 23, 0xffffffffffcb4b4b)
	EXTU(0xa5a5a5a5a5a5a06d, 26, 23, 0x00000000004b4b4b)
	DEP( 0xa5a5a5a5a5a5a06d, 4194303, 26, 23, 0xa5a5a59fffffa06d)
	EXT( 0xa5a5a5a5a5a5a06c, 26, 24, 0xffffffffff969696)
	EXTU(0xa5a5a5a5a5a5a06c, 26, 24, 0x0000000000969696)
	DEP( 0xa5a5a5a5a5a5a06c, 8388607, 26, 24, 0xa5a5a59fffffe06c)
	EXT( 0xa5a5a5a5a5a5a06b, 26, 25, 0xffffffffff2d2d2d)
	EXTU(0xa5a5a5a5a5a5a06b, 26, 25, 0x00000000012d2d2d)
	DEP( 0xa5a5a5a5a5a5a06b, 16777215, 26, 25, 0xa5a5a59fffffe06b)
	EXT( 0xa5a5a5a5a5a5a06a, 26, 26, 0xfffffffffe5a5a5a)
	EXTU(0xa5a5a5a5a5a5a06a, 26, 26, 0x00000000025a5a5a)
	DEP( 0xa5a5a5a5a5a5a06a, 33554431, 26, 26, 0xa5a5a59ffffff06a)
	EXT( 0xa5a5a5a5a5a5a069, 26, 27, 0xfffffffffcb4b4b4)
	EXTU(0xa5a5a5a5a5a5a069, 26, 27, 0x0000000004b4b4b4)
	DEP( 0xa5a5a5a5a5a5a069, 67108863, 26, 27, 0xa5a5a59ffffff869)
	EXT( 0xa5a5a5a5a5a5a068, 26, 28, 0xfffffffff9696968)
	EXTU(0xa5a5a5a5a5a5a068, 26, 28, 0x0000000009696968)
	DEP( 0xa5a5a5a5a5a5a068, 134217727, 26, 28, 0xa5a5a59ffffffc68)
	EXT( 0xa5a5a5a5a5a5a067, 26, 29, 0xfffffffff2d2d2d0)
	EXTU(0xa5a5a5a5a5a5a067, 26, 29, 0x0000000012d2d2d0)
	DEP( 0xa5a5a5a5a5a5a067, 268435455, 26, 29, 0xa5a5a59ffffffe67)
	EXT( 0xa5a5a5a5a5a5a066, 26, 30, 0xffffffffe5a5a5a0)
	EXTU(0xa5a5a5a5a5a5a066, 26, 30, 0x0000000025a5a5a0)
	DEP( 0xa5a5a5a5a5a5a066, 536870911, 26, 30, 0xa5a5a59fffffff66)
	EXT( 0xa5a5a5a5a5a5a065, 26, 31, 0xffffffffcb4b4b40)
	EXTU(0xa5a5a5a5a5a5a065, 26, 31, 0x000000004b4b4b40)
	DEP( 0xa5a5a5a5a5a5a065, 1073741823, 26, 31, 0xa5a5a59fffffffe5)
	EXT( 0xa5a5a5a5a5a5a064, 26, 32, 0xffffffff96969681)
	EXTU(0xa5a5a5a5a5a5a064, 26, 32, 0x0000000096969681)
	DEP( 0xa5a5a5a5a5a5a064, 2147483647, 26, 32, 0xa5a5a59fffffffe4)
	EXT( 0xa5a5a5a5a5a5a063, 26, 33, 0xffffffff2d2d2d03)
	EXTU(0xa5a5a5a5a5a5a063, 26, 33, 0x000000012d2d2d03)
	DEP( 0xa5a5a5a5a5a5a063, 4294967295, 26, 33, 0xa5a5a59fffffffe3)
	EXT( 0xa5a5a5a5a5a5a062, 26, 34, 0xfffffffe5a5a5a06)
	EXTU(0xa5a5a5a5a5a5a062, 26, 34, 0x000000025a5a5a06)
	DEP( 0xa5a5a5a5a5a5a062, 8589934591, 26, 34, 0xa5a5a59ffffffff2)
	EXT( 0xa5a5a5a5a5a5a061, 26, 35, 0xfffffffcb4b4b40c)
	EXTU(0xa5a5a5a5a5a5a061, 26, 35, 0x00000004b4b4b40c)
	DEP( 0xa5a5a5a5a5a5a061, 17179869183, 26, 35, 0xa5a5a59ffffffff9)
	EXT( 0xa5a5a5a5a5a5a060, 26, 36, 0xfffffff969696818)
	EXTU(0xa5a5a5a5a5a5a060, 26, 36, 0x0000000969696818)
	DEP( 0xa5a5a5a5a5a5a060, 34359738367, 26, 36, 0xa5a5a59ffffffffc)
	EXT( 0xa5a5a5a5a5a5a05f, 26, 37, 0xfffffff2d2d2d02f)
	EXTU(0xa5a5a5a5a5a5a05f, 26, 37, 0x00000012d2d2d02f)
	DEP( 0xa5a5a5a5a5a5a05f, 68719476735, 26, 37, 0xa5a5a59fffffffff)
	EXT( 0xa5a5a5a5a5a5a05e, 27, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a05e, 27, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a05e, 0, 27, 1, 0xa5a5a5a5a5a5a05e)
	EXT( 0xa5a5a5a5a5a5a05d, 27, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a05d, 27, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a05d, 1, 27, 2, 0xa5a5a5ada5a5a05d)
	EXT( 0xa5a5a5a5a5a5a05c, 27, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a05c, 27, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a05c, 3, 27, 3, 0xa5a5a5ada5a5a05c)
	EXT( 0xa5a5a5a5a5a5a05b, 27, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a05b, 27, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a05b, 7, 27, 4, 0xa5a5a5afa5a5a05b)
	EXT( 0xa5a5a5a5a5a5a05a, 27, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a05a, 27, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a05a, 15, 27, 5, 0xa5a5a5afa5a5a05a)
	EXT( 0xa5a5a5a5a5a5a059, 27, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a059, 27, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a059, 31, 27, 6, 0xa5a5a5afa5a5a059)
	EXT( 0xa5a5a5a5a5a5a058, 27, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a058, 27, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a058, 63, 27, 7, 0xa5a5a5afe5a5a058)
	EXT( 0xa5a5a5a5a5a5a057, 27, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a057, 27, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a057, 127, 27, 8, 0xa5a5a5afe5a5a057)
	EXT( 0xa5a5a5a5a5a5a056, 27, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a056, 27, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a056, 255, 27, 9, 0xa5a5a5aff5a5a056)
	EXT( 0xa5a5a5a5a5a5a055, 27, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a055, 27, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a055, 511, 27, 10, 0xa5a5a5affda5a055)
	EXT( 0xa5a5a5a5a5a5a054, 27, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a054, 27, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a054, 1023, 27, 11, 0xa5a5a5affda5a054)
	EXT( 0xa5a5a5a5a5a5a053, 27, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a053, 27, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a053, 2047, 27, 12, 0xa5a5a5afffa5a053)
	EXT( 0xa5a5a5a5a5a5a052, 27, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a052, 27, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a052, 4095, 27, 13, 0xa5a5a5afffa5a052)
	EXT( 0xa5a5a5a5a5a5a051, 27, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a051, 27, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a051, 8191, 27, 14, 0xa5a5a5afffa5a051)
	EXT( 0xa5a5a5a5a5a5a050, 27, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a050, 27, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a050, 16383, 27, 15, 0xa5a5a5afffe5a050)
	EXT( 0xa5a5a5a5a5a5a04f, 27, 16, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a04f, 27, 16, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a04f, 32767, 27, 16, 0xa5a5a5afffe5a04f)
	EXT( 0xa5a5a5a5a5a5a04e, 27, 17, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a04e, 27, 17, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a04e, 65535, 27, 17, 0xa5a5a5affff5a04e)
	EXT( 0xa5a5a5a5a5a5a04d, 27, 18, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a04d, 27, 18, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a04d, 131071, 27, 18, 0xa5a5a5affffda04d)
	EXT( 0xa5a5a5a5a5a5a04c, 27, 19, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a04c, 27, 19, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a04c, 262143, 27, 19, 0xa5a5a5affffda04c)
	EXT( 0xa5a5a5a5a5a5a04b, 27, 20, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a04b, 27, 20, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a04b, 524287, 27, 20, 0xa5a5a5afffffa04b)
	EXT( 0xa5a5a5a5a5a5a04a, 27, 21, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a04a, 27, 21, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a04a, 1048575, 27, 21, 0xa5a5a5afffffa04a)
	EXT( 0xa5a5a5a5a5a5a049, 27, 22, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a049, 27, 22, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a049, 2097151, 27, 22, 0xa5a5a5afffffa049)
	EXT( 0xa5a5a5a5a5a5a048, 27, 23, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a048, 27, 23, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a048, 4194303, 27, 23, 0xa5a5a5afffffe048)
	EXT( 0xa5a5a5a5a5a5a047, 27, 24, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a047, 27, 24, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a047, 8388607, 27, 24, 0xa5a5a5afffffe047)
	EXT( 0xa5a5a5a5a5a5a046, 27, 25, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a046, 27, 25, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a046, 16777215, 27, 25, 0xa5a5a5affffff046)
	EXT( 0xa5a5a5a5a5a5a045, 27, 26, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a045, 27, 26, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a045, 33554431, 27, 26, 0xa5a5a5affffff845)
	EXT( 0xa5a5a5a5a5a5a044, 27, 27, 0x0000000001696968)
	EXTU(0xa5a5a5a5a5a5a044, 27, 27, 0x0000000001696968)
	DEP( 0xa5a5a5a5a5a5a044, 67108863, 27, 27, 0xa5a5a5affffffc44)
	EXT( 0xa5a5a5a5a5a5a043, 27, 28, 0x0000000002d2d2d0)
	EXTU(0xa5a5a5a5a5a5a043, 27, 28, 0x0000000002d2d2d0)
	DEP( 0xa5a5a5a5a5a5a043, 134217727, 27, 28, 0xa5a5a5affffffe43)
	EXT( 0xa5a5a5a5a5a5a042, 27, 29, 0x0000000005a5a5a0)
	EXTU(0xa5a5a5a5a5a5a042, 27, 29, 0x0000000005a5a5a0)
	DEP( 0xa5a5a5a5a5a5a042, 268435455, 27, 29, 0xa5a5a5afffffff42)
	EXT( 0xa5a5a5a5a5a5a041, 27, 30, 0x000000000b4b4b40)
	EXTU(0xa5a5a5a5a5a5a041, 27, 30, 0x000000000b4b4b40)
	DEP( 0xa5a5a5a5a5a5a041, 536870911, 27, 30, 0xa5a5a5afffffffc1)
	EXT( 0xa5a5a5a5a5a5a040, 27, 31, 0x0000000016969681)
	EXTU(0xa5a5a5a5a5a5a040, 27, 31, 0x0000000016969681)
	DEP( 0xa5a5a5a5a5a5a040, 1073741823, 27, 31, 0xa5a5a5afffffffc0)
	EXT( 0xa5a5a5a5a5a5a03f, 27, 32, 0x000000002d2d2d01)
	EXTU(0xa5a5a5a5a5a5a03f, 27, 32, 0x000000002d2d2d01)
	DEP( 0xa5a5a5a5a5a5a03f, 2147483647, 27, 32, 0xa5a5a5afffffffff)
	EXT( 0xa5a5a5a5a5a5a03e, 27, 33, 0x000000005a5a5a03)
	EXTU(0xa5a5a5a5a5a5a03e, 27, 33, 0x000000005a5a5a03)
	DEP( 0xa5a5a5a5a5a5a03e, 4294967295, 27, 33, 0xa5a5a5affffffffe)
	EXT( 0xa5a5a5a5a5a5a03d, 27, 34, 0x00000000b4b4b407)
	EXTU(0xa5a5a5a5a5a5a03d, 27, 34, 0x00000000b4b4b407)
	DEP( 0xa5a5a5a5a5a5a03d, 8589934591, 27, 34, 0xa5a5a5affffffffd)
	EXT( 0xa5a5a5a5a5a5a03c, 27, 35, 0x000000016969680f)
	EXTU(0xa5a5a5a5a5a5a03c, 27, 35, 0x000000016969680f)
	DEP( 0xa5a5a5a5a5a5a03c, 17179869183, 27, 35, 0xa5a5a5affffffffc)
	EXT( 0xa5a5a5a5a5a5a03b, 27, 36, 0x00000002d2d2d01d)
	EXTU(0xa5a5a5a5a5a5a03b, 27, 36, 0x00000002d2d2d01d)
	DEP( 0xa5a5a5a5a5a5a03b, 34359738367, 27, 36, 0xa5a5a5afffffffff)
	EXT( 0xa5a5a5a5a5a5a03a, 28, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a5a03a, 28, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a5a03a, 0, 28, 1, 0xa5a5a5a5a5a5a03a)
	EXT( 0xa5a5a5a5a5a5a039, 28, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a5a039, 28, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a039, 1, 28, 2, 0xa5a5a5a5a5a5a039)
	EXT( 0xa5a5a5a5a5a5a038, 28, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a5a038, 28, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a038, 3, 28, 3, 0xa5a5a5a7a5a5a038)
	EXT( 0xa5a5a5a5a5a5a037, 28, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a5a037, 28, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a037, 7, 28, 4, 0xa5a5a5a7a5a5a037)
	EXT( 0xa5a5a5a5a5a5a036, 28, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a5a036, 28, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a036, 15, 28, 5, 0xa5a5a5a7a5a5a036)
	EXT( 0xa5a5a5a5a5a5a035, 28, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a5a035, 28, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a035, 31, 28, 6, 0xa5a5a5a7e5a5a035)
	EXT( 0xa5a5a5a5a5a5a034, 28, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a5a034, 28, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a034, 63, 28, 7, 0xa5a5a5a7e5a5a034)
	EXT( 0xa5a5a5a5a5a5a033, 28, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a5a033, 28, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a033, 127, 28, 8, 0xa5a5a5a7f5a5a033)
	EXT( 0xa5a5a5a5a5a5a032, 28, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a5a032, 28, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a032, 255, 28, 9, 0xa5a5a5a7fda5a032)
	EXT( 0xa5a5a5a5a5a5a031, 28, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a5a031, 28, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a031, 511, 28, 10, 0xa5a5a5a7fda5a031)
	EXT( 0xa5a5a5a5a5a5a030, 28, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a5a030, 28, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a030, 1023, 28, 11, 0xa5a5a5a7ffa5a030)
	EXT( 0xa5a5a5a5a5a5a02f, 28, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a5a02f, 28, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a02f, 2047, 28, 12, 0xa5a5a5a7ffa5a02f)
	EXT( 0xa5a5a5a5a5a5a02e, 28, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a5a02e, 28, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a02e, 4095, 28, 13, 0xa5a5a5a7ffa5a02e)
	EXT( 0xa5a5a5a5a5a5a02d, 28, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a5a02d, 28, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a02d, 8191, 28, 14, 0xa5a5a5a7ffe5a02d)
	EXT( 0xa5a5a5a5a5a5a02c, 28, 15, 0x0000000000002d2d)
	EXTU(0xa5a5a5a5a5a5a02c, 28, 15, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a02c, 16383, 28, 15, 0xa5a5a5a7ffe5a02c)
	EXT( 0xa5a5a5a5a5a5a02b, 28, 16, 0x0000000000005a5a)
	EXTU(0xa5a5a5a5a5a5a02b, 28, 16, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a02b, 32767, 28, 16, 0xa5a5a5a7fff5a02b)
	EXT( 0xa5a5a5a5a5a5a02a, 28, 17, 0x000000000000b4b4)
	EXTU(0xa5a5a5a5a5a5a02a, 28, 17, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a02a, 65535, 28, 17, 0xa5a5a5a7fffda02a)
	EXT( 0xa5a5a5a5a5a5a029, 28, 18, 0x0000000000016969)
	EXTU(0xa5a5a5a5a5a5a029, 28, 18, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a029, 131071, 28, 18, 0xa5a5a5a7fffda029)
	EXT( 0xa5a5a5a5a5a5a028, 28, 19, 0x000000000002d2d2)
	EXTU(0xa5a5a5a5a5a5a028, 28, 19, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a028, 262143, 28, 19, 0xa5a5a5a7ffffa028)
	EXT( 0xa5a5a5a5a5a5a027, 28, 20, 0x000000000005a5a5)
	EXTU(0xa5a5a5a5a5a5a027, 28, 20, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a027, 524287, 28, 20, 0xa5a5a5a7ffffa027)
	EXT( 0xa5a5a5a5a5a5a026, 28, 21, 0x00000000000b4b4b)
	EXTU(0xa5a5a5a5a5a5a026, 28, 21, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a026, 1048575, 28, 21, 0xa5a5a5a7ffffa026)
	EXT( 0xa5a5a5a5a5a5a025, 28, 22, 0x0000000000169696)
	EXTU(0xa5a5a5a5a5a5a025, 28, 22, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a025, 2097151, 28, 22, 0xa5a5a5a7ffffe025)
	EXT( 0xa5a5a5a5a5a5a024, 28, 23, 0x00000000002d2d2d)
	EXTU(0xa5a5a5a5a5a5a024, 28, 23, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a024, 4194303, 28, 23, 0xa5a5a5a7ffffe024)
	EXT( 0xa5a5a5a5a5a5a023, 28, 24, 0x00000000005a5a5a)
	EXTU(0xa5a5a5a5a5a5a023, 28, 24, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a023, 8388607, 28, 24, 0xa5a5a5a7fffff023)
	EXT( 0xa5a5a5a5a5a5a022, 28, 25, 0x0000000000b4b4b4)
	EXTU(0xa5a5a5a5a5a5a022, 28, 25, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a022, 16777215, 28, 25, 0xa5a5a5a7fffff822)
	EXT( 0xa5a5a5a5a5a5a021, 28, 26, 0x0000000001696968)
	EXTU(0xa5a5a5a5a5a5a021, 28, 26, 0x0000000001696968)
	DEP( 0xa5a5a5a5a5a5a021, 33554431, 28, 26, 0xa5a5a5a7fffffc21)
	EXT( 0xa5a5a5a5a5a5a020, 28, 27, 0x0000000002d2d2d0)
	EXTU(0xa5a5a5a5a5a5a020, 28, 27, 0x0000000002d2d2d0)
	DEP( 0xa5a5a5a5a5a5a020, 67108863, 28, 27, 0xa5a5a5a7fffffe20)
	EXT( 0xa5a5a5a5a5a5a01f, 28, 28, 0x0000000005a5a5a0)
	EXTU(0xa5a5a5a5a5a5a01f, 28, 28, 0x0000000005a5a5a0)
	DEP( 0xa5a5a5a5a5a5a01f, 134217727, 28, 28, 0xa5a5a5a7ffffff1f)
	EXT( 0xa5a5a5a5a5a5a01e, 28, 29, 0x000000000b4b4b40)
	EXTU(0xa5a5a5a5a5a5a01e, 28, 29, 0x000000000b4b4b40)
	DEP( 0xa5a5a5a5a5a5a01e, 268435455, 28, 29, 0xa5a5a5a7ffffff9e)
	EXT( 0xa5a5a5a5a5a5a01d, 28, 30, 0x0000000016969680)
	EXTU(0xa5a5a5a5a5a5a01d, 28, 30, 0x0000000016969680)
	DEP( 0xa5a5a5a5a5a5a01d, 536870911, 28, 30, 0xa5a5a5a7ffffffdd)
	EXT( 0xa5a5a5a5a5a5a01c, 28, 31, 0x000000002d2d2d00)
	EXTU(0xa5a5a5a5a5a5a01c, 28, 31, 0x000000002d2d2d00)
	DEP( 0xa5a5a5a5a5a5a01c, 1073741823, 28, 31, 0xa5a5a5a7fffffffc)
	EXT( 0xa5a5a5a5a5a5a01b, 28, 32, 0x000000005a5a5a01)
	EXTU(0xa5a5a5a5a5a5a01b, 28, 32, 0x000000005a5a5a01)
	DEP( 0xa5a5a5a5a5a5a01b, 2147483647, 28, 32, 0xa5a5a5a7fffffffb)
	EXT( 0xa5a5a5a5a5a5a01a, 28, 33, 0x00000000b4b4b403)
	EXTU(0xa5a5a5a5a5a5a01a, 28, 33, 0x00000000b4b4b403)
	DEP( 0xa5a5a5a5a5a5a01a, 4294967295, 28, 33, 0xa5a5a5a7fffffffa)
	EXT( 0xa5a5a5a5a5a5a019, 28, 34, 0x0000000169696806)
	EXTU(0xa5a5a5a5a5a5a019, 28, 34, 0x0000000169696806)
	DEP( 0xa5a5a5a5a5a5a019, 8589934591, 28, 34, 0xa5a5a5a7fffffffd)
	EXT( 0xa5a5a5a5a5a5a018, 28, 35, 0x00000002d2d2d00c)
	EXTU(0xa5a5a5a5a5a5a018, 28, 35, 0x00000002d2d2d00c)
	DEP( 0xa5a5a5a5a5a5a018, 17179869183, 28, 35, 0xa5a5a5a7fffffffe)
	EXT( 0xa5a5a5a5a5a5a017, 29, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a5a017, 29, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a5a017, 0, 29, 1, 0xa5a5a5a1a5a5a017)
	EXT( 0xa5a5a5a5a5a5a016, 29, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a5a016, 29, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a5a016, 1, 29, 2, 0xa5a5a5a3a5a5a016)
	EXT( 0xa5a5a5a5a5a5a015, 29, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a5a015, 29, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a5a015, 3, 29, 3, 0xa5a5a5a3a5a5a015)
	EXT( 0xa5a5a5a5a5a5a014, 29, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a5a014, 29, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a5a014, 7, 29, 4, 0xa5a5a5a3a5a5a014)
	EXT( 0xa5a5a5a5a5a5a013, 29, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a5a013, 29, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a5a013, 15, 29, 5, 0xa5a5a5a3e5a5a013)
	EXT( 0xa5a5a5a5a5a5a012, 29, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a5a012, 29, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a5a012, 31, 29, 6, 0xa5a5a5a3e5a5a012)
	EXT( 0xa5a5a5a5a5a5a011, 29, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a5a011, 29, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a5a011, 63, 29, 7, 0xa5a5a5a3f5a5a011)
	EXT( 0xa5a5a5a5a5a5a010, 29, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a5a010, 29, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a5a010, 127, 29, 8, 0xa5a5a5a3fda5a010)
	EXT( 0xa5a5a5a5a5a5a00f, 29, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a5a00f, 29, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a5a00f, 255, 29, 9, 0xa5a5a5a3fda5a00f)
	EXT( 0xa5a5a5a5a5a5a00e, 29, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a5a00e, 29, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a5a00e, 511, 29, 10, 0xa5a5a5a3ffa5a00e)
	EXT( 0xa5a5a5a5a5a5a00d, 29, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a5a00d, 29, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a5a00d, 1023, 29, 11, 0xa5a5a5a3ffa5a00d)
	EXT( 0xa5a5a5a5a5a5a00c, 29, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a5a00c, 29, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a5a00c, 2047, 29, 12, 0xa5a5a5a3ffa5a00c)
	EXT( 0xa5a5a5a5a5a5a00b, 29, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a5a00b, 29, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a5a00b, 4095, 29, 13, 0xa5a5a5a3ffe5a00b)
	EXT( 0xa5a5a5a5a5a5a00a, 29, 14, 0xffffffffffffed2d)
	EXTU(0xa5a5a5a5a5a5a00a, 29, 14, 0x0000000000002d2d)
	DEP( 0xa5a5a5a5a5a5a00a, 8191, 29, 14, 0xa5a5a5a3ffe5a00a)
	EXT( 0xa5a5a5a5a5a5a009, 29, 15, 0xffffffffffffda5a)
	EXTU(0xa5a5a5a5a5a5a009, 29, 15, 0x0000000000005a5a)
	DEP( 0xa5a5a5a5a5a5a009, 16383, 29, 15, 0xa5a5a5a3fff5a009)
	EXT( 0xa5a5a5a5a5a5a008, 29, 16, 0xffffffffffffb4b4)
	EXTU(0xa5a5a5a5a5a5a008, 29, 16, 0x000000000000b4b4)
	DEP( 0xa5a5a5a5a5a5a008, 32767, 29, 16, 0xa5a5a5a3fffda008)
	EXT( 0xa5a5a5a5a5a5a007, 29, 17, 0xffffffffffff6969)
	EXTU(0xa5a5a5a5a5a5a007, 29, 17, 0x0000000000016969)
	DEP( 0xa5a5a5a5a5a5a007, 65535, 29, 17, 0xa5a5a5a3fffda007)
	EXT( 0xa5a5a5a5a5a5a006, 29, 18, 0xfffffffffffed2d2)
	EXTU(0xa5a5a5a5a5a5a006, 29, 18, 0x000000000002d2d2)
	DEP( 0xa5a5a5a5a5a5a006, 131071, 29, 18, 0xa5a5a5a3ffffa006)
	EXT( 0xa5a5a5a5a5a5a005, 29, 19, 0xfffffffffffda5a5)
	EXTU(0xa5a5a5a5a5a5a005, 29, 19, 0x000000000005a5a5)
	DEP( 0xa5a5a5a5a5a5a005, 262143, 29, 19, 0xa5a5a5a3ffffa005)
	EXT( 0xa5a5a5a5a5a5a004, 29, 20, 0xfffffffffffb4b4b)
	EXTU(0xa5a5a5a5a5a5a004, 29, 20, 0x00000000000b4b4b)
	DEP( 0xa5a5a5a5a5a5a004, 524287, 29, 20, 0xa5a5a5a3ffffa004)
	EXT( 0xa5a5a5a5a5a5a003, 29, 21, 0xfffffffffff69696)
	EXTU(0xa5a5a5a5a5a5a003, 29, 21, 0x0000000000169696)
	DEP( 0xa5a5a5a5a5a5a003, 1048575, 29, 21, 0xa5a5a5a3ffffe003)
	EXT( 0xa5a5a5a5a5a5a002, 29, 22, 0xffffffffffed2d2d)
	EXTU(0xa5a5a5a5a5a5a002, 29, 22, 0x00000000002d2d2d)
	DEP( 0xa5a5a5a5a5a5a002, 2097151, 29, 22, 0xa5a5a5a3ffffe002)
	EXT( 0xa5a5a5a5a5a5a001, 29, 23, 0xffffffffffda5a5a)
	EXTU(0xa5a5a5a5a5a5a001, 29, 23, 0x00000000005a5a5a)
	DEP( 0xa5a5a5a5a5a5a001, 4194303, 29, 23, 0xa5a5a5a3fffff001)
	EXT( 0xa5a5a5a5a5a5a000, 29, 24, 0xffffffffffb4b4b4)
	EXTU(0xa5a5a5a5a5a5a000, 29, 24, 0x0000000000b4b4b4)
	DEP( 0xa5a5a5a5a5a5a000, 8388607, 29, 24, 0xa5a5a5a3fffff800)
	EXT( 0xa5a5a5a5a5a59fff, 29, 25, 0xffffffffff696967)
	EXTU(0xa5a5a5a5a5a59fff, 29, 25, 0x0000000001696967)
	DEP( 0xa5a5a5a5a5a59fff, 16777215, 29, 25, 0xa5a5a5a3ffffffff)
	EXT( 0xa5a5a5a5a5a59ffe, 29, 26, 0xfffffffffed2d2cf)
	EXTU(0xa5a5a5a5a5a59ffe, 29, 26, 0x0000000002d2d2cf)
	DEP( 0xa5a5a5a5a5a59ffe, 33554431, 29, 26, 0xa5a5a5a3fffffffe)
	EXT( 0xa5a5a5a5a5a59ffd, 29, 27, 0xfffffffffda5a59f)
	EXTU(0xa5a5a5a5a5a59ffd, 29, 27, 0x0000000005a5a59f)
	DEP( 0xa5a5a5a5a5a59ffd, 67108863, 29, 27, 0xa5a5a5a3fffffffd)
	EXT( 0xa5a5a5a5a5a59ffc, 29, 28, 0xfffffffffb4b4b3f)
	EXTU(0xa5a5a5a5a5a59ffc, 29, 28, 0x000000000b4b4b3f)
	DEP( 0xa5a5a5a5a5a59ffc, 134217727, 29, 28, 0xa5a5a5a3fffffffc)
	EXT( 0xa5a5a5a5a5a59ffb, 29, 29, 0xfffffffff696967f)
	EXTU(0xa5a5a5a5a5a59ffb, 29, 29, 0x000000001696967f)
	DEP( 0xa5a5a5a5a5a59ffb, 268435455, 29, 29, 0xa5a5a5a3fffffffb)
	EXT( 0xa5a5a5a5a5a59ffa, 29, 30, 0xffffffffed2d2cff)
	EXTU(0xa5a5a5a5a5a59ffa, 29, 30, 0x000000002d2d2cff)
	DEP( 0xa5a5a5a5a5a59ffa, 536870911, 29, 30, 0xa5a5a5a3fffffffa)
	EXT( 0xa5a5a5a5a5a59ff9, 29, 31, 0xffffffffda5a59ff)
	EXTU(0xa5a5a5a5a5a59ff9, 29, 31, 0x000000005a5a59ff)
	DEP( 0xa5a5a5a5a5a59ff9, 1073741823, 29, 31, 0xa5a5a5a3fffffff9)
	EXT( 0xa5a5a5a5a5a59ff8, 29, 32, 0xffffffffb4b4b3ff)
	EXTU(0xa5a5a5a5a5a59ff8, 29, 32, 0x00000000b4b4b3ff)
	DEP( 0xa5a5a5a5a5a59ff8, 2147483647, 29, 32, 0xa5a5a5a3fffffff8)
	EXT( 0xa5a5a5a5a5a59ff7, 29, 33, 0xffffffff696967fd)
	EXTU(0xa5a5a5a5a5a59ff7, 29, 33, 0x00000001696967fd)
	DEP( 0xa5a5a5a5a5a59ff7, 4294967295, 29, 33, 0xa5a5a5a3ffffffff)
	EXT( 0xa5a5a5a5a5a59ff6, 29, 34, 0xfffffffed2d2cffb)
	EXTU(0xa5a5a5a5a5a59ff6, 29, 34, 0x00000002d2d2cffb)
	DEP( 0xa5a5a5a5a5a59ff6, 8589934591, 29, 34, 0xa5a5a5a3fffffffe)
	EXT( 0xa5a5a5a5a5a59ff5, 30, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59ff5, 30, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59ff5, 0, 30, 1, 0xa5a5a5a5a5a59ff5)
	EXT( 0xa5a5a5a5a5a59ff4, 30, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59ff4, 30, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ff4, 1, 30, 2, 0xa5a5a5a5a5a59ff4)
	EXT( 0xa5a5a5a5a5a59ff3, 30, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59ff3, 30, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59ff3, 3, 30, 3, 0xa5a5a5a5a5a59ff3)
	EXT( 0xa5a5a5a5a5a59ff2, 30, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a59ff2, 30, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59ff2, 7, 30, 4, 0xa5a5a5a5e5a59ff2)
	EXT( 0xa5a5a5a5a5a59ff1, 30, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a59ff1, 30, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59ff1, 15, 30, 5, 0xa5a5a5a5e5a59ff1)
	EXT( 0xa5a5a5a5a5a59ff0, 30, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a59ff0, 30, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59ff0, 31, 30, 6, 0xa5a5a5a5f5a59ff0)
	EXT( 0xa5a5a5a5a5a59fef, 30, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a59fef, 30, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59fef, 63, 30, 7, 0xa5a5a5a5fda59fef)
	EXT( 0xa5a5a5a5a5a59fee, 30, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a59fee, 30, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59fee, 127, 30, 8, 0xa5a5a5a5fda59fee)
	EXT( 0xa5a5a5a5a5a59fed, 30, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a59fed, 30, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59fed, 255, 30, 9, 0xa5a5a5a5ffa59fed)
	EXT( 0xa5a5a5a5a5a59fec, 30, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a59fec, 30, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59fec, 511, 30, 10, 0xa5a5a5a5ffa59fec)
	EXT( 0xa5a5a5a5a5a59feb, 30, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a59feb, 30, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59feb, 1023, 30, 11, 0xa5a5a5a5ffa59feb)
	EXT( 0xa5a5a5a5a5a59fea, 30, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a59fea, 30, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59fea, 2047, 30, 12, 0xa5a5a5a5ffe59fea)
	EXT( 0xa5a5a5a5a5a59fe9, 30, 13, 0x0000000000000d2d)
	EXTU(0xa5a5a5a5a5a59fe9, 30, 13, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a59fe9, 4095, 30, 13, 0xa5a5a5a5ffe59fe9)
	EXT( 0xa5a5a5a5a5a59fe8, 30, 14, 0x0000000000001a5a)
	EXTU(0xa5a5a5a5a5a59fe8, 30, 14, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a59fe8, 8191, 30, 14, 0xa5a5a5a5fff59fe8)
	EXT( 0xa5a5a5a5a5a59fe7, 30, 15, 0x00000000000034b4)
	EXTU(0xa5a5a5a5a5a59fe7, 30, 15, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a59fe7, 16383, 30, 15, 0xa5a5a5a5fffd9fe7)
	EXT( 0xa5a5a5a5a5a59fe6, 30, 16, 0x0000000000006969)
	EXTU(0xa5a5a5a5a5a59fe6, 30, 16, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a59fe6, 32767, 30, 16, 0xa5a5a5a5fffd9fe6)
	EXT( 0xa5a5a5a5a5a59fe5, 30, 17, 0x000000000000d2d2)
	EXTU(0xa5a5a5a5a5a59fe5, 30, 17, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a59fe5, 65535, 30, 17, 0xa5a5a5a5ffff9fe5)
	EXT( 0xa5a5a5a5a5a59fe4, 30, 18, 0x000000000001a5a5)
	EXTU(0xa5a5a5a5a5a59fe4, 30, 18, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a59fe4, 131071, 30, 18, 0xa5a5a5a5ffff9fe4)
	EXT( 0xa5a5a5a5a5a59fe3, 30, 19, 0x0000000000034b4b)
	EXTU(0xa5a5a5a5a5a59fe3, 30, 19, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a59fe3, 262143, 30, 19, 0xa5a5a5a5ffff9fe3)
	EXT( 0xa5a5a5a5a5a59fe2, 30, 20, 0x0000000000069696)
	EXTU(0xa5a5a5a5a5a59fe2, 30, 20, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a59fe2, 524287, 30, 20, 0xa5a5a5a5ffffdfe2)
	EXT( 0xa5a5a5a5a5a59fe1, 30, 21, 0x00000000000d2d2c)
	EXTU(0xa5a5a5a5a5a59fe1, 30, 21, 0x00000000000d2d2c)
	DEP( 0xa5a5a5a5a5a59fe1, 1048575, 30, 21, 0xa5a5a5a5ffffffe1)
	EXT( 0xa5a5a5a5a5a59fe0, 30, 22, 0x00000000001a5a59)
	EXTU(0xa5a5a5a5a5a59fe0, 30, 22, 0x00000000001a5a59)
	DEP( 0xa5a5a5a5a5a59fe0, 2097151, 30, 22, 0xa5a5a5a5ffffffe0)
	EXT( 0xa5a5a5a5a5a59fdf, 30, 23, 0x000000000034b4b3)
	EXTU(0xa5a5a5a5a5a59fdf, 30, 23, 0x000000000034b4b3)
	DEP( 0xa5a5a5a5a5a59fdf, 4194303, 30, 23, 0xa5a5a5a5ffffffdf)
	EXT( 0xa5a5a5a5a5a59fde, 30, 24, 0x0000000000696967)
	EXTU(0xa5a5a5a5a5a59fde, 30, 24, 0x0000000000696967)
	DEP( 0xa5a5a5a5a5a59fde, 8388607, 30, 24, 0xa5a5a5a5ffffffde)
	EXT( 0xa5a5a5a5a5a59fdd, 30, 25, 0x0000000000d2d2cf)
	EXTU(0xa5a5a5a5a5a59fdd, 30, 25, 0x0000000000d2d2cf)
	DEP( 0xa5a5a5a5a5a59fdd, 16777215, 30, 25, 0xa5a5a5a5ffffffdd)
	EXT( 0xa5a5a5a5a5a59fdc, 30, 26, 0x0000000001a5a59f)
	EXTU(0xa5a5a5a5a5a59fdc, 30, 26, 0x0000000001a5a59f)
	DEP( 0xa5a5a5a5a5a59fdc, 33554431, 30, 26, 0xa5a5a5a5ffffffdc)
	EXT( 0xa5a5a5a5a5a59fdb, 30, 27, 0x00000000034b4b3f)
	EXTU(0xa5a5a5a5a5a59fdb, 30, 27, 0x00000000034b4b3f)
	DEP( 0xa5a5a5a5a5a59fdb, 67108863, 30, 27, 0xa5a5a5a5ffffffdb)
	EXT( 0xa5a5a5a5a5a59fda, 30, 28, 0x000000000696967f)
	EXTU(0xa5a5a5a5a5a59fda, 30, 28, 0x000000000696967f)
	DEP( 0xa5a5a5a5a5a59fda, 134217727, 30, 28, 0xa5a5a5a5ffffffda)
	EXT( 0xa5a5a5a5a5a59fd9, 30, 29, 0x000000000d2d2cfe)
	EXTU(0xa5a5a5a5a5a59fd9, 30, 29, 0x000000000d2d2cfe)
	DEP( 0xa5a5a5a5a5a59fd9, 268435455, 30, 29, 0xa5a5a5a5fffffff9)
	EXT( 0xa5a5a5a5a5a59fd8, 30, 30, 0x000000001a5a59fd)
	EXTU(0xa5a5a5a5a5a59fd8, 30, 30, 0x000000001a5a59fd)
	DEP( 0xa5a5a5a5a5a59fd8, 536870911, 30, 30, 0xa5a5a5a5fffffff8)
	EXT( 0xa5a5a5a5a5a59fd7, 30, 31, 0x0000000034b4b3fa)
	EXTU(0xa5a5a5a5a5a59fd7, 30, 31, 0x0000000034b4b3fa)
	DEP( 0xa5a5a5a5a5a59fd7, 1073741823, 30, 31, 0xa5a5a5a5ffffffff)
	EXT( 0xa5a5a5a5a5a59fd6, 30, 32, 0x00000000696967f5)
	EXTU(0xa5a5a5a5a5a59fd6, 30, 32, 0x00000000696967f5)
	DEP( 0xa5a5a5a5a5a59fd6, 2147483647, 30, 32, 0xa5a5a5a5fffffffe)
	EXT( 0xa5a5a5a5a5a59fd5, 30, 33, 0x00000000d2d2cfea)
	EXTU(0xa5a5a5a5a5a59fd5, 30, 33, 0x00000000d2d2cfea)
	DEP( 0xa5a5a5a5a5a59fd5, 4294967295, 30, 33, 0xa5a5a5a5ffffffff)
	EXT( 0xa5a5a5a5a5a59fd4, 31, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59fd4, 31, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59fd4, 0, 31, 1, 0xa5a5a5a4a5a59fd4)
	EXT( 0xa5a5a5a5a5a59fd3, 31, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59fd3, 31, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59fd3, 1, 31, 2, 0xa5a5a5a4a5a59fd3)
	EXT( 0xa5a5a5a5a5a59fd2, 31, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59fd2, 31, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59fd2, 3, 31, 3, 0xa5a5a5a4e5a59fd2)
	EXT( 0xa5a5a5a5a5a59fd1, 31, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59fd1, 31, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59fd1, 7, 31, 4, 0xa5a5a5a4e5a59fd1)
	EXT( 0xa5a5a5a5a5a59fd0, 31, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59fd0, 31, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59fd0, 15, 31, 5, 0xa5a5a5a4f5a59fd0)
	EXT( 0xa5a5a5a5a5a59fcf, 31, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59fcf, 31, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59fcf, 31, 31, 6, 0xa5a5a5a4fda59fcf)
	EXT( 0xa5a5a5a5a5a59fce, 31, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59fce, 31, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59fce, 63, 31, 7, 0xa5a5a5a4fda59fce)
	EXT( 0xa5a5a5a5a5a59fcd, 31, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59fcd, 31, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59fcd, 127, 31, 8, 0xa5a5a5a4ffa59fcd)
	EXT( 0xa5a5a5a5a5a59fcc, 31, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59fcc, 31, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59fcc, 255, 31, 9, 0xa5a5a5a4ffa59fcc)
	EXT( 0xa5a5a5a5a5a59fcb, 31, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59fcb, 31, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59fcb, 511, 31, 10, 0xa5a5a5a4ffa59fcb)
	EXT( 0xa5a5a5a5a5a59fca, 31, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59fca, 31, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59fca, 1023, 31, 11, 0xa5a5a5a4ffe59fca)
	EXT( 0xa5a5a5a5a5a59fc9, 31, 12, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a59fc9, 31, 12, 0x0000000000000d2d)
	DEP( 0xa5a5a5a5a5a59fc9, 2047, 31, 12, 0xa5a5a5a4ffe59fc9)
	EXT( 0xa5a5a5a5a5a59fc8, 31, 13, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a59fc8, 31, 13, 0x0000000000001a5a)
	DEP( 0xa5a5a5a5a5a59fc8, 4095, 31, 13, 0xa5a5a5a4fff59fc8)
	EXT( 0xa5a5a5a5a5a59fc7, 31, 14, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a59fc7, 31, 14, 0x00000000000034b4)
	DEP( 0xa5a5a5a5a5a59fc7, 8191, 31, 14, 0xa5a5a5a4fffd9fc7)
	EXT( 0xa5a5a5a5a5a59fc6, 31, 15, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a59fc6, 31, 15, 0x0000000000006969)
	DEP( 0xa5a5a5a5a5a59fc6, 16383, 31, 15, 0xa5a5a5a4fffd9fc6)
	EXT( 0xa5a5a5a5a5a59fc5, 31, 16, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a59fc5, 31, 16, 0x000000000000d2d2)
	DEP( 0xa5a5a5a5a5a59fc5, 32767, 31, 16, 0xa5a5a5a4ffff9fc5)
	EXT( 0xa5a5a5a5a5a59fc4, 31, 17, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a59fc4, 31, 17, 0x000000000001a5a5)
	DEP( 0xa5a5a5a5a5a59fc4, 65535, 31, 17, 0xa5a5a5a4ffff9fc4)
	EXT( 0xa5a5a5a5a5a59fc3, 31, 18, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a59fc3, 31, 18, 0x0000000000034b4b)
	DEP( 0xa5a5a5a5a5a59fc3, 131071, 31, 18, 0xa5a5a5a4ffff9fc3)
	EXT( 0xa5a5a5a5a5a59fc2, 31, 19, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a59fc2, 31, 19, 0x0000000000069696)
	DEP( 0xa5a5a5a5a5a59fc2, 262143, 31, 19, 0xa5a5a5a4ffffdfc2)
	EXT( 0xa5a5a5a5a5a59fc1, 31, 20, 0xfffffffffffd2d2c)
	EXTU(0xa5a5a5a5a5a59fc1, 31, 20, 0x00000000000d2d2c)
	DEP( 0xa5a5a5a5a5a59fc1, 524287, 31, 20, 0xa5a5a5a4ffffffc1)
	EXT( 0xa5a5a5a5a5a59fc0, 31, 21, 0xfffffffffffa5a59)
	EXTU(0xa5a5a5a5a5a59fc0, 31, 21, 0x00000000001a5a59)
	DEP( 0xa5a5a5a5a5a59fc0, 1048575, 31, 21, 0xa5a5a5a4ffffffc0)
	EXT( 0xa5a5a5a5a5a59fbf, 31, 22, 0xfffffffffff4b4b3)
	EXTU(0xa5a5a5a5a5a59fbf, 31, 22, 0x000000000034b4b3)
	DEP( 0xa5a5a5a5a5a59fbf, 2097151, 31, 22, 0xa5a5a5a4ffffffbf)
	EXT( 0xa5a5a5a5a5a59fbe, 31, 23, 0xffffffffffe96967)
	EXTU(0xa5a5a5a5a5a59fbe, 31, 23, 0x0000000000696967)
	DEP( 0xa5a5a5a5a5a59fbe, 4194303, 31, 23, 0xa5a5a5a4ffffffbe)
	EXT( 0xa5a5a5a5a5a59fbd, 31, 24, 0xffffffffffd2d2cf)
	EXTU(0xa5a5a5a5a5a59fbd, 31, 24, 0x0000000000d2d2cf)
	DEP( 0xa5a5a5a5a5a59fbd, 8388607, 31, 24, 0xa5a5a5a4ffffffbd)
	EXT( 0xa5a5a5a5a5a59fbc, 31, 25, 0xffffffffffa5a59f)
	EXTU(0xa5a5a5a5a5a59fbc, 31, 25, 0x0000000001a5a59f)
	DEP( 0xa5a5a5a5a5a59fbc, 16777215, 31, 25, 0xa5a5a5a4ffffffbc)
	EXT( 0xa5a5a5a5a5a59fbb, 31, 26, 0xffffffffff4b4b3f)
	EXTU(0xa5a5a5a5a5a59fbb, 31, 26, 0x00000000034b4b3f)
	DEP( 0xa5a5a5a5a5a59fbb, 33554431, 31, 26, 0xa5a5a5a4ffffffbb)
	EXT( 0xa5a5a5a5a5a59fba, 31, 27, 0xfffffffffe96967e)
	EXTU(0xa5a5a5a5a5a59fba, 31, 27, 0x000000000696967e)
	DEP( 0xa5a5a5a5a5a59fba, 67108863, 31, 27, 0xa5a5a5a4fffffffa)
	EXT( 0xa5a5a5a5a5a59fb9, 31, 28, 0xfffffffffd2d2cfd)
	EXTU(0xa5a5a5a5a5a59fb9, 31, 28, 0x000000000d2d2cfd)
	DEP( 0xa5a5a5a5a5a59fb9, 134217727, 31, 28, 0xa5a5a5a4fffffff9)
	EXT( 0xa5a5a5a5a5a59fb8, 31, 29, 0xfffffffffa5a59fb)
	EXTU(0xa5a5a5a5a5a59fb8, 31, 29, 0x000000001a5a59fb)
	DEP( 0xa5a5a5a5a5a59fb8, 268435455, 31, 29, 0xa5a5a5a4fffffff8)
	EXT( 0xa5a5a5a5a5a59fb7, 31, 30, 0xfffffffff4b4b3f6)
	EXTU(0xa5a5a5a5a5a59fb7, 31, 30, 0x0000000034b4b3f6)
	DEP( 0xa5a5a5a5a5a59fb7, 536870911, 31, 30, 0xa5a5a5a4ffffffff)
	EXT( 0xa5a5a5a5a5a59fb6, 31, 31, 0xffffffffe96967ed)
	EXTU(0xa5a5a5a5a5a59fb6, 31, 31, 0x00000000696967ed)
	DEP( 0xa5a5a5a5a5a59fb6, 1073741823, 31, 31, 0xa5a5a5a4fffffffe)
	EXT( 0xa5a5a5a5a5a59fb5, 31, 32, 0xffffffffd2d2cfda)
	EXTU(0xa5a5a5a5a5a59fb5, 31, 32, 0x00000000d2d2cfda)
	DEP( 0xa5a5a5a5a5a59fb5, 2147483647, 31, 32, 0xa5a5a5a4ffffffff)
	EXT( 0xa5a5a5a5a5a59fb4, 32, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59fb4, 32, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59fb4, 0, 32, 1, 0xa5a5a5a525a59fb4)
	EXT( 0xa5a5a5a5a5a59fb3, 32, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59fb3, 32, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59fb3, 1, 32, 2, 0xa5a5a5a565a59fb3)
	EXT( 0xa5a5a5a5a5a59fb2, 32, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59fb2, 32, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59fb2, 3, 32, 3, 0xa5a5a5a565a59fb2)
	EXT( 0xa5a5a5a5a5a59fb1, 32, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59fb1, 32, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a59fb1, 7, 32, 4, 0xa5a5a5a575a59fb1)
	EXT( 0xa5a5a5a5a5a59fb0, 32, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59fb0, 32, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a59fb0, 15, 32, 5, 0xa5a5a5a57da59fb0)
	EXT( 0xa5a5a5a5a5a59faf, 32, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59faf, 32, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a59faf, 31, 32, 6, 0xa5a5a5a57da59faf)
	EXT( 0xa5a5a5a5a5a59fae, 32, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59fae, 32, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a59fae, 63, 32, 7, 0xa5a5a5a57fa59fae)
	EXT( 0xa5a5a5a5a5a59fad, 32, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59fad, 32, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a59fad, 127, 32, 8, 0xa5a5a5a57fa59fad)
	EXT( 0xa5a5a5a5a5a59fac, 32, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59fac, 32, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a59fac, 255, 32, 9, 0xa5a5a5a57fa59fac)
	EXT( 0xa5a5a5a5a5a59fab, 32, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59fab, 32, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a59fab, 511, 32, 10, 0xa5a5a5a57fe59fab)
	EXT( 0xa5a5a5a5a5a59faa, 32, 11, 0xfffffffffffffd2d)
	EXTU(0xa5a5a5a5a5a59faa, 32, 11, 0x000000000000052d)
	DEP( 0xa5a5a5a5a5a59faa, 1023, 32, 11, 0xa5a5a5a57fe59faa)
	EXT( 0xa5a5a5a5a5a59fa9, 32, 12, 0xfffffffffffffa5a)
	EXTU(0xa5a5a5a5a5a59fa9, 32, 12, 0x0000000000000a5a)
	DEP( 0xa5a5a5a5a5a59fa9, 2047, 32, 12, 0xa5a5a5a57ff59fa9)
	EXT( 0xa5a5a5a5a5a59fa8, 32, 13, 0xfffffffffffff4b4)
	EXTU(0xa5a5a5a5a5a59fa8, 32, 13, 0x00000000000014b4)
	DEP( 0xa5a5a5a5a5a59fa8, 4095, 32, 13, 0xa5a5a5a57ffd9fa8)
	EXT( 0xa5a5a5a5a5a59fa7, 32, 14, 0xffffffffffffe969)
	EXTU(0xa5a5a5a5a5a59fa7, 32, 14, 0x0000000000002969)
	DEP( 0xa5a5a5a5a5a59fa7, 8191, 32, 14, 0xa5a5a5a57ffd9fa7)
	EXT( 0xa5a5a5a5a5a59fa6, 32, 15, 0xffffffffffffd2d2)
	EXTU(0xa5a5a5a5a5a59fa6, 32, 15, 0x00000000000052d2)
	DEP( 0xa5a5a5a5a5a59fa6, 16383, 32, 15, 0xa5a5a5a57fff9fa6)
	EXT( 0xa5a5a5a5a5a59fa5, 32, 16, 0xffffffffffffa5a5)
	EXTU(0xa5a5a5a5a5a59fa5, 32, 16, 0x000000000000a5a5)
	DEP( 0xa5a5a5a5a5a59fa5, 32767, 32, 16, 0xa5a5a5a57fff9fa5)
	EXT( 0xa5a5a5a5a5a59fa4, 32, 17, 0xffffffffffff4b4b)
	EXTU(0xa5a5a5a5a5a59fa4, 32, 17, 0x0000000000014b4b)
	DEP( 0xa5a5a5a5a5a59fa4, 65535, 32, 17, 0xa5a5a5a57fff9fa4)
	EXT( 0xa5a5a5a5a5a59fa3, 32, 18, 0xfffffffffffe9696)
	EXTU(0xa5a5a5a5a5a59fa3, 32, 18, 0x0000000000029696)
	DEP( 0xa5a5a5a5a5a59fa3, 131071, 32, 18, 0xa5a5a5a57fffdfa3)
	EXT( 0xa5a5a5a5a5a59fa2, 32, 19, 0xfffffffffffd2d2c)
	EXTU(0xa5a5a5a5a5a59fa2, 32, 19, 0x0000000000052d2c)
	DEP( 0xa5a5a5a5a5a59fa2, 262143, 32, 19, 0xa5a5a5a57fffffa2)
	EXT( 0xa5a5a5a5a5a59fa1, 32, 20, 0xfffffffffffa5a59)
	EXTU(0xa5a5a5a5a5a59fa1, 32, 20, 0x00000000000a5a59)
	DEP( 0xa5a5a5a5a5a59fa1, 524287, 32, 20, 0xa5a5a5a57fffffa1)
	EXT( 0xa5a5a5a5a5a59fa0, 32, 21, 0xfffffffffff4b4b3)
	EXTU(0xa5a5a5a5a5a59fa0, 32, 21, 0x000000000014b4b3)
	DEP( 0xa5a5a5a5a5a59fa0, 1048575, 32, 21, 0xa5a5a5a57fffffa0)
	EXT( 0xa5a5a5a5a5a59f9f, 32, 22, 0xffffffffffe96967)
	EXTU(0xa5a5a5a5a5a59f9f, 32, 22, 0x0000000000296967)
	DEP( 0xa5a5a5a5a5a59f9f, 2097151, 32, 22, 0xa5a5a5a57fffff9f)
	EXT( 0xa5a5a5a5a5a59f9e, 32, 23, 0xffffffffffd2d2cf)
	EXTU(0xa5a5a5a5a5a59f9e, 32, 23, 0x000000000052d2cf)
	DEP( 0xa5a5a5a5a5a59f9e, 4194303, 32, 23, 0xa5a5a5a57fffff9e)
	EXT( 0xa5a5a5a5a5a59f9d, 32, 24, 0xffffffffffa5a59f)
	EXTU(0xa5a5a5a5a5a59f9d, 32, 24, 0x0000000000a5a59f)
	DEP( 0xa5a5a5a5a5a59f9d, 8388607, 32, 24, 0xa5a5a5a57fffff9d)
	EXT( 0xa5a5a5a5a5a59f9c, 32, 25, 0xffffffffff4b4b3f)
	EXTU(0xa5a5a5a5a5a59f9c, 32, 25, 0x00000000014b4b3f)
	DEP( 0xa5a5a5a5a5a59f9c, 16777215, 32, 25, 0xa5a5a5a57fffff9c)
	EXT( 0xa5a5a5a5a5a59f9b, 32, 26, 0xfffffffffe96967e)
	EXTU(0xa5a5a5a5a5a59f9b, 32, 26, 0x000000000296967e)
	DEP( 0xa5a5a5a5a5a59f9b, 33554431, 32, 26, 0xa5a5a5a57fffffdb)
	EXT( 0xa5a5a5a5a5a59f9a, 32, 27, 0xfffffffffd2d2cfc)
	EXTU(0xa5a5a5a5a5a59f9a, 32, 27, 0x00000000052d2cfc)
	DEP( 0xa5a5a5a5a5a59f9a, 67108863, 32, 27, 0xa5a5a5a57ffffffa)
	EXT( 0xa5a5a5a5a5a59f99, 32, 28, 0xfffffffffa5a59f9)
	EXTU(0xa5a5a5a5a5a59f99, 32, 28, 0x000000000a5a59f9)
	DEP( 0xa5a5a5a5a5a59f99, 134217727, 32, 28, 0xa5a5a5a57ffffff9)
	EXT( 0xa5a5a5a5a5a59f98, 32, 29, 0xfffffffff4b4b3f3)
	EXTU(0xa5a5a5a5a5a59f98, 32, 29, 0x0000000014b4b3f3)
	DEP( 0xa5a5a5a5a5a59f98, 268435455, 32, 29, 0xa5a5a5a57ffffff8)
	EXT( 0xa5a5a5a5a5a59f97, 32, 30, 0xffffffffe96967e5)
	EXTU(0xa5a5a5a5a5a59f97, 32, 30, 0x00000000296967e5)
	DEP( 0xa5a5a5a5a5a59f97, 536870911, 32, 30, 0xa5a5a5a57fffffff)
	EXT( 0xa5a5a5a5a5a59f96, 32, 31, 0xffffffffd2d2cfcb)
	EXTU(0xa5a5a5a5a5a59f96, 32, 31, 0x0000000052d2cfcb)
	DEP( 0xa5a5a5a5a5a59f96, 1073741823, 32, 31, 0xa5a5a5a57ffffffe)
	EXT( 0xa5a5a5a5a5a59f95, 33, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f95, 33, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f95, 0, 33, 1, 0xa5a5a5a5a5a59f95)
	EXT( 0xa5a5a5a5a5a59f94, 33, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59f94, 33, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f94, 1, 33, 2, 0xa5a5a5a5a5a59f94)
	EXT( 0xa5a5a5a5a5a59f93, 33, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59f93, 33, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f93, 3, 33, 3, 0xa5a5a5a5b5a59f93)
	EXT( 0xa5a5a5a5a5a59f92, 33, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a59f92, 33, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59f92, 7, 33, 4, 0xa5a5a5a5bda59f92)
	EXT( 0xa5a5a5a5a5a59f91, 33, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a59f91, 33, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59f91, 15, 33, 5, 0xa5a5a5a5bda59f91)
	EXT( 0xa5a5a5a5a5a59f90, 33, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a59f90, 33, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59f90, 31, 33, 6, 0xa5a5a5a5bfa59f90)
	EXT( 0xa5a5a5a5a5a59f8f, 33, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a59f8f, 33, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59f8f, 63, 33, 7, 0xa5a5a5a5bfa59f8f)
	EXT( 0xa5a5a5a5a5a59f8e, 33, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a59f8e, 33, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59f8e, 127, 33, 8, 0xa5a5a5a5bfa59f8e)
	EXT( 0xa5a5a5a5a5a59f8d, 33, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a59f8d, 33, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59f8d, 255, 33, 9, 0xa5a5a5a5bfe59f8d)
	EXT( 0xa5a5a5a5a5a59f8c, 33, 10, 0x000000000000012d)
	EXTU(0xa5a5a5a5a5a59f8c, 33, 10, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59f8c, 511, 33, 10, 0xa5a5a5a5bfe59f8c)
	EXT( 0xa5a5a5a5a5a59f8b, 33, 11, 0x000000000000025a)
	EXTU(0xa5a5a5a5a5a59f8b, 33, 11, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59f8b, 1023, 33, 11, 0xa5a5a5a5bff59f8b)
	EXT( 0xa5a5a5a5a5a59f8a, 33, 12, 0x00000000000004b4)
	EXTU(0xa5a5a5a5a5a59f8a, 33, 12, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59f8a, 2047, 33, 12, 0xa5a5a5a5bffd9f8a)
	EXT( 0xa5a5a5a5a5a59f89, 33, 13, 0x0000000000000969)
	EXTU(0xa5a5a5a5a5a59f89, 33, 13, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59f89, 4095, 33, 13, 0xa5a5a5a5bffd9f89)
	EXT( 0xa5a5a5a5a5a59f88, 33, 14, 0x00000000000012d2)
	EXTU(0xa5a5a5a5a5a59f88, 33, 14, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59f88, 8191, 33, 14, 0xa5a5a5a5bfff9f88)
	EXT( 0xa5a5a5a5a5a59f87, 33, 15, 0x00000000000025a5)
	EXTU(0xa5a5a5a5a5a59f87, 33, 15, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59f87, 16383, 33, 15, 0xa5a5a5a5bfff9f87)
	EXT( 0xa5a5a5a5a5a59f86, 33, 16, 0x0000000000004b4b)
	EXTU(0xa5a5a5a5a5a59f86, 33, 16, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59f86, 32767, 33, 16, 0xa5a5a5a5bfff9f86)
	EXT( 0xa5a5a5a5a5a59f85, 33, 17, 0x0000000000009696)
	EXTU(0xa5a5a5a5a5a59f85, 33, 17, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59f85, 65535, 33, 17, 0xa5a5a5a5bfffdf85)
	EXT( 0xa5a5a5a5a5a59f84, 33, 18, 0x0000000000012d2c)
	EXTU(0xa5a5a5a5a5a59f84, 33, 18, 0x0000000000012d2c)
	DEP( 0xa5a5a5a5a5a59f84, 131071, 33, 18, 0xa5a5a5a5bfffff84)
	EXT( 0xa5a5a5a5a5a59f83, 33, 19, 0x0000000000025a59)
	EXTU(0xa5a5a5a5a5a59f83, 33, 19, 0x0000000000025a59)
	DEP( 0xa5a5a5a5a5a59f83, 262143, 33, 19, 0xa5a5a5a5bfffff83)
	EXT( 0xa5a5a5a5a5a59f82, 33, 20, 0x000000000004b4b3)
	EXTU(0xa5a5a5a5a5a59f82, 33, 20, 0x000000000004b4b3)
	DEP( 0xa5a5a5a5a5a59f82, 524287, 33, 20, 0xa5a5a5a5bfffff82)
	EXT( 0xa5a5a5a5a5a59f81, 33, 21, 0x0000000000096967)
	EXTU(0xa5a5a5a5a5a59f81, 33, 21, 0x0000000000096967)
	DEP( 0xa5a5a5a5a5a59f81, 1048575, 33, 21, 0xa5a5a5a5bfffff81)
	EXT( 0xa5a5a5a5a5a59f80, 33, 22, 0x000000000012d2cf)
	EXTU(0xa5a5a5a5a5a59f80, 33, 22, 0x000000000012d2cf)
	DEP( 0xa5a5a5a5a5a59f80, 2097151, 33, 22, 0xa5a5a5a5bfffff80)
	EXT( 0xa5a5a5a5a5a59f7f, 33, 23, 0x000000000025a59f)
	EXTU(0xa5a5a5a5a5a59f7f, 33, 23, 0x000000000025a59f)
	DEP( 0xa5a5a5a5a5a59f7f, 4194303, 33, 23, 0xa5a5a5a5bfffff7f)
	EXT( 0xa5a5a5a5a5a59f7e, 33, 24, 0x00000000004b4b3e)
	EXTU(0xa5a5a5a5a5a59f7e, 33, 24, 0x00000000004b4b3e)
	DEP( 0xa5a5a5a5a5a59f7e, 8388607, 33, 24, 0xa5a5a5a5bffffffe)
	EXT( 0xa5a5a5a5a5a59f7d, 33, 25, 0x000000000096967d)
	EXTU(0xa5a5a5a5a5a59f7d, 33, 25, 0x000000000096967d)
	DEP( 0xa5a5a5a5a5a59f7d, 16777215, 33, 25, 0xa5a5a5a5bffffffd)
	EXT( 0xa5a5a5a5a5a59f7c, 33, 26, 0x00000000012d2cfb)
	EXTU(0xa5a5a5a5a5a59f7c, 33, 26, 0x00000000012d2cfb)
	DEP( 0xa5a5a5a5a5a59f7c, 33554431, 33, 26, 0xa5a5a5a5bffffffc)
	EXT( 0xa5a5a5a5a5a59f7b, 33, 27, 0x00000000025a59f7)
	EXTU(0xa5a5a5a5a5a59f7b, 33, 27, 0x00000000025a59f7)
	DEP( 0xa5a5a5a5a5a59f7b, 67108863, 33, 27, 0xa5a5a5a5bffffffb)
	EXT( 0xa5a5a5a5a5a59f7a, 33, 28, 0x0000000004b4b3ef)
	EXTU(0xa5a5a5a5a5a59f7a, 33, 28, 0x0000000004b4b3ef)
	DEP( 0xa5a5a5a5a5a59f7a, 134217727, 33, 28, 0xa5a5a5a5bffffffa)
	EXT( 0xa5a5a5a5a5a59f79, 33, 29, 0x00000000096967de)
	EXTU(0xa5a5a5a5a5a59f79, 33, 29, 0x00000000096967de)
	DEP( 0xa5a5a5a5a5a59f79, 268435455, 33, 29, 0xa5a5a5a5bffffffd)
	EXT( 0xa5a5a5a5a5a59f78, 33, 30, 0x0000000012d2cfbc)
	EXTU(0xa5a5a5a5a5a59f78, 33, 30, 0x0000000012d2cfbc)
	DEP( 0xa5a5a5a5a5a59f78, 536870911, 33, 30, 0xa5a5a5a5bffffffe)
	EXT( 0xa5a5a5a5a5a59f77, 34, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59f77, 34, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f77, 0, 34, 1, 0xa5a5a5a585a59f77)
	EXT( 0xa5a5a5a5a5a59f76, 34, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59f76, 34, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f76, 1, 34, 2, 0xa5a5a5a595a59f76)
	EXT( 0xa5a5a5a5a5a59f75, 34, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59f75, 34, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59f75, 3, 34, 3, 0xa5a5a5a59da59f75)
	EXT( 0xa5a5a5a5a5a59f74, 34, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59f74, 34, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59f74, 7, 34, 4, 0xa5a5a5a59da59f74)
	EXT( 0xa5a5a5a5a5a59f73, 34, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a59f73, 34, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59f73, 15, 34, 5, 0xa5a5a5a59fa59f73)
	EXT( 0xa5a5a5a5a5a59f72, 34, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a59f72, 34, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59f72, 31, 34, 6, 0xa5a5a5a59fa59f72)
	EXT( 0xa5a5a5a5a5a59f71, 34, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a59f71, 34, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59f71, 63, 34, 7, 0xa5a5a5a59fa59f71)
	EXT( 0xa5a5a5a5a5a59f70, 34, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a59f70, 34, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59f70, 127, 34, 8, 0xa5a5a5a59fe59f70)
	EXT( 0xa5a5a5a5a5a59f6f, 34, 9, 0xffffffffffffff2d)
	EXTU(0xa5a5a5a5a5a59f6f, 34, 9, 0x000000000000012d)
	DEP( 0xa5a5a5a5a5a59f6f, 255, 34, 9, 0xa5a5a5a59fe59f6f)
	EXT( 0xa5a5a5a5a5a59f6e, 34, 10, 0xfffffffffffffe5a)
	EXTU(0xa5a5a5a5a5a59f6e, 34, 10, 0x000000000000025a)
	DEP( 0xa5a5a5a5a5a59f6e, 511, 34, 10, 0xa5a5a5a59ff59f6e)
	EXT( 0xa5a5a5a5a5a59f6d, 34, 11, 0xfffffffffffffcb4)
	EXTU(0xa5a5a5a5a5a59f6d, 34, 11, 0x00000000000004b4)
	DEP( 0xa5a5a5a5a5a59f6d, 1023, 34, 11, 0xa5a5a5a59ffd9f6d)
	EXT( 0xa5a5a5a5a5a59f6c, 34, 12, 0xfffffffffffff969)
	EXTU(0xa5a5a5a5a5a59f6c, 34, 12, 0x0000000000000969)
	DEP( 0xa5a5a5a5a5a59f6c, 2047, 34, 12, 0xa5a5a5a59ffd9f6c)
	EXT( 0xa5a5a5a5a5a59f6b, 34, 13, 0xfffffffffffff2d2)
	EXTU(0xa5a5a5a5a5a59f6b, 34, 13, 0x00000000000012d2)
	DEP( 0xa5a5a5a5a5a59f6b, 4095, 34, 13, 0xa5a5a5a59fff9f6b)
	EXT( 0xa5a5a5a5a5a59f6a, 34, 14, 0xffffffffffffe5a5)
	EXTU(0xa5a5a5a5a5a59f6a, 34, 14, 0x00000000000025a5)
	DEP( 0xa5a5a5a5a5a59f6a, 8191, 34, 14, 0xa5a5a5a59fff9f6a)
	EXT( 0xa5a5a5a5a5a59f69, 34, 15, 0xffffffffffffcb4b)
	EXTU(0xa5a5a5a5a5a59f69, 34, 15, 0x0000000000004b4b)
	DEP( 0xa5a5a5a5a5a59f69, 16383, 34, 15, 0xa5a5a5a59fff9f69)
	EXT( 0xa5a5a5a5a5a59f68, 34, 16, 0xffffffffffff9696)
	EXTU(0xa5a5a5a5a5a59f68, 34, 16, 0x0000000000009696)
	DEP( 0xa5a5a5a5a5a59f68, 32767, 34, 16, 0xa5a5a5a59fffdf68)
	EXT( 0xa5a5a5a5a5a59f67, 34, 17, 0xffffffffffff2d2c)
	EXTU(0xa5a5a5a5a5a59f67, 34, 17, 0x0000000000012d2c)
	DEP( 0xa5a5a5a5a5a59f67, 65535, 34, 17, 0xa5a5a5a59fffff67)
	EXT( 0xa5a5a5a5a5a59f66, 34, 18, 0xfffffffffffe5a59)
	EXTU(0xa5a5a5a5a5a59f66, 34, 18, 0x0000000000025a59)
	DEP( 0xa5a5a5a5a5a59f66, 131071, 34, 18, 0xa5a5a5a59fffff66)
	EXT( 0xa5a5a5a5a5a59f65, 34, 19, 0xfffffffffffcb4b3)
	EXTU(0xa5a5a5a5a5a59f65, 34, 19, 0x000000000004b4b3)
	DEP( 0xa5a5a5a5a5a59f65, 262143, 34, 19, 0xa5a5a5a59fffff65)
	EXT( 0xa5a5a5a5a5a59f64, 34, 20, 0xfffffffffff96967)
	EXTU(0xa5a5a5a5a5a59f64, 34, 20, 0x0000000000096967)
	DEP( 0xa5a5a5a5a5a59f64, 524287, 34, 20, 0xa5a5a5a59fffff64)
	EXT( 0xa5a5a5a5a5a59f63, 34, 21, 0xfffffffffff2d2cf)
	EXTU(0xa5a5a5a5a5a59f63, 34, 21, 0x000000000012d2cf)
	DEP( 0xa5a5a5a5a5a59f63, 1048575, 34, 21, 0xa5a5a5a59fffff63)
	EXT( 0xa5a5a5a5a5a59f62, 34, 22, 0xffffffffffe5a59f)
	EXTU(0xa5a5a5a5a5a59f62, 34, 22, 0x000000000025a59f)
	DEP( 0xa5a5a5a5a5a59f62, 2097151, 34, 22, 0xa5a5a5a59fffff62)
	EXT( 0xa5a5a5a5a5a59f61, 34, 23, 0xffffffffffcb4b3e)
	EXTU(0xa5a5a5a5a5a59f61, 34, 23, 0x00000000004b4b3e)
	DEP( 0xa5a5a5a5a5a59f61, 4194303, 34, 23, 0xa5a5a5a59fffffe1)
	EXT( 0xa5a5a5a5a5a59f60, 34, 24, 0xffffffffff96967d)
	EXTU(0xa5a5a5a5a5a59f60, 34, 24, 0x000000000096967d)
	DEP( 0xa5a5a5a5a5a59f60, 8388607, 34, 24, 0xa5a5a5a59fffffe0)
	EXT( 0xa5a5a5a5a5a59f5f, 34, 25, 0xffffffffff2d2cfa)
	EXTU(0xa5a5a5a5a5a59f5f, 34, 25, 0x00000000012d2cfa)
	DEP( 0xa5a5a5a5a5a59f5f, 16777215, 34, 25, 0xa5a5a5a59fffffff)
	EXT( 0xa5a5a5a5a5a59f5e, 34, 26, 0xfffffffffe5a59f5)
	EXTU(0xa5a5a5a5a5a59f5e, 34, 26, 0x00000000025a59f5)
	DEP( 0xa5a5a5a5a5a59f5e, 33554431, 34, 26, 0xa5a5a5a59ffffffe)
	EXT( 0xa5a5a5a5a5a59f5d, 34, 27, 0xfffffffffcb4b3eb)
	EXTU(0xa5a5a5a5a5a59f5d, 34, 27, 0x0000000004b4b3eb)
	DEP( 0xa5a5a5a5a5a59f5d, 67108863, 34, 27, 0xa5a5a5a59ffffffd)
	EXT( 0xa5a5a5a5a5a59f5c, 34, 28, 0xfffffffff96967d7)
	EXTU(0xa5a5a5a5a5a59f5c, 34, 28, 0x00000000096967d7)
	DEP( 0xa5a5a5a5a5a59f5c, 134217727, 34, 28, 0xa5a5a5a59ffffffc)
	EXT( 0xa5a5a5a5a5a59f5b, 34, 29, 0xfffffffff2d2cfad)
	EXTU(0xa5a5a5a5a5a59f5b, 34, 29, 0x0000000012d2cfad)
	DEP( 0xa5a5a5a5a5a59f5b, 268435455, 34, 29, 0xa5a5a5a59fffffff)
	EXT( 0xa5a5a5a5a5a59f5a, 35, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f5a, 35, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f5a, 0, 35, 1, 0xa5a5a5a5a5a59f5a)
	EXT( 0xa5a5a5a5a5a59f59, 35, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f59, 35, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f59, 1, 35, 2, 0xa5a5a5a5ada59f59)
	EXT( 0xa5a5a5a5a5a59f58, 35, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59f58, 35, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f58, 3, 35, 3, 0xa5a5a5a5ada59f58)
	EXT( 0xa5a5a5a5a5a59f57, 35, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59f57, 35, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f57, 7, 35, 4, 0xa5a5a5a5afa59f57)
	EXT( 0xa5a5a5a5a5a59f56, 35, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59f56, 35, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59f56, 15, 35, 5, 0xa5a5a5a5afa59f56)
	EXT( 0xa5a5a5a5a5a59f55, 35, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59f55, 35, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59f55, 31, 35, 6, 0xa5a5a5a5afa59f55)
	EXT( 0xa5a5a5a5a5a59f54, 35, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59f54, 35, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59f54, 63, 35, 7, 0xa5a5a5a5afe59f54)
	EXT( 0xa5a5a5a5a5a59f53, 35, 8, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59f53, 35, 8, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59f53, 127, 35, 8, 0xa5a5a5a5afe59f53)
	EXT( 0xa5a5a5a5a5a59f52, 35, 9, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59f52, 35, 9, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59f52, 255, 35, 9, 0xa5a5a5a5aff59f52)
	EXT( 0xa5a5a5a5a5a59f51, 35, 10, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59f51, 35, 10, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59f51, 511, 35, 10, 0xa5a5a5a5affd9f51)
	EXT( 0xa5a5a5a5a5a59f50, 35, 11, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59f50, 35, 11, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59f50, 1023, 35, 11, 0xa5a5a5a5affd9f50)
	EXT( 0xa5a5a5a5a5a59f4f, 35, 12, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59f4f, 35, 12, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59f4f, 2047, 35, 12, 0xa5a5a5a5afff9f4f)
	EXT( 0xa5a5a5a5a5a59f4e, 35, 13, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59f4e, 35, 13, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59f4e, 4095, 35, 13, 0xa5a5a5a5afff9f4e)
	EXT( 0xa5a5a5a5a5a59f4d, 35, 14, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59f4d, 35, 14, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59f4d, 8191, 35, 14, 0xa5a5a5a5afff9f4d)
	EXT( 0xa5a5a5a5a5a59f4c, 35, 15, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59f4c, 35, 15, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59f4c, 16383, 35, 15, 0xa5a5a5a5afffdf4c)
	EXT( 0xa5a5a5a5a5a59f4b, 35, 16, 0x0000000000002d2c)
	EXTU(0xa5a5a5a5a5a59f4b, 35, 16, 0x0000000000002d2c)
	DEP( 0xa5a5a5a5a5a59f4b, 32767, 35, 16, 0xa5a5a5a5afffff4b)
	EXT( 0xa5a5a5a5a5a59f4a, 35, 17, 0x0000000000005a59)
	EXTU(0xa5a5a5a5a5a59f4a, 35, 17, 0x0000000000005a59)
	DEP( 0xa5a5a5a5a5a59f4a, 65535, 35, 17, 0xa5a5a5a5afffff4a)
	EXT( 0xa5a5a5a5a5a59f49, 35, 18, 0x000000000000b4b3)
	EXTU(0xa5a5a5a5a5a59f49, 35, 18, 0x000000000000b4b3)
	DEP( 0xa5a5a5a5a5a59f49, 131071, 35, 18, 0xa5a5a5a5afffff49)
	EXT( 0xa5a5a5a5a5a59f48, 35, 19, 0x0000000000016967)
	EXTU(0xa5a5a5a5a5a59f48, 35, 19, 0x0000000000016967)
	DEP( 0xa5a5a5a5a5a59f48, 262143, 35, 19, 0xa5a5a5a5afffff48)
	EXT( 0xa5a5a5a5a5a59f47, 35, 20, 0x000000000002d2cf)
	EXTU(0xa5a5a5a5a5a59f47, 35, 20, 0x000000000002d2cf)
	DEP( 0xa5a5a5a5a5a59f47, 524287, 35, 20, 0xa5a5a5a5afffff47)
	EXT( 0xa5a5a5a5a5a59f46, 35, 21, 0x000000000005a59f)
	EXTU(0xa5a5a5a5a5a59f46, 35, 21, 0x000000000005a59f)
	DEP( 0xa5a5a5a5a5a59f46, 1048575, 35, 21, 0xa5a5a5a5afffff46)
	EXT( 0xa5a5a5a5a5a59f45, 35, 22, 0x00000000000b4b3e)
	EXTU(0xa5a5a5a5a5a59f45, 35, 22, 0x00000000000b4b3e)
	DEP( 0xa5a5a5a5a5a59f45, 2097151, 35, 22, 0xa5a5a5a5afffffc5)
	EXT( 0xa5a5a5a5a5a59f44, 35, 23, 0x000000000016967d)
	EXTU(0xa5a5a5a5a5a59f44, 35, 23, 0x000000000016967d)
	DEP( 0xa5a5a5a5a5a59f44, 4194303, 35, 23, 0xa5a5a5a5afffffc4)
	EXT( 0xa5a5a5a5a5a59f43, 35, 24, 0x00000000002d2cfa)
	EXTU(0xa5a5a5a5a5a59f43, 35, 24, 0x00000000002d2cfa)
	DEP( 0xa5a5a5a5a5a59f43, 8388607, 35, 24, 0xa5a5a5a5afffffe3)
	EXT( 0xa5a5a5a5a5a59f42, 35, 25, 0x00000000005a59f4)
	EXTU(0xa5a5a5a5a5a59f42, 35, 25, 0x00000000005a59f4)
	DEP( 0xa5a5a5a5a5a59f42, 16777215, 35, 25, 0xa5a5a5a5affffff2)
	EXT( 0xa5a5a5a5a5a59f41, 35, 26, 0x0000000000b4b3e8)
	EXTU(0xa5a5a5a5a5a59f41, 35, 26, 0x0000000000b4b3e8)
	DEP( 0xa5a5a5a5a5a59f41, 33554431, 35, 26, 0xa5a5a5a5affffff9)
	EXT( 0xa5a5a5a5a5a59f40, 35, 27, 0x00000000016967d0)
	EXTU(0xa5a5a5a5a5a59f40, 35, 27, 0x00000000016967d0)
	DEP( 0xa5a5a5a5a5a59f40, 67108863, 35, 27, 0xa5a5a5a5affffffc)
	EXT( 0xa5a5a5a5a5a59f3f, 35, 28, 0x0000000002d2cf9f)
	EXTU(0xa5a5a5a5a5a59f3f, 35, 28, 0x0000000002d2cf9f)
	DEP( 0xa5a5a5a5a5a59f3f, 134217727, 35, 28, 0xa5a5a5a5afffffff)
	EXT( 0xa5a5a5a5a5a59f3e, 36, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f3e, 36, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f3e, 0, 36, 1, 0xa5a5a5a5a5a59f3e)
	EXT( 0xa5a5a5a5a5a59f3d, 36, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59f3d, 36, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f3d, 1, 36, 2, 0xa5a5a5a5a5a59f3d)
	EXT( 0xa5a5a5a5a5a59f3c, 36, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59f3c, 36, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f3c, 3, 36, 3, 0xa5a5a5a5a7a59f3c)
	EXT( 0xa5a5a5a5a5a59f3b, 36, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59f3b, 36, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59f3b, 7, 36, 4, 0xa5a5a5a5a7a59f3b)
	EXT( 0xa5a5a5a5a5a59f3a, 36, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59f3a, 36, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59f3a, 15, 36, 5, 0xa5a5a5a5a7a59f3a)
	EXT( 0xa5a5a5a5a5a59f39, 36, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59f39, 36, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59f39, 31, 36, 6, 0xa5a5a5a5a7e59f39)
	EXT( 0xa5a5a5a5a5a59f38, 36, 7, 0x000000000000002d)
	EXTU(0xa5a5a5a5a5a59f38, 36, 7, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59f38, 63, 36, 7, 0xa5a5a5a5a7e59f38)
	EXT( 0xa5a5a5a5a5a59f37, 36, 8, 0x000000000000005a)
	EXTU(0xa5a5a5a5a5a59f37, 36, 8, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59f37, 127, 36, 8, 0xa5a5a5a5a7f59f37)
	EXT( 0xa5a5a5a5a5a59f36, 36, 9, 0x00000000000000b4)
	EXTU(0xa5a5a5a5a5a59f36, 36, 9, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59f36, 255, 36, 9, 0xa5a5a5a5a7fd9f36)
	EXT( 0xa5a5a5a5a5a59f35, 36, 10, 0x0000000000000169)
	EXTU(0xa5a5a5a5a5a59f35, 36, 10, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59f35, 511, 36, 10, 0xa5a5a5a5a7fd9f35)
	EXT( 0xa5a5a5a5a5a59f34, 36, 11, 0x00000000000002d2)
	EXTU(0xa5a5a5a5a5a59f34, 36, 11, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59f34, 1023, 36, 11, 0xa5a5a5a5a7ff9f34)
	EXT( 0xa5a5a5a5a5a59f33, 36, 12, 0x00000000000005a5)
	EXTU(0xa5a5a5a5a5a59f33, 36, 12, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59f33, 2047, 36, 12, 0xa5a5a5a5a7ff9f33)
	EXT( 0xa5a5a5a5a5a59f32, 36, 13, 0x0000000000000b4b)
	EXTU(0xa5a5a5a5a5a59f32, 36, 13, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59f32, 4095, 36, 13, 0xa5a5a5a5a7ff9f32)
	EXT( 0xa5a5a5a5a5a59f31, 36, 14, 0x0000000000001696)
	EXTU(0xa5a5a5a5a5a59f31, 36, 14, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59f31, 8191, 36, 14, 0xa5a5a5a5a7ffdf31)
	EXT( 0xa5a5a5a5a5a59f30, 36, 15, 0x0000000000002d2c)
	EXTU(0xa5a5a5a5a5a59f30, 36, 15, 0x0000000000002d2c)
	DEP( 0xa5a5a5a5a5a59f30, 16383, 36, 15, 0xa5a5a5a5a7ffff30)
	EXT( 0xa5a5a5a5a5a59f2f, 36, 16, 0x0000000000005a59)
	EXTU(0xa5a5a5a5a5a59f2f, 36, 16, 0x0000000000005a59)
	DEP( 0xa5a5a5a5a5a59f2f, 32767, 36, 16, 0xa5a5a5a5a7ffff2f)
	EXT( 0xa5a5a5a5a5a59f2e, 36, 17, 0x000000000000b4b3)
	EXTU(0xa5a5a5a5a5a59f2e, 36, 17, 0x000000000000b4b3)
	DEP( 0xa5a5a5a5a5a59f2e, 65535, 36, 17, 0xa5a5a5a5a7ffff2e)
	EXT( 0xa5a5a5a5a5a59f2d, 36, 18, 0x0000000000016967)
	EXTU(0xa5a5a5a5a5a59f2d, 36, 18, 0x0000000000016967)
	DEP( 0xa5a5a5a5a5a59f2d, 131071, 36, 18, 0xa5a5a5a5a7ffff2d)
	EXT( 0xa5a5a5a5a5a59f2c, 36, 19, 0x000000000002d2cf)
	EXTU(0xa5a5a5a5a5a59f2c, 36, 19, 0x000000000002d2cf)
	DEP( 0xa5a5a5a5a5a59f2c, 262143, 36, 19, 0xa5a5a5a5a7ffff2c)
	EXT( 0xa5a5a5a5a5a59f2b, 36, 20, 0x000000000005a59f)
	EXTU(0xa5a5a5a5a5a59f2b, 36, 20, 0x000000000005a59f)
	DEP( 0xa5a5a5a5a5a59f2b, 524287, 36, 20, 0xa5a5a5a5a7ffff2b)
	EXT( 0xa5a5a5a5a5a59f2a, 36, 21, 0x00000000000b4b3e)
	EXTU(0xa5a5a5a5a5a59f2a, 36, 21, 0x00000000000b4b3e)
	DEP( 0xa5a5a5a5a5a59f2a, 1048575, 36, 21, 0xa5a5a5a5a7ffffaa)
	EXT( 0xa5a5a5a5a5a59f29, 36, 22, 0x000000000016967c)
	EXTU(0xa5a5a5a5a5a59f29, 36, 22, 0x000000000016967c)
	DEP( 0xa5a5a5a5a5a59f29, 2097151, 36, 22, 0xa5a5a5a5a7ffffe9)
	EXT( 0xa5a5a5a5a5a59f28, 36, 23, 0x00000000002d2cf9)
	EXTU(0xa5a5a5a5a5a59f28, 36, 23, 0x00000000002d2cf9)
	DEP( 0xa5a5a5a5a5a59f28, 4194303, 36, 23, 0xa5a5a5a5a7ffffe8)
	EXT( 0xa5a5a5a5a5a59f27, 36, 24, 0x00000000005a59f2)
	EXTU(0xa5a5a5a5a5a59f27, 36, 24, 0x00000000005a59f2)
	DEP( 0xa5a5a5a5a5a59f27, 8388607, 36, 24, 0xa5a5a5a5a7fffff7)
	EXT( 0xa5a5a5a5a5a59f26, 36, 25, 0x0000000000b4b3e4)
	EXTU(0xa5a5a5a5a5a59f26, 36, 25, 0x0000000000b4b3e4)
	DEP( 0xa5a5a5a5a5a59f26, 16777215, 36, 25, 0xa5a5a5a5a7fffffe)
	EXT( 0xa5a5a5a5a5a59f25, 36, 26, 0x00000000016967c9)
	EXTU(0xa5a5a5a5a5a59f25, 36, 26, 0x00000000016967c9)
	DEP( 0xa5a5a5a5a5a59f25, 33554431, 36, 26, 0xa5a5a5a5a7fffffd)
	EXT( 0xa5a5a5a5a5a59f24, 36, 27, 0x0000000002d2cf92)
	EXTU(0xa5a5a5a5a5a59f24, 36, 27, 0x0000000002d2cf92)
	DEP( 0xa5a5a5a5a5a59f24, 67108863, 36, 27, 0xa5a5a5a5a7fffffe)
	EXT( 0xa5a5a5a5a5a59f23, 37, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59f23, 37, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f23, 0, 37, 1, 0xa5a5a5a5a1a59f23)
	EXT( 0xa5a5a5a5a5a59f22, 37, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59f22, 37, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59f22, 1, 37, 2, 0xa5a5a5a5a3a59f22)
	EXT( 0xa5a5a5a5a5a59f21, 37, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59f21, 37, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59f21, 3, 37, 3, 0xa5a5a5a5a3a59f21)
	EXT( 0xa5a5a5a5a5a59f20, 37, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59f20, 37, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59f20, 7, 37, 4, 0xa5a5a5a5a3a59f20)
	EXT( 0xa5a5a5a5a5a59f1f, 37, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a59f1f, 37, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59f1f, 15, 37, 5, 0xa5a5a5a5a3e59f1f)
	EXT( 0xa5a5a5a5a5a59f1e, 37, 6, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a59f1e, 37, 6, 0x000000000000002d)
	DEP( 0xa5a5a5a5a5a59f1e, 31, 37, 6, 0xa5a5a5a5a3e59f1e)
	EXT( 0xa5a5a5a5a5a59f1d, 37, 7, 0xffffffffffffffda)
	EXTU(0xa5a5a5a5a5a59f1d, 37, 7, 0x000000000000005a)
	DEP( 0xa5a5a5a5a5a59f1d, 63, 37, 7, 0xa5a5a5a5a3f59f1d)
	EXT( 0xa5a5a5a5a5a59f1c, 37, 8, 0xffffffffffffffb4)
	EXTU(0xa5a5a5a5a5a59f1c, 37, 8, 0x00000000000000b4)
	DEP( 0xa5a5a5a5a5a59f1c, 127, 37, 8, 0xa5a5a5a5a3fd9f1c)
	EXT( 0xa5a5a5a5a5a59f1b, 37, 9, 0xffffffffffffff69)
	EXTU(0xa5a5a5a5a5a59f1b, 37, 9, 0x0000000000000169)
	DEP( 0xa5a5a5a5a5a59f1b, 255, 37, 9, 0xa5a5a5a5a3fd9f1b)
	EXT( 0xa5a5a5a5a5a59f1a, 37, 10, 0xfffffffffffffed2)
	EXTU(0xa5a5a5a5a5a59f1a, 37, 10, 0x00000000000002d2)
	DEP( 0xa5a5a5a5a5a59f1a, 511, 37, 10, 0xa5a5a5a5a3ff9f1a)
	EXT( 0xa5a5a5a5a5a59f19, 37, 11, 0xfffffffffffffda5)
	EXTU(0xa5a5a5a5a5a59f19, 37, 11, 0x00000000000005a5)
	DEP( 0xa5a5a5a5a5a59f19, 1023, 37, 11, 0xa5a5a5a5a3ff9f19)
	EXT( 0xa5a5a5a5a5a59f18, 37, 12, 0xfffffffffffffb4b)
	EXTU(0xa5a5a5a5a5a59f18, 37, 12, 0x0000000000000b4b)
	DEP( 0xa5a5a5a5a5a59f18, 2047, 37, 12, 0xa5a5a5a5a3ff9f18)
	EXT( 0xa5a5a5a5a5a59f17, 37, 13, 0xfffffffffffff696)
	EXTU(0xa5a5a5a5a5a59f17, 37, 13, 0x0000000000001696)
	DEP( 0xa5a5a5a5a5a59f17, 4095, 37, 13, 0xa5a5a5a5a3ffdf17)
	EXT( 0xa5a5a5a5a5a59f16, 37, 14, 0xffffffffffffed2c)
	EXTU(0xa5a5a5a5a5a59f16, 37, 14, 0x0000000000002d2c)
	DEP( 0xa5a5a5a5a5a59f16, 8191, 37, 14, 0xa5a5a5a5a3ffff16)
	EXT( 0xa5a5a5a5a5a59f15, 37, 15, 0xffffffffffffda59)
	EXTU(0xa5a5a5a5a5a59f15, 37, 15, 0x0000000000005a59)
	DEP( 0xa5a5a5a5a5a59f15, 16383, 37, 15, 0xa5a5a5a5a3ffff15)
	EXT( 0xa5a5a5a5a5a59f14, 37, 16, 0xffffffffffffb4b3)
	EXTU(0xa5a5a5a5a5a59f14, 37, 16, 0x000000000000b4b3)
	DEP( 0xa5a5a5a5a5a59f14, 32767, 37, 16, 0xa5a5a5a5a3ffff14)
	EXT( 0xa5a5a5a5a5a59f13, 37, 17, 0xffffffffffff6967)
	EXTU(0xa5a5a5a5a5a59f13, 37, 17, 0x0000000000016967)
	DEP( 0xa5a5a5a5a5a59f13, 65535, 37, 17, 0xa5a5a5a5a3ffff13)
	EXT( 0xa5a5a5a5a5a59f12, 37, 18, 0xfffffffffffed2cf)
	EXTU(0xa5a5a5a5a5a59f12, 37, 18, 0x000000000002d2cf)
	DEP( 0xa5a5a5a5a5a59f12, 131071, 37, 18, 0xa5a5a5a5a3ffff12)
	EXT( 0xa5a5a5a5a5a59f11, 37, 19, 0xfffffffffffda59f)
	EXTU(0xa5a5a5a5a5a59f11, 37, 19, 0x000000000005a59f)
	DEP( 0xa5a5a5a5a5a59f11, 262143, 37, 19, 0xa5a5a5a5a3ffff11)
	EXT( 0xa5a5a5a5a5a59f10, 37, 20, 0xfffffffffffb4b3e)
	EXTU(0xa5a5a5a5a5a59f10, 37, 20, 0x00000000000b4b3e)
	DEP( 0xa5a5a5a5a5a59f10, 524287, 37, 20, 0xa5a5a5a5a3ffff90)
	EXT( 0xa5a5a5a5a5a59f0f, 37, 21, 0xfffffffffff6967c)
	EXTU(0xa5a5a5a5a5a59f0f, 37, 21, 0x000000000016967c)
	DEP( 0xa5a5a5a5a5a59f0f, 1048575, 37, 21, 0xa5a5a5a5a3ffffcf)
	EXT( 0xa5a5a5a5a5a59f0e, 37, 22, 0xffffffffffed2cf8)
	EXTU(0xa5a5a5a5a5a59f0e, 37, 22, 0x00000000002d2cf8)
	DEP( 0xa5a5a5a5a5a59f0e, 2097151, 37, 22, 0xa5a5a5a5a3ffffee)
	EXT( 0xa5a5a5a5a5a59f0d, 37, 23, 0xffffffffffda59f0)
	EXTU(0xa5a5a5a5a5a59f0d, 37, 23, 0x00000000005a59f0)
	DEP( 0xa5a5a5a5a5a59f0d, 4194303, 37, 23, 0xa5a5a5a5a3fffffd)
	EXT( 0xa5a5a5a5a5a59f0c, 37, 24, 0xffffffffffb4b3e1)
	EXTU(0xa5a5a5a5a5a59f0c, 37, 24, 0x0000000000b4b3e1)
	DEP( 0xa5a5a5a5a5a59f0c, 8388607, 37, 24, 0xa5a5a5a5a3fffffc)
	EXT( 0xa5a5a5a5a5a59f0b, 37, 25, 0xffffffffff6967c2)
	EXTU(0xa5a5a5a5a5a59f0b, 37, 25, 0x00000000016967c2)
	DEP( 0xa5a5a5a5a5a59f0b, 16777215, 37, 25, 0xa5a5a5a5a3ffffff)
	EXT( 0xa5a5a5a5a5a59f0a, 37, 26, 0xfffffffffed2cf85)
	EXTU(0xa5a5a5a5a5a59f0a, 37, 26, 0x0000000002d2cf85)
	DEP( 0xa5a5a5a5a5a59f0a, 33554431, 37, 26, 0xa5a5a5a5a3fffffe)
	EXT( 0xa5a5a5a5a5a59f09, 38, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59f09, 38, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59f09, 0, 38, 1, 0xa5a5a5a5a5a59f09)
	EXT( 0xa5a5a5a5a5a59f08, 38, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59f08, 38, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59f08, 1, 38, 2, 0xa5a5a5a5a5a59f08)
	EXT( 0xa5a5a5a5a5a59f07, 38, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59f07, 38, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59f07, 3, 38, 3, 0xa5a5a5a5a5a59f07)
	EXT( 0xa5a5a5a5a5a59f06, 38, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a59f06, 38, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59f06, 7, 38, 4, 0xa5a5a5a5a5e59f06)
	EXT( 0xa5a5a5a5a5a59f05, 38, 5, 0x000000000000000d)
	EXTU(0xa5a5a5a5a5a59f05, 38, 5, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59f05, 15, 38, 5, 0xa5a5a5a5a5e59f05)
	EXT( 0xa5a5a5a5a5a59f04, 38, 6, 0x000000000000001a)
	EXTU(0xa5a5a5a5a5a59f04, 38, 6, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59f04, 31, 38, 6, 0xa5a5a5a5a5f59f04)
	EXT( 0xa5a5a5a5a5a59f03, 38, 7, 0x0000000000000034)
	EXTU(0xa5a5a5a5a5a59f03, 38, 7, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59f03, 63, 38, 7, 0xa5a5a5a5a5fd9f03)
	EXT( 0xa5a5a5a5a5a59f02, 38, 8, 0x0000000000000069)
	EXTU(0xa5a5a5a5a5a59f02, 38, 8, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59f02, 127, 38, 8, 0xa5a5a5a5a5fd9f02)
	EXT( 0xa5a5a5a5a5a59f01, 38, 9, 0x00000000000000d2)
	EXTU(0xa5a5a5a5a5a59f01, 38, 9, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59f01, 255, 38, 9, 0xa5a5a5a5a5ff9f01)
	EXT( 0xa5a5a5a5a5a59f00, 38, 10, 0x00000000000001a5)
	EXTU(0xa5a5a5a5a5a59f00, 38, 10, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59f00, 511, 38, 10, 0xa5a5a5a5a5ff9f00)
	EXT( 0xa5a5a5a5a5a59eff, 38, 11, 0x000000000000034b)
	EXTU(0xa5a5a5a5a5a59eff, 38, 11, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59eff, 1023, 38, 11, 0xa5a5a5a5a5ff9eff)
	EXT( 0xa5a5a5a5a5a59efe, 38, 12, 0x0000000000000696)
	EXTU(0xa5a5a5a5a5a59efe, 38, 12, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59efe, 2047, 38, 12, 0xa5a5a5a5a5ffdefe)
	EXT( 0xa5a5a5a5a5a59efd, 38, 13, 0x0000000000000d2c)
	EXTU(0xa5a5a5a5a5a59efd, 38, 13, 0x0000000000000d2c)
	DEP( 0xa5a5a5a5a5a59efd, 4095, 38, 13, 0xa5a5a5a5a5fffefd)
	EXT( 0xa5a5a5a5a5a59efc, 38, 14, 0x0000000000001a59)
	EXTU(0xa5a5a5a5a5a59efc, 38, 14, 0x0000000000001a59)
	DEP( 0xa5a5a5a5a5a59efc, 8191, 38, 14, 0xa5a5a5a5a5fffefc)
	EXT( 0xa5a5a5a5a5a59efb, 38, 15, 0x00000000000034b3)
	EXTU(0xa5a5a5a5a5a59efb, 38, 15, 0x00000000000034b3)
	DEP( 0xa5a5a5a5a5a59efb, 16383, 38, 15, 0xa5a5a5a5a5fffefb)
	EXT( 0xa5a5a5a5a5a59efa, 38, 16, 0x0000000000006967)
	EXTU(0xa5a5a5a5a5a59efa, 38, 16, 0x0000000000006967)
	DEP( 0xa5a5a5a5a5a59efa, 32767, 38, 16, 0xa5a5a5a5a5fffefa)
	EXT( 0xa5a5a5a5a5a59ef9, 38, 17, 0x000000000000d2cf)
	EXTU(0xa5a5a5a5a5a59ef9, 38, 17, 0x000000000000d2cf)
	DEP( 0xa5a5a5a5a5a59ef9, 65535, 38, 17, 0xa5a5a5a5a5fffef9)
	EXT( 0xa5a5a5a5a5a59ef8, 38, 18, 0x000000000001a59e)
	EXTU(0xa5a5a5a5a5a59ef8, 38, 18, 0x000000000001a59e)
	DEP( 0xa5a5a5a5a5a59ef8, 131071, 38, 18, 0xa5a5a5a5a5fffff8)
	EXT( 0xa5a5a5a5a5a59ef7, 38, 19, 0x0000000000034b3d)
	EXTU(0xa5a5a5a5a5a59ef7, 38, 19, 0x0000000000034b3d)
	DEP( 0xa5a5a5a5a5a59ef7, 262143, 38, 19, 0xa5a5a5a5a5fffff7)
	EXT( 0xa5a5a5a5a5a59ef6, 38, 20, 0x000000000006967b)
	EXTU(0xa5a5a5a5a5a59ef6, 38, 20, 0x000000000006967b)
	DEP( 0xa5a5a5a5a5a59ef6, 524287, 38, 20, 0xa5a5a5a5a5fffff6)
	EXT( 0xa5a5a5a5a5a59ef5, 38, 21, 0x00000000000d2cf7)
	EXTU(0xa5a5a5a5a5a59ef5, 38, 21, 0x00000000000d2cf7)
	DEP( 0xa5a5a5a5a5a59ef5, 1048575, 38, 21, 0xa5a5a5a5a5fffff5)
	EXT( 0xa5a5a5a5a5a59ef4, 38, 22, 0x00000000001a59ef)
	EXTU(0xa5a5a5a5a5a59ef4, 38, 22, 0x00000000001a59ef)
	DEP( 0xa5a5a5a5a5a59ef4, 2097151, 38, 22, 0xa5a5a5a5a5fffff4)
	EXT( 0xa5a5a5a5a5a59ef3, 38, 23, 0x000000000034b3de)
	EXTU(0xa5a5a5a5a5a59ef3, 38, 23, 0x000000000034b3de)
	DEP( 0xa5a5a5a5a5a59ef3, 4194303, 38, 23, 0xa5a5a5a5a5fffffb)
	EXT( 0xa5a5a5a5a5a59ef2, 38, 24, 0x00000000006967bc)
	EXTU(0xa5a5a5a5a5a59ef2, 38, 24, 0x00000000006967bc)
	DEP( 0xa5a5a5a5a5a59ef2, 8388607, 38, 24, 0xa5a5a5a5a5fffffe)
	EXT( 0xa5a5a5a5a5a59ef1, 38, 25, 0x0000000000d2cf78)
	EXTU(0xa5a5a5a5a5a59ef1, 38, 25, 0x0000000000d2cf78)
	DEP( 0xa5a5a5a5a5a59ef1, 16777215, 38, 25, 0xa5a5a5a5a5ffffff)
	EXT( 0xa5a5a5a5a5a59ef0, 39, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59ef0, 39, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ef0, 0, 39, 1, 0xa5a5a5a5a4a59ef0)
	EXT( 0xa5a5a5a5a5a59eef, 39, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59eef, 39, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59eef, 1, 39, 2, 0xa5a5a5a5a4a59eef)
	EXT( 0xa5a5a5a5a5a59eee, 39, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59eee, 39, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59eee, 3, 39, 3, 0xa5a5a5a5a4e59eee)
	EXT( 0xa5a5a5a5a5a59eed, 39, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59eed, 39, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59eed, 7, 39, 4, 0xa5a5a5a5a4e59eed)
	EXT( 0xa5a5a5a5a5a59eec, 39, 5, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59eec, 39, 5, 0x000000000000001a)
	DEP( 0xa5a5a5a5a5a59eec, 15, 39, 5, 0xa5a5a5a5a4f59eec)
	EXT( 0xa5a5a5a5a5a59eeb, 39, 6, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59eeb, 39, 6, 0x0000000000000034)
	DEP( 0xa5a5a5a5a5a59eeb, 31, 39, 6, 0xa5a5a5a5a4fd9eeb)
	EXT( 0xa5a5a5a5a5a59eea, 39, 7, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59eea, 39, 7, 0x0000000000000069)
	DEP( 0xa5a5a5a5a5a59eea, 63, 39, 7, 0xa5a5a5a5a4fd9eea)
	EXT( 0xa5a5a5a5a5a59ee9, 39, 8, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59ee9, 39, 8, 0x00000000000000d2)
	DEP( 0xa5a5a5a5a5a59ee9, 127, 39, 8, 0xa5a5a5a5a4ff9ee9)
	EXT( 0xa5a5a5a5a5a59ee8, 39, 9, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59ee8, 39, 9, 0x00000000000001a5)
	DEP( 0xa5a5a5a5a5a59ee8, 255, 39, 9, 0xa5a5a5a5a4ff9ee8)
	EXT( 0xa5a5a5a5a5a59ee7, 39, 10, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59ee7, 39, 10, 0x000000000000034b)
	DEP( 0xa5a5a5a5a5a59ee7, 511, 39, 10, 0xa5a5a5a5a4ff9ee7)
	EXT( 0xa5a5a5a5a5a59ee6, 39, 11, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59ee6, 39, 11, 0x0000000000000696)
	DEP( 0xa5a5a5a5a5a59ee6, 1023, 39, 11, 0xa5a5a5a5a4ffdee6)
	EXT( 0xa5a5a5a5a5a59ee5, 39, 12, 0xfffffffffffffd2c)
	EXTU(0xa5a5a5a5a5a59ee5, 39, 12, 0x0000000000000d2c)
	DEP( 0xa5a5a5a5a5a59ee5, 2047, 39, 12, 0xa5a5a5a5a4fffee5)
	EXT( 0xa5a5a5a5a5a59ee4, 39, 13, 0xfffffffffffffa59)
	EXTU(0xa5a5a5a5a5a59ee4, 39, 13, 0x0000000000001a59)
	DEP( 0xa5a5a5a5a5a59ee4, 4095, 39, 13, 0xa5a5a5a5a4fffee4)
	EXT( 0xa5a5a5a5a5a59ee3, 39, 14, 0xfffffffffffff4b3)
	EXTU(0xa5a5a5a5a5a59ee3, 39, 14, 0x00000000000034b3)
	DEP( 0xa5a5a5a5a5a59ee3, 8191, 39, 14, 0xa5a5a5a5a4fffee3)
	EXT( 0xa5a5a5a5a5a59ee2, 39, 15, 0xffffffffffffe967)
	EXTU(0xa5a5a5a5a5a59ee2, 39, 15, 0x0000000000006967)
	DEP( 0xa5a5a5a5a5a59ee2, 16383, 39, 15, 0xa5a5a5a5a4fffee2)
	EXT( 0xa5a5a5a5a5a59ee1, 39, 16, 0xffffffffffffd2cf)
	EXTU(0xa5a5a5a5a5a59ee1, 39, 16, 0x000000000000d2cf)
	DEP( 0xa5a5a5a5a5a59ee1, 32767, 39, 16, 0xa5a5a5a5a4fffee1)
	EXT( 0xa5a5a5a5a5a59ee0, 39, 17, 0xffffffffffffa59e)
	EXTU(0xa5a5a5a5a5a59ee0, 39, 17, 0x000000000001a59e)
	DEP( 0xa5a5a5a5a5a59ee0, 65535, 39, 17, 0xa5a5a5a5a4ffffe0)
	EXT( 0xa5a5a5a5a5a59edf, 39, 18, 0xffffffffffff4b3d)
	EXTU(0xa5a5a5a5a5a59edf, 39, 18, 0x0000000000034b3d)
	DEP( 0xa5a5a5a5a5a59edf, 131071, 39, 18, 0xa5a5a5a5a4ffffdf)
	EXT( 0xa5a5a5a5a5a59ede, 39, 19, 0xfffffffffffe967b)
	EXTU(0xa5a5a5a5a5a59ede, 39, 19, 0x000000000006967b)
	DEP( 0xa5a5a5a5a5a59ede, 262143, 39, 19, 0xa5a5a5a5a4ffffde)
	EXT( 0xa5a5a5a5a5a59edd, 39, 20, 0xfffffffffffd2cf6)
	EXTU(0xa5a5a5a5a5a59edd, 39, 20, 0x00000000000d2cf6)
	DEP( 0xa5a5a5a5a5a59edd, 524287, 39, 20, 0xa5a5a5a5a4fffffd)
	EXT( 0xa5a5a5a5a5a59edc, 39, 21, 0xfffffffffffa59ed)
	EXTU(0xa5a5a5a5a5a59edc, 39, 21, 0x00000000001a59ed)
	DEP( 0xa5a5a5a5a5a59edc, 1048575, 39, 21, 0xa5a5a5a5a4fffffc)
	EXT( 0xa5a5a5a5a5a59edb, 39, 22, 0xfffffffffff4b3db)
	EXTU(0xa5a5a5a5a5a59edb, 39, 22, 0x000000000034b3db)
	DEP( 0xa5a5a5a5a5a59edb, 2097151, 39, 22, 0xa5a5a5a5a4fffffb)
	EXT( 0xa5a5a5a5a5a59eda, 39, 23, 0xffffffffffe967b6)
	EXTU(0xa5a5a5a5a5a59eda, 39, 23, 0x00000000006967b6)
	DEP( 0xa5a5a5a5a5a59eda, 4194303, 39, 23, 0xa5a5a5a5a4fffffe)
	EXT( 0xa5a5a5a5a5a59ed9, 39, 24, 0xffffffffffd2cf6c)
	EXTU(0xa5a5a5a5a5a59ed9, 39, 24, 0x0000000000d2cf6c)
	DEP( 0xa5a5a5a5a5a59ed9, 8388607, 39, 24, 0xa5a5a5a5a4ffffff)
	EXT( 0xa5a5a5a5a5a59ed8, 40, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59ed8, 40, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ed8, 0, 40, 1, 0xa5a5a5a5a5259ed8)
	EXT( 0xa5a5a5a5a5a59ed7, 40, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59ed7, 40, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59ed7, 1, 40, 2, 0xa5a5a5a5a5659ed7)
	EXT( 0xa5a5a5a5a5a59ed6, 40, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59ed6, 40, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59ed6, 3, 40, 3, 0xa5a5a5a5a5659ed6)
	EXT( 0xa5a5a5a5a5a59ed5, 40, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59ed5, 40, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a59ed5, 7, 40, 4, 0xa5a5a5a5a5759ed5)
	EXT( 0xa5a5a5a5a5a59ed4, 40, 5, 0xfffffffffffffff4)
	EXTU(0xa5a5a5a5a5a59ed4, 40, 5, 0x0000000000000014)
	DEP( 0xa5a5a5a5a5a59ed4, 15, 40, 5, 0xa5a5a5a5a57d9ed4)
	EXT( 0xa5a5a5a5a5a59ed3, 40, 6, 0xffffffffffffffe9)
	EXTU(0xa5a5a5a5a5a59ed3, 40, 6, 0x0000000000000029)
	DEP( 0xa5a5a5a5a5a59ed3, 31, 40, 6, 0xa5a5a5a5a57d9ed3)
	EXT( 0xa5a5a5a5a5a59ed2, 40, 7, 0xffffffffffffffd2)
	EXTU(0xa5a5a5a5a5a59ed2, 40, 7, 0x0000000000000052)
	DEP( 0xa5a5a5a5a5a59ed2, 63, 40, 7, 0xa5a5a5a5a57f9ed2)
	EXT( 0xa5a5a5a5a5a59ed1, 40, 8, 0xffffffffffffffa5)
	EXTU(0xa5a5a5a5a5a59ed1, 40, 8, 0x00000000000000a5)
	DEP( 0xa5a5a5a5a5a59ed1, 127, 40, 8, 0xa5a5a5a5a57f9ed1)
	EXT( 0xa5a5a5a5a5a59ed0, 40, 9, 0xffffffffffffff4b)
	EXTU(0xa5a5a5a5a5a59ed0, 40, 9, 0x000000000000014b)
	DEP( 0xa5a5a5a5a5a59ed0, 255, 40, 9, 0xa5a5a5a5a57f9ed0)
	EXT( 0xa5a5a5a5a5a59ecf, 40, 10, 0xfffffffffffffe96)
	EXTU(0xa5a5a5a5a5a59ecf, 40, 10, 0x0000000000000296)
	DEP( 0xa5a5a5a5a5a59ecf, 511, 40, 10, 0xa5a5a5a5a57fdecf)
	EXT( 0xa5a5a5a5a5a59ece, 40, 11, 0xfffffffffffffd2c)
	EXTU(0xa5a5a5a5a5a59ece, 40, 11, 0x000000000000052c)
	DEP( 0xa5a5a5a5a5a59ece, 1023, 40, 11, 0xa5a5a5a5a57ffece)
	EXT( 0xa5a5a5a5a5a59ecd, 40, 12, 0xfffffffffffffa59)
	EXTU(0xa5a5a5a5a5a59ecd, 40, 12, 0x0000000000000a59)
	DEP( 0xa5a5a5a5a5a59ecd, 2047, 40, 12, 0xa5a5a5a5a57ffecd)
	EXT( 0xa5a5a5a5a5a59ecc, 40, 13, 0xfffffffffffff4b3)
	EXTU(0xa5a5a5a5a5a59ecc, 40, 13, 0x00000000000014b3)
	DEP( 0xa5a5a5a5a5a59ecc, 4095, 40, 13, 0xa5a5a5a5a57ffecc)
	EXT( 0xa5a5a5a5a5a59ecb, 40, 14, 0xffffffffffffe967)
	EXTU(0xa5a5a5a5a5a59ecb, 40, 14, 0x0000000000002967)
	DEP( 0xa5a5a5a5a5a59ecb, 8191, 40, 14, 0xa5a5a5a5a57ffecb)
	EXT( 0xa5a5a5a5a5a59eca, 40, 15, 0xffffffffffffd2cf)
	EXTU(0xa5a5a5a5a5a59eca, 40, 15, 0x00000000000052cf)
	DEP( 0xa5a5a5a5a5a59eca, 16383, 40, 15, 0xa5a5a5a5a57ffeca)
	EXT( 0xa5a5a5a5a5a59ec9, 40, 16, 0xffffffffffffa59e)
	EXTU(0xa5a5a5a5a5a59ec9, 40, 16, 0x000000000000a59e)
	DEP( 0xa5a5a5a5a5a59ec9, 32767, 40, 16, 0xa5a5a5a5a57fffc9)
	EXT( 0xa5a5a5a5a5a59ec8, 40, 17, 0xffffffffffff4b3d)
	EXTU(0xa5a5a5a5a5a59ec8, 40, 17, 0x0000000000014b3d)
	DEP( 0xa5a5a5a5a5a59ec8, 65535, 40, 17, 0xa5a5a5a5a57fffc8)
	EXT( 0xa5a5a5a5a5a59ec7, 40, 18, 0xfffffffffffe967b)
	EXTU(0xa5a5a5a5a5a59ec7, 40, 18, 0x000000000002967b)
	DEP( 0xa5a5a5a5a5a59ec7, 131071, 40, 18, 0xa5a5a5a5a57fffc7)
	EXT( 0xa5a5a5a5a5a59ec6, 40, 19, 0xfffffffffffd2cf6)
	EXTU(0xa5a5a5a5a5a59ec6, 40, 19, 0x0000000000052cf6)
	DEP( 0xa5a5a5a5a5a59ec6, 262143, 40, 19, 0xa5a5a5a5a57fffe6)
	EXT( 0xa5a5a5a5a5a59ec5, 40, 20, 0xfffffffffffa59ec)
	EXTU(0xa5a5a5a5a5a59ec5, 40, 20, 0x00000000000a59ec)
	DEP( 0xa5a5a5a5a5a59ec5, 524287, 40, 20, 0xa5a5a5a5a57ffff5)
	EXT( 0xa5a5a5a5a5a59ec4, 40, 21, 0xfffffffffff4b3d8)
	EXTU(0xa5a5a5a5a5a59ec4, 40, 21, 0x000000000014b3d8)
	DEP( 0xa5a5a5a5a5a59ec4, 1048575, 40, 21, 0xa5a5a5a5a57ffffc)
	EXT( 0xa5a5a5a5a5a59ec3, 40, 22, 0xffffffffffe967b0)
	EXTU(0xa5a5a5a5a5a59ec3, 40, 22, 0x00000000002967b0)
	DEP( 0xa5a5a5a5a5a59ec3, 2097151, 40, 22, 0xa5a5a5a5a57fffff)
	EXT( 0xa5a5a5a5a5a59ec2, 40, 23, 0xffffffffffd2cf61)
	EXTU(0xa5a5a5a5a5a59ec2, 40, 23, 0x000000000052cf61)
	DEP( 0xa5a5a5a5a5a59ec2, 4194303, 40, 23, 0xa5a5a5a5a57ffffe)
	EXT( 0xa5a5a5a5a5a59ec1, 41, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59ec1, 41, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59ec1, 0, 41, 1, 0xa5a5a5a5a5a59ec1)
	EXT( 0xa5a5a5a5a5a59ec0, 41, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59ec0, 41, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59ec0, 1, 41, 2, 0xa5a5a5a5a5a59ec0)
	EXT( 0xa5a5a5a5a5a59ebf, 41, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59ebf, 41, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59ebf, 3, 41, 3, 0xa5a5a5a5a5b59ebf)
	EXT( 0xa5a5a5a5a5a59ebe, 41, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a59ebe, 41, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59ebe, 7, 41, 4, 0xa5a5a5a5a5bd9ebe)
	EXT( 0xa5a5a5a5a5a59ebd, 41, 5, 0x0000000000000009)
	EXTU(0xa5a5a5a5a5a59ebd, 41, 5, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59ebd, 15, 41, 5, 0xa5a5a5a5a5bd9ebd)
	EXT( 0xa5a5a5a5a5a59ebc, 41, 6, 0x0000000000000012)
	EXTU(0xa5a5a5a5a5a59ebc, 41, 6, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59ebc, 31, 41, 6, 0xa5a5a5a5a5bf9ebc)
	EXT( 0xa5a5a5a5a5a59ebb, 41, 7, 0x0000000000000025)
	EXTU(0xa5a5a5a5a5a59ebb, 41, 7, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59ebb, 63, 41, 7, 0xa5a5a5a5a5bf9ebb)
	EXT( 0xa5a5a5a5a5a59eba, 41, 8, 0x000000000000004b)
	EXTU(0xa5a5a5a5a5a59eba, 41, 8, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59eba, 127, 41, 8, 0xa5a5a5a5a5bf9eba)
	EXT( 0xa5a5a5a5a5a59eb9, 41, 9, 0x0000000000000096)
	EXTU(0xa5a5a5a5a5a59eb9, 41, 9, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59eb9, 255, 41, 9, 0xa5a5a5a5a5bfdeb9)
	EXT( 0xa5a5a5a5a5a59eb8, 41, 10, 0x000000000000012c)
	EXTU(0xa5a5a5a5a5a59eb8, 41, 10, 0x000000000000012c)
	DEP( 0xa5a5a5a5a5a59eb8, 511, 41, 10, 0xa5a5a5a5a5bffeb8)
	EXT( 0xa5a5a5a5a5a59eb7, 41, 11, 0x0000000000000259)
	EXTU(0xa5a5a5a5a5a59eb7, 41, 11, 0x0000000000000259)
	DEP( 0xa5a5a5a5a5a59eb7, 1023, 41, 11, 0xa5a5a5a5a5bffeb7)
	EXT( 0xa5a5a5a5a5a59eb6, 41, 12, 0x00000000000004b3)
	EXTU(0xa5a5a5a5a5a59eb6, 41, 12, 0x00000000000004b3)
	DEP( 0xa5a5a5a5a5a59eb6, 2047, 41, 12, 0xa5a5a5a5a5bffeb6)
	EXT( 0xa5a5a5a5a5a59eb5, 41, 13, 0x0000000000000967)
	EXTU(0xa5a5a5a5a5a59eb5, 41, 13, 0x0000000000000967)
	DEP( 0xa5a5a5a5a5a59eb5, 4095, 41, 13, 0xa5a5a5a5a5bffeb5)
	EXT( 0xa5a5a5a5a5a59eb4, 41, 14, 0x00000000000012cf)
	EXTU(0xa5a5a5a5a5a59eb4, 41, 14, 0x00000000000012cf)
	DEP( 0xa5a5a5a5a5a59eb4, 8191, 41, 14, 0xa5a5a5a5a5bffeb4)
	EXT( 0xa5a5a5a5a5a59eb3, 41, 15, 0x000000000000259e)
	EXTU(0xa5a5a5a5a5a59eb3, 41, 15, 0x000000000000259e)
	DEP( 0xa5a5a5a5a5a59eb3, 16383, 41, 15, 0xa5a5a5a5a5bfffb3)
	EXT( 0xa5a5a5a5a5a59eb2, 41, 16, 0x0000000000004b3d)
	EXTU(0xa5a5a5a5a5a59eb2, 41, 16, 0x0000000000004b3d)
	DEP( 0xa5a5a5a5a5a59eb2, 32767, 41, 16, 0xa5a5a5a5a5bfffb2)
	EXT( 0xa5a5a5a5a5a59eb1, 41, 17, 0x000000000000967a)
	EXTU(0xa5a5a5a5a5a59eb1, 41, 17, 0x000000000000967a)
	DEP( 0xa5a5a5a5a5a59eb1, 65535, 41, 17, 0xa5a5a5a5a5bffff1)
	EXT( 0xa5a5a5a5a5a59eb0, 41, 18, 0x0000000000012cf5)
	EXTU(0xa5a5a5a5a5a59eb0, 41, 18, 0x0000000000012cf5)
	DEP( 0xa5a5a5a5a5a59eb0, 131071, 41, 18, 0xa5a5a5a5a5bffff0)
	EXT( 0xa5a5a5a5a5a59eaf, 41, 19, 0x00000000000259ea)
	EXTU(0xa5a5a5a5a5a59eaf, 41, 19, 0x00000000000259ea)
	DEP( 0xa5a5a5a5a5a59eaf, 262143, 41, 19, 0xa5a5a5a5a5bfffff)
	EXT( 0xa5a5a5a5a5a59eae, 41, 20, 0x000000000004b3d5)
	EXTU(0xa5a5a5a5a5a59eae, 41, 20, 0x000000000004b3d5)
	DEP( 0xa5a5a5a5a5a59eae, 524287, 41, 20, 0xa5a5a5a5a5bffffe)
	EXT( 0xa5a5a5a5a5a59ead, 41, 21, 0x00000000000967ab)
	EXTU(0xa5a5a5a5a5a59ead, 41, 21, 0x00000000000967ab)
	DEP( 0xa5a5a5a5a5a59ead, 1048575, 41, 21, 0xa5a5a5a5a5bffffd)
	EXT( 0xa5a5a5a5a5a59eac, 41, 22, 0x000000000012cf56)
	EXTU(0xa5a5a5a5a5a59eac, 41, 22, 0x000000000012cf56)
	DEP( 0xa5a5a5a5a5a59eac, 2097151, 41, 22, 0xa5a5a5a5a5bffffe)
	EXT( 0xa5a5a5a5a5a59eab, 42, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59eab, 42, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59eab, 0, 42, 1, 0xa5a5a5a5a5859eab)
	EXT( 0xa5a5a5a5a5a59eaa, 42, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59eaa, 42, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59eaa, 1, 42, 2, 0xa5a5a5a5a5959eaa)
	EXT( 0xa5a5a5a5a5a59ea9, 42, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59ea9, 42, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59ea9, 3, 42, 3, 0xa5a5a5a5a59d9ea9)
	EXT( 0xa5a5a5a5a5a59ea8, 42, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59ea8, 42, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59ea8, 7, 42, 4, 0xa5a5a5a5a59d9ea8)
	EXT( 0xa5a5a5a5a5a59ea7, 42, 5, 0xfffffffffffffff2)
	EXTU(0xa5a5a5a5a5a59ea7, 42, 5, 0x0000000000000012)
	DEP( 0xa5a5a5a5a5a59ea7, 15, 42, 5, 0xa5a5a5a5a59f9ea7)
	EXT( 0xa5a5a5a5a5a59ea6, 42, 6, 0xffffffffffffffe5)
	EXTU(0xa5a5a5a5a5a59ea6, 42, 6, 0x0000000000000025)
	DEP( 0xa5a5a5a5a5a59ea6, 31, 42, 6, 0xa5a5a5a5a59f9ea6)
	EXT( 0xa5a5a5a5a5a59ea5, 42, 7, 0xffffffffffffffcb)
	EXTU(0xa5a5a5a5a5a59ea5, 42, 7, 0x000000000000004b)
	DEP( 0xa5a5a5a5a5a59ea5, 63, 42, 7, 0xa5a5a5a5a59f9ea5)
	EXT( 0xa5a5a5a5a5a59ea4, 42, 8, 0xffffffffffffff96)
	EXTU(0xa5a5a5a5a5a59ea4, 42, 8, 0x0000000000000096)
	DEP( 0xa5a5a5a5a5a59ea4, 127, 42, 8, 0xa5a5a5a5a59fdea4)
	EXT( 0xa5a5a5a5a5a59ea3, 42, 9, 0xffffffffffffff2c)
	EXTU(0xa5a5a5a5a5a59ea3, 42, 9, 0x000000000000012c)
	DEP( 0xa5a5a5a5a5a59ea3, 255, 42, 9, 0xa5a5a5a5a59ffea3)
	EXT( 0xa5a5a5a5a5a59ea2, 42, 10, 0xfffffffffffffe59)
	EXTU(0xa5a5a5a5a5a59ea2, 42, 10, 0x0000000000000259)
	DEP( 0xa5a5a5a5a5a59ea2, 511, 42, 10, 0xa5a5a5a5a59ffea2)
	EXT( 0xa5a5a5a5a5a59ea1, 42, 11, 0xfffffffffffffcb3)
	EXTU(0xa5a5a5a5a5a59ea1, 42, 11, 0x00000000000004b3)
	DEP( 0xa5a5a5a5a5a59ea1, 1023, 42, 11, 0xa5a5a5a5a59ffea1)
	EXT( 0xa5a5a5a5a5a59ea0, 42, 12, 0xfffffffffffff967)
	EXTU(0xa5a5a5a5a5a59ea0, 42, 12, 0x0000000000000967)
	DEP( 0xa5a5a5a5a5a59ea0, 2047, 42, 12, 0xa5a5a5a5a59ffea0)
	EXT( 0xa5a5a5a5a5a59e9f, 42, 13, 0xfffffffffffff2cf)
	EXTU(0xa5a5a5a5a5a59e9f, 42, 13, 0x00000000000012cf)
	DEP( 0xa5a5a5a5a5a59e9f, 4095, 42, 13, 0xa5a5a5a5a59ffe9f)
	EXT( 0xa5a5a5a5a5a59e9e, 42, 14, 0xffffffffffffe59e)
	EXTU(0xa5a5a5a5a5a59e9e, 42, 14, 0x000000000000259e)
	DEP( 0xa5a5a5a5a5a59e9e, 8191, 42, 14, 0xa5a5a5a5a59fff9e)
	EXT( 0xa5a5a5a5a5a59e9d, 42, 15, 0xffffffffffffcb3d)
	EXTU(0xa5a5a5a5a5a59e9d, 42, 15, 0x0000000000004b3d)
	DEP( 0xa5a5a5a5a5a59e9d, 16383, 42, 15, 0xa5a5a5a5a59fff9d)
	EXT( 0xa5a5a5a5a5a59e9c, 42, 16, 0xffffffffffff967a)
	EXTU(0xa5a5a5a5a5a59e9c, 42, 16, 0x000000000000967a)
	DEP( 0xa5a5a5a5a5a59e9c, 32767, 42, 16, 0xa5a5a5a5a59fffdc)
	EXT( 0xa5a5a5a5a5a59e9b, 42, 17, 0xffffffffffff2cf4)
	EXTU(0xa5a5a5a5a5a59e9b, 42, 17, 0x0000000000012cf4)
	DEP( 0xa5a5a5a5a5a59e9b, 65535, 42, 17, 0xa5a5a5a5a59ffffb)
	EXT( 0xa5a5a5a5a5a59e9a, 42, 18, 0xfffffffffffe59e9)
	EXTU(0xa5a5a5a5a5a59e9a, 42, 18, 0x00000000000259e9)
	DEP( 0xa5a5a5a5a5a59e9a, 131071, 42, 18, 0xa5a5a5a5a59ffffa)
	EXT( 0xa5a5a5a5a5a59e99, 42, 19, 0xfffffffffffcb3d3)
	EXTU(0xa5a5a5a5a5a59e99, 42, 19, 0x000000000004b3d3)
	DEP( 0xa5a5a5a5a5a59e99, 262143, 42, 19, 0xa5a5a5a5a59ffff9)
	EXT( 0xa5a5a5a5a5a59e98, 42, 20, 0xfffffffffff967a6)
	EXTU(0xa5a5a5a5a5a59e98, 42, 20, 0x00000000000967a6)
	DEP( 0xa5a5a5a5a5a59e98, 524287, 42, 20, 0xa5a5a5a5a59ffffc)
	EXT( 0xa5a5a5a5a5a59e97, 42, 21, 0xfffffffffff2cf4b)
	EXTU(0xa5a5a5a5a5a59e97, 42, 21, 0x000000000012cf4b)
	DEP( 0xa5a5a5a5a5a59e97, 1048575, 42, 21, 0xa5a5a5a5a59fffff)
	EXT( 0xa5a5a5a5a5a59e96, 43, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e96, 43, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e96, 0, 43, 1, 0xa5a5a5a5a5a59e96)
	EXT( 0xa5a5a5a5a5a59e95, 43, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e95, 43, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e95, 1, 43, 2, 0xa5a5a5a5a5ad9e95)
	EXT( 0xa5a5a5a5a5a59e94, 43, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e94, 43, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e94, 3, 43, 3, 0xa5a5a5a5a5ad9e94)
	EXT( 0xa5a5a5a5a5a59e93, 43, 4, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59e93, 43, 4, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e93, 7, 43, 4, 0xa5a5a5a5a5af9e93)
	EXT( 0xa5a5a5a5a5a59e92, 43, 5, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59e92, 43, 5, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59e92, 15, 43, 5, 0xa5a5a5a5a5af9e92)
	EXT( 0xa5a5a5a5a5a59e91, 43, 6, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59e91, 43, 6, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59e91, 31, 43, 6, 0xa5a5a5a5a5af9e91)
	EXT( 0xa5a5a5a5a5a59e90, 43, 7, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59e90, 43, 7, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59e90, 63, 43, 7, 0xa5a5a5a5a5afde90)
	EXT( 0xa5a5a5a5a5a59e8f, 43, 8, 0x000000000000002c)
	EXTU(0xa5a5a5a5a5a59e8f, 43, 8, 0x000000000000002c)
	DEP( 0xa5a5a5a5a5a59e8f, 127, 43, 8, 0xa5a5a5a5a5affe8f)
	EXT( 0xa5a5a5a5a5a59e8e, 43, 9, 0x0000000000000059)
	EXTU(0xa5a5a5a5a5a59e8e, 43, 9, 0x0000000000000059)
	DEP( 0xa5a5a5a5a5a59e8e, 255, 43, 9, 0xa5a5a5a5a5affe8e)
	EXT( 0xa5a5a5a5a5a59e8d, 43, 10, 0x00000000000000b3)
	EXTU(0xa5a5a5a5a5a59e8d, 43, 10, 0x00000000000000b3)
	DEP( 0xa5a5a5a5a5a59e8d, 511, 43, 10, 0xa5a5a5a5a5affe8d)
	EXT( 0xa5a5a5a5a5a59e8c, 43, 11, 0x0000000000000167)
	EXTU(0xa5a5a5a5a5a59e8c, 43, 11, 0x0000000000000167)
	DEP( 0xa5a5a5a5a5a59e8c, 1023, 43, 11, 0xa5a5a5a5a5affe8c)
	EXT( 0xa5a5a5a5a5a59e8b, 43, 12, 0x00000000000002cf)
	EXTU(0xa5a5a5a5a5a59e8b, 43, 12, 0x00000000000002cf)
	DEP( 0xa5a5a5a5a5a59e8b, 2047, 43, 12, 0xa5a5a5a5a5affe8b)
	EXT( 0xa5a5a5a5a5a59e8a, 43, 13, 0x000000000000059e)
	EXTU(0xa5a5a5a5a5a59e8a, 43, 13, 0x000000000000059e)
	DEP( 0xa5a5a5a5a5a59e8a, 4095, 43, 13, 0xa5a5a5a5a5afff8a)
	EXT( 0xa5a5a5a5a5a59e89, 43, 14, 0x0000000000000b3d)
	EXTU(0xa5a5a5a5a5a59e89, 43, 14, 0x0000000000000b3d)
	DEP( 0xa5a5a5a5a5a59e89, 8191, 43, 14, 0xa5a5a5a5a5afff89)
	EXT( 0xa5a5a5a5a5a59e88, 43, 15, 0x000000000000167a)
	EXTU(0xa5a5a5a5a5a59e88, 43, 15, 0x000000000000167a)
	DEP( 0xa5a5a5a5a5a59e88, 16383, 43, 15, 0xa5a5a5a5a5afffc8)
	EXT( 0xa5a5a5a5a5a59e87, 43, 16, 0x0000000000002cf4)
	EXTU(0xa5a5a5a5a5a59e87, 43, 16, 0x0000000000002cf4)
	DEP( 0xa5a5a5a5a5a59e87, 32767, 43, 16, 0xa5a5a5a5a5afffe7)
	EXT( 0xa5a5a5a5a5a59e86, 43, 17, 0x00000000000059e8)
	EXTU(0xa5a5a5a5a5a59e86, 43, 17, 0x00000000000059e8)
	DEP( 0xa5a5a5a5a5a59e86, 65535, 43, 17, 0xa5a5a5a5a5affff6)
	EXT( 0xa5a5a5a5a5a59e85, 43, 18, 0x000000000000b3d0)
	EXTU(0xa5a5a5a5a5a59e85, 43, 18, 0x000000000000b3d0)
	DEP( 0xa5a5a5a5a5a59e85, 131071, 43, 18, 0xa5a5a5a5a5affffd)
	EXT( 0xa5a5a5a5a5a59e84, 43, 19, 0x00000000000167a1)
	EXTU(0xa5a5a5a5a5a59e84, 43, 19, 0x00000000000167a1)
	DEP( 0xa5a5a5a5a5a59e84, 262143, 43, 19, 0xa5a5a5a5a5affffc)
	EXT( 0xa5a5a5a5a5a59e83, 43, 20, 0x000000000002cf41)
	EXTU(0xa5a5a5a5a5a59e83, 43, 20, 0x000000000002cf41)
	DEP( 0xa5a5a5a5a5a59e83, 524287, 43, 20, 0xa5a5a5a5a5afffff)
	EXT( 0xa5a5a5a5a5a59e82, 44, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e82, 44, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e82, 0, 44, 1, 0xa5a5a5a5a5a59e82)
	EXT( 0xa5a5a5a5a5a59e81, 44, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e81, 44, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e81, 1, 44, 2, 0xa5a5a5a5a5a59e81)
	EXT( 0xa5a5a5a5a5a59e80, 44, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59e80, 44, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e80, 3, 44, 3, 0xa5a5a5a5a5a79e80)
	EXT( 0xa5a5a5a5a5a59e7f, 44, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59e7f, 44, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59e7f, 7, 44, 4, 0xa5a5a5a5a5a79e7f)
	EXT( 0xa5a5a5a5a5a59e7e, 44, 5, 0x000000000000000b)
	EXTU(0xa5a5a5a5a5a59e7e, 44, 5, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59e7e, 15, 44, 5, 0xa5a5a5a5a5a79e7e)
	EXT( 0xa5a5a5a5a5a59e7d, 44, 6, 0x0000000000000016)
	EXTU(0xa5a5a5a5a5a59e7d, 44, 6, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59e7d, 31, 44, 6, 0xa5a5a5a5a5a7de7d)
	EXT( 0xa5a5a5a5a5a59e7c, 44, 7, 0x000000000000002c)
	EXTU(0xa5a5a5a5a5a59e7c, 44, 7, 0x000000000000002c)
	DEP( 0xa5a5a5a5a5a59e7c, 63, 44, 7, 0xa5a5a5a5a5a7fe7c)
	EXT( 0xa5a5a5a5a5a59e7b, 44, 8, 0x0000000000000059)
	EXTU(0xa5a5a5a5a5a59e7b, 44, 8, 0x0000000000000059)
	DEP( 0xa5a5a5a5a5a59e7b, 127, 44, 8, 0xa5a5a5a5a5a7fe7b)
	EXT( 0xa5a5a5a5a5a59e7a, 44, 9, 0x00000000000000b3)
	EXTU(0xa5a5a5a5a5a59e7a, 44, 9, 0x00000000000000b3)
	DEP( 0xa5a5a5a5a5a59e7a, 255, 44, 9, 0xa5a5a5a5a5a7fe7a)
	EXT( 0xa5a5a5a5a5a59e79, 44, 10, 0x0000000000000167)
	EXTU(0xa5a5a5a5a5a59e79, 44, 10, 0x0000000000000167)
	DEP( 0xa5a5a5a5a5a59e79, 511, 44, 10, 0xa5a5a5a5a5a7fe79)
	EXT( 0xa5a5a5a5a5a59e78, 44, 11, 0x00000000000002cf)
	EXTU(0xa5a5a5a5a5a59e78, 44, 11, 0x00000000000002cf)
	DEP( 0xa5a5a5a5a5a59e78, 1023, 44, 11, 0xa5a5a5a5a5a7fe78)
	EXT( 0xa5a5a5a5a5a59e77, 44, 12, 0x000000000000059e)
	EXTU(0xa5a5a5a5a5a59e77, 44, 12, 0x000000000000059e)
	DEP( 0xa5a5a5a5a5a59e77, 2047, 44, 12, 0xa5a5a5a5a5a7ff77)
	EXT( 0xa5a5a5a5a5a59e76, 44, 13, 0x0000000000000b3c)
	EXTU(0xa5a5a5a5a5a59e76, 44, 13, 0x0000000000000b3c)
	DEP( 0xa5a5a5a5a5a59e76, 4095, 44, 13, 0xa5a5a5a5a5a7fff6)
	EXT( 0xa5a5a5a5a5a59e75, 44, 14, 0x0000000000001679)
	EXTU(0xa5a5a5a5a5a59e75, 44, 14, 0x0000000000001679)
	DEP( 0xa5a5a5a5a5a59e75, 8191, 44, 14, 0xa5a5a5a5a5a7fff5)
	EXT( 0xa5a5a5a5a5a59e74, 44, 15, 0x0000000000002cf3)
	EXTU(0xa5a5a5a5a5a59e74, 44, 15, 0x0000000000002cf3)
	DEP( 0xa5a5a5a5a5a59e74, 16383, 44, 15, 0xa5a5a5a5a5a7fff4)
	EXT( 0xa5a5a5a5a5a59e73, 44, 16, 0x00000000000059e7)
	EXTU(0xa5a5a5a5a5a59e73, 44, 16, 0x00000000000059e7)
	DEP( 0xa5a5a5a5a5a59e73, 32767, 44, 16, 0xa5a5a5a5a5a7fff3)
	EXT( 0xa5a5a5a5a5a59e72, 44, 17, 0x000000000000b3ce)
	EXTU(0xa5a5a5a5a5a59e72, 44, 17, 0x000000000000b3ce)
	DEP( 0xa5a5a5a5a5a59e72, 65535, 44, 17, 0xa5a5a5a5a5a7fffa)
	EXT( 0xa5a5a5a5a5a59e71, 44, 18, 0x000000000001679c)
	EXTU(0xa5a5a5a5a5a59e71, 44, 18, 0x000000000001679c)
	DEP( 0xa5a5a5a5a5a59e71, 131071, 44, 18, 0xa5a5a5a5a5a7fffd)
	EXT( 0xa5a5a5a5a5a59e70, 44, 19, 0x000000000002cf38)
	EXTU(0xa5a5a5a5a5a59e70, 44, 19, 0x000000000002cf38)
	DEP( 0xa5a5a5a5a5a59e70, 262143, 44, 19, 0xa5a5a5a5a5a7fffe)
	EXT( 0xa5a5a5a5a5a59e6f, 45, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e6f, 45, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e6f, 0, 45, 1, 0xa5a5a5a5a5a19e6f)
	EXT( 0xa5a5a5a5a5a59e6e, 45, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e6e, 45, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e6e, 1, 45, 2, 0xa5a5a5a5a5a39e6e)
	EXT( 0xa5a5a5a5a5a59e6d, 45, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59e6d, 45, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59e6d, 3, 45, 3, 0xa5a5a5a5a5a39e6d)
	EXT( 0xa5a5a5a5a5a59e6c, 45, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59e6c, 45, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59e6c, 7, 45, 4, 0xa5a5a5a5a5a39e6c)
	EXT( 0xa5a5a5a5a5a59e6b, 45, 5, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a59e6b, 45, 5, 0x0000000000000016)
	DEP( 0xa5a5a5a5a5a59e6b, 15, 45, 5, 0xa5a5a5a5a5a3de6b)
	EXT( 0xa5a5a5a5a5a59e6a, 45, 6, 0xffffffffffffffec)
	EXTU(0xa5a5a5a5a5a59e6a, 45, 6, 0x000000000000002c)
	DEP( 0xa5a5a5a5a5a59e6a, 31, 45, 6, 0xa5a5a5a5a5a3fe6a)
	EXT( 0xa5a5a5a5a5a59e69, 45, 7, 0xffffffffffffffd9)
	EXTU(0xa5a5a5a5a5a59e69, 45, 7, 0x0000000000000059)
	DEP( 0xa5a5a5a5a5a59e69, 63, 45, 7, 0xa5a5a5a5a5a3fe69)
	EXT( 0xa5a5a5a5a5a59e68, 45, 8, 0xffffffffffffffb3)
	EXTU(0xa5a5a5a5a5a59e68, 45, 8, 0x00000000000000b3)
	DEP( 0xa5a5a5a5a5a59e68, 127, 45, 8, 0xa5a5a5a5a5a3fe68)
	EXT( 0xa5a5a5a5a5a59e67, 45, 9, 0xffffffffffffff67)
	EXTU(0xa5a5a5a5a5a59e67, 45, 9, 0x0000000000000167)
	DEP( 0xa5a5a5a5a5a59e67, 255, 45, 9, 0xa5a5a5a5a5a3fe67)
	EXT( 0xa5a5a5a5a5a59e66, 45, 10, 0xfffffffffffffecf)
	EXTU(0xa5a5a5a5a5a59e66, 45, 10, 0x00000000000002cf)
	DEP( 0xa5a5a5a5a5a59e66, 511, 45, 10, 0xa5a5a5a5a5a3fe66)
	EXT( 0xa5a5a5a5a5a59e65, 45, 11, 0xfffffffffffffd9e)
	EXTU(0xa5a5a5a5a5a59e65, 45, 11, 0x000000000000059e)
	DEP( 0xa5a5a5a5a5a59e65, 1023, 45, 11, 0xa5a5a5a5a5a3ff65)
	EXT( 0xa5a5a5a5a5a59e64, 45, 12, 0xfffffffffffffb3c)
	EXTU(0xa5a5a5a5a5a59e64, 45, 12, 0x0000000000000b3c)
	DEP( 0xa5a5a5a5a5a59e64, 2047, 45, 12, 0xa5a5a5a5a5a3ffe4)
	EXT( 0xa5a5a5a5a5a59e63, 45, 13, 0xfffffffffffff679)
	EXTU(0xa5a5a5a5a5a59e63, 45, 13, 0x0000000000001679)
	DEP( 0xa5a5a5a5a5a59e63, 4095, 45, 13, 0xa5a5a5a5a5a3ffe3)
	EXT( 0xa5a5a5a5a5a59e62, 45, 14, 0xffffffffffffecf3)
	EXTU(0xa5a5a5a5a5a59e62, 45, 14, 0x0000000000002cf3)
	DEP( 0xa5a5a5a5a5a59e62, 8191, 45, 14, 0xa5a5a5a5a5a3ffe2)
	EXT( 0xa5a5a5a5a5a59e61, 45, 15, 0xffffffffffffd9e6)
	EXTU(0xa5a5a5a5a5a59e61, 45, 15, 0x00000000000059e6)
	DEP( 0xa5a5a5a5a5a59e61, 16383, 45, 15, 0xa5a5a5a5a5a3fff1)
	EXT( 0xa5a5a5a5a5a59e60, 45, 16, 0xffffffffffffb3cc)
	EXTU(0xa5a5a5a5a5a59e60, 45, 16, 0x000000000000b3cc)
	DEP( 0xa5a5a5a5a5a59e60, 32767, 45, 16, 0xa5a5a5a5a5a3fff8)
	EXT( 0xa5a5a5a5a5a59e5f, 45, 17, 0xffffffffffff6797)
	EXTU(0xa5a5a5a5a5a59e5f, 45, 17, 0x0000000000016797)
	DEP( 0xa5a5a5a5a5a59e5f, 65535, 45, 17, 0xa5a5a5a5a5a3ffff)
	EXT( 0xa5a5a5a5a5a59e5e, 45, 18, 0xfffffffffffecf2f)
	EXTU(0xa5a5a5a5a5a59e5e, 45, 18, 0x000000000002cf2f)
	DEP( 0xa5a5a5a5a5a59e5e, 131071, 45, 18, 0xa5a5a5a5a5a3fffe)
	EXT( 0xa5a5a5a5a5a59e5d, 46, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e5d, 46, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e5d, 0, 46, 1, 0xa5a5a5a5a5a59e5d)
	EXT( 0xa5a5a5a5a5a59e5c, 46, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e5c, 46, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e5c, 1, 46, 2, 0xa5a5a5a5a5a59e5c)
	EXT( 0xa5a5a5a5a5a59e5b, 46, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59e5b, 46, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e5b, 3, 46, 3, 0xa5a5a5a5a5a59e5b)
	EXT( 0xa5a5a5a5a5a59e5a, 46, 4, 0x0000000000000006)
	EXTU(0xa5a5a5a5a5a59e5a, 46, 4, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59e5a, 7, 46, 4, 0xa5a5a5a5a5a5de5a)
	EXT( 0xa5a5a5a5a5a59e59, 46, 5, 0x000000000000000c)
	EXTU(0xa5a5a5a5a5a59e59, 46, 5, 0x000000000000000c)
	DEP( 0xa5a5a5a5a5a59e59, 15, 46, 5, 0xa5a5a5a5a5a5fe59)
	EXT( 0xa5a5a5a5a5a59e58, 46, 6, 0x0000000000000019)
	EXTU(0xa5a5a5a5a5a59e58, 46, 6, 0x0000000000000019)
	DEP( 0xa5a5a5a5a5a59e58, 31, 46, 6, 0xa5a5a5a5a5a5fe58)
	EXT( 0xa5a5a5a5a5a59e57, 46, 7, 0x0000000000000033)
	EXTU(0xa5a5a5a5a5a59e57, 46, 7, 0x0000000000000033)
	DEP( 0xa5a5a5a5a5a59e57, 63, 46, 7, 0xa5a5a5a5a5a5fe57)
	EXT( 0xa5a5a5a5a5a59e56, 46, 8, 0x0000000000000067)
	EXTU(0xa5a5a5a5a5a59e56, 46, 8, 0x0000000000000067)
	DEP( 0xa5a5a5a5a5a59e56, 127, 46, 8, 0xa5a5a5a5a5a5fe56)
	EXT( 0xa5a5a5a5a5a59e55, 46, 9, 0x00000000000000cf)
	EXTU(0xa5a5a5a5a5a59e55, 46, 9, 0x00000000000000cf)
	DEP( 0xa5a5a5a5a5a59e55, 255, 46, 9, 0xa5a5a5a5a5a5fe55)
	EXT( 0xa5a5a5a5a5a59e54, 46, 10, 0x000000000000019e)
	EXTU(0xa5a5a5a5a5a59e54, 46, 10, 0x000000000000019e)
	DEP( 0xa5a5a5a5a5a59e54, 511, 46, 10, 0xa5a5a5a5a5a5ff54)
	EXT( 0xa5a5a5a5a5a59e53, 46, 11, 0x000000000000033c)
	EXTU(0xa5a5a5a5a5a59e53, 46, 11, 0x000000000000033c)
	DEP( 0xa5a5a5a5a5a59e53, 1023, 46, 11, 0xa5a5a5a5a5a5ffd3)
	EXT( 0xa5a5a5a5a5a59e52, 46, 12, 0x0000000000000679)
	EXTU(0xa5a5a5a5a5a59e52, 46, 12, 0x0000000000000679)
	DEP( 0xa5a5a5a5a5a59e52, 2047, 46, 12, 0xa5a5a5a5a5a5ffd2)
	EXT( 0xa5a5a5a5a5a59e51, 46, 13, 0x0000000000000cf2)
	EXTU(0xa5a5a5a5a5a59e51, 46, 13, 0x0000000000000cf2)
	DEP( 0xa5a5a5a5a5a59e51, 4095, 46, 13, 0xa5a5a5a5a5a5fff1)
	EXT( 0xa5a5a5a5a5a59e50, 46, 14, 0x00000000000019e5)
	EXTU(0xa5a5a5a5a5a59e50, 46, 14, 0x00000000000019e5)
	DEP( 0xa5a5a5a5a5a59e50, 8191, 46, 14, 0xa5a5a5a5a5a5fff0)
	EXT( 0xa5a5a5a5a5a59e4f, 46, 15, 0x00000000000033c9)
	EXTU(0xa5a5a5a5a5a59e4f, 46, 15, 0x00000000000033c9)
	DEP( 0xa5a5a5a5a5a59e4f, 16383, 46, 15, 0xa5a5a5a5a5a5ffff)
	EXT( 0xa5a5a5a5a5a59e4e, 46, 16, 0x0000000000006793)
	EXTU(0xa5a5a5a5a5a59e4e, 46, 16, 0x0000000000006793)
	DEP( 0xa5a5a5a5a5a59e4e, 32767, 46, 16, 0xa5a5a5a5a5a5fffe)
	EXT( 0xa5a5a5a5a5a59e4d, 46, 17, 0x000000000000cf26)
	EXTU(0xa5a5a5a5a5a59e4d, 46, 17, 0x000000000000cf26)
	DEP( 0xa5a5a5a5a5a59e4d, 65535, 46, 17, 0xa5a5a5a5a5a5ffff)
	EXT( 0xa5a5a5a5a5a59e4c, 47, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e4c, 47, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e4c, 0, 47, 1, 0xa5a5a5a5a5a49e4c)
	EXT( 0xa5a5a5a5a5a59e4b, 47, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e4b, 47, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e4b, 1, 47, 2, 0xa5a5a5a5a5a49e4b)
	EXT( 0xa5a5a5a5a5a59e4a, 47, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e4a, 47, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59e4a, 3, 47, 3, 0xa5a5a5a5a5a4de4a)
	EXT( 0xa5a5a5a5a5a59e49, 47, 4, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59e49, 47, 4, 0x000000000000000c)
	DEP( 0xa5a5a5a5a5a59e49, 7, 47, 4, 0xa5a5a5a5a5a4fe49)
	EXT( 0xa5a5a5a5a5a59e48, 47, 5, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59e48, 47, 5, 0x0000000000000019)
	DEP( 0xa5a5a5a5a5a59e48, 15, 47, 5, 0xa5a5a5a5a5a4fe48)
	EXT( 0xa5a5a5a5a5a59e47, 47, 6, 0xfffffffffffffff3)
	EXTU(0xa5a5a5a5a5a59e47, 47, 6, 0x0000000000000033)
	DEP( 0xa5a5a5a5a5a59e47, 31, 47, 6, 0xa5a5a5a5a5a4fe47)
	EXT( 0xa5a5a5a5a5a59e46, 47, 7, 0xffffffffffffffe7)
	EXTU(0xa5a5a5a5a5a59e46, 47, 7, 0x0000000000000067)
	DEP( 0xa5a5a5a5a5a59e46, 63, 47, 7, 0xa5a5a5a5a5a4fe46)
	EXT( 0xa5a5a5a5a5a59e45, 47, 8, 0xffffffffffffffcf)
	EXTU(0xa5a5a5a5a5a59e45, 47, 8, 0x00000000000000cf)
	DEP( 0xa5a5a5a5a5a59e45, 127, 47, 8, 0xa5a5a5a5a5a4fe45)
	EXT( 0xa5a5a5a5a5a59e44, 47, 9, 0xffffffffffffff9e)
	EXTU(0xa5a5a5a5a5a59e44, 47, 9, 0x000000000000019e)
	DEP( 0xa5a5a5a5a5a59e44, 255, 47, 9, 0xa5a5a5a5a5a4ff44)
	EXT( 0xa5a5a5a5a5a59e43, 47, 10, 0xffffffffffffff3c)
	EXTU(0xa5a5a5a5a5a59e43, 47, 10, 0x000000000000033c)
	DEP( 0xa5a5a5a5a5a59e43, 511, 47, 10, 0xa5a5a5a5a5a4ffc3)
	EXT( 0xa5a5a5a5a5a59e42, 47, 11, 0xfffffffffffffe79)
	EXTU(0xa5a5a5a5a5a59e42, 47, 11, 0x0000000000000679)
	DEP( 0xa5a5a5a5a5a59e42, 1023, 47, 11, 0xa5a5a5a5a5a4ffc2)
	EXT( 0xa5a5a5a5a5a59e41, 47, 12, 0xfffffffffffffcf2)
	EXTU(0xa5a5a5a5a5a59e41, 47, 12, 0x0000000000000cf2)
	DEP( 0xa5a5a5a5a5a59e41, 2047, 47, 12, 0xa5a5a5a5a5a4ffe1)
	EXT( 0xa5a5a5a5a5a59e40, 47, 13, 0xfffffffffffff9e4)
	EXTU(0xa5a5a5a5a5a59e40, 47, 13, 0x00000000000019e4)
	DEP( 0xa5a5a5a5a5a59e40, 4095, 47, 13, 0xa5a5a5a5a5a4fff0)
	EXT( 0xa5a5a5a5a5a59e3f, 47, 14, 0xfffffffffffff3c7)
	EXTU(0xa5a5a5a5a5a59e3f, 47, 14, 0x00000000000033c7)
	DEP( 0xa5a5a5a5a5a59e3f, 8191, 47, 14, 0xa5a5a5a5a5a4ffff)
	EXT( 0xa5a5a5a5a5a59e3e, 47, 15, 0xffffffffffffe78f)
	EXTU(0xa5a5a5a5a5a59e3e, 47, 15, 0x000000000000678f)
	DEP( 0xa5a5a5a5a5a59e3e, 16383, 47, 15, 0xa5a5a5a5a5a4fffe)
	EXT( 0xa5a5a5a5a5a59e3d, 47, 16, 0xffffffffffffcf1e)
	EXTU(0xa5a5a5a5a5a59e3d, 47, 16, 0x000000000000cf1e)
	DEP( 0xa5a5a5a5a5a59e3d, 32767, 47, 16, 0xa5a5a5a5a5a4ffff)
	EXT( 0xa5a5a5a5a5a59e3c, 48, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e3c, 48, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e3c, 0, 48, 1, 0xa5a5a5a5a5a51e3c)
	EXT( 0xa5a5a5a5a5a59e3b, 48, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e3b, 48, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59e3b, 1, 48, 2, 0xa5a5a5a5a5a55e3b)
	EXT( 0xa5a5a5a5a5a59e3a, 48, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59e3a, 48, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59e3a, 3, 48, 3, 0xa5a5a5a5a5a57e3a)
	EXT( 0xa5a5a5a5a5a59e39, 48, 4, 0xfffffffffffffff9)
	EXTU(0xa5a5a5a5a5a59e39, 48, 4, 0x0000000000000009)
	DEP( 0xa5a5a5a5a5a59e39, 7, 48, 4, 0xa5a5a5a5a5a57e39)
	EXT( 0xa5a5a5a5a5a59e38, 48, 5, 0xfffffffffffffff3)
	EXTU(0xa5a5a5a5a5a59e38, 48, 5, 0x0000000000000013)
	DEP( 0xa5a5a5a5a5a59e38, 15, 48, 5, 0xa5a5a5a5a5a57e38)
	EXT( 0xa5a5a5a5a5a59e37, 48, 6, 0xffffffffffffffe7)
	EXTU(0xa5a5a5a5a5a59e37, 48, 6, 0x0000000000000027)
	DEP( 0xa5a5a5a5a5a59e37, 31, 48, 6, 0xa5a5a5a5a5a57e37)
	EXT( 0xa5a5a5a5a5a59e36, 48, 7, 0xffffffffffffffcf)
	EXTU(0xa5a5a5a5a5a59e36, 48, 7, 0x000000000000004f)
	DEP( 0xa5a5a5a5a5a59e36, 63, 48, 7, 0xa5a5a5a5a5a57e36)
	EXT( 0xa5a5a5a5a5a59e35, 48, 8, 0xffffffffffffff9e)
	EXTU(0xa5a5a5a5a5a59e35, 48, 8, 0x000000000000009e)
	DEP( 0xa5a5a5a5a5a59e35, 127, 48, 8, 0xa5a5a5a5a5a57f35)
	EXT( 0xa5a5a5a5a5a59e34, 48, 9, 0xffffffffffffff3c)
	EXTU(0xa5a5a5a5a5a59e34, 48, 9, 0x000000000000013c)
	DEP( 0xa5a5a5a5a5a59e34, 255, 48, 9, 0xa5a5a5a5a5a57fb4)
	EXT( 0xa5a5a5a5a5a59e33, 48, 10, 0xfffffffffffffe78)
	EXTU(0xa5a5a5a5a5a59e33, 48, 10, 0x0000000000000278)
	DEP( 0xa5a5a5a5a5a59e33, 511, 48, 10, 0xa5a5a5a5a5a57ff3)
	EXT( 0xa5a5a5a5a5a59e32, 48, 11, 0xfffffffffffffcf1)
	EXTU(0xa5a5a5a5a5a59e32, 48, 11, 0x00000000000004f1)
	DEP( 0xa5a5a5a5a5a59e32, 1023, 48, 11, 0xa5a5a5a5a5a57ff2)
	EXT( 0xa5a5a5a5a5a59e31, 48, 12, 0xfffffffffffff9e3)
	EXTU(0xa5a5a5a5a5a59e31, 48, 12, 0x00000000000009e3)
	DEP( 0xa5a5a5a5a5a59e31, 2047, 48, 12, 0xa5a5a5a5a5a57ff1)
	EXT( 0xa5a5a5a5a5a59e30, 48, 13, 0xfffffffffffff3c6)
	EXTU(0xa5a5a5a5a5a59e30, 48, 13, 0x00000000000013c6)
	DEP( 0xa5a5a5a5a5a59e30, 4095, 48, 13, 0xa5a5a5a5a5a57ff8)
	EXT( 0xa5a5a5a5a5a59e2f, 48, 14, 0xffffffffffffe78b)
	EXTU(0xa5a5a5a5a5a59e2f, 48, 14, 0x000000000000278b)
	DEP( 0xa5a5a5a5a5a59e2f, 8191, 48, 14, 0xa5a5a5a5a5a57fff)
	EXT( 0xa5a5a5a5a5a59e2e, 48, 15, 0xffffffffffffcf17)
	EXTU(0xa5a5a5a5a5a59e2e, 48, 15, 0x0000000000004f17)
	DEP( 0xa5a5a5a5a5a59e2e, 16383, 48, 15, 0xa5a5a5a5a5a57ffe)
	EXT( 0xa5a5a5a5a5a59e2d, 49, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e2d, 49, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e2d, 0, 49, 1, 0xa5a5a5a5a5a59e2d)
	EXT( 0xa5a5a5a5a5a59e2c, 49, 2, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e2c, 49, 2, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e2c, 1, 49, 2, 0xa5a5a5a5a5a5be2c)
	EXT( 0xa5a5a5a5a5a59e2b, 49, 3, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e2b, 49, 3, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e2b, 3, 49, 3, 0xa5a5a5a5a5a5be2b)
	EXT( 0xa5a5a5a5a5a59e2a, 49, 4, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59e2a, 49, 4, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e2a, 7, 49, 4, 0xa5a5a5a5a5a5be2a)
	EXT( 0xa5a5a5a5a5a59e29, 49, 5, 0x0000000000000007)
	EXTU(0xa5a5a5a5a5a59e29, 49, 5, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a59e29, 15, 49, 5, 0xa5a5a5a5a5a5be29)
	EXT( 0xa5a5a5a5a5a59e28, 49, 6, 0x000000000000000f)
	EXTU(0xa5a5a5a5a5a59e28, 49, 6, 0x000000000000000f)
	DEP( 0xa5a5a5a5a5a59e28, 31, 49, 6, 0xa5a5a5a5a5a5be28)
	EXT( 0xa5a5a5a5a5a59e27, 49, 7, 0x000000000000001e)
	EXTU(0xa5a5a5a5a5a59e27, 49, 7, 0x000000000000001e)
	DEP( 0xa5a5a5a5a5a59e27, 63, 49, 7, 0xa5a5a5a5a5a5bf27)
	EXT( 0xa5a5a5a5a5a59e26, 49, 8, 0x000000000000003c)
	EXTU(0xa5a5a5a5a5a59e26, 49, 8, 0x000000000000003c)
	DEP( 0xa5a5a5a5a5a59e26, 127, 49, 8, 0xa5a5a5a5a5a5bfa6)
	EXT( 0xa5a5a5a5a5a59e25, 49, 9, 0x0000000000000078)
	EXTU(0xa5a5a5a5a5a59e25, 49, 9, 0x0000000000000078)
	DEP( 0xa5a5a5a5a5a59e25, 255, 49, 9, 0xa5a5a5a5a5a5bfe5)
	EXT( 0xa5a5a5a5a5a59e24, 49, 10, 0x00000000000000f1)
	EXTU(0xa5a5a5a5a5a59e24, 49, 10, 0x00000000000000f1)
	DEP( 0xa5a5a5a5a5a59e24, 511, 49, 10, 0xa5a5a5a5a5a5bfe4)
	EXT( 0xa5a5a5a5a5a59e23, 49, 11, 0x00000000000001e2)
	EXTU(0xa5a5a5a5a5a59e23, 49, 11, 0x00000000000001e2)
	DEP( 0xa5a5a5a5a5a59e23, 1023, 49, 11, 0xa5a5a5a5a5a5bff3)
	EXT( 0xa5a5a5a5a5a59e22, 49, 12, 0x00000000000003c4)
	EXTU(0xa5a5a5a5a5a59e22, 49, 12, 0x00000000000003c4)
	DEP( 0xa5a5a5a5a5a59e22, 2047, 49, 12, 0xa5a5a5a5a5a5bffa)
	EXT( 0xa5a5a5a5a5a59e21, 49, 13, 0x0000000000000788)
	EXTU(0xa5a5a5a5a5a59e21, 49, 13, 0x0000000000000788)
	DEP( 0xa5a5a5a5a5a59e21, 4095, 49, 13, 0xa5a5a5a5a5a5bffd)
	EXT( 0xa5a5a5a5a5a59e20, 49, 14, 0x0000000000000f10)
	EXTU(0xa5a5a5a5a5a59e20, 49, 14, 0x0000000000000f10)
	DEP( 0xa5a5a5a5a5a59e20, 8191, 49, 14, 0xa5a5a5a5a5a5bffe)
	EXT( 0xa5a5a5a5a5a59e1f, 50, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59e1f, 50, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59e1f, 0, 50, 1, 0xa5a5a5a5a5a59e1f)
	EXT( 0xa5a5a5a5a5a59e1e, 50, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59e1e, 50, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e1e, 1, 50, 2, 0xa5a5a5a5a5a59e1e)
	EXT( 0xa5a5a5a5a5a59e1d, 50, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59e1d, 50, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e1d, 3, 50, 3, 0xa5a5a5a5a5a59e1d)
	EXT( 0xa5a5a5a5a5a59e1c, 50, 4, 0x0000000000000007)
	EXTU(0xa5a5a5a5a5a59e1c, 50, 4, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a59e1c, 7, 50, 4, 0xa5a5a5a5a5a59e1c)
	EXT( 0xa5a5a5a5a5a59e1b, 50, 5, 0x000000000000000f)
	EXTU(0xa5a5a5a5a5a59e1b, 50, 5, 0x000000000000000f)
	DEP( 0xa5a5a5a5a5a59e1b, 15, 50, 5, 0xa5a5a5a5a5a59e1b)
	EXT( 0xa5a5a5a5a5a59e1a, 50, 6, 0x000000000000001e)
	EXTU(0xa5a5a5a5a5a59e1a, 50, 6, 0x000000000000001e)
	DEP( 0xa5a5a5a5a5a59e1a, 31, 50, 6, 0xa5a5a5a5a5a59f1a)
	EXT( 0xa5a5a5a5a5a59e19, 50, 7, 0x000000000000003c)
	EXTU(0xa5a5a5a5a5a59e19, 50, 7, 0x000000000000003c)
	DEP( 0xa5a5a5a5a5a59e19, 63, 50, 7, 0xa5a5a5a5a5a59f99)
	EXT( 0xa5a5a5a5a5a59e18, 50, 8, 0x0000000000000078)
	EXTU(0xa5a5a5a5a5a59e18, 50, 8, 0x0000000000000078)
	DEP( 0xa5a5a5a5a5a59e18, 127, 50, 8, 0xa5a5a5a5a5a59fd8)
	EXT( 0xa5a5a5a5a5a59e17, 50, 9, 0x00000000000000f0)
	EXTU(0xa5a5a5a5a5a59e17, 50, 9, 0x00000000000000f0)
	DEP( 0xa5a5a5a5a5a59e17, 255, 50, 9, 0xa5a5a5a5a5a59ff7)
	EXT( 0xa5a5a5a5a5a59e16, 50, 10, 0x00000000000001e1)
	EXTU(0xa5a5a5a5a5a59e16, 50, 10, 0x00000000000001e1)
	DEP( 0xa5a5a5a5a5a59e16, 511, 50, 10, 0xa5a5a5a5a5a59ff6)
	EXT( 0xa5a5a5a5a5a59e15, 50, 11, 0x00000000000003c2)
	EXTU(0xa5a5a5a5a5a59e15, 50, 11, 0x00000000000003c2)
	DEP( 0xa5a5a5a5a5a59e15, 1023, 50, 11, 0xa5a5a5a5a5a59ffd)
	EXT( 0xa5a5a5a5a5a59e14, 50, 12, 0x0000000000000785)
	EXTU(0xa5a5a5a5a5a59e14, 50, 12, 0x0000000000000785)
	DEP( 0xa5a5a5a5a5a59e14, 2047, 50, 12, 0xa5a5a5a5a5a59ffc)
	EXT( 0xa5a5a5a5a5a59e13, 50, 13, 0x0000000000000f09)
	EXTU(0xa5a5a5a5a5a59e13, 50, 13, 0x0000000000000f09)
	DEP( 0xa5a5a5a5a5a59e13, 4095, 50, 13, 0xa5a5a5a5a5a59fff)
	EXT( 0xa5a5a5a5a5a59e12, 51, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e12, 51, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e12, 0, 51, 1, 0xa5a5a5a5a5a58e12)
	EXT( 0xa5a5a5a5a5a59e11, 51, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e11, 51, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e11, 1, 51, 2, 0xa5a5a5a5a5a58e11)
	EXT( 0xa5a5a5a5a5a59e10, 51, 3, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e10, 51, 3, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a59e10, 3, 51, 3, 0xa5a5a5a5a5a58e10)
	EXT( 0xa5a5a5a5a5a59e0f, 51, 4, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e0f, 51, 4, 0x000000000000000f)
	DEP( 0xa5a5a5a5a5a59e0f, 7, 51, 4, 0xa5a5a5a5a5a58e0f)
	EXT( 0xa5a5a5a5a5a59e0e, 51, 5, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e0e, 51, 5, 0x000000000000001e)
	DEP( 0xa5a5a5a5a5a59e0e, 15, 51, 5, 0xa5a5a5a5a5a58f0e)
	EXT( 0xa5a5a5a5a5a59e0d, 51, 6, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59e0d, 51, 6, 0x000000000000003c)
	DEP( 0xa5a5a5a5a5a59e0d, 31, 51, 6, 0xa5a5a5a5a5a58f8d)
	EXT( 0xa5a5a5a5a5a59e0c, 51, 7, 0xfffffffffffffff8)
	EXTU(0xa5a5a5a5a5a59e0c, 51, 7, 0x0000000000000078)
	DEP( 0xa5a5a5a5a5a59e0c, 63, 51, 7, 0xa5a5a5a5a5a58fcc)
	EXT( 0xa5a5a5a5a5a59e0b, 51, 8, 0xfffffffffffffff0)
	EXTU(0xa5a5a5a5a5a59e0b, 51, 8, 0x00000000000000f0)
	DEP( 0xa5a5a5a5a5a59e0b, 127, 51, 8, 0xa5a5a5a5a5a58feb)
	EXT( 0xa5a5a5a5a5a59e0a, 51, 9, 0xffffffffffffffe0)
	EXTU(0xa5a5a5a5a5a59e0a, 51, 9, 0x00000000000001e0)
	DEP( 0xa5a5a5a5a5a59e0a, 255, 51, 9, 0xa5a5a5a5a5a58ffa)
	EXT( 0xa5a5a5a5a5a59e09, 51, 10, 0xffffffffffffffc1)
	EXTU(0xa5a5a5a5a5a59e09, 51, 10, 0x00000000000003c1)
	DEP( 0xa5a5a5a5a5a59e09, 511, 51, 10, 0xa5a5a5a5a5a58ff9)
	EXT( 0xa5a5a5a5a5a59e08, 51, 11, 0xffffffffffffff82)
	EXTU(0xa5a5a5a5a5a59e08, 51, 11, 0x0000000000000782)
	DEP( 0xa5a5a5a5a5a59e08, 1023, 51, 11, 0xa5a5a5a5a5a58ffc)
	EXT( 0xa5a5a5a5a5a59e07, 51, 12, 0xffffffffffffff03)
	EXTU(0xa5a5a5a5a5a59e07, 51, 12, 0x0000000000000f03)
	DEP( 0xa5a5a5a5a5a59e07, 2047, 51, 12, 0xa5a5a5a5a5a58fff)
	EXT( 0xa5a5a5a5a5a59e06, 52, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e06, 52, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59e06, 0, 52, 1, 0xa5a5a5a5a5a59606)
	EXT( 0xa5a5a5a5a5a59e05, 52, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e05, 52, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59e05, 1, 52, 2, 0xa5a5a5a5a5a59605)
	EXT( 0xa5a5a5a5a5a59e04, 52, 3, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59e04, 52, 3, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a59e04, 3, 52, 3, 0xa5a5a5a5a5a59604)
	EXT( 0xa5a5a5a5a5a59e03, 52, 4, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59e03, 52, 4, 0x000000000000000e)
	DEP( 0xa5a5a5a5a5a59e03, 7, 52, 4, 0xa5a5a5a5a5a59703)
	EXT( 0xa5a5a5a5a5a59e02, 52, 5, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59e02, 52, 5, 0x000000000000001c)
	DEP( 0xa5a5a5a5a5a59e02, 15, 52, 5, 0xa5a5a5a5a5a59782)
	EXT( 0xa5a5a5a5a5a59e01, 52, 6, 0xfffffffffffffff8)
	EXTU(0xa5a5a5a5a5a59e01, 52, 6, 0x0000000000000038)
	DEP( 0xa5a5a5a5a5a59e01, 31, 52, 6, 0xa5a5a5a5a5a597c1)
	EXT( 0xa5a5a5a5a5a59e00, 52, 7, 0xfffffffffffffff0)
	EXTU(0xa5a5a5a5a5a59e00, 52, 7, 0x0000000000000070)
	DEP( 0xa5a5a5a5a5a59e00, 63, 52, 7, 0xa5a5a5a5a5a597e0)
	EXT( 0xa5a5a5a5a5a59dff, 52, 8, 0xffffffffffffffdf)
	EXTU(0xa5a5a5a5a5a59dff, 52, 8, 0x00000000000000df)
	DEP( 0xa5a5a5a5a5a59dff, 127, 52, 8, 0xa5a5a5a5a5a597ff)
	EXT( 0xa5a5a5a5a5a59dfe, 52, 9, 0xffffffffffffffbf)
	EXTU(0xa5a5a5a5a5a59dfe, 52, 9, 0x00000000000001bf)
	DEP( 0xa5a5a5a5a5a59dfe, 255, 52, 9, 0xa5a5a5a5a5a597fe)
	EXT( 0xa5a5a5a5a5a59dfd, 52, 10, 0xffffffffffffff7f)
	EXTU(0xa5a5a5a5a5a59dfd, 52, 10, 0x000000000000037f)
	DEP( 0xa5a5a5a5a5a59dfd, 511, 52, 10, 0xa5a5a5a5a5a597fd)
	EXT( 0xa5a5a5a5a5a59dfc, 52, 11, 0xfffffffffffffefe)
	EXTU(0xa5a5a5a5a5a59dfc, 52, 11, 0x00000000000006fe)
	DEP( 0xa5a5a5a5a5a59dfc, 1023, 52, 11, 0xa5a5a5a5a5a597fe)
	EXT( 0xa5a5a5a5a5a59dfb, 53, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dfb, 53, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dfb, 0, 53, 1, 0xa5a5a5a5a5a599fb)
	EXT( 0xa5a5a5a5a5a59dfa, 53, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59dfa, 53, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dfa, 1, 53, 2, 0xa5a5a5a5a5a59bfa)
	EXT( 0xa5a5a5a5a5a59df9, 53, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59df9, 53, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59df9, 3, 53, 3, 0xa5a5a5a5a5a59bf9)
	EXT( 0xa5a5a5a5a5a59df8, 53, 4, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59df8, 53, 4, 0x000000000000000b)
	DEP( 0xa5a5a5a5a5a59df8, 7, 53, 4, 0xa5a5a5a5a5a59bf8)
	EXT( 0xa5a5a5a5a5a59df7, 53, 5, 0xfffffffffffffff7)
	EXTU(0xa5a5a5a5a5a59df7, 53, 5, 0x0000000000000017)
	DEP( 0xa5a5a5a5a5a59df7, 15, 53, 5, 0xa5a5a5a5a5a59bf7)
	EXT( 0xa5a5a5a5a5a59df6, 53, 6, 0xffffffffffffffef)
	EXTU(0xa5a5a5a5a5a59df6, 53, 6, 0x000000000000002f)
	DEP( 0xa5a5a5a5a5a59df6, 31, 53, 6, 0xa5a5a5a5a5a59bf6)
	EXT( 0xa5a5a5a5a5a59df5, 53, 7, 0xffffffffffffffdf)
	EXTU(0xa5a5a5a5a5a59df5, 53, 7, 0x000000000000005f)
	DEP( 0xa5a5a5a5a5a59df5, 63, 53, 7, 0xa5a5a5a5a5a59bf5)
	EXT( 0xa5a5a5a5a5a59df4, 53, 8, 0xffffffffffffffbe)
	EXTU(0xa5a5a5a5a5a59df4, 53, 8, 0x00000000000000be)
	DEP( 0xa5a5a5a5a5a59df4, 127, 53, 8, 0xa5a5a5a5a5a59bfc)
	EXT( 0xa5a5a5a5a5a59df3, 53, 9, 0xffffffffffffff7c)
	EXTU(0xa5a5a5a5a5a59df3, 53, 9, 0x000000000000017c)
	DEP( 0xa5a5a5a5a5a59df3, 255, 53, 9, 0xa5a5a5a5a5a59bff)
	EXT( 0xa5a5a5a5a5a59df2, 53, 10, 0xfffffffffffffef9)
	EXTU(0xa5a5a5a5a5a59df2, 53, 10, 0x00000000000002f9)
	DEP( 0xa5a5a5a5a5a59df2, 511, 53, 10, 0xa5a5a5a5a5a59bfe)
	EXT( 0xa5a5a5a5a5a59df1, 54, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59df1, 54, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59df1, 0, 54, 1, 0xa5a5a5a5a5a59df1)
	EXT( 0xa5a5a5a5a5a59df0, 54, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59df0, 54, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59df0, 1, 54, 2, 0xa5a5a5a5a5a59df0)
	EXT( 0xa5a5a5a5a5a59def, 54, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59def, 54, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59def, 3, 54, 3, 0xa5a5a5a5a5a59def)
	EXT( 0xa5a5a5a5a5a59dee, 54, 4, 0x0000000000000007)
	EXTU(0xa5a5a5a5a5a59dee, 54, 4, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a59dee, 7, 54, 4, 0xa5a5a5a5a5a59dee)
	EXT( 0xa5a5a5a5a5a59ded, 54, 5, 0x000000000000000f)
	EXTU(0xa5a5a5a5a5a59ded, 54, 5, 0x000000000000000f)
	DEP( 0xa5a5a5a5a5a59ded, 15, 54, 5, 0xa5a5a5a5a5a59ded)
	EXT( 0xa5a5a5a5a5a59dec, 54, 6, 0x000000000000001e)
	EXTU(0xa5a5a5a5a5a59dec, 54, 6, 0x000000000000001e)
	DEP( 0xa5a5a5a5a5a59dec, 31, 54, 6, 0xa5a5a5a5a5a59dfc)
	EXT( 0xa5a5a5a5a5a59deb, 54, 7, 0x000000000000003d)
	EXTU(0xa5a5a5a5a5a59deb, 54, 7, 0x000000000000003d)
	DEP( 0xa5a5a5a5a5a59deb, 63, 54, 7, 0xa5a5a5a5a5a59dfb)
	EXT( 0xa5a5a5a5a5a59dea, 54, 8, 0x000000000000007a)
	EXTU(0xa5a5a5a5a5a59dea, 54, 8, 0x000000000000007a)
	DEP( 0xa5a5a5a5a5a59dea, 127, 54, 8, 0xa5a5a5a5a5a59dfe)
	EXT( 0xa5a5a5a5a5a59de9, 54, 9, 0x00000000000000f4)
	EXTU(0xa5a5a5a5a5a59de9, 54, 9, 0x00000000000000f4)
	DEP( 0xa5a5a5a5a5a59de9, 255, 54, 9, 0xa5a5a5a5a5a59dff)
	EXT( 0xa5a5a5a5a5a59de8, 55, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de8, 55, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59de8, 0, 55, 1, 0xa5a5a5a5a5a59ce8)
	EXT( 0xa5a5a5a5a5a59de7, 55, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de7, 55, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59de7, 1, 55, 2, 0xa5a5a5a5a5a59ce7)
	EXT( 0xa5a5a5a5a5a59de6, 55, 3, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de6, 55, 3, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a59de6, 3, 55, 3, 0xa5a5a5a5a5a59ce6)
	EXT( 0xa5a5a5a5a5a59de5, 55, 4, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de5, 55, 4, 0x000000000000000f)
	DEP( 0xa5a5a5a5a5a59de5, 7, 55, 4, 0xa5a5a5a5a5a59ce5)
	EXT( 0xa5a5a5a5a5a59de4, 55, 5, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59de4, 55, 5, 0x000000000000001e)
	DEP( 0xa5a5a5a5a5a59de4, 15, 55, 5, 0xa5a5a5a5a5a59cf4)
	EXT( 0xa5a5a5a5a5a59de3, 55, 6, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59de3, 55, 6, 0x000000000000003c)
	DEP( 0xa5a5a5a5a5a59de3, 31, 55, 6, 0xa5a5a5a5a5a59cfb)
	EXT( 0xa5a5a5a5a5a59de2, 55, 7, 0xfffffffffffffff8)
	EXTU(0xa5a5a5a5a5a59de2, 55, 7, 0x0000000000000078)
	DEP( 0xa5a5a5a5a5a59de2, 63, 55, 7, 0xa5a5a5a5a5a59cfe)
	EXT( 0xa5a5a5a5a5a59de1, 55, 8, 0xfffffffffffffff0)
	EXTU(0xa5a5a5a5a5a59de1, 55, 8, 0x00000000000000f0)
	DEP( 0xa5a5a5a5a5a59de1, 127, 55, 8, 0xa5a5a5a5a5a59cff)
	EXT( 0xa5a5a5a5a5a59de0, 56, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59de0, 56, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59de0, 0, 56, 1, 0xa5a5a5a5a5a59d60)
	EXT( 0xa5a5a5a5a5a59ddf, 56, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59ddf, 56, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59ddf, 1, 56, 2, 0xa5a5a5a5a5a59d5f)
	EXT( 0xa5a5a5a5a5a59dde, 56, 3, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59dde, 56, 3, 0x0000000000000006)
	DEP( 0xa5a5a5a5a5a59dde, 3, 56, 3, 0xa5a5a5a5a5a59d7e)
	EXT( 0xa5a5a5a5a5a59ddd, 56, 4, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59ddd, 56, 4, 0x000000000000000d)
	DEP( 0xa5a5a5a5a5a59ddd, 7, 56, 4, 0xa5a5a5a5a5a59d7d)
	EXT( 0xa5a5a5a5a5a59ddc, 56, 5, 0xfffffffffffffffb)
	EXTU(0xa5a5a5a5a5a59ddc, 56, 5, 0x000000000000001b)
	DEP( 0xa5a5a5a5a5a59ddc, 15, 56, 5, 0xa5a5a5a5a5a59d7c)
	EXT( 0xa5a5a5a5a5a59ddb, 56, 6, 0xfffffffffffffff6)
	EXTU(0xa5a5a5a5a5a59ddb, 56, 6, 0x0000000000000036)
	DEP( 0xa5a5a5a5a5a59ddb, 31, 56, 6, 0xa5a5a5a5a5a59d7f)
	EXT( 0xa5a5a5a5a5a59dda, 56, 7, 0xffffffffffffffed)
	EXTU(0xa5a5a5a5a5a59dda, 56, 7, 0x000000000000006d)
	DEP( 0xa5a5a5a5a5a59dda, 63, 56, 7, 0xa5a5a5a5a5a59d7e)
	EXT( 0xa5a5a5a5a5a59dd9, 57, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dd9, 57, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dd9, 0, 57, 1, 0xa5a5a5a5a5a59d99)
	EXT( 0xa5a5a5a5a5a59dd8, 57, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59dd8, 57, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dd8, 1, 57, 2, 0xa5a5a5a5a5a59db8)
	EXT( 0xa5a5a5a5a5a59dd7, 57, 3, 0xfffffffffffffffd)
	EXTU(0xa5a5a5a5a5a59dd7, 57, 3, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59dd7, 3, 57, 3, 0xa5a5a5a5a5a59db7)
	EXT( 0xa5a5a5a5a5a59dd6, 57, 4, 0xfffffffffffffffa)
	EXTU(0xa5a5a5a5a5a59dd6, 57, 4, 0x000000000000000a)
	DEP( 0xa5a5a5a5a5a59dd6, 7, 57, 4, 0xa5a5a5a5a5a59dbe)
	EXT( 0xa5a5a5a5a5a59dd5, 57, 5, 0xfffffffffffffff5)
	EXTU(0xa5a5a5a5a5a59dd5, 57, 5, 0x0000000000000015)
	DEP( 0xa5a5a5a5a5a59dd5, 15, 57, 5, 0xa5a5a5a5a5a59dbd)
	EXT( 0xa5a5a5a5a5a59dd4, 57, 6, 0xffffffffffffffea)
	EXTU(0xa5a5a5a5a5a59dd4, 57, 6, 0x000000000000002a)
	DEP( 0xa5a5a5a5a5a59dd4, 31, 57, 6, 0xa5a5a5a5a5a59dbe)
	EXT( 0xa5a5a5a5a5a59dd3, 58, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dd3, 58, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dd3, 0, 58, 1, 0xa5a5a5a5a5a59dd3)
	EXT( 0xa5a5a5a5a5a59dd2, 58, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59dd2, 58, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dd2, 1, 58, 2, 0xa5a5a5a5a5a59dd2)
	EXT( 0xa5a5a5a5a5a59dd1, 58, 3, 0x0000000000000002)
	EXTU(0xa5a5a5a5a5a59dd1, 58, 3, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dd1, 3, 58, 3, 0xa5a5a5a5a5a59dd9)
	EXT( 0xa5a5a5a5a5a59dd0, 58, 4, 0x0000000000000004)
	EXTU(0xa5a5a5a5a5a59dd0, 58, 4, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59dd0, 7, 58, 4, 0xa5a5a5a5a5a59ddc)
	EXT( 0xa5a5a5a5a5a59dcf, 58, 5, 0x0000000000000007)
	EXTU(0xa5a5a5a5a5a59dcf, 58, 5, 0x0000000000000007)
	DEP( 0xa5a5a5a5a5a59dcf, 15, 58, 5, 0xa5a5a5a5a5a59ddf)
	EXT( 0xa5a5a5a5a5a59dce, 59, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dce, 59, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dce, 0, 59, 1, 0xa5a5a5a5a5a59dce)
	EXT( 0xa5a5a5a5a5a59dcd, 59, 2, 0x0000000000000001)
	EXTU(0xa5a5a5a5a5a59dcd, 59, 2, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dcd, 1, 59, 2, 0xa5a5a5a5a5a59dcd)
	EXT( 0xa5a5a5a5a5a59dcc, 59, 3, 0x0000000000000003)
	EXTU(0xa5a5a5a5a5a59dcc, 59, 3, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59dcc, 3, 59, 3, 0xa5a5a5a5a5a59dcc)
	EXT( 0xa5a5a5a5a5a59dcb, 59, 4, 0x0000000000000005)
	EXTU(0xa5a5a5a5a5a59dcb, 59, 4, 0x0000000000000005)
	DEP( 0xa5a5a5a5a5a59dcb, 7, 59, 4, 0xa5a5a5a5a5a59dcf)
	EXT( 0xa5a5a5a5a5a59dca, 60, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dca, 60, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dca, 0, 60, 1, 0xa5a5a5a5a5a59dc2)
	EXT( 0xa5a5a5a5a5a59dc9, 60, 2, 0xfffffffffffffffe)
	EXTU(0xa5a5a5a5a5a59dc9, 60, 2, 0x0000000000000002)
	DEP( 0xa5a5a5a5a5a59dc9, 1, 60, 2, 0xa5a5a5a5a5a59dc5)
	EXT( 0xa5a5a5a5a5a59dc8, 60, 3, 0xfffffffffffffffc)
	EXTU(0xa5a5a5a5a5a59dc8, 60, 3, 0x0000000000000004)
	DEP( 0xa5a5a5a5a5a59dc8, 3, 60, 3, 0xa5a5a5a5a5a59dc6)
	EXT( 0xa5a5a5a5a5a59dc7, 61, 1, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dc7, 61, 1, 0x0000000000000001)
	DEP( 0xa5a5a5a5a5a59dc7, 0, 61, 1, 0xa5a5a5a5a5a59dc3)
	EXT( 0xa5a5a5a5a5a59dc6, 61, 2, 0xffffffffffffffff)
	EXTU(0xa5a5a5a5a5a59dc6, 61, 2, 0x0000000000000003)
	DEP( 0xa5a5a5a5a5a59dc6, 1, 61, 2, 0xa5a5a5a5a5a59dc2)
	EXT( 0xa5a5a5a5a5a59dc5, 62, 1, 0x0000000000000000)
	EXTU(0xa5a5a5a5a5a59dc5, 62, 1, 0x0000000000000000)
	DEP( 0xa5a5a5a5a5a59dc5, 0, 62, 1, 0xa5a5a5a5a5a59dc5)
#    endif
#  endif
#endif
	prepare
		pushargi ok
	finishi @printf
	ret
	epilog
#endif
