/* A Bison parser, made from /home/bettini/work/src2tags/src/lib/optparser.yy
   by GNU bison 1.35.  */

#define YYBISON 1  /* Identify Bison output.  */

# define	BOLD	257
# define	ITALICS	258
# define	UNDERLINE	259
# define	KEY	260
# define	COLOR	261


/*
 * Copyright (C) 1999, 2000, 2001 Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <string.h>
#include <iostream>

#include "my_sstream.h"

#include "tags.h"
#include "colors.h"
#include "keys.h"
#include "messages.h"

using std::cerr;

static int opsc_parse() ;
static void opsc_error( char *s ) ;

int line = 0 ;

void parseTags() ;

static FILE *openTagsFile() ;

extern int opsc_lex() ;
extern FILE *opsc_in ;


#ifndef YYSTYPE
typedef union {
  int tok ; /* command */
  char * string ; /* string : id, ... */
  int flag ;
  Tag *tag ;
  Tags *tags ;
} opsc_stype;
# define YYSTYPE opsc_stype
# define YYSTYPE_IS_TRIVIAL 1
#endif
#ifndef YYDEBUG
# define YYDEBUG 0
#endif



#define	YYFINAL		17
#define	YYFLAG		-32768
#define	YYNTBASE	10

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 261 ? yytranslate[x] : 16)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     9,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     8,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7
};

#if YYDEBUG
static const short yyprhs[] =
{
       0,     0,     2,     5,     7,     8,    14,    18,    20,    21,
      23,    25
};
static const short yyrhs[] =
{
      11,     0,    11,    12,     0,    12,     0,     0,     6,     7,
      13,    14,     8,     0,    14,     9,    15,     0,    15,     0,
       0,     3,     0,     4,     0,     5,     0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,    65,    68,    69,    72,    72,    84,    85,    88,    89,
      90,    91
};
#endif


#if (YYDEBUG) || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "BOLD", "ITALICS", "UNDERLINE", "KEY", 
  "COLOR", "';'", "','", "globaltags", "options", "option", "@1", 
  "values", "value", 0
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,    10,    11,    11,    13,    12,    14,    14,    15,    15,
      15,    15
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     1,     2,     1,     0,     5,     3,     1,     0,     1,
       1,     1
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short opsc_defact[] =
{
       0,     0,     1,     3,     4,     2,     8,     9,    10,    11,
       0,     7,     5,     8,     6,     0,     0,     0
};

static const short opsc_defgoto[] =
{
      15,     2,     3,     6,    10,    11
};

static const short opsc_pact[] =
{
      -1,     0,    -1,-32768,-32768,-32768,    -3,-32768,-32768,-32768,
      -5,-32768,-32768,    -3,-32768,     6,     8,-32768
};

static const short opsc_pgoto[] =
{
  -32768,-32768,     7,-32768,-32768,    -2
};


#define	YYLAST		11


static const short opsc_table[] =
{
       7,     8,     9,    12,    13,     1,    16,     4,    17,     5,
       0,    14
};

static const short opsc_check[] =
{
       3,     4,     5,     8,     9,     6,     0,     7,     0,     2,
      -1,    13
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */

/* Skeleton output parser for bison,

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software
   Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#if ! defined (yyoverflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || defined (YYERROR_VERBOSE) */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short opsc_ss;
  YYSTYPE opsc_vs;
# if YYLSP_NEEDED
  YYLTYPE yyls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, opsc_size);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = opsc_stacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(opsc_char = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call opsc_error.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (opsc_char == YYEMPTY && opsc_len == 1)				\
    {								\
      opsc_char = (Token);						\
      opsc_lval = (Value);						\
      opsc_char1 = YYTRANSLATE (opsc_char);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      opsc_error ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `opsc_lex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		opsc_lex (&opsc_lval, &opsc_lloc, YYLEX_PARAM)
#  else
#   define YYLEX		opsc_lex (&opsc_lval, &opsc_lloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		opsc_lex (&opsc_lval, YYLEX_PARAM)
#  else
#   define YYLEX		opsc_lex (&opsc_lval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			opsc_lex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (opsc_debug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int opsc_debug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#ifdef YYERROR_VERBOSE

# ifndef opsc_strlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define opsc_strlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
opsc_strlen (const char *opsc_str)
#   else
opsc_strlen (opsc_str)
     const char *opsc_str;
#   endif
{
  register const char *opsc_s = opsc_str;

  while (*opsc_s++ != '\0')
    continue;

  return opsc_s - opsc_str - 1;
}
#  endif
# endif

# ifndef opsc_stpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define opsc_stpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
opsc_stpcpy (char *yydest, const char *opsc_src)
#   else
opsc_stpcpy (yydest, opsc_src)
     char *yydest;
     const char *opsc_src;
#   endif
{
  register char *yyd = yydest;
  register const char *opsc_s = opsc_src;

  while ((*yyd++ = *opsc_s++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif
#endif



/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into opsc_parse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int opsc_parse (void *);
# else
int opsc_parse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int opsc_char;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE opsc_lval;						\
							\
/* Number of parse errors so far.  */			\
int opsc_nerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE opsc_lloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
opsc_parse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int opsc_state;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int opsc_char1 = 0;

  /* Three stacks and their tools:
     `opsc_ss': related to states,
     `opsc_vs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	opsc_ssa[YYINITDEPTH];
  short *opsc_ss = opsc_ssa;
  register short *opsc_ssp;

  /* The semantic value stack.  */
  YYSTYPE opsc_vsa[YYINITDEPTH];
  YYSTYPE *opsc_vs = opsc_vsa;
  register YYSTYPE *opsc_vsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (opsc_vsp--, opsc_ssp--, yylsp--)
#else
# define YYPOPSTACK   (opsc_vsp--, opsc_ssp--)
#endif

  YYSIZE_T opsc_stacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE opsc_val;
#if YYLSP_NEEDED
  YYLTYPE yyloc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int opsc_len;

  YYDPRINTF ((stderr, "Starting parse\n"));

  opsc_state = 0;
  yyerrstatus = 0;
  opsc_nerrs = 0;
  opsc_char = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  opsc_ssp = opsc_ss;
  opsc_vsp = opsc_vs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto opsc_setstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in opsc_state.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  opsc_ssp++;

 opsc_setstate:
  *opsc_ssp = opsc_state;

  if (opsc_ssp >= opsc_ss + opsc_stacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T opsc_size = opsc_ssp - opsc_ss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *opsc_vs1 = opsc_vs;
	short *opsc_ss1 = opsc_ss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *yyls1 = yyls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &opsc_ss1, opsc_size * sizeof (*opsc_ssp),
		    &opsc_vs1, opsc_size * sizeof (*opsc_vsp),
		    &yyls1, opsc_size * sizeof (*yylsp),
		    &opsc_stacksize);
	yyls = yyls1;
# else
	yyoverflow ("parser stack overflow",
		    &opsc_ss1, opsc_size * sizeof (*opsc_ssp),
		    &opsc_vs1, opsc_size * sizeof (*opsc_vsp),
		    &opsc_stacksize);
# endif
	opsc_ss = opsc_ss1;
	opsc_vs = opsc_vs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (opsc_stacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      opsc_stacksize *= 2;
      if (opsc_stacksize > YYMAXDEPTH)
	opsc_stacksize = YYMAXDEPTH;

      {
	short *opsc_ss1 = opsc_ss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (opsc_stacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (opsc_ss);
	YYSTACK_RELOCATE (opsc_vs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (yyls);
# endif
# undef YYSTACK_RELOCATE
	if (opsc_ss1 != opsc_ssa)
	  YYSTACK_FREE (opsc_ss1);
      }
# endif
#endif /* no yyoverflow */

      opsc_ssp = opsc_ss + opsc_size - 1;
      opsc_vsp = opsc_vs + opsc_size - 1;
#if YYLSP_NEEDED
      yylsp = yyls + opsc_size - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) opsc_stacksize));

      if (opsc_ssp >= opsc_ss + opsc_stacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", opsc_state));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = opsc_pact[opsc_state];
  if (yyn == YYFLAG)
    goto opsc_default;

  /* Not known => get a lookahead token if don't already have one.  */

  /* opsc_char is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (opsc_char == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      opsc_char = YYLEX;
    }

  /* Convert token to internal form (in opsc_char1) for indexing tables with */

  if (opsc_char <= 0)		/* This means end of input. */
    {
      opsc_char1 = 0;
      opsc_char = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      opsc_char1 = YYTRANSLATE (opsc_char);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (opsc_debug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     opsc_char, yytname[opsc_char1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, opsc_char, opsc_lval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  yyn += opsc_char1;
  if (yyn < 0 || yyn > YYLAST || opsc_check[yyn] != opsc_char1)
    goto opsc_default;

  yyn = opsc_table[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      opsc_char, yytname[opsc_char1]));

  /* Discard the token being shifted unless it is eof.  */
  if (opsc_char != YYEOF)
    opsc_char = YYEMPTY;

  *++opsc_vsp = opsc_lval;
#if YYLSP_NEEDED
  *++yylsp = opsc_lloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  opsc_state = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| opsc_default -- do the default action for the current state.  |
`-----------------------------------------------------------*/
opsc_default:
  yyn = opsc_defact[opsc_state];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  opsc_len = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  opsc_val = opsc_vsp[1-opsc_len];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-opsc_len];
  YYLLOC_DEFAULT (yyloc, (yylsp - opsc_len), opsc_len);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (opsc_debug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] > 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 1:
{ setTags( opsc_vsp[0].tags ) ; }
    break;
case 2:
{ opsc_vsp[-1].tags->AddTag( opsc_vsp[0].tag ) ; }
    break;
case 3:
{ opsc_val.tags = new Tags() ; opsc_val.tags->AddTag( opsc_vsp[0].tag ) ;  }
    break;
case 4:
{
                 printMessage( opsc_vsp[-1].string ) ;
                 printMessage( opsc_vsp[0].string ) ;
             }
    break;
case 5:
{
	       opsc_val.tag = new Tag( opsc_vsp[-4].string, opsc_vsp[-3].string ) ;
               opsc_val.tag->SetFlags(opsc_vsp[-1].flag) ;
	     }
    break;
case 6:
{ opsc_val.flag = opsc_vsp[-2].flag | opsc_vsp[0].flag ; }
    break;
case 8:
{ opsc_val.flag = 0 ; printMessage( " (no options) " ) ; }
    break;
case 9:
{ printMessage( " - bold" ) ; opsc_val.flag = ISBOLD ; }
    break;
case 10:
{ printMessage( " - italics" ) ; opsc_val.flag = ISITALIC ; }
    break;
case 11:
{ printMessage( " - underline" ) ; opsc_val.flag = ISUNDERLINE ; }
    break;
}



  opsc_vsp -= opsc_len;
  opsc_ssp -= opsc_len;
#if YYLSP_NEEDED
  yylsp -= opsc_len;
#endif

#if YYDEBUG
  if (opsc_debug)
    {
      short *opsc_ssp1 = opsc_ss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (opsc_ssp1 != opsc_ssp)
	YYFPRINTF (stderr, " %d", *++opsc_ssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++opsc_vsp = opsc_val;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  opsc_state = opsc_pgoto[yyn - YYNTBASE] + *opsc_ssp;
  if (opsc_state >= 0 && opsc_state <= YYLAST && opsc_check[opsc_state] == *opsc_ssp)
    opsc_state = opsc_table[opsc_state];
  else
    opsc_state = opsc_defgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++opsc_nerrs;

#ifdef YYERROR_VERBOSE
      yyn = opsc_pact[opsc_state];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  YYSIZE_T opsc_size = 0;
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (opsc_check[yyx + yyn] == yyx)
	      opsc_size += opsc_strlen (yytname[yyx]) + 15, yycount++;
	  opsc_size += opsc_strlen ("parse error, unexpected ") + 1;
	  opsc_size += opsc_strlen (yytname[YYTRANSLATE (opsc_char)]);
	  yymsg = (char *) YYSTACK_ALLOC (opsc_size);
	  if (yymsg != 0)
	    {
	      char *yyp = opsc_stpcpy (yymsg, "parse error, unexpected ");
	      yyp = opsc_stpcpy (yyp, yytname[YYTRANSLATE (opsc_char)]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (opsc_check[yyx + yyn] == yyx)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = opsc_stpcpy (yyp, yyq);
			yyp = opsc_stpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      opsc_error (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    opsc_error ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	opsc_error ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (opsc_char == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  opsc_char, yytname[opsc_char1]));
      opsc_char = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = opsc_defact[opsc_state];
  if (yyn)
    goto opsc_default;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (opsc_ssp == opsc_ss)
    YYABORT;
  opsc_vsp--;
  opsc_state = *--opsc_ssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (opsc_debug)
    {
      short *opsc_ssp1 = opsc_ss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (opsc_ssp1 != opsc_ssp)
	YYFPRINTF (stderr, " %d", *++opsc_ssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = opsc_pact[opsc_state];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || opsc_check[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = opsc_table[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++opsc_vsp = opsc_lval;
#if YYLSP_NEEDED
  *++yylsp = opsc_lloc;
#endif

  opsc_state = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

/*---------------------------------------------.
| yyoverflowab -- parser overflow comes here.  |
`---------------------------------------------*/
yyoverflowlab:
  opsc_error ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */

yyreturn:
#ifndef yyoverflow
  if (opsc_ss != opsc_ssa)
    YYSTACK_FREE (opsc_ss);
#endif
  return yyresult;
}


// this should be passed by the compiler
#ifndef SOURCE_HIGHLIGHT_DATA_DIR
#define SOURCE_HIGHLIGHT_DATA_DIR "."
#endif

#define TAGS_FILE "tags.j2h"

extern char *tags_file;

void
parseTags()
{

  // opens the file for opsc_lex
  opsc_in = openTagsFile() ;
  if (! opsc_in) {
    printWarning( "No tags.j2h file, using defaults ...", cerr ) ;
    setTags( NULL ) ;
    return ;
  }

  printMessage_noln( "Parsing ", cerr ) ;
  if (tags_file)
    printMessage_noln (tags_file, cerr);
  else
    printMessage_noln (TAGS_FILE, cerr);
  printMessage( " file ...", cerr ) ;
  opsc_parse() ;
  printMessage( "Parsing done!", cerr ) ;
}

FILE *
openTagsFile()
{
  FILE *file = 0;

  printMessage( "Trying with..." ) ;

  if ( tags_file )
    {
      printMessage (tags_file);
      file = fopen (tags_file, "r");
      if (file)
        return file;
    }

  printMessage( TAGS_FILE ) ;
  file = fopen( TAGS_FILE, "r") ;
  if ( file )
    return file ;

  file = fopen( SOURCE_HIGHLIGHT_DATA_DIR "/" TAGS_FILE, "r") ;
  printMessage( SOURCE_HIGHLIGHT_DATA_DIR "/" TAGS_FILE ) ;

  return file ;
}

void
opsc_error( char *s )
{
  ostringstream str ;
  str << "*** " << s << " on option # " << line;
  printError( str.str().c_str(), cerr ) ;
  printError( "Using default tags...", cerr ) ;
}
