/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os.unix;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.os.unix.UnixConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;

public class UnixHelper {
    public static String whichCommand = FileExecutor.getExecOutput(new String[]{"/usr/bin/env", "which", "which"}, false).trim();
    public static final String VERSION = "$Revision: 1708 $";

    public static ArrayList getEtcPasswdArray() {
        ArrayList<String> result = new ArrayList<String>();
        String line = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(UnixConstants.etcPasswd));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static ArrayList getYpPasswdArray() {
        ArrayList<String> result = new ArrayList<String>();
        String line = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(FileExecutor.getExecOutput(new String[]{UnixHelper.getYpCatCommand(), "passwd"})));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean kdeIsInstalled() {
        FileExecutor fe = new FileExecutor();
        String[] execOut = new String[2];
        int execResult = fe.executeCommand(new String[]{"/usr/bin/env", "konqueror", "--version"}, execOut);
        return execResult == 0;
    }

    public static String getWhichCommand() {
        return whichCommand;
    }

    public static String getCpCommand() {
        return FileExecutor.getExecOutput(new String[]{UnixHelper.getWhichCommand(), "cp"}).trim();
    }

    public static String getSuCommand() {
        return FileExecutor.getExecOutput(new String[]{UnixHelper.getWhichCommand(), "su"}).trim();
    }

    public static String getRmCommand() {
        return FileExecutor.getExecOutput(new String[]{whichCommand, "rm"}).trim();
    }

    public static String getYpCatCommand() {
        return FileExecutor.getExecOutput(new String[]{whichCommand, "ypcat"}).trim();
    }

    public static String getCustomCommand(String aCommand) {
        return FileExecutor.getExecOutput(new String[]{whichCommand, aCommand}).trim();
    }

    public static void main(String[] args) {
        System.out.println("Hallo from " + UnixHelper.class.getName() + VERSION);
        System.out.println("WhichCommand: '" + UnixHelper.getWhichCommand() + "'");
        System.out.println("SuCommand: " + UnixHelper.getSuCommand());
        System.out.println("RmCommand: " + UnixHelper.getRmCommand());
        System.out.println("CopyCommand: " + UnixHelper.getCpCommand());
        System.out.println("YpCommand: " + UnixHelper.getYpCatCommand());
        System.out.println("CustomCommand: " + UnixHelper.getCustomCommand("cat"));
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UnixHelper.class.getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Tempfile: " + tempFile.toString());
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(tempFile));
            w.write("Hallo");
            w.flush();
            w.close();
            if (tempFile.exists()) {
                System.out.println("Wrote: " + tempFile + ">>Hallo");
            } else {
                System.out.println("Could not Wrote: " + tempFile + "Hallo");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String destfilename = "/home/marc.eppelmann" + File.separator + "Desktop";
        System.out.println("Copy: " + tempFile.toString() + " to " + destfilename);
        String result = FileExecutor.getExecOutput(new String[]{UnixHelper.getSuCommand(), "marc.eppelmann", "-c", "\"" + UnixHelper.getCpCommand() + " " + tempFile.toString() + " " + destfilename + "\""});
        System.out.println("Wrote: " + tempFile.toString() + " to " + destfilename + " > " + result);
    }
}

