/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.corba.TypeCodeImpl;
import com.sun.corba.se.internal.core.ClientSubcontract;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.MarshalOutputStream;
import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.orbutil.CacheTable;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import com.sun.corba.se.internal.orbutil.RepositoryIdWrapper;
import com.sun.corba.se.internal.orbutil.RepositoryId_1_3;
import com.sun.corba.se.internal.orbutil.ValueHandlerImpl_1_3;
import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public class CDROutputStream
extends org.omg.CORBA_2_3.portable.OutputStream
implements MarshalOutputStream,
DataOutputStream {
    protected boolean littleEndian;
    protected int size;
    protected int buflen;
    protected int offset;
    protected byte[] buf;
    protected org.omg.CORBA.ORB orb;
    protected int blockSizeIndex = -1;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private CacheTable codebaseCache = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private int end_flag = 0;
    private boolean mustChunk = false;
    private boolean inBlock = false;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private static String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static String[] _ids = new String[]{_id};
    static /* synthetic */ Class class$org$omg$CORBA$portable$OutputStream;

    public CDROutputStream(org.omg.CORBA.ORB oRB) {
        this(oRB, false);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl) {
        this(oRB, bl, 1024);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl, int n) {
        this.orb = oRB;
        this.littleEndian = bl;
        this.buf = new byte[n];
        this.size = 0;
        this.buflen = n;
        this.offset = 0;
    }

    public org.omg.CORBA.ORB getORB() {
        return this.orb;
    }

    public CDROutputStream() {
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.buf, 0, byArray, 0, this.size);
        return byArray;
    }

    private final void alignAndReserve(int n, int n2) {
        int n3;
        if (n > 1 && (n3 = this.size & n - 1) != 0) {
            n3 = n - n3;
            this.size += n3;
        }
        if (this.size + n2 >= this.buflen) {
            this.grow(n, n2);
        }
    }

    protected void grow(int n, int n2) {
        if (this.buf == null) {
            int n3 = 1024;
            while (this.size + n2 >= n3) {
                n3 *= 2;
            }
            this.buf = new byte[n3];
            this.buflen = this.buf.length;
            return;
        }
        byte[] byArray = this.buf;
        int n4 = byArray.length * 2;
        while (this.size + n2 >= n4) {
            n4 *= 2;
        }
        this.buf = new byte[n4];
        System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
        this.buflen = this.buf.length;
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    public InputStream create_input_stream() {
        if (this.codebaseCache != null) {
            this.codebaseCache.done();
        }
        if (this.valueCache != null) {
            this.valueCache.done();
        }
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
        return new CDRInputStream(this.orb, this.buf, this.size, this.littleEndian);
    }

    public final void write_longdouble(double d) {
        throw new NO_IMPLEMENT(0x53550003, CompletionStatus.COMPLETED_MAYBE);
    }

    public final void write_octet(byte by) {
        if (this.size + 1 >= this.buflen) {
            this.alignAndReserve(1, 1);
        }
        this.buf[this.size++] = by;
    }

    public final void write_boolean(boolean bl) {
        this.write_octet(bl ? (byte)1 : 0);
    }

    public final void write_char(char c) {
        if (c > '\u00ff') {
            throw new DATA_CONVERSION(1398079494, CompletionStatus.COMPLETED_NO);
        }
        this.write_octet((byte)(c & 0xFF));
    }

    private final void writeLittleEndianWchar(char c) {
        this.buf[this.size++] = (byte)(c & 0xFF);
        this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
    }

    private final void writeBigEndianWchar(char c) {
        this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(c & 0xFF);
    }

    private final void writeLittleEndianShort(short s) {
        this.buf[this.size++] = (byte)(s & 0xFF);
        this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
    }

    private final void writeBigEndianShort(short s) {
        this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(s & 0xFF);
    }

    private final void writeLittleEndianLong(int n) {
        this.buf[this.size++] = (byte)(n & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
    }

    private final void writeBigEndianLong(int n) {
        this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(n & 0xFF);
    }

    private final void writeLittleEndianLongLong(long l) {
        this.buf[this.size++] = (byte)(l & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
    }

    private final void writeBigEndianLongLong(long l) {
        this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
        this.buf[this.size++] = (byte)(l & 0xFFL);
    }

    public final void write_wchar(char c) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianWchar(c);
        } else {
            this.writeBigEndianWchar(c);
        }
    }

    public final void write_short(short s) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianShort(s);
        } else {
            this.writeBigEndianShort(s);
        }
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_long(int n) {
        if ((this.size & 3) != 0 || this.size + 4 >= this.buflen) {
            this.alignAndReserve(4, 4);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_longlong(long l) {
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.writeLittleEndianLongLong(l);
        } else {
            this.writeBigEndianLongLong(l);
        }
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public final void write_string(String string) {
        int n;
        if (string == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        int n2 = this.size & 3;
        if (n2 != 0) {
            n2 = 4 - n2;
            this.size += n2;
        }
        if (this.size + 4 + (n = string.length() + 1) >= this.buflen) {
            this.alignAndReserve(4, 4 + n);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
        --n;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c > '\u00ff') {
                throw new DATA_CONVERSION(1398079494, CompletionStatus.COMPLETED_NO);
            }
            this.buf[this.size++] = (byte)(c & 0xFF);
            ++n3;
        }
        this.buf[this.size++] = 0;
    }

    public final void write_wstring(String string) {
        int n;
        if (string == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        int n2 = this.size & 3;
        if (n2 != 0) {
            n2 = 4 - n2;
            this.size += n2;
        }
        if (this.size + 4 + (n = string.length() + 1) * 2 >= this.buflen) {
            this.alignAndReserve(4, 4 + n * 2);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
            --n;
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                this.buf[this.size++] = (byte)(c & 0xFF);
                this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
                ++n3;
            }
        } else {
            this.writeBigEndianLong(n);
            --n;
            int n4 = 0;
            while (n4 < n) {
                char c = string.charAt(n4);
                this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
                this.buf[this.size++] = (byte)(c & 0xFF);
                ++n4;
            }
        }
        this.buf[this.size++] = 0;
        this.buf[this.size++] = 0;
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = n;
        while (n3 < n2 + n) {
            int n4;
            int n5;
            if (this.size + 1 >= this.buflen) {
                this.alignAndReserve(1, 1);
            }
            int n6 = (n5 = n2 + n - n3) < (n4 = this.buf.length - this.size) ? n5 : n4;
            System.arraycopy(byArray, n3, this.buf, this.size, n6);
            this.size += n6;
            n3 += n6;
        }
    }

    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this);
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR.NULL.write(this);
            return;
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        try {
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clientSubcontract == null) {
            if (object instanceof Stub) {
                try {
                    ((Stub)object).connect(this.orb);
                }
                catch (RemoteException remoteException) {
                    throw new MARSHAL(0, CompletionStatus.COMPLETED_MAYBE);
                }
            } else {
                this.orb.connect(object);
            }
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
        }
        IOR iOR = clientSubcontract.marshal();
        iOR.write(this);
    }

    public void write_abstract_interface(java.lang.Object object) {
        boolean bl = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl = true;
        }
        this.write_boolean(bl);
        if (bl) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                Utility.throwNotSerializableForCorba();
            }
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    public void write_value(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.write_long(-1);
            this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
            return;
        }
        Class clazz = serializable.getClass();
        boolean bl = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = this.createValueHandler();
            }
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createSequenceRepID(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createSequenceRepID(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string2 = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string2);
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            this.writeIDLValue(serializable, string2);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            if (ORBUtility.isLegacyORB((ORB)this.orb)) {
                this.writeClass(RepositoryId_1_3.kClassDescValueRepID, (Class)serializable);
            } else {
                this.writeClass(RepositoryId.kClassDescValueRepID, (Class)serializable);
            }
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = this.createValueHandler();
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.write_long(-1);
                    this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createForJavaType(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.start_block();
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createForJavaType(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.write_long(-1);
            this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
            return;
        }
        Class clazz = serializable.getClass();
        boolean bl = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = this.createValueHandler();
            }
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createSequenceRepID(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createSequenceRepID(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string);
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            this.writeIDLValue(serializable, string);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            if (ORBUtility.isLegacyORB((ORB)this.orb)) {
                this.writeClass(RepositoryId_1_3.kClassDescValueRepID, (Class)serializable);
            } else {
                this.writeClass(RepositoryId.kClassDescValueRepID, (Class)serializable);
            }
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = this.createValueHandler();
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.write_long(-1);
                    this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createForJavaType(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.start_block();
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryIdWrapper.createForJavaType(this.orb, clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        int n;
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.write_long(-1);
            this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
            return;
        }
        boolean bl = this.mustChunk;
        boolean bl2 = false;
        if (boxedValueHelper instanceof ValueHelper) {
            try {
                n = ((ValueHelper)boxedValueHelper).get_type().type_modifier();
            }
            catch (BadKind badKind) {
                n = 0;
            }
            if (serializable instanceof CustomMarshal && n == 1) {
                bl2 = true;
                this.mustChunk = true;
            }
            if (n == 3) {
                this.mustChunk = true;
            }
        }
        if (this.mustChunk) {
            if (this.inBlock) {
                this.end_block();
            }
            n = this.writeValueTag(true, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            if (bl2) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this);
            } else {
                boxedValueHelper.write_value(this, serializable);
            }
            this.end_block();
            this.writeEndTag(true);
        } else {
            n = this.writeValueTag(false, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n, serializable, serializable);
            --this.end_flag;
            boxedValueHelper.write_value(this, serializable);
            this.writeEndTag(false);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public int get_offset() {
        return this.offset + this.size;
    }

    public void start_block() {
        this.inBlock = true;
        this.write_long(0);
        this.blockSizeIndex = this.size;
    }

    public void end_block() {
        if (!this.inBlock) {
            return;
        }
        this.inBlock = false;
        if (this.size == this.blockSizeIndex) {
            this.size -= 4;
            this.blockSizeIndex = -1;
            return;
        }
        int n = this.size;
        this.size = this.blockSizeIndex - 4;
        this.write_long(n - this.blockSizeIndex);
        this.size = n;
        this.blockSizeIndex = -1;
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.size + n2 >= this.buflen) {
            this.alignAndReserve(1, n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.buf[this.size++] = blArray[n3 + n] ? (byte)1 : 0;
            ++n3;
        }
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.size + n2 >= this.buflen) {
            this.alignAndReserve(1, n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3 + n];
            if (c > '\u00ff') {
                throw new DATA_CONVERSION(1398079494, CompletionStatus.COMPLETED_NO);
            }
            this.buf[this.size++] = (byte)(c & 0xFF);
            ++n3;
        }
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(2, n2 * 2);
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianWchar(cArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianWchar(cArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(2, n2 * 2);
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianShort(sArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianShort(sArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(4, n2 * 4);
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLong(nArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLong(nArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(8, n2 * 8);
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLongLong(lArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLongLong(lArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(4, n2 * 4);
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLong(Float.floatToIntBits(fArray[n3 + n]));
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLong(Float.floatToIntBits(fArray[n4 + n]));
                ++n4;
            }
        }
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(8, n2 * 8);
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLongLong(Double.doubleToLongBits(dArray[n3 + n]));
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLongLong(Double.doubleToLongBits(dArray[n4 + n]));
                ++n4;
            }
        }
    }

    public void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_string(stringArray[n3 + n]);
            ++n3;
        }
    }

    public void write_wstring_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM(1398079489, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_wstring(stringArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_any_array(Any[] anyArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.write_any(anyArray[n3 + n]);
            ++n3;
        }
    }

    public final void reset() {
        this.offset += this.size;
        this.size = 0;
        this.end_flag = 0;
        this.end_flag_index = 0;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.size);
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        outputStream.write_long(this.size);
        outputStream.write_octet_array(this.buf, 0, this.size);
    }

    public final int getSize() {
        return this.size;
    }

    protected byte[] getBuffer() {
        return this.buf;
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(true);
        }
        this.valueCache.put(object, n);
        if (object2 != object) {
            this.valueCache.put(object2, n);
        }
    }

    private final void write_repositoryId(String string) {
        byte[] byArray;
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            this.write_long(-1);
            this.write_long(this.repositoryIdCache.getVal(string) - this.get_offset());
            return;
        }
        int n = this.size & 3;
        if (n != 0) {
            n = 4 - n;
            this.size += n;
        }
        if ((byArray = RepositoryId.getByteArray(string)) == null) {
            int n2 = string.length() + 1;
            byArray = new byte[4 + n2];
            int n3 = 0;
            if (this.littleEndian) {
                byArray[n3++] = (byte)(n2 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
            } else {
                byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
                byArray[n3++] = (byte)(n2 & 0xFF);
            }
            --n2;
            int n4 = 0;
            while (n4 < n2) {
                char c = string.charAt(n4);
                if (c > '\u00ff') {
                    throw new DATA_CONVERSION(1398079494, CompletionStatus.COMPLETED_NO);
                }
                byArray[n3++] = (byte)(c >>> 0 & 0xFF);
                ++n4;
            }
            byArray[n3++] = 0;
            RepositoryId.setByteArray(string, byArray);
        }
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(true);
        }
        this.repositoryIdCache.put(string, this.get_offset());
        this.write_octet_array(byArray, 0, byArray.length);
    }

    private void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            this.write_long(-1);
            this.write_long(this.codebaseCache.getVal(string) - this.get_offset());
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new CacheTable(true);
            }
            this.codebaseCache.put(string, n);
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, String string) {
        int n = 0;
        if (bl && bl2) {
            if (string == null) {
                this.write_long(RepositoryId.kPreComputed_StandardRMIChunked_NoRep);
                n = this.get_offset() - 4;
            } else {
                this.write_long(RepositoryId.kPreComputed_CodeBaseRMIChunked_NoRep);
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && !bl2) {
            if (string == null) {
                this.write_long(RepositoryId.kPreComputed_StandardRMIChunked);
                n = this.get_offset() - 4;
            } else {
                this.write_long(RepositoryId.kPreComputed_CodeBaseRMIChunked);
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            this.write_long(RepositoryId.kPreComputed_StandardRMIUnchunked);
            n = this.get_offset() - 4;
        } else {
            this.write_long(RepositoryId.kPreComputed_CodeBaseRMIUnchunked);
            n = this.get_offset() - 4;
            this.write_codebase(string, this.get_offset());
        }
        return n;
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write(this);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal(this);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boolean bl = false;
            if (boxedValueHelper instanceof ValueHelper && serializable instanceof CustomMarshal) {
                try {
                    if (((ValueHelper)boxedValueHelper).get_type().type_modifier() == 1) {
                        bl = true;
                    }
                }
                catch (BadKind badKind) {
                    throw new MARSHAL();
                }
            }
            if (bl) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this);
            } else {
                boxedValueHelper.write_value(this, serializable);
            }
        }
    }

    private void writeEndTag(boolean bl) {
        if (bl) {
            if (this.size == this.end_flag_index) {
                this.size -= 4;
            }
            this.write_long(this.end_flag);
        }
        this.end_flag_index = this.size;
        ++this.end_flag;
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else if (ORBUtility.isLegacyORB((ORB)this.orb)) {
                this.write_repositoryId(RepositoryId_1_3.kClassDescValueRepID);
            } else {
                this.write_repositoryId(RepositoryId.kClassDescValueRepID);
            }
            this.start_block();
            --this.end_flag;
            this.write_value((Serializable)((java.lang.Object)RepositoryIdWrapper.createForAnyType(this.orb, clazz)));
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
            this.end_block();
            this.writeEndTag(true);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else if (ORBUtility.isLegacyORB((ORB)this.orb)) {
                this.write_repositoryId(RepositoryId_1_3.kClassDescValueRepID);
            } else {
                this.write_repositoryId(RepositoryId.kClassDescValueRepID);
            }
            --this.end_flag;
            this.write_value((Serializable)((java.lang.Object)RepositoryIdWrapper.createForAnyType(this.orb, clazz)));
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
            this.writeEndTag(false);
        }
    }

    private boolean shouldWriteAsIDLEntity(Serializable serializable) {
        return serializable instanceof IDLEntity && !(serializable instanceof ValueBase) && !(serializable instanceof Object);
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        String string = RepositoryIdWrapper.createForJavaType(this.orb, iDLEntity);
        Class clazz = iDLEntity.getClass();
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, false, string2);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.write_repositoryId(string);
        --this.end_flag;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            Class[] classArray = new Class[]{class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = CDROutputStream.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, clazz};
            Method method = clazz2.getDeclaredMethod(kWriteMethod, classArray);
            java.lang.Object[] objectArray = new java.lang.Object[]{this, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MARSHAL(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MARSHAL(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MARSHAL(invocationTargetException.getMessage());
        }
        this.end_block();
        this.writeEndTag(true);
    }

    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public String[] _truncatable_ids() {
        return _ids;
    }

    public void printBuffer() {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < 16) {
                String string;
                int n3 = this.buf[n + n2];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                if ((string = Integer.toHexString(n3)).length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
                ++n2;
            }
            System.out.println(new String(this.buf, n, 16));
            n += 16;
        }
    }

    private ValueHandler createValueHandler() {
        if (ORBUtility.isLegacyORB((ORB)this.orb)) {
            return new ValueHandlerImpl_1_3();
        }
        return Util.createValueHandler();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

