/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import sun.awt.font.ArabicLigaturizer;
import sun.awt.font.NewArabicShaping;
import sun.awt.font.Segment;
import sun.awt.font.TextSource;

public class Shaping {
    private static char[] mirrorPairs = new char[]{'(', ')', '<', '>', '[', ']', '{', '}', '\u2045', '\u2046', '\u207d', '\u207e', '\u208d', '\u208e', '\u2264', '\u2265', '\u3008', '\u3009', '\u300a', '\u300b', '\u300c', '\u300d', '\u300e', '\u300f', '\u3010', '\u3011', '\u3014', '\u3015', '\u3016', '\u3017', '\u3018', '\u3019', '\u301a', '\u301b'};

    /*
     * Unable to fully structure code
     */
    public static void markSegment(Segment var0, boolean var1_1) {
        var2_2 = var0.text;
        var4_4 = var3_3 = var0.start;
        var5_5 = var4_4 + var0.length;
        if (var1_1) ** GOTO lbl25
        while (var4_4 < var5_5) {
            var6_6 = var2_2[var4_4];
            if (Shaping.isFormatMark(var6_6)) {
                var7_7 = new char[var0.length];
                System.arraycopy(var2_2, var0.start, var7_7, 0, var0.length);
                var2_2 = var7_7;
                var4_4 -= var0.start;
                var5_5 -= var0.start;
                var2_2[var4_4++] = 65535;
                var0.text = var2_2;
                var0.start = 0;
                break;
            }
            ++var4_4;
        }
        if (var4_4 != var5_5) ** GOTO lbl25
        return;
lbl-1000:
        // 1 sources

        {
            var6_6 = var2_2[var4_4];
            if (Shaping.isFormatMark(var6_6)) {
                var2_2[var4_4] = 65535;
            }
            ++var4_4;
lbl25:
            // 3 sources

            ** while (var4_4 < var5_5)
        }
lbl26:
        // 1 sources

    }

    private static boolean isFormatMark(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case '\u200c': 
            case '\u200d': 
            case '\u200e': 
            case '\u200f': 
            case '\u2028': 
            case '\u2029': 
            case '\u202a': 
            case '\u202b': 
            case '\u202c': 
            case '\u202d': 
            case '\u202e': 
            case '\u206a': 
            case '\u206b': 
            case '\u206c': 
            case '\u206d': 
            case '\u206e': 
            case '\u206f': 
            case '\ufeff': {
                return true;
            }
        }
        return false;
    }

    public static void compressSegment(Segment segment, boolean[] blArray) {
        char c;
        int n;
        char[] cArray = segment.text;
        int n2 = n = segment.start;
        int n3 = n2 + segment.length;
        char[] cArray2 = null;
        int n4 = n2;
        int n5 = 0;
        while (n2 < n3) {
            c = cArray[n2];
            if (c == '\uffff' || Shaping.isFormatMark(c)) {
                int n6 = n2 - n4;
                if (blArray != null) {
                    blArray[n2 - n] = true;
                }
                while (++n2 < n3) {
                    c = cArray[n2];
                    if (c != '\uffff' && !Shaping.isFormatMark(c)) break;
                    if (blArray == null) continue;
                    blArray[n2 - n] = true;
                }
                if (cArray2 == null) {
                    if (n2 == n3) {
                        segment.length = n6;
                        return;
                    }
                    if (n6 == 0) {
                        segment.length -= n2 - segment.start;
                        segment.start = n2;
                        n4 = n2++;
                        continue;
                    }
                    cArray2 = new char[segment.length];
                }
                System.arraycopy(cArray, n4, cArray2, n5, n6);
                n5 += n6;
                n4 = n2;
                if (n2 == n3) break;
            }
            ++n2;
        }
        if (cArray2 != null) {
            c = n2 - n4;
            if (c > '\u0000') {
                System.arraycopy(cArray, n4, cArray2, n5, c);
                n5 += c;
            }
            segment.text = cArray2;
            segment.start = 0;
            segment.length = n5;
        }
    }

    public static String getShapedString(TextSource textSource) {
        Segment segment = new Segment();
        Shaping.getShapedSegment(textSource, segment);
        Shaping.compressSegment(segment, null);
        return new String(segment.text, segment.start, segment.length);
    }

    public static void getShapedSegment(TextSource textSource, Segment segment) {
        char[] cArray = textSource.getChars();
        int n = textSource.getStart();
        int n2 = textSource.getLength();
        if (textSource.dataIsLTR()) {
            segment.set(cArray, n, n2, false);
            Shaping.markSegment(segment, false);
            return;
        }
        int n3 = textSource.getContextStart();
        int n4 = textSource.getContextLength();
        int n5 = 8;
        int n6 = n - 1;
        while (n6 >= n3) {
            n5 = NewArabicShaping.getShapeType(cArray[n6]);
            if (n5 != 4) break;
            --n6;
        }
        int n7 = 8;
        int n8 = n + n2;
        int n9 = n3 + n4;
        while (n8 < n9) {
            n7 = NewArabicShaping.getShapeType(cArray[n8]);
            if (n7 != 4) break;
            ++n8;
        }
        char[] cArray2 = new char[n2];
        int n10 = n2;
        int n11 = n - 1;
        while (n10 > 0) {
            cArray2[--n10] = cArray[++n11];
        }
        NewArabicShaping.shape(cArray2, n7, n5);
        ArabicLigaturizer.getLamAlefInstance().ligaturize(cArray2, 0, cArray2.length);
        int n12 = 0;
        while (n12 < n2) {
            char c = cArray2[n12];
            cArray2[n12] = Shaping.isFormatMark(c) ? 65535 : Shaping.getMirroredChar(c);
            ++n12;
        }
        segment.set(cArray2, 0, n2, true);
    }

    public static char getMirroredChar(char c) {
        if (c <= '}' || c >= '\u2045' && c <= '\u301b') {
            int n = 0;
            while (n < mirrorPairs.length) {
                char c2 = mirrorPairs[n];
                if (c2 == c) {
                    return mirrorPairs[n + ((n & 1) == 0 ? 1 : -1)];
                }
                if (c2 > c) break;
                ++n;
            }
        }
        return c;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{".,", ".\uffff,", ".\u0000,", ".\u001f,", ". ,", ".\u0000A,", ".\u0000\u0000A,", ".A,", ".A\u0000,", ".A\u0000\u0000,", ".\u0000A\u0000B\u0000C,", ".A\u0000B\u0000C\u0000,"};
        Segment segment = new Segment();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("----");
            segment.set(stringArray2[n].toCharArray(), 1, stringArray2[n].length() - 2, true);
            boolean[] blArray = new boolean[segment.length];
            System.out.print("in text: " + segment.text + " start: " + segment.start + " length: " + segment.length + " ");
            int n2 = 0;
            while (n2 < segment.length) {
                System.out.print(Integer.toHexString(segment.text[segment.start + n2]) + " ");
                ++n2;
            }
            System.out.println();
            Shaping.compressSegment(segment, blArray);
            System.out.print("out text: " + segment.text + " start: " + segment.start + " length: " + segment.length + " ");
            int n3 = 0;
            while (n3 < segment.length) {
                System.out.print(Integer.toHexString(segment.text[segment.start + n3]) + " ");
                ++n3;
            }
            System.out.println();
            int n4 = 0;
            while (n4 < blArray.length) {
                System.out.print(blArray[n4] + " ");
                ++n4;
            }
            System.out.println();
            ++n;
        }
    }
}

