/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.SwingUtilities;
import sun.plugin.AppletViewer;
import sun.plugin.ConsoleWindow;
import sun.plugin.DebugOutputStream;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

public class JavaRunTime {
    private static boolean onWindows = false;
    private static Object syncObject = new Object();
    private static OutputStream traceStream = null;
    private static ConsoleWindow console = null;
    private static int hStatusIconWnd = 0;

    protected static void initEnvironment(String string, String string2, String string3) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("java.home", string);
        if (string3 == null) {
            ((Hashtable)properties).put("user.home", string);
        } else {
            ((Hashtable)properties).put("user.home", string3);
        }
        ((Hashtable)properties).put("bridge.home", string2);
        AppletViewer.loadPropertiesFiles();
        try {
            String string4 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string4.indexOf("Windows") != -1) {
                onWindows = true;
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public static synchronized ConsoleWindow getJavaConsole() {
        if (console != null) {
            return console;
        }
        console = new ConsoleWindow();
        OutputStream outputStream = JavaRunTime.getTraceOutputStream();
        DebugOutputStream debugOutputStream = new DebugOutputStream(console, outputStream);
        PrintStream printStream = new PrintStream(debugOutputStream, true);
        System.setErr(printStream);
        DebugOutputStream debugOutputStream2 = new DebugOutputStream(console, outputStream);
        PrintStream printStream2 = new PrintStream(debugOutputStream2, true);
        System.setOut(printStream2);
        console.displayVersion();
        return console;
    }

    public static boolean isJavaConsoleVisible() {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            if (onWindows) {
                return consoleWindow.isVisible();
            }
            return consoleWindow.getState() == 0;
        }
        return false;
    }

    public static void showJavaConsole(final boolean bl) {
        final ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (onWindows) {
                            if (consoleWindow.isVisible() != bl) {
                                ((Component)consoleWindow).setVisible(bl);
                            }
                            if (bl) {
                                consoleWindow.toFront();
                            }
                        } else {
                            if (bl) {
                                consoleWindow.setState(0);
                            } else {
                                consoleWindow.setState(1);
                            }
                            ((Component)consoleWindow).setVisible(true);
                        }
                        JavaRunTime.ConsoleStatus(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void showJavaConsoleLater(final boolean bl) {
        final ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (onWindows) {
                            if (consoleWindow.isVisible() != bl) {
                                ((Component)consoleWindow).setVisible(bl);
                            }
                            if (bl) {
                                consoleWindow.toFront();
                            }
                        } else {
                            if (bl) {
                                consoleWindow.setState(0);
                            } else {
                                consoleWindow.setState(1);
                            }
                            ((Component)consoleWindow).setVisible(true);
                        }
                        JavaRunTime.ConsoleStatus(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void showJavaConsoleHelp() {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            consoleWindow.displayHelp();
        }
    }

    public static void showSystemProperties() {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            consoleWindow.displaySystemProperties();
        }
    }

    public static void printToJavaConsole(String string) {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            consoleWindow.append(string);
        }
    }

    public static void setStatusIconWindowHandle(int n) {
        hStatusIconWnd = n;
    }

    public static int getStatusIconWindowHandle() {
        return hStatusIconWnd;
    }

    public static OutputStream getTraceOutputStream() {
        if (traceStream != null) {
            return traceStream;
        }
        try {
            String string = System.getProperty("javaplugin.tracefile.path");
            File file = null;
            if (string == null || string.equalsIgnoreCase("")) {
                String string2 = System.getProperty("user.home");
                file = new File(string2, "plugin" + System.getProperty("javaplugin.nodotversion") + ".trace");
            } else {
                file = new File(string);
            }
            if (file.exists()) {
                file.delete();
            }
            traceStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return traceStream;
    }

    public static native void ConsoleStatus(boolean var0);
}

