/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.usability.Trace;

public class ProxyPanel
extends ActivatorSubPanel
implements ActionListener,
KeyListener {
    private JLabel httpLabel;
    private JLabel ftpLabel;
    private JLabel gopherLabel;
    private JLabel secureLabel;
    private JLabel socksLabel;
    private JTextField http;
    private JTextField ftp;
    private JTextField gopher;
    private JTextField secure;
    private JTextField socks;
    private JTextField httpPort;
    private JTextField ftpPort;
    private JTextField gopherPort;
    private JTextField securePort;
    private JTextField socksPort;
    private JCheckBox useDefault;
    private JCheckBox sameProxies;
    private MessageHandler mh = new MessageHandler("proxy");

    public ProxyPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.useDefault = new JCheckBox(this.mh.getMessage("use_browser"));
        this.useDefault.addActionListener(this);
        jPanel.add(this.useDefault);
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("proxy_settings")));
        GridLayout gridLayout = new GridLayout(6, 3);
        gridLayout.setVgap(5);
        gridLayout.setHgap(10);
        jPanel3.setLayout(gridLayout);
        this.addCenteredLabel(jPanel3, this.mh.getMessage("protocol_type"));
        this.addCenteredLabel(jPanel3, this.mh.getMessage("proxy_address"));
        this.addCenteredLabel(jPanel3, this.mh.getMessage("proxy_port"));
        this.httpLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("http"));
        this.http = this.addProxyTextField(jPanel3);
        this.httpPort = this.addProxyPortField(jPanel3);
        this.secureLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("https"));
        this.secure = this.addProxyTextField(jPanel3);
        this.securePort = this.addProxyPortField(jPanel3);
        this.ftpLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("ftp"));
        this.ftp = this.addProxyTextField(jPanel3);
        this.ftpPort = this.addProxyPortField(jPanel3);
        this.gopherLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("gopher"));
        this.gopher = this.addProxyTextField(jPanel3);
        this.gopherPort = this.addProxyPortField(jPanel3);
        this.socksLabel = this.addCenteredLabel(jPanel3, this.mh.getMessage("socks"));
        this.socks = this.addProxyTextField(jPanel3);
        this.socksPort = this.addProxyPortField(jPanel3);
        jPanel2.add(jPanel3);
        this.sameProxies = new JCheckBox(this.mh.getMessage("same_for_all_protocols"));
        this.sameProxies.addActionListener(this);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        jPanel2.add(this.sameProxies);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        this.reset();
        this.add(jPanel2);
    }

    private JTextField addProxyTextField(JPanel jPanel) {
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(this);
        jPanel.add(jTextField);
        return jTextField;
    }

    private JTextField addProxyPortField(JPanel jPanel) {
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(this);
        jPanel.add(jTextField);
        return jTextField;
    }

    private JLabel addCenteredLabel(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jLabel);
        return jLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (actionEvent.getSource() == this.useDefault) {
            bl = this.useDefault.isSelected();
            this.model.setDefaultProxySettings(bl);
            this.reset();
        }
        if (actionEvent.getSource() == this.sameProxies) {
            bl = this.sameProxies.isSelected();
            this.model.setUseSameProxy(bl);
            this.setProxySettings();
            this.reset();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void reset() {
        boolean bl = this.model.useDefaultProxy();
        this.useDefault.setSelected(bl);
        boolean bl2 = this.model.useSameProxy();
        this.sameProxies.setSelected(bl2);
        boolean bl3 = !bl;
        this.setEnabled(this.sameProxies, bl3);
        this.setEnabled(this.httpLabel, bl3);
        this.setEnabled(this.http, bl3);
        this.setEnabled(this.httpPort, bl3);
        bl3 = !bl && !bl2;
        this.setEnabled(this.secureLabel, bl3);
        this.setEnabled(this.secure, bl3);
        this.setEnabled(this.securePort, bl3);
        this.setEnabled(this.ftpLabel, bl3);
        this.setEnabled(this.ftp, bl3);
        this.setEnabled(this.ftpPort, bl3);
        this.setEnabled(this.gopherLabel, bl3);
        this.setEnabled(this.gopher, bl3);
        this.setEnabled(this.gopherPort, bl3);
        this.setEnabled(this.socksLabel, bl3);
        this.setEnabled(this.socks, bl3);
        this.setEnabled(this.socksPort, bl3);
        this.initProxySettings();
    }

    private void setProxySettings() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.http.getText().length() != 0) {
            bl = true;
            stringBuffer.append(this.http.getText());
            if (this.httpPort.getText().length() != 0) {
                stringBuffer.append(":");
                stringBuffer.append(this.httpPort.getText());
            }
        }
        String string = stringBuffer.toString();
        if (!this.sameProxies.isSelected()) {
            stringBuffer = new StringBuffer();
            if (this.sameProxies.isSelected() && string.length() != 0) {
                stringBuffer.append("http=");
                stringBuffer.append(string);
                stringBuffer.append(";https=");
                stringBuffer.append(string);
                stringBuffer.append(";ftp=");
                stringBuffer.append(string);
                stringBuffer.append(";gopher=");
                stringBuffer.append(string);
            } else {
                if (this.http.getText().length() != 0) {
                    stringBuffer.append("http=");
                    stringBuffer.append(string);
                }
                if (this.secure.getText().length() != 0) {
                    if (bl) {
                        stringBuffer.append(";");
                    } else {
                        bl = true;
                    }
                    stringBuffer.append("https=");
                    stringBuffer.append(this.secure.getText());
                    if (this.securePort.getText().length() != 0) {
                        stringBuffer.append(":");
                        stringBuffer.append(this.securePort.getText());
                    }
                }
                if (this.ftp.getText().length() != 0) {
                    if (bl) {
                        stringBuffer.append(";");
                    } else {
                        bl = true;
                    }
                    stringBuffer.append("ftp=");
                    stringBuffer.append(this.ftp.getText());
                    if (this.ftpPort.getText().length() != 0) {
                        stringBuffer.append(":");
                        stringBuffer.append(this.ftpPort.getText());
                    }
                }
                if (this.gopher.getText().length() != 0) {
                    if (bl) {
                        stringBuffer.append(";");
                    } else {
                        bl = true;
                    }
                    stringBuffer.append("gopher=");
                    stringBuffer.append(this.gopher.getText());
                    if (this.gopherPort.getText().length() != 0) {
                        stringBuffer.append(":");
                        stringBuffer.append(this.gopherPort.getText());
                    }
                }
                if (this.socks.getText().length() != 0) {
                    if (bl) {
                        stringBuffer.append(";");
                    }
                    stringBuffer.append("socks=");
                    stringBuffer.append(this.socks.getText());
                    if (this.socksPort.getText().length() != 0) {
                        stringBuffer.append(":");
                        stringBuffer.append(this.socksPort.getText());
                    }
                }
            }
            string = stringBuffer.toString();
        }
        if (string.length() != 0) {
            this.model.setProxySettingsString(string);
        } else {
            this.model.setProxySettingsString(null);
        }
    }

    private void initProxySettings() {
        String string = this.model.getProxySettingsString();
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        try {
            if (this.model.useSameProxy()) {
                this.fillProxySettings("http", string, this.http, this.httpPort);
                this.fillProxySettings("https", "", this.secure, this.securePort);
                this.fillProxySettings("ftp", "", this.ftp, this.ftpPort);
                this.fillProxySettings("gopher", "", this.gopher, this.gopherPort);
                this.fillProxySettings("socks", "", this.socks, this.socksPort);
            } else {
                this.fillProxySettings("http", string, this.http, this.httpPort);
                this.fillProxySettings("https", string, this.secure, this.securePort);
                this.fillProxySettings("ftp", string, this.ftp, this.ftpPort);
                this.fillProxySettings("gopher", string, this.gopher, this.gopherPort);
                if (string.indexOf("=") != -1) {
                    this.fillProxySettings("socks", string, this.socks, this.socksPort);
                } else {
                    this.fillProxySettings("socks", "", this.socks, this.socksPort);
                }
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    private void fillProxySettings(String string, String string2, JTextField jTextField, JTextField jTextField2) {
        String string3 = this.readProxySetting(string, string2);
        int n = string3.indexOf(":");
        if (n == -1) {
            jTextField.setText(string3);
            jTextField2.setText("");
        } else {
            jTextField.setText(string3.substring(0, n));
            jTextField2.setText(string3.substring(n + 1));
        }
    }

    private String readProxySetting(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return "";
        }
        int n = string2.indexOf("=");
        if (n == -1) {
            return string2;
        }
        n = string2.indexOf(string + "=");
        if (n == -1) {
            return "";
        }
        int n2 = string2.indexOf(";", n);
        if (n2 == -1) {
            return string2.substring(n + string.length() + 1);
        }
        return string2.substring(n + string.length() + 1, n2);
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }
}

