/* FILEMANAGER  --  An FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
*  Author: Duong Thanh An - technical@anisolution.com (core)
*  Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)
*	
*  Copyright (C) 2004 Anisolution.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Anisolution.com
*  http://www.anisolution.com
*  HCMC Vietnam
*  info@anisolution.com
*/
/*		
	 Copyright notice:
	 XUL File Manager is freeware with open source code. 
	 As long as you keep the copyright message, you can 
	 play with the code for your own purposes but you can
	 not distribute the altered version. You can not sell 
	 XUL File Manager or use it for commercial purposes.
	 Please contact us for commercial uses.

	 BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM
*/


installExtension(new ImageViewerExt());

function ImageViewerExt() {

	this.acceptExts = "(jpg)|(jpe)|(jpeg)|(bmp)|(gif)|(png)|(tiff)";
	this.getDisplayInfo = function() {
		var sel = getListSelectionModel();
		if(!sel) return null;
		if(!isFileOfType(sel, this.acceptExts)) return null;

		var menuItem = new ExtensionMenuItem();
		menuItem.caption = "View with Image Viewer";
		menuItem.iconImage = "images/ext/image-viewer.png";
		menuItem.action = function () {
			var list = document.getElementById("contentList");
			var index = list.view.selection.currentIndex;
			if(index < 0) return;
			var item = list.view.getItemAtIndex(index);
			if(item.fsData.fstype != "file") return;
			
			window.open(CLIENT_VIEW_IMAGE_WINDOW_PATH + "?path=" + escape(item.fsData.absolutePath), "", "chrome,resizable=yes");
		};
		return menuItem;
	};

	this.getAboutInfo = function() {
		return "Image Viewer by Duong Thanh An. Email: dgthanhan@yahoo.com";
	};
}

