/*** -*- Mode: Javascript; tab-width: 2;
  
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is jslib team code.  
The Initial Developer of the Original Code is jslib team.

Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.
  
Original Author: Pete Collins <pete@mozdev.org>
Contributor(s):
    
***/


if (typeof(JS_LIB_LOADED) == 'boolean') 
{
  const JS_PACKAGEINFO_LOADED = true;
  const JS_PACKAGEINFO_FILE   = 'packageInfo.js';

  function PackageInfo (aPkgName) 
  {
    if (!aPkgName)
      return jslibErrorMsg("NS_ERROR_XPC_NOT_ENOUGH_ARGS");

    this.pkgName = aPkgName;

    return this.init();
  }

  PackageInfo.prototype = 
  {
    pkgName    : null,
    rdfService : null,
    ds         : null,
    resSelf    : null,

    init : function ()
    {
      var rv = JS_LIB_OK;
      try {
        this.rdfService = jslibGetService("@mozilla.org/rdf/rdf-service;1",
                                          "nsIRDFService");
        this.ds = this.rdfService.GetDataSource("rdf:chrome");
        var pID = "urn:mozilla:package:"+this.pkgName;
        this.resSelf = this.rdfService.GetResource(pID);
      } catch (e) { rv = jslibError(e); }

      return rv;
    },

    getPackageValue : function (aProperty)
    {
      var rv = "";
      try {
        var property = "http://www.mozilla.org/rdf/chrome#"+aProperty;
        var resProp = this.rdfService.GetResource(property);
        var resTarget = this.ds.GetTarget(this.resSelf, resProp, true);
        var literal = jslibQI(resTarget, "nsIRDFLiteral");

        rv = literal.Value;
      } catch (e) {}
   
    return rv;
  },

  get version () { return this.getPackageValue("packageVersion"); },
  get author () { return this.getPackageValue("author"); },
  get name () { return this.getPackageValue("name"); },
  get displayName () { return this.getPackageValue("displayName"); },
  
  }; // END CLASS
  
  jslibLoadMsg(JS_PACKAGEINFO_FILE);

} else { dump("load FAILURE: packageInfo.js\n"); }
 
