/*** -*- Mode: Javascript; tab-width: 2;

The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is Urban Rage Software code.
The Initial Developer of the Original Code is Eric Plaster.

Portions created by Urban Rage Software are
Copyright (C) 2001 Urban Rage Software.  All
Rights Reserved.

Contributor(s): Eric Plaster <plaster@urbanrage.com)> (original author)
*/

var gOptions = null;
var gButtonList = null;

function onStartupLoad()
{
  if (window.arguments && window.arguments[0])
  {
    gOptions = window.arguments[0];
    setupImage();
    setupMessage();
    setupButtons();
    if (gOptions.title)
      setTimeout("setupTitle();", 10);
  }
}

//----------------------------------------------------------------------------------
function setupImage()
{
  // setup the image...
  if (gOptions.type) {
    var imagebox = document.getElementById("imageBox");
    var image = document.createElement("image");
    if (gOptions.type == "message") {
      image.setAttribute("class", "message-icon");
    }
    else if (gOptions.type == "alert") {
      image.setAttribute("class", "alert-icon");
    }
    else if (gOptions.type == "error") {
      image.setAttribute("class", "error-icon");
    }
    else if (gOptions.type == "question") {
      image.setAttribute("class", "question-icon");
    }
    imagebox.appendChild(image);
  }
}

function setupMessage()
{
  // setup up the text...
  if (gOptions.message) {
    try {
      var el = document.getElementById("messageText");
      el.firstChild.data = gOptions.message;
    } catch (e) { dump(e); }
  }
}

function setupButtons()
{
  var align = "center";
  var bbox = document.getElementById("buttonBox");

  gButtonList = new Array;

  // set up the buttons.
  if (gOptions.buttontype) {
    if (gOptions.buttontype == "okcancel") {
      gButtonList[0] = "OK";
      gButtonList[1] = "Cancel";
    } else if (gOptions.buttontype == "ok") {
      gButtonList[0] = "OK";
    } else if (gOptions.buttontype == "cancel") {
      gButtonList[0] = "Cancel";
    } else if (gOptions.buttontype == "yesno") {
      gButtonList[0] = "Yes";
      gButtonList[1] = "No";
    } else if (gOptions.buttontype == "yes") {
      gButtonList[0] = "Yes";
    } else if (gOptions.buttontype == "no") {
      gButtonList[0] = "No";
    } 
  } else {
    gButtonList = gOptions.buttonList;
  }

  if (!gOptions.defaultButton) {
    gOptions.defaultButton = gButtonList.length -1;
  }

  if (gOptions.buttonalign) {
    align = gOptions.buttonalign;
  }

  // left spring
  var lspring = document.createElement("spacer");
  if (align == "left") {
    lspring.setAttribute("style", "width: 10px;");
  } else {
    lspring.setAttribute("flex", "1");
  }
  bbox.appendChild(lspring);

  // buttons...
  for(i=0; i<gButtonList.length; i++) {
    var button = document.createElement("button");
    button.setAttribute("label", gButtonList[i]);
    button.setAttribute("style", "left-margin: 5px; right-margin:5px;");
    button.setAttribute("oncommand", "doButton("+i+");");
    button.setAttribute("bnum", i);
    button.setAttribute("id", "bID"+i);
    if (i == gOptions.defaultButton) {
      button.setAttribute("default", "true");
    }
    bbox.appendChild(button);
  }

  // right spring
  var rspring = document.createElement("spacer");
  if (align == "right") {
    rspring.setAttribute("style", "width: 10px;");
  } else {
    rspring.setAttribute("flex", "1");
  }
  bbox.appendChild(rspring);

  button = document.getElementById("bID"+gOptions.defaultButton);
  if (button) {
    button.focus();
  }
}

//----------------------------------------------------------------------------------
function setupTitle() { window.title = gOptions.title; }

function doButton(which) {
  var button = document.getElementById("bID"+which);
  if (button) {
    gOptions.buttonHitText = button.getAttribute("label");
    gOptions.buttonHit = button.getAttribute("bnum");

    window.close();
  }
}

function doEnter() {
  var button = document.getElementById("bID"+gOptions.defaultButton);
  gOptions.buttonHitText = button.getAttribute("label");
  gOptions.buttonHit = button.getAttribute("bnum");
  
  window.close();
}

function doEsc() {
  gOptions.buttonHit = "_none_";
  window.close();
}
