/***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Initial Developer of the Original Code is Eelco van Kuik.
   -
   - Contributor(s):
   - Several developers
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK *****/


var search = {
			
	doSearch : function (item) {
		//load libraries
		const Include=new Components.Constructor('@mozilla.org/moz/jssubscript-loader;1','mozIJSSubScriptLoader');
		const gInc = new Include();
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsVirtualForm.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsRdfLocator.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsRdfds.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsSniffer.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsPrefs.js");

		//parse the url for the search engine and search terms
		var getvars=item.split('?');
                getvars.shift();
                getvars=getvars.join('?');
		getvars=getvars.split('&');
		getvars[0]=getvars[0].split('=');
		getvars[1]=getvars[1].split('=');
		var engine,searchterm
		if (getvars[0][0]=='engine') {
			engine=unescape(getvars[0][1]);
			searchterm=unescape(getvars[1][1]);
		} else {
			engine=unescape(getvars[1][1]);
			searchterm=unescape(getvars[0][1]);
		}
		
		//Get the search enigne details
		var rdfuri='file:///'+nsRdfLocator.getUri(true);
		var enginesDS=new nsRdfds.RDFDataSource(rdfuri);
		const shortlabel=nsRdfds.RDFService.GetResource(nsRdfds.aXMLPath+'shortlabel');
		var engine_l=nsRdfds.RDFService.GetLiteral(engine);
		//var engine_n=enginesDS.getNode(engine);
		try {
			var engine_t=enginesDS.datasource.GetSource(shortlabel, engine_l, true);
			//var engine_t=engine_n.getSource(nsRdfds.aXMLPath+'shortlabel'); <--- for some reason doesn't work
			engine_t=enginesDS.getNode(engine_t.Value);
			
			//var s_searchstring,s_encoding,s_method;
			searchstring=engine_t.getTarget(nsRdfds.aXMLPath+'searchstring').getValue();
			encoding=engine_t.getTarget(nsRdfds.aXMLPath+'encoding').getValue();
			method=engine_t.getTarget(nsRdfds.aXMLPath+'method').getValue();
			
		} catch (e) {
			alert(e);
		}
		
		
		var aVF = new nsVirtualForm(searchstring, null, searchterm, method, encoding)
		if (aVF.isSuccess) {
			aVF.submit()
		} else {
			//Probably it wasn't HTML what was shown
			window._content.location = 'about:blank'
			setTimeout("aVF = new nsVirtualForm('" + searchstring + "', '" + target + "', '" + searchterm + "', '" + method + "', '"+ encoding + "'); aVF.submit()", 250)
		}
		
	}

}
