/***********************************************************************
*                           ElementExplorer
*                        (xmElementExplorer.js)
*                           version 0.40
***********************************************************************/
/*
* Contributors:
* ============
*	Franklin de Graaf (franklin@xpower.com)
*
* Description:
* ===========
* This file contains both the TreeElement and ListElement objects.
*
***********************************************************************/
if(TRACE_LOADING){ alert("Start loading: xmElementExplorer.js"); }

//======================================================================
//  ElementTree
//======================================================================
// This is the tree list of the design document's elements.

//----------------------------------------------------------------------
// ElementTree::ElementTree() (Constructor)
//----------------------------------------------------------------------

function ElementTree(theDesignDocument) {
const METHOD_NAME = "ElementTree::ElementTree";
trace(METHOD_NAME, "BEGIN" );

	// properties
	this.idtree = document.getElementById(NAMESPACE + "idtree");
	this.activeNode = document.getElementById(NAMESPACE + "idtree-window");
	this.idtreeOpenStates = new Array();
	this.theDesignDocument = theDesignDocument;
	this.newSelection = true;
	this.update(); //build the idtree from the design document

trace(METHOD_NAME, "END" );
}

//--------------------------------------------------------------------
// ElementTree::addElement()
//--------------------------------------------------------------------
//
ElementTree.prototype.addElement = function(idtreeNode, elementType, id) {
const METHOD_NAME = "ElementTree::addElement";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "MSG", "Building: <" + elementType + " id=" + id + "\" />");

	tc = document.createElement("treecell");
	tc.setAttribute("class", "treecell-type");
	tc.setAttribute("label", elementType);
	tc.setAttribute("properties", elementType); //<<<==== we could set the element type here to allow for the customization of the entry by element type.

	tc1 = document.createElement("treecell");
	tc1.setAttribute("class", "treecell-id");
	tc1.setAttribute("label", id);
	tc1.setAttribute("properties", id); //<<<==== we could set the element type here to allow for the customization of the entry by element type.

	tr = document.createElement("treerow");
	//tr.setAttribute("properties", "makecustom"); //<<<==== we could set the element type here to allow for the customization of the entry by element type.
	tr.appendChild(tc);
	tr.appendChild(tc1);

	ti = document.createElement("treeitem");
	ti.setAttribute("id",NAMESPACE + "idtree-" + id);

	//This event is meant to trigger the selection of the active element
	// The onclick event sets the "broadcaster" element "selection" attribute.
	//onclickstr="document.getElementById('--xulmaker-onChangeElementSelection').setAttribute('selection', this.getAttribute('id') )";
	//onclickstr="document.getElementById('xm:onChangeElementSelection').setAttribute('selection', this.getAttribute('id') )";
	//onclickstr="document.getElementById(\'"+NAMESPACE+"onChangeElementSelection\').setAttribute('selection', this.getAttribute('id') )";
	onclickstr="alert('ElementTree onClick');xm.theElementTree.onClick(event)";
	//ti.setAttribute("onclick", onclickstr); //<<<<<<<<<This never seems to happen
	ti.setAttribute("onclick", "alert('onclick in idtree');"); //<<<<<<<<<This never seems to happen

	ti.setAttribute(NAMESPACE + "idref",id);
	var openState = this.idtreeOpenStates[NAMESPACE + "idtree-" + id];
	if (openState == undefined) {
		this.idtreeOpenStates[NAMESPACE + "idtree-" + id] = "true";	
		ti.setAttribute("open",true);
	} else {
		ti.setAttribute("open",openState);
	}
	ti.appendChild(tr);

	idtreeNode.appendChild(ti); // adding <treeitem> to <treechildren> element

trace(METHOD_NAME, "END" );
}

//--------------------------------------------------------------------
// ElementTree::fillTree()
//--------------------------------------------------------------------
// a self-calling function to build the DOM tree
// <tree>					<== XUL file
//	<treecols>				<== XUL file
//		<treecol>			<== XUL file
//	</treecols>				<== XUL file
//	<treechildren>				<== treeFill
//		<treeitem>					<== addElement
//			<treerow>				<== addElement
//				<treecell>			<== addElement
//			</treerow>				<== addElement
//			<treechildren>				<== treeFill
//				<treeitem>					<== addElement
//					<treerow>				<== addElement
//						<treecell>			<== addElement
//					</treerow>				<== addElement
//				</treeitem>					<== addElement
//			</treechildren>				<== treeFill
//		</treeitem>					<== addElement
//	</treechildren>				<== treeFill
// </tree>					<== XUL file
//
//
//
// "ddocNode"   is the node in the ddoc (design document)
// "idtreeNode" is the node in the idtree (Element Explorer) - always pointing to a <treechildren> element
//
ElementTree.prototype.fillTree = function(idtreeNode, ddocNode) {
const METHOD_NAME = "ElementTree::fillTree";
trace(METHOD_NAME, "BEGIN" );

	// the id of the element in the design document is the id of the element in the idtree
	if (ddocNode.hasAttribute("id") == true) {
		id = ddocNode.getAttribute("id");
	} else {
		id = "<" + ddocNode.tagName + ">";
	}

 	this.addElement(idtreeNode, ddocNode.tagName, id); // idtreeNode = current place in the idtree; always points to <treechildren>
	//trace(METHOD_NAME, "MSG", "Currently at &lt;" + idtreeNode.tagName + " id=\"" + id + "\"&gt;");
	//trace(METHOD_NAME, "MSG", "Added &lt;" + treechildren.tagName + "&gt; to &lt;" + idtreeNode.tagName + "&gt;.");
	if (ddocNode.hasChildNodes()) {
		idtreeNode.lastChild.setAttribute("container","true");
		ch = document.createElement("treechildren");
		idtreeNode.lastChild.appendChild(ch);//<<<<<<<<????????
		idtreeNode = ch;

		trace(METHOD_NAME, "MSG", "\"" + id + "\" has " + ddocNode.childNodes.length + " children.");
		for (var i=0; i<ddocNode.childNodes.length; i++) { // does not build children if none exist
            	//ignore non element nodes, e.g. ignore text nodes, e.g. whitespace
			if ( ddocNode.childNodes.item(i).nodeType == 1 ) {
				trace(METHOD_NAME, "MSG", "going down one level from item#" + i);
//				idtreeNode = this.fillTree(idtreeNode, ddocNode.childNodes.item(i));
				this.fillTree(idtreeNode, ddocNode.childNodes.item(i));
            		trace(METHOD_NAME, "MSG", "going up one level to item#" + i);
			}
		}
	}

trace(METHOD_NAME, "END" );
	return idtreeNode;
}

//----------------------------------------------------------------------
// ElementTree::update()
//----------------------------------------------------------------------
// Rebuilds the tree from the Design document

ElementTree.prototype.update = function() {
const METHOD_NAME = "ElementTree::update";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "INFO", "topNode: " + (this.theDesignDocument.getTopNode().getAttribute('id')) );
trace(METHOD_NAME, "INFO", "this.activeNode: " + this.activeNode.getAttribute("id") );

	// scrap the current tree
	idtreechildren = document.getElementById(NAMESPACE + "idtree-children");
	while (idtreechildren.hasChildNodes() == true) { idtreechildren.removeChild(idtreechildren.firstChild) }

	// now cycle the DOM
	this.fillTree(idtreechildren, this.theDesignDocument.getTopNode());

	//we set the idtree open state for window (after its been created)
	id = "window";
	var topNode = document.getElementById(NAMESPACE + "idtree-" + id);
	var openState = this.idtreeOpenStates[NAMESPACE + "idtree-" + id];
	topNode.setAttribute("open", openState);

	// re-select the active element
	var id = this.theDesignDocument.getActiveNode().getAttribute("id");
	this.selectElement(id);

trace(METHOD_NAME, "END" );
}
 
//--------------------------------------------------------------------
// ElementTree::getIDTreeFromNode()
//--------------------------------------------------------------------
// given a document node (in the design document), return the corresponding idtree node

ElementTree.prototype.getIDTreeFromNode = function(node) {
	return document.getElementById(NAMESPACE + "treeid-"+node.getAttribute("id"));
}

//----------------------------------------------------------------------
// ElementTree::selectElement()
//----------------------------------------------------------------------

ElementTree.prototype.selectElement = function (id) {
const METHOD_NAME = "ElementTree::selectElement";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "INFO", "id=" + id );

	// First we point ourselves to the <tree> element for the "idtree" view
	var tree = document.getElementById(NAMESPACE + "idtree");
	if (!tree) {
		alert("System Error: ElementTree: could not be found.");
	}
	// must be a <tree> element
	if (tree.tagName != "tree") {
		alert("System Error: ElementTree: top node is not a <tree> element.");
	}

	// Next we make the appropriate <treeitem> element the "active" element
	// (This does not result in the "selection" of the element in the tree.)
	var newnode = document.getElementById(NAMESPACE + "idtree-"+id);
	if (!newnode) {
		alert("System Error: ElementTree: Selected element \"" + NAMESPACE + "idtree-" +id + "\" could not be found.");
	}
	if (this.activeNode) {
trace(METHOD_NAME, "INFO", "current active element <" + this.activeNode.tagName + ' id="' + this.activeNode.getAttribute("id") + '">' );
		this.activeNode.removeAttribute(ACTIVE_ATTRNAME); // deselect currently active node
	} else {
trace(METHOD_NAME, "INFO", "current active element is null");
	}
 	newnode.setAttribute(ACTIVE_ATTRNAME,"true"); // select new active node
	this.activeNode = newnode;


	// Then we select the item in the tree by setting the "currentIndex" property of the <tree> element
	// to the index of the item that has the cell text that corresponds to the id of the selected element
	// <<<<< problem here: selection highlight is not correct
	var itemid;
trace(METHOD_NAME, "INFO", "tree.view.rowCount=\"" + tree.view.rowCount + "\"" );
	for (var index=0; index<tree.view.rowCount; index++ ) { //tree.view.rowCount
		// getCellText(row,column)
		itemid = tree.view.getCellText(index, NAMESPACE + "idtree-treecol-elementid"); //NAMESPACE + "idtree-treecol-elementid" is <treecol> id
trace(METHOD_NAME, "INFO", "itemid=\"" + itemid + "\"" );
//itemid="" for window treeitem before application displays. <<<<<<<<<<
//This results in the window element to not be selected initially, even though it is the active element.
		if (itemid==id) {
trace(METHOD_NAME, "INFO", "index=\"" + index + "\"" );
			tree.view.selection.select(index);
		}
	}

trace(METHOD_NAME, "END" );
}
//----------------------------------------------------------------------
// ElementTree::onChangeElementSelection(event)
//----------------------------------------------------------------------

ElementTree.prototype.onChangeElementSelection = function(event) {
const METHOD_NAME = "ElementTree::onChangeElementSelection";
trace(METHOD_NAME, "BEGIN" );
try {

	// get the id of the new selection
	// (There should be an easier way of getting this.)
	var broadcaster = document.getElementById(event.target.getAttribute("element"));
	id = broadcaster.getAttribute("selection");
	trace(METHOD_NAME, "MSG", "selection: " + id );

	if (this.newSelection) {
		this.selectElement(id);
	} else {
		// ignore onChangeElementSelection if it originated here
		this.newSelection = true;
	} 

} catch (e) {
	alert(METHOD_NAME + " ERROR:\n" + e);
}
trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// ElementTree::onSelect(event)
//----------------------------------------------------------------------
// The elements within the tree element do not generate click events,
// so we use the "onselect" event on the tree element.

ElementTree.prototype.onSelect = function(event) {
const METHOD_NAME = "ElementTree::onSelect";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "MSG", "Selection from <" + event.target.tagName + ">.");
//trace(METHOD_NAME, "MSG", "Row count = " + event.target.view.rowCount);

	var tree = event.target;

/* None of this works in Mozilla 1.0
  //var items=tree.selectedItems;
  //trace("ElementTree::onSelect", "MSG", "selected items count = " + tree.selectedIndex);
  //trace("ElementTree::onSelect", "MSG", "selected items count = " + tree.selectedItems.length);
  if (items.length==0) alert("No items are selected.");
  else {
    txt="You have selected:\n\n";
    for (t=0;t<items.length;t++){
      txt+=items[t].firstChild.firstChild.getAttribute('value')+'\n';
    }
    alert(txt);
  }
*/

/* This works but is unecessary for single selection
	var startIndex = new Object();
	var endIndex = new Object();;
	for (var rangeIndex=0; rangeIndex<tree.view.selection.getRangeCount(); rangeIndex++ ) {
		tree.view.selection.getRangeAt(0,startIndex,endIndex);
		for (var selectionIndex=startIndex.value; selectionIndex<=endIndex.value; selectionIndex++){
			trace(METHOD_NAME, "MSG", "Range index = " + rangeIndex + ", Selection index = " + selectionIndex);
			trace(METHOD_NAME, "MSG", "Selection = " + selectionIndex.value);
		}
	}
*/

	var id = tree.view.getCellText(tree.currentIndex,NAMESPACE + "idtree-treecol-elementid"); //NAMESPACE + "idtree-treecol-elementid" is <treecol> id
	trace("ElementTree::onSelect", "MSG", "Selection = " + id );

	// Fire an "selection" event which gets broadcast to other observers as well as to theDesignDocument (here).
	this.newSelection = false; //ensure that the event does not get processed here again
	var broadcaster = document.getElementById(NAMESPACE + "onChangeElementSelection");
	broadcaster.setAttribute("selection", id );

trace(METHOD_NAME, "MSG", "Broadcaster element attribute set to \"" + id + "\".");
trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// ElementTree::onClick(event)
//----------------------------------------------------------------------

ElementTree.prototype.onClick = function(event) {
const METHOD_NAME = "ElementTree::onClick";
trace(METHOD_NAME, "BEGIN" );

	var id = event.target.getAttribute("id");
trace(METHOD_NAME, "MSG", "Clicked on \"" + id + "\".");

	// Fire an "selection" event which gets broadcast to other observers as well as to theDesignDocument (here).
	var broadcaster = document.getElementById(NAMESPACE + "onChangeElementSelection");
	broadcaster.setAttribute("selection", id );

	// save the open state if changed - onclick happened on grippy <<<<<====== This doesn't work - state is not changed - see idtreeOnClick() - what is *idref* used for
	var selectedNode = document.getElementById(NAMESPACE + "idtree-" + id);
	var openState;
	if (selectedNode.hasAttribute("open")) {
		openState = selectedNode.getAttribute("open");
	} else {
		openState = "false";
	}
	this.idtreeOpenStates[NAMESPACE + "idtree-" + id] = openState;
trace(METHOD_NAME, "MSG", "idtree element \"" + id + "\"\'s open state is " + openState);

trace(METHOD_NAME, "MSG", "Broadcaster element attribute set to \"" + id + "\".");
trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// ElementTree::idtreeOnClick()
//----------------------------------------------------------------------
// we need this because an onclick event bubbles up, so we need to test the selected attr
//

ElementTree.prototype.idtreeOnClick = function(id) {  //<====*******************
const METHOD_NAME = "ElementTree::idtreeOnClick";
trace(METHOD_NAME, "BEGIN" );

	node = document.getElementById(id);
	this.idtreeOpenStates[id] = node.getAttribute("open");
	if (node.hasAttribute("selected") == true) {
		//this.selectNode(document.getElementById(node.getAttribute(NAMESPACE + "idref")));
	}

trace(METHOD_NAME, "END" );
}

//======================================================================
//  ElementList
//======================================================================
// This is the flat list of the design document's elements.

//----------------------------------------------------------------------
// ElementList::ElementList() (Constructor)
//----------------------------------------------------------------------

function ElementList(theDesignDocument) {
const METHOD_NAME = "ElementList::ElementList";
trace(METHOD_NAME, "BEGIN" );

	// constants (these are currently defined in xmSettings.js)
	//const NAMESPACE = "xm:";
	//const ACTIVE_ATTRNAME = NAMESPACE + "active";

	// properties
	this.idlist = document.getElementById(NAMESPACE + "idlist");
	//this.topNode = theDesignDocument.topNode;
	this.activeNodeIDIndex = 0;
	this.activeNode;

	this.update(); //build the idlist from the design document

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// ElementList::update()
//----------------------------------------------------------------------
// Update the flat list
// Display the flat list of XUL elements. These are displayed in the order
// that they were created.
// Each list item (XUL element) is made clickable and is given a unique id
//

ElementList.prototype.update = function() {
const METHOD_NAME = "ElementList::update";
trace(METHOD_NAME, "BEGIN" );

	// idlist first points to the element with id=NAMESPACE + "idlist"
	// and then to the <rows> element, giving it an id=NAMESPACE + "idlist".
	// The list is a set of <row> elements
	//var idlist = document.getElementById(NAMESPACE + "idlist");
	var idlist = this.idlist;
	idlist.removeChild(idlist.firstChild);
	idlist.appendChild(document.createElement("rows"));
	idlist.firstChild.setAttribute("id",NAMESPACE + "idlist");
	idlist = idlist.firstChild;

	// now get flattened list of nodes from the design document
	// and write these nodes into the idlist view.
	nlist = getNodesIDList(documentToNodeList(document)); //see DOM manipulation routines
	//*****nlist = getNodesIDList(documentToNodeList(this.topNode));
	// display the flattened list - allow for selection to make it the active element
	//alert("IDList contains " + nlist.length + " elements.");
	for (i=0; i < nlist.length; i++) {
		item = nlist[i];
		itemtext = document.createElement("label");
		itemtext.setAttribute("value",item);
		itemtext.setAttribute("class","idlist-id");
		//@@deadcode onclickstr = "xm.selectNode("+i+");";
		//onclickstr = "xm.selectNode(document.getElementById(\""+item+"\"))";
		//itemtext.setAttribute("onclick",onclickstr);
		itemtext.setAttribute("onclick", "xm.theElementList.onClick(event.target); return false;");
		itemtext.setAttribute("id",NAMESPACE + "idlist-"+item);
		//if (i == this.activeNodeIDIndex) { itemtext.setAttribute(ACTIVE_ATTRNAME,"true"); this.activeNode = itemtext;}
		if (document.getElementById(item).hasAttribute(ACTIVE_ATTRNAME)) { itemtext.setAttribute(ACTIVE_ATTRNAME,"true"); this.activeNode = itemtext;}
		row = document.createElement("row");
		row.appendChild(itemtext);
		row.setAttribute("class","idlist-row");
    		//alert("<row id=\"" + NAMESPACE + "idlist-" + item + "\"" + " class=\"idlist-row\"" + "onclick=\"" + onclickstr + "\">");
    		idlist.appendChild(row);
	}

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// ElementList::selectElement()
//----------------------------------------------------------------------

ElementList.prototype.selectElement = function (id) {
const METHOD_NAME = "ElementList::selectElement";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "INFO", "id=" + id );

	var newnode = document.getElementById(NAMESPACE + "idlist-"+id);
	if (newnode == null) {
		alert("System Error: ElementList: Selected element \"" + NAMESPACE + "idlist-" +id + "\" could not be found.");
	}
	if (this.activeNode) {
trace(METHOD_NAME, "INFO", "current active element <" + this.activeNode.tagName + ' id="' + this.activeNode.getAttribute("id") + '">' );
		this.activeNode.removeAttribute(ACTIVE_ATTRNAME); // deselect currently active node
	} else {
trace(METHOD_NAME, "INFO", "current active element is null");
	}
 	newnode.setAttribute(ACTIVE_ATTRNAME,"true"); // select new active node
	this.activeNode = newnode;

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// ElementList::onChangeElementSelection(event)
//----------------------------------------------------------------------

ElementList.prototype.onChangeElementSelection = function(event) {
const METHOD_NAME = "ElementList::onChangeElementSelection";
trace(METHOD_NAME, "BEGIN" );

	// get the id of the new selection
	// (There should be an easier way of getting this.)
	var broadcaster = document.getElementById(event.target.getAttribute("element"));
	id = broadcaster.getAttribute("selection");
trace(METHOD_NAME, "MSG", "selection: " + id );
	this.selectElement(id);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// ElementList::onClick(element)
//----------------------------------------------------------------------

ElementList.prototype.onClick = function(element) {
const METHOD_NAME = "ElementList::onClick";
trace(METHOD_NAME, "BEGIN" );

	var id = element.getAttribute("id").substring(NAMESPACE.length+7); // strip off NAMESPACE + "idlist-"
trace(METHOD_NAME, "MSG", "Clicked on \"" + id + "\".");

	// Fire an "selection" event which gets broadcast to other observers as well as to theElementList (here).
	var broadcaster = document.getElementById(NAMESPACE + "onChangeElementSelection");
	broadcaster.setAttribute("selection", id );

trace(METHOD_NAME, "MSG", "Broadcaster element attribute set to \"" + id + "\".");
trace(METHOD_NAME, "END" );
}

//--------------------------------------------------------------------
// ElementList::idlistSelectNode()
//--------------------------------------------------------------------
// expects the idlist node

ElementList.prototype.idlistSelectNode = function(newnode) {
const METHOD_NAME = "ElementList::idlistSelectNode";
trace(METHOD_NAME, "BEGIN" );

	/* // check for index/node
		if (typeof newnode != "number") { newnode = this.getIDIndexFromNode(newnode) }
		// get the idlist node specified by the newnode index
		var n;
		n = this.getIDListItem(this.activeNodeIDIndex); // get currently active id list node

		n.removeAttribute(ACTIVE_ATTRNAME); // make non-active
		try {
			document.getElementById(n.getAttribute("value")).removeAttribute(ACTIVE_ATTRNAME);
			document.getElementById(NAMESPACE + "treeid-"+n.getAttribute("value")).removeAttribute("selected");
		} catch(e) { }

		n = this.getIDListItem(newnode);
		n.setAttribute(ACTIVE_ATTRNAME,"true");
		this.activeNodeIDIndex = newnode;
	  this.activeNode = document.getElementById(n.getAttribute("value"));
	  this.activeNode.setAttribute(ACTIVE_ATTRNAME,"true");

    document.getElementById(NAMESPACE + "treeid-"+n.getAttribute("value")).setAttribute("selected","true");

	  this.theAttributeInspector.update();
	*/

  var idn = this.getIDListFromNode(this.activeNode);
	idn.removeAttribute(ACTIVE_ATTRNAME); // make non-active
  newnode.setAttribute(ACTIVE_ATTRNAME,"true");

trace(METHOD_NAME, "END" );
}
//--------------------------------------------------------------------
// ElementList::getIDListItem()
//--------------------------------------------------------------------
// returns the ID List Node that the specified index refers to
ElementList.prototype.getIDListItem = function(i) {
	var idlist = document.getElementById(NAMESPACE + "idlist").firstChild;
	var n = idlist.childNodes.item(i).firstChild;
	return n;
}

//--------------------------------------------------------------------
// ElementList::getIDIndexFromNode()
//--------------------------------------------------------------------
// get the index of the IDList of this node
ElementList.prototype.getIDIndexFromNode = function(node) {
	var idlist = getNodesIDList(documentToNodeList(document));
	for (i=0; i < idlist.length; i++) {
		if (idlist[i] == node.getAttribute("id")) {
			return i;
		}
	}
	return null;
}

//--------------------------------------------------------------------
// ElementList::getIDListFromNode()
//--------------------------------------------------------------------
// given a document node (in the design document), return the corresponding idlist node

ElementList.prototype.getIDListFromNode = function(node) {
	return document.getElementById(NAMESPACE + "idlist-"+node.getAttribute("id"));
}

/***********************************************************************
if(TRACE_LOADING){ alert("Continuing loading: xmElementExplorer.js"); }
***********************************************************************/
if(TRACE_LOADING){ alert("Finish loading: xmElementExplorer.js"); }

