/****************************************************************************
** $Id:  qt/richtext.cpp   3.0.3   edited Oct 22 13:56 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**limitation.
*****************************************************************************/

#include "richtext.h"

#include <qhbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qtextview.h>
#include <qbrush.h>
#include <qapplication.h>

static const char* sayings[] = {
    "<b>Introduction:</b><br>"
    "<hr><br>"
   "A simple model of demographic process for a spatial area in this case <br>"
   "for Gemany (You can change the inputfile 'demo.csv' which is part of the<br>"
   "model). You can simulate the total population size and agestructure for<br>"
   "a long period up to 100 years.<br>"
   "The whole population is divided into 100 classes, which corresponds<br>"
   "with the age  of the individuals.<br>"
   "Like in real life, I have divided the population into males and females.<br> <br>"
   "<b>Model inputs</b> are:<br>"
   "the <b>birth rate</b>,<br>"
   "the <b>immigration</b> that means the people who come in the area,<br>"
   "the <b>emigration</b> that means the people who leave the area<br>"
   "<b>the simulation time</b><br><br>"
   "The <b>Model outputs</b> are the total of males and females in the area and the <br>"
   "structure of the population divided into males and females as graph<br>"
    ,

    "<b>Iteration cycle:</b><br>"
    "<hr><br>"
    "One iteration step simulates one year. In this year people were born,<br>"
    "people died, people came into the area ore left it.<br>"
    "To look a bit closer at the steps for one year:<br><br>"
    "Fist a lot of children will be born. It depends on the total number of <br>"
    "females with an age  between [15..45] and the birthrate.<br>"
    "Second some people will die in one year. It depends on the deathrate and the age<br>"
    "of the people: m[i]*=(1.0-sm[i]) for males and f[i]*=(1.0-sf[i]) for females.<br>"
    "The sm[i] or sf[i] means the deathrate for males or females<br>"
    "Of course some people will immigrate into the area or leave it: <br>"
    "m[i]+=migm[i] for males or f[i]+=migf[i] for females<br>"
    "The migx[i] means the total number of (males/females) who come in or leave<br>"
    "the area. At last everybody will be one year older, that means: <br>"
    " m[i]=m[i-1] for males and f[i]=f[i-1] for females. <br>"
    ,

    "<b>Migration:</b><br>"
    "<hr><br>"
     "Migration is a difficult process. In general, the age structure and gender<br>"
    "of emigrating people is different from those of immigrating people.<br>"
    "The input file: demo.csv contains the columns immigration_female, <br>"
    "immigration_male, emigration_female and emigration_male<br>"
    "For a real simulation you should adapt these parameters to your conditions.<br>"
    "The four columns stands for a weighted rate. That means<br>"
    "for example that the migration_f[i]=inp*rate_f[i]/sum(rate_f[i]+rate_m[i])<br>"
    "The migrations_f[i] stands for the females of age i that comes in or leave<br>"
    "the area. The inp are the total of immigration/emigration. <br>"
    "The rate_f[i] corresponds with the column  [immigration|emigration]_f<br>"
    "The sum in the equation means the total of the<br>"
    "sum of rate_f+rate_m.<br><br>"
     ,
    
       
    "<b>Buttons</b><br>"
    "<hr><br>"
    "<b>step:</b> calculates one step (1..n)-years<br>"
    "<b>reset:</b> reloads the initial state<br>"
    "<b>save:</b> writes the actual year males females in the file 'simulation.dat'<br>"
    "<b>help:</b> writes this helptext.<br>"
    "<b>quit:</b> terminates the progam<br>"
    ,
    
     "<b>In- outputs</b><br>"
    "<hr><br>"
    "<b>birthrate</b> should be between [0.1..9.9], for Germany about 1.3<br>"
    "<b>emigration:</b> total number of people who leave the area in one year.<br>"
    "<b>immigration:</b> total number of people who come into this area in one year.<br>"
    "<b>simulation time:</b> number of years for one simulation step.<br><br>"
    "<b>total males/females:</b> calculated for the actual year<br>"
    "The graphic output should be quite clear but the width is<br>"
    "related to maximum width in one year! That can be a bit confusing,<br>"
    "but I couldn't come up with a better idea :-( . The numbers at the bottom of<br>"
    "the graph shows the maximum values of males/females of all ages<br>"
    
    ,
    
    "<b>Structure of the input file 'demo.csv'</b><br>"
    "<hr><br>"
    "The input file consits of 9 columns:<br><br>"
    "<b>year:</b> the age between [0..99]<br>"
    "<b>females:</b> the number of females of this age<br>"
    "<b>males:</b>the number of males of this age<br>"
    "This information is extracted from a newspaper and for this<br>"
    "reason not very accurate<br>"
    "<b>deathrate_females</b> <br>"
    "<b>deathrate_males</b><br>"
    "The deathrate is from Germany and must be adapted for other countries.<br>" 
    "The file is organized as a comma separated value file with one headline.<br>"
    "<b>immigration_f, immigration_m</b><br>"
    "<b>emigration_f, emigration_m </b> are weighted rates to determine <br>"
    "the gender and the age structure of migration<br>"
    ,
    
    "<b> Copyright :</b><br>"
    "<hr><br>"
    "This Program is licensed unter the GPL:<br>"
    "You should have received a copy of the GNU Library General Public<br>"
    "License along with this program; if not, write to the<br>"
    "Free Software Foundation, Inc., 59 Temple Place - Suite 330,<br>"
    "Boston, MA  02111-1307  USA.<br>"
    ,	
   
      0
};


MyRichText::MyRichText( QWidget *parent, const char *name )
    : QVBox( parent, name )
{
    setMargin( 5 );

    view = new QTextView( this );
    view->setText( "This is a <b>Test</b> with <i>italic</i> <u>stuff</u>" );
    QBrush paper;
    view->setPaper( white );

    view->setText( sayings[0] );
    view->setMinimumSize( 450, 250 );

    QHBox *buttons = new QHBox( this );
    buttons->setMargin( 5 );

    bClose = new QPushButton( "&Close", buttons );
    bPrev = new QPushButton( "<< &Prev", buttons );
    bNext = new QPushButton( "&Next >>", buttons );

    bPrev->setEnabled( FALSE );

    connect( bClose, SIGNAL( clicked() ), this, SLOT( close() ) );
    connect( bPrev, SIGNAL( clicked() ), this, SLOT( prev() ) );
    connect( bNext, SIGNAL( clicked() ), this, SLOT( next() ) );

    num = 0;
}

void MyRichText::prev()
{
    if ( num <= 0 )
        return;

    num--;

    view->setText( sayings[num] );

    if ( num == 0 )
        bPrev->setEnabled( FALSE );

    bNext->setEnabled( TRUE );
}

void MyRichText::next()
{
    if ( !sayings[++num] )
        return;

    view->setText( sayings[num] );

    if ( !sayings[num + 1] )
        bNext->setEnabled( FALSE );

    bPrev->setEnabled( TRUE );
}
