/*
   io-avr.h

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef _IO_AVR_H_
#define _IO_AVR_H_ 1

#if defined (__AVR_AT94K__)
#  include <ioat94k.h>
#elif defined (__AVR_ATmega103__)
#  include <iom103.h>
#elif defined (__AVR_ATmega128__)
#  include <iom128.h>
#elif defined (__AVR_ATmega603__)
#  include <iom603.h>
#elif defined (__AVR_ATmega32__)
#  include <iom32.h>
#elif defined (__AVR_ATmega163__)
#  include <iom163.h>
#elif defined (__AVR_ATmega161__)
#  include <iom161.h>
#elif defined (__AVR_ATmega85__)
#  include <iom85.h>  /* XXX not here yet */
#elif defined (__AVR_ATmega83__)
#  include <iom83.h>
#elif defined (__AVR_ATmega8__)
#  include <iom8.h>
#elif defined (__AVR_AT90S8535__)
#  include <io8535.h>
#elif defined (__AVR_AT90C8534__)
#  include <io8534.h>
#elif defined (__AVR_AT90S8515__)
#  include <io8515.h>
#elif defined (__AVR_AT90S4434__)
#  include <io4434.h>
#elif defined (__AVR_AT90S4433__)
#  include <io4433.h>
#elif defined (__AVR_AT90S4414__)
#  include <io4414.h>
#elif defined (__AVR_ATtiny22__)
#  include <iotn22.h>
#elif defined (__AVR_AT90S2343__)
#  include <io2343.h>
#elif defined (__AVR_AT90S2333__)
#  include <io2333.h>
#elif defined (__AVR_AT90S2323__)
#  include <io2323.h>
#elif defined (__AVR_AT90S2313__)
#  include <io2313.h>
 /* the following only supported for assembler programs */
#elif defined (__AVR_ATtiny28__)
#  include <iotn28.h>
#elif defined (__AVR_AT90S1200__)
#  include <io1200.h>
#elif defined (__AVR_ATtiny15__)
#  include <iotn15.h>
#elif defined (__AVR_ATtiny12__)
#  include <iotn12.h>
#elif defined (__AVR_ATtiny11__)
#  include <iotn11.h>
#else
#  warning "device type not defined"
/* #  include <io8515.h> */
#endif

#endif
