/*
   pgmspace.h

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
   pgmspace.h - this is an attempt to provide some compatibility with
   header files that come with IAR C, to make porting applications
   between different compilers easier.  No 100% compatibility though
   (GCC does not have full support for multiple address spaces yet).
 */

#ifndef __PGMSPACE_H_
#define __PGMSPACE_H_ 1

#define __need_size_t
#include <stddef.h>

/* #include <io.h> */

#ifndef __ATTR_CONST__
#define __ATTR_CONST__ __attribute__((__const__))
#endif

#ifndef __ATTR_PROGMEM__
#define __ATTR_PROGMEM__ __attribute__((__progmem__))
#endif

#ifndef __ATTR_PURE__
#define __ATTR_PURE__ __attribute__((__pure__))
#endif

#define PROGMEM __ATTR_PROGMEM__

#ifdef __cplusplus
extern "C" {
#endif

typedef void prog_void PROGMEM;
typedef char prog_char PROGMEM;
typedef unsigned char prog_uchar PROGMEM;
typedef int prog_int PROGMEM;
typedef long prog_long PROGMEM;
typedef long long prog_long_long PROGMEM;

#define PSTR(s) ({static char __c[] PROGMEM = (s); __c;})

/* _LPM(), _ELPM() */
#include <ina90.h>

static inline unsigned char __lpm_inline(unsigned short __addr) __ATTR_CONST__;
static inline unsigned char __lpm_inline(unsigned short __addr)
{
	return _LPM(__addr);
}

#ifdef RAMPZ  /* >64K program memory (ATmega103) */
/*
   use this for access to >64K program memory (ATmega103),
   addr = RAMPZ:r31:r30 (if possible, put your constant tables in the
   lower 64K and use "lpm" - it is more efficient that way, and you can
   still use the upper 64K for executable code).
 */

static inline unsigned char __elpm_inline(unsigned long __addr) __ATTR_CONST__;
static inline unsigned char __elpm_inline(unsigned long __addr)
{
	return _ELPM(__addr);
}
#endif

#if 0
#define PRG_RDB(addr) __lpm_inline((unsigned short)(addr))
#else
#define PRG_RDB(addr) _LPM((unsigned short)(addr))
#endif

#ifndef PGM_P
#define PGM_P const prog_char *
#endif

#ifndef PGM_VOID_P
#define PGM_VOID_P const prog_void *
#endif

extern void *memcpy_P(void *, PGM_VOID_P, size_t);
extern char *strcat_P(char *, PGM_P);
extern int strcmp_P(const char *, PGM_P) __ATTR_PURE__;
extern char *strcpy_P(char *, PGM_P);
extern int strcasecmp_P(const char *, PGM_P) __ATTR_PURE__;
extern size_t strlen_P(PGM_P) __ATTR_CONST__; /* program memory can't change */
extern int strncmp_P(const char *, PGM_P, size_t) __ATTR_PURE__;
extern int strncasecmp_P(const char *, PGM_P) __ATTR_PURE__;
extern char *strncpy_P(char *, PGM_P, size_t);

#if 0  /* not implemented yet */
extern int printf_P(PGM_P, ...);
extern int puts_P(PGM_P);
extern int scanf_P(PGM_P, ...);
extern int sprintf_P(char *, PGM_P, ...);
extern int sscanf_P(const char *, PGM_P, ...);
extern PGM_P strerror_P(int);
#endif

#ifdef __cplusplus
}
#endif

#endif /* __PGMSPACE_H_ */

