/*
   strstr.S
   Search string contained in a string

   Contributors:
     Created by Jochen Pernsteiner <jochen.pernsteiner@stud.fh-regensburg.de>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "macros.inc"

#define s1_hi r25
#define s1_lo r24
#define s2_hi r23
#define s2_lo r22
#define tmp r21
#define ret_hi r25
#define ret_lo r24

;char *strstr(const char *s1, const char *s2)

.text
.global _U(strstr)
.type _U(strstr), @function
_U(strstr):
        LOAD_X(s1_lo, s1_hi)
        LOAD_Z(s2_lo, s2_hi)
        ld tmp, Z+
        tst tmp
        breq .strstr_ret
        clr ret_lo
        clr ret_hi
.strstr_loop:
        ld __tmp_reg__, X+
        tst __tmp_reg__
        breq .strstr_ret0
        cp __tmp_reg__, tmp
        brne .strstr_loop
        adiw ret_lo, 1
        ld tmp, Z+
        tst tmp
        brne .strstr_loop
        sub XL, ret_lo
        sbc XH, ret_hi
        mov ret_lo, XL
        mov ret_hi, XH
        ret
.strstr_ret0:
        clr ret_lo
        clr ret_hi
.strstr_ret:
        ret

.strstr_end:
.size _U(strstr), .strstr_end - _U(strstr)

