/* Top header file for the HP-67 emulator. Defines enumerated types,
 * typedefs, and global variables. */


#ifndef HP67_H
#define HP67_H

#include "config.h"

#include <float.h>

#ifndef CHKMEM
#define CHKMEM(x) do { if ((x) == NULL) { fprintf(stderr, "Memory allocation failure. Aborting.\n"); abort(); } } while (0)
#endif  /* !CHKMEM */

#ifndef TRUE
#define TRUE 1
#endif  /* !TRUE */

#ifndef FALSE
#define FALSE 0
#endif  /* !FALSE */


/* The output display mode. Fixed mode, scientific notation,
 * engineering notation, or hexadecimal */
enum disp_mode { FIX = 0, SCI, ENG, HEX };


/* Angle input modes */
enum ang_mode { DEG = 0, RAD, GRD };



/* The current running mode of the program. */
enum run_mode { IMMED = 0, RUN_PROG, ENTER_PROG, STEPPING };

/* Special actions which might be taken following the execution of a
 * program step */
enum sp_acts { NONE = 0, SKIP_NEXT, TAKE_A_STEP, ERROR, EXECUTE_NOW,
	       GET_DISK_INPUT, WRITE_PROGRAM, WRITE_MEMORY };

/* Key values which are not real key values */
enum more_codes { UNINITIALIZED = -1, VALUE = -2, NO_SUCH_KEY = -3 };

/* Outcome of an attempt at parsing an input line for a numeric value */
enum parse_codes { PARSE_OK = 0, PARSE_BAD };

/* Input method return code indicating that the buffer contains valid
 * text, or the person asked for a scroll up or down of the program
 * buffer. */
enum input_codes { TEXTINPUT = 0, NEXTLINE, PREVLINE, LINETOOLONG, 
		     ENDOFINPUT, DELETELINE, STEPSHORTCUT, REDRAW };

enum outcomes { SUCCESS = 0, FAILURE };


#define COMMENT '#'   /* Character at beginning of comments in input stream */

#define ESC '\e'     /* ESCape character */
#define WHITESPACE " \t"   /* Separates tokens */
#define BLANK ' '    /* Blank character */

#define HEXPREFIX "0x"   /* Prepend on hexadecimal output */

#define META 0x80    /* Add to a regular ASCII character to make a META character */

#define INDIRECT "(i)"   /* When this appears as a label, it means that the value of the I register should be used */

#define I_REGISTER memories[INDIRECT]


#define CLRONTESTSUFFIX " clr"   /* This, after a directive to set a flag, tells the program that the flag will be cleared on a test */

#ifdef STRICT_STATS
#define CLRONLYPRIMARY "primary"  /* This, after a directive to erase memory, tells the program to clear only the primary registers */
#endif  /* STRICT_STATS */

#define MAXDIGS DBL_DIG

#define HASH_RECENT 25   // Maximum number of recently-accessed memory elements which will be held

typedef char intstring[20];   /* Big enough to hold any integer */


#ifdef STRICT_STATS
#define STATS_SUMX        "14"
#define STATS_SUMX2       "15"
#define STATS_SUMY        "16"
#define STATS_SUMY2       "17"
#define STATS_SUMXY       "18"
#define STATS_NPTS        "19"
#else
#define STATS_SUMX        "_stats_sumx"
#define STATS_SUMX2       "_stats_sumx2"
#define STATS_SUMY        "_stats_sumy"
#define STATS_SUMY2       "_stats_sumy2"
#define STATS_SUMXY       "_stats_sumxy"
#define STATS_NPTS        "_stats_n"
#endif


#define LABELSTR "label"  /* This indicates that something is a label */
#define RUNSTR   "run"    /* The string which begins a running program */
#define ENTERSTR "ENTER"  /* The string for the ENTER key */
#define IMMEDMODE "immed" /* The string to enter immediate mode */
#define RUNSTOPSTR "R/S"  /* The string for run/stop */
#define CLEARXSTR "clx"
#define STORESTR "sto"    /* The string for storing to memory */
#define STOREINDIRECTSTR "sti"  /* The string for storing in (i) */
#define STEPSTR "step"


#define PRELOADENVVAR "HP67PROGRAM"   /* Environment variable which
				       * points to a file holding the
				       * preload program. */
#define HOMEENVVAR "HOME"             /* The environment variable
				       * which gives the name of the
				       * home directory of the
				       * user. */
#define RCFILENAME ".hp67rc"          /* The name of the .rc file */


#include "hp_prots.h"


#endif  /* !HP67_H */
