#ifndef HPGLOBALS_H
#define HPGLOBALS_H

#ifndef EXTERN
#ifndef NOEXTERN
#define EXTERN extern
#else
#define EXTERN 
#endif  /* !NOEXTERN */
#endif  /* !EXTERN */

#include "progmem.h"
#include "calcfloat.h"
#include "memory.h"
#include "hp_prots.h"


#ifdef NOEXTERN
KeyType *allkeys[] = { 
  new KeyType("+", 0, 1, 1, NULL, NULL, hp_add),
  new KeyType("-", 0, 1, 1, NULL, NULL, hp_subtract),
  new KeyType("*", 0, 1, 1, NULL, NULL, hp_multiply),
  new KeyType("/", 0, 1, 1, NULL, NULL, hp_divide),
  new KeyType("!", 0, 1, 1, NULL, NULL, hp_factorial),
  new KeyType("recip", 0, 1, 1, NULL, NULL, hp_recip),
  new KeyType("chs", 0, 1, 1, NULL, NULL, hp_chgsgn),
  new KeyType("sin", 0, 1, 1, NULL, NULL, hp_sin),
  new KeyType("cos", 0, 1, 1, NULL, NULL, hp_cos),
  new KeyType("tan", 0, 1, 1, NULL, NULL, hp_tan),
  new KeyType("asin", 0, 1, 1, NULL, NULL, hp_arcsin),
  new KeyType("acos", 0, 1, 1, NULL, NULL, hp_arccos),
  new KeyType("atan", 0, 1, 1, NULL, NULL, hp_arctan),
  new KeyType("sqrt", 0, 1, 1, NULL, NULL, hp_sqrt),
  new KeyType("square", 0, 1, 1, NULL, NULL, hp_square),
  new KeyType("ln", 0, 1, 1, NULL, NULL, hp_log_e),
  new KeyType("exp", 0, 1, 1, NULL, NULL, hp_exp_e),
  new KeyType("log10", 0, 1, 1, NULL, NULL, hp_log_10),
  new KeyType("exp10", 0, 1, 1, NULL, NULL, hp_exp_10),
  new KeyType("y^x", 0, 1, 1, NULL, NULL, hp_power),
  new KeyType("abs", 0, 1, 1, NULL, NULL, hp_abs),
  new KeyType("dsp", 1, 1, 1, NULL, NULL, hp_dispn),
  new KeyType("fix", 0, 1, 1, NULL, NULL, hp_fix),
  new KeyType("sci", 0, 1, 1, NULL, NULL, hp_sci),
  new KeyType("eng", 0, 1, 1, NULL, NULL, hp_eng),
  new KeyType("hex", 0, 1, 1, NULL, NULL, hp_hexmode),
  new KeyType("deg", 0, 1, 1, NULL, NULL, hp_deg),
  new KeyType("rad", 0, 1, 1, NULL, NULL, hp_rad),
  new KeyType("grad", 0, 1, 1, NULL, NULL, hp_grad),
  new KeyType(STORESTR, 1, 1, 1, NULL, NULL, hp_store),
  new KeyType("rcl", 1, 1, 1, NULL, NULL, hp_recall),
  new KeyType("sto+", 1, 1, 1, NULL, NULL, hp_store_plus),
  new KeyType("sto-", 1, 1, 1, NULL, NULL, hp_store_minus),
  new KeyType("sto*", 1, 1, 1, NULL, NULL, hp_store_times),
  new KeyType("sto/", 1, 1, 1, NULL, NULL, hp_store_divide),
  new KeyType("x<>y", 0, 1, 1, NULL, NULL, hp_x_int_y),
  new KeyType("r>p", 0, 1, 1, NULL, NULL, hp_rec2polar),
  new KeyType("p>r", 0, 1, 1, NULL, NULL, hp_polar2rec),
  new KeyType("d>r", 0, 1, 1, NULL, NULL, hp_deg2rad),
  new KeyType("r>d", 0, 1, 1, NULL, NULL, hp_rad2deg),
  new KeyType("pi", 0, 1, 1, NULL, NULL, hp_pival),
  new KeyType("h>hms", 0, 1, 1, NULL, NULL, hp_h2hms),
  new KeyType("hms>h", 0, 1, 1, NULL, NULL, hp_hms2h),
  new KeyType("hms+", 0, 1, 1, NULL, NULL, hp_hmsplus),
  new KeyType("int", 0, 1, 1, NULL, NULL, hp_intpart),
  new KeyType("frac", 0, 1, 1, NULL, NULL, hp_fracpart),
  new KeyType("round", 0, 1, 1, NULL, NULL, hp_round),
  new KeyType("rci", 0, 1, 1, NULL, NULL, hp_recall_i),
  new KeyType(STOREINDIRECTSTR, 0, 1, 1, NULL, NULL, hp_store_i),
  new KeyType("dsz", 0, 1, 1, NULL, NULL, hp_dsz),
  new KeyType("dsz(i)", 0, 1, 1, NULL, NULL, hp_dsz_indirect),
  new KeyType("isz", 0, 1, 1, NULL, NULL, hp_isz),
  new KeyType("isz(i)", 0, 1, 1, NULL, NULL, hp_isz_indirect),
  new KeyType("x<>i", 0, 1, 1, NULL, NULL, hp_x_int_i),
  new KeyType("stat+", 0, 1, 1, NULL, NULL, hp_addstats),
  new KeyType("stat-", 0, 1, 1, NULL, NULL, hp_subtractstats),
  new KeyType("avg", 0, 1, 1, NULL, NULL, hp_average),
  new KeyType("sdev", 0, 1, 1, NULL, NULL, hp_sdev),
  new KeyType("%", 0, 1, 1, NULL, NULL, hp_percent),
  new KeyType("%chg", 0, 1, 1, NULL, NULL, hp_pctchange),
#ifdef STRICT_STATS
  new KeyType("p<>s", 0, 1, 1, NULL, NULL, hp_exchg_p_s),
#endif  /* STRICT_STATS */
  new KeyType(CLEARXSTR, 0, 1, 1, NULL, NULL, hp_clearx),
  new KeyType("rdown", 0, 1, 1, NULL, NULL, hp_rolldown),
  new KeyType("rup", 0, 1, 1, NULL, NULL, hp_rollup),
  new KeyType("lastx", 0, 1, 1, NULL, NULL, hp_lastx),
  new KeyType("clstk", 0, 1, 1, NULL, NULL, hp_clrstack),
  new KeyType("clreg", 0, 1, 1, NULL, NULL, hp_clrreg),
  new KeyType("clprg", 0, 0, 1, parse_arg_immed_or_clprg, NULL, hp_clrpmem),
  new KeyType(ENTERSTR, 0, 1, 1, NULL, NULL, hp_enter),
  new KeyType("goto", 1, 1, 1, parse_arg_goto, NULL, hp_goto),
  new KeyType(RUNSTR, 1, 1, 0, parse_arg_run, NULL, hp_run),
  new KeyType(RUNSTOPSTR, 0, 1, 1, NULL, NULL, hp_runstop),
  new KeyType("prog", 0, 1, 0, NULL, NULL, hp_prog_mode),
  new KeyType(STEPSTR, 0, 1, 0, NULL, NULL, hp_step),
  new KeyType(LABELSTR, 1, 0, 1, NULL, NULL, hp_label),
  new KeyType("gosub", 1, 0, 1, NULL, NULL, hp_gosub),
  new KeyType("rtn", 0, 0, 1, NULL, NULL, hp_return),
  new KeyType("x!=0", 0, 0, 1, NULL, NULL, hp_x_not_zero),
  new KeyType("x==0", 0, 0, 1, NULL, NULL, hp_x_is_zero),
  new KeyType("x<0", 0, 0, 1, NULL, NULL, hp_x_lt_zero),
  new KeyType("x>0", 0, 0, 1, NULL, NULL, hp_x_gt_zero),
  new KeyType("x==y", 0, 0, 1, NULL, NULL, hp_x_eq_y),
  new KeyType("x!=y", 0, 0, 1, NULL, NULL, hp_x_neq_y),
  new KeyType("x<=y", 0, 0, 1, NULL, NULL, hp_x_leq_y),
  new KeyType("x>y", 0, 0, 1, NULL, NULL, hp_x_gt_y),
  new KeyType("sf", 1, 1, 1, NULL, NULL, hp_setflag),
  new KeyType("cf", 1, 1, 1, NULL, NULL, hp_clrflag),
  new KeyType("f?", 1, 0, 1, NULL, NULL, hp_testflag),
  new KeyType(IMMEDMODE, 0, 0, 1, parse_arg_immed_or_clprg, NULL, hp_immed_mode),
  new KeyType("r/prog", 1, 1, 0, parse_arg_loadsave, NULL, hp_diskinput),
  new KeyType("w/prog", 1, 1, 0, parse_arg_loadsave, NULL, hp_diskoutput),
  new KeyType("w/data", 1, 1, 0, parse_arg_loadsave, NULL, hp_dataoutput)
};

#else  /* !NOEXTERN */
extern KeyType *allkeys[];
#endif /* !NOEXTERN */

EXTERN KeyInfo *keycaps;   /* The names and qualities of the keys will be kept here */

EXTERN run_mode runmode;

EXTERN int dispdigs;

EXTERN disp_mode dispmode;

EXTERN ang_mode angmode;

#define NUMSCRATCHSPACES 10
EXTERN Arithdatatype *scratchspace[NUMSCRATCHSPACES];
EXTERN Arithdatatype *angscratch;

EXTERN ProgramSpace program;

EXTERN HashTable<CalcFloat> memories;

EXTERN FILE *inputstream, *outputstream;


/* Command line option variables */
EXTERN int noexit;   /* If TRUE, no keypress will cause the program to
		      * exit, it has to be killed by a signal. */
EXTERN char *preload  ;/* If non-NULL, then this points to the
			* filename of a calculator program file to
			* load at startup. */
EXTERN int ignorerc; /* If TRUE, don't read in the .hp67rc file, or
		      * the file in the HP67PROGRAM environment
		      * variable. */


#endif  /* !HPGLOBALS_H */
