/****************************************************************************
** $Id: qprogbar.h,v 2.6 1997/09/18 17:58:05 hanord Exp $
**
** Definition of QProgressBar class
**
** Created : 970520
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QPROGBAR_H
#define QPROGBAR_H

#include "qframe.h"


class QProgressBar : public QFrame
{
    Q_OBJECT
public:
    QProgressBar( QWidget *parent=0, const char *name=0, WFlags f=0 );
    QProgressBar( int totalSteps, QWidget *parent=0, const char *name=0,
		  WFlags f=0 );

    int		totalSteps() const;
    int		progress()   const;

    QSize	sizeHint() const;
    void	show();

public slots:
    void	reset();
    void	setTotalSteps( int totalSteps );
    void	setProgress( int progress );

protected:
    void	drawContents( QPainter * );
    virtual bool setIndicator( QString& progress_str, int progress,
			       int totalSteps );

private:
    int		total_steps;
    int		progress_val;
    int		percentage;
    QString	progress_str;

private:	// Disabled copy constructor and operator=
    QProgressBar( const QProgressBar & ) {}
    QProgressBar &operator=( const QProgressBar & ) { return *this; }
};


inline int QProgressBar::totalSteps() const
{
    return total_steps;
}

inline int QProgressBar::progress() const
{
    return progress_val;
}


#endif // QPROGBAR_H
