#include <qlabel.h>

#include "LabelPage.h"

#include "widget/DlgWidget.h"

#define Inherited LabelPageData

LabelPage::LabelPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QLabel* label = (QLabel*)widget->GetWidget();
    
    itsText->setText( label->text() );

    switch( label->alignment() & (AlignLeft | AlignHCenter | AlignRight) )
    {
	case AlignLeft:
	default:
	{
	    isHorizLeft->setChecked( TRUE );
	    break;
	}
	case AlignHCenter:
	{
	    isHorizCenter->setChecked( TRUE );
	    break;
	}
	case AlignRight:
	{
	    isHorizRight->setChecked( TRUE );
	    break;
	}
    }
    
    switch( label->alignment() & (AlignTop | AlignVCenter | AlignBottom) )
    {
	case AlignTop:
	{
	    isVertTop->setChecked( TRUE );
	    break;
	}
	case AlignVCenter:
	default:
	{
	    isVertCenter->setChecked( TRUE );
	    break;
	}
	case AlignBottom:
	{
	    isVertBottom->setChecked( TRUE );
	    break;
	}
    }
    
    isExpandTabs->setChecked( label->alignment() & ExpandTabs );
    isAutoBreak->setChecked( label->alignment() & WordBreak );
    isAutoResize->setChecked( label->autoResize() );

    QString str;
    itsMargin->setText( str.setNum(label->margin()) );
}


LabelPage::~LabelPage()
{
}


void LabelPage::Apply( DlgWidget*	widget )
{
    QLabel* label = (QLabel*)widget->GetWidget();
    
    label->setText( itsText->text() );
    
    int alignment = 0;
    
    if( isHorizCenter->isChecked() ) 
    {
	alignment |= AlignHCenter;
    }
    else if( isHorizRight->isChecked() )
    {
	alignment |= AlignRight;
    }
    else // default to left
    {
	alignment |= AlignLeft;
    }
    
    if( isVertTop->isChecked() )
    {
	alignment |= AlignTop;
    }
    else if( isVertBottom->isChecked() )
    {
	alignment |= AlignBottom;
    }
    else // default to center
    {
	alignment |= AlignVCenter;
    }
    
    if( isExpandTabs->isChecked() )
    {
	alignment |= ExpandTabs;
    }
    
    if( isAutoBreak->isChecked() )
    {
	alignment |= WordBreak;
    }
    
    label->setAlignment( alignment );

    label->setAutoResize( isAutoResize->isChecked() );
    
    QString str = itsMargin->text();
    label->setMargin( str.toInt() );
}

