#include "WidgetColorPage.h"

#include "widget/DlgWidget.h"

#include "prop/ColorSelectDialog.h"
#include "prop/FontSelectDialog.h"

#include "GuiTools.h"

#define Inherited WidgetColorPageData

WidgetColorPage::WidgetColorPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name ),
    itsCurrentGroup( Normal ),
    isCopy( FALSE ),
    areColorsChanged( FALSE ),
    isFontChanged( FALSE )
{
    itsPalette = widget->GetWidget()->palette();

    ChangeColors( itsPalette.normal() );

    itsFont = widget->GetWidget()->font();

    UpdateFontInfo();

    connect( itsColorGroups, SIGNAL(activated(int)), SLOT(GroupChanged(int)) );
    connect( itsForeButton, SIGNAL(clicked()), SLOT(ColorClicked()) );
    connect( itsBackButton, SIGNAL(clicked()), SLOT(ColorClicked()) );
    connect( itsLightButton, SIGNAL(clicked()), SLOT(ColorClicked()) );
    connect( itsDarkButton, SIGNAL(clicked()), SLOT(ColorClicked()) );
    connect( itsMediumButton, SIGNAL(clicked()), SLOT(ColorClicked()) );
    connect( itsTextButton, SIGNAL(clicked()), SLOT(ColorClicked()) );
    connect( itsBaseButton, SIGNAL(clicked()), SLOT(ColorClicked()) );

    connect( itsChooseButton, SIGNAL(clicked()), SLOT(FontClicked()) );
}


WidgetColorPage::~WidgetColorPage()
{
}


void WidgetColorPage::Apply( DlgWidget*	widget )
{
    if( areColorsChanged )
    {
	SaveCurrentGroup();
	widget->GetWidget()->setPalette( itsPalette );
    }

    if( isFontChanged )
    {
	widget->GetWidget()->setFont( itsFont );
    }
}


void WidgetColorPage::FontClicked()
{
    FontSelectDialog dlg( itsFont );
    
    if( dlg.exec() == QDialog::Accepted )
    {
	itsFont = dlg.GetFont();
	UpdateFontInfo();

	isFontChanged = TRUE;
    }
}


void WidgetColorPage::UpdateFontInfo()
{
    itsFamily->setText( itsFont.family() );
    itsSize->setNum( itsFont.pointSize() );
    itsWeight->setText( GuiTools::QFontWeightStr(itsFont.weight()) );
    GuiTools::SetVisible( itsItalic, itsFont.italic() );
    GuiTools::SetVisible( itsUnderline, itsFont.underline() );
    GuiTools::SetVisible( itsStrikeout, itsFont.strikeOut() );
    itsStyleHint->setText( GuiTools::QFontStyleHintStr(itsFont.styleHint()) );
}


void WidgetColorPage::SaveCurrentGroup( void )
{
    if( !isCopy )
    {
	itsPalette = itsPalette.copy();
	isCopy = TRUE;
    }

    QColorGroup group( itsForeButton->backgroundColor(),
		       itsBackButton->backgroundColor(),
		       itsLightButton->backgroundColor(),
		       itsDarkButton->backgroundColor(),
		       itsMediumButton->backgroundColor(),
		       itsTextButton->backgroundColor(),
		       itsBaseButton->backgroundColor() );
    
    switch( itsCurrentGroup )
    {
	case Normal:
	{
	    itsPalette.setNormal( group );
	    break;
	}
	case Disabled:
	{
	    itsPalette.setDisabled( group );
	    break;
	}
	case Active:
	{
	    itsPalette.setActive( group );
	    break;
	}
    }
}


void WidgetColorPage::ColorClicked()
{
    QWidget* widget = (QWidget*)sender();

    ColorSelectDialog dlg( widget->backgroundColor() );

    if( dlg.exec() == QDialog::Accepted )
    {
	areColorsChanged = TRUE;
	ChangeColor( widget, dlg.GetColor() );
    }
}


void WidgetColorPage::GroupChanged( int group )
{
    SaveCurrentGroup();

    switch( group )
    {
	case Normal:
	default:
	{
	    ChangeColors( itsPalette.normal() );
	    break;
	}
	case Disabled:
	{
	    ChangeColors( itsPalette.disabled() );
	    break;
	}
	case Active:
	{
	    ChangeColors( itsPalette.active() );
	    break;
	}
    }

    itsCurrentGroup = group;
}


void WidgetColorPage::ChangeColors( const QColorGroup&	colorGroup )
{
    ChangeColor( itsForeButton, colorGroup.foreground() );
    ChangeColor( itsBackButton, colorGroup.background() );
    ChangeColor( itsLightButton, colorGroup.light() );
    ChangeColor( itsDarkButton, colorGroup.dark() );
    ChangeColor( itsMediumButton, colorGroup.mid() );
    ChangeColor( itsTextButton, colorGroup.text() );
    ChangeColor( itsBaseButton, colorGroup.base() );
}
