#include <qstring.h>
#include <qlist.h>
#include <qstrlist.h>

#include "WidgetPropDialog.h"

#include "prop/WidgetVarMapPage.h"
#include "prop/WidgetCommonPage.h"
#include "prop/WidgetLayoutPage.h"
#include "prop/WidgetColorPage.h"

#define Inherited WidgetPropDialogData

WidgetPropDialog::WidgetPropDialog
(
    DlgWidget* widget,
    BoxLayout* layout,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name ),
    itsDlgWidget( widget ),
    itsBoxLayout( layout )
{
    QString str = "Widget Properties - ";
    str += widget->GetWidgetName();
    setCaption( str );

    itsVarMapPage = new WidgetVarMapPage( widget, this, "Mapping" );
    itsCommonPage = new WidgetCommonPage( widget, this, "Widget" );
    itsLayoutPage = new WidgetLayoutPage( widget, layout, this, "Layout" );
    itsColorPage = new WidgetColorPage( widget, this, "Color" );    

    addTab( itsVarMapPage, "Mapping" );
    addTab( itsCommonPage, "Widget" );
    addTab( itsLayoutPage, "Layout" );
    addTab( itsColorPage, "Colors & Font" );

    QList<QWidget> pages;
    QStrList labels;
    
    widget->GetPropertyPages( this, pages, labels );

    QListIterator<QWidget> pageIter( pages );
    QStrListIterator labelIter( labels );
    QWidget* page;
    const char* label;
    
    while( (page = pageIter()) )
    {
	label = labelIter();
	
	addTab( page, label );

	page->connect( this, SIGNAL(Apply(DlgWidget*)), 
		       SLOT(Apply(DlgWidget*)) );
    }

    // disable the layout tab if the widget is used as the menu bar of a layout
    if( widget->GetLayoutStatus() == DlgWidget::LayoutMenuBar )
    {
	setTabEnabled( "Layout", FALSE );
    }
    
    setCancelButton();
    setApplyButton();

    connect( this, SIGNAL(applyButtonPressed()), SLOT(Apply()) );
}


WidgetPropDialog::WidgetPropDialog
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name ),
    itsDlgWidget( widget ),
    itsBoxLayout( NULL )
{
    QString str = "Widget Properties - ";
    str += widget->GetWidgetName();
    setCaption( str );

    itsVarMapPage = new WidgetVarMapPage( widget, this );
    itsCommonPage = new WidgetCommonPage( widget, this );
    itsLayoutPage = new WidgetLayoutPage( widget, itsBoxLayout, this );
    itsColorPage = new WidgetColorPage( widget, this );    

    addTab( itsVarMapPage, "Mapping" );
    addTab( itsCommonPage, "Widget" );
    addTab( itsLayoutPage, "Layout" );
    addTab( itsColorPage, "Colors & Font" );

    setCancelButton();
    setApplyButton();

    connect( this, SIGNAL(applyButtonPressed()), SLOT(Apply()) );
}


WidgetPropDialog::~WidgetPropDialog()
{
}


void WidgetPropDialog::Apply()
{
    itsVarMapPage->Apply( itsDlgWidget );
    itsCommonPage->Apply( itsDlgWidget );
    itsLayoutPage->Apply( itsDlgWidget, itsBoxLayout );
    itsColorPage->Apply( itsDlgWidget );

    emit Apply( itsDlgWidget );

    itsDlgWidget->GetWidget()->repaint();
}
